/************************************************************************************
Program Name: SinglePRCCSLoad.do 
Description : Load SinglePRCCS.dta file used to assign Single-Level PRCCS categories from Stata. 
Developed   : By David Ross on 10/26/2009.
Updated     : By Nils Nordstrand on 11/03/2016
************************************************************************************/

local fyear     "2015"
local tool      SinglePRCCS
local prefix    "prref "
local ivar      PR
local ovar      PRCCS

if `"`ivar'"' == "PR" local icd9f icd9p
else local icd9f icd9

* Remove first two lines from file
infix str line 1-200 using "\$`prefix'`fyear'.csv" in 3/L, clear
outfile line using "\$`prefix'`fyear'Stata.csv", noquote replace wide

infile str6    _`ivar'           ///
       str3    `ovar'            ///
       str100  PRCCSDescription  ///
       str100  I9PrDescription   ///
       using "\$`prefix'`fyear'Stata.csv", clear

destring `ovar', replace

`icd9f' clean _`ivar', dots
sort _`ivar'
keep _`ivar' `ovar'
save `tool', replace

