/*****************************************************************************
* Creation Date: 05/31/2024   
* SD_SID_2022_CORE.Do
* This program will load the 2022 SD ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/*** Set available memory size ***/
set mem 500m

/*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***/
infix 3 firstlineoffile                            ///
      int    AGE                          1-   3   ///
      int    AGEDAY                       4-   6   ///
      int    AGEMONTH                     7-   9   ///
      byte   AMONTH                      10-  11   ///
      byte   ATYPE                       12-  13   ///
      byte   AWEEKEND                    14-  15   ///
      int    BWT                         16-  19   ///
      byte   DIED                        20-  21   ///
      str    DISP_X                      22-  25   ///
      byte   DISPUB04                    26-  27   ///
      byte   DISPUNIFORM                 28-  29   ///
      byte   DMONTH                      30-  31   ///
      byte   DQTR                        32-  33   ///
      int    DRG                         34-  36   ///
      int    DRG_NoPOA                   37-  39   ///
      byte   DRGVER                      40-  41   ///
      str    DXPOA1                      42        ///
      str    DXPOA2                      43        ///
      str    DXPOA3                      44        ///
      str    DXPOA4                      45        ///
      str    DXPOA5                      46        ///
      str    DXPOA6                      47        ///
      str    DXPOA7                      48        ///
      str    DXPOA8                      49        ///
      str    DXPOA9                      50        ///
      str    DXPOA10                     51        ///
      str    DXPOA11                     52        ///
      str    DXPOA12                     53        ///
      str    DXPOA13                     54        ///
      str    DXPOA14                     55        ///
      str    DXPOA15                     56        ///
      str    DXPOA16                     57        ///
      str    DXPOA17                     58        ///
      str    DXPOA18                     59        ///
      str    DXPOA19                     60        ///
      str    DXPOA20                     61        ///
      str    DXPOA21                     62        ///
      str    DXPOA22                     63        ///
      str    DXPOA23                     64        ///
      str    DXPOA24                     65        ///
      str    DXPOA25                     66        ///
      str    DXPOA26                     67        ///
      str    DXPOA27                     68        ///
      str    DXPOA28                     69        ///
      str    DXPOA29                     70        ///
      str    DXPOA30                     71        ///
      str    DXPOA31                     72        ///
      str    DXPOA32                     73        ///
      str    DXPOA33                     74        ///
      str    DXPOA34                     75        ///
      str    DXPOA35                     76        ///
      str    DXPOA36                     77        ///
      str    DXPOA37                     78        ///
      str    DXPOA38                     79        ///
      str    DXPOA39                     80        ///
      str    DXPOA40                     81        ///
      str    DXPOA41                     82        ///
      str    DXPOA42                     83        ///
      str    DXPOA43                     84        ///
      str    DXPOA44                     85        ///
      str    DXPOA45                     86        ///
      str    DXPOA46                     87        ///
      str    DXPOA47                     88        ///
      str    DXPOA48                     89        ///
      str    DXPOA49                     90        ///
      str    DXPOA50                     91        ///
      str    DXPOA51                     92        ///
      str    DXPOA52                     93        ///
      str    DXPOA53                     94        ///
      str    DXPOA54                     95        ///
      str    DXPOA55                     96        ///
      str    DXPOA56                     97        ///
      str    DXPOA57                     98        ///
      str    DXPOA58                     99        ///
      str    DXPOA59                    100        ///
      str    DXPOA60                    101        ///
      str    DXPOA61                    102        ///
      str    DXPOA62                    103        ///
      str    DXPOA63                    104        ///
      str    DXPOA64                    105        ///
      str    DXPOA65                    106        ///
      str    DXPOA66                    107        ///
      str    DXPOA67                    108        ///
      str    DXPOA68                    109        ///
      str    DXPOA69                    110        ///
      str    DXPOA70                    111        ///
      str    DXPOA71                    112        ///
      str    DXPOA72                    113        ///
      str    DXPOA73                    114        ///
      str    DXPOA74                    115        ///
      str    DXPOA75                    116        ///
      str    DXPOA76                    117        ///
      str    DXPOA77                    118        ///
      str    DXPOA78                    119        ///
      str    DXPOA79                    120        ///
      str    DXPOA80                    121        ///
      str    DXPOA81                    122        ///
      str    DXPOA82                    123        ///
      byte   FEMALE                     124- 125   ///
      byte   HCUP_ED                    126- 127   ///
      byte   HCUP_OS                    128- 129   ///
      byte   HISPANIC                   130- 131   ///
      str    HISPANIC_X                 132        ///
      byte   HospitalUnit               133- 134   ///
      str    HOSPST                     135- 136   ///
      int    I10_BIRTH                  137- 139   ///
      int    I10_DELIVERY               140- 142   ///
      str    I10_DX_Admitting           143- 149   ///
      str    I10_DX1                    150- 156   ///
      str    I10_DX2                    157- 163   ///
      str    I10_DX3                    164- 170   ///
      str    I10_DX4                    171- 177   ///
      str    I10_DX5                    178- 184   ///
      str    I10_DX6                    185- 191   ///
      str    I10_DX7                    192- 198   ///
      str    I10_DX8                    199- 205   ///
      str    I10_DX9                    206- 212   ///
      str    I10_DX10                   213- 219   ///
      str    I10_DX11                   220- 226   ///
      str    I10_DX12                   227- 233   ///
      str    I10_DX13                   234- 240   ///
      str    I10_DX14                   241- 247   ///
      str    I10_DX15                   248- 254   ///
      str    I10_DX16                   255- 261   ///
      str    I10_DX17                   262- 268   ///
      str    I10_DX18                   269- 275   ///
      str    I10_DX19                   276- 282   ///
      str    I10_DX20                   283- 289   ///
      str    I10_DX21                   290- 296   ///
      str    I10_DX22                   297- 303   ///
      str    I10_DX23                   304- 310   ///
      str    I10_DX24                   311- 317   ///
      str    I10_DX25                   318- 324   ///
      str    I10_DX26                   325- 331   ///
      str    I10_DX27                   332- 338   ///
      str    I10_DX28                   339- 345   ///
      str    I10_DX29                   346- 352   ///
      str    I10_DX30                   353- 359   ///
      str    I10_DX31                   360- 366   ///
      str    I10_DX32                   367- 373   ///
      str    I10_DX33                   374- 380   ///
      str    I10_DX34                   381- 387   ///
      str    I10_DX35                   388- 394   ///
      str    I10_DX36                   395- 401   ///
      str    I10_DX37                   402- 408   ///
      str    I10_DX38                   409- 415   ///
      str    I10_DX39                   416- 422   ///
      str    I10_DX40                   423- 429   ///
      str    I10_DX41                   430- 436   ///
      str    I10_DX42                   437- 443   ///
      str    I10_DX43                   444- 450   ///
      str    I10_DX44                   451- 457   ///
      str    I10_DX45                   458- 464   ///
      str    I10_DX46                   465- 471   ///
      str    I10_DX47                   472- 478   ///
      str    I10_DX48                   479- 485   ///
      str    I10_DX49                   486- 492   ///
      str    I10_DX50                   493- 499   ///
      str    I10_DX51                   500- 506   ///
      str    I10_DX52                   507- 513   ///
      str    I10_DX53                   514- 520   ///
      str    I10_DX54                   521- 527   ///
      str    I10_DX55                   528- 534   ///
      str    I10_DX56                   535- 541   ///
      str    I10_DX57                   542- 548   ///
      str    I10_DX58                   549- 555   ///
      str    I10_DX59                   556- 562   ///
      str    I10_DX60                   563- 569   ///
      str    I10_DX61                   570- 576   ///
      str    I10_DX62                   577- 583   ///
      str    I10_DX63                   584- 590   ///
      str    I10_DX64                   591- 597   ///
      str    I10_DX65                   598- 604   ///
      str    I10_DX66                   605- 611   ///
      str    I10_DX67                   612- 618   ///
      str    I10_DX68                   619- 625   ///
      str    I10_DX69                   626- 632   ///
      str    I10_DX70                   633- 639   ///
      str    I10_DX71                   640- 646   ///
      str    I10_DX72                   647- 653   ///
      str    I10_DX73                   654- 660   ///
      str    I10_DX74                   661- 667   ///
      str    I10_DX75                   668- 674   ///
      str    I10_DX76                   675- 681   ///
      str    I10_DX77                   682- 688   ///
      str    I10_DX78                   689- 695   ///
      str    I10_DX79                   696- 702   ///
      str    I10_DX80                   703- 709   ///
      str    I10_DX81                   710- 716   ///
      str    I10_DX82                   717- 723   ///
      int    I10_NDX                    724- 726   ///
      int    I10_NPR                    727- 729   ///
      str    I10_PR1                    730- 736   ///
      str    I10_PR2                    737- 743   ///
      str    I10_PR3                    744- 750   ///
      str    I10_PR4                    751- 757   ///
      str    I10_PR5                    758- 764   ///
      str    I10_PR6                    765- 771   ///
      str    I10_PR7                    772- 778   ///
      str    I10_PR8                    779- 785   ///
      str    I10_PR9                    786- 792   ///
      str    I10_PR10                   793- 799   ///
      str    I10_PR11                   800- 806   ///
      str    I10_PR12                   807- 813   ///
      str    I10_PR13                   814- 820   ///
      str    I10_PR14                   821- 827   ///
      str    I10_PR15                   828- 834   ///
      str    I10_PR16                   835- 841   ///
      str    I10_PR17                   842- 848   ///
      str    I10_PR18                   849- 855   ///
      str    I10_PR19                   856- 862   ///
      str    I10_PR20                   863- 869   ///
      str    I10_PR21                   870- 876   ///
      str    I10_PR22                   877- 883   ///
      str    I10_PR23                   884- 890   ///
      str    I10_PR24                   891- 897   ///
      str    I10_PR25                   898- 904   ///
      str    I10_PR26                   905- 911   ///
      str    I10_PR27                   912- 918   ///
      str    I10_PR28                   919- 925   ///
      str    I10_PR29                   926- 932   ///
      str    I10_PR30                   933- 939   ///
      str    I10_PR31                   940- 946   ///
      str    I10_PR32                   947- 953   ///
      str    I10_PR33                   954- 960   ///
      str    I10_PR34                   961- 967   ///
      str    I10_PR35                   968- 974   ///
      str    I10_PR36                   975- 981   ///
      str    I10_PR37                   982- 988   ///
      str    I10_PR38                   989- 995   ///
      str    I10_PR39                   996-1002   ///
      str    I10_PR40                  1003-1009   ///
      str    I10_PR41                  1010-1016   ///
      str    I10_PR42                  1017-1023   ///
      str    I10_PR43                  1024-1030   ///
      str    I10_PR44                  1031-1037   ///
      str    I10_PR45                  1038-1044   ///
      int    I10_PROCTYPE              1045-1047   ///
      byte   I10_SERVICELINE           1048-1049   ///
      double KEY                       1050-1064   ///
      long   LOS                       1065-1069   ///
      long   LOS_X                     1070-1075   ///
      byte   MDC                       1076-1077   ///
      byte   MDC_NoPOA                 1078-1079   ///
      long   MDNUM1_R                  1080-1088   ///
      long   MDNUM2_R                  1089-1097   ///
      byte   MEDINCSTQ                 1098-1099   ///
      long   MRN_R                     1100-1108   ///
      str    P7EDSRC_X                 1109-1110   ///
      byte   PAY1                      1111-1112   ///
      byte   PCLASS_ORPROC             1113-1114   ///
      int    PL_CBSA                   1115-1117   ///
      byte   PL_NCHS                   1118-1119   ///
      byte   PL_RUCC                   1120-1121   ///
      byte   PL_UIC                    1122-1123   ///
      byte   PL_UR_CAT4                1124-1125   ///
      byte   POA_Disch_Edit1           1126-1127   ///
      byte   POA_Disch_Edit2           1128-1129   ///
      byte   POA_Hosp_Edit1            1130-1131   ///
      byte   POA_Hosp_Edit2            1132-1133   ///
      byte   POA_Hosp_Edit3            1134-1135   ///
      double POA_Hosp_Edit3_Value      1136-1143   ///
      str    PointOfOrigin_X           1144        ///
      str    PointOfOriginUB04         1145        ///
      long   PRDAY1                    1146-1150   ///
      long   PRDAY2                    1151-1155   ///
      long   PRDAY3                    1156-1160   ///
      long   PRDAY4                    1161-1165   ///
      long   PRDAY5                    1166-1170   ///
      long   PRDAY6                    1171-1175   ///
      long   PRDAY7                    1176-1180   ///
      long   PRDAY8                    1181-1185   ///
      long   PRDAY9                    1186-1190   ///
      long   PRDAY10                   1191-1195   ///
      long   PRDAY11                   1196-1200   ///
      long   PRDAY12                   1201-1205   ///
      long   PRDAY13                   1206-1210   ///
      long   PRDAY14                   1211-1215   ///
      long   PRDAY15                   1216-1220   ///
      long   PRDAY16                   1221-1225   ///
      long   PRDAY17                   1226-1230   ///
      long   PRDAY18                   1231-1235   ///
      long   PRDAY19                   1236-1240   ///
      long   PRDAY20                   1241-1245   ///
      long   PRDAY21                   1246-1250   ///
      long   PRDAY22                   1251-1255   ///
      long   PRDAY23                   1256-1260   ///
      long   PRDAY24                   1261-1265   ///
      long   PRDAY25                   1266-1270   ///
      long   PRDAY26                   1271-1275   ///
      long   PRDAY27                   1276-1280   ///
      long   PRDAY28                   1281-1285   ///
      long   PRDAY29                   1286-1290   ///
      long   PRDAY30                   1291-1295   ///
      long   PRDAY31                   1296-1300   ///
      long   PRDAY32                   1301-1305   ///
      long   PRDAY33                   1306-1310   ///
      long   PRDAY34                   1311-1315   ///
      long   PRDAY35                   1316-1320   ///
      long   PRDAY36                   1321-1325   ///
      long   PRDAY37                   1326-1330   ///
      long   PRDAY38                   1331-1335   ///
      long   PRDAY39                   1336-1340   ///
      long   PRDAY40                   1341-1345   ///
      long   PRDAY41                   1346-1350   ///
      long   PRDAY42                   1351-1355   ///
      long   PRDAY43                   1356-1360   ///
      long   PRDAY44                   1361-1365   ///
      long   PRDAY45                   1366-1370   ///
      str    PSTATE                    1371-1372   ///
      str    PSTATE_GEO                1373-1374   ///
      long   PSTCO                     1375-1379   ///
      long   PSTCO_GEO                 1380-1384   ///
      byte   RACE                      1385-1386   ///
      float  RACE_PCT_MISS_HOSP        1387-1393   ///
      str    RACE_X                    1394        ///
      double TOTCHG                    1395-1404   ///
      double TOTCHG_X                  1405-1419   ///
      byte   TRAN_IN                   1420-1421   ///
      byte   TRAN_OUT                  1422-1423   ///
      int    YEAR                      1424-1427   ///
      str    ZIP                       1428-1432   ///
      str    ZIP3                      1433-1435   ///
      int    ZIPINC_QRTL               1436-1438   ///
      long   HOSPID                    1439-1443   ///
      int    AYEAR                     1444-1447   ///
      byte   BMONTH                    1448-1449   ///
      int    BYEAR                     1450-1453   ///
      byte   PRMONTH1                  1454-1455   ///
      byte   PRMONTH2                  1456-1457   ///
      byte   PRMONTH3                  1458-1459   ///
      byte   PRMONTH4                  1460-1461   ///
      byte   PRMONTH5                  1462-1463   ///
      byte   PRMONTH6                  1464-1465   ///
      byte   PRMONTH7                  1466-1467   ///
      byte   PRMONTH8                  1468-1469   ///
      byte   PRMONTH9                  1470-1471   ///
      byte   PRMONTH10                 1472-1473   ///
      byte   PRMONTH11                 1474-1475   ///
      byte   PRMONTH12                 1476-1477   ///
      byte   PRMONTH13                 1478-1479   ///
      byte   PRMONTH14                 1480-1481   ///
      byte   PRMONTH15                 1482-1483   ///
      byte   PRMONTH16                 1484-1485   ///
      byte   PRMONTH17                 1486-1487   ///
      byte   PRMONTH18                 1488-1489   ///
      byte   PRMONTH19                 1490-1491   ///
      byte   PRMONTH20                 1492-1493   ///
      byte   PRMONTH21                 1494-1495   ///
      byte   PRMONTH22                 1496-1497   ///
      byte   PRMONTH23                 1498-1499   ///
      byte   PRMONTH24                 1500-1501   ///
      byte   PRMONTH25                 1502-1503   ///
      byte   PRMONTH26                 1504-1505   ///
      byte   PRMONTH27                 1506-1507   ///
      byte   PRMONTH28                 1508-1509   ///
      byte   PRMONTH29                 1510-1511   ///
      byte   PRMONTH30                 1512-1513   ///
      byte   PRMONTH31                 1514-1515   ///
      byte   PRMONTH32                 1516-1517   ///
      byte   PRMONTH33                 1518-1519   ///
      byte   PRMONTH34                 1520-1521   ///
      byte   PRMONTH35                 1522-1523   ///
      byte   PRMONTH36                 1524-1525   ///
      byte   PRMONTH37                 1526-1527   ///
      byte   PRMONTH38                 1528-1529   ///
      byte   PRMONTH39                 1530-1531   ///
      byte   PRMONTH40                 1532-1533   ///
      byte   PRMONTH41                 1534-1535   ///
      byte   PRMONTH42                 1536-1537   ///
      byte   PRMONTH43                 1538-1539   ///
      byte   PRMONTH44                 1540-1541   ///
      byte   PRMONTH45                 1542-1543   ///
      int    PRYEAR1                   1544-1547   ///
      int    PRYEAR2                   1548-1551   ///
      int    PRYEAR3                   1552-1555   ///
      int    PRYEAR4                   1556-1559   ///
      int    PRYEAR5                   1560-1563   ///
      int    PRYEAR6                   1564-1567   ///
      int    PRYEAR7                   1568-1571   ///
      int    PRYEAR8                   1572-1575   ///
      int    PRYEAR9                   1576-1579   ///
      int    PRYEAR10                  1580-1583   ///
      int    PRYEAR11                  1584-1587   ///
      int    PRYEAR12                  1588-1591   ///
      int    PRYEAR13                  1592-1595   ///
      int    PRYEAR14                  1596-1599   ///
      int    PRYEAR15                  1600-1603   ///
      int    PRYEAR16                  1604-1607   ///
      int    PRYEAR17                  1608-1611   ///
      int    PRYEAR18                  1612-1615   ///
      int    PRYEAR19                  1616-1619   ///
      int    PRYEAR20                  1620-1623   ///
      int    PRYEAR21                  1624-1627   ///
      int    PRYEAR22                  1628-1631   ///
      int    PRYEAR23                  1632-1635   ///
      int    PRYEAR24                  1636-1639   ///
      int    PRYEAR25                  1640-1643   ///
      int    PRYEAR26                  1644-1647   ///
      int    PRYEAR27                  1648-1651   ///
      int    PRYEAR28                  1652-1655   ///
      int    PRYEAR29                  1656-1659   ///
      int    PRYEAR30                  1660-1663   ///
      int    PRYEAR31                  1664-1667   ///
      int    PRYEAR32                  1668-1671   ///
      int    PRYEAR33                  1672-1675   ///
      int    PRYEAR34                  1676-1679   ///
      int    PRYEAR35                  1680-1683   ///
      int    PRYEAR36                  1684-1687   ///
      int    PRYEAR37                  1688-1691   ///
      int    PRYEAR38                  1692-1695   ///
      int    PRYEAR39                  1696-1699   ///
      int    PRYEAR40                  1700-1703   ///
      int    PRYEAR41                  1704-1707   ///
      int    PRYEAR42                  1708-1711   ///
      int    PRYEAR43                  1712-1715   ///
      int    PRYEAR44                  1716-1719   ///
      int    PRYEAR45                  1720-1723   ///
      using  "SD_SID_2022_CORE.asc"

/***  Assign labels to the data elements ***/
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var BWT                      "Birth weight in grams"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DXPOA1                   "Diagnosis 1, present on admission indicator"
label var DXPOA2                   "Diagnosis 2, present on admission indicator"
label var DXPOA3                   "Diagnosis 3, present on admission indicator"
label var DXPOA4                   "Diagnosis 4, present on admission indicator"
label var DXPOA5                   "Diagnosis 5, present on admission indicator"
label var DXPOA6                   "Diagnosis 6, present on admission indicator"
label var DXPOA7                   "Diagnosis 7, present on admission indicator"
label var DXPOA8                   "Diagnosis 8, present on admission indicator"
label var DXPOA9                   "Diagnosis 9, present on admission indicator"
label var DXPOA10                  "Diagnosis 10, present on admission indicator"
label var DXPOA11                  "Diagnosis 11, present on admission indicator"
label var DXPOA12                  "Diagnosis 12, present on admission indicator"
label var DXPOA13                  "Diagnosis 13, present on admission indicator"
label var DXPOA14                  "Diagnosis 14, present on admission indicator"
label var DXPOA15                  "Diagnosis 15, present on admission indicator"
label var DXPOA16                  "Diagnosis 16, present on admission indicator"
label var DXPOA17                  "Diagnosis 17, present on admission indicator"
label var DXPOA18                  "Diagnosis 18, present on admission indicator"
label var DXPOA19                  "Diagnosis 19, present on admission indicator"
label var DXPOA20                  "Diagnosis 20, present on admission indicator"
label var DXPOA21                  "Diagnosis 21, present on admission indicator"
label var DXPOA22                  "Diagnosis 22, present on admission indicator"
label var DXPOA23                  "Diagnosis 23, present on admission indicator"
label var DXPOA24                  "Diagnosis 24, present on admission indicator"
label var DXPOA25                  "Diagnosis 25, present on admission indicator"
label var DXPOA26                  "Diagnosis 26, present on admission indicator"
label var DXPOA27                  "Diagnosis 27, present on admission indicator"
label var DXPOA28                  "Diagnosis 28, present on admission indicator"
label var DXPOA29                  "Diagnosis 29, present on admission indicator"
label var DXPOA30                  "Diagnosis 30, present on admission indicator"
label var DXPOA31                  "Diagnosis 31, present on admission indicator"
label var DXPOA32                  "Diagnosis 32, present on admission indicator"
label var DXPOA33                  "Diagnosis 33, present on admission indicator"
label var DXPOA34                  "Diagnosis 34, present on admission indicator"
label var DXPOA35                  "Diagnosis 35, present on admission indicator"
label var DXPOA36                  "Diagnosis 36, present on admission indicator"
label var DXPOA37                  "Diagnosis 37, present on admission indicator"
label var DXPOA38                  "Diagnosis 38, present on admission indicator"
label var DXPOA39                  "Diagnosis 39, present on admission indicator"
label var DXPOA40                  "Diagnosis 40, present on admission indicator"
label var DXPOA41                  "Diagnosis 41, present on admission indicator"
label var DXPOA42                  "Diagnosis 42, present on admission indicator"
label var DXPOA43                  "Diagnosis 43, present on admission indicator"
label var DXPOA44                  "Diagnosis 44, present on admission indicator"
label var DXPOA45                  "Diagnosis 45, present on admission indicator"
label var DXPOA46                  "Diagnosis 46, present on admission indicator"
label var DXPOA47                  "Diagnosis 47, present on admission indicator"
label var DXPOA48                  "Diagnosis 48, present on admission indicator"
label var DXPOA49                  "Diagnosis 49, present on admission indicator"
label var DXPOA50                  "Diagnosis 50, present on admission indicator"
label var DXPOA51                  "Diagnosis 51, present on admission indicator"
label var DXPOA52                  "Diagnosis 52, present on admission indicator"
label var DXPOA53                  "Diagnosis 53, present on admission indicator"
label var DXPOA54                  "Diagnosis 54, present on admission indicator"
label var DXPOA55                  "Diagnosis 55, present on admission indicator"
label var DXPOA56                  "Diagnosis 56, present on admission indicator"
label var DXPOA57                  "Diagnosis 57, present on admission indicator"
label var DXPOA58                  "Diagnosis 58, present on admission indicator"
label var DXPOA59                  "Diagnosis 59, present on admission indicator"
label var DXPOA60                  "Diagnosis 60, present on admission indicator"
label var DXPOA61                  "Diagnosis 61, present on admission indicator"
label var DXPOA62                  "Diagnosis 62, present on admission indicator"
label var DXPOA63                  "Diagnosis 63, present on admission indicator"
label var DXPOA64                  "Diagnosis 64, present on admission indicator"
label var DXPOA65                  "Diagnosis 65, present on admission indicator"
label var DXPOA66                  "Diagnosis 66, present on admission indicator"
label var DXPOA67                  "Diagnosis 67, present on admission indicator"
label var DXPOA68                  "Diagnosis 68, present on admission indicator"
label var DXPOA69                  "Diagnosis 69, present on admission indicator"
label var DXPOA70                  "Diagnosis 70, present on admission indicator"
label var DXPOA71                  "Diagnosis 71, present on admission indicator"
label var DXPOA72                  "Diagnosis 72, present on admission indicator"
label var DXPOA73                  "Diagnosis 73, present on admission indicator"
label var DXPOA74                  "Diagnosis 74, present on admission indicator"
label var DXPOA75                  "Diagnosis 75, present on admission indicator"
label var DXPOA76                  "Diagnosis 76, present on admission indicator"
label var DXPOA77                  "Diagnosis 77, present on admission indicator"
label var DXPOA78                  "Diagnosis 78, present on admission indicator"
label var DXPOA79                  "Diagnosis 79, present on admission indicator"
label var DXPOA80                  "Diagnosis 80, present on admission indicator"
label var DXPOA81                  "Diagnosis 81, present on admission indicator"
label var DXPOA82                  "Diagnosis 82, present on admission indicator"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HISPANIC                 "Hispanic ethnicity (uniform)"
label var HISPANIC_X               "Hispanic ethnicity (as received from source)"
label var HospitalUnit             "Patient was discharged from a special unit within an acute care hospital (reported by source)"
label var HOSPST                   "Hospital state postal code"
label var I10_BIRTH                "ICD-10-CM Birth Indicator"
label var I10_DELIVERY             "ICD-10-CM Delivery Indicator"
label var I10_DX_Admitting         "ICD-10-CM Admitting Diagnosis Code"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_DX18                 "ICD-10-CM Diagnosis 18"
label var I10_DX19                 "ICD-10-CM Diagnosis 19"
label var I10_DX20                 "ICD-10-CM Diagnosis 20"
label var I10_DX21                 "ICD-10-CM Diagnosis 21"
label var I10_DX22                 "ICD-10-CM Diagnosis 22"
label var I10_DX23                 "ICD-10-CM Diagnosis 23"
label var I10_DX24                 "ICD-10-CM Diagnosis 24"
label var I10_DX25                 "ICD-10-CM Diagnosis 25"
label var I10_DX26                 "ICD-10-CM Diagnosis 26"
label var I10_DX27                 "ICD-10-CM Diagnosis 27"
label var I10_DX28                 "ICD-10-CM Diagnosis 28"
label var I10_DX29                 "ICD-10-CM Diagnosis 29"
label var I10_DX30                 "ICD-10-CM Diagnosis 30"
label var I10_DX31                 "ICD-10-CM Diagnosis 31"
label var I10_DX32                 "ICD-10-CM Diagnosis 32"
label var I10_DX33                 "ICD-10-CM Diagnosis 33"
label var I10_DX34                 "ICD-10-CM Diagnosis 34"
label var I10_DX35                 "ICD-10-CM Diagnosis 35"
label var I10_DX36                 "ICD-10-CM Diagnosis 36"
label var I10_DX37                 "ICD-10-CM Diagnosis 37"
label var I10_DX38                 "ICD-10-CM Diagnosis 38"
label var I10_DX39                 "ICD-10-CM Diagnosis 39"
label var I10_DX40                 "ICD-10-CM Diagnosis 40"
label var I10_DX41                 "ICD-10-CM Diagnosis 41"
label var I10_DX42                 "ICD-10-CM Diagnosis 42"
label var I10_DX43                 "ICD-10-CM Diagnosis 43"
label var I10_DX44                 "ICD-10-CM Diagnosis 44"
label var I10_DX45                 "ICD-10-CM Diagnosis 45"
label var I10_DX46                 "ICD-10-CM Diagnosis 46"
label var I10_DX47                 "ICD-10-CM Diagnosis 47"
label var I10_DX48                 "ICD-10-CM Diagnosis 48"
label var I10_DX49                 "ICD-10-CM Diagnosis 49"
label var I10_DX50                 "ICD-10-CM Diagnosis 50"
label var I10_DX51                 "ICD-10-CM Diagnosis 51"
label var I10_DX52                 "ICD-10-CM Diagnosis 52"
label var I10_DX53                 "ICD-10-CM Diagnosis 53"
label var I10_DX54                 "ICD-10-CM Diagnosis 54"
label var I10_DX55                 "ICD-10-CM Diagnosis 55"
label var I10_DX56                 "ICD-10-CM Diagnosis 56"
label var I10_DX57                 "ICD-10-CM Diagnosis 57"
label var I10_DX58                 "ICD-10-CM Diagnosis 58"
label var I10_DX59                 "ICD-10-CM Diagnosis 59"
label var I10_DX60                 "ICD-10-CM Diagnosis 60"
label var I10_DX61                 "ICD-10-CM Diagnosis 61"
label var I10_DX62                 "ICD-10-CM Diagnosis 62"
label var I10_DX63                 "ICD-10-CM Diagnosis 63"
label var I10_DX64                 "ICD-10-CM Diagnosis 64"
label var I10_DX65                 "ICD-10-CM Diagnosis 65"
label var I10_DX66                 "ICD-10-CM Diagnosis 66"
label var I10_DX67                 "ICD-10-CM Diagnosis 67"
label var I10_DX68                 "ICD-10-CM Diagnosis 68"
label var I10_DX69                 "ICD-10-CM Diagnosis 69"
label var I10_DX70                 "ICD-10-CM Diagnosis 70"
label var I10_DX71                 "ICD-10-CM Diagnosis 71"
label var I10_DX72                 "ICD-10-CM Diagnosis 72"
label var I10_DX73                 "ICD-10-CM Diagnosis 73"
label var I10_DX74                 "ICD-10-CM Diagnosis 74"
label var I10_DX75                 "ICD-10-CM Diagnosis 75"
label var I10_DX76                 "ICD-10-CM Diagnosis 76"
label var I10_DX77                 "ICD-10-CM Diagnosis 77"
label var I10_DX78                 "ICD-10-CM Diagnosis 78"
label var I10_DX79                 "ICD-10-CM Diagnosis 79"
label var I10_DX80                 "ICD-10-CM Diagnosis 80"
label var I10_DX81                 "ICD-10-CM Diagnosis 81"
label var I10_DX82                 "ICD-10-CM Diagnosis 82"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_NPR                  "ICD-10-PCS Number of procedures on this record"
label var I10_PR1                  "ICD-10-PCS Procedure 1"
label var I10_PR2                  "ICD-10-PCS Procedure 2"
label var I10_PR3                  "ICD-10-PCS Procedure 3"
label var I10_PR4                  "ICD-10-PCS Procedure 4"
label var I10_PR5                  "ICD-10-PCS Procedure 5"
label var I10_PR6                  "ICD-10-PCS Procedure 6"
label var I10_PR7                  "ICD-10-PCS Procedure 7"
label var I10_PR8                  "ICD-10-PCS Procedure 8"
label var I10_PR9                  "ICD-10-PCS Procedure 9"
label var I10_PR10                 "ICD-10-PCS Procedure 10"
label var I10_PR11                 "ICD-10-PCS Procedure 11"
label var I10_PR12                 "ICD-10-PCS Procedure 12"
label var I10_PR13                 "ICD-10-PCS Procedure 13"
label var I10_PR14                 "ICD-10-PCS Procedure 14"
label var I10_PR15                 "ICD-10-PCS Procedure 15"
label var I10_PR16                 "ICD-10-PCS Procedure 16"
label var I10_PR17                 "ICD-10-PCS Procedure 17"
label var I10_PR18                 "ICD-10-PCS Procedure 18"
label var I10_PR19                 "ICD-10-PCS Procedure 19"
label var I10_PR20                 "ICD-10-PCS Procedure 20"
label var I10_PR21                 "ICD-10-PCS Procedure 21"
label var I10_PR22                 "ICD-10-PCS Procedure 22"
label var I10_PR23                 "ICD-10-PCS Procedure 23"
label var I10_PR24                 "ICD-10-PCS Procedure 24"
label var I10_PR25                 "ICD-10-PCS Procedure 25"
label var I10_PR26                 "ICD-10-PCS Procedure 26"
label var I10_PR27                 "ICD-10-PCS Procedure 27"
label var I10_PR28                 "ICD-10-PCS Procedure 28"
label var I10_PR29                 "ICD-10-PCS Procedure 29"
label var I10_PR30                 "ICD-10-PCS Procedure 30"
label var I10_PR31                 "ICD-10-PCS Procedure 31"
label var I10_PR32                 "ICD-10-PCS Procedure 32"
label var I10_PR33                 "ICD-10-PCS Procedure 33"
label var I10_PR34                 "ICD-10-PCS Procedure 34"
label var I10_PR35                 "ICD-10-PCS Procedure 35"
label var I10_PR36                 "ICD-10-PCS Procedure 36"
label var I10_PR37                 "ICD-10-PCS Procedure 37"
label var I10_PR38                 "ICD-10-PCS Procedure 38"
label var I10_PR39                 "ICD-10-PCS Procedure 39"
label var I10_PR40                 "ICD-10-PCS Procedure 40"
label var I10_PR41                 "ICD-10-PCS Procedure 41"
label var I10_PR42                 "ICD-10-PCS Procedure 42"
label var I10_PR43                 "ICD-10-PCS Procedure 43"
label var I10_PR44                 "ICD-10-PCS Procedure 44"
label var I10_PR45                 "ICD-10-PCS Procedure 45"
label var I10_PROCTYPE             "ICD-10-PCS Procedure type indicator"
label var I10_SERVICELINE          "ICD-10-CM/PCS Hospital Service Line"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDC                      "MDC in effect on discharge date"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var MRN_R                    "Medical record number (re-identified)"
label var P7EDSRC_X                "Condition Code P7, Direct Inpatient Admission from Emergency Room"
label var PAY1                     "Primary expected payer (uniform)"
label var PCLASS_ORPROC            "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes (RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var POA_Disch_Edit1          "Discharge has POA missing on all nonexempt diagnoses"
label var POA_Disch_Edit2          "Discharge has POA missing on all nonexempt secondary diagnoses"
label var POA_Hosp_Edit1           "Hospital reported POA as Y on all diagnoses on all discharges"
label var POA_Hosp_Edit2           "Hospital reported POA as missing on all non-Medicare discharges"
label var POA_Hosp_Edit3           "Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
label var POA_Hosp_Edit3_Value     "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PRDAY1                   "Number of days from admission to I10_PR1"
label var PRDAY2                   "Number of days from admission to I10_PR2"
label var PRDAY3                   "Number of days from admission to I10_PR3"
label var PRDAY4                   "Number of days from admission to I10_PR4"
label var PRDAY5                   "Number of days from admission to I10_PR5"
label var PRDAY6                   "Number of days from admission to I10_PR6"
label var PRDAY7                   "Number of days from admission to I10_PR7"
label var PRDAY8                   "Number of days from admission to I10_PR8"
label var PRDAY9                   "Number of days from admission to I10_PR9"
label var PRDAY10                  "Number of days from admission to I10_PR10"
label var PRDAY11                  "Number of days from admission to I10_PR11"
label var PRDAY12                  "Number of days from admission to I10_PR12"
label var PRDAY13                  "Number of days from admission to I10_PR13"
label var PRDAY14                  "Number of days from admission to I10_PR14"
label var PRDAY15                  "Number of days from admission to I10_PR15"
label var PRDAY16                  "Number of days from admission to I10_PR16"
label var PRDAY17                  "Number of days from admission to I10_PR17"
label var PRDAY18                  "Number of days from admission to I10_PR18"
label var PRDAY19                  "Number of days from admission to I10_PR19"
label var PRDAY20                  "Number of days from admission to I10_PR20"
label var PRDAY21                  "Number of days from admission to I10_PR21"
label var PRDAY22                  "Number of days from admission to I10_PR22"
label var PRDAY23                  "Number of days from admission to I10_PR23"
label var PRDAY24                  "Number of days from admission to I10_PR24"
label var PRDAY25                  "Number of days from admission to I10_PR25"
label var PRDAY26                  "Number of days from admission to I10_PR26"
label var PRDAY27                  "Number of days from admission to I10_PR27"
label var PRDAY28                  "Number of days from admission to I10_PR28"
label var PRDAY29                  "Number of days from admission to I10_PR29"
label var PRDAY30                  "Number of days from admission to I10_PR30"
label var PRDAY31                  "Number of days from admission to I10_PR31"
label var PRDAY32                  "Number of days from admission to I10_PR32"
label var PRDAY33                  "Number of days from admission to I10_PR33"
label var PRDAY34                  "Number of days from admission to I10_PR34"
label var PRDAY35                  "Number of days from admission to I10_PR35"
label var PRDAY36                  "Number of days from admission to I10_PR36"
label var PRDAY37                  "Number of days from admission to I10_PR37"
label var PRDAY38                  "Number of days from admission to I10_PR38"
label var PRDAY39                  "Number of days from admission to I10_PR39"
label var PRDAY40                  "Number of days from admission to I10_PR40"
label var PRDAY41                  "Number of days from admission to I10_PR41"
label var PRDAY42                  "Number of days from admission to I10_PR42"
label var PRDAY43                  "Number of days from admission to I10_PR43"
label var PRDAY44                  "Number of days from admission to I10_PR44"
label var PRDAY45                  "Number of days from admission to I10_PR45"
label var PSTATE                   "Patient State postal code"
label var PSTATE_GEO               "Patient State postal code assigned from ZIP Code"
label var PSTCO                    "Patient state/county FIPS code"
label var PSTCO_GEO                "Counties assigned based on ZIP Code geographic centroids"
label var RACE                     "Race (uniform)"
label var RACE_PCT_MISS_HOSP       "Hospital percentage of missing or invalid race values"
label var RACE_X                   "Race (as received from source)"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var HOSPID                   "HCUP hospital identification number"
label var AYEAR                    "Admission year"
label var BMONTH                   "Birth month"
label var BYEAR                    "Birth year"
label var PRMONTH1                 "Month of procedure 1"
label var PRMONTH2                 "Month of procedure 2"
label var PRMONTH3                 "Month of procedure 3"
label var PRMONTH4                 "Month of procedure 4"
label var PRMONTH5                 "Month of procedure 5"
label var PRMONTH6                 "Month of procedure 6"
label var PRMONTH7                 "Month of procedure 7"
label var PRMONTH8                 "Month of procedure 8"
label var PRMONTH9                 "Month of procedure 9"
label var PRMONTH10                "Month of procedure 10"
label var PRMONTH11                "Month of procedure 11"
label var PRMONTH12                "Month of procedure 12"
label var PRMONTH13                "Month of procedure 13"
label var PRMONTH14                "Month of procedure 14"
label var PRMONTH15                "Month of procedure 15"
label var PRMONTH16                "Month of procedure 16"
label var PRMONTH17                "Month of procedure 17"
label var PRMONTH18                "Month of procedure 18"
label var PRMONTH19                "Month of procedure 19"
label var PRMONTH20                "Month of procedure 20"
label var PRMONTH21                "Month of procedure 21"
label var PRMONTH22                "Month of procedure 22"
label var PRMONTH23                "Month of procedure 23"
label var PRMONTH24                "Month of procedure 24"
label var PRMONTH25                "Month of procedure 25"
label var PRMONTH26                "Month of procedure 26"
label var PRMONTH27                "Month of procedure 27"
label var PRMONTH28                "Month of procedure 28"
label var PRMONTH29                "Month of procedure 29"
label var PRMONTH30                "Month of procedure 30"
label var PRMONTH31                "Month of procedure 31"
label var PRMONTH32                "Month of procedure 32"
label var PRMONTH33                "Month of procedure 33"
label var PRMONTH34                "Month of procedure 34"
label var PRMONTH35                "Month of procedure 35"
label var PRMONTH36                "Month of procedure 36"
label var PRMONTH37                "Month of procedure 37"
label var PRMONTH38                "Month of procedure 38"
label var PRMONTH39                "Month of procedure 39"
label var PRMONTH40                "Month of procedure 40"
label var PRMONTH41                "Month of procedure 41"
label var PRMONTH42                "Month of procedure 42"
label var PRMONTH43                "Month of procedure 43"
label var PRMONTH44                "Month of procedure 44"
label var PRMONTH45                "Month of procedure 45"
label var PRYEAR1                  "Year of procedure 1"
label var PRYEAR2                  "Year of procedure 2"
label var PRYEAR3                  "Year of procedure 3"
label var PRYEAR4                  "Year of procedure 4"
label var PRYEAR5                  "Year of procedure 5"
label var PRYEAR6                  "Year of procedure 6"
label var PRYEAR7                  "Year of procedure 7"
label var PRYEAR8                  "Year of procedure 8"
label var PRYEAR9                  "Year of procedure 9"
label var PRYEAR10                 "Year of procedure 10"
label var PRYEAR11                 "Year of procedure 11"
label var PRYEAR12                 "Year of procedure 12"
label var PRYEAR13                 "Year of procedure 13"
label var PRYEAR14                 "Year of procedure 14"
label var PRYEAR15                 "Year of procedure 15"
label var PRYEAR16                 "Year of procedure 16"
label var PRYEAR17                 "Year of procedure 17"
label var PRYEAR18                 "Year of procedure 18"
label var PRYEAR19                 "Year of procedure 19"
label var PRYEAR20                 "Year of procedure 20"
label var PRYEAR21                 "Year of procedure 21"
label var PRYEAR22                 "Year of procedure 22"
label var PRYEAR23                 "Year of procedure 23"
label var PRYEAR24                 "Year of procedure 24"
label var PRYEAR25                 "Year of procedure 25"
label var PRYEAR26                 "Year of procedure 26"
label var PRYEAR27                 "Year of procedure 27"
label var PRYEAR28                 "Year of procedure 28"
label var PRYEAR29                 "Year of procedure 29"
label var PRYEAR30                 "Year of procedure 30"
label var PRYEAR31                 "Year of procedure 31"
label var PRYEAR32                 "Year of procedure 32"
label var PRYEAR33                 "Year of procedure 33"
label var PRYEAR34                 "Year of procedure 34"
label var PRYEAR35                 "Year of procedure 35"
label var PRYEAR36                 "Year of procedure 36"
label var PRYEAR37                 "Year of procedure 37"
label var PRYEAR38                 "Year of procedure 38"
label var PRYEAR39                 "Year of procedure 39"
label var PRYEAR40                 "Year of procedure 40"
label var PRYEAR41                 "Year of procedure 41"
label var PRYEAR42                 "Year of procedure 42"
label var PRYEAR43                 "Year of procedure 43"
label var PRYEAR44                 "Year of procedure 44"
label var PRYEAR45                 "Year of procedure 45"

/*** Convert special values to missing values ***/
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode BWT                       (-999 -888 -666=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HISPANIC                  (-9 -8 -6 -5=.)
recode HospitalUnit              (-9 -8 -6 -5=.)
recode I10_BIRTH                 (-99 -88 -66=.)
recode I10_DELIVERY              (-99 -88 -66=.)
recode I10_NDX                   (-99 -88 -66=.)
recode I10_NPR                   (-99 -88 -66=.)
recode I10_PROCTYPE              (-99 -88 -66=.)
recode I10_SERVICELINE           (-9 -8 -6 -5=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM2_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode MRN_R                     (-99999999 -88888888 -66666666=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PCLASS_ORPROC             (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode POA_Disch_Edit1           (-9 -8 -6 -5=.)
recode POA_Disch_Edit2           (-9 -8 -6 -5=.)
recode POA_Hosp_Edit1            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit2            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3_Value      (-9999.99 -8888.88 -6666.66=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PRDAY2                    (-9999 -8888 -6666=.)
recode PRDAY3                    (-9999 -8888 -6666=.)
recode PRDAY4                    (-9999 -8888 -6666=.)
recode PRDAY5                    (-9999 -8888 -6666=.)
recode PRDAY6                    (-9999 -8888 -6666=.)
recode PRDAY7                    (-9999 -8888 -6666=.)
recode PRDAY8                    (-9999 -8888 -6666=.)
recode PRDAY9                    (-9999 -8888 -6666=.)
recode PRDAY10                   (-9999 -8888 -6666=.)
recode PRDAY11                   (-9999 -8888 -6666=.)
recode PRDAY12                   (-9999 -8888 -6666=.)
recode PRDAY13                   (-9999 -8888 -6666=.)
recode PRDAY14                   (-9999 -8888 -6666=.)
recode PRDAY15                   (-9999 -8888 -6666=.)
recode PRDAY16                   (-9999 -8888 -6666=.)
recode PRDAY17                   (-9999 -8888 -6666=.)
recode PRDAY18                   (-9999 -8888 -6666=.)
recode PRDAY19                   (-9999 -8888 -6666=.)
recode PRDAY20                   (-9999 -8888 -6666=.)
recode PRDAY21                   (-9999 -8888 -6666=.)
recode PRDAY22                   (-9999 -8888 -6666=.)
recode PRDAY23                   (-9999 -8888 -6666=.)
recode PRDAY24                   (-9999 -8888 -6666=.)
recode PRDAY25                   (-9999 -8888 -6666=.)
recode PRDAY26                   (-9999 -8888 -6666=.)
recode PRDAY27                   (-9999 -8888 -6666=.)
recode PRDAY28                   (-9999 -8888 -6666=.)
recode PRDAY29                   (-9999 -8888 -6666=.)
recode PRDAY30                   (-9999 -8888 -6666=.)
recode PRDAY31                   (-9999 -8888 -6666=.)
recode PRDAY32                   (-9999 -8888 -6666=.)
recode PRDAY33                   (-9999 -8888 -6666=.)
recode PRDAY34                   (-9999 -8888 -6666=.)
recode PRDAY35                   (-9999 -8888 -6666=.)
recode PRDAY36                   (-9999 -8888 -6666=.)
recode PRDAY37                   (-9999 -8888 -6666=.)
recode PRDAY38                   (-9999 -8888 -6666=.)
recode PRDAY39                   (-9999 -8888 -6666=.)
recode PRDAY40                   (-9999 -8888 -6666=.)
recode PRDAY41                   (-9999 -8888 -6666=.)
recode PRDAY42                   (-9999 -8888 -6666=.)
recode PRDAY43                   (-9999 -8888 -6666=.)
recode PRDAY44                   (-9999 -8888 -6666=.)
recode PRDAY45                   (-9999 -8888 -6666=.)
recode PSTCO                     (-9999 -8888 -6666=.)
recode PSTCO_GEO                 (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode RACE_PCT_MISS_HOSP        (-999.99 -888.88 -666.66=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode BMONTH                    (-9 -8 -6 -5=.)
recode BYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRMONTH2                  (-9 -8 -6 -5=.)
recode PRMONTH3                  (-9 -8 -6 -5=.)
recode PRMONTH4                  (-9 -8 -6 -5=.)
recode PRMONTH5                  (-9 -8 -6 -5=.)
recode PRMONTH6                  (-9 -8 -6 -5=.)
recode PRMONTH7                  (-9 -8 -6 -5=.)
recode PRMONTH8                  (-9 -8 -6 -5=.)
recode PRMONTH9                  (-9 -8 -6 -5=.)
recode PRMONTH10                 (-9 -8 -6 -5=.)
recode PRMONTH11                 (-9 -8 -6 -5=.)
recode PRMONTH12                 (-9 -8 -6 -5=.)
recode PRMONTH13                 (-9 -8 -6 -5=.)
recode PRMONTH14                 (-9 -8 -6 -5=.)
recode PRMONTH15                 (-9 -8 -6 -5=.)
recode PRMONTH16                 (-9 -8 -6 -5=.)
recode PRMONTH17                 (-9 -8 -6 -5=.)
recode PRMONTH18                 (-9 -8 -6 -5=.)
recode PRMONTH19                 (-9 -8 -6 -5=.)
recode PRMONTH20                 (-9 -8 -6 -5=.)
recode PRMONTH21                 (-9 -8 -6 -5=.)
recode PRMONTH22                 (-9 -8 -6 -5=.)
recode PRMONTH23                 (-9 -8 -6 -5=.)
recode PRMONTH24                 (-9 -8 -6 -5=.)
recode PRMONTH25                 (-9 -8 -6 -5=.)
recode PRMONTH26                 (-9 -8 -6 -5=.)
recode PRMONTH27                 (-9 -8 -6 -5=.)
recode PRMONTH28                 (-9 -8 -6 -5=.)
recode PRMONTH29                 (-9 -8 -6 -5=.)
recode PRMONTH30                 (-9 -8 -6 -5=.)
recode PRMONTH31                 (-9 -8 -6 -5=.)
recode PRMONTH32                 (-9 -8 -6 -5=.)
recode PRMONTH33                 (-9 -8 -6 -5=.)
recode PRMONTH34                 (-9 -8 -6 -5=.)
recode PRMONTH35                 (-9 -8 -6 -5=.)
recode PRMONTH36                 (-9 -8 -6 -5=.)
recode PRMONTH37                 (-9 -8 -6 -5=.)
recode PRMONTH38                 (-9 -8 -6 -5=.)
recode PRMONTH39                 (-9 -8 -6 -5=.)
recode PRMONTH40                 (-9 -8 -6 -5=.)
recode PRMONTH41                 (-9 -8 -6 -5=.)
recode PRMONTH42                 (-9 -8 -6 -5=.)
recode PRMONTH43                 (-9 -8 -6 -5=.)
recode PRMONTH44                 (-9 -8 -6 -5=.)
recode PRMONTH45                 (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)
recode PRYEAR2                   (-999 -888 -666=.)
recode PRYEAR3                   (-999 -888 -666=.)
recode PRYEAR4                   (-999 -888 -666=.)
recode PRYEAR5                   (-999 -888 -666=.)
recode PRYEAR6                   (-999 -888 -666=.)
recode PRYEAR7                   (-999 -888 -666=.)
recode PRYEAR8                   (-999 -888 -666=.)
recode PRYEAR9                   (-999 -888 -666=.)
recode PRYEAR10                  (-999 -888 -666=.)
recode PRYEAR11                  (-999 -888 -666=.)
recode PRYEAR12                  (-999 -888 -666=.)
recode PRYEAR13                  (-999 -888 -666=.)
recode PRYEAR14                  (-999 -888 -666=.)
recode PRYEAR15                  (-999 -888 -666=.)
recode PRYEAR16                  (-999 -888 -666=.)
recode PRYEAR17                  (-999 -888 -666=.)
recode PRYEAR18                  (-999 -888 -666=.)
recode PRYEAR19                  (-999 -888 -666=.)
recode PRYEAR20                  (-999 -888 -666=.)
recode PRYEAR21                  (-999 -888 -666=.)
recode PRYEAR22                  (-999 -888 -666=.)
recode PRYEAR23                  (-999 -888 -666=.)
recode PRYEAR24                  (-999 -888 -666=.)
recode PRYEAR25                  (-999 -888 -666=.)
recode PRYEAR26                  (-999 -888 -666=.)
recode PRYEAR27                  (-999 -888 -666=.)
recode PRYEAR28                  (-999 -888 -666=.)
recode PRYEAR29                  (-999 -888 -666=.)
recode PRYEAR30                  (-999 -888 -666=.)
recode PRYEAR31                  (-999 -888 -666=.)
recode PRYEAR32                  (-999 -888 -666=.)
recode PRYEAR33                  (-999 -888 -666=.)
recode PRYEAR34                  (-999 -888 -666=.)
recode PRYEAR35                  (-999 -888 -666=.)
recode PRYEAR36                  (-999 -888 -666=.)
recode PRYEAR37                  (-999 -888 -666=.)
recode PRYEAR38                  (-999 -888 -666=.)
recode PRYEAR39                  (-999 -888 -666=.)
recode PRYEAR40                  (-999 -888 -666=.)
recode PRYEAR41                  (-999 -888 -666=.)
recode PRYEAR42                  (-999 -888 -666=.)
recode PRYEAR43                  (-999 -888 -666=.)
recode PRYEAR44                  (-999 -888 -666=.)
recode PRYEAR45                  (-999 -888 -666=.)

save "SD_SID_2022_CORE.dta", replace
