/*****************************************************************************
* Creation Date: 02/24/2016   
* Modify Date:   10/19/2017 - matches data created on date above.
* MI_SID_2014_CORE.Do
* This program will load the 2014 MI ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***
infix 3 firstlineoffile                          ///
      int    AGE                         1-  3   ///
      int    AGEDAY                      4-  6   ///
      int    AGEMONTH                    7-  9   ///
      byte   AMONTH                     10- 11   ///
      byte   ATYPE                      12- 13   ///
      byte   AWEEKEND                   14- 15   ///
      byte   DIED                       16- 17   ///
      byte   DISPUB04                   18- 19   ///
      byte   DISPUNIFORM                20- 21   ///
      str    DISP_X                     22- 23   ///
      byte   DMONTH                     24- 25   ///
      byte   DQTR                       26- 27   ///
      int    DRG                        28- 30   ///
      int    DRG24                      31- 33   ///
      byte   DRGVER                     34- 35   ///
      int    DRG_NoPOA                  36- 38   ///
      str    DX1                        39- 45   ///
      str    DX2                        46- 52   ///
      str    DX3                        53- 59   ///
      str    DX4                        60- 66   ///
      str    DX5                        67- 73   ///
      str    DX6                        74- 80   ///
      str    DX7                        81- 87   ///
      str    DX8                        88- 94   ///
      str    DX9                        95-101   ///
      str    DX10                      102-108   ///
      str    DX11                      109-115   ///
      str    DX12                      116-122   ///
      str    DX13                      123-129   ///
      str    DX14                      130-136   ///
      str    DX15                      137-143   ///
      str    DX16                      144-150   ///
      str    DX17                      151-157   ///
      str    DX18                      158-164   ///
      str    DX19                      165-171   ///
      str    DX20                      172-178   ///
      str    DX21                      179-185   ///
      str    DX22                      186-192   ///
      str    DX23                      193-199   ///
      str    DX24                      200-206   ///
      str    DX25                      207-213   ///
      str    DX26                      214-220   ///
      str    DX27                      221-227   ///
      str    DX28                      228-234   ///
      str    DX29                      235-241   ///
      str    DX30                      242-248   ///
      int    DXCCS1                    249-252   ///
      int    DXCCS2                    253-256   ///
      int    DXCCS3                    257-260   ///
      int    DXCCS4                    261-264   ///
      int    DXCCS5                    265-268   ///
      int    DXCCS6                    269-272   ///
      int    DXCCS7                    273-276   ///
      int    DXCCS8                    277-280   ///
      int    DXCCS9                    281-284   ///
      int    DXCCS10                   285-288   ///
      int    DXCCS11                   289-292   ///
      int    DXCCS12                   293-296   ///
      int    DXCCS13                   297-300   ///
      int    DXCCS14                   301-304   ///
      int    DXCCS15                   305-308   ///
      int    DXCCS16                   309-312   ///
      int    DXCCS17                   313-316   ///
      int    DXCCS18                   317-320   ///
      int    DXCCS19                   321-324   ///
      int    DXCCS20                   325-328   ///
      int    DXCCS21                   329-332   ///
      int    DXCCS22                   333-336   ///
      int    DXCCS23                   337-340   ///
      int    DXCCS24                   341-344   ///
      int    DXCCS25                   345-348   ///
      int    DXCCS26                   349-352   ///
      int    DXCCS27                   353-356   ///
      int    DXCCS28                   357-360   ///
      int    DXCCS29                   361-364   ///
      int    DXCCS30                   365-368   ///
      str    DXPOA1                    369       ///
      str    DXPOA2                    370       ///
      str    DXPOA3                    371       ///
      str    DXPOA4                    372       ///
      str    DXPOA5                    373       ///
      str    DXPOA6                    374       ///
      str    DXPOA7                    375       ///
      str    DXPOA8                    376       ///
      str    DXPOA9                    377       ///
      str    DXPOA10                   378       ///
      str    DXPOA11                   379       ///
      str    DXPOA12                   380       ///
      str    DXPOA13                   381       ///
      str    DXPOA14                   382       ///
      str    DXPOA15                   383       ///
      str    DXPOA16                   384       ///
      str    DXPOA17                   385       ///
      str    DXPOA18                   386       ///
      str    DXPOA19                   387       ///
      str    DXPOA20                   388       ///
      str    DXPOA21                   389       ///
      str    DXPOA22                   390       ///
      str    DXPOA23                   391       ///
      str    DXPOA24                   392       ///
      str    DXPOA25                   393       ///
      str    DXPOA26                   394       ///
      str    DXPOA27                   395       ///
      str    DXPOA28                   396       ///
      str    DXPOA29                   397       ///
      str    DXPOA30                   398       ///
      int    DXVER                     399-401   ///
      str    DX_Admitting              402-408   ///
      int    DaysCCU                   409-411   ///
      int    DaysICU                   412-414   ///
      str    ECODE1                    415-421   ///
      str    ECODE2                    422-428   ///
      str    ECODE3                    429-435   ///
      str    ECODE4                    436-442   ///
      str    ECODE5                    443-449   ///
      str    ECODE6                    450-456   ///
      str    ECODE7                    457-463   ///
      str    ECODE8                    464-470   ///
      str    ECODE9                    471-477   ///
      int    E_CCS1                    478-481   ///
      int    E_CCS2                    482-485   ///
      int    E_CCS3                    486-489   ///
      int    E_CCS4                    490-493   ///
      int    E_CCS5                    494-497   ///
      int    E_CCS6                    498-501   ///
      int    E_CCS7                    502-505   ///
      int    E_CCS8                    506-509   ///
      int    E_CCS9                    510-513   ///
      str    E_POA1                    514       ///
      str    E_POA2                    515       ///
      str    E_POA3                    516       ///
      str    E_POA4                    517       ///
      str    E_POA5                    518       ///
      str    E_POA6                    519       ///
      str    E_POA7                    520       ///
      str    E_POA8                    521       ///
      str    E_POA9                    522       ///
      byte   FEMALE                    523-524   ///
      byte   HCUP_ED                   525-526   ///
      byte   HCUP_OS                   527-528   ///
      str    HISPANIC_X                529       ///
      int    HOSPBRTH                  530-532   ///
      str    HOSPST                    533-534   ///
      double KEY                       535-549   ///
      long   LOS                       550-554   ///
      long   LOS_X                     555-560   ///
      byte   MDC                       561-562   ///
      byte   MDC24                     563-564   ///
      byte   MDC_NoPOA                 565-566   ///
      long   MDNUM1_R                  567-575   ///
      long   MDNUM2_R                  576-584   ///
      byte   MEDINCSTQ                 585-586   ///
      long   MOMNUM_R                  587-595   ///
      long   MRN_R                     596-604   ///
      int    NCHRONIC                  605-607   ///
      int    NDX                       608-610   ///
      byte   NECODE                    611-612   ///
      byte   NEOMAT                    613-614   ///
      int    NPR                       615-617   ///
      byte   ORPROC                    618-619   ///
      byte   PAY1                      620-621   ///
      str    PAY1_X                    622-623   ///
      byte   PAY2                      624-625   ///
      str    PAY2_X                    626-627   ///
      int    PL_CBSA                   628-630   ///
      byte   PL_NCHS                   631-632   ///
      byte   PL_RUCC                   633-634   ///
      byte   PL_UIC                    635-636   ///
      byte   PL_UR_CAT4                637-638   ///
      byte   POA_Disch_Edit1           639-640   ///
      byte   POA_Disch_Edit2           641-642   ///
      byte   POA_Hosp_Edit1            643-644   ///
      byte   POA_Hosp_Edit2            645-646   ///
      byte   POA_Hosp_Edit3            647-648   ///
      double POA_Hosp_Edit3_Value      649-656   ///
      str    PR1                       657-663   ///
      str    PR2                       664-670   ///
      str    PR3                       671-677   ///
      str    PR4                       678-684   ///
      str    PR5                       685-691   ///
      str    PR6                       692-698   ///
      str    PR7                       699-705   ///
      str    PR8                       706-712   ///
      str    PR9                       713-719   ///
      str    PR10                      720-726   ///
      str    PR11                      727-733   ///
      str    PR12                      734-740   ///
      str    PR13                      741-747   ///
      str    PR14                      748-754   ///
      str    PR15                      755-761   ///
      str    PR16                      762-768   ///
      str    PR17                      769-775   ///
      str    PR18                      776-782   ///
      str    PR19                      783-789   ///
      str    PR20                      790-796   ///
      str    PR21                      797-803   ///
      str    PR22                      804-810   ///
      str    PR23                      811-817   ///
      str    PR24                      818-824   ///
      str    PR25                      825-831   ///
      str    PR26                      832-838   ///
      str    PR27                      839-845   ///
      str    PR28                      846-852   ///
      str    PR29                      853-859   ///
      str    PR30                      860-866   ///
      int    PRCCS1                    867-869   ///
      int    PRCCS2                    870-872   ///
      int    PRCCS3                    873-875   ///
      int    PRCCS4                    876-878   ///
      int    PRCCS5                    879-881   ///
      int    PRCCS6                    882-884   ///
      int    PRCCS7                    885-887   ///
      int    PRCCS8                    888-890   ///
      int    PRCCS9                    891-893   ///
      int    PRCCS10                   894-896   ///
      int    PRCCS11                   897-899   ///
      int    PRCCS12                   900-902   ///
      int    PRCCS13                   903-905   ///
      int    PRCCS14                   906-908   ///
      int    PRCCS15                   909-911   ///
      int    PRCCS16                   912-914   ///
      int    PRCCS17                   915-917   ///
      int    PRCCS18                   918-920   ///
      int    PRCCS19                   921-923   ///
      int    PRCCS20                   924-926   ///
      int    PRCCS21                   927-929   ///
      int    PRCCS22                   930-932   ///
      int    PRCCS23                   933-935   ///
      int    PRCCS24                   936-938   ///
      int    PRCCS25                   939-941   ///
      int    PRCCS26                   942-944   ///
      int    PRCCS27                   945-947   ///
      int    PRCCS28                   948-950   ///
      int    PRCCS29                   951-953   ///
      int    PRCCS30                   954-956   ///
      long   PRDAY1                    957-961   ///
      long   PRDAY2                    962-966   ///
      long   PRDAY3                    967-971   ///
      long   PRDAY4                    972-976   ///
      long   PRDAY5                    977-981   ///
      long   PRDAY6                    982-986   ///
      long   PRDAY7                    987-991   ///
      long   PRDAY8                    992-996   ///
      long   PRDAY9                   997-1001   ///
      long   PRDAY10                 1002-1006   ///
      long   PRDAY11                 1007-1011   ///
      long   PRDAY12                 1012-1016   ///
      long   PRDAY13                 1017-1021   ///
      long   PRDAY14                 1022-1026   ///
      long   PRDAY15                 1027-1031   ///
      long   PRDAY16                 1032-1036   ///
      long   PRDAY17                 1037-1041   ///
      long   PRDAY18                 1042-1046   ///
      long   PRDAY19                 1047-1051   ///
      long   PRDAY20                 1052-1056   ///
      long   PRDAY21                 1057-1061   ///
      long   PRDAY22                 1062-1066   ///
      long   PRDAY23                 1067-1071   ///
      long   PRDAY24                 1072-1076   ///
      long   PRDAY25                 1077-1081   ///
      long   PRDAY26                 1082-1086   ///
      long   PRDAY27                 1087-1091   ///
      long   PRDAY28                 1092-1096   ///
      long   PRDAY29                 1097-1101   ///
      long   PRDAY30                 1102-1106   ///
      int    PROCTYPE                1107-1109   ///
      int    PRVER                   1110-1112   ///
      str    PSTATE                  1113-1114   ///
      long   PSTCO2                  1115-1119   ///
      str    PointOfOriginUB04       1120        ///
      str    PointOfOrigin_X         1121        ///
      byte   RACE                    1122-1123   ///
      str    RACE_X                  1124        ///
      byte   SERVICELINE             1125-1126   ///
      double TOTCHG                  1127-1136   ///
      double TOTCHG_X                1137-1151   ///
      byte   TRAN_IN                 1152-1153   ///
      byte   TRAN_OUT                1154-1155   ///
      int    YEAR                    1156-1159   ///
      str    ZIP                     1160-1164   ///
      str    ZIP3                    1165-1167   ///
      int    ZIPINC_QRTL             1168-1170   ///
      long   HOSPID                  1171-1175   ///
      int    AYEAR                   1176-1179   ///
      byte   BMONTH                  1180-1181   ///
      int    BYEAR                   1182-1185   ///
      byte   PRMONTH1                1186-1187   ///
      byte   PRMONTH2                1188-1189   ///
      byte   PRMONTH3                1190-1191   ///
      byte   PRMONTH4                1192-1193   ///
      byte   PRMONTH5                1194-1195   ///
      byte   PRMONTH6                1196-1197   ///
      byte   PRMONTH7                1198-1199   ///
      byte   PRMONTH8                1200-1201   ///
      byte   PRMONTH9                1202-1203   ///
      byte   PRMONTH10               1204-1205   ///
      byte   PRMONTH11               1206-1207   ///
      byte   PRMONTH12               1208-1209   ///
      byte   PRMONTH13               1210-1211   ///
      byte   PRMONTH14               1212-1213   ///
      byte   PRMONTH15               1214-1215   ///
      byte   PRMONTH16               1216-1217   ///
      byte   PRMONTH17               1218-1219   ///
      byte   PRMONTH18               1220-1221   ///
      byte   PRMONTH19               1222-1223   ///
      byte   PRMONTH20               1224-1225   ///
      byte   PRMONTH21               1226-1227   ///
      byte   PRMONTH22               1228-1229   ///
      byte   PRMONTH23               1230-1231   ///
      byte   PRMONTH24               1232-1233   ///
      byte   PRMONTH25               1234-1235   ///
      byte   PRMONTH26               1236-1237   ///
      byte   PRMONTH27               1238-1239   ///
      byte   PRMONTH28               1240-1241   ///
      byte   PRMONTH29               1242-1243   ///
      byte   PRMONTH30               1244-1245   ///
      int    PRYEAR1                 1246-1249   ///
      int    PRYEAR2                 1250-1253   ///
      int    PRYEAR3                 1254-1257   ///
      int    PRYEAR4                 1258-1261   ///
      int    PRYEAR5                 1262-1265   ///
      int    PRYEAR6                 1266-1269   ///
      int    PRYEAR7                 1270-1273   ///
      int    PRYEAR8                 1274-1277   ///
      int    PRYEAR9                 1278-1281   ///
      int    PRYEAR10                1282-1285   ///
      int    PRYEAR11                1286-1289   ///
      int    PRYEAR12                1290-1293   ///
      int    PRYEAR13                1294-1297   ///
      int    PRYEAR14                1298-1301   ///
      int    PRYEAR15                1302-1305   ///
      int    PRYEAR16                1306-1309   ///
      int    PRYEAR17                1310-1313   ///
      int    PRYEAR18                1314-1317   ///
      int    PRYEAR19                1318-1321   ///
      int    PRYEAR20                1322-1325   ///
      int    PRYEAR21                1326-1329   ///
      int    PRYEAR22                1330-1333   ///
      int    PRYEAR23                1334-1337   ///
      int    PRYEAR24                1338-1341   ///
      int    PRYEAR25                1342-1345   ///
      int    PRYEAR26                1346-1349   ///
      int    PRYEAR27                1350-1353   ///
      int    PRYEAR28                1354-1357   ///
      int    PRYEAR29                1358-1361   ///
      int    PRYEAR30                1362-1365   ///
      using  "MI_SID_2014_CORE.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var DIED                     "Died during hospitalization"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRG24                    "DRG, version 24"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DX16                     "Diagnosis 16"
label var DX17                     "Diagnosis 17"
label var DX18                     "Diagnosis 18"
label var DX19                     "Diagnosis 19"
label var DX20                     "Diagnosis 20"
label var DX21                     "Diagnosis 21"
label var DX22                     "Diagnosis 22"
label var DX23                     "Diagnosis 23"
label var DX24                     "Diagnosis 24"
label var DX25                     "Diagnosis 25"
label var DX26                     "Diagnosis 26"
label var DX27                     "Diagnosis 27"
label var DX28                     "Diagnosis 28"
label var DX29                     "Diagnosis 29"
label var DX30                     "Diagnosis 30"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var DXCCS16                  "CCS: diagnosis 16"
label var DXCCS17                  "CCS: diagnosis 17"
label var DXCCS18                  "CCS: diagnosis 18"
label var DXCCS19                  "CCS: diagnosis 19"
label var DXCCS20                  "CCS: diagnosis 20"
label var DXCCS21                  "CCS: diagnosis 21"
label var DXCCS22                  "CCS: diagnosis 22"
label var DXCCS23                  "CCS: diagnosis 23"
label var DXCCS24                  "CCS: diagnosis 24"
label var DXCCS25                  "CCS: diagnosis 25"
label var DXCCS26                  "CCS: diagnosis 26"
label var DXCCS27                  "CCS: diagnosis 27"
label var DXCCS28                  "CCS: diagnosis 28"
label var DXCCS29                  "CCS: diagnosis 29"
label var DXCCS30                  "CCS: diagnosis 30"
label var DXPOA1                   "Diagnosis 1, present on admission indicator"
label var DXPOA2                   "Diagnosis 2, present on admission indicator"
label var DXPOA3                   "Diagnosis 3, present on admission indicator"
label var DXPOA4                   "Diagnosis 4, present on admission indicator"
label var DXPOA5                   "Diagnosis 5, present on admission indicator"
label var DXPOA6                   "Diagnosis 6, present on admission indicator"
label var DXPOA7                   "Diagnosis 7, present on admission indicator"
label var DXPOA8                   "Diagnosis 8, present on admission indicator"
label var DXPOA9                   "Diagnosis 9, present on admission indicator"
label var DXPOA10                  "Diagnosis 10, present on admission indicator"
label var DXPOA11                  "Diagnosis 11, present on admission indicator"
label var DXPOA12                  "Diagnosis 12, present on admission indicator"
label var DXPOA13                  "Diagnosis 13, present on admission indicator"
label var DXPOA14                  "Diagnosis 14, present on admission indicator"
label var DXPOA15                  "Diagnosis 15, present on admission indicator"
label var DXPOA16                  "Diagnosis 16, present on admission indicator"
label var DXPOA17                  "Diagnosis 17, present on admission indicator"
label var DXPOA18                  "Diagnosis 18, present on admission indicator"
label var DXPOA19                  "Diagnosis 19, present on admission indicator"
label var DXPOA20                  "Diagnosis 20, present on admission indicator"
label var DXPOA21                  "Diagnosis 21, present on admission indicator"
label var DXPOA22                  "Diagnosis 22, present on admission indicator"
label var DXPOA23                  "Diagnosis 23, present on admission indicator"
label var DXPOA24                  "Diagnosis 24, present on admission indicator"
label var DXPOA25                  "Diagnosis 25, present on admission indicator"
label var DXPOA26                  "Diagnosis 26, present on admission indicator"
label var DXPOA27                  "Diagnosis 27, present on admission indicator"
label var DXPOA28                  "Diagnosis 28, present on admission indicator"
label var DXPOA29                  "Diagnosis 29, present on admission indicator"
label var DXPOA30                  "Diagnosis 30, present on admission indicator"
label var DXVER                    "Diagnosis Version"
label var DX_Admitting             "Admitting Diagnosis Code"
label var DaysCCU                  "Days in coronary care unit (as received from source)"
label var DaysICU                  "Days in medical/surgical intensive care unit (as received from source)"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ECODE5                   "E code 5"
label var ECODE6                   "E code 6"
label var ECODE7                   "E code 7"
label var ECODE8                   "E code 8"
label var ECODE9                   "E code 9"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var E_CCS5                   "CCS: E Code 5"
label var E_CCS6                   "CCS: E Code 6"
label var E_CCS7                   "CCS: E Code 7"
label var E_CCS8                   "CCS: E Code 8"
label var E_CCS9                   "CCS: E Code 9"
label var E_POA1                   "E Code 1, present on admission indicator"
label var E_POA2                   "E Code 2, present on admission indicator"
label var E_POA3                   "E Code 3, present on admission indicator"
label var E_POA4                   "E Code 4, present on admission indicator"
label var E_POA5                   "E Code 5, present on admission indicator"
label var E_POA6                   "E Code 6, present on admission indicator"
label var E_POA7                   "E Code 7, present on admission indicator"
label var E_POA8                   "E Code 8, present on admission indicator"
label var E_POA9                   "E Code 9, present on admission indicator"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HISPANIC_X               "Hispanic ethnicity (as received from source)"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSPST                   "Hospital state postal code"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDC                      "MDC in effect on discharge date"
label var MDC24                    "MDC, version 24"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var MOMNUM_R                 "Mother's number (re-identified)"
label var MRN_R                    "Medical record number (re-identified)"
label var NCHRONIC                 "Number of chronic conditions"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes(RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var POA_Disch_Edit1          "Indication that a discharge has POA missing on all nonexempt diagnoses"
label var POA_Disch_Edit2          "Indication that a discharge has POA missing on all nonexempt secondary diagnoses"
label var POA_Hosp_Edit1           "Indication that a hospital has POA reported as Y on all diagnoses on all discharges"
label var POA_Hosp_Edit2           "Indication that a hospital has POA reported as missing on all non-Medicare discharges"
label var POA_Hosp_Edit3           "Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
label var POA_Hosp_Edit3_Value     "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PR16                     "Procedure 16"
label var PR17                     "Procedure 17"
label var PR18                     "Procedure 18"
label var PR19                     "Procedure 19"
label var PR20                     "Procedure 20"
label var PR21                     "Procedure 21"
label var PR22                     "Procedure 22"
label var PR23                     "Procedure 23"
label var PR24                     "Procedure 24"
label var PR25                     "Procedure 25"
label var PR26                     "Procedure 26"
label var PR27                     "Procedure 27"
label var PR28                     "Procedure 28"
label var PR29                     "Procedure 29"
label var PR30                     "Procedure 30"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRCCS16                  "CCS: procedure 16"
label var PRCCS17                  "CCS: procedure 17"
label var PRCCS18                  "CCS: procedure 18"
label var PRCCS19                  "CCS: procedure 19"
label var PRCCS20                  "CCS: procedure 20"
label var PRCCS21                  "CCS: procedure 21"
label var PRCCS22                  "CCS: procedure 22"
label var PRCCS23                  "CCS: procedure 23"
label var PRCCS24                  "CCS: procedure 24"
label var PRCCS25                  "CCS: procedure 25"
label var PRCCS26                  "CCS: procedure 26"
label var PRCCS27                  "CCS: procedure 27"
label var PRCCS28                  "CCS: procedure 28"
label var PRCCS29                  "CCS: procedure 29"
label var PRCCS30                  "CCS: procedure 30"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var PRDAY16                  "Number of days from admission to PR16"
label var PRDAY17                  "Number of days from admission to PR17"
label var PRDAY18                  "Number of days from admission to PR18"
label var PRDAY19                  "Number of days from admission to PR19"
label var PRDAY20                  "Number of days from admission to PR20"
label var PRDAY21                  "Number of days from admission to PR21"
label var PRDAY22                  "Number of days from admission to PR22"
label var PRDAY23                  "Number of days from admission to PR23"
label var PRDAY24                  "Number of days from admission to PR24"
label var PRDAY25                  "Number of days from admission to PR25"
label var PRDAY26                  "Number of days from admission to PR26"
label var PRDAY27                  "Number of days from admission to PR27"
label var PRDAY28                  "Number of days from admission to PR28"
label var PRDAY29                  "Number of days from admission to PR29"
label var PRDAY30                  "Number of days from admission to PR30"
label var PROCTYPE                 "Procedure type indicator"
label var PRVER                    "Procedure Version"
label var PSTATE                   "Patient State postal code"
label var PSTCO2                   "Patient state/county FIPS code, possibly derived from ZIP Code"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var RACE                     "Race (uniform)"
label var RACE_X                   "Race (as received from source)"
label var SERVICELINE              "Hospital Service Line"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var HOSPID                   "HCUP hospital identification number"
label var AYEAR                    "Admission year"
label var BMONTH                   "Birth month"
label var BYEAR                    "Birth year"
label var PRMONTH1                 "Month of procedure 1"
label var PRMONTH2                 "Month of procedure 2"
label var PRMONTH3                 "Month of procedure 3"
label var PRMONTH4                 "Month of procedure 4"
label var PRMONTH5                 "Month of procedure 5"
label var PRMONTH6                 "Month of procedure 6"
label var PRMONTH7                 "Month of procedure 7"
label var PRMONTH8                 "Month of procedure 8"
label var PRMONTH9                 "Month of procedure 9"
label var PRMONTH10                "Month of procedure 10"
label var PRMONTH11                "Month of procedure 11"
label var PRMONTH12                "Month of procedure 12"
label var PRMONTH13                "Month of procedure 13"
label var PRMONTH14                "Month of procedure 14"
label var PRMONTH15                "Month of procedure 15"
label var PRMONTH16                "Month of procedure 16"
label var PRMONTH17                "Month of procedure 17"
label var PRMONTH18                "Month of procedure 18"
label var PRMONTH19                "Month of procedure 19"
label var PRMONTH20                "Month of procedure 20"
label var PRMONTH21                "Month of procedure 21"
label var PRMONTH22                "Month of procedure 22"
label var PRMONTH23                "Month of procedure 23"
label var PRMONTH24                "Month of procedure 24"
label var PRMONTH25                "Month of procedure 25"
label var PRMONTH26                "Month of procedure 26"
label var PRMONTH27                "Month of procedure 27"
label var PRMONTH28                "Month of procedure 28"
label var PRMONTH29                "Month of procedure 29"
label var PRMONTH30                "Month of procedure 30"
label var PRYEAR1                  "Year of procedure 1"
label var PRYEAR2                  "Year of procedure 2"
label var PRYEAR3                  "Year of procedure 3"
label var PRYEAR4                  "Year of procedure 4"
label var PRYEAR5                  "Year of procedure 5"
label var PRYEAR6                  "Year of procedure 6"
label var PRYEAR7                  "Year of procedure 7"
label var PRYEAR8                  "Year of procedure 8"
label var PRYEAR9                  "Year of procedure 9"
label var PRYEAR10                 "Year of procedure 10"
label var PRYEAR11                 "Year of procedure 11"
label var PRYEAR12                 "Year of procedure 12"
label var PRYEAR13                 "Year of procedure 13"
label var PRYEAR14                 "Year of procedure 14"
label var PRYEAR15                 "Year of procedure 15"
label var PRYEAR16                 "Year of procedure 16"
label var PRYEAR17                 "Year of procedure 17"
label var PRYEAR18                 "Year of procedure 18"
label var PRYEAR19                 "Year of procedure 19"
label var PRYEAR20                 "Year of procedure 20"
label var PRYEAR21                 "Year of procedure 21"
label var PRYEAR22                 "Year of procedure 22"
label var PRYEAR23                 "Year of procedure 23"
label var PRYEAR24                 "Year of procedure 24"
label var PRYEAR25                 "Year of procedure 25"
label var PRYEAR26                 "Year of procedure 26"
label var PRYEAR27                 "Year of procedure 27"
label var PRYEAR28                 "Year of procedure 28"
label var PRYEAR29                 "Year of procedure 29"
label var PRYEAR30                 "Year of procedure 30"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG24                     (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DXCCS1                    (-999 -888 -666=.)
recode DXCCS2                    (-999 -888 -666=.)
recode DXCCS3                    (-999 -888 -666=.)
recode DXCCS4                    (-999 -888 -666=.)
recode DXCCS5                    (-999 -888 -666=.)
recode DXCCS6                    (-999 -888 -666=.)
recode DXCCS7                    (-999 -888 -666=.)
recode DXCCS8                    (-999 -888 -666=.)
recode DXCCS9                    (-999 -888 -666=.)
recode DXCCS10                   (-999 -888 -666=.)
recode DXCCS11                   (-999 -888 -666=.)
recode DXCCS12                   (-999 -888 -666=.)
recode DXCCS13                   (-999 -888 -666=.)
recode DXCCS14                   (-999 -888 -666=.)
recode DXCCS15                   (-999 -888 -666=.)
recode DXCCS16                   (-999 -888 -666=.)
recode DXCCS17                   (-999 -888 -666=.)
recode DXCCS18                   (-999 -888 -666=.)
recode DXCCS19                   (-999 -888 -666=.)
recode DXCCS20                   (-999 -888 -666=.)
recode DXCCS21                   (-999 -888 -666=.)
recode DXCCS22                   (-999 -888 -666=.)
recode DXCCS23                   (-999 -888 -666=.)
recode DXCCS24                   (-999 -888 -666=.)
recode DXCCS25                   (-999 -888 -666=.)
recode DXCCS26                   (-999 -888 -666=.)
recode DXCCS27                   (-999 -888 -666=.)
recode DXCCS28                   (-999 -888 -666=.)
recode DXCCS29                   (-999 -888 -666=.)
recode DXCCS30                   (-999 -888 -666=.)
recode DXVER                     (-99 -88 -66=.)
recode DaysCCU                   (-99 -88 -66=.)
recode DaysICU                   (-99 -88 -66=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode E_CCS5                    (-999 -888 -666=.)
recode E_CCS6                    (-999 -888 -666=.)
recode E_CCS7                    (-999 -888 -666=.)
recode E_CCS8                    (-999 -888 -666=.)
recode E_CCS9                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HOSPBRTH                  (-99 -88 -66=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC24                     (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM2_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode MOMNUM_R                  (-99999999 -88888888 -66666666=.)
recode MRN_R                     (-99999999 -88888888 -66666666=.)
recode NCHRONIC                  (-99 -88 -66=.)
recode NDX                       (-99 -88 -66=.)
recode NECODE                    (-9 -8 -6 -5=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NPR                       (-99 -88 -66=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode POA_Disch_Edit1           (-9 -8 -6 -5=.)
recode POA_Disch_Edit2           (-9 -8 -6 -5=.)
recode POA_Hosp_Edit1            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit2            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3_Value      (-9999.99 -8888.88 -6666.66=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRCCS16                   (-99 -88 -66=.)
recode PRCCS17                   (-99 -88 -66=.)
recode PRCCS18                   (-99 -88 -66=.)
recode PRCCS19                   (-99 -88 -66=.)
recode PRCCS20                   (-99 -88 -66=.)
recode PRCCS21                   (-99 -88 -66=.)
recode PRCCS22                   (-99 -88 -66=.)
recode PRCCS23                   (-99 -88 -66=.)
recode PRCCS24                   (-99 -88 -66=.)
recode PRCCS25                   (-99 -88 -66=.)
recode PRCCS26                   (-99 -88 -66=.)
recode PRCCS27                   (-99 -88 -66=.)
recode PRCCS28                   (-99 -88 -66=.)
recode PRCCS29                   (-99 -88 -66=.)
recode PRCCS30                   (-99 -88 -66=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PRDAY2                    (-9999 -8888 -6666=.)
recode PRDAY3                    (-9999 -8888 -6666=.)
recode PRDAY4                    (-9999 -8888 -6666=.)
recode PRDAY5                    (-9999 -8888 -6666=.)
recode PRDAY6                    (-9999 -8888 -6666=.)
recode PRDAY7                    (-9999 -8888 -6666=.)
recode PRDAY8                    (-9999 -8888 -6666=.)
recode PRDAY9                    (-9999 -8888 -6666=.)
recode PRDAY10                   (-9999 -8888 -6666=.)
recode PRDAY11                   (-9999 -8888 -6666=.)
recode PRDAY12                   (-9999 -8888 -6666=.)
recode PRDAY13                   (-9999 -8888 -6666=.)
recode PRDAY14                   (-9999 -8888 -6666=.)
recode PRDAY15                   (-9999 -8888 -6666=.)
recode PRDAY16                   (-9999 -8888 -6666=.)
recode PRDAY17                   (-9999 -8888 -6666=.)
recode PRDAY18                   (-9999 -8888 -6666=.)
recode PRDAY19                   (-9999 -8888 -6666=.)
recode PRDAY20                   (-9999 -8888 -6666=.)
recode PRDAY21                   (-9999 -8888 -6666=.)
recode PRDAY22                   (-9999 -8888 -6666=.)
recode PRDAY23                   (-9999 -8888 -6666=.)
recode PRDAY24                   (-9999 -8888 -6666=.)
recode PRDAY25                   (-9999 -8888 -6666=.)
recode PRDAY26                   (-9999 -8888 -6666=.)
recode PRDAY27                   (-9999 -8888 -6666=.)
recode PRDAY28                   (-9999 -8888 -6666=.)
recode PRDAY29                   (-9999 -8888 -6666=.)
recode PRDAY30                   (-9999 -8888 -6666=.)
recode PROCTYPE                  (-99 -88 -66=.)
recode PRVER                     (-99 -88 -66=.)
recode PSTCO2                    (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode SERVICELINE               (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode BMONTH                    (-9 -8 -6 -5=.)
recode BYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRMONTH2                  (-9 -8 -6 -5=.)
recode PRMONTH3                  (-9 -8 -6 -5=.)
recode PRMONTH4                  (-9 -8 -6 -5=.)
recode PRMONTH5                  (-9 -8 -6 -5=.)
recode PRMONTH6                  (-9 -8 -6 -5=.)
recode PRMONTH7                  (-9 -8 -6 -5=.)
recode PRMONTH8                  (-9 -8 -6 -5=.)
recode PRMONTH9                  (-9 -8 -6 -5=.)
recode PRMONTH10                 (-9 -8 -6 -5=.)
recode PRMONTH11                 (-9 -8 -6 -5=.)
recode PRMONTH12                 (-9 -8 -6 -5=.)
recode PRMONTH13                 (-9 -8 -6 -5=.)
recode PRMONTH14                 (-9 -8 -6 -5=.)
recode PRMONTH15                 (-9 -8 -6 -5=.)
recode PRMONTH16                 (-9 -8 -6 -5=.)
recode PRMONTH17                 (-9 -8 -6 -5=.)
recode PRMONTH18                 (-9 -8 -6 -5=.)
recode PRMONTH19                 (-9 -8 -6 -5=.)
recode PRMONTH20                 (-9 -8 -6 -5=.)
recode PRMONTH21                 (-9 -8 -6 -5=.)
recode PRMONTH22                 (-9 -8 -6 -5=.)
recode PRMONTH23                 (-9 -8 -6 -5=.)
recode PRMONTH24                 (-9 -8 -6 -5=.)
recode PRMONTH25                 (-9 -8 -6 -5=.)
recode PRMONTH26                 (-9 -8 -6 -5=.)
recode PRMONTH27                 (-9 -8 -6 -5=.)
recode PRMONTH28                 (-9 -8 -6 -5=.)
recode PRMONTH29                 (-9 -8 -6 -5=.)
recode PRMONTH30                 (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)
recode PRYEAR2                   (-999 -888 -666=.)
recode PRYEAR3                   (-999 -888 -666=.)
recode PRYEAR4                   (-999 -888 -666=.)
recode PRYEAR5                   (-999 -888 -666=.)
recode PRYEAR6                   (-999 -888 -666=.)
recode PRYEAR7                   (-999 -888 -666=.)
recode PRYEAR8                   (-999 -888 -666=.)
recode PRYEAR9                   (-999 -888 -666=.)
recode PRYEAR10                  (-999 -888 -666=.)
recode PRYEAR11                  (-999 -888 -666=.)
recode PRYEAR12                  (-999 -888 -666=.)
recode PRYEAR13                  (-999 -888 -666=.)
recode PRYEAR14                  (-999 -888 -666=.)
recode PRYEAR15                  (-999 -888 -666=.)
recode PRYEAR16                  (-999 -888 -666=.)
recode PRYEAR17                  (-999 -888 -666=.)
recode PRYEAR18                  (-999 -888 -666=.)
recode PRYEAR19                  (-999 -888 -666=.)
recode PRYEAR20                  (-999 -888 -666=.)
recode PRYEAR21                  (-999 -888 -666=.)
recode PRYEAR22                  (-999 -888 -666=.)
recode PRYEAR23                  (-999 -888 -666=.)
recode PRYEAR24                  (-999 -888 -666=.)
recode PRYEAR25                  (-999 -888 -666=.)
recode PRYEAR26                  (-999 -888 -666=.)
recode PRYEAR27                  (-999 -888 -666=.)
recode PRYEAR28                  (-999 -888 -666=.)
recode PRYEAR29                  (-999 -888 -666=.)
recode PRYEAR30                  (-999 -888 -666=.)

save "MI_SID_2014_CORE.dta", replace
