/*****************************************************************************
* Creation Date: 02/07/2024   
* MA_SID_2021_CORE.Do
* This program will load the 2021 MA ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/*** Set available memory size ***/
set mem 500m

/*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***/
infix 3 firstlineoffile                            ///
      int    ADRG                         1-   3   ///
      byte   ADRGRISKMORTALITY            4-   5   ///
      byte   ADRGSEV                      6-   7   ///
      int    AGE                          8-  10   ///
      int    AGEMONTH                    11-  13   ///
      byte   AMDC                        14-  15   ///
      byte   AMONTH                      16-  17   ///
      byte   ASOURCE                     18-  19   ///
      str    ASOURCE_X                   20        ///
      str    ASOURCEUB92                 21        ///
      byte   ATYPE                       22-  23   ///
      byte   AWEEKEND                    24-  25   ///
      int    BWT                         26-  29   ///
      int    DaysBetweenVisits           30-  33   ///
      long   DaysToEvent                 34-  39   ///
      byte   DIED                        40-  41   ///
      str    DISP_X                      42-  43   ///
      byte   DISPUB04                    44-  45   ///
      byte   DISPUNIFORM                 46-  47   ///
      byte   DMONTH                      48-  49   ///
      byte   DNR                         50-  51   ///
      byte   DQTR                        52-  53   ///
      int    DRG                         54-  56   ///
      int    DRG_NoPOA                   57-  59   ///
      byte   DRGVER                      60-  61   ///
      str    DSHOSPID                    62-  78   ///
      str    DXPOA1                      79        ///
      str    DXPOA2                      80        ///
      str    DXPOA3                      81        ///
      str    DXPOA4                      82        ///
      str    DXPOA5                      83        ///
      str    DXPOA6                      84        ///
      str    DXPOA7                      85        ///
      str    DXPOA8                      86        ///
      str    DXPOA9                      87        ///
      str    DXPOA10                     88        ///
      str    DXPOA11                     89        ///
      str    DXPOA12                     90        ///
      str    DXPOA13                     91        ///
      str    DXPOA14                     92        ///
      str    DXPOA15                     93        ///
      str    DXPOA16                     94        ///
      str    DXPOA17                     95        ///
      str    DXPOA18                     96        ///
      str    DXPOA19                     97        ///
      str    DXPOA20                     98        ///
      str    DXPOA21                     99        ///
      str    DXPOA22                    100        ///
      str    DXPOA23                    101        ///
      str    DXPOA24                    102        ///
      str    DXPOA25                    103        ///
      str    DXPOA26                    104        ///
      str    DXPOA27                    105        ///
      str    DXPOA28                    106        ///
      str    DXPOA29                    107        ///
      str    DXPOA30                    108        ///
      str    DXPOA31                    109        ///
      str    DXPOA32                    110        ///
      str    DXPOA33                    111        ///
      str    DXPOA34                    112        ///
      str    DXPOA35                    113        ///
      str    DXPOA36                    114        ///
      str    DXPOA37                    115        ///
      str    DXPOA38                    116        ///
      str    DXPOA39                    117        ///
      str    DXPOA40                    118        ///
      str    DXPOA41                    119        ///
      str    DXPOA42                    120        ///
      str    DXPOA43                    121        ///
      str    DXPOA44                    122        ///
      str    DXPOA45                    123        ///
      str    DXPOA46                    124        ///
      str    DXPOA47                    125        ///
      str    DXPOA48                    126        ///
      str    DXPOA49                    127        ///
      str    DXPOA50                    128        ///
      str    DXPOA51                    129        ///
      str    DXPOA52                    130        ///
      str    DXPOA53                    131        ///
      str    DXPOA54                    132        ///
      str    DXPOA55                    133        ///
      str    DXPOA56                    134        ///
      str    DXPOA57                    135        ///
      str    DXPOA58                    136        ///
      str    DXPOA59                    137        ///
      str    DXPOA60                    138        ///
      str    DXPOA61                    139        ///
      str    DXPOA62                    140        ///
      str    DXPOA63                    141        ///
      str    DXPOA64                    142        ///
      str    DXPOA65                    143        ///
      str    DXPOA66                    144        ///
      str    DXPOA67                    145        ///
      str    DXPOA68                    146        ///
      str    DXPOA69                    147        ///
      str    DXPOA70                    148        ///
      str    DXPOA71                    149        ///
      str    DXPOA72                    150        ///
      str    DXPOA73                    151        ///
      str    DXPOA74                    152        ///
      str    DXPOA75                    153        ///
      str    DXPOA76                    154        ///
      str    DXPOA77                    155        ///
      str    DXPOA78                    156        ///
      str    DXPOA79                    157        ///
      str    DXPOA80                    158        ///
      str    DXPOA81                    159        ///
      str    DXPOA82                    160        ///
      str    DXPOA83                    161        ///
      str    DXPOA84                    162        ///
      str    DXPOA85                    163        ///
      str    DXPOA86                    164        ///
      str    DXPOA87                    165        ///
      str    DXPOA88                    166        ///
      str    DXPOA89                    167        ///
      str    DXPOA90                    168        ///
      str    DXPOA91                    169        ///
      str    DXPOA92                    170        ///
      str    DXPOA93                    171        ///
      str    DXPOA94                    172        ///
      str    DXPOA95                    173        ///
      str    DXPOA96                    174        ///
      byte   FEMALE                     175- 176   ///
      byte   HCUP_ED                    177- 178   ///
      byte   HCUP_OS                    179- 180   ///
      byte   HISPANIC                   181- 182   ///
      str    HISPANIC_X                 183- 197   ///
      byte   Homeless                   198- 199   ///
      str    HOSPST                     200- 201   ///
      int    I10_BIRTH                  202- 204   ///
      int    I10_DELIVERY               205- 207   ///
      str    I10_DX_Admitting           208- 214   ///
      str    I10_DX1                    215- 221   ///
      str    I10_DX2                    222- 228   ///
      str    I10_DX3                    229- 235   ///
      str    I10_DX4                    236- 242   ///
      str    I10_DX5                    243- 249   ///
      str    I10_DX6                    250- 256   ///
      str    I10_DX7                    257- 263   ///
      str    I10_DX8                    264- 270   ///
      str    I10_DX9                    271- 277   ///
      str    I10_DX10                   278- 284   ///
      str    I10_DX11                   285- 291   ///
      str    I10_DX12                   292- 298   ///
      str    I10_DX13                   299- 305   ///
      str    I10_DX14                   306- 312   ///
      str    I10_DX15                   313- 319   ///
      str    I10_DX16                   320- 326   ///
      str    I10_DX17                   327- 333   ///
      str    I10_DX18                   334- 340   ///
      str    I10_DX19                   341- 347   ///
      str    I10_DX20                   348- 354   ///
      str    I10_DX21                   355- 361   ///
      str    I10_DX22                   362- 368   ///
      str    I10_DX23                   369- 375   ///
      str    I10_DX24                   376- 382   ///
      str    I10_DX25                   383- 389   ///
      str    I10_DX26                   390- 396   ///
      str    I10_DX27                   397- 403   ///
      str    I10_DX28                   404- 410   ///
      str    I10_DX29                   411- 417   ///
      str    I10_DX30                   418- 424   ///
      str    I10_DX31                   425- 431   ///
      str    I10_DX32                   432- 438   ///
      str    I10_DX33                   439- 445   ///
      str    I10_DX34                   446- 452   ///
      str    I10_DX35                   453- 459   ///
      str    I10_DX36                   460- 466   ///
      str    I10_DX37                   467- 473   ///
      str    I10_DX38                   474- 480   ///
      str    I10_DX39                   481- 487   ///
      str    I10_DX40                   488- 494   ///
      str    I10_DX41                   495- 501   ///
      str    I10_DX42                   502- 508   ///
      str    I10_DX43                   509- 515   ///
      str    I10_DX44                   516- 522   ///
      str    I10_DX45                   523- 529   ///
      str    I10_DX46                   530- 536   ///
      str    I10_DX47                   537- 543   ///
      str    I10_DX48                   544- 550   ///
      str    I10_DX49                   551- 557   ///
      str    I10_DX50                   558- 564   ///
      str    I10_DX51                   565- 571   ///
      str    I10_DX52                   572- 578   ///
      str    I10_DX53                   579- 585   ///
      str    I10_DX54                   586- 592   ///
      str    I10_DX55                   593- 599   ///
      str    I10_DX56                   600- 606   ///
      str    I10_DX57                   607- 613   ///
      str    I10_DX58                   614- 620   ///
      str    I10_DX59                   621- 627   ///
      str    I10_DX60                   628- 634   ///
      str    I10_DX61                   635- 641   ///
      str    I10_DX62                   642- 648   ///
      str    I10_DX63                   649- 655   ///
      str    I10_DX64                   656- 662   ///
      str    I10_DX65                   663- 669   ///
      str    I10_DX66                   670- 676   ///
      str    I10_DX67                   677- 683   ///
      str    I10_DX68                   684- 690   ///
      str    I10_DX69                   691- 697   ///
      str    I10_DX70                   698- 704   ///
      str    I10_DX71                   705- 711   ///
      str    I10_DX72                   712- 718   ///
      str    I10_DX73                   719- 725   ///
      str    I10_DX74                   726- 732   ///
      str    I10_DX75                   733- 739   ///
      str    I10_DX76                   740- 746   ///
      str    I10_DX77                   747- 753   ///
      str    I10_DX78                   754- 760   ///
      str    I10_DX79                   761- 767   ///
      str    I10_DX80                   768- 774   ///
      str    I10_DX81                   775- 781   ///
      str    I10_DX82                   782- 788   ///
      str    I10_DX83                   789- 795   ///
      str    I10_DX84                   796- 802   ///
      str    I10_DX85                   803- 809   ///
      str    I10_DX86                   810- 816   ///
      str    I10_DX87                   817- 823   ///
      str    I10_DX88                   824- 830   ///
      str    I10_DX89                   831- 837   ///
      str    I10_DX90                   838- 844   ///
      str    I10_DX91                   845- 851   ///
      str    I10_DX92                   852- 858   ///
      str    I10_DX93                   859- 865   ///
      str    I10_DX94                   866- 872   ///
      str    I10_DX95                   873- 879   ///
      str    I10_DX96                   880- 886   ///
      int    I10_NDX                    887- 889   ///
      int    I10_NPR                    890- 892   ///
      str    I10_PR1                    893- 899   ///
      str    I10_PR2                    900- 906   ///
      str    I10_PR3                    907- 913   ///
      str    I10_PR4                    914- 920   ///
      str    I10_PR5                    921- 927   ///
      str    I10_PR6                    928- 934   ///
      str    I10_PR7                    935- 941   ///
      str    I10_PR8                    942- 948   ///
      str    I10_PR9                    949- 955   ///
      str    I10_PR10                   956- 962   ///
      str    I10_PR11                   963- 969   ///
      str    I10_PR12                   970- 976   ///
      str    I10_PR13                   977- 983   ///
      str    I10_PR14                   984- 990   ///
      str    I10_PR15                   991- 997   ///
      str    I10_PR16                   998-1004   ///
      str    I10_PR17                  1005-1011   ///
      str    I10_PR18                  1012-1018   ///
      str    I10_PR19                  1019-1025   ///
      str    I10_PR20                  1026-1032   ///
      str    I10_PR21                  1033-1039   ///
      str    I10_PR22                  1040-1046   ///
      str    I10_PR23                  1047-1053   ///
      str    I10_PR24                  1054-1060   ///
      str    I10_PR25                  1061-1067   ///
      str    I10_PR26                  1068-1074   ///
      str    I10_PR27                  1075-1081   ///
      str    I10_PR28                  1082-1088   ///
      str    I10_PR29                  1089-1095   ///
      str    I10_PR30                  1096-1102   ///
      str    I10_PR31                  1103-1109   ///
      str    I10_PR32                  1110-1116   ///
      str    I10_PR33                  1117-1123   ///
      str    I10_PR34                  1124-1130   ///
      str    I10_PR35                  1131-1137   ///
      str    I10_PR36                  1138-1144   ///
      str    I10_PR37                  1145-1151   ///
      str    I10_PR38                  1152-1158   ///
      str    I10_PR39                  1159-1165   ///
      str    I10_PR40                  1166-1172   ///
      str    I10_PR41                  1173-1179   ///
      str    I10_PR42                  1180-1186   ///
      str    I10_PR43                  1187-1193   ///
      str    I10_PR44                  1194-1200   ///
      str    I10_PR45                  1201-1207   ///
      str    I10_PR46                  1208-1214   ///
      str    I10_PR47                  1215-1221   ///
      str    I10_PR48                  1222-1228   ///
      str    I10_PR49                  1229-1235   ///
      str    I10_PR50                  1236-1242   ///
      str    I10_PR51                  1243-1249   ///
      str    I10_PR52                  1250-1256   ///
      str    I10_PR53                  1257-1263   ///
      str    I10_PR54                  1264-1270   ///
      str    I10_PR55                  1271-1277   ///
      str    I10_PR56                  1278-1284   ///
      str    I10_PR57                  1285-1291   ///
      str    I10_PR58                  1292-1298   ///
      str    I10_PR59                  1299-1305   ///
      str    I10_PR60                  1306-1312   ///
      str    I10_PR61                  1313-1319   ///
      str    I10_PR62                  1320-1326   ///
      str    I10_PR63                  1327-1333   ///
      str    I10_PR64                  1334-1340   ///
      str    I10_PR65                  1341-1347   ///
      str    I10_PR66                  1348-1354   ///
      str    I10_PR67                  1355-1361   ///
      str    I10_PR68                  1362-1368   ///
      str    I10_PR69                  1369-1375   ///
      str    I10_PR70                  1376-1382   ///
      str    I10_PR71                  1383-1389   ///
      str    I10_PR72                  1390-1396   ///
      str    I10_PR73                  1397-1403   ///
      str    I10_PR74                  1404-1410   ///
      str    I10_PR75                  1411-1417   ///
      str    I10_PR76                  1418-1424   ///
      str    I10_PR77                  1425-1431   ///
      str    I10_PR78                  1432-1438   ///
      str    I10_PR79                  1439-1445   ///
      str    I10_PR80                  1446-1452   ///
      str    I10_PR81                  1453-1459   ///
      str    I10_PR82                  1460-1466   ///
      str    I10_PR83                  1467-1473   ///
      str    I10_PR84                  1474-1480   ///
      str    I10_PR85                  1481-1487   ///
      str    I10_PR86                  1488-1494   ///
      str    I10_PR87                  1495-1501   ///
      str    I10_PR88                  1502-1508   ///
      str    I10_PR89                  1509-1515   ///
      str    I10_PR90                  1516-1522   ///
      str    I10_PR91                  1523-1529   ///
      str    I10_PR92                  1530-1536   ///
      str    I10_PR93                  1537-1543   ///
      str    I10_PR94                  1544-1550   ///
      str    I10_PR95                  1551-1557   ///
      str    I10_PR96                  1558-1564   ///
      str    I10_PR97                  1565-1571   ///
      str    I10_PR98                  1572-1578   ///
      str    I10_PR99                  1579-1585   ///
      str    I10_PR100                 1586-1592   ///
      str    I10_PR101                 1593-1599   ///
      str    I10_PR102                 1600-1606   ///
      str    I10_PR103                 1607-1613   ///
      str    I10_PR104                 1614-1620   ///
      str    I10_PR105                 1621-1627   ///
      str    I10_PR106                 1628-1634   ///
      str    I10_PR107                 1635-1641   ///
      str    I10_PR108                 1642-1648   ///
      str    I10_PR109                 1649-1655   ///
      str    I10_PR110                 1656-1662   ///
      str    I10_PR111                 1663-1669   ///
      str    I10_PR112                 1670-1676   ///
      str    I10_PR113                 1677-1683   ///
      str    I10_PR114                 1684-1690   ///
      str    I10_PR115                 1691-1697   ///
      str    I10_PR116                 1698-1704   ///
      str    I10_PR117                 1705-1711   ///
      str    I10_PR118                 1712-1718   ///
      str    I10_PR119                 1719-1725   ///
      str    I10_PR120                 1726-1732   ///
      str    I10_PR121                 1733-1739   ///
      str    I10_PR122                 1740-1746   ///
      str    I10_PR123                 1747-1753   ///
      str    I10_PR124                 1754-1760   ///
      str    I10_PR125                 1761-1767   ///
      str    I10_PR126                 1768-1774   ///
      str    I10_PR127                 1775-1781   ///
      str    I10_PR128                 1782-1788   ///
      str    I10_PR129                 1789-1795   ///
      str    I10_PR130                 1796-1802   ///
      str    I10_PR131                 1803-1809   ///
      str    I10_PR132                 1810-1816   ///
      str    I10_PR133                 1817-1823   ///
      str    I10_PR134                 1824-1830   ///
      str    I10_PR135                 1831-1837   ///
      str    I10_PR136                 1838-1844   ///
      str    I10_PR137                 1845-1851   ///
      str    I10_PR138                 1852-1858   ///
      str    I10_PR139                 1859-1865   ///
      str    I10_PR140                 1866-1872   ///
      str    I10_PR141                 1873-1879   ///
      str    I10_PR142                 1880-1886   ///
      str    I10_PR143                 1887-1893   ///
      str    I10_PR144                 1894-1900   ///
      str    I10_PR145                 1901-1907   ///
      str    I10_PR146                 1908-1914   ///
      str    I10_PR147                 1915-1921   ///
      str    I10_PR148                 1922-1928   ///
      str    I10_PR149                 1929-1935   ///
      str    I10_PR150                 1936-1942   ///
      str    I10_PR151                 1943-1949   ///
      str    I10_PR152                 1950-1956   ///
      str    I10_PR153                 1957-1963   ///
      str    I10_PR154                 1964-1970   ///
      str    I10_PR155                 1971-1977   ///
      str    I10_PR156                 1978-1984   ///
      str    I10_PR157                 1985-1991   ///
      str    I10_PR158                 1992-1998   ///
      str    I10_PR159                 1999-2005   ///
      str    I10_PR160                 2006-2012   ///
      str    I10_PR161                 2013-2019   ///
      str    I10_PR162                 2020-2026   ///
      str    I10_PR163                 2027-2033   ///
      str    I10_PR164                 2034-2040   ///
      str    I10_PR165                 2041-2047   ///
      str    I10_PR166                 2048-2054   ///
      str    I10_PR167                 2055-2061   ///
      str    I10_PR168                 2062-2068   ///
      str    I10_PR169                 2069-2075   ///
      str    I10_PR170                 2076-2082   ///
      str    I10_PR171                 2083-2089   ///
      str    I10_PR172                 2090-2096   ///
      str    I10_PR173                 2097-2103   ///
      str    I10_PR174                 2104-2110   ///
      str    I10_PR175                 2111-2117   ///
      str    I10_PR176                 2118-2124   ///
      str    I10_PR177                 2125-2131   ///
      str    I10_PR178                 2132-2138   ///
      str    I10_PR179                 2139-2145   ///
      str    I10_PR180                 2146-2152   ///
      str    I10_PR181                 2153-2159   ///
      str    I10_PR182                 2160-2166   ///
      str    I10_PR183                 2167-2173   ///
      str    I10_PR184                 2174-2180   ///
      str    I10_PR185                 2181-2187   ///
      str    I10_PR186                 2188-2194   ///
      str    I10_PR187                 2195-2201   ///
      str    I10_PR188                 2202-2208   ///
      str    I10_PR189                 2209-2215   ///
      str    I10_PR190                 2216-2222   ///
      str    I10_PR191                 2223-2229   ///
      str    I10_PR192                 2230-2236   ///
      str    I10_PR193                 2237-2243   ///
      str    I10_PR194                 2244-2250   ///
      str    I10_PR195                 2251-2257   ///
      str    I10_PR196                 2258-2264   ///
      str    I10_PR197                 2265-2271   ///
      str    I10_PR198                 2272-2278   ///
      str    I10_PR199                 2279-2285   ///
      str    I10_PR200                 2286-2292   ///
      int    I10_PROCTYPE              2293-2295   ///
      byte   I10_SERVICELINE           2296-2297   ///
      double KEY                       2298-2312   ///
      long   LOS                       2313-2317   ///
      long   LOS_X                     2318-2323   ///
      byte   MDC                       2324-2325   ///
      byte   MDC_NoPOA                 2326-2327   ///
      byte   MEDINCSTQ                 2328-2329   ///
      double OS_TIME                   2330-2340   ///
      byte   PAY1                      2341-2342   ///
      str    PAY1_X                    2343        ///
      byte   PAY2                      2344-2345   ///
      str    PAY2_X                    2346        ///
      str    PAYER1_X                  2347-2349   ///
      str    PAYER2_X                  2350-2352   ///
      byte   PCLASS_ORPROC             2353-2354   ///
      int    PL_CBSA                   2355-2357   ///
      byte   PL_UR_CAT4                2358-2359   ///
      byte   POA_Disch_Edit1           2360-2361   ///
      byte   POA_Disch_Edit2           2362-2363   ///
      byte   POA_Hosp_Edit1            2364-2365   ///
      byte   POA_Hosp_Edit2            2366-2367   ///
      byte   POA_Hosp_Edit3            2368-2369   ///
      double POA_Hosp_Edit3_Value      2370-2377   ///
      long   PRDAY1                    2378-2382   ///
      long   PRDAY2                    2383-2387   ///
      long   PRDAY3                    2388-2392   ///
      long   PRDAY4                    2393-2397   ///
      long   PRDAY5                    2398-2402   ///
      long   PRDAY6                    2403-2407   ///
      long   PRDAY7                    2408-2412   ///
      long   PRDAY8                    2413-2417   ///
      long   PRDAY9                    2418-2422   ///
      long   PRDAY10                   2423-2427   ///
      long   PRDAY11                   2428-2432   ///
      long   PRDAY12                   2433-2437   ///
      long   PRDAY13                   2438-2442   ///
      long   PRDAY14                   2443-2447   ///
      long   PRDAY15                   2448-2452   ///
      long   PRDAY16                   2453-2457   ///
      long   PRDAY17                   2458-2462   ///
      long   PRDAY18                   2463-2467   ///
      long   PRDAY19                   2468-2472   ///
      long   PRDAY20                   2473-2477   ///
      long   PRDAY21                   2478-2482   ///
      long   PRDAY22                   2483-2487   ///
      long   PRDAY23                   2488-2492   ///
      long   PRDAY24                   2493-2497   ///
      long   PRDAY25                   2498-2502   ///
      long   PRDAY26                   2503-2507   ///
      long   PRDAY27                   2508-2512   ///
      long   PRDAY28                   2513-2517   ///
      long   PRDAY29                   2518-2522   ///
      long   PRDAY30                   2523-2527   ///
      long   PRDAY31                   2528-2532   ///
      long   PRDAY32                   2533-2537   ///
      long   PRDAY33                   2538-2542   ///
      long   PRDAY34                   2543-2547   ///
      long   PRDAY35                   2548-2552   ///
      long   PRDAY36                   2553-2557   ///
      long   PRDAY37                   2558-2562   ///
      long   PRDAY38                   2563-2567   ///
      long   PRDAY39                   2568-2572   ///
      long   PRDAY40                   2573-2577   ///
      long   PRDAY41                   2578-2582   ///
      long   PRDAY42                   2583-2587   ///
      long   PRDAY43                   2588-2592   ///
      long   PRDAY44                   2593-2597   ///
      long   PRDAY45                   2598-2602   ///
      long   PRDAY46                   2603-2607   ///
      long   PRDAY47                   2608-2612   ///
      long   PRDAY48                   2613-2617   ///
      long   PRDAY49                   2618-2622   ///
      long   PRDAY50                   2623-2627   ///
      long   PRDAY51                   2628-2632   ///
      long   PRDAY52                   2633-2637   ///
      long   PRDAY53                   2638-2642   ///
      long   PRDAY54                   2643-2647   ///
      long   PRDAY55                   2648-2652   ///
      long   PRDAY56                   2653-2657   ///
      long   PRDAY57                   2658-2662   ///
      long   PRDAY58                   2663-2667   ///
      long   PRDAY59                   2668-2672   ///
      long   PRDAY60                   2673-2677   ///
      long   PRDAY61                   2678-2682   ///
      long   PRDAY62                   2683-2687   ///
      long   PRDAY63                   2688-2692   ///
      long   PRDAY64                   2693-2697   ///
      long   PRDAY65                   2698-2702   ///
      long   PRDAY66                   2703-2707   ///
      long   PRDAY67                   2708-2712   ///
      long   PRDAY68                   2713-2717   ///
      long   PRDAY69                   2718-2722   ///
      long   PRDAY70                   2723-2727   ///
      long   PRDAY71                   2728-2732   ///
      long   PRDAY72                   2733-2737   ///
      long   PRDAY73                   2738-2742   ///
      long   PRDAY74                   2743-2747   ///
      long   PRDAY75                   2748-2752   ///
      long   PRDAY76                   2753-2757   ///
      long   PRDAY77                   2758-2762   ///
      long   PRDAY78                   2763-2767   ///
      long   PRDAY79                   2768-2772   ///
      long   PRDAY80                   2773-2777   ///
      long   PRDAY81                   2778-2782   ///
      long   PRDAY82                   2783-2787   ///
      long   PRDAY83                   2788-2792   ///
      long   PRDAY84                   2793-2797   ///
      long   PRDAY85                   2798-2802   ///
      long   PRDAY86                   2803-2807   ///
      long   PRDAY87                   2808-2812   ///
      long   PRDAY88                   2813-2817   ///
      long   PRDAY89                   2818-2822   ///
      long   PRDAY90                   2823-2827   ///
      long   PRDAY91                   2828-2832   ///
      long   PRDAY92                   2833-2837   ///
      long   PRDAY93                   2838-2842   ///
      long   PRDAY94                   2843-2847   ///
      long   PRDAY95                   2848-2852   ///
      long   PRDAY96                   2853-2857   ///
      long   PRDAY97                   2858-2862   ///
      long   PRDAY98                   2863-2867   ///
      long   PRDAY99                   2868-2872   ///
      long   PRDAY100                  2873-2877   ///
      long   PRDAY101                  2878-2882   ///
      long   PRDAY102                  2883-2887   ///
      long   PRDAY103                  2888-2892   ///
      long   PRDAY104                  2893-2897   ///
      long   PRDAY105                  2898-2902   ///
      long   PRDAY106                  2903-2907   ///
      long   PRDAY107                  2908-2912   ///
      long   PRDAY108                  2913-2917   ///
      long   PRDAY109                  2918-2922   ///
      long   PRDAY110                  2923-2927   ///
      long   PRDAY111                  2928-2932   ///
      long   PRDAY112                  2933-2937   ///
      long   PRDAY113                  2938-2942   ///
      long   PRDAY114                  2943-2947   ///
      long   PRDAY115                  2948-2952   ///
      long   PRDAY116                  2953-2957   ///
      long   PRDAY117                  2958-2962   ///
      long   PRDAY118                  2963-2967   ///
      long   PRDAY119                  2968-2972   ///
      long   PRDAY120                  2973-2977   ///
      long   PRDAY121                  2978-2982   ///
      long   PRDAY122                  2983-2987   ///
      long   PRDAY123                  2988-2992   ///
      long   PRDAY124                  2993-2997   ///
      long   PRDAY125                  2998-3002   ///
      long   PRDAY126                  3003-3007   ///
      long   PRDAY127                  3008-3012   ///
      long   PRDAY128                  3013-3017   ///
      long   PRDAY129                  3018-3022   ///
      long   PRDAY130                  3023-3027   ///
      long   PRDAY131                  3028-3032   ///
      long   PRDAY132                  3033-3037   ///
      long   PRDAY133                  3038-3042   ///
      long   PRDAY134                  3043-3047   ///
      long   PRDAY135                  3048-3052   ///
      long   PRDAY136                  3053-3057   ///
      long   PRDAY137                  3058-3062   ///
      long   PRDAY138                  3063-3067   ///
      long   PRDAY139                  3068-3072   ///
      long   PRDAY140                  3073-3077   ///
      long   PRDAY141                  3078-3082   ///
      long   PRDAY142                  3083-3087   ///
      long   PRDAY143                  3088-3092   ///
      long   PRDAY144                  3093-3097   ///
      long   PRDAY145                  3098-3102   ///
      long   PRDAY146                  3103-3107   ///
      long   PRDAY147                  3108-3112   ///
      long   PRDAY148                  3113-3117   ///
      long   PRDAY149                  3118-3122   ///
      long   PRDAY150                  3123-3127   ///
      long   PRDAY151                  3128-3132   ///
      long   PRDAY152                  3133-3137   ///
      long   PRDAY153                  3138-3142   ///
      long   PRDAY154                  3143-3147   ///
      long   PRDAY155                  3148-3152   ///
      long   PRDAY156                  3153-3157   ///
      long   PRDAY157                  3158-3162   ///
      long   PRDAY158                  3163-3167   ///
      long   PRDAY159                  3168-3172   ///
      long   PRDAY160                  3173-3177   ///
      long   PRDAY161                  3178-3182   ///
      long   PRDAY162                  3183-3187   ///
      long   PRDAY163                  3188-3192   ///
      long   PRDAY164                  3193-3197   ///
      long   PRDAY165                  3198-3202   ///
      long   PRDAY166                  3203-3207   ///
      long   PRDAY167                  3208-3212   ///
      long   PRDAY168                  3213-3217   ///
      long   PRDAY169                  3218-3222   ///
      long   PRDAY170                  3223-3227   ///
      long   PRDAY171                  3228-3232   ///
      long   PRDAY172                  3233-3237   ///
      long   PRDAY173                  3238-3242   ///
      long   PRDAY174                  3243-3247   ///
      long   PRDAY175                  3248-3252   ///
      long   PRDAY176                  3253-3257   ///
      long   PRDAY177                  3258-3262   ///
      long   PRDAY178                  3263-3267   ///
      long   PRDAY179                  3268-3272   ///
      long   PRDAY180                  3273-3277   ///
      long   PRDAY181                  3278-3282   ///
      long   PRDAY182                  3283-3287   ///
      long   PRDAY183                  3288-3292   ///
      long   PRDAY184                  3293-3297   ///
      long   PRDAY185                  3298-3302   ///
      long   PRDAY186                  3303-3307   ///
      long   PRDAY187                  3308-3312   ///
      long   PRDAY188                  3313-3317   ///
      long   PRDAY189                  3318-3322   ///
      long   PRDAY190                  3323-3327   ///
      long   PRDAY191                  3328-3332   ///
      long   PRDAY192                  3333-3337   ///
      long   PRDAY193                  3338-3342   ///
      long   PRDAY194                  3343-3347   ///
      long   PRDAY195                  3348-3352   ///
      long   PRDAY196                  3353-3357   ///
      long   PRDAY197                  3358-3362   ///
      long   PRDAY198                  3363-3367   ///
      long   PRDAY199                  3368-3372   ///
      long   PRDAY200                  3373-3377   ///
      str    PSTATE                    3378-3379   ///
      str    PSTATE_GEO                3380-3381   ///
      long   PSTCO_GEO                 3382-3386   ///
      byte   RACE                      3387-3388   ///
      float  RACE_PCT_MISS_HOSP        3389-3395   ///
      str    RACE_X                    3396-3408   ///
      double TOTCHG                    3409-3418   ///
      double TOTCHG_X                  3419-3433   ///
      byte   TRAN_IN                   3434-3435   ///
      byte   TRAN_OUT                  3436-3437   ///
      long   VisitLink                 3438-3446   ///
      int    YEAR                      3447-3450   ///
      str    ZIP3                      3451-3453   ///
      int    ZIPINC_QRTL               3454-3456   ///
      int    AYEAR                     3457-3460   ///
      byte   PRMONTH1                  3461-3462   ///
      byte   PRMONTH2                  3463-3464   ///
      byte   PRMONTH3                  3465-3466   ///
      byte   PRMONTH4                  3467-3468   ///
      byte   PRMONTH5                  3469-3470   ///
      byte   PRMONTH6                  3471-3472   ///
      byte   PRMONTH7                  3473-3474   ///
      byte   PRMONTH8                  3475-3476   ///
      byte   PRMONTH9                  3477-3478   ///
      byte   PRMONTH10                 3479-3480   ///
      byte   PRMONTH11                 3481-3482   ///
      byte   PRMONTH12                 3483-3484   ///
      byte   PRMONTH13                 3485-3486   ///
      byte   PRMONTH14                 3487-3488   ///
      byte   PRMONTH15                 3489-3490   ///
      byte   PRMONTH16                 3491-3492   ///
      byte   PRMONTH17                 3493-3494   ///
      byte   PRMONTH18                 3495-3496   ///
      byte   PRMONTH19                 3497-3498   ///
      byte   PRMONTH20                 3499-3500   ///
      byte   PRMONTH21                 3501-3502   ///
      byte   PRMONTH22                 3503-3504   ///
      byte   PRMONTH23                 3505-3506   ///
      byte   PRMONTH24                 3507-3508   ///
      byte   PRMONTH25                 3509-3510   ///
      byte   PRMONTH26                 3511-3512   ///
      byte   PRMONTH27                 3513-3514   ///
      byte   PRMONTH28                 3515-3516   ///
      byte   PRMONTH29                 3517-3518   ///
      byte   PRMONTH30                 3519-3520   ///
      byte   PRMONTH31                 3521-3522   ///
      byte   PRMONTH32                 3523-3524   ///
      byte   PRMONTH33                 3525-3526   ///
      byte   PRMONTH34                 3527-3528   ///
      byte   PRMONTH35                 3529-3530   ///
      byte   PRMONTH36                 3531-3532   ///
      byte   PRMONTH37                 3533-3534   ///
      byte   PRMONTH38                 3535-3536   ///
      byte   PRMONTH39                 3537-3538   ///
      byte   PRMONTH40                 3539-3540   ///
      byte   PRMONTH41                 3541-3542   ///
      byte   PRMONTH42                 3543-3544   ///
      byte   PRMONTH43                 3545-3546   ///
      byte   PRMONTH44                 3547-3548   ///
      byte   PRMONTH45                 3549-3550   ///
      byte   PRMONTH46                 3551-3552   ///
      byte   PRMONTH47                 3553-3554   ///
      byte   PRMONTH48                 3555-3556   ///
      byte   PRMONTH49                 3557-3558   ///
      byte   PRMONTH50                 3559-3560   ///
      byte   PRMONTH51                 3561-3562   ///
      byte   PRMONTH52                 3563-3564   ///
      byte   PRMONTH53                 3565-3566   ///
      byte   PRMONTH54                 3567-3568   ///
      byte   PRMONTH55                 3569-3570   ///
      byte   PRMONTH56                 3571-3572   ///
      byte   PRMONTH57                 3573-3574   ///
      byte   PRMONTH58                 3575-3576   ///
      byte   PRMONTH59                 3577-3578   ///
      byte   PRMONTH60                 3579-3580   ///
      byte   PRMONTH61                 3581-3582   ///
      byte   PRMONTH62                 3583-3584   ///
      byte   PRMONTH63                 3585-3586   ///
      byte   PRMONTH64                 3587-3588   ///
      byte   PRMONTH65                 3589-3590   ///
      byte   PRMONTH66                 3591-3592   ///
      byte   PRMONTH67                 3593-3594   ///
      byte   PRMONTH68                 3595-3596   ///
      byte   PRMONTH69                 3597-3598   ///
      byte   PRMONTH70                 3599-3600   ///
      byte   PRMONTH71                 3601-3602   ///
      byte   PRMONTH72                 3603-3604   ///
      byte   PRMONTH73                 3605-3606   ///
      byte   PRMONTH74                 3607-3608   ///
      byte   PRMONTH75                 3609-3610   ///
      byte   PRMONTH76                 3611-3612   ///
      byte   PRMONTH77                 3613-3614   ///
      byte   PRMONTH78                 3615-3616   ///
      byte   PRMONTH79                 3617-3618   ///
      byte   PRMONTH80                 3619-3620   ///
      byte   PRMONTH81                 3621-3622   ///
      byte   PRMONTH82                 3623-3624   ///
      byte   PRMONTH83                 3625-3626   ///
      byte   PRMONTH84                 3627-3628   ///
      byte   PRMONTH85                 3629-3630   ///
      byte   PRMONTH86                 3631-3632   ///
      byte   PRMONTH87                 3633-3634   ///
      byte   PRMONTH88                 3635-3636   ///
      byte   PRMONTH89                 3637-3638   ///
      byte   PRMONTH90                 3639-3640   ///
      byte   PRMONTH91                 3641-3642   ///
      byte   PRMONTH92                 3643-3644   ///
      byte   PRMONTH93                 3645-3646   ///
      byte   PRMONTH94                 3647-3648   ///
      byte   PRMONTH95                 3649-3650   ///
      byte   PRMONTH96                 3651-3652   ///
      byte   PRMONTH97                 3653-3654   ///
      byte   PRMONTH98                 3655-3656   ///
      byte   PRMONTH99                 3657-3658   ///
      byte   PRMONTH100                3659-3660   ///
      byte   PRMONTH101                3661-3662   ///
      byte   PRMONTH102                3663-3664   ///
      byte   PRMONTH103                3665-3666   ///
      byte   PRMONTH104                3667-3668   ///
      byte   PRMONTH105                3669-3670   ///
      byte   PRMONTH106                3671-3672   ///
      byte   PRMONTH107                3673-3674   ///
      byte   PRMONTH108                3675-3676   ///
      byte   PRMONTH109                3677-3678   ///
      byte   PRMONTH110                3679-3680   ///
      byte   PRMONTH111                3681-3682   ///
      byte   PRMONTH112                3683-3684   ///
      byte   PRMONTH113                3685-3686   ///
      byte   PRMONTH114                3687-3688   ///
      byte   PRMONTH115                3689-3690   ///
      byte   PRMONTH116                3691-3692   ///
      byte   PRMONTH117                3693-3694   ///
      byte   PRMONTH118                3695-3696   ///
      byte   PRMONTH119                3697-3698   ///
      byte   PRMONTH120                3699-3700   ///
      byte   PRMONTH121                3701-3702   ///
      byte   PRMONTH122                3703-3704   ///
      byte   PRMONTH123                3705-3706   ///
      byte   PRMONTH124                3707-3708   ///
      byte   PRMONTH125                3709-3710   ///
      byte   PRMONTH126                3711-3712   ///
      byte   PRMONTH127                3713-3714   ///
      byte   PRMONTH128                3715-3716   ///
      byte   PRMONTH129                3717-3718   ///
      byte   PRMONTH130                3719-3720   ///
      byte   PRMONTH131                3721-3722   ///
      byte   PRMONTH132                3723-3724   ///
      byte   PRMONTH133                3725-3726   ///
      byte   PRMONTH134                3727-3728   ///
      byte   PRMONTH135                3729-3730   ///
      byte   PRMONTH136                3731-3732   ///
      byte   PRMONTH137                3733-3734   ///
      byte   PRMONTH138                3735-3736   ///
      byte   PRMONTH139                3737-3738   ///
      byte   PRMONTH140                3739-3740   ///
      byte   PRMONTH141                3741-3742   ///
      byte   PRMONTH142                3743-3744   ///
      byte   PRMONTH143                3745-3746   ///
      byte   PRMONTH144                3747-3748   ///
      byte   PRMONTH145                3749-3750   ///
      byte   PRMONTH146                3751-3752   ///
      byte   PRMONTH147                3753-3754   ///
      byte   PRMONTH148                3755-3756   ///
      byte   PRMONTH149                3757-3758   ///
      byte   PRMONTH150                3759-3760   ///
      byte   PRMONTH151                3761-3762   ///
      byte   PRMONTH152                3763-3764   ///
      byte   PRMONTH153                3765-3766   ///
      byte   PRMONTH154                3767-3768   ///
      byte   PRMONTH155                3769-3770   ///
      byte   PRMONTH156                3771-3772   ///
      byte   PRMONTH157                3773-3774   ///
      byte   PRMONTH158                3775-3776   ///
      byte   PRMONTH159                3777-3778   ///
      byte   PRMONTH160                3779-3780   ///
      byte   PRMONTH161                3781-3782   ///
      byte   PRMONTH162                3783-3784   ///
      byte   PRMONTH163                3785-3786   ///
      byte   PRMONTH164                3787-3788   ///
      byte   PRMONTH165                3789-3790   ///
      byte   PRMONTH166                3791-3792   ///
      byte   PRMONTH167                3793-3794   ///
      byte   PRMONTH168                3795-3796   ///
      byte   PRMONTH169                3797-3798   ///
      byte   PRMONTH170                3799-3800   ///
      byte   PRMONTH171                3801-3802   ///
      byte   PRMONTH172                3803-3804   ///
      byte   PRMONTH173                3805-3806   ///
      byte   PRMONTH174                3807-3808   ///
      byte   PRMONTH175                3809-3810   ///
      byte   PRMONTH176                3811-3812   ///
      byte   PRMONTH177                3813-3814   ///
      byte   PRMONTH178                3815-3816   ///
      byte   PRMONTH179                3817-3818   ///
      byte   PRMONTH180                3819-3820   ///
      byte   PRMONTH181                3821-3822   ///
      byte   PRMONTH182                3823-3824   ///
      byte   PRMONTH183                3825-3826   ///
      byte   PRMONTH184                3827-3828   ///
      byte   PRMONTH185                3829-3830   ///
      byte   PRMONTH186                3831-3832   ///
      byte   PRMONTH187                3833-3834   ///
      byte   PRMONTH188                3835-3836   ///
      byte   PRMONTH189                3837-3838   ///
      byte   PRMONTH190                3839-3840   ///
      byte   PRMONTH191                3841-3842   ///
      byte   PRMONTH192                3843-3844   ///
      byte   PRMONTH193                3845-3846   ///
      byte   PRMONTH194                3847-3848   ///
      byte   PRMONTH195                3849-3850   ///
      byte   PRMONTH196                3851-3852   ///
      byte   PRMONTH197                3853-3854   ///
      byte   PRMONTH198                3855-3856   ///
      byte   PRMONTH199                3857-3858   ///
      byte   PRMONTH200                3859-3860   ///
      int    PRYEAR1                   3861-3864   ///
      int    PRYEAR2                   3865-3868   ///
      int    PRYEAR3                   3869-3872   ///
      int    PRYEAR4                   3873-3876   ///
      int    PRYEAR5                   3877-3880   ///
      int    PRYEAR6                   3881-3884   ///
      int    PRYEAR7                   3885-3888   ///
      int    PRYEAR8                   3889-3892   ///
      int    PRYEAR9                   3893-3896   ///
      int    PRYEAR10                  3897-3900   ///
      int    PRYEAR11                  3901-3904   ///
      int    PRYEAR12                  3905-3908   ///
      int    PRYEAR13                  3909-3912   ///
      int    PRYEAR14                  3913-3916   ///
      int    PRYEAR15                  3917-3920   ///
      int    PRYEAR16                  3921-3924   ///
      int    PRYEAR17                  3925-3928   ///
      int    PRYEAR18                  3929-3932   ///
      int    PRYEAR19                  3933-3936   ///
      int    PRYEAR20                  3937-3940   ///
      int    PRYEAR21                  3941-3944   ///
      int    PRYEAR22                  3945-3948   ///
      int    PRYEAR23                  3949-3952   ///
      int    PRYEAR24                  3953-3956   ///
      int    PRYEAR25                  3957-3960   ///
      int    PRYEAR26                  3961-3964   ///
      int    PRYEAR27                  3965-3968   ///
      int    PRYEAR28                  3969-3972   ///
      int    PRYEAR29                  3973-3976   ///
      int    PRYEAR30                  3977-3980   ///
      int    PRYEAR31                  3981-3984   ///
      int    PRYEAR32                  3985-3988   ///
      int    PRYEAR33                  3989-3992   ///
      int    PRYEAR34                  3993-3996   ///
      int    PRYEAR35                  3997-4000   ///
      int    PRYEAR36                  4001-4004   ///
      int    PRYEAR37                  4005-4008   ///
      int    PRYEAR38                  4009-4012   ///
      int    PRYEAR39                  4013-4016   ///
      int    PRYEAR40                  4017-4020   ///
      int    PRYEAR41                  4021-4024   ///
      int    PRYEAR42                  4025-4028   ///
      int    PRYEAR43                  4029-4032   ///
      int    PRYEAR44                  4033-4036   ///
      int    PRYEAR45                  4037-4040   ///
      int    PRYEAR46                  4041-4044   ///
      int    PRYEAR47                  4045-4048   ///
      int    PRYEAR48                  4049-4052   ///
      int    PRYEAR49                  4053-4056   ///
      int    PRYEAR50                  4057-4060   ///
      int    PRYEAR51                  4061-4064   ///
      int    PRYEAR52                  4065-4068   ///
      int    PRYEAR53                  4069-4072   ///
      int    PRYEAR54                  4073-4076   ///
      int    PRYEAR55                  4077-4080   ///
      int    PRYEAR56                  4081-4084   ///
      int    PRYEAR57                  4085-4088   ///
      int    PRYEAR58                  4089-4092   ///
      int    PRYEAR59                  4093-4096   ///
      int    PRYEAR60                  4097-4100   ///
      int    PRYEAR61                  4101-4104   ///
      int    PRYEAR62                  4105-4108   ///
      int    PRYEAR63                  4109-4112   ///
      int    PRYEAR64                  4113-4116   ///
      int    PRYEAR65                  4117-4120   ///
      int    PRYEAR66                  4121-4124   ///
      int    PRYEAR67                  4125-4128   ///
      int    PRYEAR68                  4129-4132   ///
      int    PRYEAR69                  4133-4136   ///
      int    PRYEAR70                  4137-4140   ///
      int    PRYEAR71                  4141-4144   ///
      int    PRYEAR72                  4145-4148   ///
      int    PRYEAR73                  4149-4152   ///
      int    PRYEAR74                  4153-4156   ///
      int    PRYEAR75                  4157-4160   ///
      int    PRYEAR76                  4161-4164   ///
      int    PRYEAR77                  4165-4168   ///
      int    PRYEAR78                  4169-4172   ///
      int    PRYEAR79                  4173-4176   ///
      int    PRYEAR80                  4177-4180   ///
      int    PRYEAR81                  4181-4184   ///
      int    PRYEAR82                  4185-4188   ///
      int    PRYEAR83                  4189-4192   ///
      int    PRYEAR84                  4193-4196   ///
      int    PRYEAR85                  4197-4200   ///
      int    PRYEAR86                  4201-4204   ///
      int    PRYEAR87                  4205-4208   ///
      int    PRYEAR88                  4209-4212   ///
      int    PRYEAR89                  4213-4216   ///
      int    PRYEAR90                  4217-4220   ///
      int    PRYEAR91                  4221-4224   ///
      int    PRYEAR92                  4225-4228   ///
      int    PRYEAR93                  4229-4232   ///
      int    PRYEAR94                  4233-4236   ///
      int    PRYEAR95                  4237-4240   ///
      int    PRYEAR96                  4241-4244   ///
      int    PRYEAR97                  4245-4248   ///
      int    PRYEAR98                  4249-4252   ///
      int    PRYEAR99                  4253-4256   ///
      int    PRYEAR100                 4257-4260   ///
      int    PRYEAR101                 4261-4264   ///
      int    PRYEAR102                 4265-4268   ///
      int    PRYEAR103                 4269-4272   ///
      int    PRYEAR104                 4273-4276   ///
      int    PRYEAR105                 4277-4280   ///
      int    PRYEAR106                 4281-4284   ///
      int    PRYEAR107                 4285-4288   ///
      int    PRYEAR108                 4289-4292   ///
      int    PRYEAR109                 4293-4296   ///
      int    PRYEAR110                 4297-4300   ///
      int    PRYEAR111                 4301-4304   ///
      int    PRYEAR112                 4305-4308   ///
      int    PRYEAR113                 4309-4312   ///
      int    PRYEAR114                 4313-4316   ///
      int    PRYEAR115                 4317-4320   ///
      int    PRYEAR116                 4321-4324   ///
      int    PRYEAR117                 4325-4328   ///
      int    PRYEAR118                 4329-4332   ///
      int    PRYEAR119                 4333-4336   ///
      int    PRYEAR120                 4337-4340   ///
      int    PRYEAR121                 4341-4344   ///
      int    PRYEAR122                 4345-4348   ///
      int    PRYEAR123                 4349-4352   ///
      int    PRYEAR124                 4353-4356   ///
      int    PRYEAR125                 4357-4360   ///
      int    PRYEAR126                 4361-4364   ///
      int    PRYEAR127                 4365-4368   ///
      int    PRYEAR128                 4369-4372   ///
      int    PRYEAR129                 4373-4376   ///
      int    PRYEAR130                 4377-4380   ///
      int    PRYEAR131                 4381-4384   ///
      int    PRYEAR132                 4385-4388   ///
      int    PRYEAR133                 4389-4392   ///
      int    PRYEAR134                 4393-4396   ///
      int    PRYEAR135                 4397-4400   ///
      int    PRYEAR136                 4401-4404   ///
      int    PRYEAR137                 4405-4408   ///
      int    PRYEAR138                 4409-4412   ///
      int    PRYEAR139                 4413-4416   ///
      int    PRYEAR140                 4417-4420   ///
      int    PRYEAR141                 4421-4424   ///
      int    PRYEAR142                 4425-4428   ///
      int    PRYEAR143                 4429-4432   ///
      int    PRYEAR144                 4433-4436   ///
      int    PRYEAR145                 4437-4440   ///
      int    PRYEAR146                 4441-4444   ///
      int    PRYEAR147                 4445-4448   ///
      int    PRYEAR148                 4449-4452   ///
      int    PRYEAR149                 4453-4456   ///
      int    PRYEAR150                 4457-4460   ///
      int    PRYEAR151                 4461-4464   ///
      int    PRYEAR152                 4465-4468   ///
      int    PRYEAR153                 4469-4472   ///
      int    PRYEAR154                 4473-4476   ///
      int    PRYEAR155                 4477-4480   ///
      int    PRYEAR156                 4481-4484   ///
      int    PRYEAR157                 4485-4488   ///
      int    PRYEAR158                 4489-4492   ///
      int    PRYEAR159                 4493-4496   ///
      int    PRYEAR160                 4497-4500   ///
      int    PRYEAR161                 4501-4504   ///
      int    PRYEAR162                 4505-4508   ///
      int    PRYEAR163                 4509-4512   ///
      int    PRYEAR164                 4513-4516   ///
      int    PRYEAR165                 4517-4520   ///
      int    PRYEAR166                 4521-4524   ///
      int    PRYEAR167                 4525-4528   ///
      int    PRYEAR168                 4529-4532   ///
      int    PRYEAR169                 4533-4536   ///
      int    PRYEAR170                 4537-4540   ///
      int    PRYEAR171                 4541-4544   ///
      int    PRYEAR172                 4545-4548   ///
      int    PRYEAR173                 4549-4552   ///
      int    PRYEAR174                 4553-4556   ///
      int    PRYEAR175                 4557-4560   ///
      int    PRYEAR176                 4561-4564   ///
      int    PRYEAR177                 4565-4568   ///
      int    PRYEAR178                 4569-4572   ///
      int    PRYEAR179                 4573-4576   ///
      int    PRYEAR180                 4577-4580   ///
      int    PRYEAR181                 4581-4584   ///
      int    PRYEAR182                 4585-4588   ///
      int    PRYEAR183                 4589-4592   ///
      int    PRYEAR184                 4593-4596   ///
      int    PRYEAR185                 4597-4600   ///
      int    PRYEAR186                 4601-4604   ///
      int    PRYEAR187                 4605-4608   ///
      int    PRYEAR188                 4609-4612   ///
      int    PRYEAR189                 4613-4616   ///
      int    PRYEAR190                 4617-4620   ///
      int    PRYEAR191                 4621-4624   ///
      int    PRYEAR192                 4625-4628   ///
      int    PRYEAR193                 4629-4632   ///
      int    PRYEAR194                 4633-4636   ///
      int    PRYEAR195                 4637-4640   ///
      int    PRYEAR196                 4641-4644   ///
      int    PRYEAR197                 4645-4648   ///
      int    PRYEAR198                 4649-4652   ///
      int    PRYEAR199                 4653-4656   ///
      int    PRYEAR200                 4657-4660   ///
      using  "MA_SID_2021_CORE.asc"

/***  Assign labels to the data elements ***/
label var ADRG                     "All Patient Refined DRG"
label var ADRGRISKMORTALITY        "All Patient Refined DRG mortality risk"
label var ADRGSEV                  "All Patient Refined DRG severity level"
label var AGE                      "Age in years at admission"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMDC                     "All Patient Refined MDC"
label var AMONTH                   "Admission month"
label var ASOURCE                  "Admission source (uniform)"
label var ASOURCE_X                "Admission source (as received from source)"
label var ASOURCEUB92              "Admission source (UB-92 standard coding)"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var BWT                      "Birth weight in grams"
label var DaysBetweenVisits        "Number of days between visits"
label var DaysToEvent              "Days from 'start date' to admission"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DMONTH                   "Discharge month"
label var DNR                      "Do not resuscitate indicator"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DSHOSPID                 "Data source hospital identifier"
label var DXPOA1                   "Diagnosis 1, present on admission indicator"
label var DXPOA2                   "Diagnosis 2, present on admission indicator"
label var DXPOA3                   "Diagnosis 3, present on admission indicator"
label var DXPOA4                   "Diagnosis 4, present on admission indicator"
label var DXPOA5                   "Diagnosis 5, present on admission indicator"
label var DXPOA6                   "Diagnosis 6, present on admission indicator"
label var DXPOA7                   "Diagnosis 7, present on admission indicator"
label var DXPOA8                   "Diagnosis 8, present on admission indicator"
label var DXPOA9                   "Diagnosis 9, present on admission indicator"
label var DXPOA10                  "Diagnosis 10, present on admission indicator"
label var DXPOA11                  "Diagnosis 11, present on admission indicator"
label var DXPOA12                  "Diagnosis 12, present on admission indicator"
label var DXPOA13                  "Diagnosis 13, present on admission indicator"
label var DXPOA14                  "Diagnosis 14, present on admission indicator"
label var DXPOA15                  "Diagnosis 15, present on admission indicator"
label var DXPOA16                  "Diagnosis 16, present on admission indicator"
label var DXPOA17                  "Diagnosis 17, present on admission indicator"
label var DXPOA18                  "Diagnosis 18, present on admission indicator"
label var DXPOA19                  "Diagnosis 19, present on admission indicator"
label var DXPOA20                  "Diagnosis 20, present on admission indicator"
label var DXPOA21                  "Diagnosis 21, present on admission indicator"
label var DXPOA22                  "Diagnosis 22, present on admission indicator"
label var DXPOA23                  "Diagnosis 23, present on admission indicator"
label var DXPOA24                  "Diagnosis 24, present on admission indicator"
label var DXPOA25                  "Diagnosis 25, present on admission indicator"
label var DXPOA26                  "Diagnosis 26, present on admission indicator"
label var DXPOA27                  "Diagnosis 27, present on admission indicator"
label var DXPOA28                  "Diagnosis 28, present on admission indicator"
label var DXPOA29                  "Diagnosis 29, present on admission indicator"
label var DXPOA30                  "Diagnosis 30, present on admission indicator"
label var DXPOA31                  "Diagnosis 31, present on admission indicator"
label var DXPOA32                  "Diagnosis 32, present on admission indicator"
label var DXPOA33                  "Diagnosis 33, present on admission indicator"
label var DXPOA34                  "Diagnosis 34, present on admission indicator"
label var DXPOA35                  "Diagnosis 35, present on admission indicator"
label var DXPOA36                  "Diagnosis 36, present on admission indicator"
label var DXPOA37                  "Diagnosis 37, present on admission indicator"
label var DXPOA38                  "Diagnosis 38, present on admission indicator"
label var DXPOA39                  "Diagnosis 39, present on admission indicator"
label var DXPOA40                  "Diagnosis 40, present on admission indicator"
label var DXPOA41                  "Diagnosis 41, present on admission indicator"
label var DXPOA42                  "Diagnosis 42, present on admission indicator"
label var DXPOA43                  "Diagnosis 43, present on admission indicator"
label var DXPOA44                  "Diagnosis 44, present on admission indicator"
label var DXPOA45                  "Diagnosis 45, present on admission indicator"
label var DXPOA46                  "Diagnosis 46, present on admission indicator"
label var DXPOA47                  "Diagnosis 47, present on admission indicator"
label var DXPOA48                  "Diagnosis 48, present on admission indicator"
label var DXPOA49                  "Diagnosis 49, present on admission indicator"
label var DXPOA50                  "Diagnosis 50, present on admission indicator"
label var DXPOA51                  "Diagnosis 51, present on admission indicator"
label var DXPOA52                  "Diagnosis 52, present on admission indicator"
label var DXPOA53                  "Diagnosis 53, present on admission indicator"
label var DXPOA54                  "Diagnosis 54, present on admission indicator"
label var DXPOA55                  "Diagnosis 55, present on admission indicator"
label var DXPOA56                  "Diagnosis 56, present on admission indicator"
label var DXPOA57                  "Diagnosis 57, present on admission indicator"
label var DXPOA58                  "Diagnosis 58, present on admission indicator"
label var DXPOA59                  "Diagnosis 59, present on admission indicator"
label var DXPOA60                  "Diagnosis 60, present on admission indicator"
label var DXPOA61                  "Diagnosis 61, present on admission indicator"
label var DXPOA62                  "Diagnosis 62, present on admission indicator"
label var DXPOA63                  "Diagnosis 63, present on admission indicator"
label var DXPOA64                  "Diagnosis 64, present on admission indicator"
label var DXPOA65                  "Diagnosis 65, present on admission indicator"
label var DXPOA66                  "Diagnosis 66, present on admission indicator"
label var DXPOA67                  "Diagnosis 67, present on admission indicator"
label var DXPOA68                  "Diagnosis 68, present on admission indicator"
label var DXPOA69                  "Diagnosis 69, present on admission indicator"
label var DXPOA70                  "Diagnosis 70, present on admission indicator"
label var DXPOA71                  "Diagnosis 71, present on admission indicator"
label var DXPOA72                  "Diagnosis 72, present on admission indicator"
label var DXPOA73                  "Diagnosis 73, present on admission indicator"
label var DXPOA74                  "Diagnosis 74, present on admission indicator"
label var DXPOA75                  "Diagnosis 75, present on admission indicator"
label var DXPOA76                  "Diagnosis 76, present on admission indicator"
label var DXPOA77                  "Diagnosis 77, present on admission indicator"
label var DXPOA78                  "Diagnosis 78, present on admission indicator"
label var DXPOA79                  "Diagnosis 79, present on admission indicator"
label var DXPOA80                  "Diagnosis 80, present on admission indicator"
label var DXPOA81                  "Diagnosis 81, present on admission indicator"
label var DXPOA82                  "Diagnosis 82, present on admission indicator"
label var DXPOA83                  "Diagnosis 83, present on admission indicator"
label var DXPOA84                  "Diagnosis 84, present on admission indicator"
label var DXPOA85                  "Diagnosis 85, present on admission indicator"
label var DXPOA86                  "Diagnosis 86, present on admission indicator"
label var DXPOA87                  "Diagnosis 87, present on admission indicator"
label var DXPOA88                  "Diagnosis 88, present on admission indicator"
label var DXPOA89                  "Diagnosis 89, present on admission indicator"
label var DXPOA90                  "Diagnosis 90, present on admission indicator"
label var DXPOA91                  "Diagnosis 91, present on admission indicator"
label var DXPOA92                  "Diagnosis 92, present on admission indicator"
label var DXPOA93                  "Diagnosis 93, present on admission indicator"
label var DXPOA94                  "Diagnosis 94, present on admission indicator"
label var DXPOA95                  "Diagnosis 95, present on admission indicator"
label var DXPOA96                  "Diagnosis 96, present on admission indicator"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HISPANIC                 "Hispanic ethnicity (uniform)"
label var HISPANIC_X               "Hispanic ethnicity (as received from source)"
label var Homeless                 "Indicator that patient is homeless"
label var HOSPST                   "Hospital state postal code"
label var I10_BIRTH                "ICD-10-CM Birth Indicator"
label var I10_DELIVERY             "ICD-10-CM Delivery Indicator"
label var I10_DX_Admitting         "ICD-10-CM Admitting Diagnosis Code"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_DX18                 "ICD-10-CM Diagnosis 18"
label var I10_DX19                 "ICD-10-CM Diagnosis 19"
label var I10_DX20                 "ICD-10-CM Diagnosis 20"
label var I10_DX21                 "ICD-10-CM Diagnosis 21"
label var I10_DX22                 "ICD-10-CM Diagnosis 22"
label var I10_DX23                 "ICD-10-CM Diagnosis 23"
label var I10_DX24                 "ICD-10-CM Diagnosis 24"
label var I10_DX25                 "ICD-10-CM Diagnosis 25"
label var I10_DX26                 "ICD-10-CM Diagnosis 26"
label var I10_DX27                 "ICD-10-CM Diagnosis 27"
label var I10_DX28                 "ICD-10-CM Diagnosis 28"
label var I10_DX29                 "ICD-10-CM Diagnosis 29"
label var I10_DX30                 "ICD-10-CM Diagnosis 30"
label var I10_DX31                 "ICD-10-CM Diagnosis 31"
label var I10_DX32                 "ICD-10-CM Diagnosis 32"
label var I10_DX33                 "ICD-10-CM Diagnosis 33"
label var I10_DX34                 "ICD-10-CM Diagnosis 34"
label var I10_DX35                 "ICD-10-CM Diagnosis 35"
label var I10_DX36                 "ICD-10-CM Diagnosis 36"
label var I10_DX37                 "ICD-10-CM Diagnosis 37"
label var I10_DX38                 "ICD-10-CM Diagnosis 38"
label var I10_DX39                 "ICD-10-CM Diagnosis 39"
label var I10_DX40                 "ICD-10-CM Diagnosis 40"
label var I10_DX41                 "ICD-10-CM Diagnosis 41"
label var I10_DX42                 "ICD-10-CM Diagnosis 42"
label var I10_DX43                 "ICD-10-CM Diagnosis 43"
label var I10_DX44                 "ICD-10-CM Diagnosis 44"
label var I10_DX45                 "ICD-10-CM Diagnosis 45"
label var I10_DX46                 "ICD-10-CM Diagnosis 46"
label var I10_DX47                 "ICD-10-CM Diagnosis 47"
label var I10_DX48                 "ICD-10-CM Diagnosis 48"
label var I10_DX49                 "ICD-10-CM Diagnosis 49"
label var I10_DX50                 "ICD-10-CM Diagnosis 50"
label var I10_DX51                 "ICD-10-CM Diagnosis 51"
label var I10_DX52                 "ICD-10-CM Diagnosis 52"
label var I10_DX53                 "ICD-10-CM Diagnosis 53"
label var I10_DX54                 "ICD-10-CM Diagnosis 54"
label var I10_DX55                 "ICD-10-CM Diagnosis 55"
label var I10_DX56                 "ICD-10-CM Diagnosis 56"
label var I10_DX57                 "ICD-10-CM Diagnosis 57"
label var I10_DX58                 "ICD-10-CM Diagnosis 58"
label var I10_DX59                 "ICD-10-CM Diagnosis 59"
label var I10_DX60                 "ICD-10-CM Diagnosis 60"
label var I10_DX61                 "ICD-10-CM Diagnosis 61"
label var I10_DX62                 "ICD-10-CM Diagnosis 62"
label var I10_DX63                 "ICD-10-CM Diagnosis 63"
label var I10_DX64                 "ICD-10-CM Diagnosis 64"
label var I10_DX65                 "ICD-10-CM Diagnosis 65"
label var I10_DX66                 "ICD-10-CM Diagnosis 66"
label var I10_DX67                 "ICD-10-CM Diagnosis 67"
label var I10_DX68                 "ICD-10-CM Diagnosis 68"
label var I10_DX69                 "ICD-10-CM Diagnosis 69"
label var I10_DX70                 "ICD-10-CM Diagnosis 70"
label var I10_DX71                 "ICD-10-CM Diagnosis 71"
label var I10_DX72                 "ICD-10-CM Diagnosis 72"
label var I10_DX73                 "ICD-10-CM Diagnosis 73"
label var I10_DX74                 "ICD-10-CM Diagnosis 74"
label var I10_DX75                 "ICD-10-CM Diagnosis 75"
label var I10_DX76                 "ICD-10-CM Diagnosis 76"
label var I10_DX77                 "ICD-10-CM Diagnosis 77"
label var I10_DX78                 "ICD-10-CM Diagnosis 78"
label var I10_DX79                 "ICD-10-CM Diagnosis 79"
label var I10_DX80                 "ICD-10-CM Diagnosis 80"
label var I10_DX81                 "ICD-10-CM Diagnosis 81"
label var I10_DX82                 "ICD-10-CM Diagnosis 82"
label var I10_DX83                 "ICD-10-CM Diagnosis 83"
label var I10_DX84                 "ICD-10-CM Diagnosis 84"
label var I10_DX85                 "ICD-10-CM Diagnosis 85"
label var I10_DX86                 "ICD-10-CM Diagnosis 86"
label var I10_DX87                 "ICD-10-CM Diagnosis 87"
label var I10_DX88                 "ICD-10-CM Diagnosis 88"
label var I10_DX89                 "ICD-10-CM Diagnosis 89"
label var I10_DX90                 "ICD-10-CM Diagnosis 90"
label var I10_DX91                 "ICD-10-CM Diagnosis 91"
label var I10_DX92                 "ICD-10-CM Diagnosis 92"
label var I10_DX93                 "ICD-10-CM Diagnosis 93"
label var I10_DX94                 "ICD-10-CM Diagnosis 94"
label var I10_DX95                 "ICD-10-CM Diagnosis 95"
label var I10_DX96                 "ICD-10-CM Diagnosis 96"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_NPR                  "ICD-10-PCS Number of procedures on this record"
label var I10_PR1                  "ICD-10-PCS Procedure 1"
label var I10_PR2                  "ICD-10-PCS Procedure 2"
label var I10_PR3                  "ICD-10-PCS Procedure 3"
label var I10_PR4                  "ICD-10-PCS Procedure 4"
label var I10_PR5                  "ICD-10-PCS Procedure 5"
label var I10_PR6                  "ICD-10-PCS Procedure 6"
label var I10_PR7                  "ICD-10-PCS Procedure 7"
label var I10_PR8                  "ICD-10-PCS Procedure 8"
label var I10_PR9                  "ICD-10-PCS Procedure 9"
label var I10_PR10                 "ICD-10-PCS Procedure 10"
label var I10_PR11                 "ICD-10-PCS Procedure 11"
label var I10_PR12                 "ICD-10-PCS Procedure 12"
label var I10_PR13                 "ICD-10-PCS Procedure 13"
label var I10_PR14                 "ICD-10-PCS Procedure 14"
label var I10_PR15                 "ICD-10-PCS Procedure 15"
label var I10_PR16                 "ICD-10-PCS Procedure 16"
label var I10_PR17                 "ICD-10-PCS Procedure 17"
label var I10_PR18                 "ICD-10-PCS Procedure 18"
label var I10_PR19                 "ICD-10-PCS Procedure 19"
label var I10_PR20                 "ICD-10-PCS Procedure 20"
label var I10_PR21                 "ICD-10-PCS Procedure 21"
label var I10_PR22                 "ICD-10-PCS Procedure 22"
label var I10_PR23                 "ICD-10-PCS Procedure 23"
label var I10_PR24                 "ICD-10-PCS Procedure 24"
label var I10_PR25                 "ICD-10-PCS Procedure 25"
label var I10_PR26                 "ICD-10-PCS Procedure 26"
label var I10_PR27                 "ICD-10-PCS Procedure 27"
label var I10_PR28                 "ICD-10-PCS Procedure 28"
label var I10_PR29                 "ICD-10-PCS Procedure 29"
label var I10_PR30                 "ICD-10-PCS Procedure 30"
label var I10_PR31                 "ICD-10-PCS Procedure 31"
label var I10_PR32                 "ICD-10-PCS Procedure 32"
label var I10_PR33                 "ICD-10-PCS Procedure 33"
label var I10_PR34                 "ICD-10-PCS Procedure 34"
label var I10_PR35                 "ICD-10-PCS Procedure 35"
label var I10_PR36                 "ICD-10-PCS Procedure 36"
label var I10_PR37                 "ICD-10-PCS Procedure 37"
label var I10_PR38                 "ICD-10-PCS Procedure 38"
label var I10_PR39                 "ICD-10-PCS Procedure 39"
label var I10_PR40                 "ICD-10-PCS Procedure 40"
label var I10_PR41                 "ICD-10-PCS Procedure 41"
label var I10_PR42                 "ICD-10-PCS Procedure 42"
label var I10_PR43                 "ICD-10-PCS Procedure 43"
label var I10_PR44                 "ICD-10-PCS Procedure 44"
label var I10_PR45                 "ICD-10-PCS Procedure 45"
label var I10_PR46                 "ICD-10-PCS Procedure 46"
label var I10_PR47                 "ICD-10-PCS Procedure 47"
label var I10_PR48                 "ICD-10-PCS Procedure 48"
label var I10_PR49                 "ICD-10-PCS Procedure 49"
label var I10_PR50                 "ICD-10-PCS Procedure 50"
label var I10_PR51                 "ICD-10-PCS Procedure 51"
label var I10_PR52                 "ICD-10-PCS Procedure 52"
label var I10_PR53                 "ICD-10-PCS Procedure 53"
label var I10_PR54                 "ICD-10-PCS Procedure 54"
label var I10_PR55                 "ICD-10-PCS Procedure 55"
label var I10_PR56                 "ICD-10-PCS Procedure 56"
label var I10_PR57                 "ICD-10-PCS Procedure 57"
label var I10_PR58                 "ICD-10-PCS Procedure 58"
label var I10_PR59                 "ICD-10-PCS Procedure 59"
label var I10_PR60                 "ICD-10-PCS Procedure 60"
label var I10_PR61                 "ICD-10-PCS Procedure 61"
label var I10_PR62                 "ICD-10-PCS Procedure 62"
label var I10_PR63                 "ICD-10-PCS Procedure 63"
label var I10_PR64                 "ICD-10-PCS Procedure 64"
label var I10_PR65                 "ICD-10-PCS Procedure 65"
label var I10_PR66                 "ICD-10-PCS Procedure 66"
label var I10_PR67                 "ICD-10-PCS Procedure 67"
label var I10_PR68                 "ICD-10-PCS Procedure 68"
label var I10_PR69                 "ICD-10-PCS Procedure 69"
label var I10_PR70                 "ICD-10-PCS Procedure 70"
label var I10_PR71                 "ICD-10-PCS Procedure 71"
label var I10_PR72                 "ICD-10-PCS Procedure 72"
label var I10_PR73                 "ICD-10-PCS Procedure 73"
label var I10_PR74                 "ICD-10-PCS Procedure 74"
label var I10_PR75                 "ICD-10-PCS Procedure 75"
label var I10_PR76                 "ICD-10-PCS Procedure 76"
label var I10_PR77                 "ICD-10-PCS Procedure 77"
label var I10_PR78                 "ICD-10-PCS Procedure 78"
label var I10_PR79                 "ICD-10-PCS Procedure 79"
label var I10_PR80                 "ICD-10-PCS Procedure 80"
label var I10_PR81                 "ICD-10-PCS Procedure 81"
label var I10_PR82                 "ICD-10-PCS Procedure 82"
label var I10_PR83                 "ICD-10-PCS Procedure 83"
label var I10_PR84                 "ICD-10-PCS Procedure 84"
label var I10_PR85                 "ICD-10-PCS Procedure 85"
label var I10_PR86                 "ICD-10-PCS Procedure 86"
label var I10_PR87                 "ICD-10-PCS Procedure 87"
label var I10_PR88                 "ICD-10-PCS Procedure 88"
label var I10_PR89                 "ICD-10-PCS Procedure 89"
label var I10_PR90                 "ICD-10-PCS Procedure 90"
label var I10_PR91                 "ICD-10-PCS Procedure 91"
label var I10_PR92                 "ICD-10-PCS Procedure 92"
label var I10_PR93                 "ICD-10-PCS Procedure 93"
label var I10_PR94                 "ICD-10-PCS Procedure 94"
label var I10_PR95                 "ICD-10-PCS Procedure 95"
label var I10_PR96                 "ICD-10-PCS Procedure 96"
label var I10_PR97                 "ICD-10-PCS Procedure 97"
label var I10_PR98                 "ICD-10-PCS Procedure 98"
label var I10_PR99                 "ICD-10-PCS Procedure 99"
label var I10_PR100                "ICD-10-PCS Procedure 100"
label var I10_PR101                "ICD-10-PCS Procedure 101"
label var I10_PR102                "ICD-10-PCS Procedure 102"
label var I10_PR103                "ICD-10-PCS Procedure 103"
label var I10_PR104                "ICD-10-PCS Procedure 104"
label var I10_PR105                "ICD-10-PCS Procedure 105"
label var I10_PR106                "ICD-10-PCS Procedure 106"
label var I10_PR107                "ICD-10-PCS Procedure 107"
label var I10_PR108                "ICD-10-PCS Procedure 108"
label var I10_PR109                "ICD-10-PCS Procedure 109"
label var I10_PR110                "ICD-10-PCS Procedure 110"
label var I10_PR111                "ICD-10-PCS Procedure 111"
label var I10_PR112                "ICD-10-PCS Procedure 112"
label var I10_PR113                "ICD-10-PCS Procedure 113"
label var I10_PR114                "ICD-10-PCS Procedure 114"
label var I10_PR115                "ICD-10-PCS Procedure 115"
label var I10_PR116                "ICD-10-PCS Procedure 116"
label var I10_PR117                "ICD-10-PCS Procedure 117"
label var I10_PR118                "ICD-10-PCS Procedure 118"
label var I10_PR119                "ICD-10-PCS Procedure 119"
label var I10_PR120                "ICD-10-PCS Procedure 120"
label var I10_PR121                "ICD-10-PCS Procedure 121"
label var I10_PR122                "ICD-10-PCS Procedure 122"
label var I10_PR123                "ICD-10-PCS Procedure 123"
label var I10_PR124                "ICD-10-PCS Procedure 124"
label var I10_PR125                "ICD-10-PCS Procedure 125"
label var I10_PR126                "ICD-10-PCS Procedure 126"
label var I10_PR127                "ICD-10-PCS Procedure 127"
label var I10_PR128                "ICD-10-PCS Procedure 128"
label var I10_PR129                "ICD-10-PCS Procedure 129"
label var I10_PR130                "ICD-10-PCS Procedure 130"
label var I10_PR131                "ICD-10-PCS Procedure 131"
label var I10_PR132                "ICD-10-PCS Procedure 132"
label var I10_PR133                "ICD-10-PCS Procedure 133"
label var I10_PR134                "ICD-10-PCS Procedure 134"
label var I10_PR135                "ICD-10-PCS Procedure 135"
label var I10_PR136                "ICD-10-PCS Procedure 136"
label var I10_PR137                "ICD-10-PCS Procedure 137"
label var I10_PR138                "ICD-10-PCS Procedure 138"
label var I10_PR139                "ICD-10-PCS Procedure 139"
label var I10_PR140                "ICD-10-PCS Procedure 140"
label var I10_PR141                "ICD-10-PCS Procedure 141"
label var I10_PR142                "ICD-10-PCS Procedure 142"
label var I10_PR143                "ICD-10-PCS Procedure 143"
label var I10_PR144                "ICD-10-PCS Procedure 144"
label var I10_PR145                "ICD-10-PCS Procedure 145"
label var I10_PR146                "ICD-10-PCS Procedure 146"
label var I10_PR147                "ICD-10-PCS Procedure 147"
label var I10_PR148                "ICD-10-PCS Procedure 148"
label var I10_PR149                "ICD-10-PCS Procedure 149"
label var I10_PR150                "ICD-10-PCS Procedure 150"
label var I10_PR151                "ICD-10-PCS Procedure 151"
label var I10_PR152                "ICD-10-PCS Procedure 152"
label var I10_PR153                "ICD-10-PCS Procedure 153"
label var I10_PR154                "ICD-10-PCS Procedure 154"
label var I10_PR155                "ICD-10-PCS Procedure 155"
label var I10_PR156                "ICD-10-PCS Procedure 156"
label var I10_PR157                "ICD-10-PCS Procedure 157"
label var I10_PR158                "ICD-10-PCS Procedure 158"
label var I10_PR159                "ICD-10-PCS Procedure 159"
label var I10_PR160                "ICD-10-PCS Procedure 160"
label var I10_PR161                "ICD-10-PCS Procedure 161"
label var I10_PR162                "ICD-10-PCS Procedure 162"
label var I10_PR163                "ICD-10-PCS Procedure 163"
label var I10_PR164                "ICD-10-PCS Procedure 164"
label var I10_PR165                "ICD-10-PCS Procedure 165"
label var I10_PR166                "ICD-10-PCS Procedure 166"
label var I10_PR167                "ICD-10-PCS Procedure 167"
label var I10_PR168                "ICD-10-PCS Procedure 168"
label var I10_PR169                "ICD-10-PCS Procedure 169"
label var I10_PR170                "ICD-10-PCS Procedure 170"
label var I10_PR171                "ICD-10-PCS Procedure 171"
label var I10_PR172                "ICD-10-PCS Procedure 172"
label var I10_PR173                "ICD-10-PCS Procedure 173"
label var I10_PR174                "ICD-10-PCS Procedure 174"
label var I10_PR175                "ICD-10-PCS Procedure 175"
label var I10_PR176                "ICD-10-PCS Procedure 176"
label var I10_PR177                "ICD-10-PCS Procedure 177"
label var I10_PR178                "ICD-10-PCS Procedure 178"
label var I10_PR179                "ICD-10-PCS Procedure 179"
label var I10_PR180                "ICD-10-PCS Procedure 180"
label var I10_PR181                "ICD-10-PCS Procedure 181"
label var I10_PR182                "ICD-10-PCS Procedure 182"
label var I10_PR183                "ICD-10-PCS Procedure 183"
label var I10_PR184                "ICD-10-PCS Procedure 184"
label var I10_PR185                "ICD-10-PCS Procedure 185"
label var I10_PR186                "ICD-10-PCS Procedure 186"
label var I10_PR187                "ICD-10-PCS Procedure 187"
label var I10_PR188                "ICD-10-PCS Procedure 188"
label var I10_PR189                "ICD-10-PCS Procedure 189"
label var I10_PR190                "ICD-10-PCS Procedure 190"
label var I10_PR191                "ICD-10-PCS Procedure 191"
label var I10_PR192                "ICD-10-PCS Procedure 192"
label var I10_PR193                "ICD-10-PCS Procedure 193"
label var I10_PR194                "ICD-10-PCS Procedure 194"
label var I10_PR195                "ICD-10-PCS Procedure 195"
label var I10_PR196                "ICD-10-PCS Procedure 196"
label var I10_PR197                "ICD-10-PCS Procedure 197"
label var I10_PR198                "ICD-10-PCS Procedure 198"
label var I10_PR199                "ICD-10-PCS Procedure 199"
label var I10_PR200                "ICD-10-PCS Procedure 200"
label var I10_PROCTYPE             "ICD-10-PCS Procedure type indicator"
label var I10_SERVICELINE          "ICD-10-CM/PCS Hospital Service Line"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDC                      "MDC in effect on discharge date"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var OS_TIME                  "Observation stay time summed from UNITS"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PAYER1_X                 "Primary expected payer plan identifier (as received from source)"
label var PAYER2_X                 "Secondary expected payer plan identifier (as received from source)"
label var PCLASS_ORPROC            "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var POA_Disch_Edit1          "Discharge has POA missing on all nonexempt diagnoses"
label var POA_Disch_Edit2          "Discharge has POA missing on all nonexempt secondary diagnoses"
label var POA_Hosp_Edit1           "Hospital reported POA as Y on all diagnoses on all discharges"
label var POA_Hosp_Edit2           "Hospital reported POA as missing on all non-Medicare discharges"
label var POA_Hosp_Edit3           "Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
label var POA_Hosp_Edit3_Value     "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
label var PRDAY1                   "Number of days from admission to I10_PR1"
label var PRDAY2                   "Number of days from admission to I10_PR2"
label var PRDAY3                   "Number of days from admission to I10_PR3"
label var PRDAY4                   "Number of days from admission to I10_PR4"
label var PRDAY5                   "Number of days from admission to I10_PR5"
label var PRDAY6                   "Number of days from admission to I10_PR6"
label var PRDAY7                   "Number of days from admission to I10_PR7"
label var PRDAY8                   "Number of days from admission to I10_PR8"
label var PRDAY9                   "Number of days from admission to I10_PR9"
label var PRDAY10                  "Number of days from admission to I10_PR10"
label var PRDAY11                  "Number of days from admission to I10_PR11"
label var PRDAY12                  "Number of days from admission to I10_PR12"
label var PRDAY13                  "Number of days from admission to I10_PR13"
label var PRDAY14                  "Number of days from admission to I10_PR14"
label var PRDAY15                  "Number of days from admission to I10_PR15"
label var PRDAY16                  "Number of days from admission to I10_PR16"
label var PRDAY17                  "Number of days from admission to I10_PR17"
label var PRDAY18                  "Number of days from admission to I10_PR18"
label var PRDAY19                  "Number of days from admission to I10_PR19"
label var PRDAY20                  "Number of days from admission to I10_PR20"
label var PRDAY21                  "Number of days from admission to I10_PR21"
label var PRDAY22                  "Number of days from admission to I10_PR22"
label var PRDAY23                  "Number of days from admission to I10_PR23"
label var PRDAY24                  "Number of days from admission to I10_PR24"
label var PRDAY25                  "Number of days from admission to I10_PR25"
label var PRDAY26                  "Number of days from admission to I10_PR26"
label var PRDAY27                  "Number of days from admission to I10_PR27"
label var PRDAY28                  "Number of days from admission to I10_PR28"
label var PRDAY29                  "Number of days from admission to I10_PR29"
label var PRDAY30                  "Number of days from admission to I10_PR30"
label var PRDAY31                  "Number of days from admission to I10_PR31"
label var PRDAY32                  "Number of days from admission to I10_PR32"
label var PRDAY33                  "Number of days from admission to I10_PR33"
label var PRDAY34                  "Number of days from admission to I10_PR34"
label var PRDAY35                  "Number of days from admission to I10_PR35"
label var PRDAY36                  "Number of days from admission to I10_PR36"
label var PRDAY37                  "Number of days from admission to I10_PR37"
label var PRDAY38                  "Number of days from admission to I10_PR38"
label var PRDAY39                  "Number of days from admission to I10_PR39"
label var PRDAY40                  "Number of days from admission to I10_PR40"
label var PRDAY41                  "Number of days from admission to I10_PR41"
label var PRDAY42                  "Number of days from admission to I10_PR42"
label var PRDAY43                  "Number of days from admission to I10_PR43"
label var PRDAY44                  "Number of days from admission to I10_PR44"
label var PRDAY45                  "Number of days from admission to I10_PR45"
label var PRDAY46                  "Number of days from admission to I10_PR46"
label var PRDAY47                  "Number of days from admission to I10_PR47"
label var PRDAY48                  "Number of days from admission to I10_PR48"
label var PRDAY49                  "Number of days from admission to I10_PR49"
label var PRDAY50                  "Number of days from admission to I10_PR50"
label var PRDAY51                  "Number of days from admission to I10_PR51"
label var PRDAY52                  "Number of days from admission to I10_PR52"
label var PRDAY53                  "Number of days from admission to I10_PR53"
label var PRDAY54                  "Number of days from admission to I10_PR54"
label var PRDAY55                  "Number of days from admission to I10_PR55"
label var PRDAY56                  "Number of days from admission to I10_PR56"
label var PRDAY57                  "Number of days from admission to I10_PR57"
label var PRDAY58                  "Number of days from admission to I10_PR58"
label var PRDAY59                  "Number of days from admission to I10_PR59"
label var PRDAY60                  "Number of days from admission to I10_PR60"
label var PRDAY61                  "Number of days from admission to I10_PR61"
label var PRDAY62                  "Number of days from admission to I10_PR62"
label var PRDAY63                  "Number of days from admission to I10_PR63"
label var PRDAY64                  "Number of days from admission to I10_PR64"
label var PRDAY65                  "Number of days from admission to I10_PR65"
label var PRDAY66                  "Number of days from admission to I10_PR66"
label var PRDAY67                  "Number of days from admission to I10_PR67"
label var PRDAY68                  "Number of days from admission to I10_PR68"
label var PRDAY69                  "Number of days from admission to I10_PR69"
label var PRDAY70                  "Number of days from admission to I10_PR70"
label var PRDAY71                  "Number of days from admission to I10_PR71"
label var PRDAY72                  "Number of days from admission to I10_PR72"
label var PRDAY73                  "Number of days from admission to I10_PR73"
label var PRDAY74                  "Number of days from admission to I10_PR74"
label var PRDAY75                  "Number of days from admission to I10_PR75"
label var PRDAY76                  "Number of days from admission to I10_PR76"
label var PRDAY77                  "Number of days from admission to I10_PR77"
label var PRDAY78                  "Number of days from admission to I10_PR78"
label var PRDAY79                  "Number of days from admission to I10_PR79"
label var PRDAY80                  "Number of days from admission to I10_PR80"
label var PRDAY81                  "Number of days from admission to I10_PR81"
label var PRDAY82                  "Number of days from admission to I10_PR82"
label var PRDAY83                  "Number of days from admission to I10_PR83"
label var PRDAY84                  "Number of days from admission to I10_PR84"
label var PRDAY85                  "Number of days from admission to I10_PR85"
label var PRDAY86                  "Number of days from admission to I10_PR86"
label var PRDAY87                  "Number of days from admission to I10_PR87"
label var PRDAY88                  "Number of days from admission to I10_PR88"
label var PRDAY89                  "Number of days from admission to I10_PR89"
label var PRDAY90                  "Number of days from admission to I10_PR90"
label var PRDAY91                  "Number of days from admission to I10_PR91"
label var PRDAY92                  "Number of days from admission to I10_PR92"
label var PRDAY93                  "Number of days from admission to I10_PR93"
label var PRDAY94                  "Number of days from admission to I10_PR94"
label var PRDAY95                  "Number of days from admission to I10_PR95"
label var PRDAY96                  "Number of days from admission to I10_PR96"
label var PRDAY97                  "Number of days from admission to I10_PR97"
label var PRDAY98                  "Number of days from admission to I10_PR98"
label var PRDAY99                  "Number of days from admission to I10_PR99"
label var PRDAY100                 "Number of days from admission to I10_PR100"
label var PRDAY101                 "Number of days from admission to I10_PR101"
label var PRDAY102                 "Number of days from admission to I10_PR102"
label var PRDAY103                 "Number of days from admission to I10_PR103"
label var PRDAY104                 "Number of days from admission to I10_PR104"
label var PRDAY105                 "Number of days from admission to I10_PR105"
label var PRDAY106                 "Number of days from admission to I10_PR106"
label var PRDAY107                 "Number of days from admission to I10_PR107"
label var PRDAY108                 "Number of days from admission to I10_PR108"
label var PRDAY109                 "Number of days from admission to I10_PR109"
label var PRDAY110                 "Number of days from admission to I10_PR110"
label var PRDAY111                 "Number of days from admission to I10_PR111"
label var PRDAY112                 "Number of days from admission to I10_PR112"
label var PRDAY113                 "Number of days from admission to I10_PR113"
label var PRDAY114                 "Number of days from admission to I10_PR114"
label var PRDAY115                 "Number of days from admission to I10_PR115"
label var PRDAY116                 "Number of days from admission to I10_PR116"
label var PRDAY117                 "Number of days from admission to I10_PR117"
label var PRDAY118                 "Number of days from admission to I10_PR118"
label var PRDAY119                 "Number of days from admission to I10_PR119"
label var PRDAY120                 "Number of days from admission to I10_PR120"
label var PRDAY121                 "Number of days from admission to I10_PR121"
label var PRDAY122                 "Number of days from admission to I10_PR122"
label var PRDAY123                 "Number of days from admission to I10_PR123"
label var PRDAY124                 "Number of days from admission to I10_PR124"
label var PRDAY125                 "Number of days from admission to I10_PR125"
label var PRDAY126                 "Number of days from admission to I10_PR126"
label var PRDAY127                 "Number of days from admission to I10_PR127"
label var PRDAY128                 "Number of days from admission to I10_PR128"
label var PRDAY129                 "Number of days from admission to I10_PR129"
label var PRDAY130                 "Number of days from admission to I10_PR130"
label var PRDAY131                 "Number of days from admission to I10_PR131"
label var PRDAY132                 "Number of days from admission to I10_PR132"
label var PRDAY133                 "Number of days from admission to I10_PR133"
label var PRDAY134                 "Number of days from admission to I10_PR134"
label var PRDAY135                 "Number of days from admission to I10_PR135"
label var PRDAY136                 "Number of days from admission to I10_PR136"
label var PRDAY137                 "Number of days from admission to I10_PR137"
label var PRDAY138                 "Number of days from admission to I10_PR138"
label var PRDAY139                 "Number of days from admission to I10_PR139"
label var PRDAY140                 "Number of days from admission to I10_PR140"
label var PRDAY141                 "Number of days from admission to I10_PR141"
label var PRDAY142                 "Number of days from admission to I10_PR142"
label var PRDAY143                 "Number of days from admission to I10_PR143"
label var PRDAY144                 "Number of days from admission to I10_PR144"
label var PRDAY145                 "Number of days from admission to I10_PR145"
label var PRDAY146                 "Number of days from admission to I10_PR146"
label var PRDAY147                 "Number of days from admission to I10_PR147"
label var PRDAY148                 "Number of days from admission to I10_PR148"
label var PRDAY149                 "Number of days from admission to I10_PR149"
label var PRDAY150                 "Number of days from admission to I10_PR150"
label var PRDAY151                 "Number of days from admission to I10_PR151"
label var PRDAY152                 "Number of days from admission to I10_PR152"
label var PRDAY153                 "Number of days from admission to I10_PR153"
label var PRDAY154                 "Number of days from admission to I10_PR154"
label var PRDAY155                 "Number of days from admission to I10_PR155"
label var PRDAY156                 "Number of days from admission to I10_PR156"
label var PRDAY157                 "Number of days from admission to I10_PR157"
label var PRDAY158                 "Number of days from admission to I10_PR158"
label var PRDAY159                 "Number of days from admission to I10_PR159"
label var PRDAY160                 "Number of days from admission to I10_PR160"
label var PRDAY161                 "Number of days from admission to I10_PR161"
label var PRDAY162                 "Number of days from admission to I10_PR162"
label var PRDAY163                 "Number of days from admission to I10_PR163"
label var PRDAY164                 "Number of days from admission to I10_PR164"
label var PRDAY165                 "Number of days from admission to I10_PR165"
label var PRDAY166                 "Number of days from admission to I10_PR166"
label var PRDAY167                 "Number of days from admission to I10_PR167"
label var PRDAY168                 "Number of days from admission to I10_PR168"
label var PRDAY169                 "Number of days from admission to I10_PR169"
label var PRDAY170                 "Number of days from admission to I10_PR170"
label var PRDAY171                 "Number of days from admission to I10_PR171"
label var PRDAY172                 "Number of days from admission to I10_PR172"
label var PRDAY173                 "Number of days from admission to I10_PR173"
label var PRDAY174                 "Number of days from admission to I10_PR174"
label var PRDAY175                 "Number of days from admission to I10_PR175"
label var PRDAY176                 "Number of days from admission to I10_PR176"
label var PRDAY177                 "Number of days from admission to I10_PR177"
label var PRDAY178                 "Number of days from admission to I10_PR178"
label var PRDAY179                 "Number of days from admission to I10_PR179"
label var PRDAY180                 "Number of days from admission to I10_PR180"
label var PRDAY181                 "Number of days from admission to I10_PR181"
label var PRDAY182                 "Number of days from admission to I10_PR182"
label var PRDAY183                 "Number of days from admission to I10_PR183"
label var PRDAY184                 "Number of days from admission to I10_PR184"
label var PRDAY185                 "Number of days from admission to I10_PR185"
label var PRDAY186                 "Number of days from admission to I10_PR186"
label var PRDAY187                 "Number of days from admission to I10_PR187"
label var PRDAY188                 "Number of days from admission to I10_PR188"
label var PRDAY189                 "Number of days from admission to I10_PR189"
label var PRDAY190                 "Number of days from admission to I10_PR190"
label var PRDAY191                 "Number of days from admission to I10_PR191"
label var PRDAY192                 "Number of days from admission to I10_PR192"
label var PRDAY193                 "Number of days from admission to I10_PR193"
label var PRDAY194                 "Number of days from admission to I10_PR194"
label var PRDAY195                 "Number of days from admission to I10_PR195"
label var PRDAY196                 "Number of days from admission to I10_PR196"
label var PRDAY197                 "Number of days from admission to I10_PR197"
label var PRDAY198                 "Number of days from admission to I10_PR198"
label var PRDAY199                 "Number of days from admission to I10_PR199"
label var PRDAY200                 "Number of days from admission to I10_PR200"
label var PSTATE                   "Patient State postal code"
label var PSTATE_GEO               "Patient State postal code assigned from ZIP Code"
label var PSTCO_GEO                "Counties assigned based on ZIP Code geographic centroids"
label var RACE                     "Race (uniform)"
label var RACE_PCT_MISS_HOSP       "Hospital percentage of missing or invalid race values"
label var RACE_X                   "Race (as received from source)"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var VisitLink                "Visit linkage variable"
label var YEAR                     "Calendar year"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var AYEAR                    "Admission year"
label var PRMONTH1                 "Month of procedure 1"
label var PRMONTH2                 "Month of procedure 2"
label var PRMONTH3                 "Month of procedure 3"
label var PRMONTH4                 "Month of procedure 4"
label var PRMONTH5                 "Month of procedure 5"
label var PRMONTH6                 "Month of procedure 6"
label var PRMONTH7                 "Month of procedure 7"
label var PRMONTH8                 "Month of procedure 8"
label var PRMONTH9                 "Month of procedure 9"
label var PRMONTH10                "Month of procedure 10"
label var PRMONTH11                "Month of procedure 11"
label var PRMONTH12                "Month of procedure 12"
label var PRMONTH13                "Month of procedure 13"
label var PRMONTH14                "Month of procedure 14"
label var PRMONTH15                "Month of procedure 15"
label var PRMONTH16                "Month of procedure 16"
label var PRMONTH17                "Month of procedure 17"
label var PRMONTH18                "Month of procedure 18"
label var PRMONTH19                "Month of procedure 19"
label var PRMONTH20                "Month of procedure 20"
label var PRMONTH21                "Month of procedure 21"
label var PRMONTH22                "Month of procedure 22"
label var PRMONTH23                "Month of procedure 23"
label var PRMONTH24                "Month of procedure 24"
label var PRMONTH25                "Month of procedure 25"
label var PRMONTH26                "Month of procedure 26"
label var PRMONTH27                "Month of procedure 27"
label var PRMONTH28                "Month of procedure 28"
label var PRMONTH29                "Month of procedure 29"
label var PRMONTH30                "Month of procedure 30"
label var PRMONTH31                "Month of procedure 31"
label var PRMONTH32                "Month of procedure 32"
label var PRMONTH33                "Month of procedure 33"
label var PRMONTH34                "Month of procedure 34"
label var PRMONTH35                "Month of procedure 35"
label var PRMONTH36                "Month of procedure 36"
label var PRMONTH37                "Month of procedure 37"
label var PRMONTH38                "Month of procedure 38"
label var PRMONTH39                "Month of procedure 39"
label var PRMONTH40                "Month of procedure 40"
label var PRMONTH41                "Month of procedure 41"
label var PRMONTH42                "Month of procedure 42"
label var PRMONTH43                "Month of procedure 43"
label var PRMONTH44                "Month of procedure 44"
label var PRMONTH45                "Month of procedure 45"
label var PRMONTH46                "Month of procedure 46"
label var PRMONTH47                "Month of procedure 47"
label var PRMONTH48                "Month of procedure 48"
label var PRMONTH49                "Month of procedure 49"
label var PRMONTH50                "Month of procedure 50"
label var PRMONTH51                "Month of procedure 51"
label var PRMONTH52                "Month of procedure 52"
label var PRMONTH53                "Month of procedure 53"
label var PRMONTH54                "Month of procedure 54"
label var PRMONTH55                "Month of procedure 55"
label var PRMONTH56                "Month of procedure 56"
label var PRMONTH57                "Month of procedure 57"
label var PRMONTH58                "Month of procedure 58"
label var PRMONTH59                "Month of procedure 59"
label var PRMONTH60                "Month of procedure 60"
label var PRMONTH61                "Month of procedure 61"
label var PRMONTH62                "Month of procedure 62"
label var PRMONTH63                "Month of procedure 63"
label var PRMONTH64                "Month of procedure 64"
label var PRMONTH65                "Month of procedure 65"
label var PRMONTH66                "Month of procedure 66"
label var PRMONTH67                "Month of procedure 67"
label var PRMONTH68                "Month of procedure 68"
label var PRMONTH69                "Month of procedure 69"
label var PRMONTH70                "Month of procedure 70"
label var PRMONTH71                "Month of procedure 71"
label var PRMONTH72                "Month of procedure 72"
label var PRMONTH73                "Month of procedure 73"
label var PRMONTH74                "Month of procedure 74"
label var PRMONTH75                "Month of procedure 75"
label var PRMONTH76                "Month of procedure 76"
label var PRMONTH77                "Month of procedure 77"
label var PRMONTH78                "Month of procedure 78"
label var PRMONTH79                "Month of procedure 79"
label var PRMONTH80                "Month of procedure 80"
label var PRMONTH81                "Month of procedure 81"
label var PRMONTH82                "Month of procedure 82"
label var PRMONTH83                "Month of procedure 83"
label var PRMONTH84                "Month of procedure 84"
label var PRMONTH85                "Month of procedure 85"
label var PRMONTH86                "Month of procedure 86"
label var PRMONTH87                "Month of procedure 87"
label var PRMONTH88                "Month of procedure 88"
label var PRMONTH89                "Month of procedure 89"
label var PRMONTH90                "Month of procedure 90"
label var PRMONTH91                "Month of procedure 91"
label var PRMONTH92                "Month of procedure 92"
label var PRMONTH93                "Month of procedure 93"
label var PRMONTH94                "Month of procedure 94"
label var PRMONTH95                "Month of procedure 95"
label var PRMONTH96                "Month of procedure 96"
label var PRMONTH97                "Month of procedure 97"
label var PRMONTH98                "Month of procedure 98"
label var PRMONTH99                "Month of procedure 99"
label var PRMONTH100               "Month of procedure 100"
label var PRMONTH101               "Month of procedure 101"
label var PRMONTH102               "Month of procedure 102"
label var PRMONTH103               "Month of procedure 103"
label var PRMONTH104               "Month of procedure 104"
label var PRMONTH105               "Month of procedure 105"
label var PRMONTH106               "Month of procedure 106"
label var PRMONTH107               "Month of procedure 107"
label var PRMONTH108               "Month of procedure 108"
label var PRMONTH109               "Month of procedure 109"
label var PRMONTH110               "Month of procedure 110"
label var PRMONTH111               "Month of procedure 111"
label var PRMONTH112               "Month of procedure 112"
label var PRMONTH113               "Month of procedure 113"
label var PRMONTH114               "Month of procedure 114"
label var PRMONTH115               "Month of procedure 115"
label var PRMONTH116               "Month of procedure 116"
label var PRMONTH117               "Month of procedure 117"
label var PRMONTH118               "Month of procedure 118"
label var PRMONTH119               "Month of procedure 119"
label var PRMONTH120               "Month of procedure 120"
label var PRMONTH121               "Month of procedure 121"
label var PRMONTH122               "Month of procedure 122"
label var PRMONTH123               "Month of procedure 123"
label var PRMONTH124               "Month of procedure 124"
label var PRMONTH125               "Month of procedure 125"
label var PRMONTH126               "Month of procedure 126"
label var PRMONTH127               "Month of procedure 127"
label var PRMONTH128               "Month of procedure 128"
label var PRMONTH129               "Month of procedure 129"
label var PRMONTH130               "Month of procedure 130"
label var PRMONTH131               "Month of procedure 131"
label var PRMONTH132               "Month of procedure 132"
label var PRMONTH133               "Month of procedure 133"
label var PRMONTH134               "Month of procedure 134"
label var PRMONTH135               "Month of procedure 135"
label var PRMONTH136               "Month of procedure 136"
label var PRMONTH137               "Month of procedure 137"
label var PRMONTH138               "Month of procedure 138"
label var PRMONTH139               "Month of procedure 139"
label var PRMONTH140               "Month of procedure 140"
label var PRMONTH141               "Month of procedure 141"
label var PRMONTH142               "Month of procedure 142"
label var PRMONTH143               "Month of procedure 143"
label var PRMONTH144               "Month of procedure 144"
label var PRMONTH145               "Month of procedure 145"
label var PRMONTH146               "Month of procedure 146"
label var PRMONTH147               "Month of procedure 147"
label var PRMONTH148               "Month of procedure 148"
label var PRMONTH149               "Month of procedure 149"
label var PRMONTH150               "Month of procedure 150"
label var PRMONTH151               "Month of procedure 151"
label var PRMONTH152               "Month of procedure 152"
label var PRMONTH153               "Month of procedure 153"
label var PRMONTH154               "Month of procedure 154"
label var PRMONTH155               "Month of procedure 155"
label var PRMONTH156               "Month of procedure 156"
label var PRMONTH157               "Month of procedure 157"
label var PRMONTH158               "Month of procedure 158"
label var PRMONTH159               "Month of procedure 159"
label var PRMONTH160               "Month of procedure 160"
label var PRMONTH161               "Month of procedure 161"
label var PRMONTH162               "Month of procedure 162"
label var PRMONTH163               "Month of procedure 163"
label var PRMONTH164               "Month of procedure 164"
label var PRMONTH165               "Month of procedure 165"
label var PRMONTH166               "Month of procedure 166"
label var PRMONTH167               "Month of procedure 167"
label var PRMONTH168               "Month of procedure 168"
label var PRMONTH169               "Month of procedure 169"
label var PRMONTH170               "Month of procedure 170"
label var PRMONTH171               "Month of procedure 171"
label var PRMONTH172               "Month of procedure 172"
label var PRMONTH173               "Month of procedure 173"
label var PRMONTH174               "Month of procedure 174"
label var PRMONTH175               "Month of procedure 175"
label var PRMONTH176               "Month of procedure 176"
label var PRMONTH177               "Month of procedure 177"
label var PRMONTH178               "Month of procedure 178"
label var PRMONTH179               "Month of procedure 179"
label var PRMONTH180               "Month of procedure 180"
label var PRMONTH181               "Month of procedure 181"
label var PRMONTH182               "Month of procedure 182"
label var PRMONTH183               "Month of procedure 183"
label var PRMONTH184               "Month of procedure 184"
label var PRMONTH185               "Month of procedure 185"
label var PRMONTH186               "Month of procedure 186"
label var PRMONTH187               "Month of procedure 187"
label var PRMONTH188               "Month of procedure 188"
label var PRMONTH189               "Month of procedure 189"
label var PRMONTH190               "Month of procedure 190"
label var PRMONTH191               "Month of procedure 191"
label var PRMONTH192               "Month of procedure 192"
label var PRMONTH193               "Month of procedure 193"
label var PRMONTH194               "Month of procedure 194"
label var PRMONTH195               "Month of procedure 195"
label var PRMONTH196               "Month of procedure 196"
label var PRMONTH197               "Month of procedure 197"
label var PRMONTH198               "Month of procedure 198"
label var PRMONTH199               "Month of procedure 199"
label var PRMONTH200               "Month of procedure 200"
label var PRYEAR1                  "Year of procedure 1"
label var PRYEAR2                  "Year of procedure 2"
label var PRYEAR3                  "Year of procedure 3"
label var PRYEAR4                  "Year of procedure 4"
label var PRYEAR5                  "Year of procedure 5"
label var PRYEAR6                  "Year of procedure 6"
label var PRYEAR7                  "Year of procedure 7"
label var PRYEAR8                  "Year of procedure 8"
label var PRYEAR9                  "Year of procedure 9"
label var PRYEAR10                 "Year of procedure 10"
label var PRYEAR11                 "Year of procedure 11"
label var PRYEAR12                 "Year of procedure 12"
label var PRYEAR13                 "Year of procedure 13"
label var PRYEAR14                 "Year of procedure 14"
label var PRYEAR15                 "Year of procedure 15"
label var PRYEAR16                 "Year of procedure 16"
label var PRYEAR17                 "Year of procedure 17"
label var PRYEAR18                 "Year of procedure 18"
label var PRYEAR19                 "Year of procedure 19"
label var PRYEAR20                 "Year of procedure 20"
label var PRYEAR21                 "Year of procedure 21"
label var PRYEAR22                 "Year of procedure 22"
label var PRYEAR23                 "Year of procedure 23"
label var PRYEAR24                 "Year of procedure 24"
label var PRYEAR25                 "Year of procedure 25"
label var PRYEAR26                 "Year of procedure 26"
label var PRYEAR27                 "Year of procedure 27"
label var PRYEAR28                 "Year of procedure 28"
label var PRYEAR29                 "Year of procedure 29"
label var PRYEAR30                 "Year of procedure 30"
label var PRYEAR31                 "Year of procedure 31"
label var PRYEAR32                 "Year of procedure 32"
label var PRYEAR33                 "Year of procedure 33"
label var PRYEAR34                 "Year of procedure 34"
label var PRYEAR35                 "Year of procedure 35"
label var PRYEAR36                 "Year of procedure 36"
label var PRYEAR37                 "Year of procedure 37"
label var PRYEAR38                 "Year of procedure 38"
label var PRYEAR39                 "Year of procedure 39"
label var PRYEAR40                 "Year of procedure 40"
label var PRYEAR41                 "Year of procedure 41"
label var PRYEAR42                 "Year of procedure 42"
label var PRYEAR43                 "Year of procedure 43"
label var PRYEAR44                 "Year of procedure 44"
label var PRYEAR45                 "Year of procedure 45"
label var PRYEAR46                 "Year of procedure 46"
label var PRYEAR47                 "Year of procedure 47"
label var PRYEAR48                 "Year of procedure 48"
label var PRYEAR49                 "Year of procedure 49"
label var PRYEAR50                 "Year of procedure 50"
label var PRYEAR51                 "Year of procedure 51"
label var PRYEAR52                 "Year of procedure 52"
label var PRYEAR53                 "Year of procedure 53"
label var PRYEAR54                 "Year of procedure 54"
label var PRYEAR55                 "Year of procedure 55"
label var PRYEAR56                 "Year of procedure 56"
label var PRYEAR57                 "Year of procedure 57"
label var PRYEAR58                 "Year of procedure 58"
label var PRYEAR59                 "Year of procedure 59"
label var PRYEAR60                 "Year of procedure 60"
label var PRYEAR61                 "Year of procedure 61"
label var PRYEAR62                 "Year of procedure 62"
label var PRYEAR63                 "Year of procedure 63"
label var PRYEAR64                 "Year of procedure 64"
label var PRYEAR65                 "Year of procedure 65"
label var PRYEAR66                 "Year of procedure 66"
label var PRYEAR67                 "Year of procedure 67"
label var PRYEAR68                 "Year of procedure 68"
label var PRYEAR69                 "Year of procedure 69"
label var PRYEAR70                 "Year of procedure 70"
label var PRYEAR71                 "Year of procedure 71"
label var PRYEAR72                 "Year of procedure 72"
label var PRYEAR73                 "Year of procedure 73"
label var PRYEAR74                 "Year of procedure 74"
label var PRYEAR75                 "Year of procedure 75"
label var PRYEAR76                 "Year of procedure 76"
label var PRYEAR77                 "Year of procedure 77"
label var PRYEAR78                 "Year of procedure 78"
label var PRYEAR79                 "Year of procedure 79"
label var PRYEAR80                 "Year of procedure 80"
label var PRYEAR81                 "Year of procedure 81"
label var PRYEAR82                 "Year of procedure 82"
label var PRYEAR83                 "Year of procedure 83"
label var PRYEAR84                 "Year of procedure 84"
label var PRYEAR85                 "Year of procedure 85"
label var PRYEAR86                 "Year of procedure 86"
label var PRYEAR87                 "Year of procedure 87"
label var PRYEAR88                 "Year of procedure 88"
label var PRYEAR89                 "Year of procedure 89"
label var PRYEAR90                 "Year of procedure 90"
label var PRYEAR91                 "Year of procedure 91"
label var PRYEAR92                 "Year of procedure 92"
label var PRYEAR93                 "Year of procedure 93"
label var PRYEAR94                 "Year of procedure 94"
label var PRYEAR95                 "Year of procedure 95"
label var PRYEAR96                 "Year of procedure 96"
label var PRYEAR97                 "Year of procedure 97"
label var PRYEAR98                 "Year of procedure 98"
label var PRYEAR99                 "Year of procedure 99"
label var PRYEAR100                "Year of procedure 100"
label var PRYEAR101                "Year of procedure 101"
label var PRYEAR102                "Year of procedure 102"
label var PRYEAR103                "Year of procedure 103"
label var PRYEAR104                "Year of procedure 104"
label var PRYEAR105                "Year of procedure 105"
label var PRYEAR106                "Year of procedure 106"
label var PRYEAR107                "Year of procedure 107"
label var PRYEAR108                "Year of procedure 108"
label var PRYEAR109                "Year of procedure 109"
label var PRYEAR110                "Year of procedure 110"
label var PRYEAR111                "Year of procedure 111"
label var PRYEAR112                "Year of procedure 112"
label var PRYEAR113                "Year of procedure 113"
label var PRYEAR114                "Year of procedure 114"
label var PRYEAR115                "Year of procedure 115"
label var PRYEAR116                "Year of procedure 116"
label var PRYEAR117                "Year of procedure 117"
label var PRYEAR118                "Year of procedure 118"
label var PRYEAR119                "Year of procedure 119"
label var PRYEAR120                "Year of procedure 120"
label var PRYEAR121                "Year of procedure 121"
label var PRYEAR122                "Year of procedure 122"
label var PRYEAR123                "Year of procedure 123"
label var PRYEAR124                "Year of procedure 124"
label var PRYEAR125                "Year of procedure 125"
label var PRYEAR126                "Year of procedure 126"
label var PRYEAR127                "Year of procedure 127"
label var PRYEAR128                "Year of procedure 128"
label var PRYEAR129                "Year of procedure 129"
label var PRYEAR130                "Year of procedure 130"
label var PRYEAR131                "Year of procedure 131"
label var PRYEAR132                "Year of procedure 132"
label var PRYEAR133                "Year of procedure 133"
label var PRYEAR134                "Year of procedure 134"
label var PRYEAR135                "Year of procedure 135"
label var PRYEAR136                "Year of procedure 136"
label var PRYEAR137                "Year of procedure 137"
label var PRYEAR138                "Year of procedure 138"
label var PRYEAR139                "Year of procedure 139"
label var PRYEAR140                "Year of procedure 140"
label var PRYEAR141                "Year of procedure 141"
label var PRYEAR142                "Year of procedure 142"
label var PRYEAR143                "Year of procedure 143"
label var PRYEAR144                "Year of procedure 144"
label var PRYEAR145                "Year of procedure 145"
label var PRYEAR146                "Year of procedure 146"
label var PRYEAR147                "Year of procedure 147"
label var PRYEAR148                "Year of procedure 148"
label var PRYEAR149                "Year of procedure 149"
label var PRYEAR150                "Year of procedure 150"
label var PRYEAR151                "Year of procedure 151"
label var PRYEAR152                "Year of procedure 152"
label var PRYEAR153                "Year of procedure 153"
label var PRYEAR154                "Year of procedure 154"
label var PRYEAR155                "Year of procedure 155"
label var PRYEAR156                "Year of procedure 156"
label var PRYEAR157                "Year of procedure 157"
label var PRYEAR158                "Year of procedure 158"
label var PRYEAR159                "Year of procedure 159"
label var PRYEAR160                "Year of procedure 160"
label var PRYEAR161                "Year of procedure 161"
label var PRYEAR162                "Year of procedure 162"
label var PRYEAR163                "Year of procedure 163"
label var PRYEAR164                "Year of procedure 164"
label var PRYEAR165                "Year of procedure 165"
label var PRYEAR166                "Year of procedure 166"
label var PRYEAR167                "Year of procedure 167"
label var PRYEAR168                "Year of procedure 168"
label var PRYEAR169                "Year of procedure 169"
label var PRYEAR170                "Year of procedure 170"
label var PRYEAR171                "Year of procedure 171"
label var PRYEAR172                "Year of procedure 172"
label var PRYEAR173                "Year of procedure 173"
label var PRYEAR174                "Year of procedure 174"
label var PRYEAR175                "Year of procedure 175"
label var PRYEAR176                "Year of procedure 176"
label var PRYEAR177                "Year of procedure 177"
label var PRYEAR178                "Year of procedure 178"
label var PRYEAR179                "Year of procedure 179"
label var PRYEAR180                "Year of procedure 180"
label var PRYEAR181                "Year of procedure 181"
label var PRYEAR182                "Year of procedure 182"
label var PRYEAR183                "Year of procedure 183"
label var PRYEAR184                "Year of procedure 184"
label var PRYEAR185                "Year of procedure 185"
label var PRYEAR186                "Year of procedure 186"
label var PRYEAR187                "Year of procedure 187"
label var PRYEAR188                "Year of procedure 188"
label var PRYEAR189                "Year of procedure 189"
label var PRYEAR190                "Year of procedure 190"
label var PRYEAR191                "Year of procedure 191"
label var PRYEAR192                "Year of procedure 192"
label var PRYEAR193                "Year of procedure 193"
label var PRYEAR194                "Year of procedure 194"
label var PRYEAR195                "Year of procedure 195"
label var PRYEAR196                "Year of procedure 196"
label var PRYEAR197                "Year of procedure 197"
label var PRYEAR198                "Year of procedure 198"
label var PRYEAR199                "Year of procedure 199"
label var PRYEAR200                "Year of procedure 200"

/*** Convert special values to missing values ***/
recode ADRG                      (-99 -88 -66=.)
recode ADRGRISKMORTALITY         (-9 -8 -6 -5=.)
recode ADRGSEV                   (-9 -8 -6 -5=.)
recode AGE                       (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMDC                      (-9 -8 -6 -5=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ASOURCE                   (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode BWT                       (-999 -888 -666=.)
recode DaysBetweenVisits         (-999 -888 -666=.)
recode DaysToEvent               (-99999 -88888 -66666=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DNR                       (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HISPANIC                  (-9 -8 -6 -5=.)
recode Homeless                  (-9 -8 -6 -5=.)
recode I10_BIRTH                 (-99 -88 -66=.)
recode I10_DELIVERY              (-99 -88 -66=.)
recode I10_NDX                   (-99 -88 -66=.)
recode I10_NPR                   (-99 -88 -66=.)
recode I10_PROCTYPE              (-99 -88 -66=.)
recode I10_SERVICELINE           (-9 -8 -6 -5=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode OS_TIME                   (-9999999.99 -8888888.88 -6666666.66=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PCLASS_ORPROC             (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode POA_Disch_Edit1           (-9 -8 -6 -5=.)
recode POA_Disch_Edit2           (-9 -8 -6 -5=.)
recode POA_Hosp_Edit1            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit2            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3_Value      (-9999.99 -8888.88 -6666.66=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PRDAY2                    (-9999 -8888 -6666=.)
recode PRDAY3                    (-9999 -8888 -6666=.)
recode PRDAY4                    (-9999 -8888 -6666=.)
recode PRDAY5                    (-9999 -8888 -6666=.)
recode PRDAY6                    (-9999 -8888 -6666=.)
recode PRDAY7                    (-9999 -8888 -6666=.)
recode PRDAY8                    (-9999 -8888 -6666=.)
recode PRDAY9                    (-9999 -8888 -6666=.)
recode PRDAY10                   (-9999 -8888 -6666=.)
recode PRDAY11                   (-9999 -8888 -6666=.)
recode PRDAY12                   (-9999 -8888 -6666=.)
recode PRDAY13                   (-9999 -8888 -6666=.)
recode PRDAY14                   (-9999 -8888 -6666=.)
recode PRDAY15                   (-9999 -8888 -6666=.)
recode PRDAY16                   (-9999 -8888 -6666=.)
recode PRDAY17                   (-9999 -8888 -6666=.)
recode PRDAY18                   (-9999 -8888 -6666=.)
recode PRDAY19                   (-9999 -8888 -6666=.)
recode PRDAY20                   (-9999 -8888 -6666=.)
recode PRDAY21                   (-9999 -8888 -6666=.)
recode PRDAY22                   (-9999 -8888 -6666=.)
recode PRDAY23                   (-9999 -8888 -6666=.)
recode PRDAY24                   (-9999 -8888 -6666=.)
recode PRDAY25                   (-9999 -8888 -6666=.)
recode PRDAY26                   (-9999 -8888 -6666=.)
recode PRDAY27                   (-9999 -8888 -6666=.)
recode PRDAY28                   (-9999 -8888 -6666=.)
recode PRDAY29                   (-9999 -8888 -6666=.)
recode PRDAY30                   (-9999 -8888 -6666=.)
recode PRDAY31                   (-9999 -8888 -6666=.)
recode PRDAY32                   (-9999 -8888 -6666=.)
recode PRDAY33                   (-9999 -8888 -6666=.)
recode PRDAY34                   (-9999 -8888 -6666=.)
recode PRDAY35                   (-9999 -8888 -6666=.)
recode PRDAY36                   (-9999 -8888 -6666=.)
recode PRDAY37                   (-9999 -8888 -6666=.)
recode PRDAY38                   (-9999 -8888 -6666=.)
recode PRDAY39                   (-9999 -8888 -6666=.)
recode PRDAY40                   (-9999 -8888 -6666=.)
recode PRDAY41                   (-9999 -8888 -6666=.)
recode PRDAY42                   (-9999 -8888 -6666=.)
recode PRDAY43                   (-9999 -8888 -6666=.)
recode PRDAY44                   (-9999 -8888 -6666=.)
recode PRDAY45                   (-9999 -8888 -6666=.)
recode PRDAY46                   (-9999 -8888 -6666=.)
recode PRDAY47                   (-9999 -8888 -6666=.)
recode PRDAY48                   (-9999 -8888 -6666=.)
recode PRDAY49                   (-9999 -8888 -6666=.)
recode PRDAY50                   (-9999 -8888 -6666=.)
recode PRDAY51                   (-9999 -8888 -6666=.)
recode PRDAY52                   (-9999 -8888 -6666=.)
recode PRDAY53                   (-9999 -8888 -6666=.)
recode PRDAY54                   (-9999 -8888 -6666=.)
recode PRDAY55                   (-9999 -8888 -6666=.)
recode PRDAY56                   (-9999 -8888 -6666=.)
recode PRDAY57                   (-9999 -8888 -6666=.)
recode PRDAY58                   (-9999 -8888 -6666=.)
recode PRDAY59                   (-9999 -8888 -6666=.)
recode PRDAY60                   (-9999 -8888 -6666=.)
recode PRDAY61                   (-9999 -8888 -6666=.)
recode PRDAY62                   (-9999 -8888 -6666=.)
recode PRDAY63                   (-9999 -8888 -6666=.)
recode PRDAY64                   (-9999 -8888 -6666=.)
recode PRDAY65                   (-9999 -8888 -6666=.)
recode PRDAY66                   (-9999 -8888 -6666=.)
recode PRDAY67                   (-9999 -8888 -6666=.)
recode PRDAY68                   (-9999 -8888 -6666=.)
recode PRDAY69                   (-9999 -8888 -6666=.)
recode PRDAY70                   (-9999 -8888 -6666=.)
recode PRDAY71                   (-9999 -8888 -6666=.)
recode PRDAY72                   (-9999 -8888 -6666=.)
recode PRDAY73                   (-9999 -8888 -6666=.)
recode PRDAY74                   (-9999 -8888 -6666=.)
recode PRDAY75                   (-9999 -8888 -6666=.)
recode PRDAY76                   (-9999 -8888 -6666=.)
recode PRDAY77                   (-9999 -8888 -6666=.)
recode PRDAY78                   (-9999 -8888 -6666=.)
recode PRDAY79                   (-9999 -8888 -6666=.)
recode PRDAY80                   (-9999 -8888 -6666=.)
recode PRDAY81                   (-9999 -8888 -6666=.)
recode PRDAY82                   (-9999 -8888 -6666=.)
recode PRDAY83                   (-9999 -8888 -6666=.)
recode PRDAY84                   (-9999 -8888 -6666=.)
recode PRDAY85                   (-9999 -8888 -6666=.)
recode PRDAY86                   (-9999 -8888 -6666=.)
recode PRDAY87                   (-9999 -8888 -6666=.)
recode PRDAY88                   (-9999 -8888 -6666=.)
recode PRDAY89                   (-9999 -8888 -6666=.)
recode PRDAY90                   (-9999 -8888 -6666=.)
recode PRDAY91                   (-9999 -8888 -6666=.)
recode PRDAY92                   (-9999 -8888 -6666=.)
recode PRDAY93                   (-9999 -8888 -6666=.)
recode PRDAY94                   (-9999 -8888 -6666=.)
recode PRDAY95                   (-9999 -8888 -6666=.)
recode PRDAY96                   (-9999 -8888 -6666=.)
recode PRDAY97                   (-9999 -8888 -6666=.)
recode PRDAY98                   (-9999 -8888 -6666=.)
recode PRDAY99                   (-9999 -8888 -6666=.)
recode PRDAY100                  (-9999 -8888 -6666=.)
recode PRDAY101                  (-9999 -8888 -6666=.)
recode PRDAY102                  (-9999 -8888 -6666=.)
recode PRDAY103                  (-9999 -8888 -6666=.)
recode PRDAY104                  (-9999 -8888 -6666=.)
recode PRDAY105                  (-9999 -8888 -6666=.)
recode PRDAY106                  (-9999 -8888 -6666=.)
recode PRDAY107                  (-9999 -8888 -6666=.)
recode PRDAY108                  (-9999 -8888 -6666=.)
recode PRDAY109                  (-9999 -8888 -6666=.)
recode PRDAY110                  (-9999 -8888 -6666=.)
recode PRDAY111                  (-9999 -8888 -6666=.)
recode PRDAY112                  (-9999 -8888 -6666=.)
recode PRDAY113                  (-9999 -8888 -6666=.)
recode PRDAY114                  (-9999 -8888 -6666=.)
recode PRDAY115                  (-9999 -8888 -6666=.)
recode PRDAY116                  (-9999 -8888 -6666=.)
recode PRDAY117                  (-9999 -8888 -6666=.)
recode PRDAY118                  (-9999 -8888 -6666=.)
recode PRDAY119                  (-9999 -8888 -6666=.)
recode PRDAY120                  (-9999 -8888 -6666=.)
recode PRDAY121                  (-9999 -8888 -6666=.)
recode PRDAY122                  (-9999 -8888 -6666=.)
recode PRDAY123                  (-9999 -8888 -6666=.)
recode PRDAY124                  (-9999 -8888 -6666=.)
recode PRDAY125                  (-9999 -8888 -6666=.)
recode PRDAY126                  (-9999 -8888 -6666=.)
recode PRDAY127                  (-9999 -8888 -6666=.)
recode PRDAY128                  (-9999 -8888 -6666=.)
recode PRDAY129                  (-9999 -8888 -6666=.)
recode PRDAY130                  (-9999 -8888 -6666=.)
recode PRDAY131                  (-9999 -8888 -6666=.)
recode PRDAY132                  (-9999 -8888 -6666=.)
recode PRDAY133                  (-9999 -8888 -6666=.)
recode PRDAY134                  (-9999 -8888 -6666=.)
recode PRDAY135                  (-9999 -8888 -6666=.)
recode PRDAY136                  (-9999 -8888 -6666=.)
recode PRDAY137                  (-9999 -8888 -6666=.)
recode PRDAY138                  (-9999 -8888 -6666=.)
recode PRDAY139                  (-9999 -8888 -6666=.)
recode PRDAY140                  (-9999 -8888 -6666=.)
recode PRDAY141                  (-9999 -8888 -6666=.)
recode PRDAY142                  (-9999 -8888 -6666=.)
recode PRDAY143                  (-9999 -8888 -6666=.)
recode PRDAY144                  (-9999 -8888 -6666=.)
recode PRDAY145                  (-9999 -8888 -6666=.)
recode PRDAY146                  (-9999 -8888 -6666=.)
recode PRDAY147                  (-9999 -8888 -6666=.)
recode PRDAY148                  (-9999 -8888 -6666=.)
recode PRDAY149                  (-9999 -8888 -6666=.)
recode PRDAY150                  (-9999 -8888 -6666=.)
recode PRDAY151                  (-9999 -8888 -6666=.)
recode PRDAY152                  (-9999 -8888 -6666=.)
recode PRDAY153                  (-9999 -8888 -6666=.)
recode PRDAY154                  (-9999 -8888 -6666=.)
recode PRDAY155                  (-9999 -8888 -6666=.)
recode PRDAY156                  (-9999 -8888 -6666=.)
recode PRDAY157                  (-9999 -8888 -6666=.)
recode PRDAY158                  (-9999 -8888 -6666=.)
recode PRDAY159                  (-9999 -8888 -6666=.)
recode PRDAY160                  (-9999 -8888 -6666=.)
recode PRDAY161                  (-9999 -8888 -6666=.)
recode PRDAY162                  (-9999 -8888 -6666=.)
recode PRDAY163                  (-9999 -8888 -6666=.)
recode PRDAY164                  (-9999 -8888 -6666=.)
recode PRDAY165                  (-9999 -8888 -6666=.)
recode PRDAY166                  (-9999 -8888 -6666=.)
recode PRDAY167                  (-9999 -8888 -6666=.)
recode PRDAY168                  (-9999 -8888 -6666=.)
recode PRDAY169                  (-9999 -8888 -6666=.)
recode PRDAY170                  (-9999 -8888 -6666=.)
recode PRDAY171                  (-9999 -8888 -6666=.)
recode PRDAY172                  (-9999 -8888 -6666=.)
recode PRDAY173                  (-9999 -8888 -6666=.)
recode PRDAY174                  (-9999 -8888 -6666=.)
recode PRDAY175                  (-9999 -8888 -6666=.)
recode PRDAY176                  (-9999 -8888 -6666=.)
recode PRDAY177                  (-9999 -8888 -6666=.)
recode PRDAY178                  (-9999 -8888 -6666=.)
recode PRDAY179                  (-9999 -8888 -6666=.)
recode PRDAY180                  (-9999 -8888 -6666=.)
recode PRDAY181                  (-9999 -8888 -6666=.)
recode PRDAY182                  (-9999 -8888 -6666=.)
recode PRDAY183                  (-9999 -8888 -6666=.)
recode PRDAY184                  (-9999 -8888 -6666=.)
recode PRDAY185                  (-9999 -8888 -6666=.)
recode PRDAY186                  (-9999 -8888 -6666=.)
recode PRDAY187                  (-9999 -8888 -6666=.)
recode PRDAY188                  (-9999 -8888 -6666=.)
recode PRDAY189                  (-9999 -8888 -6666=.)
recode PRDAY190                  (-9999 -8888 -6666=.)
recode PRDAY191                  (-9999 -8888 -6666=.)
recode PRDAY192                  (-9999 -8888 -6666=.)
recode PRDAY193                  (-9999 -8888 -6666=.)
recode PRDAY194                  (-9999 -8888 -6666=.)
recode PRDAY195                  (-9999 -8888 -6666=.)
recode PRDAY196                  (-9999 -8888 -6666=.)
recode PRDAY197                  (-9999 -8888 -6666=.)
recode PRDAY198                  (-9999 -8888 -6666=.)
recode PRDAY199                  (-9999 -8888 -6666=.)
recode PRDAY200                  (-9999 -8888 -6666=.)
recode PSTCO_GEO                 (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode RACE_PCT_MISS_HOSP        (-999.99 -888.88 -666.66=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode VisitLink                 (-99999999 -88888888 -66666666=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRMONTH2                  (-9 -8 -6 -5=.)
recode PRMONTH3                  (-9 -8 -6 -5=.)
recode PRMONTH4                  (-9 -8 -6 -5=.)
recode PRMONTH5                  (-9 -8 -6 -5=.)
recode PRMONTH6                  (-9 -8 -6 -5=.)
recode PRMONTH7                  (-9 -8 -6 -5=.)
recode PRMONTH8                  (-9 -8 -6 -5=.)
recode PRMONTH9                  (-9 -8 -6 -5=.)
recode PRMONTH10                 (-9 -8 -6 -5=.)
recode PRMONTH11                 (-9 -8 -6 -5=.)
recode PRMONTH12                 (-9 -8 -6 -5=.)
recode PRMONTH13                 (-9 -8 -6 -5=.)
recode PRMONTH14                 (-9 -8 -6 -5=.)
recode PRMONTH15                 (-9 -8 -6 -5=.)
recode PRMONTH16                 (-9 -8 -6 -5=.)
recode PRMONTH17                 (-9 -8 -6 -5=.)
recode PRMONTH18                 (-9 -8 -6 -5=.)
recode PRMONTH19                 (-9 -8 -6 -5=.)
recode PRMONTH20                 (-9 -8 -6 -5=.)
recode PRMONTH21                 (-9 -8 -6 -5=.)
recode PRMONTH22                 (-9 -8 -6 -5=.)
recode PRMONTH23                 (-9 -8 -6 -5=.)
recode PRMONTH24                 (-9 -8 -6 -5=.)
recode PRMONTH25                 (-9 -8 -6 -5=.)
recode PRMONTH26                 (-9 -8 -6 -5=.)
recode PRMONTH27                 (-9 -8 -6 -5=.)
recode PRMONTH28                 (-9 -8 -6 -5=.)
recode PRMONTH29                 (-9 -8 -6 -5=.)
recode PRMONTH30                 (-9 -8 -6 -5=.)
recode PRMONTH31                 (-9 -8 -6 -5=.)
recode PRMONTH32                 (-9 -8 -6 -5=.)
recode PRMONTH33                 (-9 -8 -6 -5=.)
recode PRMONTH34                 (-9 -8 -6 -5=.)
recode PRMONTH35                 (-9 -8 -6 -5=.)
recode PRMONTH36                 (-9 -8 -6 -5=.)
recode PRMONTH37                 (-9 -8 -6 -5=.)
recode PRMONTH38                 (-9 -8 -6 -5=.)
recode PRMONTH39                 (-9 -8 -6 -5=.)
recode PRMONTH40                 (-9 -8 -6 -5=.)
recode PRMONTH41                 (-9 -8 -6 -5=.)
recode PRMONTH42                 (-9 -8 -6 -5=.)
recode PRMONTH43                 (-9 -8 -6 -5=.)
recode PRMONTH44                 (-9 -8 -6 -5=.)
recode PRMONTH45                 (-9 -8 -6 -5=.)
recode PRMONTH46                 (-9 -8 -6 -5=.)
recode PRMONTH47                 (-9 -8 -6 -5=.)
recode PRMONTH48                 (-9 -8 -6 -5=.)
recode PRMONTH49                 (-9 -8 -6 -5=.)
recode PRMONTH50                 (-9 -8 -6 -5=.)
recode PRMONTH51                 (-9 -8 -6 -5=.)
recode PRMONTH52                 (-9 -8 -6 -5=.)
recode PRMONTH53                 (-9 -8 -6 -5=.)
recode PRMONTH54                 (-9 -8 -6 -5=.)
recode PRMONTH55                 (-9 -8 -6 -5=.)
recode PRMONTH56                 (-9 -8 -6 -5=.)
recode PRMONTH57                 (-9 -8 -6 -5=.)
recode PRMONTH58                 (-9 -8 -6 -5=.)
recode PRMONTH59                 (-9 -8 -6 -5=.)
recode PRMONTH60                 (-9 -8 -6 -5=.)
recode PRMONTH61                 (-9 -8 -6 -5=.)
recode PRMONTH62                 (-9 -8 -6 -5=.)
recode PRMONTH63                 (-9 -8 -6 -5=.)
recode PRMONTH64                 (-9 -8 -6 -5=.)
recode PRMONTH65                 (-9 -8 -6 -5=.)
recode PRMONTH66                 (-9 -8 -6 -5=.)
recode PRMONTH67                 (-9 -8 -6 -5=.)
recode PRMONTH68                 (-9 -8 -6 -5=.)
recode PRMONTH69                 (-9 -8 -6 -5=.)
recode PRMONTH70                 (-9 -8 -6 -5=.)
recode PRMONTH71                 (-9 -8 -6 -5=.)
recode PRMONTH72                 (-9 -8 -6 -5=.)
recode PRMONTH73                 (-9 -8 -6 -5=.)
recode PRMONTH74                 (-9 -8 -6 -5=.)
recode PRMONTH75                 (-9 -8 -6 -5=.)
recode PRMONTH76                 (-9 -8 -6 -5=.)
recode PRMONTH77                 (-9 -8 -6 -5=.)
recode PRMONTH78                 (-9 -8 -6 -5=.)
recode PRMONTH79                 (-9 -8 -6 -5=.)
recode PRMONTH80                 (-9 -8 -6 -5=.)
recode PRMONTH81                 (-9 -8 -6 -5=.)
recode PRMONTH82                 (-9 -8 -6 -5=.)
recode PRMONTH83                 (-9 -8 -6 -5=.)
recode PRMONTH84                 (-9 -8 -6 -5=.)
recode PRMONTH85                 (-9 -8 -6 -5=.)
recode PRMONTH86                 (-9 -8 -6 -5=.)
recode PRMONTH87                 (-9 -8 -6 -5=.)
recode PRMONTH88                 (-9 -8 -6 -5=.)
recode PRMONTH89                 (-9 -8 -6 -5=.)
recode PRMONTH90                 (-9 -8 -6 -5=.)
recode PRMONTH91                 (-9 -8 -6 -5=.)
recode PRMONTH92                 (-9 -8 -6 -5=.)
recode PRMONTH93                 (-9 -8 -6 -5=.)
recode PRMONTH94                 (-9 -8 -6 -5=.)
recode PRMONTH95                 (-9 -8 -6 -5=.)
recode PRMONTH96                 (-9 -8 -6 -5=.)
recode PRMONTH97                 (-9 -8 -6 -5=.)
recode PRMONTH98                 (-9 -8 -6 -5=.)
recode PRMONTH99                 (-9 -8 -6 -5=.)
recode PRMONTH100                (-9 -8 -6 -5=.)
recode PRMONTH101                (-9 -8 -6 -5=.)
recode PRMONTH102                (-9 -8 -6 -5=.)
recode PRMONTH103                (-9 -8 -6 -5=.)
recode PRMONTH104                (-9 -8 -6 -5=.)
recode PRMONTH105                (-9 -8 -6 -5=.)
recode PRMONTH106                (-9 -8 -6 -5=.)
recode PRMONTH107                (-9 -8 -6 -5=.)
recode PRMONTH108                (-9 -8 -6 -5=.)
recode PRMONTH109                (-9 -8 -6 -5=.)
recode PRMONTH110                (-9 -8 -6 -5=.)
recode PRMONTH111                (-9 -8 -6 -5=.)
recode PRMONTH112                (-9 -8 -6 -5=.)
recode PRMONTH113                (-9 -8 -6 -5=.)
recode PRMONTH114                (-9 -8 -6 -5=.)
recode PRMONTH115                (-9 -8 -6 -5=.)
recode PRMONTH116                (-9 -8 -6 -5=.)
recode PRMONTH117                (-9 -8 -6 -5=.)
recode PRMONTH118                (-9 -8 -6 -5=.)
recode PRMONTH119                (-9 -8 -6 -5=.)
recode PRMONTH120                (-9 -8 -6 -5=.)
recode PRMONTH121                (-9 -8 -6 -5=.)
recode PRMONTH122                (-9 -8 -6 -5=.)
recode PRMONTH123                (-9 -8 -6 -5=.)
recode PRMONTH124                (-9 -8 -6 -5=.)
recode PRMONTH125                (-9 -8 -6 -5=.)
recode PRMONTH126                (-9 -8 -6 -5=.)
recode PRMONTH127                (-9 -8 -6 -5=.)
recode PRMONTH128                (-9 -8 -6 -5=.)
recode PRMONTH129                (-9 -8 -6 -5=.)
recode PRMONTH130                (-9 -8 -6 -5=.)
recode PRMONTH131                (-9 -8 -6 -5=.)
recode PRMONTH132                (-9 -8 -6 -5=.)
recode PRMONTH133                (-9 -8 -6 -5=.)
recode PRMONTH134                (-9 -8 -6 -5=.)
recode PRMONTH135                (-9 -8 -6 -5=.)
recode PRMONTH136                (-9 -8 -6 -5=.)
recode PRMONTH137                (-9 -8 -6 -5=.)
recode PRMONTH138                (-9 -8 -6 -5=.)
recode PRMONTH139                (-9 -8 -6 -5=.)
recode PRMONTH140                (-9 -8 -6 -5=.)
recode PRMONTH141                (-9 -8 -6 -5=.)
recode PRMONTH142                (-9 -8 -6 -5=.)
recode PRMONTH143                (-9 -8 -6 -5=.)
recode PRMONTH144                (-9 -8 -6 -5=.)
recode PRMONTH145                (-9 -8 -6 -5=.)
recode PRMONTH146                (-9 -8 -6 -5=.)
recode PRMONTH147                (-9 -8 -6 -5=.)
recode PRMONTH148                (-9 -8 -6 -5=.)
recode PRMONTH149                (-9 -8 -6 -5=.)
recode PRMONTH150                (-9 -8 -6 -5=.)
recode PRMONTH151                (-9 -8 -6 -5=.)
recode PRMONTH152                (-9 -8 -6 -5=.)
recode PRMONTH153                (-9 -8 -6 -5=.)
recode PRMONTH154                (-9 -8 -6 -5=.)
recode PRMONTH155                (-9 -8 -6 -5=.)
recode PRMONTH156                (-9 -8 -6 -5=.)
recode PRMONTH157                (-9 -8 -6 -5=.)
recode PRMONTH158                (-9 -8 -6 -5=.)
recode PRMONTH159                (-9 -8 -6 -5=.)
recode PRMONTH160                (-9 -8 -6 -5=.)
recode PRMONTH161                (-9 -8 -6 -5=.)
recode PRMONTH162                (-9 -8 -6 -5=.)
recode PRMONTH163                (-9 -8 -6 -5=.)
recode PRMONTH164                (-9 -8 -6 -5=.)
recode PRMONTH165                (-9 -8 -6 -5=.)
recode PRMONTH166                (-9 -8 -6 -5=.)
recode PRMONTH167                (-9 -8 -6 -5=.)
recode PRMONTH168                (-9 -8 -6 -5=.)
recode PRMONTH169                (-9 -8 -6 -5=.)
recode PRMONTH170                (-9 -8 -6 -5=.)
recode PRMONTH171                (-9 -8 -6 -5=.)
recode PRMONTH172                (-9 -8 -6 -5=.)
recode PRMONTH173                (-9 -8 -6 -5=.)
recode PRMONTH174                (-9 -8 -6 -5=.)
recode PRMONTH175                (-9 -8 -6 -5=.)
recode PRMONTH176                (-9 -8 -6 -5=.)
recode PRMONTH177                (-9 -8 -6 -5=.)
recode PRMONTH178                (-9 -8 -6 -5=.)
recode PRMONTH179                (-9 -8 -6 -5=.)
recode PRMONTH180                (-9 -8 -6 -5=.)
recode PRMONTH181                (-9 -8 -6 -5=.)
recode PRMONTH182                (-9 -8 -6 -5=.)
recode PRMONTH183                (-9 -8 -6 -5=.)
recode PRMONTH184                (-9 -8 -6 -5=.)
recode PRMONTH185                (-9 -8 -6 -5=.)
recode PRMONTH186                (-9 -8 -6 -5=.)
recode PRMONTH187                (-9 -8 -6 -5=.)
recode PRMONTH188                (-9 -8 -6 -5=.)
recode PRMONTH189                (-9 -8 -6 -5=.)
recode PRMONTH190                (-9 -8 -6 -5=.)
recode PRMONTH191                (-9 -8 -6 -5=.)
recode PRMONTH192                (-9 -8 -6 -5=.)
recode PRMONTH193                (-9 -8 -6 -5=.)
recode PRMONTH194                (-9 -8 -6 -5=.)
recode PRMONTH195                (-9 -8 -6 -5=.)
recode PRMONTH196                (-9 -8 -6 -5=.)
recode PRMONTH197                (-9 -8 -6 -5=.)
recode PRMONTH198                (-9 -8 -6 -5=.)
recode PRMONTH199                (-9 -8 -6 -5=.)
recode PRMONTH200                (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)
recode PRYEAR2                   (-999 -888 -666=.)
recode PRYEAR3                   (-999 -888 -666=.)
recode PRYEAR4                   (-999 -888 -666=.)
recode PRYEAR5                   (-999 -888 -666=.)
recode PRYEAR6                   (-999 -888 -666=.)
recode PRYEAR7                   (-999 -888 -666=.)
recode PRYEAR8                   (-999 -888 -666=.)
recode PRYEAR9                   (-999 -888 -666=.)
recode PRYEAR10                  (-999 -888 -666=.)
recode PRYEAR11                  (-999 -888 -666=.)
recode PRYEAR12                  (-999 -888 -666=.)
recode PRYEAR13                  (-999 -888 -666=.)
recode PRYEAR14                  (-999 -888 -666=.)
recode PRYEAR15                  (-999 -888 -666=.)
recode PRYEAR16                  (-999 -888 -666=.)
recode PRYEAR17                  (-999 -888 -666=.)
recode PRYEAR18                  (-999 -888 -666=.)
recode PRYEAR19                  (-999 -888 -666=.)
recode PRYEAR20                  (-999 -888 -666=.)
recode PRYEAR21                  (-999 -888 -666=.)
recode PRYEAR22                  (-999 -888 -666=.)
recode PRYEAR23                  (-999 -888 -666=.)
recode PRYEAR24                  (-999 -888 -666=.)
recode PRYEAR25                  (-999 -888 -666=.)
recode PRYEAR26                  (-999 -888 -666=.)
recode PRYEAR27                  (-999 -888 -666=.)
recode PRYEAR28                  (-999 -888 -666=.)
recode PRYEAR29                  (-999 -888 -666=.)
recode PRYEAR30                  (-999 -888 -666=.)
recode PRYEAR31                  (-999 -888 -666=.)
recode PRYEAR32                  (-999 -888 -666=.)
recode PRYEAR33                  (-999 -888 -666=.)
recode PRYEAR34                  (-999 -888 -666=.)
recode PRYEAR35                  (-999 -888 -666=.)
recode PRYEAR36                  (-999 -888 -666=.)
recode PRYEAR37                  (-999 -888 -666=.)
recode PRYEAR38                  (-999 -888 -666=.)
recode PRYEAR39                  (-999 -888 -666=.)
recode PRYEAR40                  (-999 -888 -666=.)
recode PRYEAR41                  (-999 -888 -666=.)
recode PRYEAR42                  (-999 -888 -666=.)
recode PRYEAR43                  (-999 -888 -666=.)
recode PRYEAR44                  (-999 -888 -666=.)
recode PRYEAR45                  (-999 -888 -666=.)
recode PRYEAR46                  (-999 -888 -666=.)
recode PRYEAR47                  (-999 -888 -666=.)
recode PRYEAR48                  (-999 -888 -666=.)
recode PRYEAR49                  (-999 -888 -666=.)
recode PRYEAR50                  (-999 -888 -666=.)
recode PRYEAR51                  (-999 -888 -666=.)
recode PRYEAR52                  (-999 -888 -666=.)
recode PRYEAR53                  (-999 -888 -666=.)
recode PRYEAR54                  (-999 -888 -666=.)
recode PRYEAR55                  (-999 -888 -666=.)
recode PRYEAR56                  (-999 -888 -666=.)
recode PRYEAR57                  (-999 -888 -666=.)
recode PRYEAR58                  (-999 -888 -666=.)
recode PRYEAR59                  (-999 -888 -666=.)
recode PRYEAR60                  (-999 -888 -666=.)
recode PRYEAR61                  (-999 -888 -666=.)
recode PRYEAR62                  (-999 -888 -666=.)
recode PRYEAR63                  (-999 -888 -666=.)
recode PRYEAR64                  (-999 -888 -666=.)
recode PRYEAR65                  (-999 -888 -666=.)
recode PRYEAR66                  (-999 -888 -666=.)
recode PRYEAR67                  (-999 -888 -666=.)
recode PRYEAR68                  (-999 -888 -666=.)
recode PRYEAR69                  (-999 -888 -666=.)
recode PRYEAR70                  (-999 -888 -666=.)
recode PRYEAR71                  (-999 -888 -666=.)
recode PRYEAR72                  (-999 -888 -666=.)
recode PRYEAR73                  (-999 -888 -666=.)
recode PRYEAR74                  (-999 -888 -666=.)
recode PRYEAR75                  (-999 -888 -666=.)
recode PRYEAR76                  (-999 -888 -666=.)
recode PRYEAR77                  (-999 -888 -666=.)
recode PRYEAR78                  (-999 -888 -666=.)
recode PRYEAR79                  (-999 -888 -666=.)
recode PRYEAR80                  (-999 -888 -666=.)
recode PRYEAR81                  (-999 -888 -666=.)
recode PRYEAR82                  (-999 -888 -666=.)
recode PRYEAR83                  (-999 -888 -666=.)
recode PRYEAR84                  (-999 -888 -666=.)
recode PRYEAR85                  (-999 -888 -666=.)
recode PRYEAR86                  (-999 -888 -666=.)
recode PRYEAR87                  (-999 -888 -666=.)
recode PRYEAR88                  (-999 -888 -666=.)
recode PRYEAR89                  (-999 -888 -666=.)
recode PRYEAR90                  (-999 -888 -666=.)
recode PRYEAR91                  (-999 -888 -666=.)
recode PRYEAR92                  (-999 -888 -666=.)
recode PRYEAR93                  (-999 -888 -666=.)
recode PRYEAR94                  (-999 -888 -666=.)
recode PRYEAR95                  (-999 -888 -666=.)
recode PRYEAR96                  (-999 -888 -666=.)
recode PRYEAR97                  (-999 -888 -666=.)
recode PRYEAR98                  (-999 -888 -666=.)
recode PRYEAR99                  (-999 -888 -666=.)
recode PRYEAR100                 (-999 -888 -666=.)
recode PRYEAR101                 (-999 -888 -666=.)
recode PRYEAR102                 (-999 -888 -666=.)
recode PRYEAR103                 (-999 -888 -666=.)
recode PRYEAR104                 (-999 -888 -666=.)
recode PRYEAR105                 (-999 -888 -666=.)
recode PRYEAR106                 (-999 -888 -666=.)
recode PRYEAR107                 (-999 -888 -666=.)
recode PRYEAR108                 (-999 -888 -666=.)
recode PRYEAR109                 (-999 -888 -666=.)
recode PRYEAR110                 (-999 -888 -666=.)
recode PRYEAR111                 (-999 -888 -666=.)
recode PRYEAR112                 (-999 -888 -666=.)
recode PRYEAR113                 (-999 -888 -666=.)
recode PRYEAR114                 (-999 -888 -666=.)
recode PRYEAR115                 (-999 -888 -666=.)
recode PRYEAR116                 (-999 -888 -666=.)
recode PRYEAR117                 (-999 -888 -666=.)
recode PRYEAR118                 (-999 -888 -666=.)
recode PRYEAR119                 (-999 -888 -666=.)
recode PRYEAR120                 (-999 -888 -666=.)
recode PRYEAR121                 (-999 -888 -666=.)
recode PRYEAR122                 (-999 -888 -666=.)
recode PRYEAR123                 (-999 -888 -666=.)
recode PRYEAR124                 (-999 -888 -666=.)
recode PRYEAR125                 (-999 -888 -666=.)
recode PRYEAR126                 (-999 -888 -666=.)
recode PRYEAR127                 (-999 -888 -666=.)
recode PRYEAR128                 (-999 -888 -666=.)
recode PRYEAR129                 (-999 -888 -666=.)
recode PRYEAR130                 (-999 -888 -666=.)
recode PRYEAR131                 (-999 -888 -666=.)
recode PRYEAR132                 (-999 -888 -666=.)
recode PRYEAR133                 (-999 -888 -666=.)
recode PRYEAR134                 (-999 -888 -666=.)
recode PRYEAR135                 (-999 -888 -666=.)
recode PRYEAR136                 (-999 -888 -666=.)
recode PRYEAR137                 (-999 -888 -666=.)
recode PRYEAR138                 (-999 -888 -666=.)
recode PRYEAR139                 (-999 -888 -666=.)
recode PRYEAR140                 (-999 -888 -666=.)
recode PRYEAR141                 (-999 -888 -666=.)
recode PRYEAR142                 (-999 -888 -666=.)
recode PRYEAR143                 (-999 -888 -666=.)
recode PRYEAR144                 (-999 -888 -666=.)
recode PRYEAR145                 (-999 -888 -666=.)
recode PRYEAR146                 (-999 -888 -666=.)
recode PRYEAR147                 (-999 -888 -666=.)
recode PRYEAR148                 (-999 -888 -666=.)
recode PRYEAR149                 (-999 -888 -666=.)
recode PRYEAR150                 (-999 -888 -666=.)
recode PRYEAR151                 (-999 -888 -666=.)
recode PRYEAR152                 (-999 -888 -666=.)
recode PRYEAR153                 (-999 -888 -666=.)
recode PRYEAR154                 (-999 -888 -666=.)
recode PRYEAR155                 (-999 -888 -666=.)
recode PRYEAR156                 (-999 -888 -666=.)
recode PRYEAR157                 (-999 -888 -666=.)
recode PRYEAR158                 (-999 -888 -666=.)
recode PRYEAR159                 (-999 -888 -666=.)
recode PRYEAR160                 (-999 -888 -666=.)
recode PRYEAR161                 (-999 -888 -666=.)
recode PRYEAR162                 (-999 -888 -666=.)
recode PRYEAR163                 (-999 -888 -666=.)
recode PRYEAR164                 (-999 -888 -666=.)
recode PRYEAR165                 (-999 -888 -666=.)
recode PRYEAR166                 (-999 -888 -666=.)
recode PRYEAR167                 (-999 -888 -666=.)
recode PRYEAR168                 (-999 -888 -666=.)
recode PRYEAR169                 (-999 -888 -666=.)
recode PRYEAR170                 (-999 -888 -666=.)
recode PRYEAR171                 (-999 -888 -666=.)
recode PRYEAR172                 (-999 -888 -666=.)
recode PRYEAR173                 (-999 -888 -666=.)
recode PRYEAR174                 (-999 -888 -666=.)
recode PRYEAR175                 (-999 -888 -666=.)
recode PRYEAR176                 (-999 -888 -666=.)
recode PRYEAR177                 (-999 -888 -666=.)
recode PRYEAR178                 (-999 -888 -666=.)
recode PRYEAR179                 (-999 -888 -666=.)
recode PRYEAR180                 (-999 -888 -666=.)
recode PRYEAR181                 (-999 -888 -666=.)
recode PRYEAR182                 (-999 -888 -666=.)
recode PRYEAR183                 (-999 -888 -666=.)
recode PRYEAR184                 (-999 -888 -666=.)
recode PRYEAR185                 (-999 -888 -666=.)
recode PRYEAR186                 (-999 -888 -666=.)
recode PRYEAR187                 (-999 -888 -666=.)
recode PRYEAR188                 (-999 -888 -666=.)
recode PRYEAR189                 (-999 -888 -666=.)
recode PRYEAR190                 (-999 -888 -666=.)
recode PRYEAR191                 (-999 -888 -666=.)
recode PRYEAR192                 (-999 -888 -666=.)
recode PRYEAR193                 (-999 -888 -666=.)
recode PRYEAR194                 (-999 -888 -666=.)
recode PRYEAR195                 (-999 -888 -666=.)
recode PRYEAR196                 (-999 -888 -666=.)
recode PRYEAR197                 (-999 -888 -666=.)
recode PRYEAR198                 (-999 -888 -666=.)
recode PRYEAR199                 (-999 -888 -666=.)
recode PRYEAR200                 (-999 -888 -666=.)

save "MA_SID_2021_CORE.dta", replace
