/*****************************************************************************
* Creation Date: 02/17/2025   
* GA_SID_2023_DX_PR_GRPS.Do
* This program will load the 2023 GA ASCII DX_PR_GRPS File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/*** Set available memory size ***/
set mem 500m

/*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***/
infix 3 firstlineoffile                            ///
      str    CCIR_VERSION                 1-   6   ///
      int    CCIR1                        7-   9   ///
      int    CCIR2                       10-  12   ///
      int    CCIR3                       13-  15   ///
      int    CCIR4                       16-  18   ///
      int    CCIR5                       19-  21   ///
      int    CCIR6                       22-  24   ///
      int    CCIR7                       25-  27   ///
      int    CCIR8                       28-  30   ///
      int    CCIR9                       31-  33   ///
      int    CCIR10                      34-  36   ///
      int    CCIR11                      37-  39   ///
      int    CCIR12                      40-  42   ///
      int    CCIR13                      43-  45   ///
      int    CCIR14                      46-  48   ///
      int    CCIR15                      49-  51   ///
      int    CCIR16                      52-  54   ///
      int    CCIR17                      55-  57   ///
      int    CCIR18                      58-  60   ///
      int    CCIR19                      61-  63   ///
      int    CCIR20                      64-  66   ///
      int    CCIR21                      67-  69   ///
      int    CCIR22                      70-  72   ///
      int    CCIR23                      73-  75   ///
      int    CCIR24                      76-  78   ///
      int    CCIR25                      79-  81   ///
      int    CCIR26                      82-  84   ///
      int    CCIR27                      85-  87   ///
      int    CCIR28                      88-  90   ///
      int    CCIR29                      91-  93   ///
      int    CCIR30                      94-  96   ///
      int    CCIR31                      97-  99   ///
      int    CCIR32                     100- 102   ///
      int    CCIR33                     103- 105   ///
      int    CCIR34                     106- 108   ///
      int    CCIR35                     109- 111   ///
      int    CCIR36                     112- 114   ///
      int    CCIR37                     115- 117   ///
      int    CCIR38                     118- 120   ///
      int    CCIR39                     121- 123   ///
      int    CCIR40                     124- 126   ///
      int    CCIR41                     127- 129   ///
      int    CCIR42                     130- 132   ///
      int    CCIR43                     133- 135   ///
      int    CCIR44                     136- 138   ///
      int    CCIR45                     139- 141   ///
      int    CCIR46                     142- 144   ///
      int    CCIR47                     145- 147   ///
      int    CCIR48                     148- 150   ///
      int    CCIR49                     151- 153   ///
      int    CCIR50                     154- 156   ///
      int    CCIR51                     157- 159   ///
      int    CCIR52                     160- 162   ///
      int    CCIR53                     163- 165   ///
      int    CCIR54                     166- 168   ///
      int    CCIR55                     169- 171   ///
      int    CCIR56                     172- 174   ///
      int    CCIR57                     175- 177   ///
      int    CCIR58                     178- 180   ///
      int    CCIR59                     181- 183   ///
      int    CCIR60                     184- 186   ///
      int    CCIR61                     187- 189   ///
      int    CCIR62                     190- 192   ///
      int    CCIR63                     193- 195   ///
      int    CCIR64                     196- 198   ///
      int    CCIR65                     199- 201   ///
      int    CCIR66                     202- 204   ///
      int    CCIR67                     205- 207   ///
      int    CCIR68                     208- 210   ///
      int    CCIR69                     211- 213   ///
      int    CCIR70                     214- 216   ///
      int    CCIR71                     217- 219   ///
      int    CCIR72                     220- 222   ///
      int    CCIR73                     223- 225   ///
      int    CCIR74                     226- 228   ///
      int    CCIR75                     229- 231   ///
      int    CCIR76                     232- 234   ///
      int    CCIR77                     235- 237   ///
      int    CCIR78                     238- 240   ///
      int    CCIR79                     241- 243   ///
      int    CCIR80                     244- 246   ///
      int    CCIR81                     247- 249   ///
      int    CCIR82                     250- 252   ///
      int    CCIR83                     253- 255   ///
      int    CCIR84                     256- 258   ///
      int    CCIR85                     259- 261   ///
      int    CCIR86                     262- 264   ///
      int    CCIR87                     265- 267   ///
      int    CCIR88                     268- 270   ///
      int    CCIR89                     271- 273   ///
      int    CCIR90                     274- 276   ///
      int    CCIR91                     277- 279   ///
      int    CCIR92                     280- 282   ///
      int    CCIR93                     283- 285   ///
      int    CCIR94                     286- 288   ///
      int    CCIR95                     289- 291   ///
      int    CCIR96                     292- 294   ///
      int    CCIR97                     295- 297   ///
      int    CCIR98                     298- 300   ///
      int    CCIR99                     301- 303   ///
      int    CCIR100                    304- 306   ///
      int    CCIR101                    307- 309   ///
      int    CCIR102                    310- 312   ///
      int    CCIR103                    313- 315   ///
      int    CCIR104                    316- 318   ///
      int    CCIR105                    319- 321   ///
      int    CCIR106                    322- 324   ///
      int    CCIR107                    325- 327   ///
      int    CCIR108                    328- 330   ///
      int    CCIR109                    331- 333   ///
      int    CCIR110                    334- 336   ///
      int    CCIR111                    337- 339   ///
      int    CCIR112                    340- 342   ///
      int    CCIR113                    343- 345   ///
      int    CCIR114                    346- 348   ///
      int    CCIR115                    349- 351   ///
      int    CCIR116                    352- 354   ///
      int    CCIR117                    355- 357   ///
      int    CCIR118                    358- 360   ///
      int    CCIR119                    361- 363   ///
      int    CCIR120                    364- 366   ///
      int    CCIR121                    367- 369   ///
      int    CCIR122                    370- 372   ///
      int    CCIR123                    373- 375   ///
      int    CCIR124                    376- 378   ///
      int    CCIR125                    379- 381   ///
      int    CCIR126                    382- 384   ///
      int    CCIR127                    385- 387   ///
      int    CCIR128                    388- 390   ///
      int    CCIR129                    391- 393   ///
      int    CCIR130                    394- 396   ///
      int    CCIR131                    397- 399   ///
      int    CCIR132                    400- 402   ///
      int    CCIR133                    403- 405   ///
      int    CCIR134                    406- 408   ///
      int    CCIR135                    409- 411   ///
      int    CCIR136                    412- 414   ///
      byte   CMR_AIDS                   415- 416   ///
      byte   CMR_ALCOHOL                417- 418   ///
      byte   CMR_ANEMDEF                419- 420   ///
      byte   CMR_AUTOIMMUNE             421- 422   ///
      byte   CMR_BLDLOSS                423- 424   ///
      byte   CMR_CANCER_LEUK            425- 426   ///
      byte   CMR_CANCER_LYMPH           427- 428   ///
      byte   CMR_CANCER_METS            429- 430   ///
      byte   CMR_CANCER_NSITU           431- 432   ///
      byte   CMR_CANCER_SOLID           433- 434   ///
      byte   CMR_CBVD                   435- 436   ///
      byte   CMR_COAG                   437- 438   ///
      byte   CMR_DEMENTIA               439- 440   ///
      byte   CMR_DEPRESS                441- 442   ///
      byte   CMR_DIAB_CX                443- 444   ///
      byte   CMR_DIAB_UNCX              445- 446   ///
      byte   CMR_DRUG_ABUSE             447- 448   ///
      byte   CMR_HF                     449- 450   ///
      byte   CMR_HTN_CX                 451- 452   ///
      byte   CMR_HTN_UNCX               453- 454   ///
      byte   CMR_LIVER_MLD              455- 456   ///
      byte   CMR_LIVER_SEV              457- 458   ///
      byte   CMR_LUNG_CHRONIC           459- 460   ///
      byte   CMR_NEURO_MOVT             461- 462   ///
      byte   CMR_NEURO_OTH              463- 464   ///
      byte   CMR_NEURO_SEIZ             465- 466   ///
      byte   CMR_OBESE                  467- 468   ///
      byte   CMR_PARALYSIS              469- 470   ///
      byte   CMR_PERIVASC               471- 472   ///
      byte   CMR_PSYCHOSES              473- 474   ///
      byte   CMR_PULMCIRC               475- 476   ///
      byte   CMR_RENLFL_MOD             477- 478   ///
      byte   CMR_RENLFL_SEV             479- 480   ///
      byte   CMR_THYROID_HYPO           481- 482   ///
      byte   CMR_THYROID_OTH            483- 484   ///
      byte   CMR_ULCER_PEPTIC           485- 486   ///
      byte   CMR_VALVE                  487- 488   ///
      str    CMR_VERSION                489- 494   ///
      byte   CMR_WGHTLOSS               495- 496   ///
      byte   I10_INJURY                 497- 498   ///
      byte   I10_INJURY_CUT             499- 500   ///
      byte   I10_INJURY_DROWN           501- 502   ///
      byte   I10_INJURY_FALL            503- 504   ///
      byte   I10_INJURY_FIRE            505- 506   ///
      byte   I10_INJURY_FIREARM         507- 508   ///
      byte   I10_INJURY_MACHINERY       509- 510   ///
      byte   I10_INJURY_MVT             511- 512   ///
      byte   I10_INJURY_NATURE          513- 514   ///
      byte   I10_INJURY_OVEREXERTION    515- 516   ///
      byte   I10_INJURY_POISON          517- 518   ///
      byte   I10_INJURY_STRUCK          519- 520   ///
      byte   I10_INJURY_SUFFOCATION     521- 522   ///
      byte   I10_INTENT_ASSAULT         523- 524   ///
      byte   I10_INTENT_SELF_HARM       525- 526   ///
      byte   I10_INTENT_UNINTENTIONAL   527- 528   ///
      byte   I10_MULTINJURY             529- 530   ///
      double KEY                        531- 545   ///
      str    PCLASS_VERSION             546- 551   ///
      byte   PCLASS1                    552- 553   ///
      byte   PCLASS2                    554- 555   ///
      byte   PCLASS3                    556- 557   ///
      byte   PCLASS4                    558- 559   ///
      byte   PCLASS5                    560- 561   ///
      byte   PCLASS6                    562- 563   ///
      byte   PCLASS7                    564- 565   ///
      byte   PCLASS8                    566- 567   ///
      byte   PCLASS9                    568- 569   ///
      byte   PCLASS10                   570- 571   ///
      byte   PCLASS11                   572- 573   ///
      byte   PCLASS12                   574- 575   ///
      byte   PCLASS13                   576- 577   ///
      byte   PCLASS14                   578- 579   ///
      byte   PCLASS15                   580- 581   ///
      byte   PCLASS16                   582- 583   ///
      byte   PCLASS17                   584- 585   ///
      byte   PCLASS18                   586- 587   ///
      byte   PCLASS19                   588- 589   ///
      byte   PCLASS20                   590- 591   ///
      byte   PCLASS21                   592- 593   ///
      byte   PCLASS22                   594- 595   ///
      byte   PCLASS23                   596- 597   ///
      byte   PCLASS24                   598- 599   ///
      byte   PCLASS25                   600- 601   ///
      byte   PCLASS26                   602- 603   ///
      byte   PCLASS27                   604- 605   ///
      byte   PCLASS28                   606- 607   ///
      byte   PCLASS29                   608- 609   ///
      byte   PCLASS30                   610- 611   ///
      byte   PCLASS31                   612- 613   ///
      byte   PCLASS32                   614- 615   ///
      byte   PCLASS33                   616- 617   ///
      byte   PCLASS34                   618- 619   ///
      byte   PCLASS35                   620- 621   ///
      byte   PCLASS36                   622- 623   ///
      byte   PCLASS37                   624- 625   ///
      byte   PCLASS38                   626- 627   ///
      byte   PCLASS39                   628- 629   ///
      byte   PCLASS40                   630- 631   ///
      byte   PCLASS41                   632- 633   ///
      byte   PCLASS42                   634- 635   ///
      byte   PCLASS43                   636- 637   ///
      byte   PCLASS44                   638- 639   ///
      byte   PCLASS45                   640- 641   ///
      byte   PCLASS46                   642- 643   ///
      byte   PCLASS47                   644- 645   ///
      byte   PCLASS48                   646- 647   ///
      byte   PCLASS49                   648- 649   ///
      byte   PCLASS50                   650- 651   ///
      byte   PCLASS51                   652- 653   ///
      byte   PCLASS52                   654- 655   ///
      byte   PCLASS53                   656- 657   ///
      byte   PCLASS54                   658- 659   ///
      byte   PCLASS55                   660- 661   ///
      byte   PCLASS56                   662- 663   ///
      byte   PCLASS57                   664- 665   ///
      byte   PCLASS58                   666- 667   ///
      byte   PCLASS59                   668- 669   ///
      byte   PCLASS60                   670- 671   ///
      byte   PCLASS61                   672- 673   ///
      byte   PCLASS62                   674- 675   ///
      byte   PCLASS63                   676- 677   ///
      byte   PCLASS64                   678- 679   ///
      byte   PCLASS65                   680- 681   ///
      byte   PCLASS66                   682- 683   ///
      byte   PCLASS67                   684- 685   ///
      byte   PCLASS68                   686- 687   ///
      byte   PCLASS69                   688- 689   ///
      byte   PCLASS70                   690- 691   ///
      byte   PCLASS71                   692- 693   ///
      byte   PCLASS72                   694- 695   ///
      byte   PCLASS73                   696- 697   ///
      byte   PCLASS74                   698- 699   ///
      byte   PCLASS75                   700- 701   ///
      byte   PCLASS76                   702- 703   ///
      byte   PCLASS77                   704- 705   ///
      byte   PCLASS78                   706- 707   ///
      byte   PCLASS79                   708- 709   ///
      byte   PCLASS80                   710- 711   ///
      byte   PCLASS81                   712- 713   ///
      byte   PCLASS82                   714- 715   ///
      byte   PCLASS83                   716- 717   ///
      byte   PCLASS84                   718- 719   ///
      byte   PCLASS85                   720- 721   ///
      byte   PCLASS86                   722- 723   ///
      byte   PCLASS87                   724- 725   ///
      byte   PCLASS88                   726- 727   ///
      byte   PCLASS89                   728- 729   ///
      byte   PCLASS90                   730- 731   ///
      byte   PCLASS91                   732- 733   ///
      byte   PCLASS92                   734- 735   ///
      byte   PCLASS93                   736- 737   ///
      byte   PCLASS94                   738- 739   ///
      byte   PCLASS95                   740- 741   ///
      byte   PCLASS96                   742- 743   ///
      byte   PCLASS97                   744- 745   ///
      byte   PCLASS98                   746- 747   ///
      byte   PCLASS99                   748- 749   ///
      byte   PCLASS100                  750- 751   ///
      byte   PCLASS101                  752- 753   ///
      byte   PCLASS102                  754- 755   ///
      byte   PCLASS103                  756- 757   ///
      byte   PCLASS104                  758- 759   ///
      byte   PCLASS105                  760- 761   ///
      byte   PCLASS106                  762- 763   ///
      byte   PCLASS107                  764- 765   ///
      byte   PCLASS108                  766- 767   ///
      byte   PCLASS109                  768- 769   ///
      byte   PCLASS110                  770- 771   ///
      byte   PCLASS111                  772- 773   ///
      byte   PCLASS112                  774- 775   ///
      byte   PCLASS113                  776- 777   ///
      byte   PCLASS114                  778- 779   ///
      byte   PCLASS115                  780- 781   ///
      byte   PCLASS116                  782- 783   ///
      byte   PCLASS117                  784- 785   ///
      byte   PCLASS118                  786- 787   ///
      byte   PCLASS119                  788- 789   ///
      byte   PCLASS120                  790- 791   ///
      byte   PCLASS121                  792- 793   ///
      byte   PCLASS122                  794- 795   ///
      byte   PCLASS123                  796- 797   ///
      byte   PCLASS124                  798- 799   ///
      byte   PCLASS125                  800- 801   ///
      byte   PCLASS126                  802- 803   ///
      byte   PCLASS127                  804- 805   ///
      byte   PCLASS128                  806- 807   ///
      byte   PCLASS129                  808- 809   ///
      byte   PCLASS130                  810- 811   ///
      byte   PCLASS131                  812- 813   ///
      byte   PCLASS132                  814- 815   ///
      byte   PCLASS133                  816- 817   ///
      byte   PCLASS134                  818- 819   ///
      byte   PCLASS135                  820- 821   ///
      byte   PCLASS136                  822- 823   ///
      byte   PCLASS137                  824- 825   ///
      byte   PCLASS138                  826- 827   ///
      byte   PCLASS139                  828- 829   ///
      byte   PCLASS140                  830- 831   ///
      byte   PCLASS141                  832- 833   ///
      byte   PCLASS142                  834- 835   ///
      byte   PCLASS143                  836- 837   ///
      byte   PCLASS144                  838- 839   ///
      byte   PCLASS145                  840- 841   ///
      byte   PCLASS146                  842- 843   ///
      byte   PCLASS147                  844- 845   ///
      byte   PCLASS148                  846- 847   ///
      byte   PCLASS149                  848- 849   ///
      byte   PCLASS150                  850- 851   ///
      byte   PCLASS151                  852- 853   ///
      byte   PCLASS152                  854- 855   ///
      byte   PCLASS153                  856- 857   ///
      byte   PCLASS154                  858- 859   ///
      byte   PCLASS155                  860- 861   ///
      byte   PCLASS156                  862- 863   ///
      byte   PCLASS157                  864- 865   ///
      byte   PCLASS158                  866- 867   ///
      byte   PCLASS159                  868- 869   ///
      byte   PCLASS160                  870- 871   ///
      byte   PCLASS161                  872- 873   ///
      byte   PCLASS162                  874- 875   ///
      byte   PCLASS163                  876- 877   ///
      byte   PCLASS164                  878- 879   ///
      byte   PCLASS165                  880- 881   ///
      byte   PCLASS166                  882- 883   ///
      byte   PCLASS167                  884- 885   ///
      byte   PCLASS168                  886- 887   ///
      byte   PCLASS169                  888- 889   ///
      byte   PCLASS170                  890- 891   ///
      byte   PCLASS171                  892- 893   ///
      byte   PCLASS172                  894- 895   ///
      byte   PCLASS173                  896- 897   ///
      byte   PCLASS174                  898- 899   ///
      byte   PCLASS175                  900- 901   ///
      byte   PCLASS176                  902- 903   ///
      byte   PCLASS177                  904- 905   ///
      byte   PCLASS178                  906- 907   ///
      byte   PCLASS179                  908- 909   ///
      byte   PCLASS180                  910- 911   ///
      byte   PCLASS181                  912- 913   ///
      byte   PCLASS182                  914- 915   ///
      byte   PCLASS183                  916- 917   ///
      byte   PCLASS184                  918- 919   ///
      byte   PCLASS185                  920- 921   ///
      byte   PCLASS186                  922- 923   ///
      byte   PCLASS187                  924- 925   ///
      byte   PCLASS188                  926- 927   ///
      byte   PCLASS189                  928- 929   ///
      byte   PCLASS190                  930- 931   ///
      byte   PCLASS191                  932- 933   ///
      byte   PCLASS192                  934- 935   ///
      byte   PCLASS193                  936- 937   ///
      byte   PCLASS194                  938- 939   ///
      byte   PCLASS195                  940- 941   ///
      byte   PCLASS196                  942- 943   ///
      byte   PCLASS197                  944- 945   ///
      byte   PCLASS198                  946- 947   ///
      byte   PCLASS199                  948- 949   ///
      byte   PCLASS200                  950- 951   ///
      str    DXCCSR_Default_DX1         952- 957   ///
      int    DXCCSR_BLD001              958- 960   ///
      int    DXCCSR_BLD002              961- 963   ///
      int    DXCCSR_BLD003              964- 966   ///
      int    DXCCSR_BLD004              967- 969   ///
      int    DXCCSR_BLD005              970- 972   ///
      int    DXCCSR_BLD006              973- 975   ///
      int    DXCCSR_BLD007              976- 978   ///
      int    DXCCSR_BLD008              979- 981   ///
      int    DXCCSR_BLD009              982- 984   ///
      int    DXCCSR_BLD010              985- 987   ///
      int    DXCCSR_CIR001              988- 990   ///
      int    DXCCSR_CIR002              991- 993   ///
      int    DXCCSR_CIR003              994- 996   ///
      int    DXCCSR_CIR004              997- 999   ///
      int    DXCCSR_CIR005             1000-1002   ///
      int    DXCCSR_CIR006             1003-1005   ///
      int    DXCCSR_CIR007             1006-1008   ///
      int    DXCCSR_CIR008             1009-1011   ///
      int    DXCCSR_CIR009             1012-1014   ///
      int    DXCCSR_CIR010             1015-1017   ///
      int    DXCCSR_CIR011             1018-1020   ///
      int    DXCCSR_CIR012             1021-1023   ///
      int    DXCCSR_CIR013             1024-1026   ///
      int    DXCCSR_CIR014             1027-1029   ///
      int    DXCCSR_CIR015             1030-1032   ///
      int    DXCCSR_CIR016             1033-1035   ///
      int    DXCCSR_CIR017             1036-1038   ///
      int    DXCCSR_CIR018             1039-1041   ///
      int    DXCCSR_CIR019             1042-1044   ///
      int    DXCCSR_CIR020             1045-1047   ///
      int    DXCCSR_CIR021             1048-1050   ///
      int    DXCCSR_CIR022             1051-1053   ///
      int    DXCCSR_CIR023             1054-1056   ///
      int    DXCCSR_CIR024             1057-1059   ///
      int    DXCCSR_CIR025             1060-1062   ///
      int    DXCCSR_CIR026             1063-1065   ///
      int    DXCCSR_CIR027             1066-1068   ///
      int    DXCCSR_CIR028             1069-1071   ///
      int    DXCCSR_CIR029             1072-1074   ///
      int    DXCCSR_CIR030             1075-1077   ///
      int    DXCCSR_CIR031             1078-1080   ///
      int    DXCCSR_CIR032             1081-1083   ///
      int    DXCCSR_CIR033             1084-1086   ///
      int    DXCCSR_CIR034             1087-1089   ///
      int    DXCCSR_CIR035             1090-1092   ///
      int    DXCCSR_CIR036             1093-1095   ///
      int    DXCCSR_CIR037             1096-1098   ///
      int    DXCCSR_CIR038             1099-1101   ///
      int    DXCCSR_CIR039             1102-1104   ///
      int    DXCCSR_DEN001             1105-1107   ///
      int    DXCCSR_DEN002             1108-1110   ///
      int    DXCCSR_DEN003             1111-1113   ///
      int    DXCCSR_DIG001             1114-1116   ///
      int    DXCCSR_DIG002             1117-1119   ///
      int    DXCCSR_DIG003             1120-1122   ///
      int    DXCCSR_DIG004             1123-1125   ///
      int    DXCCSR_DIG005             1126-1128   ///
      int    DXCCSR_DIG006             1129-1131   ///
      int    DXCCSR_DIG007             1132-1134   ///
      int    DXCCSR_DIG008             1135-1137   ///
      int    DXCCSR_DIG009             1138-1140   ///
      int    DXCCSR_DIG010             1141-1143   ///
      int    DXCCSR_DIG011             1144-1146   ///
      int    DXCCSR_DIG012             1147-1149   ///
      int    DXCCSR_DIG013             1150-1152   ///
      int    DXCCSR_DIG014             1153-1155   ///
      int    DXCCSR_DIG015             1156-1158   ///
      int    DXCCSR_DIG016             1159-1161   ///
      int    DXCCSR_DIG017             1162-1164   ///
      int    DXCCSR_DIG018             1165-1167   ///
      int    DXCCSR_DIG019             1168-1170   ///
      int    DXCCSR_DIG020             1171-1173   ///
      int    DXCCSR_DIG021             1174-1176   ///
      int    DXCCSR_DIG022             1177-1179   ///
      int    DXCCSR_DIG023             1180-1182   ///
      int    DXCCSR_DIG024             1183-1185   ///
      int    DXCCSR_DIG025             1186-1188   ///
      int    DXCCSR_EAR001             1189-1191   ///
      int    DXCCSR_EAR002             1192-1194   ///
      int    DXCCSR_EAR003             1195-1197   ///
      int    DXCCSR_EAR004             1198-1200   ///
      int    DXCCSR_EAR005             1201-1203   ///
      int    DXCCSR_EAR006             1204-1206   ///
      int    DXCCSR_END001             1207-1209   ///
      int    DXCCSR_END002             1210-1212   ///
      int    DXCCSR_END003             1213-1215   ///
      int    DXCCSR_END004             1216-1218   ///
      int    DXCCSR_END005             1219-1221   ///
      int    DXCCSR_END006             1222-1224   ///
      int    DXCCSR_END007             1225-1227   ///
      int    DXCCSR_END008             1228-1230   ///
      int    DXCCSR_END009             1231-1233   ///
      int    DXCCSR_END010             1234-1236   ///
      int    DXCCSR_END011             1237-1239   ///
      int    DXCCSR_END012             1240-1242   ///
      int    DXCCSR_END013             1243-1245   ///
      int    DXCCSR_END014             1246-1248   ///
      int    DXCCSR_END015             1249-1251   ///
      int    DXCCSR_END016             1252-1254   ///
      int    DXCCSR_END017             1255-1257   ///
      int    DXCCSR_EXT001             1258-1260   ///
      int    DXCCSR_EXT002             1261-1263   ///
      int    DXCCSR_EXT003             1264-1266   ///
      int    DXCCSR_EXT004             1267-1269   ///
      int    DXCCSR_EXT005             1270-1272   ///
      int    DXCCSR_EXT006             1273-1275   ///
      int    DXCCSR_EXT007             1276-1278   ///
      int    DXCCSR_EXT008             1279-1281   ///
      int    DXCCSR_EXT009             1282-1284   ///
      int    DXCCSR_EXT010             1285-1287   ///
      int    DXCCSR_EXT011             1288-1290   ///
      int    DXCCSR_EXT012             1291-1293   ///
      int    DXCCSR_EXT013             1294-1296   ///
      int    DXCCSR_EXT014             1297-1299   ///
      int    DXCCSR_EXT015             1300-1302   ///
      int    DXCCSR_EXT016             1303-1305   ///
      int    DXCCSR_EXT017             1306-1308   ///
      int    DXCCSR_EXT018             1309-1311   ///
      int    DXCCSR_EXT019             1312-1314   ///
      int    DXCCSR_EXT020             1315-1317   ///
      int    DXCCSR_EXT021             1318-1320   ///
      int    DXCCSR_EXT022             1321-1323   ///
      int    DXCCSR_EXT023             1324-1326   ///
      int    DXCCSR_EXT024             1327-1329   ///
      int    DXCCSR_EXT025             1330-1332   ///
      int    DXCCSR_EXT026             1333-1335   ///
      int    DXCCSR_EXT027             1336-1338   ///
      int    DXCCSR_EXT028             1339-1341   ///
      int    DXCCSR_EXT029             1342-1344   ///
      int    DXCCSR_EXT030             1345-1347   ///
      int    DXCCSR_EYE001             1348-1350   ///
      int    DXCCSR_EYE002             1351-1353   ///
      int    DXCCSR_EYE003             1354-1356   ///
      int    DXCCSR_EYE004             1357-1359   ///
      int    DXCCSR_EYE005             1360-1362   ///
      int    DXCCSR_EYE006             1363-1365   ///
      int    DXCCSR_EYE007             1366-1368   ///
      int    DXCCSR_EYE008             1369-1371   ///
      int    DXCCSR_EYE009             1372-1374   ///
      int    DXCCSR_EYE010             1375-1377   ///
      int    DXCCSR_EYE011             1378-1380   ///
      int    DXCCSR_EYE012             1381-1383   ///
      int    DXCCSR_FAC001             1384-1386   ///
      int    DXCCSR_FAC002             1387-1389   ///
      int    DXCCSR_FAC003             1390-1392   ///
      int    DXCCSR_FAC004             1393-1395   ///
      int    DXCCSR_FAC005             1396-1398   ///
      int    DXCCSR_FAC006             1399-1401   ///
      int    DXCCSR_FAC007             1402-1404   ///
      int    DXCCSR_FAC008             1405-1407   ///
      int    DXCCSR_FAC009             1408-1410   ///
      int    DXCCSR_FAC010             1411-1413   ///
      int    DXCCSR_FAC011             1414-1416   ///
      int    DXCCSR_FAC012             1417-1419   ///
      int    DXCCSR_FAC013             1420-1422   ///
      int    DXCCSR_FAC014             1423-1425   ///
      int    DXCCSR_FAC015             1426-1428   ///
      int    DXCCSR_FAC016             1429-1431   ///
      int    DXCCSR_FAC017             1432-1434   ///
      int    DXCCSR_FAC018             1435-1437   ///
      int    DXCCSR_FAC019             1438-1440   ///
      int    DXCCSR_FAC020             1441-1443   ///
      int    DXCCSR_FAC021             1444-1446   ///
      int    DXCCSR_FAC022             1447-1449   ///
      int    DXCCSR_FAC023             1450-1452   ///
      int    DXCCSR_FAC024             1453-1455   ///
      int    DXCCSR_FAC025             1456-1458   ///
      int    DXCCSR_GEN001             1459-1461   ///
      int    DXCCSR_GEN002             1462-1464   ///
      int    DXCCSR_GEN003             1465-1467   ///
      int    DXCCSR_GEN004             1468-1470   ///
      int    DXCCSR_GEN005             1471-1473   ///
      int    DXCCSR_GEN006             1474-1476   ///
      int    DXCCSR_GEN007             1477-1479   ///
      int    DXCCSR_GEN008             1480-1482   ///
      int    DXCCSR_GEN009             1483-1485   ///
      int    DXCCSR_GEN010             1486-1488   ///
      int    DXCCSR_GEN011             1489-1491   ///
      int    DXCCSR_GEN012             1492-1494   ///
      int    DXCCSR_GEN013             1495-1497   ///
      int    DXCCSR_GEN014             1498-1500   ///
      int    DXCCSR_GEN015             1501-1503   ///
      int    DXCCSR_GEN016             1504-1506   ///
      int    DXCCSR_GEN017             1507-1509   ///
      int    DXCCSR_GEN018             1510-1512   ///
      int    DXCCSR_GEN019             1513-1515   ///
      int    DXCCSR_GEN020             1516-1518   ///
      int    DXCCSR_GEN021             1519-1521   ///
      int    DXCCSR_GEN022             1522-1524   ///
      int    DXCCSR_GEN023             1525-1527   ///
      int    DXCCSR_GEN024             1528-1530   ///
      int    DXCCSR_GEN025             1531-1533   ///
      int    DXCCSR_GEN026             1534-1536   ///
      int    DXCCSR_INF001             1537-1539   ///
      int    DXCCSR_INF002             1540-1542   ///
      int    DXCCSR_INF003             1543-1545   ///
      int    DXCCSR_INF004             1546-1548   ///
      int    DXCCSR_INF005             1549-1551   ///
      int    DXCCSR_INF006             1552-1554   ///
      int    DXCCSR_INF007             1555-1557   ///
      int    DXCCSR_INF008             1558-1560   ///
      int    DXCCSR_INF009             1561-1563   ///
      int    DXCCSR_INF010             1564-1566   ///
      int    DXCCSR_INF011             1567-1569   ///
      int    DXCCSR_INF012             1570-1572   ///
      int    DXCCSR_INJ001             1573-1575   ///
      int    DXCCSR_INJ002             1576-1578   ///
      int    DXCCSR_INJ003             1579-1581   ///
      int    DXCCSR_INJ004             1582-1584   ///
      int    DXCCSR_INJ005             1585-1587   ///
      int    DXCCSR_INJ006             1588-1590   ///
      int    DXCCSR_INJ007             1591-1593   ///
      int    DXCCSR_INJ008             1594-1596   ///
      int    DXCCSR_INJ009             1597-1599   ///
      int    DXCCSR_INJ010             1600-1602   ///
      int    DXCCSR_INJ011             1603-1605   ///
      int    DXCCSR_INJ012             1606-1608   ///
      int    DXCCSR_INJ013             1609-1611   ///
      int    DXCCSR_INJ014             1612-1614   ///
      int    DXCCSR_INJ015             1615-1617   ///
      int    DXCCSR_INJ016             1618-1620   ///
      int    DXCCSR_INJ017             1621-1623   ///
      int    DXCCSR_INJ018             1624-1626   ///
      int    DXCCSR_INJ019             1627-1629   ///
      int    DXCCSR_INJ020             1630-1632   ///
      int    DXCCSR_INJ021             1633-1635   ///
      int    DXCCSR_INJ022             1636-1638   ///
      int    DXCCSR_INJ023             1639-1641   ///
      int    DXCCSR_INJ024             1642-1644   ///
      int    DXCCSR_INJ025             1645-1647   ///
      int    DXCCSR_INJ026             1648-1650   ///
      int    DXCCSR_INJ027             1651-1653   ///
      int    DXCCSR_INJ028             1654-1656   ///
      int    DXCCSR_INJ029             1657-1659   ///
      int    DXCCSR_INJ030             1660-1662   ///
      int    DXCCSR_INJ031             1663-1665   ///
      int    DXCCSR_INJ032             1666-1668   ///
      int    DXCCSR_INJ033             1669-1671   ///
      int    DXCCSR_INJ034             1672-1674   ///
      int    DXCCSR_INJ035             1675-1677   ///
      int    DXCCSR_INJ036             1678-1680   ///
      int    DXCCSR_INJ037             1681-1683   ///
      int    DXCCSR_INJ038             1684-1686   ///
      int    DXCCSR_INJ039             1687-1689   ///
      int    DXCCSR_INJ040             1690-1692   ///
      int    DXCCSR_INJ041             1693-1695   ///
      int    DXCCSR_INJ042             1696-1698   ///
      int    DXCCSR_INJ043             1699-1701   ///
      int    DXCCSR_INJ044             1702-1704   ///
      int    DXCCSR_INJ045             1705-1707   ///
      int    DXCCSR_INJ046             1708-1710   ///
      int    DXCCSR_INJ047             1711-1713   ///
      int    DXCCSR_INJ048             1714-1716   ///
      int    DXCCSR_INJ049             1717-1719   ///
      int    DXCCSR_INJ050             1720-1722   ///
      int    DXCCSR_INJ051             1723-1725   ///
      int    DXCCSR_INJ052             1726-1728   ///
      int    DXCCSR_INJ053             1729-1731   ///
      int    DXCCSR_INJ054             1732-1734   ///
      int    DXCCSR_INJ055             1735-1737   ///
      int    DXCCSR_INJ056             1738-1740   ///
      int    DXCCSR_INJ057             1741-1743   ///
      int    DXCCSR_INJ058             1744-1746   ///
      int    DXCCSR_INJ059             1747-1749   ///
      int    DXCCSR_INJ060             1750-1752   ///
      int    DXCCSR_INJ061             1753-1755   ///
      int    DXCCSR_INJ062             1756-1758   ///
      int    DXCCSR_INJ063             1759-1761   ///
      int    DXCCSR_INJ064             1762-1764   ///
      int    DXCCSR_INJ065             1765-1767   ///
      int    DXCCSR_INJ066             1768-1770   ///
      int    DXCCSR_INJ067             1771-1773   ///
      int    DXCCSR_INJ068             1774-1776   ///
      int    DXCCSR_INJ069             1777-1779   ///
      int    DXCCSR_INJ070             1780-1782   ///
      int    DXCCSR_INJ071             1783-1785   ///
      int    DXCCSR_INJ072             1786-1788   ///
      int    DXCCSR_INJ073             1789-1791   ///
      int    DXCCSR_INJ074             1792-1794   ///
      int    DXCCSR_INJ075             1795-1797   ///
      int    DXCCSR_INJ076             1798-1800   ///
      int    DXCCSR_MAL001             1801-1803   ///
      int    DXCCSR_MAL002             1804-1806   ///
      int    DXCCSR_MAL003             1807-1809   ///
      int    DXCCSR_MAL004             1810-1812   ///
      int    DXCCSR_MAL005             1813-1815   ///
      int    DXCCSR_MAL006             1816-1818   ///
      int    DXCCSR_MAL007             1819-1821   ///
      int    DXCCSR_MAL008             1822-1824   ///
      int    DXCCSR_MAL009             1825-1827   ///
      int    DXCCSR_MAL010             1828-1830   ///
      int    DXCCSR_MBD001             1831-1833   ///
      int    DXCCSR_MBD002             1834-1836   ///
      int    DXCCSR_MBD003             1837-1839   ///
      int    DXCCSR_MBD004             1840-1842   ///
      int    DXCCSR_MBD005             1843-1845   ///
      int    DXCCSR_MBD006             1846-1848   ///
      int    DXCCSR_MBD007             1849-1851   ///
      int    DXCCSR_MBD008             1852-1854   ///
      int    DXCCSR_MBD009             1855-1857   ///
      int    DXCCSR_MBD010             1858-1860   ///
      int    DXCCSR_MBD011             1861-1863   ///
      int    DXCCSR_MBD012             1864-1866   ///
      int    DXCCSR_MBD013             1867-1869   ///
      int    DXCCSR_MBD014             1870-1872   ///
      int    DXCCSR_MBD017             1873-1875   ///
      int    DXCCSR_MBD018             1876-1878   ///
      int    DXCCSR_MBD019             1879-1881   ///
      int    DXCCSR_MBD020             1882-1884   ///
      int    DXCCSR_MBD021             1885-1887   ///
      int    DXCCSR_MBD022             1888-1890   ///
      int    DXCCSR_MBD023             1891-1893   ///
      int    DXCCSR_MBD024             1894-1896   ///
      int    DXCCSR_MBD025             1897-1899   ///
      int    DXCCSR_MBD026             1900-1902   ///
      int    DXCCSR_MBD027             1903-1905   ///
      int    DXCCSR_MBD028             1906-1908   ///
      int    DXCCSR_MBD029             1909-1911   ///
      int    DXCCSR_MBD030             1912-1914   ///
      int    DXCCSR_MBD031             1915-1917   ///
      int    DXCCSR_MBD032             1918-1920   ///
      int    DXCCSR_MBD033             1921-1923   ///
      int    DXCCSR_MBD034             1924-1926   ///
      int    DXCCSR_MUS001             1927-1929   ///
      int    DXCCSR_MUS002             1930-1932   ///
      int    DXCCSR_MUS003             1933-1935   ///
      int    DXCCSR_MUS004             1936-1938   ///
      int    DXCCSR_MUS005             1939-1941   ///
      int    DXCCSR_MUS006             1942-1944   ///
      int    DXCCSR_MUS007             1945-1947   ///
      int    DXCCSR_MUS008             1948-1950   ///
      int    DXCCSR_MUS009             1951-1953   ///
      int    DXCCSR_MUS010             1954-1956   ///
      int    DXCCSR_MUS011             1957-1959   ///
      int    DXCCSR_MUS012             1960-1962   ///
      int    DXCCSR_MUS013             1963-1965   ///
      int    DXCCSR_MUS014             1966-1968   ///
      int    DXCCSR_MUS015             1969-1971   ///
      int    DXCCSR_MUS016             1972-1974   ///
      int    DXCCSR_MUS017             1975-1977   ///
      int    DXCCSR_MUS018             1978-1980   ///
      int    DXCCSR_MUS019             1981-1983   ///
      int    DXCCSR_MUS020             1984-1986   ///
      int    DXCCSR_MUS021             1987-1989   ///
      int    DXCCSR_MUS022             1990-1992   ///
      int    DXCCSR_MUS023             1993-1995   ///
      int    DXCCSR_MUS024             1996-1998   ///
      int    DXCCSR_MUS025             1999-2001   ///
      int    DXCCSR_MUS026             2002-2004   ///
      int    DXCCSR_MUS027             2005-2007   ///
      int    DXCCSR_MUS028             2008-2010   ///
      int    DXCCSR_MUS029             2011-2013   ///
      int    DXCCSR_MUS030             2014-2016   ///
      int    DXCCSR_MUS031             2017-2019   ///
      int    DXCCSR_MUS032             2020-2022   ///
      int    DXCCSR_MUS033             2023-2025   ///
      int    DXCCSR_MUS034             2026-2028   ///
      int    DXCCSR_MUS035             2029-2031   ///
      int    DXCCSR_MUS036             2032-2034   ///
      int    DXCCSR_MUS037             2035-2037   ///
      int    DXCCSR_MUS038             2038-2040   ///
      int    DXCCSR_NEO001             2041-2043   ///
      int    DXCCSR_NEO002             2044-2046   ///
      int    DXCCSR_NEO003             2047-2049   ///
      int    DXCCSR_NEO004             2050-2052   ///
      int    DXCCSR_NEO005             2053-2055   ///
      int    DXCCSR_NEO006             2056-2058   ///
      int    DXCCSR_NEO007             2059-2061   ///
      int    DXCCSR_NEO008             2062-2064   ///
      int    DXCCSR_NEO009             2065-2067   ///
      int    DXCCSR_NEO010             2068-2070   ///
      int    DXCCSR_NEO011             2071-2073   ///
      int    DXCCSR_NEO012             2074-2076   ///
      int    DXCCSR_NEO013             2077-2079   ///
      int    DXCCSR_NEO014             2080-2082   ///
      int    DXCCSR_NEO015             2083-2085   ///
      int    DXCCSR_NEO016             2086-2088   ///
      int    DXCCSR_NEO017             2089-2091   ///
      int    DXCCSR_NEO018             2092-2094   ///
      int    DXCCSR_NEO019             2095-2097   ///
      int    DXCCSR_NEO020             2098-2100   ///
      int    DXCCSR_NEO021             2101-2103   ///
      int    DXCCSR_NEO022             2104-2106   ///
      int    DXCCSR_NEO023             2107-2109   ///
      int    DXCCSR_NEO024             2110-2112   ///
      int    DXCCSR_NEO025             2113-2115   ///
      int    DXCCSR_NEO026             2116-2118   ///
      int    DXCCSR_NEO027             2119-2121   ///
      int    DXCCSR_NEO028             2122-2124   ///
      int    DXCCSR_NEO029             2125-2127   ///
      int    DXCCSR_NEO030             2128-2130   ///
      int    DXCCSR_NEO031             2131-2133   ///
      int    DXCCSR_NEO032             2134-2136   ///
      int    DXCCSR_NEO033             2137-2139   ///
      int    DXCCSR_NEO034             2140-2142   ///
      int    DXCCSR_NEO035             2143-2145   ///
      int    DXCCSR_NEO036             2146-2148   ///
      int    DXCCSR_NEO037             2149-2151   ///
      int    DXCCSR_NEO038             2152-2154   ///
      int    DXCCSR_NEO039             2155-2157   ///
      int    DXCCSR_NEO040             2158-2160   ///
      int    DXCCSR_NEO041             2161-2163   ///
      int    DXCCSR_NEO042             2164-2166   ///
      int    DXCCSR_NEO043             2167-2169   ///
      int    DXCCSR_NEO044             2170-2172   ///
      int    DXCCSR_NEO045             2173-2175   ///
      int    DXCCSR_NEO046             2176-2178   ///
      int    DXCCSR_NEO047             2179-2181   ///
      int    DXCCSR_NEO048             2182-2184   ///
      int    DXCCSR_NEO049             2185-2187   ///
      int    DXCCSR_NEO050             2188-2190   ///
      int    DXCCSR_NEO051             2191-2193   ///
      int    DXCCSR_NEO052             2194-2196   ///
      int    DXCCSR_NEO053             2197-2199   ///
      int    DXCCSR_NEO054             2200-2202   ///
      int    DXCCSR_NEO055             2203-2205   ///
      int    DXCCSR_NEO056             2206-2208   ///
      int    DXCCSR_NEO057             2209-2211   ///
      int    DXCCSR_NEO058             2212-2214   ///
      int    DXCCSR_NEO059             2215-2217   ///
      int    DXCCSR_NEO060             2218-2220   ///
      int    DXCCSR_NEO061             2221-2223   ///
      int    DXCCSR_NEO062             2224-2226   ///
      int    DXCCSR_NEO063             2227-2229   ///
      int    DXCCSR_NEO064             2230-2232   ///
      int    DXCCSR_NEO065             2233-2235   ///
      int    DXCCSR_NEO066             2236-2238   ///
      int    DXCCSR_NEO067             2239-2241   ///
      int    DXCCSR_NEO068             2242-2244   ///
      int    DXCCSR_NEO069             2245-2247   ///
      int    DXCCSR_NEO070             2248-2250   ///
      int    DXCCSR_NEO071             2251-2253   ///
      int    DXCCSR_NEO072             2254-2256   ///
      int    DXCCSR_NEO073             2257-2259   ///
      int    DXCCSR_NEO074             2260-2262   ///
      int    DXCCSR_NVS001             2263-2265   ///
      int    DXCCSR_NVS002             2266-2268   ///
      int    DXCCSR_NVS003             2269-2271   ///
      int    DXCCSR_NVS004             2272-2274   ///
      int    DXCCSR_NVS005             2275-2277   ///
      int    DXCCSR_NVS006             2278-2280   ///
      int    DXCCSR_NVS007             2281-2283   ///
      int    DXCCSR_NVS008             2284-2286   ///
      int    DXCCSR_NVS009             2287-2289   ///
      int    DXCCSR_NVS010             2290-2292   ///
      int    DXCCSR_NVS011             2293-2295   ///
      int    DXCCSR_NVS012             2296-2298   ///
      int    DXCCSR_NVS013             2299-2301   ///
      int    DXCCSR_NVS014             2302-2304   ///
      int    DXCCSR_NVS015             2305-2307   ///
      int    DXCCSR_NVS016             2308-2310   ///
      int    DXCCSR_NVS017             2311-2313   ///
      int    DXCCSR_NVS018             2314-2316   ///
      int    DXCCSR_NVS019             2317-2319   ///
      int    DXCCSR_NVS020             2320-2322   ///
      int    DXCCSR_NVS021             2323-2325   ///
      int    DXCCSR_NVS022             2326-2328   ///
      int    DXCCSR_PNL001             2329-2331   ///
      int    DXCCSR_PNL002             2332-2334   ///
      int    DXCCSR_PNL003             2335-2337   ///
      int    DXCCSR_PNL004             2338-2340   ///
      int    DXCCSR_PNL005             2341-2343   ///
      int    DXCCSR_PNL006             2344-2346   ///
      int    DXCCSR_PNL007             2347-2349   ///
      int    DXCCSR_PNL008             2350-2352   ///
      int    DXCCSR_PNL009             2353-2355   ///
      int    DXCCSR_PNL010             2356-2358   ///
      int    DXCCSR_PNL011             2359-2361   ///
      int    DXCCSR_PNL012             2362-2364   ///
      int    DXCCSR_PNL013             2365-2367   ///
      int    DXCCSR_PNL014             2368-2370   ///
      int    DXCCSR_PNL015             2371-2373   ///
      int    DXCCSR_PRG001             2374-2376   ///
      int    DXCCSR_PRG002             2377-2379   ///
      int    DXCCSR_PRG003             2380-2382   ///
      int    DXCCSR_PRG004             2383-2385   ///
      int    DXCCSR_PRG005             2386-2388   ///
      int    DXCCSR_PRG006             2389-2391   ///
      int    DXCCSR_PRG007             2392-2394   ///
      int    DXCCSR_PRG008             2395-2397   ///
      int    DXCCSR_PRG009             2398-2400   ///
      int    DXCCSR_PRG010             2401-2403   ///
      int    DXCCSR_PRG011             2404-2406   ///
      int    DXCCSR_PRG012             2407-2409   ///
      int    DXCCSR_PRG013             2410-2412   ///
      int    DXCCSR_PRG014             2413-2415   ///
      int    DXCCSR_PRG015             2416-2418   ///
      int    DXCCSR_PRG016             2419-2421   ///
      int    DXCCSR_PRG017             2422-2424   ///
      int    DXCCSR_PRG018             2425-2427   ///
      int    DXCCSR_PRG019             2428-2430   ///
      int    DXCCSR_PRG020             2431-2433   ///
      int    DXCCSR_PRG021             2434-2436   ///
      int    DXCCSR_PRG022             2437-2439   ///
      int    DXCCSR_PRG023             2440-2442   ///
      int    DXCCSR_PRG024             2443-2445   ///
      int    DXCCSR_PRG025             2446-2448   ///
      int    DXCCSR_PRG026             2449-2451   ///
      int    DXCCSR_PRG027             2452-2454   ///
      int    DXCCSR_PRG028             2455-2457   ///
      int    DXCCSR_PRG029             2458-2460   ///
      int    DXCCSR_PRG030             2461-2463   ///
      int    DXCCSR_RSP001             2464-2466   ///
      int    DXCCSR_RSP002             2467-2469   ///
      int    DXCCSR_RSP003             2470-2472   ///
      int    DXCCSR_RSP004             2473-2475   ///
      int    DXCCSR_RSP005             2476-2478   ///
      int    DXCCSR_RSP006             2479-2481   ///
      int    DXCCSR_RSP007             2482-2484   ///
      int    DXCCSR_RSP008             2485-2487   ///
      int    DXCCSR_RSP009             2488-2490   ///
      int    DXCCSR_RSP010             2491-2493   ///
      int    DXCCSR_RSP011             2494-2496   ///
      int    DXCCSR_RSP012             2497-2499   ///
      int    DXCCSR_RSP013             2500-2502   ///
      int    DXCCSR_RSP014             2503-2505   ///
      int    DXCCSR_RSP015             2506-2508   ///
      int    DXCCSR_RSP016             2509-2511   ///
      int    DXCCSR_RSP017             2512-2514   ///
      int    DXCCSR_SKN001             2515-2517   ///
      int    DXCCSR_SKN002             2518-2520   ///
      int    DXCCSR_SKN003             2521-2523   ///
      int    DXCCSR_SKN004             2524-2526   ///
      int    DXCCSR_SKN005             2527-2529   ///
      int    DXCCSR_SKN006             2530-2532   ///
      int    DXCCSR_SKN007             2533-2535   ///
      int    DXCCSR_SYM001             2536-2538   ///
      int    DXCCSR_SYM002             2539-2541   ///
      int    DXCCSR_SYM003             2542-2544   ///
      int    DXCCSR_SYM004             2545-2547   ///
      int    DXCCSR_SYM005             2548-2550   ///
      int    DXCCSR_SYM006             2551-2553   ///
      int    DXCCSR_SYM007             2554-2556   ///
      int    DXCCSR_SYM008             2557-2559   ///
      int    DXCCSR_SYM009             2560-2562   ///
      int    DXCCSR_SYM010             2563-2565   ///
      int    DXCCSR_SYM011             2566-2568   ///
      int    DXCCSR_SYM012             2569-2571   ///
      int    DXCCSR_SYM013             2572-2574   ///
      int    DXCCSR_SYM014             2575-2577   ///
      int    DXCCSR_SYM015             2578-2580   ///
      int    DXCCSR_SYM016             2581-2583   ///
      int    DXCCSR_SYM017             2584-2586   ///
      str    DXCCSR_VERSION            2587-2592   ///
      int    PRCCSR_ADM001             2593-2595   ///
      int    PRCCSR_ADM002             2596-2598   ///
      int    PRCCSR_ADM003             2599-2601   ///
      int    PRCCSR_ADM004             2602-2604   ///
      int    PRCCSR_ADM005             2605-2607   ///
      int    PRCCSR_ADM006             2608-2610   ///
      int    PRCCSR_ADM007             2611-2613   ///
      int    PRCCSR_ADM008             2614-2616   ///
      int    PRCCSR_ADM009             2617-2619   ///
      int    PRCCSR_ADM010             2620-2622   ///
      int    PRCCSR_ADM011             2623-2625   ///
      int    PRCCSR_ADM012             2626-2628   ///
      int    PRCCSR_ADM013             2629-2631   ///
      int    PRCCSR_ADM014             2632-2634   ///
      int    PRCCSR_ADM015             2635-2637   ///
      int    PRCCSR_ADM016             2638-2640   ///
      int    PRCCSR_ADM017             2641-2643   ///
      int    PRCCSR_ADM018             2644-2646   ///
      int    PRCCSR_ADM019             2647-2649   ///
      int    PRCCSR_ADM020             2650-2652   ///
      int    PRCCSR_ADM021             2653-2655   ///
      int    PRCCSR_ADM022             2656-2658   ///
      int    PRCCSR_CAR001             2659-2661   ///
      int    PRCCSR_CAR002             2662-2664   ///
      int    PRCCSR_CAR003             2665-2667   ///
      int    PRCCSR_CAR004             2668-2670   ///
      int    PRCCSR_CAR005             2671-2673   ///
      int    PRCCSR_CAR006             2674-2676   ///
      int    PRCCSR_CAR007             2677-2679   ///
      int    PRCCSR_CAR008             2680-2682   ///
      int    PRCCSR_CAR009             2683-2685   ///
      int    PRCCSR_CAR010             2686-2688   ///
      int    PRCCSR_CAR011             2689-2691   ///
      int    PRCCSR_CAR012             2692-2694   ///
      int    PRCCSR_CAR013             2695-2697   ///
      int    PRCCSR_CAR014             2698-2700   ///
      int    PRCCSR_CAR015             2701-2703   ///
      int    PRCCSR_CAR016             2704-2706   ///
      int    PRCCSR_CAR017             2707-2709   ///
      int    PRCCSR_CAR018             2710-2712   ///
      int    PRCCSR_CAR019             2713-2715   ///
      int    PRCCSR_CAR020             2716-2718   ///
      int    PRCCSR_CAR021             2719-2721   ///
      int    PRCCSR_CAR022             2722-2724   ///
      int    PRCCSR_CAR023             2725-2727   ///
      int    PRCCSR_CAR024             2728-2730   ///
      int    PRCCSR_CAR025             2731-2733   ///
      int    PRCCSR_CAR026             2734-2736   ///
      int    PRCCSR_CAR027             2737-2739   ///
      int    PRCCSR_CAR028             2740-2742   ///
      int    PRCCSR_CAR029             2743-2745   ///
      int    PRCCSR_CHP001             2746-2748   ///
      int    PRCCSR_CNS001             2749-2751   ///
      int    PRCCSR_CNS002             2752-2754   ///
      int    PRCCSR_CNS003             2755-2757   ///
      int    PRCCSR_CNS004             2758-2760   ///
      int    PRCCSR_CNS005             2761-2763   ///
      int    PRCCSR_CNS006             2764-2766   ///
      int    PRCCSR_CNS007             2767-2769   ///
      int    PRCCSR_CNS008             2770-2772   ///
      int    PRCCSR_CNS009             2773-2775   ///
      int    PRCCSR_CNS010             2776-2778   ///
      int    PRCCSR_CNS011             2779-2781   ///
      int    PRCCSR_CNS012             2782-2784   ///
      int    PRCCSR_CNS013             2785-2787   ///
      int    PRCCSR_CNS014             2788-2790   ///
      int    PRCCSR_ENP001             2791-2793   ///
      int    PRCCSR_ENP002             2794-2796   ///
      int    PRCCSR_ENP003             2797-2799   ///
      int    PRCCSR_ENP004             2800-2802   ///
      int    PRCCSR_ENP005             2803-2805   ///
      int    PRCCSR_ENP006             2806-2808   ///
      int    PRCCSR_ENT001             2809-2811   ///
      int    PRCCSR_ENT002             2812-2814   ///
      int    PRCCSR_ENT003             2815-2817   ///
      int    PRCCSR_ENT004             2818-2820   ///
      int    PRCCSR_ENT005             2821-2823   ///
      int    PRCCSR_ENT006             2824-2826   ///
      int    PRCCSR_ENT007             2827-2829   ///
      int    PRCCSR_ENT008             2830-2832   ///
      int    PRCCSR_ENT009             2833-2835   ///
      int    PRCCSR_ENT010             2836-2838   ///
      int    PRCCSR_ENT011             2839-2841   ///
      int    PRCCSR_ENT012             2842-2844   ///
      int    PRCCSR_ENT013             2845-2847   ///
      int    PRCCSR_ENT014             2848-2850   ///
      int    PRCCSR_ENT015             2851-2853   ///
      int    PRCCSR_ENT016             2854-2856   ///
      int    PRCCSR_ENT017             2857-2859   ///
      int    PRCCSR_ESA001             2860-2862   ///
      int    PRCCSR_ESA002             2863-2865   ///
      int    PRCCSR_ESA003             2866-2868   ///
      int    PRCCSR_ESA004             2869-2871   ///
      int    PRCCSR_ESA005             2872-2874   ///
      int    PRCCSR_ESA006             2875-2877   ///
      int    PRCCSR_ESA007             2878-2880   ///
      int    PRCCSR_ESA008             2881-2883   ///
      int    PRCCSR_ESA009             2884-2886   ///
      int    PRCCSR_ESA010             2887-2889   ///
      int    PRCCSR_ESA011             2890-2892   ///
      int    PRCCSR_EST001             2893-2895   ///
      int    PRCCSR_EST002             2896-2898   ///
      int    PRCCSR_EST003             2899-2901   ///
      int    PRCCSR_EST004             2902-2904   ///
      int    PRCCSR_EST005             2905-2907   ///
      int    PRCCSR_EYP001             2908-2910   ///
      int    PRCCSR_EYP002             2911-2913   ///
      int    PRCCSR_FRS001             2914-2916   ///
      int    PRCCSR_FRS002             2917-2919   ///
      int    PRCCSR_FRS003             2920-2922   ///
      int    PRCCSR_FRS004             2923-2925   ///
      int    PRCCSR_FRS005             2926-2928   ///
      int    PRCCSR_FRS006             2929-2931   ///
      int    PRCCSR_FRS007             2932-2934   ///
      int    PRCCSR_FRS008             2935-2937   ///
      int    PRCCSR_FRS009             2938-2940   ///
      int    PRCCSR_FRS010             2941-2943   ///
      int    PRCCSR_FRS011             2944-2946   ///
      int    PRCCSR_FRS012             2947-2949   ///
      int    PRCCSR_FRS013             2950-2952   ///
      int    PRCCSR_FRS014             2953-2955   ///
      int    PRCCSR_FRS015             2956-2958   ///
      int    PRCCSR_GIS001             2959-2961   ///
      int    PRCCSR_GIS002             2962-2964   ///
      int    PRCCSR_GIS003             2965-2967   ///
      int    PRCCSR_GIS004             2968-2970   ///
      int    PRCCSR_GIS005             2971-2973   ///
      int    PRCCSR_GIS006             2974-2976   ///
      int    PRCCSR_GIS007             2977-2979   ///
      int    PRCCSR_GIS008             2980-2982   ///
      int    PRCCSR_GIS009             2983-2985   ///
      int    PRCCSR_GIS010             2986-2988   ///
      int    PRCCSR_GIS011             2989-2991   ///
      int    PRCCSR_GIS012             2992-2994   ///
      int    PRCCSR_GIS013             2995-2997   ///
      int    PRCCSR_GIS014             2998-3000   ///
      int    PRCCSR_GIS015             3001-3003   ///
      int    PRCCSR_GIS016             3004-3006   ///
      int    PRCCSR_GIS017             3007-3009   ///
      int    PRCCSR_GIS018             3010-3012   ///
      int    PRCCSR_GIS019             3013-3015   ///
      int    PRCCSR_GIS020             3016-3018   ///
      int    PRCCSR_GIS021             3019-3021   ///
      int    PRCCSR_GIS022             3022-3024   ///
      int    PRCCSR_GIS023             3025-3027   ///
      int    PRCCSR_GIS024             3028-3030   ///
      int    PRCCSR_GIS025             3031-3033   ///
      int    PRCCSR_GIS026             3034-3036   ///
      int    PRCCSR_GIS027             3037-3039   ///
      int    PRCCSR_GIS028             3040-3042   ///
      int    PRCCSR_GIS029             3043-3045   ///
      int    PRCCSR_GNR001             3046-3048   ///
      int    PRCCSR_GNR002             3049-3051   ///
      int    PRCCSR_GNR003             3052-3054   ///
      int    PRCCSR_GNR004             3055-3057   ///
      int    PRCCSR_GNR005             3058-3060   ///
      int    PRCCSR_GNR006             3061-3063   ///
      int    PRCCSR_GNR007             3064-3066   ///
      int    PRCCSR_GNR008             3067-3069   ///
      int    PRCCSR_GNR009             3070-3072   ///
      int    PRCCSR_GNR010             3073-3075   ///
      int    PRCCSR_HEP001             3076-3078   ///
      int    PRCCSR_HEP002             3079-3081   ///
      int    PRCCSR_HEP003             3082-3084   ///
      int    PRCCSR_HEP004             3085-3087   ///
      int    PRCCSR_HEP005             3088-3090   ///
      int    PRCCSR_HEP006             3091-3093   ///
      int    PRCCSR_HEP007             3094-3096   ///
      int    PRCCSR_HEP008             3097-3099   ///
      int    PRCCSR_HEP009             3100-3102   ///
      int    PRCCSR_HEP010             3103-3105   ///
      int    PRCCSR_HEP011             3106-3108   ///
      int    PRCCSR_HEP012             3109-3111   ///
      int    PRCCSR_HEP013             3112-3114   ///
      int    PRCCSR_IMG001             3115-3117   ///
      int    PRCCSR_IMG002             3118-3120   ///
      int    PRCCSR_IMG003             3121-3123   ///
      int    PRCCSR_IMG004             3124-3126   ///
      int    PRCCSR_IMG005             3127-3129   ///
      int    PRCCSR_IMG006             3130-3132   ///
      int    PRCCSR_IMG007             3133-3135   ///
      int    PRCCSR_IMG008             3136-3138   ///
      int    PRCCSR_IMG009             3139-3141   ///
      int    PRCCSR_IMG010             3142-3144   ///
      int    PRCCSR_LYM001             3145-3147   ///
      int    PRCCSR_LYM002             3148-3150   ///
      int    PRCCSR_LYM003             3151-3153   ///
      int    PRCCSR_LYM004             3154-3156   ///
      int    PRCCSR_LYM005             3157-3159   ///
      int    PRCCSR_LYM006             3160-3162   ///
      int    PRCCSR_LYM007             3163-3165   ///
      int    PRCCSR_LYM008             3166-3168   ///
      int    PRCCSR_LYM009             3169-3171   ///
      int    PRCCSR_LYM010             3172-3174   ///
      int    PRCCSR_LYM011             3175-3177   ///
      int    PRCCSR_MAM001             3178-3180   ///
      int    PRCCSR_MAM002             3181-3183   ///
      int    PRCCSR_MAM003             3184-3186   ///
      int    PRCCSR_MAM004             3187-3189   ///
      int    PRCCSR_MAM005             3190-3192   ///
      int    PRCCSR_MAM006             3193-3195   ///
      int    PRCCSR_MAM007             3196-3198   ///
      int    PRCCSR_MAM008             3199-3201   ///
      int    PRCCSR_MAM009             3202-3204   ///
      int    PRCCSR_MAM010             3205-3207   ///
      int    PRCCSR_MAM011             3208-3210   ///
      int    PRCCSR_MAM012             3211-3213   ///
      int    PRCCSR_MAM013             3214-3216   ///
      int    PRCCSR_MAM014             3217-3219   ///
      int    PRCCSR_MAM015             3220-3222   ///
      int    PRCCSR_MHT001             3223-3225   ///
      int    PRCCSR_MHT002             3226-3228   ///
      int    PRCCSR_MHT003             3229-3231   ///
      int    PRCCSR_MHT004             3232-3234   ///
      int    PRCCSR_MHT005             3235-3237   ///
      int    PRCCSR_MRS001             3238-3240   ///
      int    PRCCSR_MRS002             3241-3243   ///
      int    PRCCSR_MRS003             3244-3246   ///
      int    PRCCSR_MRS004             3247-3249   ///
      int    PRCCSR_MRS005             3250-3252   ///
      int    PRCCSR_MRS006             3253-3255   ///
      int    PRCCSR_MRS007             3256-3258   ///
      int    PRCCSR_MST001             3259-3261   ///
      int    PRCCSR_MST002             3262-3264   ///
      int    PRCCSR_MST003             3265-3267   ///
      int    PRCCSR_MST004             3268-3270   ///
      int    PRCCSR_MST005             3271-3273   ///
      int    PRCCSR_MST006             3274-3276   ///
      int    PRCCSR_MST007             3277-3279   ///
      int    PRCCSR_MST008             3280-3282   ///
      int    PRCCSR_MST009             3283-3285   ///
      int    PRCCSR_MST010             3286-3288   ///
      int    PRCCSR_MST011             3289-3291   ///
      int    PRCCSR_MST012             3292-3294   ///
      int    PRCCSR_MST013             3295-3297   ///
      int    PRCCSR_MST014             3298-3300   ///
      int    PRCCSR_MST015             3301-3303   ///
      int    PRCCSR_MST016             3304-3306   ///
      int    PRCCSR_MST017             3307-3309   ///
      int    PRCCSR_MST018             3310-3312   ///
      int    PRCCSR_MST019             3313-3315   ///
      int    PRCCSR_MST020             3316-3318   ///
      int    PRCCSR_MST021             3319-3321   ///
      int    PRCCSR_MST022             3322-3324   ///
      int    PRCCSR_MST023             3325-3327   ///
      int    PRCCSR_MST024             3328-3330   ///
      int    PRCCSR_MST025             3331-3333   ///
      int    PRCCSR_MST026             3334-3336   ///
      int    PRCCSR_MST027             3337-3339   ///
      int    PRCCSR_MST028             3340-3342   ///
      int    PRCCSR_MST029             3343-3345   ///
      int    PRCCSR_MST030             3346-3348   ///
      int    PRCCSR_NCM001             3349-3351   ///
      int    PRCCSR_NCM002             3352-3354   ///
      int    PRCCSR_NCM003             3355-3357   ///
      int    PRCCSR_NCM004             3358-3360   ///
      int    PRCCSR_OST001             3361-3363   ///
      int    PRCCSR_OTR001             3364-3366   ///
      int    PRCCSR_OTR002             3367-3369   ///
      int    PRCCSR_OTR003             3370-3372   ///
      int    PRCCSR_OTR004             3373-3375   ///
      int    PRCCSR_OTR005             3376-3378   ///
      int    PRCCSR_PGN001             3379-3381   ///
      int    PRCCSR_PGN002             3382-3384   ///
      int    PRCCSR_PGN003             3385-3387   ///
      int    PRCCSR_PGN004             3388-3390   ///
      int    PRCCSR_PGN005             3391-3393   ///
      int    PRCCSR_PGN006             3394-3396   ///
      int    PRCCSR_PGN007             3397-3399   ///
      int    PRCCSR_PGN008             3400-3402   ///
      int    PRCCSR_PGN009             3403-3405   ///
      int    PRCCSR_PLC001             3406-3408   ///
      int    PRCCSR_PLC002             3409-3411   ///
      int    PRCCSR_PNS001             3412-3414   ///
      int    PRCCSR_PNS002             3415-3417   ///
      int    PRCCSR_PNS003             3418-3420   ///
      int    PRCCSR_PNS004             3421-3423   ///
      int    PRCCSR_PNS005             3424-3426   ///
      int    PRCCSR_PNS006             3427-3429   ///
      int    PRCCSR_RAD001             3430-3432   ///
      int    PRCCSR_RAD002             3433-3435   ///
      int    PRCCSR_RAD003             3436-3438   ///
      int    PRCCSR_RAD004             3439-3441   ///
      int    PRCCSR_RES001             3442-3444   ///
      int    PRCCSR_RES002             3445-3447   ///
      int    PRCCSR_RES003             3448-3450   ///
      int    PRCCSR_RES004             3451-3453   ///
      int    PRCCSR_RES005             3454-3456   ///
      int    PRCCSR_RES006             3457-3459   ///
      int    PRCCSR_RES007             3460-3462   ///
      int    PRCCSR_RES008             3463-3465   ///
      int    PRCCSR_RES009             3466-3468   ///
      int    PRCCSR_RES010             3469-3471   ///
      int    PRCCSR_RES011             3472-3474   ///
      int    PRCCSR_RES012             3475-3477   ///
      int    PRCCSR_RES013             3478-3480   ///
      int    PRCCSR_RES014             3481-3483   ///
      int    PRCCSR_RHB001             3484-3486   ///
      int    PRCCSR_RHB002             3487-3489   ///
      int    PRCCSR_RHB003             3490-3492   ///
      int    PRCCSR_RHB004             3493-3495   ///
      int    PRCCSR_SKB001             3496-3498   ///
      int    PRCCSR_SKB002             3499-3501   ///
      int    PRCCSR_SKB003             3502-3504   ///
      int    PRCCSR_SKB004             3505-3507   ///
      int    PRCCSR_SKB005             3508-3510   ///
      int    PRCCSR_SKB006             3511-3513   ///
      int    PRCCSR_SKB007             3514-3516   ///
      int    PRCCSR_SKB008             3517-3519   ///
      int    PRCCSR_SKB009             3520-3522   ///
      int    PRCCSR_SKB010             3523-3525   ///
      int    PRCCSR_SUD001             3526-3528   ///
      int    PRCCSR_SUD002             3529-3531   ///
      int    PRCCSR_SUD003             3532-3534   ///
      int    PRCCSR_SUD004             3535-3537   ///
      int    PRCCSR_URN001             3538-3540   ///
      int    PRCCSR_URN002             3541-3543   ///
      int    PRCCSR_URN003             3544-3546   ///
      int    PRCCSR_URN004             3547-3549   ///
      int    PRCCSR_URN005             3550-3552   ///
      int    PRCCSR_URN006             3553-3555   ///
      int    PRCCSR_URN007             3556-3558   ///
      int    PRCCSR_URN008             3559-3561   ///
      int    PRCCSR_URN009             3562-3564   ///
      int    PRCCSR_URN010             3565-3567   ///
      int    PRCCSR_URN011             3568-3570   ///
      int    PRCCSR_URN012             3571-3573   ///
      str    PRCCSR_VERSION            3574-3579   ///
      using  "GA_SID_2023_DX_PR_GRPS.asc"

/***  Assign labels to the data elements ***/
label var CCIR_VERSION             "Version of Chronic Condition Indicator Refined for ICD-10-CM"
label var CCIR1                    "ICD-10-CM Chronic Condition Indicator Refined 1"
label var CCIR2                    "ICD-10-CM Chronic Condition Indicator Refined 2"
label var CCIR3                    "ICD-10-CM Chronic Condition Indicator Refined 3"
label var CCIR4                    "ICD-10-CM Chronic Condition Indicator Refined 4"
label var CCIR5                    "ICD-10-CM Chronic Condition Indicator Refined 5"
label var CCIR6                    "ICD-10-CM Chronic Condition Indicator Refined 6"
label var CCIR7                    "ICD-10-CM Chronic Condition Indicator Refined 7"
label var CCIR8                    "ICD-10-CM Chronic Condition Indicator Refined 8"
label var CCIR9                    "ICD-10-CM Chronic Condition Indicator Refined 9"
label var CCIR10                   "ICD-10-CM Chronic Condition Indicator Refined 10"
label var CCIR11                   "ICD-10-CM Chronic Condition Indicator Refined 11"
label var CCIR12                   "ICD-10-CM Chronic Condition Indicator Refined 12"
label var CCIR13                   "ICD-10-CM Chronic Condition Indicator Refined 13"
label var CCIR14                   "ICD-10-CM Chronic Condition Indicator Refined 14"
label var CCIR15                   "ICD-10-CM Chronic Condition Indicator Refined 15"
label var CCIR16                   "ICD-10-CM Chronic Condition Indicator Refined 16"
label var CCIR17                   "ICD-10-CM Chronic Condition Indicator Refined 17"
label var CCIR18                   "ICD-10-CM Chronic Condition Indicator Refined 18"
label var CCIR19                   "ICD-10-CM Chronic Condition Indicator Refined 19"
label var CCIR20                   "ICD-10-CM Chronic Condition Indicator Refined 20"
label var CCIR21                   "ICD-10-CM Chronic Condition Indicator Refined 21"
label var CCIR22                   "ICD-10-CM Chronic Condition Indicator Refined 22"
label var CCIR23                   "ICD-10-CM Chronic Condition Indicator Refined 23"
label var CCIR24                   "ICD-10-CM Chronic Condition Indicator Refined 24"
label var CCIR25                   "ICD-10-CM Chronic Condition Indicator Refined 25"
label var CCIR26                   "ICD-10-CM Chronic Condition Indicator Refined 26"
label var CCIR27                   "ICD-10-CM Chronic Condition Indicator Refined 27"
label var CCIR28                   "ICD-10-CM Chronic Condition Indicator Refined 28"
label var CCIR29                   "ICD-10-CM Chronic Condition Indicator Refined 29"
label var CCIR30                   "ICD-10-CM Chronic Condition Indicator Refined 30"
label var CCIR31                   "ICD-10-CM Chronic Condition Indicator Refined 31"
label var CCIR32                   "ICD-10-CM Chronic Condition Indicator Refined 32"
label var CCIR33                   "ICD-10-CM Chronic Condition Indicator Refined 33"
label var CCIR34                   "ICD-10-CM Chronic Condition Indicator Refined 34"
label var CCIR35                   "ICD-10-CM Chronic Condition Indicator Refined 35"
label var CCIR36                   "ICD-10-CM Chronic Condition Indicator Refined 36"
label var CCIR37                   "ICD-10-CM Chronic Condition Indicator Refined 37"
label var CCIR38                   "ICD-10-CM Chronic Condition Indicator Refined 38"
label var CCIR39                   "ICD-10-CM Chronic Condition Indicator Refined 39"
label var CCIR40                   "ICD-10-CM Chronic Condition Indicator Refined 40"
label var CCIR41                   "ICD-10-CM Chronic Condition Indicator Refined 41"
label var CCIR42                   "ICD-10-CM Chronic Condition Indicator Refined 42"
label var CCIR43                   "ICD-10-CM Chronic Condition Indicator Refined 43"
label var CCIR44                   "ICD-10-CM Chronic Condition Indicator Refined 44"
label var CCIR45                   "ICD-10-CM Chronic Condition Indicator Refined 45"
label var CCIR46                   "ICD-10-CM Chronic Condition Indicator Refined 46"
label var CCIR47                   "ICD-10-CM Chronic Condition Indicator Refined 47"
label var CCIR48                   "ICD-10-CM Chronic Condition Indicator Refined 48"
label var CCIR49                   "ICD-10-CM Chronic Condition Indicator Refined 49"
label var CCIR50                   "ICD-10-CM Chronic Condition Indicator Refined 50"
label var CCIR51                   "ICD-10-CM Chronic Condition Indicator Refined 51"
label var CCIR52                   "ICD-10-CM Chronic Condition Indicator Refined 52"
label var CCIR53                   "ICD-10-CM Chronic Condition Indicator Refined 53"
label var CCIR54                   "ICD-10-CM Chronic Condition Indicator Refined 54"
label var CCIR55                   "ICD-10-CM Chronic Condition Indicator Refined 55"
label var CCIR56                   "ICD-10-CM Chronic Condition Indicator Refined 56"
label var CCIR57                   "ICD-10-CM Chronic Condition Indicator Refined 57"
label var CCIR58                   "ICD-10-CM Chronic Condition Indicator Refined 58"
label var CCIR59                   "ICD-10-CM Chronic Condition Indicator Refined 59"
label var CCIR60                   "ICD-10-CM Chronic Condition Indicator Refined 60"
label var CCIR61                   "ICD-10-CM Chronic Condition Indicator Refined 61"
label var CCIR62                   "ICD-10-CM Chronic Condition Indicator Refined 62"
label var CCIR63                   "ICD-10-CM Chronic Condition Indicator Refined 63"
label var CCIR64                   "ICD-10-CM Chronic Condition Indicator Refined 64"
label var CCIR65                   "ICD-10-CM Chronic Condition Indicator Refined 65"
label var CCIR66                   "ICD-10-CM Chronic Condition Indicator Refined 66"
label var CCIR67                   "ICD-10-CM Chronic Condition Indicator Refined 67"
label var CCIR68                   "ICD-10-CM Chronic Condition Indicator Refined 68"
label var CCIR69                   "ICD-10-CM Chronic Condition Indicator Refined 69"
label var CCIR70                   "ICD-10-CM Chronic Condition Indicator Refined 70"
label var CCIR71                   "ICD-10-CM Chronic Condition Indicator Refined 71"
label var CCIR72                   "ICD-10-CM Chronic Condition Indicator Refined 72"
label var CCIR73                   "ICD-10-CM Chronic Condition Indicator Refined 73"
label var CCIR74                   "ICD-10-CM Chronic Condition Indicator Refined 74"
label var CCIR75                   "ICD-10-CM Chronic Condition Indicator Refined 75"
label var CCIR76                   "ICD-10-CM Chronic Condition Indicator Refined 76"
label var CCIR77                   "ICD-10-CM Chronic Condition Indicator Refined 77"
label var CCIR78                   "ICD-10-CM Chronic Condition Indicator Refined 78"
label var CCIR79                   "ICD-10-CM Chronic Condition Indicator Refined 79"
label var CCIR80                   "ICD-10-CM Chronic Condition Indicator Refined 80"
label var CCIR81                   "ICD-10-CM Chronic Condition Indicator Refined 81"
label var CCIR82                   "ICD-10-CM Chronic Condition Indicator Refined 82"
label var CCIR83                   "ICD-10-CM Chronic Condition Indicator Refined 83"
label var CCIR84                   "ICD-10-CM Chronic Condition Indicator Refined 84"
label var CCIR85                   "ICD-10-CM Chronic Condition Indicator Refined 85"
label var CCIR86                   "ICD-10-CM Chronic Condition Indicator Refined 86"
label var CCIR87                   "ICD-10-CM Chronic Condition Indicator Refined 87"
label var CCIR88                   "ICD-10-CM Chronic Condition Indicator Refined 88"
label var CCIR89                   "ICD-10-CM Chronic Condition Indicator Refined 89"
label var CCIR90                   "ICD-10-CM Chronic Condition Indicator Refined 90"
label var CCIR91                   "ICD-10-CM Chronic Condition Indicator Refined 91"
label var CCIR92                   "ICD-10-CM Chronic Condition Indicator Refined 92"
label var CCIR93                   "ICD-10-CM Chronic Condition Indicator Refined 93"
label var CCIR94                   "ICD-10-CM Chronic Condition Indicator Refined 94"
label var CCIR95                   "ICD-10-CM Chronic Condition Indicator Refined 95"
label var CCIR96                   "ICD-10-CM Chronic Condition Indicator Refined 96"
label var CCIR97                   "ICD-10-CM Chronic Condition Indicator Refined 97"
label var CCIR98                   "ICD-10-CM Chronic Condition Indicator Refined 98"
label var CCIR99                   "ICD-10-CM Chronic Condition Indicator Refined 99"
label var CCIR100                  "ICD-10-CM Chronic Condition Indicator Refined 100"
label var CCIR101                  "ICD-10-CM Chronic Condition Indicator Refined 101"
label var CCIR102                  "ICD-10-CM Chronic Condition Indicator Refined 102"
label var CCIR103                  "ICD-10-CM Chronic Condition Indicator Refined 103"
label var CCIR104                  "ICD-10-CM Chronic Condition Indicator Refined 104"
label var CCIR105                  "ICD-10-CM Chronic Condition Indicator Refined 105"
label var CCIR106                  "ICD-10-CM Chronic Condition Indicator Refined 106"
label var CCIR107                  "ICD-10-CM Chronic Condition Indicator Refined 107"
label var CCIR108                  "ICD-10-CM Chronic Condition Indicator Refined 108"
label var CCIR109                  "ICD-10-CM Chronic Condition Indicator Refined 109"
label var CCIR110                  "ICD-10-CM Chronic Condition Indicator Refined 110"
label var CCIR111                  "ICD-10-CM Chronic Condition Indicator Refined 111"
label var CCIR112                  "ICD-10-CM Chronic Condition Indicator Refined 112"
label var CCIR113                  "ICD-10-CM Chronic Condition Indicator Refined 113"
label var CCIR114                  "ICD-10-CM Chronic Condition Indicator Refined 114"
label var CCIR115                  "ICD-10-CM Chronic Condition Indicator Refined 115"
label var CCIR116                  "ICD-10-CM Chronic Condition Indicator Refined 116"
label var CCIR117                  "ICD-10-CM Chronic Condition Indicator Refined 117"
label var CCIR118                  "ICD-10-CM Chronic Condition Indicator Refined 118"
label var CCIR119                  "ICD-10-CM Chronic Condition Indicator Refined 119"
label var CCIR120                  "ICD-10-CM Chronic Condition Indicator Refined 120"
label var CCIR121                  "ICD-10-CM Chronic Condition Indicator Refined 121"
label var CCIR122                  "ICD-10-CM Chronic Condition Indicator Refined 122"
label var CCIR123                  "ICD-10-CM Chronic Condition Indicator Refined 123"
label var CCIR124                  "ICD-10-CM Chronic Condition Indicator Refined 124"
label var CCIR125                  "ICD-10-CM Chronic Condition Indicator Refined 125"
label var CCIR126                  "ICD-10-CM Chronic Condition Indicator Refined 126"
label var CCIR127                  "ICD-10-CM Chronic Condition Indicator Refined 127"
label var CCIR128                  "ICD-10-CM Chronic Condition Indicator Refined 128"
label var CCIR129                  "ICD-10-CM Chronic Condition Indicator Refined 129"
label var CCIR130                  "ICD-10-CM Chronic Condition Indicator Refined 130"
label var CCIR131                  "ICD-10-CM Chronic Condition Indicator Refined 131"
label var CCIR132                  "ICD-10-CM Chronic Condition Indicator Refined 132"
label var CCIR133                  "ICD-10-CM Chronic Condition Indicator Refined 133"
label var CCIR134                  "ICD-10-CM Chronic Condition Indicator Refined 134"
label var CCIR135                  "ICD-10-CM Chronic Condition Indicator Refined 135"
label var CCIR136                  "ICD-10-CM Chronic Condition Indicator Refined 136"
label var CMR_AIDS                 "Acquired immune deficiency syndrome"
label var CMR_ALCOHOL              "Alcohol abuse"
label var CMR_ANEMDEF              "Anemias due to other nutritional deficiencies"
label var CMR_AUTOIMMUNE           "Autoimmune conditions"
label var CMR_BLDLOSS              "Chronic blood loss anemia (iron deficiency)"
label var CMR_CANCER_LEUK          "Leukemia"
label var CMR_CANCER_LYMPH         "Lymphoma"
label var CMR_CANCER_METS          "Metastatic cancer"
label var CMR_CANCER_NSITU         "Solid tumor without metastasis, in situ"
label var CMR_CANCER_SOLID         "Solid tumor without metastasis, malignant"
label var CMR_CBVD                 "Cerebrovascular disease"
label var CMR_COAG                 "Coagulopathy"
label var CMR_DEMENTIA             "Dementia"
label var CMR_DEPRESS              "Depression"
label var CMR_DIAB_CX              "Diabetes with chronic complications"
label var CMR_DIAB_UNCX            "Diabetes without chronic complications"
label var CMR_DRUG_ABUSE           "Drug abuse"
label var CMR_HF                   "Heart failure"
label var CMR_HTN_CX               "Hypertension, complicated"
label var CMR_HTN_UNCX             "Hypertension, uncomplicated"
label var CMR_LIVER_MLD            "Liver disease, mild"
label var CMR_LIVER_SEV            "Liver disease, moderate to severe"
label var CMR_LUNG_CHRONIC         "Chronic pulmonary disease"
label var CMR_NEURO_MOVT           "Neurological disorders affecting movement"
label var CMR_NEURO_OTH            "Other neurological disorders"
label var CMR_NEURO_SEIZ           "Seizures and epilepsy"
label var CMR_OBESE                "Obesity"
label var CMR_PARALYSIS            "Paralysis"
label var CMR_PERIVASC             "Peripheral vascular disease"
label var CMR_PSYCHOSES            "Psychoses"
label var CMR_PULMCIRC             "Pulmonary circulation disease"
label var CMR_RENLFL_MOD           "Renal failure, moderate"
label var CMR_RENLFL_SEV           "Renal failure, severe"
label var CMR_THYROID_HYPO         "Hypothyroidism"
label var CMR_THYROID_OTH          "Other thyroid disorders"
label var CMR_ULCER_PEPTIC         "Peptic ulcer disease x bleeding"
label var CMR_VALVE                "Valvular disease"
label var CMR_VERSION              "Version of Elixhauser Comorbidity Software Refined"
label var CMR_WGHTLOSS             "Weight loss"
label var I10_INJURY
    "Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)"
label var I10_INJURY_CUT           "Mechanism of injury: cut or pierce"
label var I10_INJURY_DROWN         "Mechanism of injury: drowning or submersion"
label var I10_INJURY_FALL          "Mechanism of injury: fall"
label var I10_INJURY_FIRE          "Mechanism of injury: fire, flame, hot object, or hot substance"
label var I10_INJURY_FIREARM       "Mechanism of injury: firearm"
label var I10_INJURY_MACHINERY     "Mechanism of injury: machinery"
label var I10_INJURY_MVT

"Mechanism of injury: motor vehicle traffic, including the occupant of a car, motorcyclist, pedal cyclist, pedestrian, other, or uns
pecified"
label var I10_INJURY_NATURE
    "Mechanism of injury: natural or environmental, included venomous and nonvenomous bites and stings"
label var I10_INJURY_OVEREXERTION  "Mechanism of injury: overexertion"
label var I10_INJURY_POISON        "Mechanism of injury: poisoning, including drugs and nondrugs"
label var I10_INJURY_STRUCK        "Mechanism of injury: struck by or against"
label var I10_INJURY_SUFFOCATION   "Mechanism of injury: suffocation"
label var I10_INTENT_ASSAULT       "Intent of injury: assault"
label var I10_INTENT_SELF_HARM     "Intent of injury: intentional self-harm"
label var I10_INTENT_UNINTENTIONAL "Intent of injury: unintentional"
label var I10_MULTINJURY           "Multiple ICD-10-CM injuries reported on record"
label var KEY                      "HCUP record identifier"
label var PCLASS_VERSION           "Version of ICD-10-PCS Procedure class"
label var PCLASS1                  "ICD-10-PCS Procedure class 1"
label var PCLASS2                  "ICD-10-PCS Procedure class 2"
label var PCLASS3                  "ICD-10-PCS Procedure class 3"
label var PCLASS4                  "ICD-10-PCS Procedure class 4"
label var PCLASS5                  "ICD-10-PCS Procedure class 5"
label var PCLASS6                  "ICD-10-PCS Procedure class 6"
label var PCLASS7                  "ICD-10-PCS Procedure class 7"
label var PCLASS8                  "ICD-10-PCS Procedure class 8"
label var PCLASS9                  "ICD-10-PCS Procedure class 9"
label var PCLASS10                 "ICD-10-PCS Procedure class 10"
label var PCLASS11                 "ICD-10-PCS Procedure class 11"
label var PCLASS12                 "ICD-10-PCS Procedure class 12"
label var PCLASS13                 "ICD-10-PCS Procedure class 13"
label var PCLASS14                 "ICD-10-PCS Procedure class 14"
label var PCLASS15                 "ICD-10-PCS Procedure class 15"
label var PCLASS16                 "ICD-10-PCS Procedure class 16"
label var PCLASS17                 "ICD-10-PCS Procedure class 17"
label var PCLASS18                 "ICD-10-PCS Procedure class 18"
label var PCLASS19                 "ICD-10-PCS Procedure class 19"
label var PCLASS20                 "ICD-10-PCS Procedure class 20"
label var PCLASS21                 "ICD-10-PCS Procedure class 21"
label var PCLASS22                 "ICD-10-PCS Procedure class 22"
label var PCLASS23                 "ICD-10-PCS Procedure class 23"
label var PCLASS24                 "ICD-10-PCS Procedure class 24"
label var PCLASS25                 "ICD-10-PCS Procedure class 25"
label var PCLASS26                 "ICD-10-PCS Procedure class 26"
label var PCLASS27                 "ICD-10-PCS Procedure class 27"
label var PCLASS28                 "ICD-10-PCS Procedure class 28"
label var PCLASS29                 "ICD-10-PCS Procedure class 29"
label var PCLASS30                 "ICD-10-PCS Procedure class 30"
label var PCLASS31                 "ICD-10-PCS Procedure class 31"
label var PCLASS32                 "ICD-10-PCS Procedure class 32"
label var PCLASS33                 "ICD-10-PCS Procedure class 33"
label var PCLASS34                 "ICD-10-PCS Procedure class 34"
label var PCLASS35                 "ICD-10-PCS Procedure class 35"
label var PCLASS36                 "ICD-10-PCS Procedure class 36"
label var PCLASS37                 "ICD-10-PCS Procedure class 37"
label var PCLASS38                 "ICD-10-PCS Procedure class 38"
label var PCLASS39                 "ICD-10-PCS Procedure class 39"
label var PCLASS40                 "ICD-10-PCS Procedure class 40"
label var PCLASS41                 "ICD-10-PCS Procedure class 41"
label var PCLASS42                 "ICD-10-PCS Procedure class 42"
label var PCLASS43                 "ICD-10-PCS Procedure class 43"
label var PCLASS44                 "ICD-10-PCS Procedure class 44"
label var PCLASS45                 "ICD-10-PCS Procedure class 45"
label var PCLASS46                 "ICD-10-PCS Procedure class 46"
label var PCLASS47                 "ICD-10-PCS Procedure class 47"
label var PCLASS48                 "ICD-10-PCS Procedure class 48"
label var PCLASS49                 "ICD-10-PCS Procedure class 49"
label var PCLASS50                 "ICD-10-PCS Procedure class 50"
label var PCLASS51                 "ICD-10-PCS Procedure class 51"
label var PCLASS52                 "ICD-10-PCS Procedure class 52"
label var PCLASS53                 "ICD-10-PCS Procedure class 53"
label var PCLASS54                 "ICD-10-PCS Procedure class 54"
label var PCLASS55                 "ICD-10-PCS Procedure class 55"
label var PCLASS56                 "ICD-10-PCS Procedure class 56"
label var PCLASS57                 "ICD-10-PCS Procedure class 57"
label var PCLASS58                 "ICD-10-PCS Procedure class 58"
label var PCLASS59                 "ICD-10-PCS Procedure class 59"
label var PCLASS60                 "ICD-10-PCS Procedure class 60"
label var PCLASS61                 "ICD-10-PCS Procedure class 61"
label var PCLASS62                 "ICD-10-PCS Procedure class 62"
label var PCLASS63                 "ICD-10-PCS Procedure class 63"
label var PCLASS64                 "ICD-10-PCS Procedure class 64"
label var PCLASS65                 "ICD-10-PCS Procedure class 65"
label var PCLASS66                 "ICD-10-PCS Procedure class 66"
label var PCLASS67                 "ICD-10-PCS Procedure class 67"
label var PCLASS68                 "ICD-10-PCS Procedure class 68"
label var PCLASS69                 "ICD-10-PCS Procedure class 69"
label var PCLASS70                 "ICD-10-PCS Procedure class 70"
label var PCLASS71                 "ICD-10-PCS Procedure class 71"
label var PCLASS72                 "ICD-10-PCS Procedure class 72"
label var PCLASS73                 "ICD-10-PCS Procedure class 73"
label var PCLASS74                 "ICD-10-PCS Procedure class 74"
label var PCLASS75                 "ICD-10-PCS Procedure class 75"
label var PCLASS76                 "ICD-10-PCS Procedure class 76"
label var PCLASS77                 "ICD-10-PCS Procedure class 77"
label var PCLASS78                 "ICD-10-PCS Procedure class 78"
label var PCLASS79                 "ICD-10-PCS Procedure class 79"
label var PCLASS80                 "ICD-10-PCS Procedure class 80"
label var PCLASS81                 "ICD-10-PCS Procedure class 81"
label var PCLASS82                 "ICD-10-PCS Procedure class 82"
label var PCLASS83                 "ICD-10-PCS Procedure class 83"
label var PCLASS84                 "ICD-10-PCS Procedure class 84"
label var PCLASS85                 "ICD-10-PCS Procedure class 85"
label var PCLASS86                 "ICD-10-PCS Procedure class 86"
label var PCLASS87                 "ICD-10-PCS Procedure class 87"
label var PCLASS88                 "ICD-10-PCS Procedure class 88"
label var PCLASS89                 "ICD-10-PCS Procedure class 89"
label var PCLASS90                 "ICD-10-PCS Procedure class 90"
label var PCLASS91                 "ICD-10-PCS Procedure class 91"
label var PCLASS92                 "ICD-10-PCS Procedure class 92"
label var PCLASS93                 "ICD-10-PCS Procedure class 93"
label var PCLASS94                 "ICD-10-PCS Procedure class 94"
label var PCLASS95                 "ICD-10-PCS Procedure class 95"
label var PCLASS96                 "ICD-10-PCS Procedure class 96"
label var PCLASS97                 "ICD-10-PCS Procedure class 97"
label var PCLASS98                 "ICD-10-PCS Procedure class 98"
label var PCLASS99                 "ICD-10-PCS Procedure class 99"
label var PCLASS100                "ICD-10-PCS Procedure class 100"
label var PCLASS101                "ICD-10-PCS Procedure class 101"
label var PCLASS102                "ICD-10-PCS Procedure class 102"
label var PCLASS103                "ICD-10-PCS Procedure class 103"
label var PCLASS104                "ICD-10-PCS Procedure class 104"
label var PCLASS105                "ICD-10-PCS Procedure class 105"
label var PCLASS106                "ICD-10-PCS Procedure class 106"
label var PCLASS107                "ICD-10-PCS Procedure class 107"
label var PCLASS108                "ICD-10-PCS Procedure class 108"
label var PCLASS109                "ICD-10-PCS Procedure class 109"
label var PCLASS110                "ICD-10-PCS Procedure class 110"
label var PCLASS111                "ICD-10-PCS Procedure class 111"
label var PCLASS112                "ICD-10-PCS Procedure class 112"
label var PCLASS113                "ICD-10-PCS Procedure class 113"
label var PCLASS114                "ICD-10-PCS Procedure class 114"
label var PCLASS115                "ICD-10-PCS Procedure class 115"
label var PCLASS116                "ICD-10-PCS Procedure class 116"
label var PCLASS117                "ICD-10-PCS Procedure class 117"
label var PCLASS118                "ICD-10-PCS Procedure class 118"
label var PCLASS119                "ICD-10-PCS Procedure class 119"
label var PCLASS120                "ICD-10-PCS Procedure class 120"
label var PCLASS121                "ICD-10-PCS Procedure class 121"
label var PCLASS122                "ICD-10-PCS Procedure class 122"
label var PCLASS123                "ICD-10-PCS Procedure class 123"
label var PCLASS124                "ICD-10-PCS Procedure class 124"
label var PCLASS125                "ICD-10-PCS Procedure class 125"
label var PCLASS126                "ICD-10-PCS Procedure class 126"
label var PCLASS127                "ICD-10-PCS Procedure class 127"
label var PCLASS128                "ICD-10-PCS Procedure class 128"
label var PCLASS129                "ICD-10-PCS Procedure class 129"
label var PCLASS130                "ICD-10-PCS Procedure class 130"
label var PCLASS131                "ICD-10-PCS Procedure class 131"
label var PCLASS132                "ICD-10-PCS Procedure class 132"
label var PCLASS133                "ICD-10-PCS Procedure class 133"
label var PCLASS134                "ICD-10-PCS Procedure class 134"
label var PCLASS135                "ICD-10-PCS Procedure class 135"
label var PCLASS136                "ICD-10-PCS Procedure class 136"
label var PCLASS137                "ICD-10-PCS Procedure class 137"
label var PCLASS138                "ICD-10-PCS Procedure class 138"
label var PCLASS139                "ICD-10-PCS Procedure class 139"
label var PCLASS140                "ICD-10-PCS Procedure class 140"
label var PCLASS141                "ICD-10-PCS Procedure class 141"
label var PCLASS142                "ICD-10-PCS Procedure class 142"
label var PCLASS143                "ICD-10-PCS Procedure class 143"
label var PCLASS144                "ICD-10-PCS Procedure class 144"
label var PCLASS145                "ICD-10-PCS Procedure class 145"
label var PCLASS146                "ICD-10-PCS Procedure class 146"
label var PCLASS147                "ICD-10-PCS Procedure class 147"
label var PCLASS148                "ICD-10-PCS Procedure class 148"
label var PCLASS149                "ICD-10-PCS Procedure class 149"
label var PCLASS150                "ICD-10-PCS Procedure class 150"
label var PCLASS151                "ICD-10-PCS Procedure class 151"
label var PCLASS152                "ICD-10-PCS Procedure class 152"
label var PCLASS153                "ICD-10-PCS Procedure class 153"
label var PCLASS154                "ICD-10-PCS Procedure class 154"
label var PCLASS155                "ICD-10-PCS Procedure class 155"
label var PCLASS156                "ICD-10-PCS Procedure class 156"
label var PCLASS157                "ICD-10-PCS Procedure class 157"
label var PCLASS158                "ICD-10-PCS Procedure class 158"
label var PCLASS159                "ICD-10-PCS Procedure class 159"
label var PCLASS160                "ICD-10-PCS Procedure class 160"
label var PCLASS161                "ICD-10-PCS Procedure class 161"
label var PCLASS162                "ICD-10-PCS Procedure class 162"
label var PCLASS163                "ICD-10-PCS Procedure class 163"
label var PCLASS164                "ICD-10-PCS Procedure class 164"
label var PCLASS165                "ICD-10-PCS Procedure class 165"
label var PCLASS166                "ICD-10-PCS Procedure class 166"
label var PCLASS167                "ICD-10-PCS Procedure class 167"
label var PCLASS168                "ICD-10-PCS Procedure class 168"
label var PCLASS169                "ICD-10-PCS Procedure class 169"
label var PCLASS170                "ICD-10-PCS Procedure class 170"
label var PCLASS171                "ICD-10-PCS Procedure class 171"
label var PCLASS172                "ICD-10-PCS Procedure class 172"
label var PCLASS173                "ICD-10-PCS Procedure class 173"
label var PCLASS174                "ICD-10-PCS Procedure class 174"
label var PCLASS175                "ICD-10-PCS Procedure class 175"
label var PCLASS176                "ICD-10-PCS Procedure class 176"
label var PCLASS177                "ICD-10-PCS Procedure class 177"
label var PCLASS178                "ICD-10-PCS Procedure class 178"
label var PCLASS179                "ICD-10-PCS Procedure class 179"
label var PCLASS180                "ICD-10-PCS Procedure class 180"
label var PCLASS181                "ICD-10-PCS Procedure class 181"
label var PCLASS182                "ICD-10-PCS Procedure class 182"
label var PCLASS183                "ICD-10-PCS Procedure class 183"
label var PCLASS184                "ICD-10-PCS Procedure class 184"
label var PCLASS185                "ICD-10-PCS Procedure class 185"
label var PCLASS186                "ICD-10-PCS Procedure class 186"
label var PCLASS187                "ICD-10-PCS Procedure class 187"
label var PCLASS188                "ICD-10-PCS Procedure class 188"
label var PCLASS189                "ICD-10-PCS Procedure class 189"
label var PCLASS190                "ICD-10-PCS Procedure class 190"
label var PCLASS191                "ICD-10-PCS Procedure class 191"
label var PCLASS192                "ICD-10-PCS Procedure class 192"
label var PCLASS193                "ICD-10-PCS Procedure class 193"
label var PCLASS194                "ICD-10-PCS Procedure class 194"
label var PCLASS195                "ICD-10-PCS Procedure class 195"
label var PCLASS196                "ICD-10-PCS Procedure class 196"
label var PCLASS197                "ICD-10-PCS Procedure class 197"
label var PCLASS198                "ICD-10-PCS Procedure class 198"
label var PCLASS199                "ICD-10-PCS Procedure class 199"
label var PCLASS200                "ICD-10-PCS Procedure class 200"
label var DXCCSR_Default_DX1       "Default CCSR for principal/first-listed ICD-10-CM diagnosis"
label var DXCCSR_BLD001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD001"
label var DXCCSR_BLD002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD002"
label var DXCCSR_BLD003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD003"
label var DXCCSR_BLD004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD004"
label var DXCCSR_BLD005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD005"
label var DXCCSR_BLD006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD006"
label var DXCCSR_BLD007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD007"
label var DXCCSR_BLD008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD008"
label var DXCCSR_BLD009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD009"
label var DXCCSR_BLD010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD010"
label var DXCCSR_CIR001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR001"
label var DXCCSR_CIR002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR002"
label var DXCCSR_CIR003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR003"
label var DXCCSR_CIR004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR004"
label var DXCCSR_CIR005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR005"
label var DXCCSR_CIR006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR006"
label var DXCCSR_CIR007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR007"
label var DXCCSR_CIR008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR008"
label var DXCCSR_CIR009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR009"
label var DXCCSR_CIR010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR010"
label var DXCCSR_CIR011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR011"
label var DXCCSR_CIR012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR012"
label var DXCCSR_CIR013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR013"
label var DXCCSR_CIR014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR014"
label var DXCCSR_CIR015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR015"
label var DXCCSR_CIR016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR016"
label var DXCCSR_CIR017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR017"
label var DXCCSR_CIR018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR018"
label var DXCCSR_CIR019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR019"
label var DXCCSR_CIR020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR020"
label var DXCCSR_CIR021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR021"
label var DXCCSR_CIR022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR022"
label var DXCCSR_CIR023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR023"
label var DXCCSR_CIR024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR024"
label var DXCCSR_CIR025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR025"
label var DXCCSR_CIR026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR026"
label var DXCCSR_CIR027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR027"
label var DXCCSR_CIR028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR028"
label var DXCCSR_CIR029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR029"
label var DXCCSR_CIR030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR030"
label var DXCCSR_CIR031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR031"
label var DXCCSR_CIR032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR032"
label var DXCCSR_CIR033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR033"
label var DXCCSR_CIR034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR034"
label var DXCCSR_CIR035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR035"
label var DXCCSR_CIR036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR036"
label var DXCCSR_CIR037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR037"
label var DXCCSR_CIR038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR038"
label var DXCCSR_CIR039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR039"
label var DXCCSR_DEN001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN001"
label var DXCCSR_DEN002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN002"
label var DXCCSR_DEN003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN003"
label var DXCCSR_DIG001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG001"
label var DXCCSR_DIG002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG002"
label var DXCCSR_DIG003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG003"
label var DXCCSR_DIG004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG004"
label var DXCCSR_DIG005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG005"
label var DXCCSR_DIG006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG006"
label var DXCCSR_DIG007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG007"
label var DXCCSR_DIG008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG008"
label var DXCCSR_DIG009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG009"
label var DXCCSR_DIG010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG010"
label var DXCCSR_DIG011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG011"
label var DXCCSR_DIG012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG012"
label var DXCCSR_DIG013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG013"
label var DXCCSR_DIG014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG014"
label var DXCCSR_DIG015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG015"
label var DXCCSR_DIG016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG016"
label var DXCCSR_DIG017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG017"
label var DXCCSR_DIG018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG018"
label var DXCCSR_DIG019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG019"
label var DXCCSR_DIG020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG020"
label var DXCCSR_DIG021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG021"
label var DXCCSR_DIG022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG022"
label var DXCCSR_DIG023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG023"
label var DXCCSR_DIG024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG024"
label var DXCCSR_DIG025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG025"
label var DXCCSR_EAR001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR001"
label var DXCCSR_EAR002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR002"
label var DXCCSR_EAR003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR003"
label var DXCCSR_EAR004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR004"
label var DXCCSR_EAR005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR005"
label var DXCCSR_EAR006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR006"
label var DXCCSR_END001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END001"
label var DXCCSR_END002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END002"
label var DXCCSR_END003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END003"
label var DXCCSR_END004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END004"
label var DXCCSR_END005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END005"
label var DXCCSR_END006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END006"
label var DXCCSR_END007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END007"
label var DXCCSR_END008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END008"
label var DXCCSR_END009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END009"
label var DXCCSR_END010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END010"
label var DXCCSR_END011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END011"
label var DXCCSR_END012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END012"
label var DXCCSR_END013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END013"
label var DXCCSR_END014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END014"
label var DXCCSR_END015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END015"
label var DXCCSR_END016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END016"
label var DXCCSR_END017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END017"
label var DXCCSR_EXT001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT001"
label var DXCCSR_EXT002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT002"
label var DXCCSR_EXT003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT003"
label var DXCCSR_EXT004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT004"
label var DXCCSR_EXT005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT005"
label var DXCCSR_EXT006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT006"
label var DXCCSR_EXT007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT007"
label var DXCCSR_EXT008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT008"
label var DXCCSR_EXT009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT009"
label var DXCCSR_EXT010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT010"
label var DXCCSR_EXT011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT011"
label var DXCCSR_EXT012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT012"
label var DXCCSR_EXT013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT013"
label var DXCCSR_EXT014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT014"
label var DXCCSR_EXT015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT015"
label var DXCCSR_EXT016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT016"
label var DXCCSR_EXT017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT017"
label var DXCCSR_EXT018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT018"
label var DXCCSR_EXT019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT019"
label var DXCCSR_EXT020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT020"
label var DXCCSR_EXT021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT021"
label var DXCCSR_EXT022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT022"
label var DXCCSR_EXT023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT023"
label var DXCCSR_EXT024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT024"
label var DXCCSR_EXT025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT025"
label var DXCCSR_EXT026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT026"
label var DXCCSR_EXT027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT027"
label var DXCCSR_EXT028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT028"
label var DXCCSR_EXT029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT029"
label var DXCCSR_EXT030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT030"
label var DXCCSR_EYE001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE001"
label var DXCCSR_EYE002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE002"
label var DXCCSR_EYE003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE003"
label var DXCCSR_EYE004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE004"
label var DXCCSR_EYE005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE005"
label var DXCCSR_EYE006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE006"
label var DXCCSR_EYE007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE007"
label var DXCCSR_EYE008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE008"
label var DXCCSR_EYE009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE009"
label var DXCCSR_EYE010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE010"
label var DXCCSR_EYE011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE011"
label var DXCCSR_EYE012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE012"
label var DXCCSR_FAC001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC001"
label var DXCCSR_FAC002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC002"
label var DXCCSR_FAC003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC003"
label var DXCCSR_FAC004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC004"
label var DXCCSR_FAC005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC005"
label var DXCCSR_FAC006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC006"
label var DXCCSR_FAC007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC007"
label var DXCCSR_FAC008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC008"
label var DXCCSR_FAC009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC009"
label var DXCCSR_FAC010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC010"
label var DXCCSR_FAC011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC011"
label var DXCCSR_FAC012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC012"
label var DXCCSR_FAC013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC013"
label var DXCCSR_FAC014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC014"
label var DXCCSR_FAC015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC015"
label var DXCCSR_FAC016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC016"
label var DXCCSR_FAC017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC017"
label var DXCCSR_FAC018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC018"
label var DXCCSR_FAC019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC019"
label var DXCCSR_FAC020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC020"
label var DXCCSR_FAC021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC021"
label var DXCCSR_FAC022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC022"
label var DXCCSR_FAC023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC023"
label var DXCCSR_FAC024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC024"
label var DXCCSR_FAC025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC025"
label var DXCCSR_GEN001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN001"
label var DXCCSR_GEN002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN002"
label var DXCCSR_GEN003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN003"
label var DXCCSR_GEN004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN004"
label var DXCCSR_GEN005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN005"
label var DXCCSR_GEN006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN006"
label var DXCCSR_GEN007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN007"
label var DXCCSR_GEN008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN008"
label var DXCCSR_GEN009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN009"
label var DXCCSR_GEN010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN010"
label var DXCCSR_GEN011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN011"
label var DXCCSR_GEN012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN012"
label var DXCCSR_GEN013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN013"
label var DXCCSR_GEN014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN014"
label var DXCCSR_GEN015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN015"
label var DXCCSR_GEN016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN016"
label var DXCCSR_GEN017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN017"
label var DXCCSR_GEN018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN018"
label var DXCCSR_GEN019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN019"
label var DXCCSR_GEN020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN020"
label var DXCCSR_GEN021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN021"
label var DXCCSR_GEN022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN022"
label var DXCCSR_GEN023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN023"
label var DXCCSR_GEN024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN024"
label var DXCCSR_GEN025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN025"
label var DXCCSR_GEN026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN026"
label var DXCCSR_INF001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF001"
label var DXCCSR_INF002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF002"
label var DXCCSR_INF003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF003"
label var DXCCSR_INF004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF004"
label var DXCCSR_INF005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF005"
label var DXCCSR_INF006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF006"
label var DXCCSR_INF007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF007"
label var DXCCSR_INF008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF008"
label var DXCCSR_INF009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF009"
label var DXCCSR_INF010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF010"
label var DXCCSR_INF011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF011"
label var DXCCSR_INF012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF012"
label var DXCCSR_INJ001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ001"
label var DXCCSR_INJ002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ002"
label var DXCCSR_INJ003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ003"
label var DXCCSR_INJ004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ004"
label var DXCCSR_INJ005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ005"
label var DXCCSR_INJ006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ006"
label var DXCCSR_INJ007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ007"
label var DXCCSR_INJ008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ008"
label var DXCCSR_INJ009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ009"
label var DXCCSR_INJ010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ010"
label var DXCCSR_INJ011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ011"
label var DXCCSR_INJ012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ012"
label var DXCCSR_INJ013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ013"
label var DXCCSR_INJ014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ014"
label var DXCCSR_INJ015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ015"
label var DXCCSR_INJ016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ016"
label var DXCCSR_INJ017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ017"
label var DXCCSR_INJ018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ018"
label var DXCCSR_INJ019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ019"
label var DXCCSR_INJ020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ020"
label var DXCCSR_INJ021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ021"
label var DXCCSR_INJ022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ022"
label var DXCCSR_INJ023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ023"
label var DXCCSR_INJ024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ024"
label var DXCCSR_INJ025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ025"
label var DXCCSR_INJ026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ026"
label var DXCCSR_INJ027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ027"
label var DXCCSR_INJ028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ028"
label var DXCCSR_INJ029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ029"
label var DXCCSR_INJ030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ030"
label var DXCCSR_INJ031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ031"
label var DXCCSR_INJ032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ032"
label var DXCCSR_INJ033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ033"
label var DXCCSR_INJ034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ034"
label var DXCCSR_INJ035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ035"
label var DXCCSR_INJ036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ036"
label var DXCCSR_INJ037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ037"
label var DXCCSR_INJ038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ038"
label var DXCCSR_INJ039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ039"
label var DXCCSR_INJ040            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ040"
label var DXCCSR_INJ041            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ041"
label var DXCCSR_INJ042            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ042"
label var DXCCSR_INJ043            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ043"
label var DXCCSR_INJ044            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ044"
label var DXCCSR_INJ045            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ045"
label var DXCCSR_INJ046            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ046"
label var DXCCSR_INJ047            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ047"
label var DXCCSR_INJ048            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ048"
label var DXCCSR_INJ049            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ049"
label var DXCCSR_INJ050            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ050"
label var DXCCSR_INJ051            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ051"
label var DXCCSR_INJ052            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ052"
label var DXCCSR_INJ053            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ053"
label var DXCCSR_INJ054            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ054"
label var DXCCSR_INJ055            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ055"
label var DXCCSR_INJ056            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ056"
label var DXCCSR_INJ057            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ057"
label var DXCCSR_INJ058            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ058"
label var DXCCSR_INJ059            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ059"
label var DXCCSR_INJ060            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ060"
label var DXCCSR_INJ061            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ061"
label var DXCCSR_INJ062            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ062"
label var DXCCSR_INJ063            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ063"
label var DXCCSR_INJ064            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ064"
label var DXCCSR_INJ065            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ065"
label var DXCCSR_INJ066            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ066"
label var DXCCSR_INJ067            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ067"
label var DXCCSR_INJ068            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ068"
label var DXCCSR_INJ069            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ069"
label var DXCCSR_INJ070            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ070"
label var DXCCSR_INJ071            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ071"
label var DXCCSR_INJ072            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ072"
label var DXCCSR_INJ073            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ073"
label var DXCCSR_INJ074            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ074"
label var DXCCSR_INJ075            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ075"
label var DXCCSR_INJ076            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ076"
label var DXCCSR_MAL001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL001"
label var DXCCSR_MAL002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL002"
label var DXCCSR_MAL003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL003"
label var DXCCSR_MAL004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL004"
label var DXCCSR_MAL005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL005"
label var DXCCSR_MAL006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL006"
label var DXCCSR_MAL007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL007"
label var DXCCSR_MAL008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL008"
label var DXCCSR_MAL009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL009"
label var DXCCSR_MAL010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL010"
label var DXCCSR_MBD001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD001"
label var DXCCSR_MBD002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD002"
label var DXCCSR_MBD003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD003"
label var DXCCSR_MBD004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD004"
label var DXCCSR_MBD005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD005"
label var DXCCSR_MBD006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD006"
label var DXCCSR_MBD007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD007"
label var DXCCSR_MBD008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD008"
label var DXCCSR_MBD009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD009"
label var DXCCSR_MBD010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD010"
label var DXCCSR_MBD011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD011"
label var DXCCSR_MBD012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD012"
label var DXCCSR_MBD013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD013"
label var DXCCSR_MBD014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD014"
label var DXCCSR_MBD017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD017"
label var DXCCSR_MBD018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD018"
label var DXCCSR_MBD019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD019"
label var DXCCSR_MBD020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD020"
label var DXCCSR_MBD021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD021"
label var DXCCSR_MBD022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD022"
label var DXCCSR_MBD023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD023"
label var DXCCSR_MBD024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD024"
label var DXCCSR_MBD025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD025"
label var DXCCSR_MBD026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD026"
label var DXCCSR_MBD027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD027"
label var DXCCSR_MBD028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD028"
label var DXCCSR_MBD029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD029"
label var DXCCSR_MBD030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD030"
label var DXCCSR_MBD031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD031"
label var DXCCSR_MBD032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD032"
label var DXCCSR_MBD033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD033"
label var DXCCSR_MBD034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD034"
label var DXCCSR_MUS001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS001"
label var DXCCSR_MUS002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS002"
label var DXCCSR_MUS003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS003"
label var DXCCSR_MUS004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS004"
label var DXCCSR_MUS005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS005"
label var DXCCSR_MUS006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS006"
label var DXCCSR_MUS007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS007"
label var DXCCSR_MUS008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS008"
label var DXCCSR_MUS009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS009"
label var DXCCSR_MUS010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS010"
label var DXCCSR_MUS011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS011"
label var DXCCSR_MUS012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS012"
label var DXCCSR_MUS013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS013"
label var DXCCSR_MUS014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS014"
label var DXCCSR_MUS015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS015"
label var DXCCSR_MUS016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS016"
label var DXCCSR_MUS017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS017"
label var DXCCSR_MUS018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS018"
label var DXCCSR_MUS019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS019"
label var DXCCSR_MUS020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS020"
label var DXCCSR_MUS021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS021"
label var DXCCSR_MUS022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS022"
label var DXCCSR_MUS023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS023"
label var DXCCSR_MUS024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS024"
label var DXCCSR_MUS025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS025"
label var DXCCSR_MUS026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS026"
label var DXCCSR_MUS027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS027"
label var DXCCSR_MUS028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS028"
label var DXCCSR_MUS029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS029"
label var DXCCSR_MUS030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS030"
label var DXCCSR_MUS031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS031"
label var DXCCSR_MUS032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS032"
label var DXCCSR_MUS033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS033"
label var DXCCSR_MUS034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS034"
label var DXCCSR_MUS035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS035"
label var DXCCSR_MUS036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS036"
label var DXCCSR_MUS037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS037"
label var DXCCSR_MUS038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS038"
label var DXCCSR_NEO001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO001"
label var DXCCSR_NEO002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO002"
label var DXCCSR_NEO003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO003"
label var DXCCSR_NEO004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO004"
label var DXCCSR_NEO005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO005"
label var DXCCSR_NEO006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO006"
label var DXCCSR_NEO007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO007"
label var DXCCSR_NEO008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO008"
label var DXCCSR_NEO009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO009"
label var DXCCSR_NEO010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO010"
label var DXCCSR_NEO011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO011"
label var DXCCSR_NEO012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO012"
label var DXCCSR_NEO013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO013"
label var DXCCSR_NEO014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO014"
label var DXCCSR_NEO015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO015"
label var DXCCSR_NEO016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO016"
label var DXCCSR_NEO017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO017"
label var DXCCSR_NEO018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO018"
label var DXCCSR_NEO019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO019"
label var DXCCSR_NEO020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO020"
label var DXCCSR_NEO021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO021"
label var DXCCSR_NEO022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO022"
label var DXCCSR_NEO023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO023"
label var DXCCSR_NEO024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO024"
label var DXCCSR_NEO025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO025"
label var DXCCSR_NEO026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO026"
label var DXCCSR_NEO027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO027"
label var DXCCSR_NEO028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO028"
label var DXCCSR_NEO029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO029"
label var DXCCSR_NEO030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO030"
label var DXCCSR_NEO031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO031"
label var DXCCSR_NEO032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO032"
label var DXCCSR_NEO033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO033"
label var DXCCSR_NEO034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO034"
label var DXCCSR_NEO035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO035"
label var DXCCSR_NEO036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO036"
label var DXCCSR_NEO037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO037"
label var DXCCSR_NEO038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO038"
label var DXCCSR_NEO039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO039"
label var DXCCSR_NEO040            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO040"
label var DXCCSR_NEO041            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO041"
label var DXCCSR_NEO042            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO042"
label var DXCCSR_NEO043            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO043"
label var DXCCSR_NEO044            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO044"
label var DXCCSR_NEO045            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO045"
label var DXCCSR_NEO046            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO046"
label var DXCCSR_NEO047            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO047"
label var DXCCSR_NEO048            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO048"
label var DXCCSR_NEO049            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO049"
label var DXCCSR_NEO050            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO050"
label var DXCCSR_NEO051            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO051"
label var DXCCSR_NEO052            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO052"
label var DXCCSR_NEO053            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO053"
label var DXCCSR_NEO054            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO054"
label var DXCCSR_NEO055            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO055"
label var DXCCSR_NEO056            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO056"
label var DXCCSR_NEO057            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO057"
label var DXCCSR_NEO058            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO058"
label var DXCCSR_NEO059            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO059"
label var DXCCSR_NEO060            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO060"
label var DXCCSR_NEO061            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO061"
label var DXCCSR_NEO062            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO062"
label var DXCCSR_NEO063            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO063"
label var DXCCSR_NEO064            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO064"
label var DXCCSR_NEO065            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO065"
label var DXCCSR_NEO066            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO066"
label var DXCCSR_NEO067            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO067"
label var DXCCSR_NEO068            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO068"
label var DXCCSR_NEO069            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO069"
label var DXCCSR_NEO070            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO070"
label var DXCCSR_NEO071            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO071"
label var DXCCSR_NEO072            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO072"
label var DXCCSR_NEO073            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO073"
label var DXCCSR_NEO074            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO074"
label var DXCCSR_NVS001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS001"
label var DXCCSR_NVS002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS002"
label var DXCCSR_NVS003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS003"
label var DXCCSR_NVS004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS004"
label var DXCCSR_NVS005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS005"
label var DXCCSR_NVS006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS006"
label var DXCCSR_NVS007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS007"
label var DXCCSR_NVS008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS008"
label var DXCCSR_NVS009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS009"
label var DXCCSR_NVS010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS010"
label var DXCCSR_NVS011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS011"
label var DXCCSR_NVS012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS012"
label var DXCCSR_NVS013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS013"
label var DXCCSR_NVS014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS014"
label var DXCCSR_NVS015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS015"
label var DXCCSR_NVS016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS016"
label var DXCCSR_NVS017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS017"
label var DXCCSR_NVS018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS018"
label var DXCCSR_NVS019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS019"
label var DXCCSR_NVS020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS020"
label var DXCCSR_NVS021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS021"
label var DXCCSR_NVS022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS022"
label var DXCCSR_PNL001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL001"
label var DXCCSR_PNL002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL002"
label var DXCCSR_PNL003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL003"
label var DXCCSR_PNL004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL004"
label var DXCCSR_PNL005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL005"
label var DXCCSR_PNL006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL006"
label var DXCCSR_PNL007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL007"
label var DXCCSR_PNL008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL008"
label var DXCCSR_PNL009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL009"
label var DXCCSR_PNL010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL010"
label var DXCCSR_PNL011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL011"
label var DXCCSR_PNL012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL012"
label var DXCCSR_PNL013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL013"
label var DXCCSR_PNL014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL014"
label var DXCCSR_PNL015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL015"
label var DXCCSR_PRG001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG001"
label var DXCCSR_PRG002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG002"
label var DXCCSR_PRG003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG003"
label var DXCCSR_PRG004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG004"
label var DXCCSR_PRG005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG005"
label var DXCCSR_PRG006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG006"
label var DXCCSR_PRG007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG007"
label var DXCCSR_PRG008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG008"
label var DXCCSR_PRG009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG009"
label var DXCCSR_PRG010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG010"
label var DXCCSR_PRG011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG011"
label var DXCCSR_PRG012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG012"
label var DXCCSR_PRG013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG013"
label var DXCCSR_PRG014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG014"
label var DXCCSR_PRG015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG015"
label var DXCCSR_PRG016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG016"
label var DXCCSR_PRG017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG017"
label var DXCCSR_PRG018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG018"
label var DXCCSR_PRG019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG019"
label var DXCCSR_PRG020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG020"
label var DXCCSR_PRG021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG021"
label var DXCCSR_PRG022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG022"
label var DXCCSR_PRG023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG023"
label var DXCCSR_PRG024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG024"
label var DXCCSR_PRG025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG025"
label var DXCCSR_PRG026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG026"
label var DXCCSR_PRG027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG027"
label var DXCCSR_PRG028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG028"
label var DXCCSR_PRG029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG029"
label var DXCCSR_PRG030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG030"
label var DXCCSR_RSP001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP001"
label var DXCCSR_RSP002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP002"
label var DXCCSR_RSP003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP003"
label var DXCCSR_RSP004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP004"
label var DXCCSR_RSP005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP005"
label var DXCCSR_RSP006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP006"
label var DXCCSR_RSP007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP007"
label var DXCCSR_RSP008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP008"
label var DXCCSR_RSP009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP009"
label var DXCCSR_RSP010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP010"
label var DXCCSR_RSP011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP011"
label var DXCCSR_RSP012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP012"
label var DXCCSR_RSP013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP013"
label var DXCCSR_RSP014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP014"
label var DXCCSR_RSP015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP015"
label var DXCCSR_RSP016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP016"
label var DXCCSR_RSP017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP017"
label var DXCCSR_SKN001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN001"
label var DXCCSR_SKN002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN002"
label var DXCCSR_SKN003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN003"
label var DXCCSR_SKN004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN004"
label var DXCCSR_SKN005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN005"
label var DXCCSR_SKN006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN006"
label var DXCCSR_SKN007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN007"
label var DXCCSR_SYM001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM001"
label var DXCCSR_SYM002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM002"
label var DXCCSR_SYM003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM003"
label var DXCCSR_SYM004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM004"
label var DXCCSR_SYM005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM005"
label var DXCCSR_SYM006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM006"
label var DXCCSR_SYM007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM007"
label var DXCCSR_SYM008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM008"
label var DXCCSR_SYM009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM009"
label var DXCCSR_SYM010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM010"
label var DXCCSR_SYM011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM011"
label var DXCCSR_SYM012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM012"
label var DXCCSR_SYM013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM013"
label var DXCCSR_SYM014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM014"
label var DXCCSR_SYM015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM015"
label var DXCCSR_SYM016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM016"
label var DXCCSR_SYM017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM017"
label var DXCCSR_VERSION           "Version of CCSR for ICD-10-CM diagnoses"
label var PRCCSR_ADM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM001"
label var PRCCSR_ADM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM002"
label var PRCCSR_ADM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM003"
label var PRCCSR_ADM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM004"
label var PRCCSR_ADM005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM005"
label var PRCCSR_ADM006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM006"
label var PRCCSR_ADM007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM007"
label var PRCCSR_ADM008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM008"
label var PRCCSR_ADM009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM009"
label var PRCCSR_ADM010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM010"
label var PRCCSR_ADM011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM011"
label var PRCCSR_ADM012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM012"
label var PRCCSR_ADM013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM013"
label var PRCCSR_ADM014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM014"
label var PRCCSR_ADM015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM015"
label var PRCCSR_ADM016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM016"
label var PRCCSR_ADM017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM017"
label var PRCCSR_ADM018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM018"
label var PRCCSR_ADM019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM019"
label var PRCCSR_ADM020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM020"
label var PRCCSR_ADM021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM021"
label var PRCCSR_ADM022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM022"
label var PRCCSR_CAR001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR001"
label var PRCCSR_CAR002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR002"
label var PRCCSR_CAR003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR003"
label var PRCCSR_CAR004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR004"
label var PRCCSR_CAR005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR005"
label var PRCCSR_CAR006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR006"
label var PRCCSR_CAR007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR007"
label var PRCCSR_CAR008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR008"
label var PRCCSR_CAR009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR009"
label var PRCCSR_CAR010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR010"
label var PRCCSR_CAR011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR011"
label var PRCCSR_CAR012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR012"
label var PRCCSR_CAR013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR013"
label var PRCCSR_CAR014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR014"
label var PRCCSR_CAR015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR015"
label var PRCCSR_CAR016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR016"
label var PRCCSR_CAR017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR017"
label var PRCCSR_CAR018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR018"
label var PRCCSR_CAR019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR019"
label var PRCCSR_CAR020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR020"
label var PRCCSR_CAR021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR021"
label var PRCCSR_CAR022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR022"
label var PRCCSR_CAR023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR023"
label var PRCCSR_CAR024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR024"
label var PRCCSR_CAR025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR025"
label var PRCCSR_CAR026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR026"
label var PRCCSR_CAR027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR027"
label var PRCCSR_CAR028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR028"
label var PRCCSR_CAR029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR029"
label var PRCCSR_CHP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CHP001"
label var PRCCSR_CNS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS001"
label var PRCCSR_CNS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS002"
label var PRCCSR_CNS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS003"
label var PRCCSR_CNS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS004"
label var PRCCSR_CNS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS005"
label var PRCCSR_CNS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS006"
label var PRCCSR_CNS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS007"
label var PRCCSR_CNS008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS008"
label var PRCCSR_CNS009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS009"
label var PRCCSR_CNS010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS010"
label var PRCCSR_CNS011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS011"
label var PRCCSR_CNS012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS012"
label var PRCCSR_CNS013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS013"
label var PRCCSR_CNS014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS014"
label var PRCCSR_ENP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP001"
label var PRCCSR_ENP002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP002"
label var PRCCSR_ENP003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP003"
label var PRCCSR_ENP004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP004"
label var PRCCSR_ENP005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP005"
label var PRCCSR_ENP006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP006"
label var PRCCSR_ENT001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT001"
label var PRCCSR_ENT002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT002"
label var PRCCSR_ENT003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT003"
label var PRCCSR_ENT004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT004"
label var PRCCSR_ENT005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT005"
label var PRCCSR_ENT006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT006"
label var PRCCSR_ENT007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT007"
label var PRCCSR_ENT008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT008"
label var PRCCSR_ENT009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT009"
label var PRCCSR_ENT010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT010"
label var PRCCSR_ENT011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT011"
label var PRCCSR_ENT012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT012"
label var PRCCSR_ENT013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT013"
label var PRCCSR_ENT014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT014"
label var PRCCSR_ENT015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT015"
label var PRCCSR_ENT016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT016"
label var PRCCSR_ENT017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT017"
label var PRCCSR_ESA001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA001"
label var PRCCSR_ESA002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA002"
label var PRCCSR_ESA003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA003"
label var PRCCSR_ESA004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA004"
label var PRCCSR_ESA005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA005"
label var PRCCSR_ESA006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA006"
label var PRCCSR_ESA007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA007"
label var PRCCSR_ESA008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA008"
label var PRCCSR_ESA009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA009"
label var PRCCSR_ESA010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA010"
label var PRCCSR_ESA011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA011"
label var PRCCSR_EST001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST001"
label var PRCCSR_EST002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST002"
label var PRCCSR_EST003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST003"
label var PRCCSR_EST004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST004"
label var PRCCSR_EST005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST005"
label var PRCCSR_EYP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP001"
label var PRCCSR_EYP002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP002"
label var PRCCSR_FRS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS001"
label var PRCCSR_FRS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS002"
label var PRCCSR_FRS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS003"
label var PRCCSR_FRS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS004"
label var PRCCSR_FRS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS005"
label var PRCCSR_FRS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS006"
label var PRCCSR_FRS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS007"
label var PRCCSR_FRS008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS008"
label var PRCCSR_FRS009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS009"
label var PRCCSR_FRS010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS010"
label var PRCCSR_FRS011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS011"
label var PRCCSR_FRS012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS012"
label var PRCCSR_FRS013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS013"
label var PRCCSR_FRS014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS014"
label var PRCCSR_FRS015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS015"
label var PRCCSR_GIS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS001"
label var PRCCSR_GIS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS002"
label var PRCCSR_GIS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS003"
label var PRCCSR_GIS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS004"
label var PRCCSR_GIS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS005"
label var PRCCSR_GIS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS006"
label var PRCCSR_GIS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS007"
label var PRCCSR_GIS008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS008"
label var PRCCSR_GIS009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS009"
label var PRCCSR_GIS010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS010"
label var PRCCSR_GIS011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS011"
label var PRCCSR_GIS012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS012"
label var PRCCSR_GIS013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS013"
label var PRCCSR_GIS014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS014"
label var PRCCSR_GIS015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS015"
label var PRCCSR_GIS016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS016"
label var PRCCSR_GIS017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS017"
label var PRCCSR_GIS018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS018"
label var PRCCSR_GIS019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS019"
label var PRCCSR_GIS020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS020"
label var PRCCSR_GIS021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS021"
label var PRCCSR_GIS022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS022"
label var PRCCSR_GIS023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS023"
label var PRCCSR_GIS024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS024"
label var PRCCSR_GIS025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS025"
label var PRCCSR_GIS026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS026"
label var PRCCSR_GIS027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS027"
label var PRCCSR_GIS028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS028"
label var PRCCSR_GIS029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS029"
label var PRCCSR_GNR001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR001"
label var PRCCSR_GNR002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR002"
label var PRCCSR_GNR003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR003"
label var PRCCSR_GNR004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR004"
label var PRCCSR_GNR005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR005"
label var PRCCSR_GNR006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR006"
label var PRCCSR_GNR007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR007"
label var PRCCSR_GNR008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR008"
label var PRCCSR_GNR009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR009"
label var PRCCSR_GNR010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR010"
label var PRCCSR_HEP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP001"
label var PRCCSR_HEP002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP002"
label var PRCCSR_HEP003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP003"
label var PRCCSR_HEP004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP004"
label var PRCCSR_HEP005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP005"
label var PRCCSR_HEP006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP006"
label var PRCCSR_HEP007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP007"
label var PRCCSR_HEP008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP008"
label var PRCCSR_HEP009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP009"
label var PRCCSR_HEP010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP010"
label var PRCCSR_HEP011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP011"
label var PRCCSR_HEP012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP012"
label var PRCCSR_HEP013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP013"
label var PRCCSR_IMG001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG001"
label var PRCCSR_IMG002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG002"
label var PRCCSR_IMG003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG003"
label var PRCCSR_IMG004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG004"
label var PRCCSR_IMG005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG005"
label var PRCCSR_IMG006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG006"
label var PRCCSR_IMG007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG007"
label var PRCCSR_IMG008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG008"
label var PRCCSR_IMG009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG009"
label var PRCCSR_IMG010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG010"
label var PRCCSR_LYM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM001"
label var PRCCSR_LYM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM002"
label var PRCCSR_LYM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM003"
label var PRCCSR_LYM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM004"
label var PRCCSR_LYM005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM005"
label var PRCCSR_LYM006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM006"
label var PRCCSR_LYM007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM007"
label var PRCCSR_LYM008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM008"
label var PRCCSR_LYM009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM009"
label var PRCCSR_LYM010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM010"
label var PRCCSR_LYM011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM011"
label var PRCCSR_MAM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM001"
label var PRCCSR_MAM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM002"
label var PRCCSR_MAM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM003"
label var PRCCSR_MAM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM004"
label var PRCCSR_MAM005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM005"
label var PRCCSR_MAM006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM006"
label var PRCCSR_MAM007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM007"
label var PRCCSR_MAM008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM008"
label var PRCCSR_MAM009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM009"
label var PRCCSR_MAM010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM010"
label var PRCCSR_MAM011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM011"
label var PRCCSR_MAM012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM012"
label var PRCCSR_MAM013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM013"
label var PRCCSR_MAM014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM014"
label var PRCCSR_MAM015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM015"
label var PRCCSR_MHT001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT001"
label var PRCCSR_MHT002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT002"
label var PRCCSR_MHT003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT003"
label var PRCCSR_MHT004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT004"
label var PRCCSR_MHT005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT005"
label var PRCCSR_MRS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS001"
label var PRCCSR_MRS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS002"
label var PRCCSR_MRS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS003"
label var PRCCSR_MRS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS004"
label var PRCCSR_MRS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS005"
label var PRCCSR_MRS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS006"
label var PRCCSR_MRS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS007"
label var PRCCSR_MST001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST001"
label var PRCCSR_MST002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST002"
label var PRCCSR_MST003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST003"
label var PRCCSR_MST004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST004"
label var PRCCSR_MST005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST005"
label var PRCCSR_MST006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST006"
label var PRCCSR_MST007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST007"
label var PRCCSR_MST008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST008"
label var PRCCSR_MST009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST009"
label var PRCCSR_MST010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST010"
label var PRCCSR_MST011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST011"
label var PRCCSR_MST012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST012"
label var PRCCSR_MST013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST013"
label var PRCCSR_MST014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST014"
label var PRCCSR_MST015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST015"
label var PRCCSR_MST016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST016"
label var PRCCSR_MST017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST017"
label var PRCCSR_MST018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST018"
label var PRCCSR_MST019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST019"
label var PRCCSR_MST020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST020"
label var PRCCSR_MST021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST021"
label var PRCCSR_MST022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST022"
label var PRCCSR_MST023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST023"
label var PRCCSR_MST024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST024"
label var PRCCSR_MST025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST025"
label var PRCCSR_MST026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST026"
label var PRCCSR_MST027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST027"
label var PRCCSR_MST028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST028"
label var PRCCSR_MST029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST029"
label var PRCCSR_MST030            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST030"
label var PRCCSR_NCM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM001"
label var PRCCSR_NCM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM002"
label var PRCCSR_NCM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM003"
label var PRCCSR_NCM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM004"
label var PRCCSR_OST001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OST001"
label var PRCCSR_OTR001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR001"
label var PRCCSR_OTR002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR002"
label var PRCCSR_OTR003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR003"
label var PRCCSR_OTR004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR004"
label var PRCCSR_OTR005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR005"
label var PRCCSR_PGN001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN001"
label var PRCCSR_PGN002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN002"
label var PRCCSR_PGN003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN003"
label var PRCCSR_PGN004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN004"
label var PRCCSR_PGN005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN005"
label var PRCCSR_PGN006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN006"
label var PRCCSR_PGN007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN007"
label var PRCCSR_PGN008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN008"
label var PRCCSR_PGN009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN009"
label var PRCCSR_PLC001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC001"
label var PRCCSR_PLC002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC002"
label var PRCCSR_PNS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS001"
label var PRCCSR_PNS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS002"
label var PRCCSR_PNS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS003"
label var PRCCSR_PNS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS004"
label var PRCCSR_PNS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS005"
label var PRCCSR_PNS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS006"
label var PRCCSR_RAD001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD001"
label var PRCCSR_RAD002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD002"
label var PRCCSR_RAD003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD003"
label var PRCCSR_RAD004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD004"
label var PRCCSR_RES001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES001"
label var PRCCSR_RES002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES002"
label var PRCCSR_RES003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES003"
label var PRCCSR_RES004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES004"
label var PRCCSR_RES005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES005"
label var PRCCSR_RES006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES006"
label var PRCCSR_RES007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES007"
label var PRCCSR_RES008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES008"
label var PRCCSR_RES009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES009"
label var PRCCSR_RES010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES010"
label var PRCCSR_RES011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES011"
label var PRCCSR_RES012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES012"
label var PRCCSR_RES013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES013"
label var PRCCSR_RES014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES014"
label var PRCCSR_RHB001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB001"
label var PRCCSR_RHB002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB002"
label var PRCCSR_RHB003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB003"
label var PRCCSR_RHB004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB004"
label var PRCCSR_SKB001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB001"
label var PRCCSR_SKB002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB002"
label var PRCCSR_SKB003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB003"
label var PRCCSR_SKB004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB004"
label var PRCCSR_SKB005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB005"
label var PRCCSR_SKB006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB006"
label var PRCCSR_SKB007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB007"
label var PRCCSR_SKB008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB008"
label var PRCCSR_SKB009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB009"
label var PRCCSR_SKB010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB010"
label var PRCCSR_SUD001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD001"
label var PRCCSR_SUD002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD002"
label var PRCCSR_SUD003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD003"
label var PRCCSR_SUD004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD004"
label var PRCCSR_URN001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN001"
label var PRCCSR_URN002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN002"
label var PRCCSR_URN003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN003"
label var PRCCSR_URN004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN004"
label var PRCCSR_URN005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN005"
label var PRCCSR_URN006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN006"
label var PRCCSR_URN007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN007"
label var PRCCSR_URN008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN008"
label var PRCCSR_URN009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN009"
label var PRCCSR_URN010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN010"
label var PRCCSR_URN011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN011"
label var PRCCSR_URN012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN012"
label var PRCCSR_VERSION           "Version of CCSR for ICD-10-PCS procedures"

/*** Convert special values to missing values ***/
recode CCIR1                     (-99 -88 -66=.)
recode CCIR2                     (-99 -88 -66=.)
recode CCIR3                     (-99 -88 -66=.)
recode CCIR4                     (-99 -88 -66=.)
recode CCIR5                     (-99 -88 -66=.)
recode CCIR6                     (-99 -88 -66=.)
recode CCIR7                     (-99 -88 -66=.)
recode CCIR8                     (-99 -88 -66=.)
recode CCIR9                     (-99 -88 -66=.)
recode CCIR10                    (-99 -88 -66=.)
recode CCIR11                    (-99 -88 -66=.)
recode CCIR12                    (-99 -88 -66=.)
recode CCIR13                    (-99 -88 -66=.)
recode CCIR14                    (-99 -88 -66=.)
recode CCIR15                    (-99 -88 -66=.)
recode CCIR16                    (-99 -88 -66=.)
recode CCIR17                    (-99 -88 -66=.)
recode CCIR18                    (-99 -88 -66=.)
recode CCIR19                    (-99 -88 -66=.)
recode CCIR20                    (-99 -88 -66=.)
recode CCIR21                    (-99 -88 -66=.)
recode CCIR22                    (-99 -88 -66=.)
recode CCIR23                    (-99 -88 -66=.)
recode CCIR24                    (-99 -88 -66=.)
recode CCIR25                    (-99 -88 -66=.)
recode CCIR26                    (-99 -88 -66=.)
recode CCIR27                    (-99 -88 -66=.)
recode CCIR28                    (-99 -88 -66=.)
recode CCIR29                    (-99 -88 -66=.)
recode CCIR30                    (-99 -88 -66=.)
recode CCIR31                    (-99 -88 -66=.)
recode CCIR32                    (-99 -88 -66=.)
recode CCIR33                    (-99 -88 -66=.)
recode CCIR34                    (-99 -88 -66=.)
recode CCIR35                    (-99 -88 -66=.)
recode CCIR36                    (-99 -88 -66=.)
recode CCIR37                    (-99 -88 -66=.)
recode CCIR38                    (-99 -88 -66=.)
recode CCIR39                    (-99 -88 -66=.)
recode CCIR40                    (-99 -88 -66=.)
recode CCIR41                    (-99 -88 -66=.)
recode CCIR42                    (-99 -88 -66=.)
recode CCIR43                    (-99 -88 -66=.)
recode CCIR44                    (-99 -88 -66=.)
recode CCIR45                    (-99 -88 -66=.)
recode CCIR46                    (-99 -88 -66=.)
recode CCIR47                    (-99 -88 -66=.)
recode CCIR48                    (-99 -88 -66=.)
recode CCIR49                    (-99 -88 -66=.)
recode CCIR50                    (-99 -88 -66=.)
recode CCIR51                    (-99 -88 -66=.)
recode CCIR52                    (-99 -88 -66=.)
recode CCIR53                    (-99 -88 -66=.)
recode CCIR54                    (-99 -88 -66=.)
recode CCIR55                    (-99 -88 -66=.)
recode CCIR56                    (-99 -88 -66=.)
recode CCIR57                    (-99 -88 -66=.)
recode CCIR58                    (-99 -88 -66=.)
recode CCIR59                    (-99 -88 -66=.)
recode CCIR60                    (-99 -88 -66=.)
recode CCIR61                    (-99 -88 -66=.)
recode CCIR62                    (-99 -88 -66=.)
recode CCIR63                    (-99 -88 -66=.)
recode CCIR64                    (-99 -88 -66=.)
recode CCIR65                    (-99 -88 -66=.)
recode CCIR66                    (-99 -88 -66=.)
recode CCIR67                    (-99 -88 -66=.)
recode CCIR68                    (-99 -88 -66=.)
recode CCIR69                    (-99 -88 -66=.)
recode CCIR70                    (-99 -88 -66=.)
recode CCIR71                    (-99 -88 -66=.)
recode CCIR72                    (-99 -88 -66=.)
recode CCIR73                    (-99 -88 -66=.)
recode CCIR74                    (-99 -88 -66=.)
recode CCIR75                    (-99 -88 -66=.)
recode CCIR76                    (-99 -88 -66=.)
recode CCIR77                    (-99 -88 -66=.)
recode CCIR78                    (-99 -88 -66=.)
recode CCIR79                    (-99 -88 -66=.)
recode CCIR80                    (-99 -88 -66=.)
recode CCIR81                    (-99 -88 -66=.)
recode CCIR82                    (-99 -88 -66=.)
recode CCIR83                    (-99 -88 -66=.)
recode CCIR84                    (-99 -88 -66=.)
recode CCIR85                    (-99 -88 -66=.)
recode CCIR86                    (-99 -88 -66=.)
recode CCIR87                    (-99 -88 -66=.)
recode CCIR88                    (-99 -88 -66=.)
recode CCIR89                    (-99 -88 -66=.)
recode CCIR90                    (-99 -88 -66=.)
recode CCIR91                    (-99 -88 -66=.)
recode CCIR92                    (-99 -88 -66=.)
recode CCIR93                    (-99 -88 -66=.)
recode CCIR94                    (-99 -88 -66=.)
recode CCIR95                    (-99 -88 -66=.)
recode CCIR96                    (-99 -88 -66=.)
recode CCIR97                    (-99 -88 -66=.)
recode CCIR98                    (-99 -88 -66=.)
recode CCIR99                    (-99 -88 -66=.)
recode CCIR100                   (-99 -88 -66=.)
recode CCIR101                   (-99 -88 -66=.)
recode CCIR102                   (-99 -88 -66=.)
recode CCIR103                   (-99 -88 -66=.)
recode CCIR104                   (-99 -88 -66=.)
recode CCIR105                   (-99 -88 -66=.)
recode CCIR106                   (-99 -88 -66=.)
recode CCIR107                   (-99 -88 -66=.)
recode CCIR108                   (-99 -88 -66=.)
recode CCIR109                   (-99 -88 -66=.)
recode CCIR110                   (-99 -88 -66=.)
recode CCIR111                   (-99 -88 -66=.)
recode CCIR112                   (-99 -88 -66=.)
recode CCIR113                   (-99 -88 -66=.)
recode CCIR114                   (-99 -88 -66=.)
recode CCIR115                   (-99 -88 -66=.)
recode CCIR116                   (-99 -88 -66=.)
recode CCIR117                   (-99 -88 -66=.)
recode CCIR118                   (-99 -88 -66=.)
recode CCIR119                   (-99 -88 -66=.)
recode CCIR120                   (-99 -88 -66=.)
recode CCIR121                   (-99 -88 -66=.)
recode CCIR122                   (-99 -88 -66=.)
recode CCIR123                   (-99 -88 -66=.)
recode CCIR124                   (-99 -88 -66=.)
recode CCIR125                   (-99 -88 -66=.)
recode CCIR126                   (-99 -88 -66=.)
recode CCIR127                   (-99 -88 -66=.)
recode CCIR128                   (-99 -88 -66=.)
recode CCIR129                   (-99 -88 -66=.)
recode CCIR130                   (-99 -88 -66=.)
recode CCIR131                   (-99 -88 -66=.)
recode CCIR132                   (-99 -88 -66=.)
recode CCIR133                   (-99 -88 -66=.)
recode CCIR134                   (-99 -88 -66=.)
recode CCIR135                   (-99 -88 -66=.)
recode CCIR136                   (-99 -88 -66=.)
recode CMR_AIDS                  (-9 -8 -6 -5=.)
recode CMR_ALCOHOL               (-9 -8 -6 -5=.)
recode CMR_ANEMDEF               (-9 -8 -6 -5=.)
recode CMR_AUTOIMMUNE            (-9 -8 -6 -5=.)
recode CMR_BLDLOSS               (-9 -8 -6 -5=.)
recode CMR_CANCER_LEUK           (-9 -8 -6 -5=.)
recode CMR_CANCER_LYMPH          (-9 -8 -6 -5=.)
recode CMR_CANCER_METS           (-9 -8 -6 -5=.)
recode CMR_CANCER_NSITU          (-9 -8 -6 -5=.)
recode CMR_CANCER_SOLID          (-9 -8 -6 -5=.)
recode CMR_CBVD                  (-9 -8 -6 -5=.)
recode CMR_COAG                  (-9 -8 -6 -5=.)
recode CMR_DEMENTIA              (-9 -8 -6 -5=.)
recode CMR_DEPRESS               (-9 -8 -6 -5=.)
recode CMR_DIAB_CX               (-9 -8 -6 -5=.)
recode CMR_DIAB_UNCX             (-9 -8 -6 -5=.)
recode CMR_DRUG_ABUSE            (-9 -8 -6 -5=.)
recode CMR_HF                    (-9 -8 -6 -5=.)
recode CMR_HTN_CX                (-9 -8 -6 -5=.)
recode CMR_HTN_UNCX              (-9 -8 -6 -5=.)
recode CMR_LIVER_MLD             (-9 -8 -6 -5=.)
recode CMR_LIVER_SEV             (-9 -8 -6 -5=.)
recode CMR_LUNG_CHRONIC          (-9 -8 -6 -5=.)
recode CMR_NEURO_MOVT            (-9 -8 -6 -5=.)
recode CMR_NEURO_OTH             (-9 -8 -6 -5=.)
recode CMR_NEURO_SEIZ            (-9 -8 -6 -5=.)
recode CMR_OBESE                 (-9 -8 -6 -5=.)
recode CMR_PARALYSIS             (-9 -8 -6 -5=.)
recode CMR_PERIVASC              (-9 -8 -6 -5=.)
recode CMR_PSYCHOSES             (-9 -8 -6 -5=.)
recode CMR_PULMCIRC              (-9 -8 -6 -5=.)
recode CMR_RENLFL_MOD            (-9 -8 -6 -5=.)
recode CMR_RENLFL_SEV            (-9 -8 -6 -5=.)
recode CMR_THYROID_HYPO          (-9 -8 -6 -5=.)
recode CMR_THYROID_OTH           (-9 -8 -6 -5=.)
recode CMR_ULCER_PEPTIC          (-9 -8 -6 -5=.)
recode CMR_VALVE                 (-9 -8 -6 -5=.)
recode CMR_WGHTLOSS              (-9 -8 -6 -5=.)
recode I10_INJURY                (-9 -8 -6 -5=.)
recode I10_INJURY_CUT            (-9 -8 -6 -5=.)
recode I10_INJURY_DROWN          (-9 -8 -6 -5=.)
recode I10_INJURY_FALL           (-9 -8 -6 -5=.)
recode I10_INJURY_FIRE           (-9 -8 -6 -5=.)
recode I10_INJURY_FIREARM        (-9 -8 -6 -5=.)
recode I10_INJURY_MACHINERY      (-9 -8 -6 -5=.)
recode I10_INJURY_MVT            (-9 -8 -6 -5=.)
recode I10_INJURY_NATURE         (-9 -8 -6 -5=.)
recode I10_INJURY_OVEREXERTION   (-9 -8 -6 -5=.)
recode I10_INJURY_POISON         (-9 -8 -6 -5=.)
recode I10_INJURY_STRUCK         (-9 -8 -6 -5=.)
recode I10_INJURY_SUFFOCATION    (-9 -8 -6 -5=.)
recode I10_INTENT_ASSAULT        (-9 -8 -6 -5=.)
recode I10_INTENT_SELF_HARM      (-9 -8 -6 -5=.)
recode I10_INTENT_UNINTENTIONAL  (-9 -8 -6 -5=.)
recode I10_MULTINJURY            (-9 -8 -6 -5=.)
recode PCLASS1                   (-9 -8 -6 -5=.)
recode PCLASS2                   (-9 -8 -6 -5=.)
recode PCLASS3                   (-9 -8 -6 -5=.)
recode PCLASS4                   (-9 -8 -6 -5=.)
recode PCLASS5                   (-9 -8 -6 -5=.)
recode PCLASS6                   (-9 -8 -6 -5=.)
recode PCLASS7                   (-9 -8 -6 -5=.)
recode PCLASS8                   (-9 -8 -6 -5=.)
recode PCLASS9                   (-9 -8 -6 -5=.)
recode PCLASS10                  (-9 -8 -6 -5=.)
recode PCLASS11                  (-9 -8 -6 -5=.)
recode PCLASS12                  (-9 -8 -6 -5=.)
recode PCLASS13                  (-9 -8 -6 -5=.)
recode PCLASS14                  (-9 -8 -6 -5=.)
recode PCLASS15                  (-9 -8 -6 -5=.)
recode PCLASS16                  (-9 -8 -6 -5=.)
recode PCLASS17                  (-9 -8 -6 -5=.)
recode PCLASS18                  (-9 -8 -6 -5=.)
recode PCLASS19                  (-9 -8 -6 -5=.)
recode PCLASS20                  (-9 -8 -6 -5=.)
recode PCLASS21                  (-9 -8 -6 -5=.)
recode PCLASS22                  (-9 -8 -6 -5=.)
recode PCLASS23                  (-9 -8 -6 -5=.)
recode PCLASS24                  (-9 -8 -6 -5=.)
recode PCLASS25                  (-9 -8 -6 -5=.)
recode PCLASS26                  (-9 -8 -6 -5=.)
recode PCLASS27                  (-9 -8 -6 -5=.)
recode PCLASS28                  (-9 -8 -6 -5=.)
recode PCLASS29                  (-9 -8 -6 -5=.)
recode PCLASS30                  (-9 -8 -6 -5=.)
recode PCLASS31                  (-9 -8 -6 -5=.)
recode PCLASS32                  (-9 -8 -6 -5=.)
recode PCLASS33                  (-9 -8 -6 -5=.)
recode PCLASS34                  (-9 -8 -6 -5=.)
recode PCLASS35                  (-9 -8 -6 -5=.)
recode PCLASS36                  (-9 -8 -6 -5=.)
recode PCLASS37                  (-9 -8 -6 -5=.)
recode PCLASS38                  (-9 -8 -6 -5=.)
recode PCLASS39                  (-9 -8 -6 -5=.)
recode PCLASS40                  (-9 -8 -6 -5=.)
recode PCLASS41                  (-9 -8 -6 -5=.)
recode PCLASS42                  (-9 -8 -6 -5=.)
recode PCLASS43                  (-9 -8 -6 -5=.)
recode PCLASS44                  (-9 -8 -6 -5=.)
recode PCLASS45                  (-9 -8 -6 -5=.)
recode PCLASS46                  (-9 -8 -6 -5=.)
recode PCLASS47                  (-9 -8 -6 -5=.)
recode PCLASS48                  (-9 -8 -6 -5=.)
recode PCLASS49                  (-9 -8 -6 -5=.)
recode PCLASS50                  (-9 -8 -6 -5=.)
recode PCLASS51                  (-9 -8 -6 -5=.)
recode PCLASS52                  (-9 -8 -6 -5=.)
recode PCLASS53                  (-9 -8 -6 -5=.)
recode PCLASS54                  (-9 -8 -6 -5=.)
recode PCLASS55                  (-9 -8 -6 -5=.)
recode PCLASS56                  (-9 -8 -6 -5=.)
recode PCLASS57                  (-9 -8 -6 -5=.)
recode PCLASS58                  (-9 -8 -6 -5=.)
recode PCLASS59                  (-9 -8 -6 -5=.)
recode PCLASS60                  (-9 -8 -6 -5=.)
recode PCLASS61                  (-9 -8 -6 -5=.)
recode PCLASS62                  (-9 -8 -6 -5=.)
recode PCLASS63                  (-9 -8 -6 -5=.)
recode PCLASS64                  (-9 -8 -6 -5=.)
recode PCLASS65                  (-9 -8 -6 -5=.)
recode PCLASS66                  (-9 -8 -6 -5=.)
recode PCLASS67                  (-9 -8 -6 -5=.)
recode PCLASS68                  (-9 -8 -6 -5=.)
recode PCLASS69                  (-9 -8 -6 -5=.)
recode PCLASS70                  (-9 -8 -6 -5=.)
recode PCLASS71                  (-9 -8 -6 -5=.)
recode PCLASS72                  (-9 -8 -6 -5=.)
recode PCLASS73                  (-9 -8 -6 -5=.)
recode PCLASS74                  (-9 -8 -6 -5=.)
recode PCLASS75                  (-9 -8 -6 -5=.)
recode PCLASS76                  (-9 -8 -6 -5=.)
recode PCLASS77                  (-9 -8 -6 -5=.)
recode PCLASS78                  (-9 -8 -6 -5=.)
recode PCLASS79                  (-9 -8 -6 -5=.)
recode PCLASS80                  (-9 -8 -6 -5=.)
recode PCLASS81                  (-9 -8 -6 -5=.)
recode PCLASS82                  (-9 -8 -6 -5=.)
recode PCLASS83                  (-9 -8 -6 -5=.)
recode PCLASS84                  (-9 -8 -6 -5=.)
recode PCLASS85                  (-9 -8 -6 -5=.)
recode PCLASS86                  (-9 -8 -6 -5=.)
recode PCLASS87                  (-9 -8 -6 -5=.)
recode PCLASS88                  (-9 -8 -6 -5=.)
recode PCLASS89                  (-9 -8 -6 -5=.)
recode PCLASS90                  (-9 -8 -6 -5=.)
recode PCLASS91                  (-9 -8 -6 -5=.)
recode PCLASS92                  (-9 -8 -6 -5=.)
recode PCLASS93                  (-9 -8 -6 -5=.)
recode PCLASS94                  (-9 -8 -6 -5=.)
recode PCLASS95                  (-9 -8 -6 -5=.)
recode PCLASS96                  (-9 -8 -6 -5=.)
recode PCLASS97                  (-9 -8 -6 -5=.)
recode PCLASS98                  (-9 -8 -6 -5=.)
recode PCLASS99                  (-9 -8 -6 -5=.)
recode PCLASS100                 (-9 -8 -6 -5=.)
recode PCLASS101                 (-9 -8 -6 -5=.)
recode PCLASS102                 (-9 -8 -6 -5=.)
recode PCLASS103                 (-9 -8 -6 -5=.)
recode PCLASS104                 (-9 -8 -6 -5=.)
recode PCLASS105                 (-9 -8 -6 -5=.)
recode PCLASS106                 (-9 -8 -6 -5=.)
recode PCLASS107                 (-9 -8 -6 -5=.)
recode PCLASS108                 (-9 -8 -6 -5=.)
recode PCLASS109                 (-9 -8 -6 -5=.)
recode PCLASS110                 (-9 -8 -6 -5=.)
recode PCLASS111                 (-9 -8 -6 -5=.)
recode PCLASS112                 (-9 -8 -6 -5=.)
recode PCLASS113                 (-9 -8 -6 -5=.)
recode PCLASS114                 (-9 -8 -6 -5=.)
recode PCLASS115                 (-9 -8 -6 -5=.)
recode PCLASS116                 (-9 -8 -6 -5=.)
recode PCLASS117                 (-9 -8 -6 -5=.)
recode PCLASS118                 (-9 -8 -6 -5=.)
recode PCLASS119                 (-9 -8 -6 -5=.)
recode PCLASS120                 (-9 -8 -6 -5=.)
recode PCLASS121                 (-9 -8 -6 -5=.)
recode PCLASS122                 (-9 -8 -6 -5=.)
recode PCLASS123                 (-9 -8 -6 -5=.)
recode PCLASS124                 (-9 -8 -6 -5=.)
recode PCLASS125                 (-9 -8 -6 -5=.)
recode PCLASS126                 (-9 -8 -6 -5=.)
recode PCLASS127                 (-9 -8 -6 -5=.)
recode PCLASS128                 (-9 -8 -6 -5=.)
recode PCLASS129                 (-9 -8 -6 -5=.)
recode PCLASS130                 (-9 -8 -6 -5=.)
recode PCLASS131                 (-9 -8 -6 -5=.)
recode PCLASS132                 (-9 -8 -6 -5=.)
recode PCLASS133                 (-9 -8 -6 -5=.)
recode PCLASS134                 (-9 -8 -6 -5=.)
recode PCLASS135                 (-9 -8 -6 -5=.)
recode PCLASS136                 (-9 -8 -6 -5=.)
recode PCLASS137                 (-9 -8 -6 -5=.)
recode PCLASS138                 (-9 -8 -6 -5=.)
recode PCLASS139                 (-9 -8 -6 -5=.)
recode PCLASS140                 (-9 -8 -6 -5=.)
recode PCLASS141                 (-9 -8 -6 -5=.)
recode PCLASS142                 (-9 -8 -6 -5=.)
recode PCLASS143                 (-9 -8 -6 -5=.)
recode PCLASS144                 (-9 -8 -6 -5=.)
recode PCLASS145                 (-9 -8 -6 -5=.)
recode PCLASS146                 (-9 -8 -6 -5=.)
recode PCLASS147                 (-9 -8 -6 -5=.)
recode PCLASS148                 (-9 -8 -6 -5=.)
recode PCLASS149                 (-9 -8 -6 -5=.)
recode PCLASS150                 (-9 -8 -6 -5=.)
recode PCLASS151                 (-9 -8 -6 -5=.)
recode PCLASS152                 (-9 -8 -6 -5=.)
recode PCLASS153                 (-9 -8 -6 -5=.)
recode PCLASS154                 (-9 -8 -6 -5=.)
recode PCLASS155                 (-9 -8 -6 -5=.)
recode PCLASS156                 (-9 -8 -6 -5=.)
recode PCLASS157                 (-9 -8 -6 -5=.)
recode PCLASS158                 (-9 -8 -6 -5=.)
recode PCLASS159                 (-9 -8 -6 -5=.)
recode PCLASS160                 (-9 -8 -6 -5=.)
recode PCLASS161                 (-9 -8 -6 -5=.)
recode PCLASS162                 (-9 -8 -6 -5=.)
recode PCLASS163                 (-9 -8 -6 -5=.)
recode PCLASS164                 (-9 -8 -6 -5=.)
recode PCLASS165                 (-9 -8 -6 -5=.)
recode PCLASS166                 (-9 -8 -6 -5=.)
recode PCLASS167                 (-9 -8 -6 -5=.)
recode PCLASS168                 (-9 -8 -6 -5=.)
recode PCLASS169                 (-9 -8 -6 -5=.)
recode PCLASS170                 (-9 -8 -6 -5=.)
recode PCLASS171                 (-9 -8 -6 -5=.)
recode PCLASS172                 (-9 -8 -6 -5=.)
recode PCLASS173                 (-9 -8 -6 -5=.)
recode PCLASS174                 (-9 -8 -6 -5=.)
recode PCLASS175                 (-9 -8 -6 -5=.)
recode PCLASS176                 (-9 -8 -6 -5=.)
recode PCLASS177                 (-9 -8 -6 -5=.)
recode PCLASS178                 (-9 -8 -6 -5=.)
recode PCLASS179                 (-9 -8 -6 -5=.)
recode PCLASS180                 (-9 -8 -6 -5=.)
recode PCLASS181                 (-9 -8 -6 -5=.)
recode PCLASS182                 (-9 -8 -6 -5=.)
recode PCLASS183                 (-9 -8 -6 -5=.)
recode PCLASS184                 (-9 -8 -6 -5=.)
recode PCLASS185                 (-9 -8 -6 -5=.)
recode PCLASS186                 (-9 -8 -6 -5=.)
recode PCLASS187                 (-9 -8 -6 -5=.)
recode PCLASS188                 (-9 -8 -6 -5=.)
recode PCLASS189                 (-9 -8 -6 -5=.)
recode PCLASS190                 (-9 -8 -6 -5=.)
recode PCLASS191                 (-9 -8 -6 -5=.)
recode PCLASS192                 (-9 -8 -6 -5=.)
recode PCLASS193                 (-9 -8 -6 -5=.)
recode PCLASS194                 (-9 -8 -6 -5=.)
recode PCLASS195                 (-9 -8 -6 -5=.)
recode PCLASS196                 (-9 -8 -6 -5=.)
recode PCLASS197                 (-9 -8 -6 -5=.)
recode PCLASS198                 (-9 -8 -6 -5=.)
recode PCLASS199                 (-9 -8 -6 -5=.)
recode PCLASS200                 (-9 -8 -6 -5=.)
recode DXCCSR_BLD001             (-99 -88 -66=.)
recode DXCCSR_BLD002             (-99 -88 -66=.)
recode DXCCSR_BLD003             (-99 -88 -66=.)
recode DXCCSR_BLD004             (-99 -88 -66=.)
recode DXCCSR_BLD005             (-99 -88 -66=.)
recode DXCCSR_BLD006             (-99 -88 -66=.)
recode DXCCSR_BLD007             (-99 -88 -66=.)
recode DXCCSR_BLD008             (-99 -88 -66=.)
recode DXCCSR_BLD009             (-99 -88 -66=.)
recode DXCCSR_BLD010             (-99 -88 -66=.)
recode DXCCSR_CIR001             (-99 -88 -66=.)
recode DXCCSR_CIR002             (-99 -88 -66=.)
recode DXCCSR_CIR003             (-99 -88 -66=.)
recode DXCCSR_CIR004             (-99 -88 -66=.)
recode DXCCSR_CIR005             (-99 -88 -66=.)
recode DXCCSR_CIR006             (-99 -88 -66=.)
recode DXCCSR_CIR007             (-99 -88 -66=.)
recode DXCCSR_CIR008             (-99 -88 -66=.)
recode DXCCSR_CIR009             (-99 -88 -66=.)
recode DXCCSR_CIR010             (-99 -88 -66=.)
recode DXCCSR_CIR011             (-99 -88 -66=.)
recode DXCCSR_CIR012             (-99 -88 -66=.)
recode DXCCSR_CIR013             (-99 -88 -66=.)
recode DXCCSR_CIR014             (-99 -88 -66=.)
recode DXCCSR_CIR015             (-99 -88 -66=.)
recode DXCCSR_CIR016             (-99 -88 -66=.)
recode DXCCSR_CIR017             (-99 -88 -66=.)
recode DXCCSR_CIR018             (-99 -88 -66=.)
recode DXCCSR_CIR019             (-99 -88 -66=.)
recode DXCCSR_CIR020             (-99 -88 -66=.)
recode DXCCSR_CIR021             (-99 -88 -66=.)
recode DXCCSR_CIR022             (-99 -88 -66=.)
recode DXCCSR_CIR023             (-99 -88 -66=.)
recode DXCCSR_CIR024             (-99 -88 -66=.)
recode DXCCSR_CIR025             (-99 -88 -66=.)
recode DXCCSR_CIR026             (-99 -88 -66=.)
recode DXCCSR_CIR027             (-99 -88 -66=.)
recode DXCCSR_CIR028             (-99 -88 -66=.)
recode DXCCSR_CIR029             (-99 -88 -66=.)
recode DXCCSR_CIR030             (-99 -88 -66=.)
recode DXCCSR_CIR031             (-99 -88 -66=.)
recode DXCCSR_CIR032             (-99 -88 -66=.)
recode DXCCSR_CIR033             (-99 -88 -66=.)
recode DXCCSR_CIR034             (-99 -88 -66=.)
recode DXCCSR_CIR035             (-99 -88 -66=.)
recode DXCCSR_CIR036             (-99 -88 -66=.)
recode DXCCSR_CIR037             (-99 -88 -66=.)
recode DXCCSR_CIR038             (-99 -88 -66=.)
recode DXCCSR_CIR039             (-99 -88 -66=.)
recode DXCCSR_DEN001             (-99 -88 -66=.)
recode DXCCSR_DEN002             (-99 -88 -66=.)
recode DXCCSR_DEN003             (-99 -88 -66=.)
recode DXCCSR_DIG001             (-99 -88 -66=.)
recode DXCCSR_DIG002             (-99 -88 -66=.)
recode DXCCSR_DIG003             (-99 -88 -66=.)
recode DXCCSR_DIG004             (-99 -88 -66=.)
recode DXCCSR_DIG005             (-99 -88 -66=.)
recode DXCCSR_DIG006             (-99 -88 -66=.)
recode DXCCSR_DIG007             (-99 -88 -66=.)
recode DXCCSR_DIG008             (-99 -88 -66=.)
recode DXCCSR_DIG009             (-99 -88 -66=.)
recode DXCCSR_DIG010             (-99 -88 -66=.)
recode DXCCSR_DIG011             (-99 -88 -66=.)
recode DXCCSR_DIG012             (-99 -88 -66=.)
recode DXCCSR_DIG013             (-99 -88 -66=.)
recode DXCCSR_DIG014             (-99 -88 -66=.)
recode DXCCSR_DIG015             (-99 -88 -66=.)
recode DXCCSR_DIG016             (-99 -88 -66=.)
recode DXCCSR_DIG017             (-99 -88 -66=.)
recode DXCCSR_DIG018             (-99 -88 -66=.)
recode DXCCSR_DIG019             (-99 -88 -66=.)
recode DXCCSR_DIG020             (-99 -88 -66=.)
recode DXCCSR_DIG021             (-99 -88 -66=.)
recode DXCCSR_DIG022             (-99 -88 -66=.)
recode DXCCSR_DIG023             (-99 -88 -66=.)
recode DXCCSR_DIG024             (-99 -88 -66=.)
recode DXCCSR_DIG025             (-99 -88 -66=.)
recode DXCCSR_EAR001             (-99 -88 -66=.)
recode DXCCSR_EAR002             (-99 -88 -66=.)
recode DXCCSR_EAR003             (-99 -88 -66=.)
recode DXCCSR_EAR004             (-99 -88 -66=.)
recode DXCCSR_EAR005             (-99 -88 -66=.)
recode DXCCSR_EAR006             (-99 -88 -66=.)
recode DXCCSR_END001             (-99 -88 -66=.)
recode DXCCSR_END002             (-99 -88 -66=.)
recode DXCCSR_END003             (-99 -88 -66=.)
recode DXCCSR_END004             (-99 -88 -66=.)
recode DXCCSR_END005             (-99 -88 -66=.)
recode DXCCSR_END006             (-99 -88 -66=.)
recode DXCCSR_END007             (-99 -88 -66=.)
recode DXCCSR_END008             (-99 -88 -66=.)
recode DXCCSR_END009             (-99 -88 -66=.)
recode DXCCSR_END010             (-99 -88 -66=.)
recode DXCCSR_END011             (-99 -88 -66=.)
recode DXCCSR_END012             (-99 -88 -66=.)
recode DXCCSR_END013             (-99 -88 -66=.)
recode DXCCSR_END014             (-99 -88 -66=.)
recode DXCCSR_END015             (-99 -88 -66=.)
recode DXCCSR_END016             (-99 -88 -66=.)
recode DXCCSR_END017             (-99 -88 -66=.)
recode DXCCSR_EXT001             (-99 -88 -66=.)
recode DXCCSR_EXT002             (-99 -88 -66=.)
recode DXCCSR_EXT003             (-99 -88 -66=.)
recode DXCCSR_EXT004             (-99 -88 -66=.)
recode DXCCSR_EXT005             (-99 -88 -66=.)
recode DXCCSR_EXT006             (-99 -88 -66=.)
recode DXCCSR_EXT007             (-99 -88 -66=.)
recode DXCCSR_EXT008             (-99 -88 -66=.)
recode DXCCSR_EXT009             (-99 -88 -66=.)
recode DXCCSR_EXT010             (-99 -88 -66=.)
recode DXCCSR_EXT011             (-99 -88 -66=.)
recode DXCCSR_EXT012             (-99 -88 -66=.)
recode DXCCSR_EXT013             (-99 -88 -66=.)
recode DXCCSR_EXT014             (-99 -88 -66=.)
recode DXCCSR_EXT015             (-99 -88 -66=.)
recode DXCCSR_EXT016             (-99 -88 -66=.)
recode DXCCSR_EXT017             (-99 -88 -66=.)
recode DXCCSR_EXT018             (-99 -88 -66=.)
recode DXCCSR_EXT019             (-99 -88 -66=.)
recode DXCCSR_EXT020             (-99 -88 -66=.)
recode DXCCSR_EXT021             (-99 -88 -66=.)
recode DXCCSR_EXT022             (-99 -88 -66=.)
recode DXCCSR_EXT023             (-99 -88 -66=.)
recode DXCCSR_EXT024             (-99 -88 -66=.)
recode DXCCSR_EXT025             (-99 -88 -66=.)
recode DXCCSR_EXT026             (-99 -88 -66=.)
recode DXCCSR_EXT027             (-99 -88 -66=.)
recode DXCCSR_EXT028             (-99 -88 -66=.)
recode DXCCSR_EXT029             (-99 -88 -66=.)
recode DXCCSR_EXT030             (-99 -88 -66=.)
recode DXCCSR_EYE001             (-99 -88 -66=.)
recode DXCCSR_EYE002             (-99 -88 -66=.)
recode DXCCSR_EYE003             (-99 -88 -66=.)
recode DXCCSR_EYE004             (-99 -88 -66=.)
recode DXCCSR_EYE005             (-99 -88 -66=.)
recode DXCCSR_EYE006             (-99 -88 -66=.)
recode DXCCSR_EYE007             (-99 -88 -66=.)
recode DXCCSR_EYE008             (-99 -88 -66=.)
recode DXCCSR_EYE009             (-99 -88 -66=.)
recode DXCCSR_EYE010             (-99 -88 -66=.)
recode DXCCSR_EYE011             (-99 -88 -66=.)
recode DXCCSR_EYE012             (-99 -88 -66=.)
recode DXCCSR_FAC001             (-99 -88 -66=.)
recode DXCCSR_FAC002             (-99 -88 -66=.)
recode DXCCSR_FAC003             (-99 -88 -66=.)
recode DXCCSR_FAC004             (-99 -88 -66=.)
recode DXCCSR_FAC005             (-99 -88 -66=.)
recode DXCCSR_FAC006             (-99 -88 -66=.)
recode DXCCSR_FAC007             (-99 -88 -66=.)
recode DXCCSR_FAC008             (-99 -88 -66=.)
recode DXCCSR_FAC009             (-99 -88 -66=.)
recode DXCCSR_FAC010             (-99 -88 -66=.)
recode DXCCSR_FAC011             (-99 -88 -66=.)
recode DXCCSR_FAC012             (-99 -88 -66=.)
recode DXCCSR_FAC013             (-99 -88 -66=.)
recode DXCCSR_FAC014             (-99 -88 -66=.)
recode DXCCSR_FAC015             (-99 -88 -66=.)
recode DXCCSR_FAC016             (-99 -88 -66=.)
recode DXCCSR_FAC017             (-99 -88 -66=.)
recode DXCCSR_FAC018             (-99 -88 -66=.)
recode DXCCSR_FAC019             (-99 -88 -66=.)
recode DXCCSR_FAC020             (-99 -88 -66=.)
recode DXCCSR_FAC021             (-99 -88 -66=.)
recode DXCCSR_FAC022             (-99 -88 -66=.)
recode DXCCSR_FAC023             (-99 -88 -66=.)
recode DXCCSR_FAC024             (-99 -88 -66=.)
recode DXCCSR_FAC025             (-99 -88 -66=.)
recode DXCCSR_GEN001             (-99 -88 -66=.)
recode DXCCSR_GEN002             (-99 -88 -66=.)
recode DXCCSR_GEN003             (-99 -88 -66=.)
recode DXCCSR_GEN004             (-99 -88 -66=.)
recode DXCCSR_GEN005             (-99 -88 -66=.)
recode DXCCSR_GEN006             (-99 -88 -66=.)
recode DXCCSR_GEN007             (-99 -88 -66=.)
recode DXCCSR_GEN008             (-99 -88 -66=.)
recode DXCCSR_GEN009             (-99 -88 -66=.)
recode DXCCSR_GEN010             (-99 -88 -66=.)
recode DXCCSR_GEN011             (-99 -88 -66=.)
recode DXCCSR_GEN012             (-99 -88 -66=.)
recode DXCCSR_GEN013             (-99 -88 -66=.)
recode DXCCSR_GEN014             (-99 -88 -66=.)
recode DXCCSR_GEN015             (-99 -88 -66=.)
recode DXCCSR_GEN016             (-99 -88 -66=.)
recode DXCCSR_GEN017             (-99 -88 -66=.)
recode DXCCSR_GEN018             (-99 -88 -66=.)
recode DXCCSR_GEN019             (-99 -88 -66=.)
recode DXCCSR_GEN020             (-99 -88 -66=.)
recode DXCCSR_GEN021             (-99 -88 -66=.)
recode DXCCSR_GEN022             (-99 -88 -66=.)
recode DXCCSR_GEN023             (-99 -88 -66=.)
recode DXCCSR_GEN024             (-99 -88 -66=.)
recode DXCCSR_GEN025             (-99 -88 -66=.)
recode DXCCSR_GEN026             (-99 -88 -66=.)
recode DXCCSR_INF001             (-99 -88 -66=.)
recode DXCCSR_INF002             (-99 -88 -66=.)
recode DXCCSR_INF003             (-99 -88 -66=.)
recode DXCCSR_INF004             (-99 -88 -66=.)
recode DXCCSR_INF005             (-99 -88 -66=.)
recode DXCCSR_INF006             (-99 -88 -66=.)
recode DXCCSR_INF007             (-99 -88 -66=.)
recode DXCCSR_INF008             (-99 -88 -66=.)
recode DXCCSR_INF009             (-99 -88 -66=.)
recode DXCCSR_INF010             (-99 -88 -66=.)
recode DXCCSR_INF011             (-99 -88 -66=.)
recode DXCCSR_INF012             (-99 -88 -66=.)
recode DXCCSR_INJ001             (-99 -88 -66=.)
recode DXCCSR_INJ002             (-99 -88 -66=.)
recode DXCCSR_INJ003             (-99 -88 -66=.)
recode DXCCSR_INJ004             (-99 -88 -66=.)
recode DXCCSR_INJ005             (-99 -88 -66=.)
recode DXCCSR_INJ006             (-99 -88 -66=.)
recode DXCCSR_INJ007             (-99 -88 -66=.)
recode DXCCSR_INJ008             (-99 -88 -66=.)
recode DXCCSR_INJ009             (-99 -88 -66=.)
recode DXCCSR_INJ010             (-99 -88 -66=.)
recode DXCCSR_INJ011             (-99 -88 -66=.)
recode DXCCSR_INJ012             (-99 -88 -66=.)
recode DXCCSR_INJ013             (-99 -88 -66=.)
recode DXCCSR_INJ014             (-99 -88 -66=.)
recode DXCCSR_INJ015             (-99 -88 -66=.)
recode DXCCSR_INJ016             (-99 -88 -66=.)
recode DXCCSR_INJ017             (-99 -88 -66=.)
recode DXCCSR_INJ018             (-99 -88 -66=.)
recode DXCCSR_INJ019             (-99 -88 -66=.)
recode DXCCSR_INJ020             (-99 -88 -66=.)
recode DXCCSR_INJ021             (-99 -88 -66=.)
recode DXCCSR_INJ022             (-99 -88 -66=.)
recode DXCCSR_INJ023             (-99 -88 -66=.)
recode DXCCSR_INJ024             (-99 -88 -66=.)
recode DXCCSR_INJ025             (-99 -88 -66=.)
recode DXCCSR_INJ026             (-99 -88 -66=.)
recode DXCCSR_INJ027             (-99 -88 -66=.)
recode DXCCSR_INJ028             (-99 -88 -66=.)
recode DXCCSR_INJ029             (-99 -88 -66=.)
recode DXCCSR_INJ030             (-99 -88 -66=.)
recode DXCCSR_INJ031             (-99 -88 -66=.)
recode DXCCSR_INJ032             (-99 -88 -66=.)
recode DXCCSR_INJ033             (-99 -88 -66=.)
recode DXCCSR_INJ034             (-99 -88 -66=.)
recode DXCCSR_INJ035             (-99 -88 -66=.)
recode DXCCSR_INJ036             (-99 -88 -66=.)
recode DXCCSR_INJ037             (-99 -88 -66=.)
recode DXCCSR_INJ038             (-99 -88 -66=.)
recode DXCCSR_INJ039             (-99 -88 -66=.)
recode DXCCSR_INJ040             (-99 -88 -66=.)
recode DXCCSR_INJ041             (-99 -88 -66=.)
recode DXCCSR_INJ042             (-99 -88 -66=.)
recode DXCCSR_INJ043             (-99 -88 -66=.)
recode DXCCSR_INJ044             (-99 -88 -66=.)
recode DXCCSR_INJ045             (-99 -88 -66=.)
recode DXCCSR_INJ046             (-99 -88 -66=.)
recode DXCCSR_INJ047             (-99 -88 -66=.)
recode DXCCSR_INJ048             (-99 -88 -66=.)
recode DXCCSR_INJ049             (-99 -88 -66=.)
recode DXCCSR_INJ050             (-99 -88 -66=.)
recode DXCCSR_INJ051             (-99 -88 -66=.)
recode DXCCSR_INJ052             (-99 -88 -66=.)
recode DXCCSR_INJ053             (-99 -88 -66=.)
recode DXCCSR_INJ054             (-99 -88 -66=.)
recode DXCCSR_INJ055             (-99 -88 -66=.)
recode DXCCSR_INJ056             (-99 -88 -66=.)
recode DXCCSR_INJ057             (-99 -88 -66=.)
recode DXCCSR_INJ058             (-99 -88 -66=.)
recode DXCCSR_INJ059             (-99 -88 -66=.)
recode DXCCSR_INJ060             (-99 -88 -66=.)
recode DXCCSR_INJ061             (-99 -88 -66=.)
recode DXCCSR_INJ062             (-99 -88 -66=.)
recode DXCCSR_INJ063             (-99 -88 -66=.)
recode DXCCSR_INJ064             (-99 -88 -66=.)
recode DXCCSR_INJ065             (-99 -88 -66=.)
recode DXCCSR_INJ066             (-99 -88 -66=.)
recode DXCCSR_INJ067             (-99 -88 -66=.)
recode DXCCSR_INJ068             (-99 -88 -66=.)
recode DXCCSR_INJ069             (-99 -88 -66=.)
recode DXCCSR_INJ070             (-99 -88 -66=.)
recode DXCCSR_INJ071             (-99 -88 -66=.)
recode DXCCSR_INJ072             (-99 -88 -66=.)
recode DXCCSR_INJ073             (-99 -88 -66=.)
recode DXCCSR_INJ074             (-99 -88 -66=.)
recode DXCCSR_INJ075             (-99 -88 -66=.)
recode DXCCSR_INJ076             (-99 -88 -66=.)
recode DXCCSR_MAL001             (-99 -88 -66=.)
recode DXCCSR_MAL002             (-99 -88 -66=.)
recode DXCCSR_MAL003             (-99 -88 -66=.)
recode DXCCSR_MAL004             (-99 -88 -66=.)
recode DXCCSR_MAL005             (-99 -88 -66=.)
recode DXCCSR_MAL006             (-99 -88 -66=.)
recode DXCCSR_MAL007             (-99 -88 -66=.)
recode DXCCSR_MAL008             (-99 -88 -66=.)
recode DXCCSR_MAL009             (-99 -88 -66=.)
recode DXCCSR_MAL010             (-99 -88 -66=.)
recode DXCCSR_MBD001             (-99 -88 -66=.)
recode DXCCSR_MBD002             (-99 -88 -66=.)
recode DXCCSR_MBD003             (-99 -88 -66=.)
recode DXCCSR_MBD004             (-99 -88 -66=.)
recode DXCCSR_MBD005             (-99 -88 -66=.)
recode DXCCSR_MBD006             (-99 -88 -66=.)
recode DXCCSR_MBD007             (-99 -88 -66=.)
recode DXCCSR_MBD008             (-99 -88 -66=.)
recode DXCCSR_MBD009             (-99 -88 -66=.)
recode DXCCSR_MBD010             (-99 -88 -66=.)
recode DXCCSR_MBD011             (-99 -88 -66=.)
recode DXCCSR_MBD012             (-99 -88 -66=.)
recode DXCCSR_MBD013             (-99 -88 -66=.)
recode DXCCSR_MBD014             (-99 -88 -66=.)
recode DXCCSR_MBD017             (-99 -88 -66=.)
recode DXCCSR_MBD018             (-99 -88 -66=.)
recode DXCCSR_MBD019             (-99 -88 -66=.)
recode DXCCSR_MBD020             (-99 -88 -66=.)
recode DXCCSR_MBD021             (-99 -88 -66=.)
recode DXCCSR_MBD022             (-99 -88 -66=.)
recode DXCCSR_MBD023             (-99 -88 -66=.)
recode DXCCSR_MBD024             (-99 -88 -66=.)
recode DXCCSR_MBD025             (-99 -88 -66=.)
recode DXCCSR_MBD026             (-99 -88 -66=.)
recode DXCCSR_MBD027             (-99 -88 -66=.)
recode DXCCSR_MBD028             (-99 -88 -66=.)
recode DXCCSR_MBD029             (-99 -88 -66=.)
recode DXCCSR_MBD030             (-99 -88 -66=.)
recode DXCCSR_MBD031             (-99 -88 -66=.)
recode DXCCSR_MBD032             (-99 -88 -66=.)
recode DXCCSR_MBD033             (-99 -88 -66=.)
recode DXCCSR_MBD034             (-99 -88 -66=.)
recode DXCCSR_MUS001             (-99 -88 -66=.)
recode DXCCSR_MUS002             (-99 -88 -66=.)
recode DXCCSR_MUS003             (-99 -88 -66=.)
recode DXCCSR_MUS004             (-99 -88 -66=.)
recode DXCCSR_MUS005             (-99 -88 -66=.)
recode DXCCSR_MUS006             (-99 -88 -66=.)
recode DXCCSR_MUS007             (-99 -88 -66=.)
recode DXCCSR_MUS008             (-99 -88 -66=.)
recode DXCCSR_MUS009             (-99 -88 -66=.)
recode DXCCSR_MUS010             (-99 -88 -66=.)
recode DXCCSR_MUS011             (-99 -88 -66=.)
recode DXCCSR_MUS012             (-99 -88 -66=.)
recode DXCCSR_MUS013             (-99 -88 -66=.)
recode DXCCSR_MUS014             (-99 -88 -66=.)
recode DXCCSR_MUS015             (-99 -88 -66=.)
recode DXCCSR_MUS016             (-99 -88 -66=.)
recode DXCCSR_MUS017             (-99 -88 -66=.)
recode DXCCSR_MUS018             (-99 -88 -66=.)
recode DXCCSR_MUS019             (-99 -88 -66=.)
recode DXCCSR_MUS020             (-99 -88 -66=.)
recode DXCCSR_MUS021             (-99 -88 -66=.)
recode DXCCSR_MUS022             (-99 -88 -66=.)
recode DXCCSR_MUS023             (-99 -88 -66=.)
recode DXCCSR_MUS024             (-99 -88 -66=.)
recode DXCCSR_MUS025             (-99 -88 -66=.)
recode DXCCSR_MUS026             (-99 -88 -66=.)
recode DXCCSR_MUS027             (-99 -88 -66=.)
recode DXCCSR_MUS028             (-99 -88 -66=.)
recode DXCCSR_MUS029             (-99 -88 -66=.)
recode DXCCSR_MUS030             (-99 -88 -66=.)
recode DXCCSR_MUS031             (-99 -88 -66=.)
recode DXCCSR_MUS032             (-99 -88 -66=.)
recode DXCCSR_MUS033             (-99 -88 -66=.)
recode DXCCSR_MUS034             (-99 -88 -66=.)
recode DXCCSR_MUS035             (-99 -88 -66=.)
recode DXCCSR_MUS036             (-99 -88 -66=.)
recode DXCCSR_MUS037             (-99 -88 -66=.)
recode DXCCSR_MUS038             (-99 -88 -66=.)
recode DXCCSR_NEO001             (-99 -88 -66=.)
recode DXCCSR_NEO002             (-99 -88 -66=.)
recode DXCCSR_NEO003             (-99 -88 -66=.)
recode DXCCSR_NEO004             (-99 -88 -66=.)
recode DXCCSR_NEO005             (-99 -88 -66=.)
recode DXCCSR_NEO006             (-99 -88 -66=.)
recode DXCCSR_NEO007             (-99 -88 -66=.)
recode DXCCSR_NEO008             (-99 -88 -66=.)
recode DXCCSR_NEO009             (-99 -88 -66=.)
recode DXCCSR_NEO010             (-99 -88 -66=.)
recode DXCCSR_NEO011             (-99 -88 -66=.)
recode DXCCSR_NEO012             (-99 -88 -66=.)
recode DXCCSR_NEO013             (-99 -88 -66=.)
recode DXCCSR_NEO014             (-99 -88 -66=.)
recode DXCCSR_NEO015             (-99 -88 -66=.)
recode DXCCSR_NEO016             (-99 -88 -66=.)
recode DXCCSR_NEO017             (-99 -88 -66=.)
recode DXCCSR_NEO018             (-99 -88 -66=.)
recode DXCCSR_NEO019             (-99 -88 -66=.)
recode DXCCSR_NEO020             (-99 -88 -66=.)
recode DXCCSR_NEO021             (-99 -88 -66=.)
recode DXCCSR_NEO022             (-99 -88 -66=.)
recode DXCCSR_NEO023             (-99 -88 -66=.)
recode DXCCSR_NEO024             (-99 -88 -66=.)
recode DXCCSR_NEO025             (-99 -88 -66=.)
recode DXCCSR_NEO026             (-99 -88 -66=.)
recode DXCCSR_NEO027             (-99 -88 -66=.)
recode DXCCSR_NEO028             (-99 -88 -66=.)
recode DXCCSR_NEO029             (-99 -88 -66=.)
recode DXCCSR_NEO030             (-99 -88 -66=.)
recode DXCCSR_NEO031             (-99 -88 -66=.)
recode DXCCSR_NEO032             (-99 -88 -66=.)
recode DXCCSR_NEO033             (-99 -88 -66=.)
recode DXCCSR_NEO034             (-99 -88 -66=.)
recode DXCCSR_NEO035             (-99 -88 -66=.)
recode DXCCSR_NEO036             (-99 -88 -66=.)
recode DXCCSR_NEO037             (-99 -88 -66=.)
recode DXCCSR_NEO038             (-99 -88 -66=.)
recode DXCCSR_NEO039             (-99 -88 -66=.)
recode DXCCSR_NEO040             (-99 -88 -66=.)
recode DXCCSR_NEO041             (-99 -88 -66=.)
recode DXCCSR_NEO042             (-99 -88 -66=.)
recode DXCCSR_NEO043             (-99 -88 -66=.)
recode DXCCSR_NEO044             (-99 -88 -66=.)
recode DXCCSR_NEO045             (-99 -88 -66=.)
recode DXCCSR_NEO046             (-99 -88 -66=.)
recode DXCCSR_NEO047             (-99 -88 -66=.)
recode DXCCSR_NEO048             (-99 -88 -66=.)
recode DXCCSR_NEO049             (-99 -88 -66=.)
recode DXCCSR_NEO050             (-99 -88 -66=.)
recode DXCCSR_NEO051             (-99 -88 -66=.)
recode DXCCSR_NEO052             (-99 -88 -66=.)
recode DXCCSR_NEO053             (-99 -88 -66=.)
recode DXCCSR_NEO054             (-99 -88 -66=.)
recode DXCCSR_NEO055             (-99 -88 -66=.)
recode DXCCSR_NEO056             (-99 -88 -66=.)
recode DXCCSR_NEO057             (-99 -88 -66=.)
recode DXCCSR_NEO058             (-99 -88 -66=.)
recode DXCCSR_NEO059             (-99 -88 -66=.)
recode DXCCSR_NEO060             (-99 -88 -66=.)
recode DXCCSR_NEO061             (-99 -88 -66=.)
recode DXCCSR_NEO062             (-99 -88 -66=.)
recode DXCCSR_NEO063             (-99 -88 -66=.)
recode DXCCSR_NEO064             (-99 -88 -66=.)
recode DXCCSR_NEO065             (-99 -88 -66=.)
recode DXCCSR_NEO066             (-99 -88 -66=.)
recode DXCCSR_NEO067             (-99 -88 -66=.)
recode DXCCSR_NEO068             (-99 -88 -66=.)
recode DXCCSR_NEO069             (-99 -88 -66=.)
recode DXCCSR_NEO070             (-99 -88 -66=.)
recode DXCCSR_NEO071             (-99 -88 -66=.)
recode DXCCSR_NEO072             (-99 -88 -66=.)
recode DXCCSR_NEO073             (-99 -88 -66=.)
recode DXCCSR_NEO074             (-99 -88 -66=.)
recode DXCCSR_NVS001             (-99 -88 -66=.)
recode DXCCSR_NVS002             (-99 -88 -66=.)
recode DXCCSR_NVS003             (-99 -88 -66=.)
recode DXCCSR_NVS004             (-99 -88 -66=.)
recode DXCCSR_NVS005             (-99 -88 -66=.)
recode DXCCSR_NVS006             (-99 -88 -66=.)
recode DXCCSR_NVS007             (-99 -88 -66=.)
recode DXCCSR_NVS008             (-99 -88 -66=.)
recode DXCCSR_NVS009             (-99 -88 -66=.)
recode DXCCSR_NVS010             (-99 -88 -66=.)
recode DXCCSR_NVS011             (-99 -88 -66=.)
recode DXCCSR_NVS012             (-99 -88 -66=.)
recode DXCCSR_NVS013             (-99 -88 -66=.)
recode DXCCSR_NVS014             (-99 -88 -66=.)
recode DXCCSR_NVS015             (-99 -88 -66=.)
recode DXCCSR_NVS016             (-99 -88 -66=.)
recode DXCCSR_NVS017             (-99 -88 -66=.)
recode DXCCSR_NVS018             (-99 -88 -66=.)
recode DXCCSR_NVS019             (-99 -88 -66=.)
recode DXCCSR_NVS020             (-99 -88 -66=.)
recode DXCCSR_NVS021             (-99 -88 -66=.)
recode DXCCSR_NVS022             (-99 -88 -66=.)
recode DXCCSR_PNL001             (-99 -88 -66=.)
recode DXCCSR_PNL002             (-99 -88 -66=.)
recode DXCCSR_PNL003             (-99 -88 -66=.)
recode DXCCSR_PNL004             (-99 -88 -66=.)
recode DXCCSR_PNL005             (-99 -88 -66=.)
recode DXCCSR_PNL006             (-99 -88 -66=.)
recode DXCCSR_PNL007             (-99 -88 -66=.)
recode DXCCSR_PNL008             (-99 -88 -66=.)
recode DXCCSR_PNL009             (-99 -88 -66=.)
recode DXCCSR_PNL010             (-99 -88 -66=.)
recode DXCCSR_PNL011             (-99 -88 -66=.)
recode DXCCSR_PNL012             (-99 -88 -66=.)
recode DXCCSR_PNL013             (-99 -88 -66=.)
recode DXCCSR_PNL014             (-99 -88 -66=.)
recode DXCCSR_PNL015             (-99 -88 -66=.)
recode DXCCSR_PRG001             (-99 -88 -66=.)
recode DXCCSR_PRG002             (-99 -88 -66=.)
recode DXCCSR_PRG003             (-99 -88 -66=.)
recode DXCCSR_PRG004             (-99 -88 -66=.)
recode DXCCSR_PRG005             (-99 -88 -66=.)
recode DXCCSR_PRG006             (-99 -88 -66=.)
recode DXCCSR_PRG007             (-99 -88 -66=.)
recode DXCCSR_PRG008             (-99 -88 -66=.)
recode DXCCSR_PRG009             (-99 -88 -66=.)
recode DXCCSR_PRG010             (-99 -88 -66=.)
recode DXCCSR_PRG011             (-99 -88 -66=.)
recode DXCCSR_PRG012             (-99 -88 -66=.)
recode DXCCSR_PRG013             (-99 -88 -66=.)
recode DXCCSR_PRG014             (-99 -88 -66=.)
recode DXCCSR_PRG015             (-99 -88 -66=.)
recode DXCCSR_PRG016             (-99 -88 -66=.)
recode DXCCSR_PRG017             (-99 -88 -66=.)
recode DXCCSR_PRG018             (-99 -88 -66=.)
recode DXCCSR_PRG019             (-99 -88 -66=.)
recode DXCCSR_PRG020             (-99 -88 -66=.)
recode DXCCSR_PRG021             (-99 -88 -66=.)
recode DXCCSR_PRG022             (-99 -88 -66=.)
recode DXCCSR_PRG023             (-99 -88 -66=.)
recode DXCCSR_PRG024             (-99 -88 -66=.)
recode DXCCSR_PRG025             (-99 -88 -66=.)
recode DXCCSR_PRG026             (-99 -88 -66=.)
recode DXCCSR_PRG027             (-99 -88 -66=.)
recode DXCCSR_PRG028             (-99 -88 -66=.)
recode DXCCSR_PRG029             (-99 -88 -66=.)
recode DXCCSR_PRG030             (-99 -88 -66=.)
recode DXCCSR_RSP001             (-99 -88 -66=.)
recode DXCCSR_RSP002             (-99 -88 -66=.)
recode DXCCSR_RSP003             (-99 -88 -66=.)
recode DXCCSR_RSP004             (-99 -88 -66=.)
recode DXCCSR_RSP005             (-99 -88 -66=.)
recode DXCCSR_RSP006             (-99 -88 -66=.)
recode DXCCSR_RSP007             (-99 -88 -66=.)
recode DXCCSR_RSP008             (-99 -88 -66=.)
recode DXCCSR_RSP009             (-99 -88 -66=.)
recode DXCCSR_RSP010             (-99 -88 -66=.)
recode DXCCSR_RSP011             (-99 -88 -66=.)
recode DXCCSR_RSP012             (-99 -88 -66=.)
recode DXCCSR_RSP013             (-99 -88 -66=.)
recode DXCCSR_RSP014             (-99 -88 -66=.)
recode DXCCSR_RSP015             (-99 -88 -66=.)
recode DXCCSR_RSP016             (-99 -88 -66=.)
recode DXCCSR_RSP017             (-99 -88 -66=.)
recode DXCCSR_SKN001             (-99 -88 -66=.)
recode DXCCSR_SKN002             (-99 -88 -66=.)
recode DXCCSR_SKN003             (-99 -88 -66=.)
recode DXCCSR_SKN004             (-99 -88 -66=.)
recode DXCCSR_SKN005             (-99 -88 -66=.)
recode DXCCSR_SKN006             (-99 -88 -66=.)
recode DXCCSR_SKN007             (-99 -88 -66=.)
recode DXCCSR_SYM001             (-99 -88 -66=.)
recode DXCCSR_SYM002             (-99 -88 -66=.)
recode DXCCSR_SYM003             (-99 -88 -66=.)
recode DXCCSR_SYM004             (-99 -88 -66=.)
recode DXCCSR_SYM005             (-99 -88 -66=.)
recode DXCCSR_SYM006             (-99 -88 -66=.)
recode DXCCSR_SYM007             (-99 -88 -66=.)
recode DXCCSR_SYM008             (-99 -88 -66=.)
recode DXCCSR_SYM009             (-99 -88 -66=.)
recode DXCCSR_SYM010             (-99 -88 -66=.)
recode DXCCSR_SYM011             (-99 -88 -66=.)
recode DXCCSR_SYM012             (-99 -88 -66=.)
recode DXCCSR_SYM013             (-99 -88 -66=.)
recode DXCCSR_SYM014             (-99 -88 -66=.)
recode DXCCSR_SYM015             (-99 -88 -66=.)
recode DXCCSR_SYM016             (-99 -88 -66=.)
recode DXCCSR_SYM017             (-99 -88 -66=.)
recode PRCCSR_ADM001             (-99 -88 -66=.)
recode PRCCSR_ADM002             (-99 -88 -66=.)
recode PRCCSR_ADM003             (-99 -88 -66=.)
recode PRCCSR_ADM004             (-99 -88 -66=.)
recode PRCCSR_ADM005             (-99 -88 -66=.)
recode PRCCSR_ADM006             (-99 -88 -66=.)
recode PRCCSR_ADM007             (-99 -88 -66=.)
recode PRCCSR_ADM008             (-99 -88 -66=.)
recode PRCCSR_ADM009             (-99 -88 -66=.)
recode PRCCSR_ADM010             (-99 -88 -66=.)
recode PRCCSR_ADM011             (-99 -88 -66=.)
recode PRCCSR_ADM012             (-99 -88 -66=.)
recode PRCCSR_ADM013             (-99 -88 -66=.)
recode PRCCSR_ADM014             (-99 -88 -66=.)
recode PRCCSR_ADM015             (-99 -88 -66=.)
recode PRCCSR_ADM016             (-99 -88 -66=.)
recode PRCCSR_ADM017             (-99 -88 -66=.)
recode PRCCSR_ADM018             (-99 -88 -66=.)
recode PRCCSR_ADM019             (-99 -88 -66=.)
recode PRCCSR_ADM020             (-99 -88 -66=.)
recode PRCCSR_ADM021             (-99 -88 -66=.)
recode PRCCSR_ADM022             (-99 -88 -66=.)
recode PRCCSR_CAR001             (-99 -88 -66=.)
recode PRCCSR_CAR002             (-99 -88 -66=.)
recode PRCCSR_CAR003             (-99 -88 -66=.)
recode PRCCSR_CAR004             (-99 -88 -66=.)
recode PRCCSR_CAR005             (-99 -88 -66=.)
recode PRCCSR_CAR006             (-99 -88 -66=.)
recode PRCCSR_CAR007             (-99 -88 -66=.)
recode PRCCSR_CAR008             (-99 -88 -66=.)
recode PRCCSR_CAR009             (-99 -88 -66=.)
recode PRCCSR_CAR010             (-99 -88 -66=.)
recode PRCCSR_CAR011             (-99 -88 -66=.)
recode PRCCSR_CAR012             (-99 -88 -66=.)
recode PRCCSR_CAR013             (-99 -88 -66=.)
recode PRCCSR_CAR014             (-99 -88 -66=.)
recode PRCCSR_CAR015             (-99 -88 -66=.)
recode PRCCSR_CAR016             (-99 -88 -66=.)
recode PRCCSR_CAR017             (-99 -88 -66=.)
recode PRCCSR_CAR018             (-99 -88 -66=.)
recode PRCCSR_CAR019             (-99 -88 -66=.)
recode PRCCSR_CAR020             (-99 -88 -66=.)
recode PRCCSR_CAR021             (-99 -88 -66=.)
recode PRCCSR_CAR022             (-99 -88 -66=.)
recode PRCCSR_CAR023             (-99 -88 -66=.)
recode PRCCSR_CAR024             (-99 -88 -66=.)
recode PRCCSR_CAR025             (-99 -88 -66=.)
recode PRCCSR_CAR026             (-99 -88 -66=.)
recode PRCCSR_CAR027             (-99 -88 -66=.)
recode PRCCSR_CAR028             (-99 -88 -66=.)
recode PRCCSR_CAR029             (-99 -88 -66=.)
recode PRCCSR_CHP001             (-99 -88 -66=.)
recode PRCCSR_CNS001             (-99 -88 -66=.)
recode PRCCSR_CNS002             (-99 -88 -66=.)
recode PRCCSR_CNS003             (-99 -88 -66=.)
recode PRCCSR_CNS004             (-99 -88 -66=.)
recode PRCCSR_CNS005             (-99 -88 -66=.)
recode PRCCSR_CNS006             (-99 -88 -66=.)
recode PRCCSR_CNS007             (-99 -88 -66=.)
recode PRCCSR_CNS008             (-99 -88 -66=.)
recode PRCCSR_CNS009             (-99 -88 -66=.)
recode PRCCSR_CNS010             (-99 -88 -66=.)
recode PRCCSR_CNS011             (-99 -88 -66=.)
recode PRCCSR_CNS012             (-99 -88 -66=.)
recode PRCCSR_CNS013             (-99 -88 -66=.)
recode PRCCSR_CNS014             (-99 -88 -66=.)
recode PRCCSR_ENP001             (-99 -88 -66=.)
recode PRCCSR_ENP002             (-99 -88 -66=.)
recode PRCCSR_ENP003             (-99 -88 -66=.)
recode PRCCSR_ENP004             (-99 -88 -66=.)
recode PRCCSR_ENP005             (-99 -88 -66=.)
recode PRCCSR_ENP006             (-99 -88 -66=.)
recode PRCCSR_ENT001             (-99 -88 -66=.)
recode PRCCSR_ENT002             (-99 -88 -66=.)
recode PRCCSR_ENT003             (-99 -88 -66=.)
recode PRCCSR_ENT004             (-99 -88 -66=.)
recode PRCCSR_ENT005             (-99 -88 -66=.)
recode PRCCSR_ENT006             (-99 -88 -66=.)
recode PRCCSR_ENT007             (-99 -88 -66=.)
recode PRCCSR_ENT008             (-99 -88 -66=.)
recode PRCCSR_ENT009             (-99 -88 -66=.)
recode PRCCSR_ENT010             (-99 -88 -66=.)
recode PRCCSR_ENT011             (-99 -88 -66=.)
recode PRCCSR_ENT012             (-99 -88 -66=.)
recode PRCCSR_ENT013             (-99 -88 -66=.)
recode PRCCSR_ENT014             (-99 -88 -66=.)
recode PRCCSR_ENT015             (-99 -88 -66=.)
recode PRCCSR_ENT016             (-99 -88 -66=.)
recode PRCCSR_ENT017             (-99 -88 -66=.)
recode PRCCSR_ESA001             (-99 -88 -66=.)
recode PRCCSR_ESA002             (-99 -88 -66=.)
recode PRCCSR_ESA003             (-99 -88 -66=.)
recode PRCCSR_ESA004             (-99 -88 -66=.)
recode PRCCSR_ESA005             (-99 -88 -66=.)
recode PRCCSR_ESA006             (-99 -88 -66=.)
recode PRCCSR_ESA007             (-99 -88 -66=.)
recode PRCCSR_ESA008             (-99 -88 -66=.)
recode PRCCSR_ESA009             (-99 -88 -66=.)
recode PRCCSR_ESA010             (-99 -88 -66=.)
recode PRCCSR_ESA011             (-99 -88 -66=.)
recode PRCCSR_EST001             (-99 -88 -66=.)
recode PRCCSR_EST002             (-99 -88 -66=.)
recode PRCCSR_EST003             (-99 -88 -66=.)
recode PRCCSR_EST004             (-99 -88 -66=.)
recode PRCCSR_EST005             (-99 -88 -66=.)
recode PRCCSR_EYP001             (-99 -88 -66=.)
recode PRCCSR_EYP002             (-99 -88 -66=.)
recode PRCCSR_FRS001             (-99 -88 -66=.)
recode PRCCSR_FRS002             (-99 -88 -66=.)
recode PRCCSR_FRS003             (-99 -88 -66=.)
recode PRCCSR_FRS004             (-99 -88 -66=.)
recode PRCCSR_FRS005             (-99 -88 -66=.)
recode PRCCSR_FRS006             (-99 -88 -66=.)
recode PRCCSR_FRS007             (-99 -88 -66=.)
recode PRCCSR_FRS008             (-99 -88 -66=.)
recode PRCCSR_FRS009             (-99 -88 -66=.)
recode PRCCSR_FRS010             (-99 -88 -66=.)
recode PRCCSR_FRS011             (-99 -88 -66=.)
recode PRCCSR_FRS012             (-99 -88 -66=.)
recode PRCCSR_FRS013             (-99 -88 -66=.)
recode PRCCSR_FRS014             (-99 -88 -66=.)
recode PRCCSR_FRS015             (-99 -88 -66=.)
recode PRCCSR_GIS001             (-99 -88 -66=.)
recode PRCCSR_GIS002             (-99 -88 -66=.)
recode PRCCSR_GIS003             (-99 -88 -66=.)
recode PRCCSR_GIS004             (-99 -88 -66=.)
recode PRCCSR_GIS005             (-99 -88 -66=.)
recode PRCCSR_GIS006             (-99 -88 -66=.)
recode PRCCSR_GIS007             (-99 -88 -66=.)
recode PRCCSR_GIS008             (-99 -88 -66=.)
recode PRCCSR_GIS009             (-99 -88 -66=.)
recode PRCCSR_GIS010             (-99 -88 -66=.)
recode PRCCSR_GIS011             (-99 -88 -66=.)
recode PRCCSR_GIS012             (-99 -88 -66=.)
recode PRCCSR_GIS013             (-99 -88 -66=.)
recode PRCCSR_GIS014             (-99 -88 -66=.)
recode PRCCSR_GIS015             (-99 -88 -66=.)
recode PRCCSR_GIS016             (-99 -88 -66=.)
recode PRCCSR_GIS017             (-99 -88 -66=.)
recode PRCCSR_GIS018             (-99 -88 -66=.)
recode PRCCSR_GIS019             (-99 -88 -66=.)
recode PRCCSR_GIS020             (-99 -88 -66=.)
recode PRCCSR_GIS021             (-99 -88 -66=.)
recode PRCCSR_GIS022             (-99 -88 -66=.)
recode PRCCSR_GIS023             (-99 -88 -66=.)
recode PRCCSR_GIS024             (-99 -88 -66=.)
recode PRCCSR_GIS025             (-99 -88 -66=.)
recode PRCCSR_GIS026             (-99 -88 -66=.)
recode PRCCSR_GIS027             (-99 -88 -66=.)
recode PRCCSR_GIS028             (-99 -88 -66=.)
recode PRCCSR_GIS029             (-99 -88 -66=.)
recode PRCCSR_GNR001             (-99 -88 -66=.)
recode PRCCSR_GNR002             (-99 -88 -66=.)
recode PRCCSR_GNR003             (-99 -88 -66=.)
recode PRCCSR_GNR004             (-99 -88 -66=.)
recode PRCCSR_GNR005             (-99 -88 -66=.)
recode PRCCSR_GNR006             (-99 -88 -66=.)
recode PRCCSR_GNR007             (-99 -88 -66=.)
recode PRCCSR_GNR008             (-99 -88 -66=.)
recode PRCCSR_GNR009             (-99 -88 -66=.)
recode PRCCSR_GNR010             (-99 -88 -66=.)
recode PRCCSR_HEP001             (-99 -88 -66=.)
recode PRCCSR_HEP002             (-99 -88 -66=.)
recode PRCCSR_HEP003             (-99 -88 -66=.)
recode PRCCSR_HEP004             (-99 -88 -66=.)
recode PRCCSR_HEP005             (-99 -88 -66=.)
recode PRCCSR_HEP006             (-99 -88 -66=.)
recode PRCCSR_HEP007             (-99 -88 -66=.)
recode PRCCSR_HEP008             (-99 -88 -66=.)
recode PRCCSR_HEP009             (-99 -88 -66=.)
recode PRCCSR_HEP010             (-99 -88 -66=.)
recode PRCCSR_HEP011             (-99 -88 -66=.)
recode PRCCSR_HEP012             (-99 -88 -66=.)
recode PRCCSR_HEP013             (-99 -88 -66=.)
recode PRCCSR_IMG001             (-99 -88 -66=.)
recode PRCCSR_IMG002             (-99 -88 -66=.)
recode PRCCSR_IMG003             (-99 -88 -66=.)
recode PRCCSR_IMG004             (-99 -88 -66=.)
recode PRCCSR_IMG005             (-99 -88 -66=.)
recode PRCCSR_IMG006             (-99 -88 -66=.)
recode PRCCSR_IMG007             (-99 -88 -66=.)
recode PRCCSR_IMG008             (-99 -88 -66=.)
recode PRCCSR_IMG009             (-99 -88 -66=.)
recode PRCCSR_IMG010             (-99 -88 -66=.)
recode PRCCSR_LYM001             (-99 -88 -66=.)
recode PRCCSR_LYM002             (-99 -88 -66=.)
recode PRCCSR_LYM003             (-99 -88 -66=.)
recode PRCCSR_LYM004             (-99 -88 -66=.)
recode PRCCSR_LYM005             (-99 -88 -66=.)
recode PRCCSR_LYM006             (-99 -88 -66=.)
recode PRCCSR_LYM007             (-99 -88 -66=.)
recode PRCCSR_LYM008             (-99 -88 -66=.)
recode PRCCSR_LYM009             (-99 -88 -66=.)
recode PRCCSR_LYM010             (-99 -88 -66=.)
recode PRCCSR_LYM011             (-99 -88 -66=.)
recode PRCCSR_MAM001             (-99 -88 -66=.)
recode PRCCSR_MAM002             (-99 -88 -66=.)
recode PRCCSR_MAM003             (-99 -88 -66=.)
recode PRCCSR_MAM004             (-99 -88 -66=.)
recode PRCCSR_MAM005             (-99 -88 -66=.)
recode PRCCSR_MAM006             (-99 -88 -66=.)
recode PRCCSR_MAM007             (-99 -88 -66=.)
recode PRCCSR_MAM008             (-99 -88 -66=.)
recode PRCCSR_MAM009             (-99 -88 -66=.)
recode PRCCSR_MAM010             (-99 -88 -66=.)
recode PRCCSR_MAM011             (-99 -88 -66=.)
recode PRCCSR_MAM012             (-99 -88 -66=.)
recode PRCCSR_MAM013             (-99 -88 -66=.)
recode PRCCSR_MAM014             (-99 -88 -66=.)
recode PRCCSR_MAM015             (-99 -88 -66=.)
recode PRCCSR_MHT001             (-99 -88 -66=.)
recode PRCCSR_MHT002             (-99 -88 -66=.)
recode PRCCSR_MHT003             (-99 -88 -66=.)
recode PRCCSR_MHT004             (-99 -88 -66=.)
recode PRCCSR_MHT005             (-99 -88 -66=.)
recode PRCCSR_MRS001             (-99 -88 -66=.)
recode PRCCSR_MRS002             (-99 -88 -66=.)
recode PRCCSR_MRS003             (-99 -88 -66=.)
recode PRCCSR_MRS004             (-99 -88 -66=.)
recode PRCCSR_MRS005             (-99 -88 -66=.)
recode PRCCSR_MRS006             (-99 -88 -66=.)
recode PRCCSR_MRS007             (-99 -88 -66=.)
recode PRCCSR_MST001             (-99 -88 -66=.)
recode PRCCSR_MST002             (-99 -88 -66=.)
recode PRCCSR_MST003             (-99 -88 -66=.)
recode PRCCSR_MST004             (-99 -88 -66=.)
recode PRCCSR_MST005             (-99 -88 -66=.)
recode PRCCSR_MST006             (-99 -88 -66=.)
recode PRCCSR_MST007             (-99 -88 -66=.)
recode PRCCSR_MST008             (-99 -88 -66=.)
recode PRCCSR_MST009             (-99 -88 -66=.)
recode PRCCSR_MST010             (-99 -88 -66=.)
recode PRCCSR_MST011             (-99 -88 -66=.)
recode PRCCSR_MST012             (-99 -88 -66=.)
recode PRCCSR_MST013             (-99 -88 -66=.)
recode PRCCSR_MST014             (-99 -88 -66=.)
recode PRCCSR_MST015             (-99 -88 -66=.)
recode PRCCSR_MST016             (-99 -88 -66=.)
recode PRCCSR_MST017             (-99 -88 -66=.)
recode PRCCSR_MST018             (-99 -88 -66=.)
recode PRCCSR_MST019             (-99 -88 -66=.)
recode PRCCSR_MST020             (-99 -88 -66=.)
recode PRCCSR_MST021             (-99 -88 -66=.)
recode PRCCSR_MST022             (-99 -88 -66=.)
recode PRCCSR_MST023             (-99 -88 -66=.)
recode PRCCSR_MST024             (-99 -88 -66=.)
recode PRCCSR_MST025             (-99 -88 -66=.)
recode PRCCSR_MST026             (-99 -88 -66=.)
recode PRCCSR_MST027             (-99 -88 -66=.)
recode PRCCSR_MST028             (-99 -88 -66=.)
recode PRCCSR_MST029             (-99 -88 -66=.)
recode PRCCSR_MST030             (-99 -88 -66=.)
recode PRCCSR_NCM001             (-99 -88 -66=.)
recode PRCCSR_NCM002             (-99 -88 -66=.)
recode PRCCSR_NCM003             (-99 -88 -66=.)
recode PRCCSR_NCM004             (-99 -88 -66=.)
recode PRCCSR_OST001             (-99 -88 -66=.)
recode PRCCSR_OTR001             (-99 -88 -66=.)
recode PRCCSR_OTR002             (-99 -88 -66=.)
recode PRCCSR_OTR003             (-99 -88 -66=.)
recode PRCCSR_OTR004             (-99 -88 -66=.)
recode PRCCSR_OTR005             (-99 -88 -66=.)
recode PRCCSR_PGN001             (-99 -88 -66=.)
recode PRCCSR_PGN002             (-99 -88 -66=.)
recode PRCCSR_PGN003             (-99 -88 -66=.)
recode PRCCSR_PGN004             (-99 -88 -66=.)
recode PRCCSR_PGN005             (-99 -88 -66=.)
recode PRCCSR_PGN006             (-99 -88 -66=.)
recode PRCCSR_PGN007             (-99 -88 -66=.)
recode PRCCSR_PGN008             (-99 -88 -66=.)
recode PRCCSR_PGN009             (-99 -88 -66=.)
recode PRCCSR_PLC001             (-99 -88 -66=.)
recode PRCCSR_PLC002             (-99 -88 -66=.)
recode PRCCSR_PNS001             (-99 -88 -66=.)
recode PRCCSR_PNS002             (-99 -88 -66=.)
recode PRCCSR_PNS003             (-99 -88 -66=.)
recode PRCCSR_PNS004             (-99 -88 -66=.)
recode PRCCSR_PNS005             (-99 -88 -66=.)
recode PRCCSR_PNS006             (-99 -88 -66=.)
recode PRCCSR_RAD001             (-99 -88 -66=.)
recode PRCCSR_RAD002             (-99 -88 -66=.)
recode PRCCSR_RAD003             (-99 -88 -66=.)
recode PRCCSR_RAD004             (-99 -88 -66=.)
recode PRCCSR_RES001             (-99 -88 -66=.)
recode PRCCSR_RES002             (-99 -88 -66=.)
recode PRCCSR_RES003             (-99 -88 -66=.)
recode PRCCSR_RES004             (-99 -88 -66=.)
recode PRCCSR_RES005             (-99 -88 -66=.)
recode PRCCSR_RES006             (-99 -88 -66=.)
recode PRCCSR_RES007             (-99 -88 -66=.)
recode PRCCSR_RES008             (-99 -88 -66=.)
recode PRCCSR_RES009             (-99 -88 -66=.)
recode PRCCSR_RES010             (-99 -88 -66=.)
recode PRCCSR_RES011             (-99 -88 -66=.)
recode PRCCSR_RES012             (-99 -88 -66=.)
recode PRCCSR_RES013             (-99 -88 -66=.)
recode PRCCSR_RES014             (-99 -88 -66=.)
recode PRCCSR_RHB001             (-99 -88 -66=.)
recode PRCCSR_RHB002             (-99 -88 -66=.)
recode PRCCSR_RHB003             (-99 -88 -66=.)
recode PRCCSR_RHB004             (-99 -88 -66=.)
recode PRCCSR_SKB001             (-99 -88 -66=.)
recode PRCCSR_SKB002             (-99 -88 -66=.)
recode PRCCSR_SKB003             (-99 -88 -66=.)
recode PRCCSR_SKB004             (-99 -88 -66=.)
recode PRCCSR_SKB005             (-99 -88 -66=.)
recode PRCCSR_SKB006             (-99 -88 -66=.)
recode PRCCSR_SKB007             (-99 -88 -66=.)
recode PRCCSR_SKB008             (-99 -88 -66=.)
recode PRCCSR_SKB009             (-99 -88 -66=.)
recode PRCCSR_SKB010             (-99 -88 -66=.)
recode PRCCSR_SUD001             (-99 -88 -66=.)
recode PRCCSR_SUD002             (-99 -88 -66=.)
recode PRCCSR_SUD003             (-99 -88 -66=.)
recode PRCCSR_SUD004             (-99 -88 -66=.)
recode PRCCSR_URN001             (-99 -88 -66=.)
recode PRCCSR_URN002             (-99 -88 -66=.)
recode PRCCSR_URN003             (-99 -88 -66=.)
recode PRCCSR_URN004             (-99 -88 -66=.)
recode PRCCSR_URN005             (-99 -88 -66=.)
recode PRCCSR_URN006             (-99 -88 -66=.)
recode PRCCSR_URN007             (-99 -88 -66=.)
recode PRCCSR_URN008             (-99 -88 -66=.)
recode PRCCSR_URN009             (-99 -88 -66=.)
recode PRCCSR_URN010             (-99 -88 -66=.)
recode PRCCSR_URN011             (-99 -88 -66=.)
recode PRCCSR_URN012             (-99 -88 -66=.)

save "GA_SID_2023_DX_PR_GRPS.dta", replace
