/*******************************************************************
*   HI_SID_1997_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'HI_SID_1997_CORE.ASC' FIXED / 
 SEQ_SID                    1-  13
 AGEDAY                    14-  16
 SEX                       17-  19
 RACE                      20-  21
 DQTR                      22-  23
 LOS                       24-  28
 DISP                      29-  30
 DIED                      31-  32
 ATYPE                     33-  34
 ASOURCE                   35-  36
 NDX                       37-  38
 DX1                       39-  43 (A)
 DXV1                      44-  47
 DCCHPR1                   48-  51
 NPR                       52-  53
 PR1                       54-  57 (A)
 PRV1                      58-  60
 PCCHPR1                   61-  64
 DRG                       65-  67
 MDC                       68-  69
 DRGVER                    70-  71
 DRG10                     72-  74
 MDC10                     75-  76
 PAY1                      77-  78
 TOTCHG                    79-  88
 PROCESS                   89-  99
 YEAR                     100- 103
 DSNUM                    104- 106
 DSTYPE                   107- 109
 HOSPST                   110- 111 (A)
 MDID_S                   112- 127 (A)
 SURGID_S                 128- 143 (A)
 ADAYWK                   144- 146
 AMONTH                   147- 148
 LOS_X                    149- 154
 NEOMAT                   155- 156
 DXSYS                    157- 159
 DSNDX                    160- 162
 PRSYS                    163- 165
 DSNPR                    166- 168
 PRDAY1                   169- 173
 PAY1_N                   174- 176
 TOTCHG_X                 177- 191
 DX2                      192- 196 (A)
 DX3                      197- 201 (A)
 DX4                      202- 206 (A)
 DX5                      207- 211 (A)
 DX6                      212- 216 (A)
 DX7                      217- 221 (A)
 DX8                      222- 226 (A)
 DX9                      227- 231 (A)
 DX10                     232- 236 (A)
 DX11                     237- 241 (A)
 DXV2                     242- 245
 DXV3                     246- 249
 DXV4                     250- 253
 DXV5                     254- 257
 DXV6                     258- 261
 DXV7                     262- 265
 DXV8                     266- 269
 DXV9                     270- 273
 DXV10                    274- 277
 DXV11                    278- 281
 DCCHPR2                  282- 285
 DCCHPR3                  286- 289
 DCCHPR4                  290- 293
 DCCHPR5                  294- 297
 DCCHPR6                  298- 301
 DCCHPR7                  302- 305
 DCCHPR8                  306- 309
 DCCHPR9                  310- 313
 DCCHPR10                 314- 317
 DCCHPR11                 318- 321
 PR2                      322- 325 (A)
 PR3                      326- 329 (A)
 PR4                      330- 333 (A)
 PR5                      334- 337 (A)
 PR6                      338- 341 (A)
 PR7                      342- 345 (A)
 PR8                      346- 349 (A)
 PR9                      350- 353 (A)
 PR10                     354- 357 (A)
 PRV2                     358- 360
 PRV3                     361- 363
 PRV4                     364- 366
 PRV5                     367- 369
 PRV6                     370- 372
 PRV7                     373- 375
 PRV8                     376- 378
 PRV9                     379- 381
 PRV10                    382- 384
 PCCHPR2                  385- 388
 PCCHPR3                  389- 392
 PCCHPR4                  393- 396
 PCCHPR5                  397- 400
 PCCHPR6                  401- 404
 PCCHPR7                  405- 408
 PCCHPR8                  409- 412
 PCCHPR9                  413- 416
 PCCHPR10                 417- 420
 PRDAY2                   421- 425
 PRDAY3                   426- 430
 PRDAY4                   431- 435
 PRDAY5                   436- 440
 PRDAY6                   441- 445
 PRDAY7                   446- 450
 PRDAY8                   451- 455
 PRDAY9                   456- 460
 PRDAY10                  461- 465
 HOSPID                   466- 470
 ZIP                      471- 475 (A)
 MRN_S                    476- 493 (A)
 PNUM_S                   494- 510 (A)
 BWT                      511- 514
 PAY1_X                   515- 534 (A)
 AGEGROUP                 535- 537
 AYEAR                    538- 541
 DMONTH                   542- 543
 BMONTH                   544- 545
 BYEAR                    546- 549
 PRMNTH1                  550- 551
 PRMNTH2                  552- 553
 PRMNTH3                  554- 555
 PRMNTH4                  556- 557
 PRMNTH5                  558- 559
 PRMNTH6                  560- 561
 PRMNTH7                  562- 563
 PRMNTH8                  564- 565
 PRMNTH9                  566- 567
 PRMNTH10                 568- 569
 PRYEAR1                  570- 573
 PRYEAR2                  574- 577
 PRYEAR3                  578- 581
 PRYEAR4                  582- 585
 PRYEAR5                  586- 589
 PRYEAR6                  590- 593
 PRYEAR7                  594- 597
 PRYEAR8                  598- 601
 PRYEAR9                  602- 605
 PRYEAR10                 606- 609.


***  Specify write formats  ***.
FORMATS
 SEQ_SID                 (F7.0) /
 AGEDAY                  (F3.0) /
 SEX                     (F3.0) /
 RACE                    (F3.0) /
 DQTR                    (F3.0) /
 LOS                     (F4.0) /
 DISP                    (F3.0) /
 DIED                    (F3.0) /
 ATYPE                   (F3.0) /
 ASOURCE                 (F3.0) /
 NDX                     (F3.0) /
 DXV1                    (F3.0) /
 DCCHPR1                 (F3.0) /
 NPR                     (F3.0) /
 PRV1                    (F3.0) /
 PCCHPR1                 (F3.0) /
 DRG                     (F3.0) /
 MDC                     (F3.0) /
 DRGVER                  (F3.0) /
 DRG10                   (F3.0) /
 MDC10                   (F3.0) /
 PAY1                    (F3.0) /
 TOTCHG                  (F6.0) /
 PROCESS                 (F6.0) /
 YEAR                    (F3.0) /
 DSNUM                   (F3.0) /
 DSTYPE                  (F3.0) /
 ADAYWK                  (F3.0) /
 AMONTH                  (F3.0) /
 LOS_X                   (F4.0) /
 NEOMAT                  (F3.0) /
 DXSYS                   (F3.0) /
 DSNDX                   (F3.0) /
 PRSYS                   (F3.0) /
 DSNPR                   (F3.0) /
 PRDAY1                  (F4.0) /
 PAY1_N                  (F3.0) /
 TOTCHG_X                (F7.2) /
 DXV2                    (F3.0) /
 DXV3                    (F3.0) /
 DXV4                    (F3.0) /
 DXV5                    (F3.0) /
 DXV6                    (F3.0) /
 DXV7                    (F3.0) /
 DXV8                    (F3.0) /
 DXV9                    (F3.0) /
 DXV10                   (F3.0) /
 DXV11                   (F3.0) /
 DCCHPR2                 (F3.0) /
 DCCHPR3                 (F3.0) /
 DCCHPR4                 (F3.0) /
 DCCHPR5                 (F3.0) /
 DCCHPR6                 (F3.0) /
 DCCHPR7                 (F3.0) /
 DCCHPR8                 (F3.0) /
 DCCHPR9                 (F3.0) /
 DCCHPR10                (F3.0) /
 DCCHPR11                (F3.0) /
 PRV2                    (F3.0) /
 PRV3                    (F3.0) /
 PRV4                    (F3.0) /
 PRV5                    (F3.0) /
 PRV6                    (F3.0) /
 PRV7                    (F3.0) /
 PRV8                    (F3.0) /
 PRV9                    (F3.0) /
 PRV10                   (F3.0) /
 PCCHPR2                 (F3.0) /
 PCCHPR3                 (F3.0) /
 PCCHPR4                 (F3.0) /
 PCCHPR5                 (F3.0) /
 PCCHPR6                 (F3.0) /
 PCCHPR7                 (F3.0) /
 PCCHPR8                 (F3.0) /
 PCCHPR9                 (F3.0) /
 PCCHPR10                (F3.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 HOSPID                  (F4.0) /
 BWT                     (F4.0) /
 AGEGROUP                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 SEQ_SID   "I:HCUP-3 SID record sequence number"
 AGEDAY    "I:Age in days (when < 1 year)"
 SEX       "I:Sex"
 RACE      "I:Race"
 DQTR      "I:Discharge quarter"
 LOS       "I:Length of stay (cleaned)"
 DISP      "I:Disposition of patient"
 DIED      "I:Died during hospitalization"
 ATYPE     "I:Admission type"
 ASOURCE   "I:Admission source"
 NDX       "I:Number of diagnoses on this discharge"
 DX1       "I:Principal diagnosis"
 DXV1      "I:Validity flag: principal diagnosis"
 DCCHPR1   "I:CCHPR: principal diagnosis"
 NPR       "I:Number of procedures on this discharge"
 PR1       "I:Principal procedure"
 PRV1      "I:Validity flag: principal procedure"
 PCCHPR1   "I:CCHPR: principal procedure"
 DRG       "I:DRG in effect on discharge date"
 MDC       "I:MDC in effect on discharge date"
 DRGVER    "I:DRG grouper version used on disch date"
 DRG10     "I:DRG, Version 10"
 MDC10     "I:MDC, Version 10"
 PAY1      "I:Primary expected payer, uniform"
 TOTCHG    "I:Total charges (cleaned)"
 PROCESS   "I:HCUP-3 discharge processing ID number"
 YEAR      "Calendar year"
 DSNUM     "I:Data source ID number"
 DSTYPE    "I:Data source type"
 HOSPST    "Hospital state postal code"
 MDID_S    "I:Attending physician number (synthetic)"
 SURGID_S  "I:Primary surgeon number (synthetic)"
 ADAYWK    "I:Admission day of week"
 AMONTH    "I:Admission month"
 LOS_X     "I:Length of stay (uncleaned)"
 NEOMAT    "I:Neonatal and/or maternal DX and/or PR"
 DXSYS     "I:Diagnosis coding system"
 DSNDX     "I:Max number of diagnoses from source"
 PRSYS     "I:Procedure coding system"
 DSNPR     "I:Max number of procedures from source"
 PRDAY1    "I:No. of days from admission to PR1"
 PAY1_N    "I:Primary expected payer, nonuniform"
 TOTCHG_X  "I:Total charges (from data source)"
 DX2       "I:Diagnosis 2"
 DX3       "I:Diagnosis 3"
 DX4       "I:Diagnosis 4"
 DX5       "I:Diagnosis 5"
 DX6       "I:Diagnosis 6"
 DX7       "I:Diagnosis 7"
 DX8       "I:Diagnosis 8"
 DX9       "I:Diagnosis 9"
 DX10      "I:Diagnosis 10"
 DX11      "I:Diagnosis 11"
 DXV2      "I:Validity flag: diagnosis 2"
 DXV3      "I:Validity flag: diagnosis 3"
 DXV4      "I:Validity flag: diagnosis 4"
 DXV5      "I:Validity flag: diagnosis 5"
 DXV6      "I:Validity flag: diagnosis 6"
 DXV7      "I:Validity flag: diagnosis 7"
 DXV8      "I:Validity flag: diagnosis 8"
 DXV9      "I:Validity flag: diagnosis 9"
 DXV10     "I:Validity flag: diagnosis 10"
 DXV11     "I:Validity flag: diagnosis 11"
 DCCHPR2   "I:CCHPR: diagnosis 2"
 DCCHPR3   "I:CCHPR: diagnosis 3"
 DCCHPR4   "I:CCHPR: diagnosis 4"
 DCCHPR5   "I:CCHPR: diagnosis 5"
 DCCHPR6   "I:CCHPR: diagnosis 6"
 DCCHPR7   "I:CCHPR: diagnosis 7"
 DCCHPR8   "I:CCHPR: diagnosis 8"
 DCCHPR9   "I:CCHPR: diagnosis 9"
 DCCHPR10  "I:CCHPR: diagnosis 10"
 DCCHPR11  "I:CCHPR: diagnosis 11"
 PR2       "I:Procedure 2"
 PR3       "I:Procedure 3"
 PR4       "I:Procedure 4"
 PR5       "I:Procedure 5"
 PR6       "I:Procedure 6"
 PR7       "I:Procedure 7"
 PR8       "I:Procedure 8"
 PR9       "I:Procedure 9"
 PR10      "I:Procedure 10"
 PRV2      "I:Validity flag: procedure 2"
 PRV3      "I:Validity flag: procedure 3"
 PRV4      "I:Validity flag: procedure 4"
 PRV5      "I:Validity flag: procedure 5"
 PRV6      "I:Validity flag: procedure 6"
 PRV7      "I:Validity flag: procedure 7"
 PRV8      "I:Validity flag: procedure 8"
 PRV9      "I:Validity flag: procedure 9"
 PRV10     "I:Validity flag: procedure 10"
 PCCHPR2   "I:CCHPR: procedure 2"
 PCCHPR3   "I:CCHPR: procedure 3"
 PCCHPR4   "I:CCHPR: procedure 4"
 PCCHPR5   "I:CCHPR: procedure 5"
 PCCHPR6   "I:CCHPR: procedure 6"
 PCCHPR7   "I:CCHPR: procedure 7"
 PCCHPR8   "I:CCHPR: procedure 8"
 PCCHPR9   "I:CCHPR: procedure 9"
 PCCHPR10  "I:CCHPR: procedure 10"
 PRDAY2    "I:No. of days from admission to PR2"
 PRDAY3    "I:No. of days from admission to PR3"
 PRDAY4    "I:No. of days from admission to PR4"
 PRDAY5    "I:No. of days from admission to PR5"
 PRDAY6    "I:No. of days from admission to PR6"
 PRDAY7    "I:No. of days from admission to PR7"
 PRDAY8    "I:No. of days from admission to PR8"
 PRDAY9    "I:No. of days from admission to PR9"
 PRDAY10   "I:No. of days from admission to PR10"
 HOSPID    "HCUP-3 hospital ID number (SSHHH)"
 ZIP       "I:Patient zip code"
 MRN_S     "I:Medical record number (synthetic)"
 PNUM_S    "I:Person number (synthetic)"
 BWT       "I:Birthweight in grams"
 PAY1_X    "I:Primary exp. payer (from data source)"
 AGEGROUP  "Age Group"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE SEQ_SID
 (-999999999999,-888888888888,-666666666666,-555555555555=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE SEX
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DISP
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE DXV1
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PRV1
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE PROCESS
 (-9999999999,-8888888888,-6666666666,-5555555555=SYSMIS).
RECODE DSNUM
 (-99,-88,-66,-55=SYSMIS).
RECODE DSTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE ADAYWK
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE DXSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNDX
 (-99,-88,-66,-55=SYSMIS).
RECODE PRSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PAY1_N
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE DXV2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV11
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRV2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV10
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'HI_SID_1997_CORE.SAV' /COMPRESSED.
