/*******************************************************************
*   CA_SID_2009_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'CA_SID_2009_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ASCHED                    12-  13
 ASOURCE                   14-  15
 ASOURCE_X                 16-  18 (A)
 AWEEKEND                  19-  20
 DIED                      21-  22
 DISPUNIFORM               23-  24
 DISP_X                    25-  26 (A)
 DNR                       27-  28
 DQTR                      29-  30
 DRG                       31-  33
 DRG24                     34-  36
 DRGVER                    37-  38
 DRG_NoPOA                 39-  41
 DSHOSPID                  42-  58 (A)
 DX1                       59-  63 (A)
 DX2                       64-  68 (A)
 DX3                       69-  73 (A)
 DX4                       74-  78 (A)
 DX5                       79-  83 (A)
 DX6                       84-  88 (A)
 DX7                       89-  93 (A)
 DX8                       94-  98 (A)
 DX9                       99- 103 (A)
 DX10                     104- 108 (A)
 DX11                     109- 113 (A)
 DX12                     114- 118 (A)
 DX13                     119- 123 (A)
 DX14                     124- 128 (A)
 DX15                     129- 133 (A)
 DX16                     134- 138 (A)
 DX17                     139- 143 (A)
 DX18                     144- 148 (A)
 DX19                     149- 153 (A)
 DX20                     154- 158 (A)
 DX21                     159- 163 (A)
 DX22                     164- 168 (A)
 DX23                     169- 173 (A)
 DX24                     174- 178 (A)
 DX25                     179- 183 (A)
 DXCCS1                   184- 187
 DXCCS2                   188- 191
 DXCCS3                   192- 195
 DXCCS4                   196- 199
 DXCCS5                   200- 203
 DXCCS6                   204- 207
 DXCCS7                   208- 211
 DXCCS8                   212- 215
 DXCCS9                   216- 219
 DXCCS10                  220- 223
 DXCCS11                  224- 227
 DXCCS12                  228- 231
 DXCCS13                  232- 235
 DXCCS14                  236- 239
 DXCCS15                  240- 243
 DXCCS16                  244- 247
 DXCCS17                  248- 251
 DXCCS18                  252- 255
 DXCCS19                  256- 259
 DXCCS20                  260- 263
 DXCCS21                  264- 267
 DXCCS22                  268- 271
 DXCCS23                  272- 275
 DXCCS24                  276- 279
 DXCCS25                  280- 283
 DXPOA1                   284     (A)
 DXPOA2                   285     (A)
 DXPOA3                   286     (A)
 DXPOA4                   287     (A)
 DXPOA5                   288     (A)
 DXPOA6                   289     (A)
 DXPOA7                   290     (A)
 DXPOA8                   291     (A)
 DXPOA9                   292     (A)
 DXPOA10                  293     (A)
 DXPOA11                  294     (A)
 DXPOA12                  295     (A)
 DXPOA13                  296     (A)
 DXPOA14                  297     (A)
 DXPOA15                  298     (A)
 DXPOA16                  299     (A)
 DXPOA17                  300     (A)
 DXPOA18                  301     (A)
 DXPOA19                  302     (A)
 DXPOA20                  303     (A)
 DXPOA21                  304     (A)
 DXPOA22                  305     (A)
 DXPOA23                  306     (A)
 DXPOA24                  307     (A)
 DXPOA25                  308     (A)
 DaysToEvent              309- 314
 ECODE1                   315- 319 (A)
 ECODE2                   320- 324 (A)
 ECODE3                   325- 329 (A)
 ECODE4                   330- 334 (A)
 ECODE5                   335- 339 (A)
 E_CCS1                   340- 343
 E_CCS2                   344- 347
 E_CCS3                   348- 351
 E_CCS4                   352- 355
 E_CCS5                   356- 359
 E_POA1                   360     (A)
 E_POA2                   361     (A)
 E_POA3                   362     (A)
 E_POA4                   363     (A)
 E_POA5                   364     (A)
 FEMALE                   365- 366
 HCUP_ED                  367- 368
 HCUP_OS                  369- 370
 HISPANIC_X               371     (A)
 HOSPBRTH                 372- 374
 HOSPST                   375- 376 (A)
 Homeless                 377- 378
 HospitalUnit             379- 380
 KEY                      381- 394
 LOS                      395- 399
 LOS_X                    400- 405
 MDC                      406- 407
 MDC24                    408- 409
 MEDINCSTQ                410- 411
 NCHRONIC                 412- 414
 NDX                      415- 416
 NECODE                   417- 418
 NEOMAT                   419- 420
 NPR                      421- 422
 ORPROC                   423- 424
 PAY1                     425- 426
 PAY1_X                   427- 429 (A)
 PAYER1_X                 430- 433 (A)
 PL_CBSA                  434- 436
 PL_MSA1993               437- 439
 PL_NCHS2006              440- 441
 PL_RUCA4_2005            442- 443
 PL_RUCC2003              444- 445
 PL_UIC2003               446- 447
 PL_UR_CAT4               448- 449
 PNUM_R                   450- 458
 PR1                      459- 462 (A)
 PR2                      463- 466 (A)
 PR3                      467- 470 (A)
 PR4                      471- 474 (A)
 PR5                      475- 478 (A)
 PR6                      479- 482 (A)
 PR7                      483- 486 (A)
 PR8                      487- 490 (A)
 PR9                      491- 494 (A)
 PR10                     495- 498 (A)
 PR11                     499- 502 (A)
 PR12                     503- 506 (A)
 PR13                     507- 510 (A)
 PR14                     511- 514 (A)
 PR15                     515- 518 (A)
 PR16                     519- 522 (A)
 PR17                     523- 526 (A)
 PR18                     527- 530 (A)
 PR19                     531- 534 (A)
 PR20                     535- 538 (A)
 PR21                     539- 542 (A)
 PRCCS1                   543- 545
 PRCCS2                   546- 548
 PRCCS3                   549- 551
 PRCCS4                   552- 554
 PRCCS5                   555- 557
 PRCCS6                   558- 560
 PRCCS7                   561- 563
 PRCCS8                   564- 566
 PRCCS9                   567- 569
 PRCCS10                  570- 572
 PRCCS11                  573- 575
 PRCCS12                  576- 578
 PRCCS13                  579- 581
 PRCCS14                  582- 584
 PRCCS15                  585- 587
 PRCCS16                  588- 590
 PRCCS17                  591- 593
 PRCCS18                  594- 596
 PRCCS19                  597- 599
 PRCCS20                  600- 602
 PRCCS21                  603- 605
 PRDAY1                   606- 610
 PRDAY2                   611- 615
 PRDAY3                   616- 620
 PRDAY4                   621- 625
 PRDAY5                   626- 630
 PRDAY6                   631- 635
 PRDAY7                   636- 640
 PRDAY8                   641- 645
 PRDAY9                   646- 650
 PRDAY10                  651- 655
 PRDAY11                  656- 660
 PRDAY12                  661- 665
 PRDAY13                  666- 670
 PRDAY14                  671- 675
 PRDAY15                  676- 680
 PRDAY16                  681- 685
 PRDAY17                  686- 690
 PRDAY18                  691- 695
 PRDAY19                  696- 700
 PRDAY20                  701- 705
 PRDAY21                  706- 710
 PROCTYPE                 711- 713
 PSTATE                   714- 715 (A)
 RACE                     716- 717
 RACE_X                   718     (A)
 TOTCHG                   719- 728
 TOTCHG_X                 729- 743
 TRAN_IN                  744- 745
 TRAN_OUT                 746- 747
 VisitLink                748- 756
 YEAR                     757- 760
 AYEAR                    761- 764
 DMONTH                   765- 766
 BMONTH                   767- 768
 PRMONTH1                 769- 770
 PRMONTH2                 771- 772
 PRMONTH3                 773- 774
 PRMONTH4                 775- 776
 PRMONTH5                 777- 778
 PRMONTH6                 779- 780
 PRMONTH7                 781- 782
 PRMONTH8                 783- 784
 PRMONTH9                 785- 786
 PRMONTH10                787- 788
 PRMONTH11                789- 790
 PRMONTH12                791- 792
 PRMONTH13                793- 794
 PRMONTH14                795- 796
 PRMONTH15                797- 798
 PRMONTH16                799- 800
 PRMONTH17                801- 802
 PRMONTH18                803- 804
 PRMONTH19                805- 806
 PRMONTH20                807- 808
 PRMONTH21                809- 810
 PRYEAR1                  811- 814
 PRYEAR2                  815- 818
 PRYEAR3                  819- 822
 PRYEAR4                  823- 826
 PRYEAR5                  827- 830
 PRYEAR6                  831- 834
 PRYEAR7                  835- 838
 PRYEAR8                  839- 842
 PRYEAR9                  843- 846
 PRYEAR10                 847- 850
 PRYEAR11                 851- 854
 PRYEAR12                 855- 858
 PRYEAR13                 859- 862
 PRYEAR14                 863- 866
 PRYEAR15                 867- 870
 PRYEAR16                 871- 874
 PRYEAR17                 875- 878
 PRYEAR18                 879- 882
 PRYEAR19                 883- 886
 PRYEAR20                 887- 890
 PRYEAR21                 891- 894.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASCHED                  (F3.0) /
 ASOURCE                 (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUNIFORM             (F3.0) /
 DNR                     (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 HospitalUnit            (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PROCTYPE                (F3.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRMONTH21               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 ASCHED                  "Admission scheduled vs. unscheduled"
 ASOURCE                 "Admission source (uniform)"
 ASOURCE_X               "Admission source (as received from source)"
 AWEEKEND                "Admission day is a weekend"
 DIED                    "Died during hospitalization"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DNR                     "Do not resuscitate indicator"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DXPOA16                 "Diagnosis 16, present on admission indicator"
 DXPOA17                 "Diagnosis 17, present on admission indicator"
 DXPOA18                 "Diagnosis 18, present on admission indicator"
 DXPOA19                 "Diagnosis 19, present on admission indicator"
 DXPOA20                 "Diagnosis 20, present on admission indicator"
 DXPOA21                 "Diagnosis 21, present on admission indicator"
 DXPOA22                 "Diagnosis 22, present on admission indicator"
 DXPOA23                 "Diagnosis 23, present on admission indicator"
 DXPOA24                 "Diagnosis 24, present on admission indicator"
 DXPOA25                 "Diagnosis 25, present on admission indicator"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 Homeless                "Indicator that patient is homeless"
 HospitalUnit

"Indicator that patient was discharged from a special unit within an acute care hospital (re
ported by source)"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAYER1_X                "Primary expected payer plan identifier (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PNUM_R                  "Person number (re-identified)"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PR21                    "Procedure 21"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRCCS21                 "CCS: procedure 21"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PRDAY21                 "Number of days from admission to PR21"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRMONTH21               "Month of procedure 21"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20"
 PRYEAR21                "Year of procedure 21" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASCHED
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'CA_SID_2009_CORE.SAV' /COMPRESSED.
