/*******************************************************************
* Creation Date: 02/11/2018   
*   AR_SID_2015q4_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'AR_SID_2015q4_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 APGAR1                         16-  17
 APGAR5                         18-  19
 ATYPE                          20-  21
 AWEEKEND                       22-  23
 BILLTYPE                       24-  27 (A)
 BWT                            28-  31
 CPT1                           32-  36 (A)
 CPT2                           37-  41 (A)
 CPT3                           42-  46 (A)
 CPT4                           47-  51 (A)
 CPT5                           52-  56 (A)
 CPT6                           57-  61 (A)
 CPT7                           62-  66 (A)
 CPT8                           67-  71 (A)
 CPT9                           72-  76 (A)
 CPT10                          77-  81 (A)
 CPT11                          82-  86 (A)
 CPT12                          87-  91 (A)
 CPT13                          92-  96 (A)
 CPT14                          97- 101 (A)
 CPT15                         102- 106 (A)
 CPT16                         107- 111 (A)
 CPT17                         112- 116 (A)
 CPT18                         117- 121 (A)
 CPT19                         122- 126 (A)
 CPT20                         127- 131 (A)
 CPT21                         132- 136 (A)
 CPT22                         137- 141 (A)
 CPT23                         142- 146 (A)
 CPT24                         147- 151 (A)
 CPT25                         152- 156 (A)
 CPT26                         157- 161 (A)
 CPT27                         162- 166 (A)
 CPT28                         167- 171 (A)
 CPT29                         172- 176 (A)
 CPT30                         177- 181 (A)
 CPT31                         182- 186 (A)
 CPT32                         187- 191 (A)
 CPT33                         192- 196 (A)
 CPT34                         197- 201 (A)
 CPT35                         202- 206 (A)
 CPT36                         207- 211 (A)
 CPT37                         212- 216 (A)
 CPT38                         217- 221 (A)
 CPT39                         222- 226 (A)
 CPT40                         227- 231 (A)
 CPT41                         232- 236 (A)
 CPT42                         237- 241 (A)
 CPT43                         242- 246 (A)
 CPT44                         247- 251 (A)
 CPT45                         252- 256 (A)
 CPT46                         257- 261 (A)
 CPT47                         262- 266 (A)
 CPT48                         267- 271 (A)
 CPT49                         272- 276 (A)
 CPT50                         277- 281 (A)
 CPT51                         282- 286 (A)
 CPT52                         287- 291 (A)
 CPT53                         292- 296 (A)
 CPT54                         297- 301 (A)
 CPT55                         302- 306 (A)
 CPT56                         307- 311 (A)
 CPT57                         312- 316 (A)
 CPT58                         317- 321 (A)
 CPT59                         322- 326 (A)
 CPT60                         327- 331 (A)
 CPT61                         332- 336 (A)
 CPT62                         337- 341 (A)
 CPT63                         342- 346 (A)
 CPT64                         347- 351 (A)
 CPT65                         352- 356 (A)
 CPT66                         357- 361 (A)
 CPT67                         362- 366 (A)
 CPT68                         367- 371 (A)
 CPT69                         372- 376 (A)
 CPT70                         377- 381 (A)
 CPT71                         382- 386 (A)
 CPT72                         387- 391 (A)
 CPT73                         392- 396 (A)
 CPT74                         397- 401 (A)
 CPT75                         402- 406 (A)
 CPT76                         407- 411 (A)
 CPT77                         412- 416 (A)
 CPT78                         417- 421 (A)
 CPT79                         422- 426 (A)
 CPT80                         427- 431 (A)
 CPT81                         432- 436 (A)
 CPT82                         437- 441 (A)
 CPT83                         442- 446 (A)
 CPT84                         447- 451 (A)
 CPT85                         452- 456 (A)
 CPT86                         457- 461 (A)
 CPT87                         462- 466 (A)
 CPT88                         467- 471 (A)
 CPT89                         472- 476 (A)
 CPT90                         477- 481 (A)
 CPT91                         482- 486 (A)
 CPT92                         487- 491 (A)
 CPT93                         492- 496 (A)
 CPT94                         497- 501 (A)
 CPT95                         502- 506 (A)
 CPT96                         507- 511 (A)
 CPT97                         512- 516 (A)
 CPT98                         517- 521 (A)
 CPT99                         522- 526 (A)
 CPT100                        527- 531 (A)
 CPT101                        532- 536 (A)
 CPT102                        537- 541 (A)
 CPT103                        542- 546 (A)
 CPT104                        547- 551 (A)
 CPT105                        552- 556 (A)
 CPT106                        557- 561 (A)
 CPT107                        562- 566 (A)
 CPT108                        567- 571 (A)
 CPT109                        572- 576 (A)
 CPT110                        577- 581 (A)
 CPTCCS1                       582- 584
 CPTCCS2                       585- 587
 CPTCCS3                       588- 590
 CPTCCS4                       591- 593
 CPTCCS5                       594- 596
 CPTCCS6                       597- 599
 CPTCCS7                       600- 602
 CPTCCS8                       603- 605
 CPTCCS9                       606- 608
 CPTCCS10                      609- 611
 CPTCCS11                      612- 614
 CPTCCS12                      615- 617
 CPTCCS13                      618- 620
 CPTCCS14                      621- 623
 CPTCCS15                      624- 626
 CPTCCS16                      627- 629
 CPTCCS17                      630- 632
 CPTCCS18                      633- 635
 CPTCCS19                      636- 638
 CPTCCS20                      639- 641
 CPTCCS21                      642- 644
 CPTCCS22                      645- 647
 CPTCCS23                      648- 650
 CPTCCS24                      651- 653
 CPTCCS25                      654- 656
 CPTCCS26                      657- 659
 CPTCCS27                      660- 662
 CPTCCS28                      663- 665
 CPTCCS29                      666- 668
 CPTCCS30                      669- 671
 CPTCCS31                      672- 674
 CPTCCS32                      675- 677
 CPTCCS33                      678- 680
 CPTCCS34                      681- 683
 CPTCCS35                      684- 686
 CPTCCS36                      687- 689
 CPTCCS37                      690- 692
 CPTCCS38                      693- 695
 CPTCCS39                      696- 698
 CPTCCS40                      699- 701
 CPTCCS41                      702- 704
 CPTCCS42                      705- 707
 CPTCCS43                      708- 710
 CPTCCS44                      711- 713
 CPTCCS45                      714- 716
 CPTCCS46                      717- 719
 CPTCCS47                      720- 722
 CPTCCS48                      723- 725
 CPTCCS49                      726- 728
 CPTCCS50                      729- 731
 CPTCCS51                      732- 734
 CPTCCS52                      735- 737
 CPTCCS53                      738- 740
 CPTCCS54                      741- 743
 CPTCCS55                      744- 746
 CPTCCS56                      747- 749
 CPTCCS57                      750- 752
 CPTCCS58                      753- 755
 CPTCCS59                      756- 758
 CPTCCS60                      759- 761
 CPTCCS61                      762- 764
 CPTCCS62                      765- 767
 CPTCCS63                      768- 770
 CPTCCS64                      771- 773
 CPTCCS65                      774- 776
 CPTCCS66                      777- 779
 CPTCCS67                      780- 782
 CPTCCS68                      783- 785
 CPTCCS69                      786- 788
 CPTCCS70                      789- 791
 CPTCCS71                      792- 794
 CPTCCS72                      795- 797
 CPTCCS73                      798- 800
 CPTCCS74                      801- 803
 CPTCCS75                      804- 806
 CPTCCS76                      807- 809
 CPTCCS77                      810- 812
 CPTCCS78                      813- 815
 CPTCCS79                      816- 818
 CPTCCS80                      819- 821
 CPTCCS81                      822- 824
 CPTCCS82                      825- 827
 CPTCCS83                      828- 830
 CPTCCS84                      831- 833
 CPTCCS85                      834- 836
 CPTCCS86                      837- 839
 CPTCCS87                      840- 842
 CPTCCS88                      843- 845
 CPTCCS89                      846- 848
 CPTCCS90                      849- 851
 CPTCCS91                      852- 854
 CPTCCS92                      855- 857
 CPTCCS93                      858- 860
 CPTCCS94                      861- 863
 CPTCCS95                      864- 866
 CPTCCS96                      867- 869
 CPTCCS97                      870- 872
 CPTCCS98                      873- 875
 CPTCCS99                      876- 878
 CPTCCS100                     879- 881
 CPTCCS101                     882- 884
 CPTCCS102                     885- 887
 CPTCCS103                     888- 890
 CPTCCS104                     891- 893
 CPTCCS105                     894- 896
 CPTCCS106                     897- 899
 CPTCCS107                     900- 902
 CPTCCS108                     903- 905
 CPTCCS109                     906- 908
 CPTCCS110                     909- 911
 DaysToEvent                   912- 917
 DHOUR                         918- 921
 DIED                          922- 923
 DISP_X                        924- 925 (A)
 DISPUB04                      926- 927
 DISPUNIFORM                   928- 929
 DMONTH                        930- 931
 DNR                           932- 933
 DQTR                          934- 935
 DRG                           936- 938
 DRG_NoPOA                     939- 941
 DRG32                         942- 944
 DRGVER                        945- 946
 DSHOSPID                      947- 963 (A)
 DXPOA1                        964     (A)
 DXPOA2                        965     (A)
 DXPOA3                        966     (A)
 DXPOA4                        967     (A)
 DXPOA5                        968     (A)
 DXPOA6                        969     (A)
 DXPOA7                        970     (A)
 DXPOA8                        971     (A)
 DXPOA9                        972     (A)
 DXPOA10                       973     (A)
 DXPOA11                       974     (A)
 DXPOA12                       975     (A)
 DXPOA13                       976     (A)
 DXPOA14                       977     (A)
 DXPOA15                       978     (A)
 DXPOA16                       979     (A)
 DXPOA17                       980     (A)
 DXPOA18                       981     (A)
 DXPOA19                       982     (A)
 DXPOA20                       983     (A)
 DXPOA21                       984     (A)
 DXPOA22                       985     (A)
 DXPOA23                       986     (A)
 DXPOA24                       987     (A)
 DXPOA25                       988     (A)
 DXPOA26                       989     (A)
 DXPOA27                       990     (A)
 DXPOA28                       991     (A)
 DXPOA29                       992     (A)
 DXPOA30                       993     (A)
 DXVER                         994- 996
 E_POA1                        997     (A)
 E_POA2                        998     (A)
 E_POA3                        999     (A)
 E_POA4                       1000     (A)
 E_POA5                       1001     (A)
 E_POA6                       1002     (A)
 E_POA7                       1003     (A)
 E_POA8                       1004     (A)
 E_POA9                       1005     (A)
 E_POA10                      1006     (A)
 E_POA11                      1007     (A)
 E_POA12                      1008     (A)
 E_POA13                      1009     (A)
 E_POA14                      1010     (A)
 E_POA15                      1011     (A)
 E_POA16                      1012     (A)
 FEMALE                       1013-1014
 HCUP_ED                      1015-1016
 HCUP_OS                      1017-1018
 HISPANIC                     1019-1020
 HISPANIC_X                   1021     (A)
 HOSPST                       1022-1023 (A)
 I10_DX_Admitting             1024-1030 (A)
 I10_DX1                      1031-1037 (A)
 I10_DX2                      1038-1044 (A)
 I10_DX3                      1045-1051 (A)
 I10_DX4                      1052-1058 (A)
 I10_DX5                      1059-1065 (A)
 I10_DX6                      1066-1072 (A)
 I10_DX7                      1073-1079 (A)
 I10_DX8                      1080-1086 (A)
 I10_DX9                      1087-1093 (A)
 I10_DX10                     1094-1100 (A)
 I10_DX11                     1101-1107 (A)
 I10_DX12                     1108-1114 (A)
 I10_DX13                     1115-1121 (A)
 I10_DX14                     1122-1128 (A)
 I10_DX15                     1129-1135 (A)
 I10_DX16                     1136-1142 (A)
 I10_DX17                     1143-1149 (A)
 I10_DX18                     1150-1156 (A)
 I10_DX19                     1157-1163 (A)
 I10_DX20                     1164-1170 (A)
 I10_DX21                     1171-1177 (A)
 I10_DX22                     1178-1184 (A)
 I10_DX23                     1185-1191 (A)
 I10_DX24                     1192-1198 (A)
 I10_DX25                     1199-1205 (A)
 I10_DX26                     1206-1212 (A)
 I10_DX27                     1213-1219 (A)
 I10_DX28                     1220-1226 (A)
 I10_DX29                     1227-1233 (A)
 I10_DX30                     1234-1240 (A)
 I10_DXCCS1                   1241-1244
 I10_DXCCS2                   1245-1248
 I10_DXCCS3                   1249-1252
 I10_DXCCS4                   1253-1256
 I10_DXCCS5                   1257-1260
 I10_DXCCS6                   1261-1264
 I10_DXCCS7                   1265-1268
 I10_DXCCS8                   1269-1272
 I10_DXCCS9                   1273-1276
 I10_DXCCS10                  1277-1280
 I10_DXCCS11                  1281-1284
 I10_DXCCS12                  1285-1288
 I10_DXCCS13                  1289-1292
 I10_DXCCS14                  1293-1296
 I10_DXCCS15                  1297-1300
 I10_DXCCS16                  1301-1304
 I10_DXCCS17                  1305-1308
 I10_DXCCS18                  1309-1312
 I10_DXCCS19                  1313-1316
 I10_DXCCS20                  1317-1320
 I10_DXCCS21                  1321-1324
 I10_DXCCS22                  1325-1328
 I10_DXCCS23                  1329-1332
 I10_DXCCS24                  1333-1336
 I10_DXCCS25                  1337-1340
 I10_DXCCS26                  1341-1344
 I10_DXCCS27                  1345-1348
 I10_DXCCS28                  1349-1352
 I10_DXCCS29                  1353-1356
 I10_DXCCS30                  1357-1360
 I10_ECAUSE1                  1361-1367 (A)
 I10_ECAUSE2                  1368-1374 (A)
 I10_ECAUSE3                  1375-1381 (A)
 I10_ECAUSE4                  1382-1388 (A)
 I10_ECAUSE5                  1389-1395 (A)
 I10_ECAUSE6                  1396-1402 (A)
 I10_ECAUSE7                  1403-1409 (A)
 I10_ECAUSE8                  1410-1416 (A)
 I10_ECAUSE9                  1417-1423 (A)
 I10_ECAUSE10                 1424-1430 (A)
 I10_ECAUSE11                 1431-1437 (A)
 I10_ECAUSE12                 1438-1444 (A)
 I10_ECAUSE13                 1445-1451 (A)
 I10_ECAUSE14                 1452-1458 (A)
 I10_ECAUSE15                 1459-1465 (A)
 I10_ECAUSE16                 1466-1472 (A)
 I10_ECauseCCS1               1473-1476
 I10_ECauseCCS2               1477-1480
 I10_ECauseCCS3               1481-1484
 I10_ECauseCCS4               1485-1488
 I10_ECauseCCS5               1489-1492
 I10_ECauseCCS6               1493-1496
 I10_ECauseCCS7               1497-1500
 I10_ECauseCCS8               1501-1504
 I10_ECauseCCS9               1505-1508
 I10_ECauseCCS10              1509-1512
 I10_ECauseCCS11              1513-1516
 I10_ECauseCCS12              1517-1520
 I10_ECauseCCS13              1521-1524
 I10_ECauseCCS14              1525-1528
 I10_ECauseCCS15              1529-1532
 I10_ECauseCCS16              1533-1536
 I10_HOSPBRTH                 1537-1539
 I10_NCHRONIC                 1540-1542
 I10_NDX                      1543-1545
 I10_NECAUSE                  1546-1547
 I10_NEOMAT                   1548-1549
 I10_NPR                      1550-1552
 I10_ORPROC                   1553-1554
 I10_PR1                      1555-1561 (A)
 I10_PR2                      1562-1568 (A)
 I10_PR3                      1569-1575 (A)
 I10_PR4                      1576-1582 (A)
 I10_PR5                      1583-1589 (A)
 I10_PR6                      1590-1596 (A)
 I10_PR7                      1597-1603 (A)
 I10_PR8                      1604-1610 (A)
 I10_PR9                      1611-1617 (A)
 I10_PR10                     1618-1624 (A)
 I10_PR11                     1625-1631 (A)
 I10_PR12                     1632-1638 (A)
 I10_PR13                     1639-1645 (A)
 I10_PR14                     1646-1652 (A)
 I10_PR15                     1653-1659 (A)
 I10_PR16                     1660-1666 (A)
 I10_PR17                     1667-1673 (A)
 I10_PR18                     1674-1680 (A)
 I10_PR19                     1681-1687 (A)
 I10_PR20                     1688-1694 (A)
 I10_PR21                     1695-1701 (A)
 I10_PRCCS1                   1702-1704
 I10_PRCCS2                   1705-1707
 I10_PRCCS3                   1708-1710
 I10_PRCCS4                   1711-1713
 I10_PRCCS5                   1714-1716
 I10_PRCCS6                   1717-1719
 I10_PRCCS7                   1720-1722
 I10_PRCCS8                   1723-1725
 I10_PRCCS9                   1726-1728
 I10_PRCCS10                  1729-1731
 I10_PRCCS11                  1732-1734
 I10_PRCCS12                  1735-1737
 I10_PRCCS13                  1738-1740
 I10_PRCCS14                  1741-1743
 I10_PRCCS15                  1744-1746
 I10_PRCCS16                  1747-1749
 I10_PRCCS17                  1750-1752
 I10_PRCCS18                  1753-1755
 I10_PRCCS19                  1756-1758
 I10_PRCCS20                  1759-1761
 I10_PRCCS21                  1762-1764
 I10_PROCTYPE                 1765-1767
 I10_SERVICELINE              1768-1769
 KEY                          1770-1784
 LOS                          1785-1789
 LOS_X                        1790-1795
 MARITALSTATUS_X              1796     (A)
 MARITALSTATUSUB04            1797     (A)
 MDC                          1798-1799
 MDC_NoPOA                    1800-1801
 MDC32                        1802-1803
 MDNUM1_R                     1804-1812
 MDNUM2_R                     1813-1821
 MDNUM3_R                     1822-1830
 MDNUM4_R                     1831-1839
 MDNUMTYPE1                   1840     (A)
 MEDINCSTQ                    1841-1842
 MRN_R                        1843-1851
 NCPT                         1852-1855
 OS_TIME                      1856-1866
 P7EDSRC_X                    1867-1868 (A)
 PAY1                         1869-1870
 PAY1_X                       1871     (A)
 PAY2                         1872-1873
 PAY2_X                       1874     (A)
 PAY3                         1875-1876
 PAY3_X                       1877     (A)
 PL_CBSA                      1878-1880
 PL_NCHS                      1881-1882
 PL_RUCC                      1883-1884
 PL_UIC                       1885-1886
 PL_UR_CAT4                   1887-1888
 POA_Disch_Edit1              1889-1890
 POA_Disch_Edit2              1891-1892
 POA_Hosp_Edit1               1893-1894
 POA_Hosp_Edit2               1895-1896
 POA_Hosp_Edit3               1897-1898
 POA_Hosp_Edit3_Value         1899-1906
 PointOfOrigin_X              1907     (A)
 PointOfOriginUB04            1908     (A)
 PRDAY1                       1909-1913
 PRDAY2                       1914-1918
 PRDAY3                       1919-1923
 PRDAY4                       1924-1928
 PRDAY5                       1929-1933
 PRDAY6                       1934-1938
 PRDAY7                       1939-1943
 PRDAY8                       1944-1948
 PRDAY9                       1949-1953
 PRDAY10                      1954-1958
 PRDAY11                      1959-1963
 PRDAY12                      1964-1968
 PRDAY13                      1969-1973
 PRDAY14                      1974-1978
 PRDAY15                      1979-1983
 PRDAY16                      1984-1988
 PRDAY17                      1989-1993
 PRDAY18                      1994-1998
 PRDAY19                      1999-2003
 PRDAY20                      2004-2008
 PRDAY21                      2009-2013
 PRVER                        2014-2016
 PSTATE                       2017-2018 (A)
 PSTCO2                       2019-2023
 RACE                         2024-2025
 RACE_X                       2026     (A)
 TOTCHG                       2027-2036
 TOTCHG_X                     2037-2051
 TRAN_IN                      2052-2053
 TRAN_OUT                     2054-2055
 VisitLink                    2056-2064
 YEAR                         2065-2068
 ZIP                          2069-2073 (A)
 ZIP3                         2074-2076 (A)
 ZIPINC_QRTL                  2077-2079
 AYEAR                        2080-2083
 BMONTH                       2084-2085
 BYEAR                        2086-2089
 PRMONTH1                     2090-2091
 PRMONTH2                     2092-2093
 PRMONTH3                     2094-2095
 PRMONTH4                     2096-2097
 PRMONTH5                     2098-2099
 PRMONTH6                     2100-2101
 PRYEAR1                      2102-2105
 PRYEAR2                      2106-2109
 PRYEAR3                      2110-2113
 PRYEAR4                      2114-2117
 PRYEAR5                      2118-2121
 PRYEAR6                      2122-2125.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 APGAR1                       (F3.0) /
 APGAR5                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTCCS77                     (F4.0) /
 CPTCCS78                     (F4.0) /
 CPTCCS79                     (F4.0) /
 CPTCCS80                     (F4.0) /
 CPTCCS81                     (F4.0) /
 CPTCCS82                     (F4.0) /
 CPTCCS83                     (F4.0) /
 CPTCCS84                     (F4.0) /
 CPTCCS85                     (F4.0) /
 CPTCCS86                     (F4.0) /
 CPTCCS87                     (F4.0) /
 CPTCCS88                     (F4.0) /
 CPTCCS89                     (F4.0) /
 CPTCCS90                     (F4.0) /
 CPTCCS91                     (F4.0) /
 CPTCCS92                     (F4.0) /
 CPTCCS93                     (F4.0) /
 CPTCCS94                     (F4.0) /
 CPTCCS95                     (F4.0) /
 CPTCCS96                     (F4.0) /
 CPTCCS97                     (F4.0) /
 CPTCCS98                     (F4.0) /
 CPTCCS99                     (F4.0) /
 CPTCCS100                    (F4.0) /
 CPTCCS101                    (F4.0) /
 CPTCCS102                    (F4.0) /
 CPTCCS103                    (F4.0) /
 CPTCCS104                    (F4.0) /
 CPTCCS105                    (F4.0) /
 CPTCCS106                    (F4.0) /
 CPTCCS107                    (F4.0) /
 CPTCCS108                    (F4.0) /
 CPTCCS109                    (F4.0) /
 CPTCCS110                    (F4.0) /
 DaysToEvent                  (F8.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DNR                          (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRG32                        (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_DXCCS1                   (F4.0) /
 I10_DXCCS2                   (F4.0) /
 I10_DXCCS3                   (F4.0) /
 I10_DXCCS4                   (F4.0) /
 I10_DXCCS5                   (F4.0) /
 I10_DXCCS6                   (F4.0) /
 I10_DXCCS7                   (F4.0) /
 I10_DXCCS8                   (F4.0) /
 I10_DXCCS9                   (F4.0) /
 I10_DXCCS10                  (F4.0) /
 I10_DXCCS11                  (F4.0) /
 I10_DXCCS12                  (F4.0) /
 I10_DXCCS13                  (F4.0) /
 I10_DXCCS14                  (F4.0) /
 I10_DXCCS15                  (F4.0) /
 I10_DXCCS16                  (F4.0) /
 I10_DXCCS17                  (F4.0) /
 I10_DXCCS18                  (F4.0) /
 I10_DXCCS19                  (F4.0) /
 I10_DXCCS20                  (F4.0) /
 I10_DXCCS21                  (F4.0) /
 I10_DXCCS22                  (F4.0) /
 I10_DXCCS23                  (F4.0) /
 I10_DXCCS24                  (F4.0) /
 I10_DXCCS25                  (F4.0) /
 I10_DXCCS26                  (F4.0) /
 I10_DXCCS27                  (F4.0) /
 I10_DXCCS28                  (F4.0) /
 I10_DXCCS29                  (F4.0) /
 I10_DXCCS30                  (F4.0) /
 I10_ECauseCCS1               (F3.0) /
 I10_ECauseCCS2               (F3.0) /
 I10_ECauseCCS3               (F3.0) /
 I10_ECauseCCS4               (F3.0) /
 I10_ECauseCCS5               (F3.0) /
 I10_ECauseCCS6               (F3.0) /
 I10_ECauseCCS7               (F3.0) /
 I10_ECauseCCS8               (F3.0) /
 I10_ECauseCCS9               (F3.0) /
 I10_ECauseCCS10              (F3.0) /
 I10_ECauseCCS11              (F3.0) /
 I10_ECauseCCS12              (F3.0) /
 I10_ECauseCCS13              (F3.0) /
 I10_ECauseCCS14              (F3.0) /
 I10_ECauseCCS15              (F3.0) /
 I10_ECauseCCS16              (F3.0) /
 I10_HOSPBRTH                 (F3.0) /
 I10_NCHRONIC                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NEOMAT                   (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PRCCS1                   (F3.0) /
 I10_PRCCS2                   (F3.0) /
 I10_PRCCS3                   (F3.0) /
 I10_PRCCS4                   (F3.0) /
 I10_PRCCS5                   (F3.0) /
 I10_PRCCS6                   (F3.0) /
 I10_PRCCS7                   (F3.0) /
 I10_PRCCS8                   (F3.0) /
 I10_PRCCS9                   (F3.0) /
 I10_PRCCS10                  (F3.0) /
 I10_PRCCS11                  (F3.0) /
 I10_PRCCS12                  (F3.0) /
 I10_PRCCS13                  (F3.0) /
 I10_PRCCS14                  (F3.0) /
 I10_PRCCS15                  (F3.0) /
 I10_PRCCS16                  (F3.0) /
 I10_PRCCS17                  (F3.0) /
 I10_PRCCS18                  (F3.0) /
 I10_PRCCS19                  (F3.0) /
 I10_PRCCS20                  (F3.0) /
 I10_PRCCS21                  (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDC32                        (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 APGAR1                       "One-minute APGAR score"
 APGAR5                       "Five-minute APGAR score"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 BWT                          "Birth weight in grams"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPT77                        "CPT/HCPCS procedure code 77"
 CPT78                        "CPT/HCPCS procedure code 78"
 CPT79                        "CPT/HCPCS procedure code 79"
 CPT80                        "CPT/HCPCS procedure code 80"
 CPT81                        "CPT/HCPCS procedure code 81"
 CPT82                        "CPT/HCPCS procedure code 82"
 CPT83                        "CPT/HCPCS procedure code 83"
 CPT84                        "CPT/HCPCS procedure code 84"
 CPT85                        "CPT/HCPCS procedure code 85"
 CPT86                        "CPT/HCPCS procedure code 86"
 CPT87                        "CPT/HCPCS procedure code 87"
 CPT88                        "CPT/HCPCS procedure code 88"
 CPT89                        "CPT/HCPCS procedure code 89"
 CPT90                        "CPT/HCPCS procedure code 90"
 CPT91                        "CPT/HCPCS procedure code 91"
 CPT92                        "CPT/HCPCS procedure code 92"
 CPT93                        "CPT/HCPCS procedure code 93"
 CPT94                        "CPT/HCPCS procedure code 94"
 CPT95                        "CPT/HCPCS procedure code 95"
 CPT96                        "CPT/HCPCS procedure code 96"
 CPT97                        "CPT/HCPCS procedure code 97"
 CPT98                        "CPT/HCPCS procedure code 98"
 CPT99                        "CPT/HCPCS procedure code 99"
 CPT100                       "CPT/HCPCS procedure code 100"
 CPT101                       "CPT/HCPCS procedure code 101"
 CPT102                       "CPT/HCPCS procedure code 102"
 CPT103                       "CPT/HCPCS procedure code 103"
 CPT104                       "CPT/HCPCS procedure code 104"
 CPT105                       "CPT/HCPCS procedure code 105"
 CPT106                       "CPT/HCPCS procedure code 106"
 CPT107                       "CPT/HCPCS procedure code 107"
 CPT108                       "CPT/HCPCS procedure code 108"
 CPT109                       "CPT/HCPCS procedure code 109"
 CPT110                       "CPT/HCPCS procedure code 110"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTCCS77                     "CCS: CPT 77"
 CPTCCS78                     "CCS: CPT 78"
 CPTCCS79                     "CCS: CPT 79"
 CPTCCS80                     "CCS: CPT 80"
 CPTCCS81                     "CCS: CPT 81"
 CPTCCS82                     "CCS: CPT 82"
 CPTCCS83                     "CCS: CPT 83"
 CPTCCS84                     "CCS: CPT 84"
 CPTCCS85                     "CCS: CPT 85"
 CPTCCS86                     "CCS: CPT 86"
 CPTCCS87                     "CCS: CPT 87"
 CPTCCS88                     "CCS: CPT 88"
 CPTCCS89                     "CCS: CPT 89"
 CPTCCS90                     "CCS: CPT 90"
 CPTCCS91                     "CCS: CPT 91"
 CPTCCS92                     "CCS: CPT 92"
 CPTCCS93                     "CCS: CPT 93"
 CPTCCS94                     "CCS: CPT 94"
 CPTCCS95                     "CCS: CPT 95"
 CPTCCS96                     "CCS: CPT 96"
 CPTCCS97                     "CCS: CPT 97"
 CPTCCS98                     "CCS: CPT 98"
 CPTCCS99                     "CCS: CPT 99"
 CPTCCS100                    "CCS: CPT 100"
 CPTCCS101                    "CCS: CPT 101"
 CPTCCS102                    "CCS: CPT 102"
 CPTCCS103                    "CCS: CPT 103"
 CPTCCS104                    "CCS: CPT 104"
 CPTCCS105                    "CCS: CPT 105"
 CPTCCS106                    "CCS: CPT 106"
 CPTCCS107                    "CCS: CPT 107"
 CPTCCS108                    "CCS: CPT 108"
 CPTCCS109                    "CCS: CPT 109"
 CPTCCS110                    "CCS: CPT 110"
 DaysToEvent                  "Days from 'start date' to admission"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DNR                          "Do not resuscitate indicator"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRG32                        "DRG, version 32"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "E Cause 1, present on admission indicator"
 E_POA2                       "E Cause 2, present on admission indicator"
 E_POA3                       "E Cause 3, present on admission indicator"
 E_POA4                       "E Cause 4, present on admission indicator"
 E_POA5                       "E Cause 5, present on admission indicator"
 E_POA6                       "E Cause 6, present on admission indicator"
 E_POA7                       "E Cause 7, present on admission indicator"
 E_POA8                       "E Cause 8, present on admission indicator"
 E_POA9                       "E Cause 9, present on admission indicator"
 E_POA10                      "E Cause 10, present on admission indicator"
 E_POA11                      "E Cause 11, present on admission indicator"
 E_POA12                      "E Cause 12, present on admission indicator"
 E_POA13                      "E Cause 13, present on admission indicator"
 E_POA14                      "E Cause 14, present on admission indicator"
 E_POA15                      "E Cause 15, present on admission indicator"
 E_POA16                      "E Cause 16, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DXCCS1                   "ICD-10-CM CCS: diagnosis 1"
 I10_DXCCS2                   "ICD-10-CM CCS: diagnosis 2"
 I10_DXCCS3                   "ICD-10-CM CCS: diagnosis 3"
 I10_DXCCS4                   "ICD-10-CM CCS: diagnosis 4"
 I10_DXCCS5                   "ICD-10-CM CCS: diagnosis 5"
 I10_DXCCS6                   "ICD-10-CM CCS: diagnosis 6"
 I10_DXCCS7                   "ICD-10-CM CCS: diagnosis 7"
 I10_DXCCS8                   "ICD-10-CM CCS: diagnosis 8"
 I10_DXCCS9                   "ICD-10-CM CCS: diagnosis 9"
 I10_DXCCS10                  "ICD-10-CM CCS: diagnosis 10"
 I10_DXCCS11                  "ICD-10-CM CCS: diagnosis 11"
 I10_DXCCS12                  "ICD-10-CM CCS: diagnosis 12"
 I10_DXCCS13                  "ICD-10-CM CCS: diagnosis 13"
 I10_DXCCS14                  "ICD-10-CM CCS: diagnosis 14"
 I10_DXCCS15                  "ICD-10-CM CCS: diagnosis 15"
 I10_DXCCS16                  "ICD-10-CM CCS: diagnosis 16"
 I10_DXCCS17                  "ICD-10-CM CCS: diagnosis 17"
 I10_DXCCS18                  "ICD-10-CM CCS: diagnosis 18"
 I10_DXCCS19                  "ICD-10-CM CCS: diagnosis 19"
 I10_DXCCS20                  "ICD-10-CM CCS: diagnosis 20"
 I10_DXCCS21                  "ICD-10-CM CCS: diagnosis 21"
 I10_DXCCS22                  "ICD-10-CM CCS: diagnosis 22"
 I10_DXCCS23                  "ICD-10-CM CCS: diagnosis 23"
 I10_DXCCS24                  "ICD-10-CM CCS: diagnosis 24"
 I10_DXCCS25                  "ICD-10-CM CCS: diagnosis 25"
 I10_DXCCS26                  "ICD-10-CM CCS: diagnosis 26"
 I10_DXCCS27                  "ICD-10-CM CCS: diagnosis 27"
 I10_DXCCS28                  "ICD-10-CM CCS: diagnosis 28"
 I10_DXCCS29                  "ICD-10-CM CCS: diagnosis 29"
 I10_DXCCS30                  "ICD-10-CM CCS: diagnosis 30"
 I10_ECAUSE1                  "ICD-10-CM E Cause 1"
 I10_ECAUSE2                  "ICD-10-CM E Cause 2"
 I10_ECAUSE3                  "ICD-10-CM E Cause 3"
 I10_ECAUSE4                  "ICD-10-CM E Cause 4"
 I10_ECAUSE5                  "ICD-10-CM E Cause 5"
 I10_ECAUSE6                  "ICD-10-CM E Cause 6"
 I10_ECAUSE7                  "ICD-10-CM E Cause 7"
 I10_ECAUSE8                  "ICD-10-CM E Cause 8"
 I10_ECAUSE9                  "ICD-10-CM E Cause 9"
 I10_ECAUSE10                 "ICD-10-CM E Cause 10"
 I10_ECAUSE11                 "ICD-10-CM E Cause 11"
 I10_ECAUSE12                 "ICD-10-CM E Cause 12"
 I10_ECAUSE13                 "ICD-10-CM E Cause 13"
 I10_ECAUSE14                 "ICD-10-CM E Cause 14"
 I10_ECAUSE15                 "ICD-10-CM E Cause 15"
 I10_ECAUSE16                 "ICD-10-CM E Cause 16"
 I10_ECauseCCS1               "ICD-10-CM CCS: E Cause 1"
 I10_ECauseCCS2               "ICD-10-CM CCS: E Cause 2"
 I10_ECauseCCS3               "ICD-10-CM CCS: E Cause 3"
 I10_ECauseCCS4               "ICD-10-CM CCS: E Cause 4"
 I10_ECauseCCS5               "ICD-10-CM CCS: E Cause 5"
 I10_ECauseCCS6               "ICD-10-CM CCS: E Cause 6"
 I10_ECauseCCS7               "ICD-10-CM CCS: E Cause 7"
 I10_ECauseCCS8               "ICD-10-CM CCS: E Cause 8"
 I10_ECauseCCS9               "ICD-10-CM CCS: E Cause 9"
 I10_ECauseCCS10              "ICD-10-CM CCS: E Cause 10"
 I10_ECauseCCS11              "ICD-10-CM CCS: E Cause 11"
 I10_ECauseCCS12              "ICD-10-CM CCS: E Cause 12"
 I10_ECauseCCS13              "ICD-10-CM CCS: E Cause 13"
 I10_ECauseCCS14              "ICD-10-CM CCS: E Cause 14"
 I10_ECauseCCS15              "ICD-10-CM CCS: E Cause 15"
 I10_ECauseCCS16              "ICD-10-CM CCS: E Cause 16"
 I10_HOSPBRTH                 "ICD-10-CM Indicator of birth in this hospital"
 I10_NCHRONIC                 "ICD-10-CM Number of chronic conditions"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of E Causes on this record"
 I10_NEOMAT                   "ICD-10-CM/PCS Neonatal and/or maternal I10_DX and/or I10_PR"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PRCCS1                   "ICD-10-PCS CCS: procedure 1"
 I10_PRCCS2                   "ICD-10-PCS CCS: procedure 2"
 I10_PRCCS3                   "ICD-10-PCS CCS: procedure 3"
 I10_PRCCS4                   "ICD-10-PCS CCS: procedure 4"
 I10_PRCCS5                   "ICD-10-PCS CCS: procedure 5"
 I10_PRCCS6                   "ICD-10-PCS CCS: procedure 6"
 I10_PRCCS7                   "ICD-10-PCS CCS: procedure 7"
 I10_PRCCS8                   "ICD-10-PCS CCS: procedure 8"
 I10_PRCCS9                   "ICD-10-PCS CCS: procedure 9"
 I10_PRCCS10                  "ICD-10-PCS CCS: procedure 10"
 I10_PRCCS11                  "ICD-10-PCS CCS: procedure 11"
 I10_PRCCS12                  "ICD-10-PCS CCS: procedure 12"
 I10_PRCCS13                  "ICD-10-PCS CCS: procedure 13"
 I10_PRCCS14                  "ICD-10-PCS CCS: procedure 14"
 I10_PRCCS15                  "ICD-10-PCS CCS: procedure 15"
 I10_PRCCS16                  "ICD-10-PCS CCS: procedure 16"
 I10_PRCCS17                  "ICD-10-PCS CCS: procedure 17"
 I10_PRCCS18                  "ICD-10-PCS CCS: procedure 18"
 I10_PRCCS19                  "ICD-10-PCS CCS: procedure 19"
 I10_PRCCS20                  "ICD-10-PCS CCS: procedure 20"
 I10_PRCCS21                  "ICD-10-PCS CCS: procedure 21"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDC32                        "MDC, version 32"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MDNUMTYPE1                   "Physician 1 number type"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OS_TIME                      "Observation stay time summed from UNITS"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE APGAR1
 (-9,-8,-6,-5=SYSMIS).
RECODE APGAR5
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS101
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS102
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS103
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS104
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS105
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS106
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS107
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS108
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS109
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS110
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG32
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC32
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'AR_SID_2015q4_CORE.SAV' /COMPRESSED.
