/*******************************************************************
* Creation Date: 10/05/2016   
*   AR_SID_2014_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'AR_SID_2014_CHGS.ASC' FIXED SKIP=2 / 
 CHARGE                          1-  12
 KEY                            13-  27
 RATE                           28-  36
 REVCODE                        37-  40 (A)
 UNITS                          41-  51.


***  Specify write formats  ***.
FORMATS
 CHARGE                       (F6.2) /
 KEY                          (F8.0) /
 RATE                         (F5.2) /
 UNITS                        (F4.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHARGE                       "Line item charges (as received from source)"
 KEY                          "HCUP record identifier"
 RATE                         "Line item rate (as received from source)"
 REVCODE                      "Line item revenue code (as received from source)"
 UNITS                        "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE RATE
 (-99999.99,-88888.88,-66666.66,-55555.55=SYSMIS).
RECODE UNITS
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).



SAVE OUTFILE = 'AR_SID_2014_CHGS.SAV' /COMPRESSED.
