/*******************************************************************
* Creation Date: 03/03/2017   
*   WI_SEDD_2015q4_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'WI_SEDD_2015q4_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BILLTYPE                       16-  19 (A)
 CPT1                           20-  24 (A)
 CPT2                           25-  29 (A)
 CPT3                           30-  34 (A)
 CPT4                           35-  39 (A)
 CPT5                           40-  44 (A)
 CPT6                           45-  49 (A)
 CPT7                           50-  54 (A)
 CPT8                           55-  59 (A)
 CPT9                           60-  64 (A)
 CPT10                          65-  69 (A)
 CPT11                          70-  74 (A)
 CPT12                          75-  79 (A)
 CPT13                          80-  84 (A)
 CPT14                          85-  89 (A)
 CPT15                          90-  94 (A)
 CPT16                          95-  99 (A)
 CPT17                         100- 104 (A)
 CPT18                         105- 109 (A)
 CPT19                         110- 114 (A)
 CPT20                         115- 119 (A)
 CPT21                         120- 124 (A)
 CPT22                         125- 129 (A)
 CPT23                         130- 134 (A)
 CPT24                         135- 139 (A)
 CPT25                         140- 144 (A)
 CPT26                         145- 149 (A)
 CPT27                         150- 154 (A)
 CPT28                         155- 159 (A)
 CPT29                         160- 164 (A)
 CPT30                         165- 169 (A)
 CPT31                         170- 174 (A)
 CPT32                         175- 179 (A)
 CPT33                         180- 184 (A)
 CPT34                         185- 189 (A)
 CPT35                         190- 194 (A)
 CPT36                         195- 199 (A)
 CPT37                         200- 204 (A)
 CPT38                         205- 209 (A)
 CPT39                         210- 214 (A)
 CPT40                         215- 219 (A)
 CPT41                         220- 224 (A)
 CPT42                         225- 229 (A)
 CPT43                         230- 234 (A)
 CPT44                         235- 239 (A)
 CPT45                         240- 244 (A)
 CPT46                         245- 249 (A)
 CPT47                         250- 254 (A)
 CPT48                         255- 259 (A)
 CPT49                         260- 264 (A)
 CPT50                         265- 269 (A)
 CPTCCS1                       270- 272
 CPTCCS2                       273- 275
 CPTCCS3                       276- 278
 CPTCCS4                       279- 281
 CPTCCS5                       282- 284
 CPTCCS6                       285- 287
 CPTCCS7                       288- 290
 CPTCCS8                       291- 293
 CPTCCS9                       294- 296
 CPTCCS10                      297- 299
 CPTCCS11                      300- 302
 CPTCCS12                      303- 305
 CPTCCS13                      306- 308
 CPTCCS14                      309- 311
 CPTCCS15                      312- 314
 CPTCCS16                      315- 317
 CPTCCS17                      318- 320
 CPTCCS18                      321- 323
 CPTCCS19                      324- 326
 CPTCCS20                      327- 329
 CPTCCS21                      330- 332
 CPTCCS22                      333- 335
 CPTCCS23                      336- 338
 CPTCCS24                      339- 341
 CPTCCS25                      342- 344
 CPTCCS26                      345- 347
 CPTCCS27                      348- 350
 CPTCCS28                      351- 353
 CPTCCS29                      354- 356
 CPTCCS30                      357- 359
 CPTCCS31                      360- 362
 CPTCCS32                      363- 365
 CPTCCS33                      366- 368
 CPTCCS34                      369- 371
 CPTCCS35                      372- 374
 CPTCCS36                      375- 377
 CPTCCS37                      378- 380
 CPTCCS38                      381- 383
 CPTCCS39                      384- 386
 CPTCCS40                      387- 389
 CPTCCS41                      390- 392
 CPTCCS42                      393- 395
 CPTCCS43                      396- 398
 CPTCCS44                      399- 401
 CPTCCS45                      402- 404
 CPTCCS46                      405- 407
 CPTCCS47                      408- 410
 CPTCCS48                      411- 413
 CPTCCS49                      414- 416
 CPTCCS50                      417- 419
 CPTM1_1                       420- 421 (A)
 CPTM1_2                       422- 423 (A)
 CPTM1_3                       424- 425 (A)
 CPTM1_4                       426- 427 (A)
 CPTM1_5                       428- 429 (A)
 CPTM1_6                       430- 431 (A)
 CPTM1_7                       432- 433 (A)
 CPTM1_8                       434- 435 (A)
 CPTM1_9                       436- 437 (A)
 CPTM1_10                      438- 439 (A)
 CPTM1_11                      440- 441 (A)
 CPTM1_12                      442- 443 (A)
 CPTM1_13                      444- 445 (A)
 CPTM1_14                      446- 447 (A)
 CPTM1_15                      448- 449 (A)
 CPTM1_16                      450- 451 (A)
 CPTM1_17                      452- 453 (A)
 CPTM1_18                      454- 455 (A)
 CPTM1_19                      456- 457 (A)
 CPTM1_20                      458- 459 (A)
 CPTM1_21                      460- 461 (A)
 CPTM1_22                      462- 463 (A)
 CPTM1_23                      464- 465 (A)
 CPTM1_24                      466- 467 (A)
 CPTM1_25                      468- 469 (A)
 CPTM1_26                      470- 471 (A)
 CPTM1_27                      472- 473 (A)
 CPTM1_28                      474- 475 (A)
 CPTM1_29                      476- 477 (A)
 CPTM1_30                      478- 479 (A)
 CPTM1_31                      480- 481 (A)
 CPTM1_32                      482- 483 (A)
 CPTM1_33                      484- 485 (A)
 CPTM1_34                      486- 487 (A)
 CPTM1_35                      488- 489 (A)
 CPTM1_36                      490- 491 (A)
 CPTM1_37                      492- 493 (A)
 CPTM1_38                      494- 495 (A)
 CPTM1_39                      496- 497 (A)
 CPTM1_40                      498- 499 (A)
 CPTM1_41                      500- 501 (A)
 CPTM1_42                      502- 503 (A)
 CPTM1_43                      504- 505 (A)
 CPTM1_44                      506- 507 (A)
 CPTM1_45                      508- 509 (A)
 CPTM1_46                      510- 511 (A)
 CPTM1_47                      512- 513 (A)
 CPTM1_48                      514- 515 (A)
 CPTM1_49                      516- 517 (A)
 CPTM1_50                      518- 519 (A)
 CPTM2_1                       520- 521 (A)
 CPTM2_2                       522- 523 (A)
 CPTM2_3                       524- 525 (A)
 CPTM2_4                       526- 527 (A)
 CPTM2_5                       528- 529 (A)
 CPTM2_6                       530- 531 (A)
 CPTM2_7                       532- 533 (A)
 CPTM2_8                       534- 535 (A)
 CPTM2_9                       536- 537 (A)
 CPTM2_10                      538- 539 (A)
 CPTM2_11                      540- 541 (A)
 CPTM2_12                      542- 543 (A)
 CPTM2_13                      544- 545 (A)
 CPTM2_14                      546- 547 (A)
 CPTM2_15                      548- 549 (A)
 CPTM2_16                      550- 551 (A)
 CPTM2_17                      552- 553 (A)
 CPTM2_18                      554- 555 (A)
 CPTM2_19                      556- 557 (A)
 CPTM2_20                      558- 559 (A)
 CPTM2_21                      560- 561 (A)
 CPTM2_22                      562- 563 (A)
 CPTM2_23                      564- 565 (A)
 CPTM2_24                      566- 567 (A)
 CPTM2_25                      568- 569 (A)
 CPTM2_26                      570- 571 (A)
 CPTM2_27                      572- 573 (A)
 CPTM2_28                      574- 575 (A)
 CPTM2_29                      576- 577 (A)
 CPTM2_30                      578- 579 (A)
 CPTM2_31                      580- 581 (A)
 CPTM2_32                      582- 583 (A)
 CPTM2_33                      584- 585 (A)
 CPTM2_34                      586- 587 (A)
 CPTM2_35                      588- 589 (A)
 CPTM2_36                      590- 591 (A)
 CPTM2_37                      592- 593 (A)
 CPTM2_38                      594- 595 (A)
 CPTM2_39                      596- 597 (A)
 CPTM2_40                      598- 599 (A)
 CPTM2_41                      600- 601 (A)
 CPTM2_42                      602- 603 (A)
 CPTM2_43                      604- 605 (A)
 CPTM2_44                      606- 607 (A)
 CPTM2_45                      608- 609 (A)
 CPTM2_46                      610- 611 (A)
 CPTM2_47                      612- 613 (A)
 CPTM2_48                      614- 615 (A)
 CPTM2_49                      616- 617 (A)
 CPTM2_50                      618- 619 (A)
 DaysToEvent                   620- 625
 DIED                          626- 627
 DISP_X                        628- 629 (A)
 DISPUB04                      630- 631
 DISPUNIFORM                   632- 633
 DMONTH                        634- 635
 DQTR                          636- 637
 DSHOSPID                      638- 654 (A)
 DXVER                         655- 657
 FEMALE                        658- 659
 HCUP_ED                       660- 661
 HCUP_OS                       662- 663
 HISPANIC                      664- 665
 HISPANIC_X                    666     (A)
 Homeless                      667- 668
 HOSP_NPI                      669- 678 (A)
 HOSPST                        679- 680 (A)
 I10_DX_Visit_Reason1          681- 687 (A)
 I10_DX_Visit_Reason2          688- 694 (A)
 I10_DX_Visit_Reason3          695- 701 (A)
 I10_DX1                       702- 708 (A)
 I10_DX2                       709- 715 (A)
 I10_DX3                       716- 722 (A)
 I10_DX4                       723- 729 (A)
 I10_DX5                       730- 736 (A)
 I10_DX6                       737- 743 (A)
 I10_DX7                       744- 750 (A)
 I10_DX8                       751- 757 (A)
 I10_DX9                       758- 764 (A)
 I10_DX10                      765- 771 (A)
 I10_DX11                      772- 778 (A)
 I10_DX12                      779- 785 (A)
 I10_DX13                      786- 792 (A)
 I10_DX14                      793- 799 (A)
 I10_DX15                      800- 806 (A)
 I10_DX16                      807- 813 (A)
 I10_DX17                      814- 820 (A)
 I10_DX18                      821- 827 (A)
 I10_DX19                      828- 834 (A)
 I10_DX20                      835- 841 (A)
 I10_DX21                      842- 848 (A)
 I10_DX22                      849- 855 (A)
 I10_DX23                      856- 862 (A)
 I10_DX24                      863- 869 (A)
 I10_DX25                      870- 876 (A)
 I10_DX26                      877- 883 (A)
 I10_DX27                      884- 890 (A)
 I10_DX28                      891- 897 (A)
 I10_DX29                      898- 904 (A)
 I10_DX30                      905- 911 (A)
 I10_DX31                      912- 918 (A)
 I10_DX32                      919- 925 (A)
 I10_DX33                      926- 932 (A)
 I10_DX34                      933- 939 (A)
 I10_DX35                      940- 946 (A)
 I10_DX36                      947- 953 (A)
 I10_DX37                      954- 960 (A)
 I10_DX38                      961- 967 (A)
 I10_DX39                      968- 974 (A)
 I10_DX40                      975- 981 (A)
 I10_DX41                      982- 988 (A)
 I10_DX42                      989- 995 (A)
 I10_DX43                      996-1002 (A)
 I10_DX44                     1003-1009 (A)
 I10_DX45                     1010-1016 (A)
 I10_DX46                     1017-1023 (A)
 I10_DX47                     1024-1030 (A)
 I10_DX48                     1031-1037 (A)
 I10_DX49                     1038-1044 (A)
 I10_DX50                     1045-1051 (A)
 I10_DXCCS1                   1052-1055
 I10_DXCCS2                   1056-1059
 I10_DXCCS3                   1060-1063
 I10_DXCCS4                   1064-1067
 I10_DXCCS5                   1068-1071
 I10_DXCCS6                   1072-1075
 I10_DXCCS7                   1076-1079
 I10_DXCCS8                   1080-1083
 I10_DXCCS9                   1084-1087
 I10_DXCCS10                  1088-1091
 I10_DXCCS11                  1092-1095
 I10_DXCCS12                  1096-1099
 I10_DXCCS13                  1100-1103
 I10_DXCCS14                  1104-1107
 I10_DXCCS15                  1108-1111
 I10_DXCCS16                  1112-1115
 I10_DXCCS17                  1116-1119
 I10_DXCCS18                  1120-1123
 I10_DXCCS19                  1124-1127
 I10_DXCCS20                  1128-1131
 I10_DXCCS21                  1132-1135
 I10_DXCCS22                  1136-1139
 I10_DXCCS23                  1140-1143
 I10_DXCCS24                  1144-1147
 I10_DXCCS25                  1148-1151
 I10_DXCCS26                  1152-1155
 I10_DXCCS27                  1156-1159
 I10_DXCCS28                  1160-1163
 I10_DXCCS29                  1164-1167
 I10_DXCCS30                  1168-1171
 I10_DXCCS31                  1172-1175
 I10_DXCCS32                  1176-1179
 I10_DXCCS33                  1180-1183
 I10_DXCCS34                  1184-1187
 I10_DXCCS35                  1188-1191
 I10_DXCCS36                  1192-1195
 I10_DXCCS37                  1196-1199
 I10_DXCCS38                  1200-1203
 I10_DXCCS39                  1204-1207
 I10_DXCCS40                  1208-1211
 I10_DXCCS41                  1212-1215
 I10_DXCCS42                  1216-1219
 I10_DXCCS43                  1220-1223
 I10_DXCCS44                  1224-1227
 I10_DXCCS45                  1228-1231
 I10_DXCCS46                  1232-1235
 I10_DXCCS47                  1236-1239
 I10_DXCCS48                  1240-1243
 I10_DXCCS49                  1244-1247
 I10_DXCCS50                  1248-1251
 I10_ECAUSE1                  1252-1258 (A)
 I10_ECAUSE2                  1259-1265 (A)
 I10_ECAUSE3                  1266-1272 (A)
 I10_ECAUSE4                  1273-1279 (A)
 I10_ECAUSE5                  1280-1286 (A)
 I10_ECAUSE6                  1287-1293 (A)
 I10_ECAUSE7                  1294-1300 (A)
 I10_ECAUSE8                  1301-1307 (A)
 I10_ECAUSE9                  1308-1314 (A)
 I10_ECAUSE10                 1315-1321 (A)
 I10_ECAUSE11                 1322-1328 (A)
 I10_ECauseCCS1               1329-1332
 I10_ECauseCCS2               1333-1336
 I10_ECauseCCS3               1337-1340
 I10_ECauseCCS4               1341-1344
 I10_ECauseCCS5               1345-1348
 I10_ECauseCCS6               1349-1352
 I10_ECauseCCS7               1353-1356
 I10_ECauseCCS8               1357-1360
 I10_ECauseCCS9               1361-1364
 I10_ECauseCCS10              1365-1368
 I10_ECauseCCS11              1369-1372
 I10_HOSPBRTH                 1373-1375
 I10_NCHRONIC                 1376-1378
 I10_NDX                      1379-1381
 I10_NECAUSE                  1382-1383
 I10_NEOMAT                   1384-1385
 I10_NPR                      1386-1388
 I10_ORPROC                   1389-1390
 I10_PR1                      1391-1397 (A)
 I10_PR2                      1398-1404 (A)
 I10_PR3                      1405-1411 (A)
 I10_PR4                      1412-1418 (A)
 I10_PR5                      1419-1425 (A)
 I10_PR6                      1426-1432 (A)
 I10_PR7                      1433-1439 (A)
 I10_PR8                      1440-1446 (A)
 I10_PR9                      1447-1453 (A)
 I10_PR10                     1454-1460 (A)
 I10_PR11                     1461-1467 (A)
 I10_PR12                     1468-1474 (A)
 I10_PR13                     1475-1481 (A)
 I10_PR14                     1482-1488 (A)
 I10_PR15                     1489-1495 (A)
 I10_PR16                     1496-1502 (A)
 I10_PR17                     1503-1509 (A)
 I10_PR18                     1510-1516 (A)
 I10_PR19                     1517-1523 (A)
 I10_PR20                     1524-1530 (A)
 I10_PR21                     1531-1537 (A)
 I10_PR22                     1538-1544 (A)
 I10_PR23                     1545-1551 (A)
 I10_PR24                     1552-1558 (A)
 I10_PR25                     1559-1565 (A)
 I10_PR26                     1566-1572 (A)
 I10_PR27                     1573-1579 (A)
 I10_PR28                     1580-1586 (A)
 I10_PR29                     1587-1593 (A)
 I10_PR30                     1594-1600 (A)
 I10_PR31                     1601-1607 (A)
 I10_PR32                     1608-1614 (A)
 I10_PR33                     1615-1621 (A)
 I10_PR34                     1622-1628 (A)
 I10_PR35                     1629-1635 (A)
 I10_PR36                     1636-1642 (A)
 I10_PR37                     1643-1649 (A)
 I10_PR38                     1650-1656 (A)
 I10_PR39                     1657-1663 (A)
 I10_PR40                     1664-1670 (A)
 I10_PR41                     1671-1677 (A)
 I10_PR42                     1678-1684 (A)
 I10_PR43                     1685-1691 (A)
 I10_PR44                     1692-1698 (A)
 I10_PR45                     1699-1705 (A)
 I10_PR46                     1706-1712 (A)
 I10_PR47                     1713-1719 (A)
 I10_PR48                     1720-1726 (A)
 I10_PR49                     1727-1733 (A)
 I10_PR50                     1734-1740 (A)
 I10_PRCCS1                   1741-1743
 I10_PRCCS2                   1744-1746
 I10_PRCCS3                   1747-1749
 I10_PRCCS4                   1750-1752
 I10_PRCCS5                   1753-1755
 I10_PRCCS6                   1756-1758
 I10_PRCCS7                   1759-1761
 I10_PRCCS8                   1762-1764
 I10_PRCCS9                   1765-1767
 I10_PRCCS10                  1768-1770
 I10_PRCCS11                  1771-1773
 I10_PRCCS12                  1774-1776
 I10_PRCCS13                  1777-1779
 I10_PRCCS14                  1780-1782
 I10_PRCCS15                  1783-1785
 I10_PRCCS16                  1786-1788
 I10_PRCCS17                  1789-1791
 I10_PRCCS18                  1792-1794
 I10_PRCCS19                  1795-1797
 I10_PRCCS20                  1798-1800
 I10_PRCCS21                  1801-1803
 I10_PRCCS22                  1804-1806
 I10_PRCCS23                  1807-1809
 I10_PRCCS24                  1810-1812
 I10_PRCCS25                  1813-1815
 I10_PRCCS26                  1816-1818
 I10_PRCCS27                  1819-1821
 I10_PRCCS28                  1822-1824
 I10_PRCCS29                  1825-1827
 I10_PRCCS30                  1828-1830
 I10_PRCCS31                  1831-1833
 I10_PRCCS32                  1834-1836
 I10_PRCCS33                  1837-1839
 I10_PRCCS34                  1840-1842
 I10_PRCCS35                  1843-1845
 I10_PRCCS36                  1846-1848
 I10_PRCCS37                  1849-1851
 I10_PRCCS38                  1852-1854
 I10_PRCCS39                  1855-1857
 I10_PRCCS40                  1858-1860
 I10_PRCCS41                  1861-1863
 I10_PRCCS42                  1864-1866
 I10_PRCCS43                  1867-1869
 I10_PRCCS44                  1870-1872
 I10_PRCCS45                  1873-1875
 I10_PRCCS46                  1876-1878
 I10_PRCCS47                  1879-1881
 I10_PRCCS48                  1882-1884
 I10_PRCCS49                  1885-1887
 I10_PRCCS50                  1888-1890
 I10_PROCTYPE                 1891-1893
 KEY                          1894-1908
 LOS                          1909-1913
 LOS_X                        1914-1919
 MDSPEC1                      1920-1922 (A)
 MDSPEC2                      1923-1925 (A)
 MEDINCSTQ                    1926-1927
 MRN_R                        1928-1936
 NCPT                         1937-1940
 OPservice                    1941     (A)
 OS_TIME                      1942-1952
 PAY1                         1953-1954
 PAY1_X                       1955-1959 (A)
 PAY2                         1960-1961
 PAY2_X                       1962-1966 (A)
 PL_CBSA                      1967-1969
 PL_NCHS                      1970-1971
 PL_RUCC                      1972-1973
 PL_UIC                       1974-1975
 PL_UR_CAT4                   1976-1977
 PointOfOrigin_X              1978     (A)
 PointOfOriginUB04            1979     (A)
 PRDAY1                       1980-1984
 PRVER                        1985-1987
 PSTATE                       1988-1989 (A)
 PSTCO2                       1990-1994
 RACE                         1995-1996
 RACE_X                       1997-1998 (A)
 STATE_AS                     1999-2000
 STATE_ED                     2001-2002
 STATE_OS                     2003-2004
 TOTCHG                       2005-2014
 TOTCHG_X                     2015-2029
 VisitLink                    2030-2038
 YEAR                         2039-2042
 ZIP                          2043-2047 (A)
 ZIP3                         2048-2050 (A)
 ZIPINC_QRTL                  2051-2053
 AYEAR                        2054-2057
 BMONTH                       2058-2059
 BYEAR                        2060-2063
 PRMONTH1                     2064-2065
 PRYEAR1                      2066-2069.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 Homeless                     (F3.0) /
 I10_DXCCS1                   (F4.0) /
 I10_DXCCS2                   (F4.0) /
 I10_DXCCS3                   (F4.0) /
 I10_DXCCS4                   (F4.0) /
 I10_DXCCS5                   (F4.0) /
 I10_DXCCS6                   (F4.0) /
 I10_DXCCS7                   (F4.0) /
 I10_DXCCS8                   (F4.0) /
 I10_DXCCS9                   (F4.0) /
 I10_DXCCS10                  (F4.0) /
 I10_DXCCS11                  (F4.0) /
 I10_DXCCS12                  (F4.0) /
 I10_DXCCS13                  (F4.0) /
 I10_DXCCS14                  (F4.0) /
 I10_DXCCS15                  (F4.0) /
 I10_DXCCS16                  (F4.0) /
 I10_DXCCS17                  (F4.0) /
 I10_DXCCS18                  (F4.0) /
 I10_DXCCS19                  (F4.0) /
 I10_DXCCS20                  (F4.0) /
 I10_DXCCS21                  (F4.0) /
 I10_DXCCS22                  (F4.0) /
 I10_DXCCS23                  (F4.0) /
 I10_DXCCS24                  (F4.0) /
 I10_DXCCS25                  (F4.0) /
 I10_DXCCS26                  (F4.0) /
 I10_DXCCS27                  (F4.0) /
 I10_DXCCS28                  (F4.0) /
 I10_DXCCS29                  (F4.0) /
 I10_DXCCS30                  (F4.0) /
 I10_DXCCS31                  (F4.0) /
 I10_DXCCS32                  (F4.0) /
 I10_DXCCS33                  (F4.0) /
 I10_DXCCS34                  (F4.0) /
 I10_DXCCS35                  (F4.0) /
 I10_DXCCS36                  (F4.0) /
 I10_DXCCS37                  (F4.0) /
 I10_DXCCS38                  (F4.0) /
 I10_DXCCS39                  (F4.0) /
 I10_DXCCS40                  (F4.0) /
 I10_DXCCS41                  (F4.0) /
 I10_DXCCS42                  (F4.0) /
 I10_DXCCS43                  (F4.0) /
 I10_DXCCS44                  (F4.0) /
 I10_DXCCS45                  (F4.0) /
 I10_DXCCS46                  (F4.0) /
 I10_DXCCS47                  (F4.0) /
 I10_DXCCS48                  (F4.0) /
 I10_DXCCS49                  (F4.0) /
 I10_DXCCS50                  (F4.0) /
 I10_ECauseCCS1               (F3.0) /
 I10_ECauseCCS2               (F3.0) /
 I10_ECauseCCS3               (F3.0) /
 I10_ECauseCCS4               (F3.0) /
 I10_ECauseCCS5               (F3.0) /
 I10_ECauseCCS6               (F3.0) /
 I10_ECauseCCS7               (F3.0) /
 I10_ECauseCCS8               (F3.0) /
 I10_ECauseCCS9               (F3.0) /
 I10_ECauseCCS10              (F3.0) /
 I10_ECauseCCS11              (F3.0) /
 I10_HOSPBRTH                 (F3.0) /
 I10_NCHRONIC                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NEOMAT                   (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PRCCS1                   (F3.0) /
 I10_PRCCS2                   (F3.0) /
 I10_PRCCS3                   (F3.0) /
 I10_PRCCS4                   (F3.0) /
 I10_PRCCS5                   (F3.0) /
 I10_PRCCS6                   (F3.0) /
 I10_PRCCS7                   (F3.0) /
 I10_PRCCS8                   (F3.0) /
 I10_PRCCS9                   (F3.0) /
 I10_PRCCS10                  (F3.0) /
 I10_PRCCS11                  (F3.0) /
 I10_PRCCS12                  (F3.0) /
 I10_PRCCS13                  (F3.0) /
 I10_PRCCS14                  (F3.0) /
 I10_PRCCS15                  (F3.0) /
 I10_PRCCS16                  (F3.0) /
 I10_PRCCS17                  (F3.0) /
 I10_PRCCS18                  (F3.0) /
 I10_PRCCS19                  (F3.0) /
 I10_PRCCS20                  (F3.0) /
 I10_PRCCS21                  (F3.0) /
 I10_PRCCS22                  (F3.0) /
 I10_PRCCS23                  (F3.0) /
 I10_PRCCS24                  (F3.0) /
 I10_PRCCS25                  (F3.0) /
 I10_PRCCS26                  (F3.0) /
 I10_PRCCS27                  (F3.0) /
 I10_PRCCS28                  (F3.0) /
 I10_PRCCS29                  (F3.0) /
 I10_PRCCS30                  (F3.0) /
 I10_PRCCS31                  (F3.0) /
 I10_PRCCS32                  (F3.0) /
 I10_PRCCS33                  (F3.0) /
 I10_PRCCS34                  (F3.0) /
 I10_PRCCS35                  (F3.0) /
 I10_PRCCS36                  (F3.0) /
 I10_PRCCS37                  (F3.0) /
 I10_PRCCS38                  (F3.0) /
 I10_PRCCS39                  (F3.0) /
 I10_PRCCS40                  (F3.0) /
 I10_PRCCS41                  (F3.0) /
 I10_PRCCS42                  (F3.0) /
 I10_PRCCS43                  (F3.0) /
 I10_PRCCS44                  (F3.0) /
 I10_PRCCS45                  (F3.0) /
 I10_PRCCS46                  (F3.0) /
 I10_PRCCS47                  (F3.0) /
 I10_PRCCS48                  (F3.0) /
 I10_PRCCS49                  (F3.0) /
 I10_PRCCS50                  (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRDAY1                       (F4.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRYEAR1                      (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM1_7                      "First CPT-4/HCPCS modifier 7"
 CPTM1_8                      "First CPT-4/HCPCS modifier 8"
 CPTM1_9                      "First CPT-4/HCPCS modifier 9"
 CPTM1_10                     "First CPT-4/HCPCS modifier 10"
 CPTM1_11                     "First CPT-4/HCPCS modifier 11"
 CPTM1_12                     "First CPT-4/HCPCS modifier 12"
 CPTM1_13                     "First CPT-4/HCPCS modifier 13"
 CPTM1_14                     "First CPT-4/HCPCS modifier 14"
 CPTM1_15                     "First CPT-4/HCPCS modifier 15"
 CPTM1_16                     "First CPT-4/HCPCS modifier 16"
 CPTM1_17                     "First CPT-4/HCPCS modifier 17"
 CPTM1_18                     "First CPT-4/HCPCS modifier 18"
 CPTM1_19                     "First CPT-4/HCPCS modifier 19"
 CPTM1_20                     "First CPT-4/HCPCS modifier 20"
 CPTM1_21                     "First CPT-4/HCPCS modifier 21"
 CPTM1_22                     "First CPT-4/HCPCS modifier 22"
 CPTM1_23                     "First CPT-4/HCPCS modifier 23"
 CPTM1_24                     "First CPT-4/HCPCS modifier 24"
 CPTM1_25                     "First CPT-4/HCPCS modifier 25"
 CPTM1_26                     "First CPT-4/HCPCS modifier 26"
 CPTM1_27                     "First CPT-4/HCPCS modifier 27"
 CPTM1_28                     "First CPT-4/HCPCS modifier 28"
 CPTM1_29                     "First CPT-4/HCPCS modifier 29"
 CPTM1_30                     "First CPT-4/HCPCS modifier 30"
 CPTM1_31                     "First CPT-4/HCPCS modifier 31"
 CPTM1_32                     "First CPT-4/HCPCS modifier 32"
 CPTM1_33                     "First CPT-4/HCPCS modifier 33"
 CPTM1_34                     "First CPT-4/HCPCS modifier 34"
 CPTM1_35                     "First CPT-4/HCPCS modifier 35"
 CPTM1_36                     "First CPT-4/HCPCS modifier 36"
 CPTM1_37                     "First CPT-4/HCPCS modifier 37"
 CPTM1_38                     "First CPT-4/HCPCS modifier 38"
 CPTM1_39                     "First CPT-4/HCPCS modifier 39"
 CPTM1_40                     "First CPT-4/HCPCS modifier 40"
 CPTM1_41                     "First CPT-4/HCPCS modifier 41"
 CPTM1_42                     "First CPT-4/HCPCS modifier 42"
 CPTM1_43                     "First CPT-4/HCPCS modifier 43"
 CPTM1_44                     "First CPT-4/HCPCS modifier 44"
 CPTM1_45                     "First CPT-4/HCPCS modifier 45"
 CPTM1_46                     "First CPT-4/HCPCS modifier 46"
 CPTM1_47                     "First CPT-4/HCPCS modifier 47"
 CPTM1_48                     "First CPT-4/HCPCS modifier 48"
 CPTM1_49                     "First CPT-4/HCPCS modifier 49"
 CPTM1_50                     "First CPT-4/HCPCS modifier 50"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                      "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                      "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                      "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                     "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                     "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                     "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                     "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                     "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                     "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                     "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                     "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                     "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                     "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                     "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                     "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                     "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                     "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                     "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                     "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                     "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                     "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                     "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                     "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                     "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                     "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                     "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                     "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                     "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                     "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                     "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                     "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                     "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                     "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                     "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                     "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                     "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                     "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                     "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                     "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                     "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                     "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                     "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                     "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                     "Second CPT-4/HCPCS modifier 50"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DSHOSPID                     "Data source hospital identifier"
 DXVER                        "Diagnosis Version"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 Homeless                     "Indicator that patient is homeless"
 HOSP_NPI                     "Hospital NPI"
 HOSPST                       "Hospital state postal code"
 I10_DX_Visit_Reason1         "ICD-10-CM Reason for visit diagnosis 1"
 I10_DX_Visit_Reason2         "ICD-10-CM Reason for visit diagnosis 2"
 I10_DX_Visit_Reason3         "ICD-10-CM Reason for visit diagnosis 3"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DXCCS1                   "ICD-10-CM CCS: diagnosis 1"
 I10_DXCCS2                   "ICD-10-CM CCS: diagnosis 2"
 I10_DXCCS3                   "ICD-10-CM CCS: diagnosis 3"
 I10_DXCCS4                   "ICD-10-CM CCS: diagnosis 4"
 I10_DXCCS5                   "ICD-10-CM CCS: diagnosis 5"
 I10_DXCCS6                   "ICD-10-CM CCS: diagnosis 6"
 I10_DXCCS7                   "ICD-10-CM CCS: diagnosis 7"
 I10_DXCCS8                   "ICD-10-CM CCS: diagnosis 8"
 I10_DXCCS9                   "ICD-10-CM CCS: diagnosis 9"
 I10_DXCCS10                  "ICD-10-CM CCS: diagnosis 10"
 I10_DXCCS11                  "ICD-10-CM CCS: diagnosis 11"
 I10_DXCCS12                  "ICD-10-CM CCS: diagnosis 12"
 I10_DXCCS13                  "ICD-10-CM CCS: diagnosis 13"
 I10_DXCCS14                  "ICD-10-CM CCS: diagnosis 14"
 I10_DXCCS15                  "ICD-10-CM CCS: diagnosis 15"
 I10_DXCCS16                  "ICD-10-CM CCS: diagnosis 16"
 I10_DXCCS17                  "ICD-10-CM CCS: diagnosis 17"
 I10_DXCCS18                  "ICD-10-CM CCS: diagnosis 18"
 I10_DXCCS19                  "ICD-10-CM CCS: diagnosis 19"
 I10_DXCCS20                  "ICD-10-CM CCS: diagnosis 20"
 I10_DXCCS21                  "ICD-10-CM CCS: diagnosis 21"
 I10_DXCCS22                  "ICD-10-CM CCS: diagnosis 22"
 I10_DXCCS23                  "ICD-10-CM CCS: diagnosis 23"
 I10_DXCCS24                  "ICD-10-CM CCS: diagnosis 24"
 I10_DXCCS25                  "ICD-10-CM CCS: diagnosis 25"
 I10_DXCCS26                  "ICD-10-CM CCS: diagnosis 26"
 I10_DXCCS27                  "ICD-10-CM CCS: diagnosis 27"
 I10_DXCCS28                  "ICD-10-CM CCS: diagnosis 28"
 I10_DXCCS29                  "ICD-10-CM CCS: diagnosis 29"
 I10_DXCCS30                  "ICD-10-CM CCS: diagnosis 30"
 I10_DXCCS31                  "ICD-10-CM CCS: diagnosis 31"
 I10_DXCCS32                  "ICD-10-CM CCS: diagnosis 32"
 I10_DXCCS33                  "ICD-10-CM CCS: diagnosis 33"
 I10_DXCCS34                  "ICD-10-CM CCS: diagnosis 34"
 I10_DXCCS35                  "ICD-10-CM CCS: diagnosis 35"
 I10_DXCCS36                  "ICD-10-CM CCS: diagnosis 36"
 I10_DXCCS37                  "ICD-10-CM CCS: diagnosis 37"
 I10_DXCCS38                  "ICD-10-CM CCS: diagnosis 38"
 I10_DXCCS39                  "ICD-10-CM CCS: diagnosis 39"
 I10_DXCCS40                  "ICD-10-CM CCS: diagnosis 40"
 I10_DXCCS41                  "ICD-10-CM CCS: diagnosis 41"
 I10_DXCCS42                  "ICD-10-CM CCS: diagnosis 42"
 I10_DXCCS43                  "ICD-10-CM CCS: diagnosis 43"
 I10_DXCCS44                  "ICD-10-CM CCS: diagnosis 44"
 I10_DXCCS45                  "ICD-10-CM CCS: diagnosis 45"
 I10_DXCCS46                  "ICD-10-CM CCS: diagnosis 46"
 I10_DXCCS47                  "ICD-10-CM CCS: diagnosis 47"
 I10_DXCCS48                  "ICD-10-CM CCS: diagnosis 48"
 I10_DXCCS49                  "ICD-10-CM CCS: diagnosis 49"
 I10_DXCCS50                  "ICD-10-CM CCS: diagnosis 50"
 I10_ECAUSE1                  "ICD-10-CM E Cause 1"
 I10_ECAUSE2                  "ICD-10-CM E Cause 2"
 I10_ECAUSE3                  "ICD-10-CM E Cause 3"
 I10_ECAUSE4                  "ICD-10-CM E Cause 4"
 I10_ECAUSE5                  "ICD-10-CM E Cause 5"
 I10_ECAUSE6                  "ICD-10-CM E Cause 6"
 I10_ECAUSE7                  "ICD-10-CM E Cause 7"
 I10_ECAUSE8                  "ICD-10-CM E Cause 8"
 I10_ECAUSE9                  "ICD-10-CM E Cause 9"
 I10_ECAUSE10                 "ICD-10-CM E Cause 10"
 I10_ECAUSE11                 "ICD-10-CM E Cause 11"
 I10_ECauseCCS1               "ICD-10-CM CCS: E Cause 1"
 I10_ECauseCCS2               "ICD-10-CM CCS: E Cause 2"
 I10_ECauseCCS3               "ICD-10-CM CCS: E Cause 3"
 I10_ECauseCCS4               "ICD-10-CM CCS: E Cause 4"
 I10_ECauseCCS5               "ICD-10-CM CCS: E Cause 5"
 I10_ECauseCCS6               "ICD-10-CM CCS: E Cause 6"
 I10_ECauseCCS7               "ICD-10-CM CCS: E Cause 7"
 I10_ECauseCCS8               "ICD-10-CM CCS: E Cause 8"
 I10_ECauseCCS9               "ICD-10-CM CCS: E Cause 9"
 I10_ECauseCCS10              "ICD-10-CM CCS: E Cause 10"
 I10_ECauseCCS11              "ICD-10-CM CCS: E Cause 11"
 I10_HOSPBRTH                 "ICD-10-CM Indicator of birth in this hospital"
 I10_NCHRONIC                 "ICD-10-CM Number of chronic conditions"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of E Causes on this record"
 I10_NEOMAT                   "ICD-10-CM/PCS Neonatal and/or maternal I10_DX and/or I10_PR"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PRCCS1                   "ICD-10-PCS CCS: procedure 1"
 I10_PRCCS2                   "ICD-10-PCS CCS: procedure 2"
 I10_PRCCS3                   "ICD-10-PCS CCS: procedure 3"
 I10_PRCCS4                   "ICD-10-PCS CCS: procedure 4"
 I10_PRCCS5                   "ICD-10-PCS CCS: procedure 5"
 I10_PRCCS6                   "ICD-10-PCS CCS: procedure 6"
 I10_PRCCS7                   "ICD-10-PCS CCS: procedure 7"
 I10_PRCCS8                   "ICD-10-PCS CCS: procedure 8"
 I10_PRCCS9                   "ICD-10-PCS CCS: procedure 9"
 I10_PRCCS10                  "ICD-10-PCS CCS: procedure 10"
 I10_PRCCS11                  "ICD-10-PCS CCS: procedure 11"
 I10_PRCCS12                  "ICD-10-PCS CCS: procedure 12"
 I10_PRCCS13                  "ICD-10-PCS CCS: procedure 13"
 I10_PRCCS14                  "ICD-10-PCS CCS: procedure 14"
 I10_PRCCS15                  "ICD-10-PCS CCS: procedure 15"
 I10_PRCCS16                  "ICD-10-PCS CCS: procedure 16"
 I10_PRCCS17                  "ICD-10-PCS CCS: procedure 17"
 I10_PRCCS18                  "ICD-10-PCS CCS: procedure 18"
 I10_PRCCS19                  "ICD-10-PCS CCS: procedure 19"
 I10_PRCCS20                  "ICD-10-PCS CCS: procedure 20"
 I10_PRCCS21                  "ICD-10-PCS CCS: procedure 21"
 I10_PRCCS22                  "ICD-10-PCS CCS: procedure 22"
 I10_PRCCS23                  "ICD-10-PCS CCS: procedure 23"
 I10_PRCCS24                  "ICD-10-PCS CCS: procedure 24"
 I10_PRCCS25                  "ICD-10-PCS CCS: procedure 25"
 I10_PRCCS26                  "ICD-10-PCS CCS: procedure 26"
 I10_PRCCS27                  "ICD-10-PCS CCS: procedure 27"
 I10_PRCCS28                  "ICD-10-PCS CCS: procedure 28"
 I10_PRCCS29                  "ICD-10-PCS CCS: procedure 29"
 I10_PRCCS30                  "ICD-10-PCS CCS: procedure 30"
 I10_PRCCS31                  "ICD-10-PCS CCS: procedure 31"
 I10_PRCCS32                  "ICD-10-PCS CCS: procedure 32"
 I10_PRCCS33                  "ICD-10-PCS CCS: procedure 33"
 I10_PRCCS34                  "ICD-10-PCS CCS: procedure 34"
 I10_PRCCS35                  "ICD-10-PCS CCS: procedure 35"
 I10_PRCCS36                  "ICD-10-PCS CCS: procedure 36"
 I10_PRCCS37                  "ICD-10-PCS CCS: procedure 37"
 I10_PRCCS38                  "ICD-10-PCS CCS: procedure 38"
 I10_PRCCS39                  "ICD-10-PCS CCS: procedure 39"
 I10_PRCCS40                  "ICD-10-PCS CCS: procedure 40"
 I10_PRCCS41                  "ICD-10-PCS CCS: procedure 41"
 I10_PRCCS42                  "ICD-10-PCS CCS: procedure 42"
 I10_PRCCS43                  "ICD-10-PCS CCS: procedure 43"
 I10_PRCCS44                  "ICD-10-PCS CCS: procedure 44"
 I10_PRCCS45                  "ICD-10-PCS CCS: procedure 45"
 I10_PRCCS46                  "ICD-10-PCS CCS: procedure 46"
 I10_PRCCS47                  "ICD-10-PCS CCS: procedure 47"
 I10_PRCCS48                  "ICD-10-PCS CCS: procedure 48"
 I10_PRCCS49                  "ICD-10-PCS CCS: procedure 49"
 I10_PRCCS50                  "ICD-10-PCS CCS: procedure 50"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDSPEC1                      "Physician 1 specialty (as received from source)"
 MDSPEC2                      "Physician 2 specialty (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OPservice                    "Indicator of outpatient service (as received from source)"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRYEAR1                      "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'WI_SEDD_2015q4_CORE.SAV' /COMPRESSED.
