/*******************************************************************
*   WI_SEDD_2007_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'WI_SEDD_2007_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ASOURCE                   12-  13
 ASOURCEU                  14     (A)
 ASOURCE_                  15     (A)
 ATYPE                     16-  17
 AWEEKEND                  18-  19
 BILLTYPE                  20-  23 (A)
 CPT1                      24-  28 (A)
 CPT2                      29-  33 (A)
 CPT3                      34-  38 (A)
 CPT4                      39-  43 (A)
 CPT5                      44-  48 (A)
 CPT6                      49-  53 (A)
 CPT7                      54-  58 (A)
 CPT8                      59-  63 (A)
 CPT9                      64-  68 (A)
 CPT10                     69-  73 (A)
 CPT11                     74-  78 (A)
 CPT12                     79-  83 (A)
 CPT13                     84-  88 (A)
 CPT14                     89-  93 (A)
 CPT15                     94-  98 (A)
 CPT16                     99- 103 (A)
 CPT17                    104- 108 (A)
 CPT18                    109- 113 (A)
 CPT19                    114- 118 (A)
 CPT20                    119- 123 (A)
 CPT21                    124- 128 (A)
 CPT22                    129- 133 (A)
 CPT23                    134- 138 (A)
 CPT24                    139- 143 (A)
 CPT25                    144- 148 (A)
 CPT26                    149- 153 (A)
 CPT27                    154- 158 (A)
 CPT28                    159- 163 (A)
 CPT29                    164- 168 (A)
 CPT30                    169- 173 (A)
 CPTM1_1                  174- 175 (A)
 CPTM1_2                  176- 177 (A)
 CPTM1_3                  178- 179 (A)
 CPTM1_4                  180- 181 (A)
 CPTM1_5                  182- 183 (A)
 CPTM1_6                  184- 185 (A)
 CPTM1_7                  186- 187 (A)
 CPTM1_8                  188- 189 (A)
 CPTM1_9                  190- 191 (A)
 CPTM1_10                 192- 193 (A)
 CPTM1_11                 194- 195 (A)
 CPTM1_12                 196- 197 (A)
 CPTM1_13                 198- 199 (A)
 CPTM1_14                 200- 201 (A)
 CPTM1_15                 202- 203 (A)
 CPTM1_16                 204- 205 (A)
 CPTM1_17                 206- 207 (A)
 CPTM1_18                 208- 209 (A)
 CPTM1_19                 210- 211 (A)
 CPTM1_20                 212- 213 (A)
 CPTM1_21                 214- 215 (A)
 CPTM1_22                 216- 217 (A)
 CPTM1_23                 218- 219 (A)
 CPTM1_24                 220- 221 (A)
 CPTM1_25                 222- 223 (A)
 CPTM1_26                 224- 225 (A)
 CPTM1_27                 226- 227 (A)
 CPTM1_28                 228- 229 (A)
 CPTM1_29                 230- 231 (A)
 CPTM1_30                 232- 233 (A)
 DIED                     234- 235
 DISPUB04                 236- 237
 DISPUNIF                 238- 239
 DISP_X                   240- 241 (A)
 DQTR                     242- 243
 DSHOSPID                 244- 256 (A)
 DX1                      257- 261 (A)
 DX2                      262- 266 (A)
 DX3                      267- 271 (A)
 DX4                      272- 276 (A)
 DX5                      277- 281 (A)
 DX6                      282- 286 (A)
 DX7                      287- 291 (A)
 DX8                      292- 296 (A)
 DX9                      297- 301 (A)
 DX10                     302- 306 (A)
 DX11                     307- 311 (A)
 DX12                     312- 316 (A)
 DX13                     317- 321 (A)
 DX14                     322- 326 (A)
 DX15                     327- 331 (A)
 DX16                     332- 336 (A)
 DX17                     337- 341 (A)
 DX18                     342- 346 (A)
 DX19                     347- 351 (A)
 DX20                     352- 356 (A)
 DX21                     357- 361 (A)
 DX22                     362- 366 (A)
 DX23                     367- 371 (A)
 DX24                     372- 376 (A)
 DX25                     377- 381 (A)
 DX26                     382- 386 (A)
 DX27                     387- 391 (A)
 DX28                     392- 396 (A)
 DX29                     397- 401 (A)
 DX30                     402- 406 (A)
 DXCCS1                   407- 410
 DXCCS2                   411- 414
 DXCCS3                   415- 418
 DXCCS4                   419- 422
 DXCCS5                   423- 426
 DXCCS6                   427- 430
 DXCCS7                   431- 434
 DXCCS8                   435- 438
 DXCCS9                   439- 442
 DXCCS10                  443- 446
 DXCCS11                  447- 450
 DXCCS12                  451- 454
 DXCCS13                  455- 458
 DXCCS14                  459- 462
 DXCCS15                  463- 466
 DXCCS16                  467- 470
 DXCCS17                  471- 474
 DXCCS18                  475- 478
 DXCCS19                  479- 482
 DXCCS20                  483- 486
 DXCCS21                  487- 490
 DXCCS22                  491- 494
 DXCCS23                  495- 498
 DXCCS24                  499- 502
 DXCCS25                  503- 506
 DXCCS26                  507- 510
 DXCCS27                  511- 514
 DXCCS28                  515- 518
 DXCCS29                  519- 522
 DXCCS30                  523- 526
 DX_Visit                 527- 531 (A)
 DX_Visit                 532- 536 (A)
 DX_Visit                 537- 541 (A)
 ECODE1                   542- 546 (A)
 ECODE2                   547- 551 (A)
 ECODE3                   552- 556 (A)
 ECODE4                   557- 561 (A)
 ECODE5                   562- 566 (A)
 ECODE6                   567- 571 (A)
 ECODE7                   572- 576 (A)
 ECODE8                   577- 581 (A)
 ECODE9                   582- 586 (A)
 ECODE10                  587- 591 (A)
 ECODE11                  592- 596 (A)
 ECODE12                  597- 601 (A)
 E_CCS1                   602- 605
 E_CCS2                   606- 609
 E_CCS3                   610- 613
 E_CCS4                   614- 617
 E_CCS5                   618- 621
 E_CCS6                   622- 625
 E_CCS7                   626- 629
 E_CCS8                   630- 633
 E_CCS9                   634- 637
 E_CCS10                  638- 641
 E_CCS11                  642- 645
 E_CCS12                  646- 649
 FEMALE                   650- 651
 HCUP_AS                  652- 653
 HCUP_ED                  654- 655
 HCUP_OS                  656- 657
 HISPANIC                 658     (A)
 HOSPBRTH                 659- 661
 HOSPST                   662- 663 (A)
 Homeless                 664- 665
 KEY                      666- 679
 LOS                      680- 684
 LOS_X                    685- 690
 MDSPEC1                  691- 693 (A)
 MDSPEC2                  694- 696 (A)
 MEDINCST                 697- 698
 MRN_R                    699- 707
 NCPT                     708- 710
 NDX                      711- 712
 NECODE                   713- 714
 NEOMAT                   715- 716
 NPR                      717- 718
 PAY1                     719- 720
 PAY1_X                   721- 725 (A)
 PAY2                     726- 727
 PAY2_X                   728- 732 (A)
 PL_CBSA                  733- 735
 PL_MSA19                 736- 738
 PL_NCHS2                 739- 740
 PL_RUCA1                 741- 742
 PL_RUCA2                 743- 746
 PL_RUCA4                 747- 748
 PL_RUCC2                 749- 750
 PL_UIC20                 751- 752
 PL_UR_CA                 753- 754
 PR1                      755- 758 (A)
 PR2                      759- 762 (A)
 PR3                      763- 766 (A)
 PR4                      767- 770 (A)
 PR5                      771- 774 (A)
 PR6                      775- 778 (A)
 PR7                      779- 782 (A)
 PR8                      783- 786 (A)
 PR9                      787- 790 (A)
 PR10                     791- 794 (A)
 PR11                     795- 798 (A)
 PR12                     799- 802 (A)
 PR13                     803- 806 (A)
 PR14                     807- 810 (A)
 PR15                     811- 814 (A)
 PR16                     815- 818 (A)
 PR17                     819- 822 (A)
 PR18                     823- 826 (A)
 PR19                     827- 830 (A)
 PR20                     831- 834 (A)
 PR21                     835- 838 (A)
 PR22                     839- 842 (A)
 PR23                     843- 846 (A)
 PR24                     847- 850 (A)
 PR25                     851- 854 (A)
 PR26                     855- 858 (A)
 PR27                     859- 862 (A)
 PR28                     863- 866 (A)
 PR29                     867- 870 (A)
 PR30                     871- 874 (A)
 PRCCS1                   875- 877
 PRCCS2                   878- 880
 PRCCS3                   881- 883
 PRCCS4                   884- 886
 PRCCS5                   887- 889
 PRCCS6                   890- 892
 PRCCS7                   893- 895
 PRCCS8                   896- 898
 PRCCS9                   899- 901
 PRCCS10                  902- 904
 PRCCS11                  905- 907
 PRCCS12                  908- 910
 PRCCS13                  911- 913
 PRCCS14                  914- 916
 PRCCS15                  917- 919
 PRCCS16                  920- 922
 PRCCS17                  923- 925
 PRCCS18                  926- 928
 PRCCS19                  929- 931
 PRCCS20                  932- 934
 PRCCS21                  935- 937
 PRCCS22                  938- 940
 PRCCS23                  941- 943
 PRCCS24                  944- 946
 PRCCS25                  947- 949
 PRCCS26                  950- 952
 PRCCS27                  953- 955
 PRCCS28                  956- 958
 PRCCS29                  959- 961
 PRCCS30                  962- 964
 PRDAY1                   965- 969
 PROCTYPE                 970- 972
 PSTATE                   973- 974 (A)
 PSTCO2                   975- 979
 RACE                     980- 981
 RACE_X                   982     (A)
 STATE_AS                 983- 984
 STATE_ED                 985- 986
 STATE_OS                 987- 988
 TOTCHG                   989- 998
 TOTCHG_X                 999-1013
 YEAR                    1014-1017
 ZIPINC_Q                1018-1020
 ZIP                     1021-1025 (A)
 AYEAR                   1026-1029
 DMONTH                  1030-1031
 BMONTH                  1032-1033
 BYEAR                   1034-1037
 PRMNTH1                 1038-1039
 PRYEAR1                 1040-1043.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 E_CCS10                 (F3.0) /
 E_CCS11                 (F3.0) /
 E_CCS12                 (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 BILLTYPE  "UB-92 bill type"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPTM1_1   "First CPT-4/HCPCS modifier 1"
 CPTM1_2   "First CPT-4/HCPCS modifier 2"
 CPTM1_3   "First CPT-4/HCPCS modifier 3"
 CPTM1_4   "First CPT-4/HCPCS modifier 4"
 CPTM1_5   "First CPT-4/HCPCS modifier 5"
 CPTM1_6   "First CPT-4/HCPCS modifier 6"
 CPTM1_7   "First CPT-4/HCPCS modifier 7"
 CPTM1_8   "First CPT-4/HCPCS modifier 8"
 CPTM1_9   "First CPT-4/HCPCS modifier 9"
 CPTM1_10  "First CPT-4/HCPCS modifier 10"
 CPTM1_11  "First CPT-4/HCPCS modifier 11"
 CPTM1_12  "First CPT-4/HCPCS modifier 12"
 CPTM1_13  "First CPT-4/HCPCS modifier 13"
 CPTM1_14  "First CPT-4/HCPCS modifier 14"
 CPTM1_15  "First CPT-4/HCPCS modifier 15"
 CPTM1_16  "First CPT-4/HCPCS modifier 16"
 CPTM1_17  "First CPT-4/HCPCS modifier 17"
 CPTM1_18  "First CPT-4/HCPCS modifier 18"
 CPTM1_19  "First CPT-4/HCPCS modifier 19"
 CPTM1_20  "First CPT-4/HCPCS modifier 20"
 CPTM1_21  "First CPT-4/HCPCS modifier 21"
 CPTM1_22  "First CPT-4/HCPCS modifier 22"
 CPTM1_23  "First CPT-4/HCPCS modifier 23"
 CPTM1_24  "First CPT-4/HCPCS modifier 24"
 CPTM1_25  "First CPT-4/HCPCS modifier 25"
 CPTM1_26  "First CPT-4/HCPCS modifier 26"
 CPTM1_27  "First CPT-4/HCPCS modifier 27"
 CPTM1_28  "First CPT-4/HCPCS modifier 28"
 CPTM1_29  "First CPT-4/HCPCS modifier 29"
 CPTM1_30  "First CPT-4/HCPCS modifier 30"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 DX_Visit  "Reason for visit diagnosis 1"
 DX_Visit  "Reason for visit diagnosis 2"
 DX_Visit  "Reason for visit diagnosis 3"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 ECODE9    "E code 9"
 ECODE10   "E code 10"
 ECODE11   "E code 11"
 ECODE12   "E code 12"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 E_CCS9    "CCS: E Code 9"
 E_CCS10   "CCS: E Code 10"
 E_CCS11   "CCS: E Code 11"
 E_CCS12   "CCS: E Code 12"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 Homeless  "Indicator that patient is homeless"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDSPEC1   "Physician 1 specialty (as received from source)"
 MDSPEC2   "Physician 2 specialty (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2      "Secondary expected payer (uniform)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PR26      "Procedure 26"
 PR27      "Procedure 27"
 PR28      "Procedure 28"
 PR29      "Procedure 29"
 PR30      "Procedure 30"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRCCS26   "CCS: procedure 26"
 PRCCS27   "CCS: procedure 27"
 PRCCS28   "CCS: procedure 28"
 PRCCS29   "CCS: procedure 29"
 PRCCS30   "CCS: procedure 30"
 PRDAY1    "Number of days from admission to PR1"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'WI_SEDD_2007_CORE.SAV' /COMPRESSED.
