/*******************************************************************
* Creation Date: 04/22/2025   
*   UT_SEDD_2022_DX_PR_GRPS.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      SEDD DX_PR_GRPS FILE INTO SPSS                                   
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'UT_SEDD_2022_DX_PR_GRPS.asc' FIXED SKIP=2 / 
 CMR_AIDS                        1-   2
 CMR_ALCOHOL                     3-   4
 CMR_ANEMDEF                     5-   6
 CMR_AUTOIMMUNE                  7-   8
 CMR_BLDLOSS                     9-  10
 CMR_CANCER_LEUK                11-  12
 CMR_CANCER_LYMPH               13-  14
 CMR_CANCER_METS                15-  16
 CMR_CANCER_NSITU               17-  18
 CMR_CANCER_SOLID               19-  20
 CMR_CBVD                       21-  22
 CMR_COAG                       23-  24
 CMR_DEMENTIA                   25-  26
 CMR_DEPRESS                    27-  28
 CMR_DIAB_CX                    29-  30
 CMR_DIAB_UNCX                  31-  32
 CMR_DRUG_ABUSE                 33-  34
 CMR_HF                         35-  36
 CMR_HTN_CX                     37-  38
 CMR_HTN_UNCX                   39-  40
 CMR_LIVER_MLD                  41-  42
 CMR_LIVER_SEV                  43-  44
 CMR_LUNG_CHRONIC               45-  46
 CMR_NEURO_MOVT                 47-  48
 CMR_NEURO_OTH                  49-  50
 CMR_NEURO_SEIZ                 51-  52
 CMR_OBESE                      53-  54
 CMR_PARALYSIS                  55-  56
 CMR_PERIVASC                   57-  58
 CMR_PSYCHOSES                  59-  60
 CMR_PULMCIRC                   61-  62
 CMR_RENLFL_MOD                 63-  64
 CMR_RENLFL_SEV                 65-  66
 CMR_THYROID_HYPO               67-  68
 CMR_THYROID_OTH                69-  70
 CMR_ULCER_PEPTIC               71-  72
 CMR_VALVE                      73-  74
 CMR_VERSION                    75-  80 (A)
 CMR_WGHTLOSS                   81-  82
 DXCCSR_BLD001                  83-  85
 DXCCSR_BLD002                  86-  88
 DXCCSR_BLD003                  89-  91
 DXCCSR_BLD004                  92-  94
 DXCCSR_BLD005                  95-  97
 DXCCSR_BLD006                  98- 100
 DXCCSR_BLD007                 101- 103
 DXCCSR_BLD008                 104- 106
 DXCCSR_BLD009                 107- 109
 DXCCSR_BLD010                 110- 112
 DXCCSR_CIR001                 113- 115
 DXCCSR_CIR002                 116- 118
 DXCCSR_CIR003                 119- 121
 DXCCSR_CIR004                 122- 124
 DXCCSR_CIR005                 125- 127
 DXCCSR_CIR006                 128- 130
 DXCCSR_CIR007                 131- 133
 DXCCSR_CIR008                 134- 136
 DXCCSR_CIR009                 137- 139
 DXCCSR_CIR010                 140- 142
 DXCCSR_CIR011                 143- 145
 DXCCSR_CIR012                 146- 148
 DXCCSR_CIR013                 149- 151
 DXCCSR_CIR014                 152- 154
 DXCCSR_CIR015                 155- 157
 DXCCSR_CIR016                 158- 160
 DXCCSR_CIR017                 161- 163
 DXCCSR_CIR018                 164- 166
 DXCCSR_CIR019                 167- 169
 DXCCSR_CIR020                 170- 172
 DXCCSR_CIR021                 173- 175
 DXCCSR_CIR022                 176- 178
 DXCCSR_CIR023                 179- 181
 DXCCSR_CIR024                 182- 184
 DXCCSR_CIR025                 185- 187
 DXCCSR_CIR026                 188- 190
 DXCCSR_CIR027                 191- 193
 DXCCSR_CIR028                 194- 196
 DXCCSR_CIR029                 197- 199
 DXCCSR_CIR030                 200- 202
 DXCCSR_CIR031                 203- 205
 DXCCSR_CIR032                 206- 208
 DXCCSR_CIR033                 209- 211
 DXCCSR_CIR034                 212- 214
 DXCCSR_CIR035                 215- 217
 DXCCSR_CIR036                 218- 220
 DXCCSR_CIR037                 221- 223
 DXCCSR_CIR038                 224- 226
 DXCCSR_CIR039                 227- 229
 DXCCSR_Default_DX1            230- 235 (A)
 DXCCSR_DEN001                 236- 238
 DXCCSR_DEN002                 239- 241
 DXCCSR_DEN003                 242- 244
 DXCCSR_DIG001                 245- 247
 DXCCSR_DIG002                 248- 250
 DXCCSR_DIG003                 251- 253
 DXCCSR_DIG004                 254- 256
 DXCCSR_DIG005                 257- 259
 DXCCSR_DIG006                 260- 262
 DXCCSR_DIG007                 263- 265
 DXCCSR_DIG008                 266- 268
 DXCCSR_DIG009                 269- 271
 DXCCSR_DIG010                 272- 274
 DXCCSR_DIG011                 275- 277
 DXCCSR_DIG012                 278- 280
 DXCCSR_DIG013                 281- 283
 DXCCSR_DIG014                 284- 286
 DXCCSR_DIG015                 287- 289
 DXCCSR_DIG016                 290- 292
 DXCCSR_DIG017                 293- 295
 DXCCSR_DIG018                 296- 298
 DXCCSR_DIG019                 299- 301
 DXCCSR_DIG020                 302- 304
 DXCCSR_DIG021                 305- 307
 DXCCSR_DIG022                 308- 310
 DXCCSR_DIG023                 311- 313
 DXCCSR_DIG024                 314- 316
 DXCCSR_DIG025                 317- 319
 DXCCSR_EAR001                 320- 322
 DXCCSR_EAR002                 323- 325
 DXCCSR_EAR003                 326- 328
 DXCCSR_EAR004                 329- 331
 DXCCSR_EAR005                 332- 334
 DXCCSR_EAR006                 335- 337
 DXCCSR_END001                 338- 340
 DXCCSR_END002                 341- 343
 DXCCSR_END003                 344- 346
 DXCCSR_END004                 347- 349
 DXCCSR_END005                 350- 352
 DXCCSR_END006                 353- 355
 DXCCSR_END007                 356- 358
 DXCCSR_END008                 359- 361
 DXCCSR_END009                 362- 364
 DXCCSR_END010                 365- 367
 DXCCSR_END011                 368- 370
 DXCCSR_END012                 371- 373
 DXCCSR_END013                 374- 376
 DXCCSR_END014                 377- 379
 DXCCSR_END015                 380- 382
 DXCCSR_END016                 383- 385
 DXCCSR_END017                 386- 388
 DXCCSR_EXT001                 389- 391
 DXCCSR_EXT002                 392- 394
 DXCCSR_EXT003                 395- 397
 DXCCSR_EXT004                 398- 400
 DXCCSR_EXT005                 401- 403
 DXCCSR_EXT006                 404- 406
 DXCCSR_EXT007                 407- 409
 DXCCSR_EXT008                 410- 412
 DXCCSR_EXT009                 413- 415
 DXCCSR_EXT010                 416- 418
 DXCCSR_EXT011                 419- 421
 DXCCSR_EXT012                 422- 424
 DXCCSR_EXT013                 425- 427
 DXCCSR_EXT014                 428- 430
 DXCCSR_EXT015                 431- 433
 DXCCSR_EXT016                 434- 436
 DXCCSR_EXT017                 437- 439
 DXCCSR_EXT018                 440- 442
 DXCCSR_EXT019                 443- 445
 DXCCSR_EXT020                 446- 448
 DXCCSR_EXT021                 449- 451
 DXCCSR_EXT022                 452- 454
 DXCCSR_EXT023                 455- 457
 DXCCSR_EXT024                 458- 460
 DXCCSR_EXT025                 461- 463
 DXCCSR_EXT026                 464- 466
 DXCCSR_EXT027                 467- 469
 DXCCSR_EXT028                 470- 472
 DXCCSR_EXT029                 473- 475
 DXCCSR_EXT030                 476- 478
 DXCCSR_EYE001                 479- 481
 DXCCSR_EYE002                 482- 484
 DXCCSR_EYE003                 485- 487
 DXCCSR_EYE004                 488- 490
 DXCCSR_EYE005                 491- 493
 DXCCSR_EYE006                 494- 496
 DXCCSR_EYE007                 497- 499
 DXCCSR_EYE008                 500- 502
 DXCCSR_EYE009                 503- 505
 DXCCSR_EYE010                 506- 508
 DXCCSR_EYE011                 509- 511
 DXCCSR_EYE012                 512- 514
 DXCCSR_FAC001                 515- 517
 DXCCSR_FAC002                 518- 520
 DXCCSR_FAC003                 521- 523
 DXCCSR_FAC004                 524- 526
 DXCCSR_FAC005                 527- 529
 DXCCSR_FAC006                 530- 532
 DXCCSR_FAC007                 533- 535
 DXCCSR_FAC008                 536- 538
 DXCCSR_FAC009                 539- 541
 DXCCSR_FAC010                 542- 544
 DXCCSR_FAC011                 545- 547
 DXCCSR_FAC012                 548- 550
 DXCCSR_FAC013                 551- 553
 DXCCSR_FAC014                 554- 556
 DXCCSR_FAC015                 557- 559
 DXCCSR_FAC016                 560- 562
 DXCCSR_FAC017                 563- 565
 DXCCSR_FAC018                 566- 568
 DXCCSR_FAC019                 569- 571
 DXCCSR_FAC020                 572- 574
 DXCCSR_FAC021                 575- 577
 DXCCSR_FAC022                 578- 580
 DXCCSR_FAC023                 581- 583
 DXCCSR_FAC024                 584- 586
 DXCCSR_FAC025                 587- 589
 DXCCSR_GEN001                 590- 592
 DXCCSR_GEN002                 593- 595
 DXCCSR_GEN003                 596- 598
 DXCCSR_GEN004                 599- 601
 DXCCSR_GEN005                 602- 604
 DXCCSR_GEN006                 605- 607
 DXCCSR_GEN007                 608- 610
 DXCCSR_GEN008                 611- 613
 DXCCSR_GEN009                 614- 616
 DXCCSR_GEN010                 617- 619
 DXCCSR_GEN011                 620- 622
 DXCCSR_GEN012                 623- 625
 DXCCSR_GEN013                 626- 628
 DXCCSR_GEN014                 629- 631
 DXCCSR_GEN015                 632- 634
 DXCCSR_GEN016                 635- 637
 DXCCSR_GEN017                 638- 640
 DXCCSR_GEN018                 641- 643
 DXCCSR_GEN019                 644- 646
 DXCCSR_GEN020                 647- 649
 DXCCSR_GEN021                 650- 652
 DXCCSR_GEN022                 653- 655
 DXCCSR_GEN023                 656- 658
 DXCCSR_GEN024                 659- 661
 DXCCSR_GEN025                 662- 664
 DXCCSR_GEN026                 665- 667
 DXCCSR_INF001                 668- 670
 DXCCSR_INF002                 671- 673
 DXCCSR_INF003                 674- 676
 DXCCSR_INF004                 677- 679
 DXCCSR_INF005                 680- 682
 DXCCSR_INF006                 683- 685
 DXCCSR_INF007                 686- 688
 DXCCSR_INF008                 689- 691
 DXCCSR_INF009                 692- 694
 DXCCSR_INF010                 695- 697
 DXCCSR_INF011                 698- 700
 DXCCSR_INF012                 701- 703
 DXCCSR_INJ001                 704- 706
 DXCCSR_INJ002                 707- 709
 DXCCSR_INJ003                 710- 712
 DXCCSR_INJ004                 713- 715
 DXCCSR_INJ005                 716- 718
 DXCCSR_INJ006                 719- 721
 DXCCSR_INJ007                 722- 724
 DXCCSR_INJ008                 725- 727
 DXCCSR_INJ009                 728- 730
 DXCCSR_INJ010                 731- 733
 DXCCSR_INJ011                 734- 736
 DXCCSR_INJ012                 737- 739
 DXCCSR_INJ013                 740- 742
 DXCCSR_INJ014                 743- 745
 DXCCSR_INJ015                 746- 748
 DXCCSR_INJ016                 749- 751
 DXCCSR_INJ017                 752- 754
 DXCCSR_INJ018                 755- 757
 DXCCSR_INJ019                 758- 760
 DXCCSR_INJ020                 761- 763
 DXCCSR_INJ021                 764- 766
 DXCCSR_INJ022                 767- 769
 DXCCSR_INJ023                 770- 772
 DXCCSR_INJ024                 773- 775
 DXCCSR_INJ025                 776- 778
 DXCCSR_INJ026                 779- 781
 DXCCSR_INJ027                 782- 784
 DXCCSR_INJ028                 785- 787
 DXCCSR_INJ029                 788- 790
 DXCCSR_INJ030                 791- 793
 DXCCSR_INJ031                 794- 796
 DXCCSR_INJ032                 797- 799
 DXCCSR_INJ033                 800- 802
 DXCCSR_INJ034                 803- 805
 DXCCSR_INJ035                 806- 808
 DXCCSR_INJ036                 809- 811
 DXCCSR_INJ037                 812- 814
 DXCCSR_INJ038                 815- 817
 DXCCSR_INJ039                 818- 820
 DXCCSR_INJ040                 821- 823
 DXCCSR_INJ041                 824- 826
 DXCCSR_INJ042                 827- 829
 DXCCSR_INJ043                 830- 832
 DXCCSR_INJ044                 833- 835
 DXCCSR_INJ045                 836- 838
 DXCCSR_INJ046                 839- 841
 DXCCSR_INJ047                 842- 844
 DXCCSR_INJ048                 845- 847
 DXCCSR_INJ049                 848- 850
 DXCCSR_INJ050                 851- 853
 DXCCSR_INJ051                 854- 856
 DXCCSR_INJ052                 857- 859
 DXCCSR_INJ053                 860- 862
 DXCCSR_INJ054                 863- 865
 DXCCSR_INJ055                 866- 868
 DXCCSR_INJ056                 869- 871
 DXCCSR_INJ057                 872- 874
 DXCCSR_INJ058                 875- 877
 DXCCSR_INJ059                 878- 880
 DXCCSR_INJ060                 881- 883
 DXCCSR_INJ061                 884- 886
 DXCCSR_INJ062                 887- 889
 DXCCSR_INJ063                 890- 892
 DXCCSR_INJ064                 893- 895
 DXCCSR_INJ065                 896- 898
 DXCCSR_INJ066                 899- 901
 DXCCSR_INJ067                 902- 904
 DXCCSR_INJ068                 905- 907
 DXCCSR_INJ069                 908- 910
 DXCCSR_INJ070                 911- 913
 DXCCSR_INJ071                 914- 916
 DXCCSR_INJ072                 917- 919
 DXCCSR_INJ073                 920- 922
 DXCCSR_INJ074                 923- 925
 DXCCSR_INJ075                 926- 928
 DXCCSR_INJ076                 929- 931
 DXCCSR_MAL001                 932- 934
 DXCCSR_MAL002                 935- 937
 DXCCSR_MAL003                 938- 940
 DXCCSR_MAL004                 941- 943
 DXCCSR_MAL005                 944- 946
 DXCCSR_MAL006                 947- 949
 DXCCSR_MAL007                 950- 952
 DXCCSR_MAL008                 953- 955
 DXCCSR_MAL009                 956- 958
 DXCCSR_MAL010                 959- 961
 DXCCSR_MBD001                 962- 964
 DXCCSR_MBD002                 965- 967
 DXCCSR_MBD003                 968- 970
 DXCCSR_MBD004                 971- 973
 DXCCSR_MBD005                 974- 976
 DXCCSR_MBD006                 977- 979
 DXCCSR_MBD007                 980- 982
 DXCCSR_MBD008                 983- 985
 DXCCSR_MBD009                 986- 988
 DXCCSR_MBD010                 989- 991
 DXCCSR_MBD011                 992- 994
 DXCCSR_MBD012                 995- 997
 DXCCSR_MBD013                 998-1000
 DXCCSR_MBD014                1001-1003
 DXCCSR_MBD017                1004-1006
 DXCCSR_MBD018                1007-1009
 DXCCSR_MBD019                1010-1012
 DXCCSR_MBD020                1013-1015
 DXCCSR_MBD021                1016-1018
 DXCCSR_MBD022                1019-1021
 DXCCSR_MBD023                1022-1024
 DXCCSR_MBD024                1025-1027
 DXCCSR_MBD025                1028-1030
 DXCCSR_MBD026                1031-1033
 DXCCSR_MBD027                1034-1036
 DXCCSR_MBD028                1037-1039
 DXCCSR_MBD029                1040-1042
 DXCCSR_MBD030                1043-1045
 DXCCSR_MBD031                1046-1048
 DXCCSR_MBD032                1049-1051
 DXCCSR_MBD033                1052-1054
 DXCCSR_MBD034                1055-1057
 DXCCSR_MUS001                1058-1060
 DXCCSR_MUS002                1061-1063
 DXCCSR_MUS003                1064-1066
 DXCCSR_MUS004                1067-1069
 DXCCSR_MUS005                1070-1072
 DXCCSR_MUS006                1073-1075
 DXCCSR_MUS007                1076-1078
 DXCCSR_MUS008                1079-1081
 DXCCSR_MUS009                1082-1084
 DXCCSR_MUS010                1085-1087
 DXCCSR_MUS011                1088-1090
 DXCCSR_MUS012                1091-1093
 DXCCSR_MUS013                1094-1096
 DXCCSR_MUS014                1097-1099
 DXCCSR_MUS015                1100-1102
 DXCCSR_MUS016                1103-1105
 DXCCSR_MUS017                1106-1108
 DXCCSR_MUS018                1109-1111
 DXCCSR_MUS019                1112-1114
 DXCCSR_MUS020                1115-1117
 DXCCSR_MUS021                1118-1120
 DXCCSR_MUS022                1121-1123
 DXCCSR_MUS023                1124-1126
 DXCCSR_MUS024                1127-1129
 DXCCSR_MUS025                1130-1132
 DXCCSR_MUS026                1133-1135
 DXCCSR_MUS027                1136-1138
 DXCCSR_MUS028                1139-1141
 DXCCSR_MUS029                1142-1144
 DXCCSR_MUS030                1145-1147
 DXCCSR_MUS031                1148-1150
 DXCCSR_MUS032                1151-1153
 DXCCSR_MUS033                1154-1156
 DXCCSR_MUS034                1157-1159
 DXCCSR_MUS035                1160-1162
 DXCCSR_MUS036                1163-1165
 DXCCSR_MUS037                1166-1168
 DXCCSR_MUS038                1169-1171
 DXCCSR_NEO001                1172-1174
 DXCCSR_NEO002                1175-1177
 DXCCSR_NEO003                1178-1180
 DXCCSR_NEO004                1181-1183
 DXCCSR_NEO005                1184-1186
 DXCCSR_NEO006                1187-1189
 DXCCSR_NEO007                1190-1192
 DXCCSR_NEO008                1193-1195
 DXCCSR_NEO009                1196-1198
 DXCCSR_NEO010                1199-1201
 DXCCSR_NEO011                1202-1204
 DXCCSR_NEO012                1205-1207
 DXCCSR_NEO013                1208-1210
 DXCCSR_NEO014                1211-1213
 DXCCSR_NEO015                1214-1216
 DXCCSR_NEO016                1217-1219
 DXCCSR_NEO017                1220-1222
 DXCCSR_NEO018                1223-1225
 DXCCSR_NEO019                1226-1228
 DXCCSR_NEO020                1229-1231
 DXCCSR_NEO021                1232-1234
 DXCCSR_NEO022                1235-1237
 DXCCSR_NEO023                1238-1240
 DXCCSR_NEO024                1241-1243
 DXCCSR_NEO025                1244-1246
 DXCCSR_NEO026                1247-1249
 DXCCSR_NEO027                1250-1252
 DXCCSR_NEO028                1253-1255
 DXCCSR_NEO029                1256-1258
 DXCCSR_NEO030                1259-1261
 DXCCSR_NEO031                1262-1264
 DXCCSR_NEO032                1265-1267
 DXCCSR_NEO033                1268-1270
 DXCCSR_NEO034                1271-1273
 DXCCSR_NEO035                1274-1276
 DXCCSR_NEO036                1277-1279
 DXCCSR_NEO037                1280-1282
 DXCCSR_NEO038                1283-1285
 DXCCSR_NEO039                1286-1288
 DXCCSR_NEO040                1289-1291
 DXCCSR_NEO041                1292-1294
 DXCCSR_NEO042                1295-1297
 DXCCSR_NEO043                1298-1300
 DXCCSR_NEO044                1301-1303
 DXCCSR_NEO045                1304-1306
 DXCCSR_NEO046                1307-1309
 DXCCSR_NEO047                1310-1312
 DXCCSR_NEO048                1313-1315
 DXCCSR_NEO049                1316-1318
 DXCCSR_NEO050                1319-1321
 DXCCSR_NEO051                1322-1324
 DXCCSR_NEO052                1325-1327
 DXCCSR_NEO053                1328-1330
 DXCCSR_NEO054                1331-1333
 DXCCSR_NEO055                1334-1336
 DXCCSR_NEO056                1337-1339
 DXCCSR_NEO057                1340-1342
 DXCCSR_NEO058                1343-1345
 DXCCSR_NEO059                1346-1348
 DXCCSR_NEO060                1349-1351
 DXCCSR_NEO061                1352-1354
 DXCCSR_NEO062                1355-1357
 DXCCSR_NEO063                1358-1360
 DXCCSR_NEO064                1361-1363
 DXCCSR_NEO065                1364-1366
 DXCCSR_NEO066                1367-1369
 DXCCSR_NEO067                1370-1372
 DXCCSR_NEO068                1373-1375
 DXCCSR_NEO069                1376-1378
 DXCCSR_NEO070                1379-1381
 DXCCSR_NEO071                1382-1384
 DXCCSR_NEO072                1385-1387
 DXCCSR_NEO073                1388-1390
 DXCCSR_NEO074                1391-1393
 DXCCSR_NVS001                1394-1396
 DXCCSR_NVS002                1397-1399
 DXCCSR_NVS003                1400-1402
 DXCCSR_NVS004                1403-1405
 DXCCSR_NVS005                1406-1408
 DXCCSR_NVS006                1409-1411
 DXCCSR_NVS007                1412-1414
 DXCCSR_NVS008                1415-1417
 DXCCSR_NVS009                1418-1420
 DXCCSR_NVS010                1421-1423
 DXCCSR_NVS011                1424-1426
 DXCCSR_NVS012                1427-1429
 DXCCSR_NVS013                1430-1432
 DXCCSR_NVS014                1433-1435
 DXCCSR_NVS015                1436-1438
 DXCCSR_NVS016                1439-1441
 DXCCSR_NVS017                1442-1444
 DXCCSR_NVS018                1445-1447
 DXCCSR_NVS019                1448-1450
 DXCCSR_NVS020                1451-1453
 DXCCSR_NVS021                1454-1456
 DXCCSR_NVS022                1457-1459
 DXCCSR_PNL001                1460-1462
 DXCCSR_PNL002                1463-1465
 DXCCSR_PNL003                1466-1468
 DXCCSR_PNL004                1469-1471
 DXCCSR_PNL005                1472-1474
 DXCCSR_PNL006                1475-1477
 DXCCSR_PNL007                1478-1480
 DXCCSR_PNL008                1481-1483
 DXCCSR_PNL009                1484-1486
 DXCCSR_PNL010                1487-1489
 DXCCSR_PNL011                1490-1492
 DXCCSR_PNL012                1493-1495
 DXCCSR_PNL013                1496-1498
 DXCCSR_PNL014                1499-1501
 DXCCSR_PNL015                1502-1504
 DXCCSR_PRG001                1505-1507
 DXCCSR_PRG002                1508-1510
 DXCCSR_PRG003                1511-1513
 DXCCSR_PRG004                1514-1516
 DXCCSR_PRG005                1517-1519
 DXCCSR_PRG006                1520-1522
 DXCCSR_PRG007                1523-1525
 DXCCSR_PRG008                1526-1528
 DXCCSR_PRG009                1529-1531
 DXCCSR_PRG010                1532-1534
 DXCCSR_PRG011                1535-1537
 DXCCSR_PRG012                1538-1540
 DXCCSR_PRG013                1541-1543
 DXCCSR_PRG014                1544-1546
 DXCCSR_PRG015                1547-1549
 DXCCSR_PRG016                1550-1552
 DXCCSR_PRG017                1553-1555
 DXCCSR_PRG018                1556-1558
 DXCCSR_PRG019                1559-1561
 DXCCSR_PRG020                1562-1564
 DXCCSR_PRG021                1565-1567
 DXCCSR_PRG022                1568-1570
 DXCCSR_PRG023                1571-1573
 DXCCSR_PRG024                1574-1576
 DXCCSR_PRG025                1577-1579
 DXCCSR_PRG026                1580-1582
 DXCCSR_PRG027                1583-1585
 DXCCSR_PRG028                1586-1588
 DXCCSR_PRG029                1589-1591
 DXCCSR_PRG030                1592-1594
 DXCCSR_RSP001                1595-1597
 DXCCSR_RSP002                1598-1600
 DXCCSR_RSP003                1601-1603
 DXCCSR_RSP004                1604-1606
 DXCCSR_RSP005                1607-1609
 DXCCSR_RSP006                1610-1612
 DXCCSR_RSP007                1613-1615
 DXCCSR_RSP008                1616-1618
 DXCCSR_RSP009                1619-1621
 DXCCSR_RSP010                1622-1624
 DXCCSR_RSP011                1625-1627
 DXCCSR_RSP012                1628-1630
 DXCCSR_RSP013                1631-1633
 DXCCSR_RSP014                1634-1636
 DXCCSR_RSP015                1637-1639
 DXCCSR_RSP016                1640-1642
 DXCCSR_RSP017                1643-1645
 DXCCSR_SKN001                1646-1648
 DXCCSR_SKN002                1649-1651
 DXCCSR_SKN003                1652-1654
 DXCCSR_SKN004                1655-1657
 DXCCSR_SKN005                1658-1660
 DXCCSR_SKN006                1661-1663
 DXCCSR_SKN007                1664-1666
 DXCCSR_SYM001                1667-1669
 DXCCSR_SYM002                1670-1672
 DXCCSR_SYM003                1673-1675
 DXCCSR_SYM004                1676-1678
 DXCCSR_SYM005                1679-1681
 DXCCSR_SYM006                1682-1684
 DXCCSR_SYM007                1685-1687
 DXCCSR_SYM008                1688-1690
 DXCCSR_SYM009                1691-1693
 DXCCSR_SYM010                1694-1696
 DXCCSR_SYM011                1697-1699
 DXCCSR_SYM012                1700-1702
 DXCCSR_SYM013                1703-1705
 DXCCSR_SYM014                1706-1708
 DXCCSR_SYM015                1709-1711
 DXCCSR_SYM016                1712-1714
 DXCCSR_SYM017                1715-1717
 DXCCSR_VERSION               1718-1723 (A)
 I10_INJURY                   1724-1725
 I10_INJURY_CUT               1726-1727
 I10_INJURY_DROWN             1728-1729
 I10_INJURY_FALL              1730-1731
 I10_INJURY_FIRE              1732-1733
 I10_INJURY_FIREARM           1734-1735
 I10_INJURY_MACHINERY         1736-1737
 I10_INJURY_MVT               1738-1739
 I10_INJURY_NATURE            1740-1741
 I10_INJURY_OVEREXERTION      1742-1743
 I10_INJURY_POISON            1744-1745
 I10_INJURY_STRUCK            1746-1747
 I10_INJURY_SUFFOCATION       1748-1749
 I10_INTENT_ASSAULT           1750-1751
 I10_INTENT_SELF_HARM         1752-1753
 I10_INTENT_UNINTENTIONAL     1754-1755
 I10_MULTINJURY               1756-1757
 KEY                          1758-1772.


/***  Specify write formats  ***/
FORMATS
 CMR_AIDS                     (F3.0) /
 CMR_ALCOHOL                  (F3.0) /
 CMR_ANEMDEF                  (F3.0) /
 CMR_AUTOIMMUNE               (F3.0) /
 CMR_BLDLOSS                  (F3.0) /
 CMR_CANCER_LEUK              (F3.0) /
 CMR_CANCER_LYMPH             (F3.0) /
 CMR_CANCER_METS              (F3.0) /
 CMR_CANCER_NSITU             (F3.0) /
 CMR_CANCER_SOLID             (F3.0) /
 CMR_CBVD                     (F3.0) /
 CMR_COAG                     (F3.0) /
 CMR_DEMENTIA                 (F3.0) /
 CMR_DEPRESS                  (F3.0) /
 CMR_DIAB_CX                  (F3.0) /
 CMR_DIAB_UNCX                (F3.0) /
 CMR_DRUG_ABUSE               (F3.0) /
 CMR_HF                       (F3.0) /
 CMR_HTN_CX                   (F3.0) /
 CMR_HTN_UNCX                 (F3.0) /
 CMR_LIVER_MLD                (F3.0) /
 CMR_LIVER_SEV                (F3.0) /
 CMR_LUNG_CHRONIC             (F3.0) /
 CMR_NEURO_MOVT               (F3.0) /
 CMR_NEURO_OTH                (F3.0) /
 CMR_NEURO_SEIZ               (F3.0) /
 CMR_OBESE                    (F3.0) /
 CMR_PARALYSIS                (F3.0) /
 CMR_PERIVASC                 (F3.0) /
 CMR_PSYCHOSES                (F3.0) /
 CMR_PULMCIRC                 (F3.0) /
 CMR_RENLFL_MOD               (F3.0) /
 CMR_RENLFL_SEV               (F3.0) /
 CMR_THYROID_HYPO             (F3.0) /
 CMR_THYROID_OTH              (F3.0) /
 CMR_ULCER_PEPTIC             (F3.0) /
 CMR_VALVE                    (F3.0) /
 CMR_WGHTLOSS                 (F3.0) /
 DXCCSR_BLD001                (F3.0) /
 DXCCSR_BLD002                (F3.0) /
 DXCCSR_BLD003                (F3.0) /
 DXCCSR_BLD004                (F3.0) /
 DXCCSR_BLD005                (F3.0) /
 DXCCSR_BLD006                (F3.0) /
 DXCCSR_BLD007                (F3.0) /
 DXCCSR_BLD008                (F3.0) /
 DXCCSR_BLD009                (F3.0) /
 DXCCSR_BLD010                (F3.0) /
 DXCCSR_CIR001                (F3.0) /
 DXCCSR_CIR002                (F3.0) /
 DXCCSR_CIR003                (F3.0) /
 DXCCSR_CIR004                (F3.0) /
 DXCCSR_CIR005                (F3.0) /
 DXCCSR_CIR006                (F3.0) /
 DXCCSR_CIR007                (F3.0) /
 DXCCSR_CIR008                (F3.0) /
 DXCCSR_CIR009                (F3.0) /
 DXCCSR_CIR010                (F3.0) /
 DXCCSR_CIR011                (F3.0) /
 DXCCSR_CIR012                (F3.0) /
 DXCCSR_CIR013                (F3.0) /
 DXCCSR_CIR014                (F3.0) /
 DXCCSR_CIR015                (F3.0) /
 DXCCSR_CIR016                (F3.0) /
 DXCCSR_CIR017                (F3.0) /
 DXCCSR_CIR018                (F3.0) /
 DXCCSR_CIR019                (F3.0) /
 DXCCSR_CIR020                (F3.0) /
 DXCCSR_CIR021                (F3.0) /
 DXCCSR_CIR022                (F3.0) /
 DXCCSR_CIR023                (F3.0) /
 DXCCSR_CIR024                (F3.0) /
 DXCCSR_CIR025                (F3.0) /
 DXCCSR_CIR026                (F3.0) /
 DXCCSR_CIR027                (F3.0) /
 DXCCSR_CIR028                (F3.0) /
 DXCCSR_CIR029                (F3.0) /
 DXCCSR_CIR030                (F3.0) /
 DXCCSR_CIR031                (F3.0) /
 DXCCSR_CIR032                (F3.0) /
 DXCCSR_CIR033                (F3.0) /
 DXCCSR_CIR034                (F3.0) /
 DXCCSR_CIR035                (F3.0) /
 DXCCSR_CIR036                (F3.0) /
 DXCCSR_CIR037                (F3.0) /
 DXCCSR_CIR038                (F3.0) /
 DXCCSR_CIR039                (F3.0) /
 DXCCSR_DEN001                (F3.0) /
 DXCCSR_DEN002                (F3.0) /
 DXCCSR_DEN003                (F3.0) /
 DXCCSR_DIG001                (F3.0) /
 DXCCSR_DIG002                (F3.0) /
 DXCCSR_DIG003                (F3.0) /
 DXCCSR_DIG004                (F3.0) /
 DXCCSR_DIG005                (F3.0) /
 DXCCSR_DIG006                (F3.0) /
 DXCCSR_DIG007                (F3.0) /
 DXCCSR_DIG008                (F3.0) /
 DXCCSR_DIG009                (F3.0) /
 DXCCSR_DIG010                (F3.0) /
 DXCCSR_DIG011                (F3.0) /
 DXCCSR_DIG012                (F3.0) /
 DXCCSR_DIG013                (F3.0) /
 DXCCSR_DIG014                (F3.0) /
 DXCCSR_DIG015                (F3.0) /
 DXCCSR_DIG016                (F3.0) /
 DXCCSR_DIG017                (F3.0) /
 DXCCSR_DIG018                (F3.0) /
 DXCCSR_DIG019                (F3.0) /
 DXCCSR_DIG020                (F3.0) /
 DXCCSR_DIG021                (F3.0) /
 DXCCSR_DIG022                (F3.0) /
 DXCCSR_DIG023                (F3.0) /
 DXCCSR_DIG024                (F3.0) /
 DXCCSR_DIG025                (F3.0) /
 DXCCSR_EAR001                (F3.0) /
 DXCCSR_EAR002                (F3.0) /
 DXCCSR_EAR003                (F3.0) /
 DXCCSR_EAR004                (F3.0) /
 DXCCSR_EAR005                (F3.0) /
 DXCCSR_EAR006                (F3.0) /
 DXCCSR_END001                (F3.0) /
 DXCCSR_END002                (F3.0) /
 DXCCSR_END003                (F3.0) /
 DXCCSR_END004                (F3.0) /
 DXCCSR_END005                (F3.0) /
 DXCCSR_END006                (F3.0) /
 DXCCSR_END007                (F3.0) /
 DXCCSR_END008                (F3.0) /
 DXCCSR_END009                (F3.0) /
 DXCCSR_END010                (F3.0) /
 DXCCSR_END011                (F3.0) /
 DXCCSR_END012                (F3.0) /
 DXCCSR_END013                (F3.0) /
 DXCCSR_END014                (F3.0) /
 DXCCSR_END015                (F3.0) /
 DXCCSR_END016                (F3.0) /
 DXCCSR_END017                (F3.0) /
 DXCCSR_EXT001                (F3.0) /
 DXCCSR_EXT002                (F3.0) /
 DXCCSR_EXT003                (F3.0) /
 DXCCSR_EXT004                (F3.0) /
 DXCCSR_EXT005                (F3.0) /
 DXCCSR_EXT006                (F3.0) /
 DXCCSR_EXT007                (F3.0) /
 DXCCSR_EXT008                (F3.0) /
 DXCCSR_EXT009                (F3.0) /
 DXCCSR_EXT010                (F3.0) /
 DXCCSR_EXT011                (F3.0) /
 DXCCSR_EXT012                (F3.0) /
 DXCCSR_EXT013                (F3.0) /
 DXCCSR_EXT014                (F3.0) /
 DXCCSR_EXT015                (F3.0) /
 DXCCSR_EXT016                (F3.0) /
 DXCCSR_EXT017                (F3.0) /
 DXCCSR_EXT018                (F3.0) /
 DXCCSR_EXT019                (F3.0) /
 DXCCSR_EXT020                (F3.0) /
 DXCCSR_EXT021                (F3.0) /
 DXCCSR_EXT022                (F3.0) /
 DXCCSR_EXT023                (F3.0) /
 DXCCSR_EXT024                (F3.0) /
 DXCCSR_EXT025                (F3.0) /
 DXCCSR_EXT026                (F3.0) /
 DXCCSR_EXT027                (F3.0) /
 DXCCSR_EXT028                (F3.0) /
 DXCCSR_EXT029                (F3.0) /
 DXCCSR_EXT030                (F3.0) /
 DXCCSR_EYE001                (F3.0) /
 DXCCSR_EYE002                (F3.0) /
 DXCCSR_EYE003                (F3.0) /
 DXCCSR_EYE004                (F3.0) /
 DXCCSR_EYE005                (F3.0) /
 DXCCSR_EYE006                (F3.0) /
 DXCCSR_EYE007                (F3.0) /
 DXCCSR_EYE008                (F3.0) /
 DXCCSR_EYE009                (F3.0) /
 DXCCSR_EYE010                (F3.0) /
 DXCCSR_EYE011                (F3.0) /
 DXCCSR_EYE012                (F3.0) /
 DXCCSR_FAC001                (F3.0) /
 DXCCSR_FAC002                (F3.0) /
 DXCCSR_FAC003                (F3.0) /
 DXCCSR_FAC004                (F3.0) /
 DXCCSR_FAC005                (F3.0) /
 DXCCSR_FAC006                (F3.0) /
 DXCCSR_FAC007                (F3.0) /
 DXCCSR_FAC008                (F3.0) /
 DXCCSR_FAC009                (F3.0) /
 DXCCSR_FAC010                (F3.0) /
 DXCCSR_FAC011                (F3.0) /
 DXCCSR_FAC012                (F3.0) /
 DXCCSR_FAC013                (F3.0) /
 DXCCSR_FAC014                (F3.0) /
 DXCCSR_FAC015                (F3.0) /
 DXCCSR_FAC016                (F3.0) /
 DXCCSR_FAC017                (F3.0) /
 DXCCSR_FAC018                (F3.0) /
 DXCCSR_FAC019                (F3.0) /
 DXCCSR_FAC020                (F3.0) /
 DXCCSR_FAC021                (F3.0) /
 DXCCSR_FAC022                (F3.0) /
 DXCCSR_FAC023                (F3.0) /
 DXCCSR_FAC024                (F3.0) /
 DXCCSR_FAC025                (F3.0) /
 DXCCSR_GEN001                (F3.0) /
 DXCCSR_GEN002                (F3.0) /
 DXCCSR_GEN003                (F3.0) /
 DXCCSR_GEN004                (F3.0) /
 DXCCSR_GEN005                (F3.0) /
 DXCCSR_GEN006                (F3.0) /
 DXCCSR_GEN007                (F3.0) /
 DXCCSR_GEN008                (F3.0) /
 DXCCSR_GEN009                (F3.0) /
 DXCCSR_GEN010                (F3.0) /
 DXCCSR_GEN011                (F3.0) /
 DXCCSR_GEN012                (F3.0) /
 DXCCSR_GEN013                (F3.0) /
 DXCCSR_GEN014                (F3.0) /
 DXCCSR_GEN015                (F3.0) /
 DXCCSR_GEN016                (F3.0) /
 DXCCSR_GEN017                (F3.0) /
 DXCCSR_GEN018                (F3.0) /
 DXCCSR_GEN019                (F3.0) /
 DXCCSR_GEN020                (F3.0) /
 DXCCSR_GEN021                (F3.0) /
 DXCCSR_GEN022                (F3.0) /
 DXCCSR_GEN023                (F3.0) /
 DXCCSR_GEN024                (F3.0) /
 DXCCSR_GEN025                (F3.0) /
 DXCCSR_GEN026                (F3.0) /
 DXCCSR_INF001                (F3.0) /
 DXCCSR_INF002                (F3.0) /
 DXCCSR_INF003                (F3.0) /
 DXCCSR_INF004                (F3.0) /
 DXCCSR_INF005                (F3.0) /
 DXCCSR_INF006                (F3.0) /
 DXCCSR_INF007                (F3.0) /
 DXCCSR_INF008                (F3.0) /
 DXCCSR_INF009                (F3.0) /
 DXCCSR_INF010                (F3.0) /
 DXCCSR_INF011                (F3.0) /
 DXCCSR_INF012                (F3.0) /
 DXCCSR_INJ001                (F3.0) /
 DXCCSR_INJ002                (F3.0) /
 DXCCSR_INJ003                (F3.0) /
 DXCCSR_INJ004                (F3.0) /
 DXCCSR_INJ005                (F3.0) /
 DXCCSR_INJ006                (F3.0) /
 DXCCSR_INJ007                (F3.0) /
 DXCCSR_INJ008                (F3.0) /
 DXCCSR_INJ009                (F3.0) /
 DXCCSR_INJ010                (F3.0) /
 DXCCSR_INJ011                (F3.0) /
 DXCCSR_INJ012                (F3.0) /
 DXCCSR_INJ013                (F3.0) /
 DXCCSR_INJ014                (F3.0) /
 DXCCSR_INJ015                (F3.0) /
 DXCCSR_INJ016                (F3.0) /
 DXCCSR_INJ017                (F3.0) /
 DXCCSR_INJ018                (F3.0) /
 DXCCSR_INJ019                (F3.0) /
 DXCCSR_INJ020                (F3.0) /
 DXCCSR_INJ021                (F3.0) /
 DXCCSR_INJ022                (F3.0) /
 DXCCSR_INJ023                (F3.0) /
 DXCCSR_INJ024                (F3.0) /
 DXCCSR_INJ025                (F3.0) /
 DXCCSR_INJ026                (F3.0) /
 DXCCSR_INJ027                (F3.0) /
 DXCCSR_INJ028                (F3.0) /
 DXCCSR_INJ029                (F3.0) /
 DXCCSR_INJ030                (F3.0) /
 DXCCSR_INJ031                (F3.0) /
 DXCCSR_INJ032                (F3.0) /
 DXCCSR_INJ033                (F3.0) /
 DXCCSR_INJ034                (F3.0) /
 DXCCSR_INJ035                (F3.0) /
 DXCCSR_INJ036                (F3.0) /
 DXCCSR_INJ037                (F3.0) /
 DXCCSR_INJ038                (F3.0) /
 DXCCSR_INJ039                (F3.0) /
 DXCCSR_INJ040                (F3.0) /
 DXCCSR_INJ041                (F3.0) /
 DXCCSR_INJ042                (F3.0) /
 DXCCSR_INJ043                (F3.0) /
 DXCCSR_INJ044                (F3.0) /
 DXCCSR_INJ045                (F3.0) /
 DXCCSR_INJ046                (F3.0) /
 DXCCSR_INJ047                (F3.0) /
 DXCCSR_INJ048                (F3.0) /
 DXCCSR_INJ049                (F3.0) /
 DXCCSR_INJ050                (F3.0) /
 DXCCSR_INJ051                (F3.0) /
 DXCCSR_INJ052                (F3.0) /
 DXCCSR_INJ053                (F3.0) /
 DXCCSR_INJ054                (F3.0) /
 DXCCSR_INJ055                (F3.0) /
 DXCCSR_INJ056                (F3.0) /
 DXCCSR_INJ057                (F3.0) /
 DXCCSR_INJ058                (F3.0) /
 DXCCSR_INJ059                (F3.0) /
 DXCCSR_INJ060                (F3.0) /
 DXCCSR_INJ061                (F3.0) /
 DXCCSR_INJ062                (F3.0) /
 DXCCSR_INJ063                (F3.0) /
 DXCCSR_INJ064                (F3.0) /
 DXCCSR_INJ065                (F3.0) /
 DXCCSR_INJ066                (F3.0) /
 DXCCSR_INJ067                (F3.0) /
 DXCCSR_INJ068                (F3.0) /
 DXCCSR_INJ069                (F3.0) /
 DXCCSR_INJ070                (F3.0) /
 DXCCSR_INJ071                (F3.0) /
 DXCCSR_INJ072                (F3.0) /
 DXCCSR_INJ073                (F3.0) /
 DXCCSR_INJ074                (F3.0) /
 DXCCSR_INJ075                (F3.0) /
 DXCCSR_INJ076                (F3.0) /
 DXCCSR_MAL001                (F3.0) /
 DXCCSR_MAL002                (F3.0) /
 DXCCSR_MAL003                (F3.0) /
 DXCCSR_MAL004                (F3.0) /
 DXCCSR_MAL005                (F3.0) /
 DXCCSR_MAL006                (F3.0) /
 DXCCSR_MAL007                (F3.0) /
 DXCCSR_MAL008                (F3.0) /
 DXCCSR_MAL009                (F3.0) /
 DXCCSR_MAL010                (F3.0) /
 DXCCSR_MBD001                (F3.0) /
 DXCCSR_MBD002                (F3.0) /
 DXCCSR_MBD003                (F3.0) /
 DXCCSR_MBD004                (F3.0) /
 DXCCSR_MBD005                (F3.0) /
 DXCCSR_MBD006                (F3.0) /
 DXCCSR_MBD007                (F3.0) /
 DXCCSR_MBD008                (F3.0) /
 DXCCSR_MBD009                (F3.0) /
 DXCCSR_MBD010                (F3.0) /
 DXCCSR_MBD011                (F3.0) /
 DXCCSR_MBD012                (F3.0) /
 DXCCSR_MBD013                (F3.0) /
 DXCCSR_MBD014                (F3.0) /
 DXCCSR_MBD017                (F3.0) /
 DXCCSR_MBD018                (F3.0) /
 DXCCSR_MBD019                (F3.0) /
 DXCCSR_MBD020                (F3.0) /
 DXCCSR_MBD021                (F3.0) /
 DXCCSR_MBD022                (F3.0) /
 DXCCSR_MBD023                (F3.0) /
 DXCCSR_MBD024                (F3.0) /
 DXCCSR_MBD025                (F3.0) /
 DXCCSR_MBD026                (F3.0) /
 DXCCSR_MBD027                (F3.0) /
 DXCCSR_MBD028                (F3.0) /
 DXCCSR_MBD029                (F3.0) /
 DXCCSR_MBD030                (F3.0) /
 DXCCSR_MBD031                (F3.0) /
 DXCCSR_MBD032                (F3.0) /
 DXCCSR_MBD033                (F3.0) /
 DXCCSR_MBD034                (F3.0) /
 DXCCSR_MUS001                (F3.0) /
 DXCCSR_MUS002                (F3.0) /
 DXCCSR_MUS003                (F3.0) /
 DXCCSR_MUS004                (F3.0) /
 DXCCSR_MUS005                (F3.0) /
 DXCCSR_MUS006                (F3.0) /
 DXCCSR_MUS007                (F3.0) /
 DXCCSR_MUS008                (F3.0) /
 DXCCSR_MUS009                (F3.0) /
 DXCCSR_MUS010                (F3.0) /
 DXCCSR_MUS011                (F3.0) /
 DXCCSR_MUS012                (F3.0) /
 DXCCSR_MUS013                (F3.0) /
 DXCCSR_MUS014                (F3.0) /
 DXCCSR_MUS015                (F3.0) /
 DXCCSR_MUS016                (F3.0) /
 DXCCSR_MUS017                (F3.0) /
 DXCCSR_MUS018                (F3.0) /
 DXCCSR_MUS019                (F3.0) /
 DXCCSR_MUS020                (F3.0) /
 DXCCSR_MUS021                (F3.0) /
 DXCCSR_MUS022                (F3.0) /
 DXCCSR_MUS023                (F3.0) /
 DXCCSR_MUS024                (F3.0) /
 DXCCSR_MUS025                (F3.0) /
 DXCCSR_MUS026                (F3.0) /
 DXCCSR_MUS027                (F3.0) /
 DXCCSR_MUS028                (F3.0) /
 DXCCSR_MUS029                (F3.0) /
 DXCCSR_MUS030                (F3.0) /
 DXCCSR_MUS031                (F3.0) /
 DXCCSR_MUS032                (F3.0) /
 DXCCSR_MUS033                (F3.0) /
 DXCCSR_MUS034                (F3.0) /
 DXCCSR_MUS035                (F3.0) /
 DXCCSR_MUS036                (F3.0) /
 DXCCSR_MUS037                (F3.0) /
 DXCCSR_MUS038                (F3.0) /
 DXCCSR_NEO001                (F3.0) /
 DXCCSR_NEO002                (F3.0) /
 DXCCSR_NEO003                (F3.0) /
 DXCCSR_NEO004                (F3.0) /
 DXCCSR_NEO005                (F3.0) /
 DXCCSR_NEO006                (F3.0) /
 DXCCSR_NEO007                (F3.0) /
 DXCCSR_NEO008                (F3.0) /
 DXCCSR_NEO009                (F3.0) /
 DXCCSR_NEO010                (F3.0) /
 DXCCSR_NEO011                (F3.0) /
 DXCCSR_NEO012                (F3.0) /
 DXCCSR_NEO013                (F3.0) /
 DXCCSR_NEO014                (F3.0) /
 DXCCSR_NEO015                (F3.0) /
 DXCCSR_NEO016                (F3.0) /
 DXCCSR_NEO017                (F3.0) /
 DXCCSR_NEO018                (F3.0) /
 DXCCSR_NEO019                (F3.0) /
 DXCCSR_NEO020                (F3.0) /
 DXCCSR_NEO021                (F3.0) /
 DXCCSR_NEO022                (F3.0) /
 DXCCSR_NEO023                (F3.0) /
 DXCCSR_NEO024                (F3.0) /
 DXCCSR_NEO025                (F3.0) /
 DXCCSR_NEO026                (F3.0) /
 DXCCSR_NEO027                (F3.0) /
 DXCCSR_NEO028                (F3.0) /
 DXCCSR_NEO029                (F3.0) /
 DXCCSR_NEO030                (F3.0) /
 DXCCSR_NEO031                (F3.0) /
 DXCCSR_NEO032                (F3.0) /
 DXCCSR_NEO033                (F3.0) /
 DXCCSR_NEO034                (F3.0) /
 DXCCSR_NEO035                (F3.0) /
 DXCCSR_NEO036                (F3.0) /
 DXCCSR_NEO037                (F3.0) /
 DXCCSR_NEO038                (F3.0) /
 DXCCSR_NEO039                (F3.0) /
 DXCCSR_NEO040                (F3.0) /
 DXCCSR_NEO041                (F3.0) /
 DXCCSR_NEO042                (F3.0) /
 DXCCSR_NEO043                (F3.0) /
 DXCCSR_NEO044                (F3.0) /
 DXCCSR_NEO045                (F3.0) /
 DXCCSR_NEO046                (F3.0) /
 DXCCSR_NEO047                (F3.0) /
 DXCCSR_NEO048                (F3.0) /
 DXCCSR_NEO049                (F3.0) /
 DXCCSR_NEO050                (F3.0) /
 DXCCSR_NEO051                (F3.0) /
 DXCCSR_NEO052                (F3.0) /
 DXCCSR_NEO053                (F3.0) /
 DXCCSR_NEO054                (F3.0) /
 DXCCSR_NEO055                (F3.0) /
 DXCCSR_NEO056                (F3.0) /
 DXCCSR_NEO057                (F3.0) /
 DXCCSR_NEO058                (F3.0) /
 DXCCSR_NEO059                (F3.0) /
 DXCCSR_NEO060                (F3.0) /
 DXCCSR_NEO061                (F3.0) /
 DXCCSR_NEO062                (F3.0) /
 DXCCSR_NEO063                (F3.0) /
 DXCCSR_NEO064                (F3.0) /
 DXCCSR_NEO065                (F3.0) /
 DXCCSR_NEO066                (F3.0) /
 DXCCSR_NEO067                (F3.0) /
 DXCCSR_NEO068                (F3.0) /
 DXCCSR_NEO069                (F3.0) /
 DXCCSR_NEO070                (F3.0) /
 DXCCSR_NEO071                (F3.0) /
 DXCCSR_NEO072                (F3.0) /
 DXCCSR_NEO073                (F3.0) /
 DXCCSR_NEO074                (F3.0) /
 DXCCSR_NVS001                (F3.0) /
 DXCCSR_NVS002                (F3.0) /
 DXCCSR_NVS003                (F3.0) /
 DXCCSR_NVS004                (F3.0) /
 DXCCSR_NVS005                (F3.0) /
 DXCCSR_NVS006                (F3.0) /
 DXCCSR_NVS007                (F3.0) /
 DXCCSR_NVS008                (F3.0) /
 DXCCSR_NVS009                (F3.0) /
 DXCCSR_NVS010                (F3.0) /
 DXCCSR_NVS011                (F3.0) /
 DXCCSR_NVS012                (F3.0) /
 DXCCSR_NVS013                (F3.0) /
 DXCCSR_NVS014                (F3.0) /
 DXCCSR_NVS015                (F3.0) /
 DXCCSR_NVS016                (F3.0) /
 DXCCSR_NVS017                (F3.0) /
 DXCCSR_NVS018                (F3.0) /
 DXCCSR_NVS019                (F3.0) /
 DXCCSR_NVS020                (F3.0) /
 DXCCSR_NVS021                (F3.0) /
 DXCCSR_NVS022                (F3.0) /
 DXCCSR_PNL001                (F3.0) /
 DXCCSR_PNL002                (F3.0) /
 DXCCSR_PNL003                (F3.0) /
 DXCCSR_PNL004                (F3.0) /
 DXCCSR_PNL005                (F3.0) /
 DXCCSR_PNL006                (F3.0) /
 DXCCSR_PNL007                (F3.0) /
 DXCCSR_PNL008                (F3.0) /
 DXCCSR_PNL009                (F3.0) /
 DXCCSR_PNL010                (F3.0) /
 DXCCSR_PNL011                (F3.0) /
 DXCCSR_PNL012                (F3.0) /
 DXCCSR_PNL013                (F3.0) /
 DXCCSR_PNL014                (F3.0) /
 DXCCSR_PNL015                (F3.0) /
 DXCCSR_PRG001                (F3.0) /
 DXCCSR_PRG002                (F3.0) /
 DXCCSR_PRG003                (F3.0) /
 DXCCSR_PRG004                (F3.0) /
 DXCCSR_PRG005                (F3.0) /
 DXCCSR_PRG006                (F3.0) /
 DXCCSR_PRG007                (F3.0) /
 DXCCSR_PRG008                (F3.0) /
 DXCCSR_PRG009                (F3.0) /
 DXCCSR_PRG010                (F3.0) /
 DXCCSR_PRG011                (F3.0) /
 DXCCSR_PRG012                (F3.0) /
 DXCCSR_PRG013                (F3.0) /
 DXCCSR_PRG014                (F3.0) /
 DXCCSR_PRG015                (F3.0) /
 DXCCSR_PRG016                (F3.0) /
 DXCCSR_PRG017                (F3.0) /
 DXCCSR_PRG018                (F3.0) /
 DXCCSR_PRG019                (F3.0) /
 DXCCSR_PRG020                (F3.0) /
 DXCCSR_PRG021                (F3.0) /
 DXCCSR_PRG022                (F3.0) /
 DXCCSR_PRG023                (F3.0) /
 DXCCSR_PRG024                (F3.0) /
 DXCCSR_PRG025                (F3.0) /
 DXCCSR_PRG026                (F3.0) /
 DXCCSR_PRG027                (F3.0) /
 DXCCSR_PRG028                (F3.0) /
 DXCCSR_PRG029                (F3.0) /
 DXCCSR_PRG030                (F3.0) /
 DXCCSR_RSP001                (F3.0) /
 DXCCSR_RSP002                (F3.0) /
 DXCCSR_RSP003                (F3.0) /
 DXCCSR_RSP004                (F3.0) /
 DXCCSR_RSP005                (F3.0) /
 DXCCSR_RSP006                (F3.0) /
 DXCCSR_RSP007                (F3.0) /
 DXCCSR_RSP008                (F3.0) /
 DXCCSR_RSP009                (F3.0) /
 DXCCSR_RSP010                (F3.0) /
 DXCCSR_RSP011                (F3.0) /
 DXCCSR_RSP012                (F3.0) /
 DXCCSR_RSP013                (F3.0) /
 DXCCSR_RSP014                (F3.0) /
 DXCCSR_RSP015                (F3.0) /
 DXCCSR_RSP016                (F3.0) /
 DXCCSR_RSP017                (F3.0) /
 DXCCSR_SKN001                (F3.0) /
 DXCCSR_SKN002                (F3.0) /
 DXCCSR_SKN003                (F3.0) /
 DXCCSR_SKN004                (F3.0) /
 DXCCSR_SKN005                (F3.0) /
 DXCCSR_SKN006                (F3.0) /
 DXCCSR_SKN007                (F3.0) /
 DXCCSR_SYM001                (F3.0) /
 DXCCSR_SYM002                (F3.0) /
 DXCCSR_SYM003                (F3.0) /
 DXCCSR_SYM004                (F3.0) /
 DXCCSR_SYM005                (F3.0) /
 DXCCSR_SYM006                (F3.0) /
 DXCCSR_SYM007                (F3.0) /
 DXCCSR_SYM008                (F3.0) /
 DXCCSR_SYM009                (F3.0) /
 DXCCSR_SYM010                (F3.0) /
 DXCCSR_SYM011                (F3.0) /
 DXCCSR_SYM012                (F3.0) /
 DXCCSR_SYM013                (F3.0) /
 DXCCSR_SYM014                (F3.0) /
 DXCCSR_SYM015                (F3.0) /
 DXCCSR_SYM016                (F3.0) /
 DXCCSR_SYM017                (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_INJURY_CUT               (F3.0) /
 I10_INJURY_DROWN             (F3.0) /
 I10_INJURY_FALL              (F3.0) /
 I10_INJURY_FIRE              (F3.0) /
 I10_INJURY_FIREARM           (F3.0) /
 I10_INJURY_MACHINERY         (F3.0) /
 I10_INJURY_MVT               (F3.0) /
 I10_INJURY_NATURE            (F3.0) /
 I10_INJURY_OVEREXERTION      (F3.0) /
 I10_INJURY_POISON            (F3.0) /
 I10_INJURY_STRUCK            (F3.0) /
 I10_INJURY_SUFFOCATION       (F3.0) /
 I10_INTENT_ASSAULT           (F3.0) /
 I10_INTENT_SELF_HARM         (F3.0) /
 I10_INTENT_UNINTENTIONAL     (F3.0) /
 I10_MULTINJURY               (F3.0) /
 KEY                          (F8.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 CMR_AIDS                     "Acquired immune deficiency syndrome"
 CMR_ALCOHOL                  "Alcohol abuse"
 CMR_ANEMDEF                  "Anemias due to other nutritional deficiencies"
 CMR_AUTOIMMUNE               "Autoimmune conditions"
 CMR_BLDLOSS                  "Chronic blood loss anemia (iron deficiency)"
 CMR_CANCER_LEUK              "Leukemia"
 CMR_CANCER_LYMPH             "Lymphoma"
 CMR_CANCER_METS              "Metastatic cancer"
 CMR_CANCER_NSITU             "Solid tumor without metastasis, in situ"
 CMR_CANCER_SOLID             "Solid tumor without metastasis, malignant"
 CMR_CBVD                     "Cerebrovascular disease"
 CMR_COAG                     "Coagulopathy"
 CMR_DEMENTIA                 "Dementia"
 CMR_DEPRESS                  "Depression"
 CMR_DIAB_CX                  "Diabetes with chronic complications"
 CMR_DIAB_UNCX                "Diabetes without chronic complications"
 CMR_DRUG_ABUSE               "Drug abuse"
 CMR_HF                       "Heart failure"
 CMR_HTN_CX                   "Hypertension, complicated"
 CMR_HTN_UNCX                 "Hypertension, uncomplicated"
 CMR_LIVER_MLD                "Liver disease, mild"
 CMR_LIVER_SEV                "Liver disease, moderate to severe"
 CMR_LUNG_CHRONIC             "Chronic pulmonary disease"
 CMR_NEURO_MOVT               "Neurological disorders affecting movement"
 CMR_NEURO_OTH                "Other neurological disorders"
 CMR_NEURO_SEIZ               "Seizures and epilepsy"
 CMR_OBESE                    "Obesity"
 CMR_PARALYSIS                "Paralysis"
 CMR_PERIVASC                 "Peripheral vascular disease"
 CMR_PSYCHOSES                "Psychoses"
 CMR_PULMCIRC                 "Pulmonary circulation disease"
 CMR_RENLFL_MOD               "Renal failure, moderate"
 CMR_RENLFL_SEV               "Renal failure, severe"
 CMR_THYROID_HYPO             "Hypothyroidism"
 CMR_THYROID_OTH              "Other thyroid disorders"
 CMR_ULCER_PEPTIC             "Peptic ulcer disease x bleeding"
 CMR_VALVE                    "Valvular disease"
 CMR_VERSION                  "Version of Elixhauser Comorbidity Software Refined"
 CMR_WGHTLOSS                 "Weight loss"
 DXCCSR_BLD001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD001"
 DXCCSR_BLD002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD002"
 DXCCSR_BLD003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD003"
 DXCCSR_BLD004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD004"
 DXCCSR_BLD005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD005"
 DXCCSR_BLD006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD006"
 DXCCSR_BLD007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD007"
 DXCCSR_BLD008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD008"
 DXCCSR_BLD009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD009"
 DXCCSR_BLD010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD010"
 DXCCSR_CIR001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR001"
 DXCCSR_CIR002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR002"
 DXCCSR_CIR003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR003"
 DXCCSR_CIR004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR004"
 DXCCSR_CIR005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR005"
 DXCCSR_CIR006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR006"
 DXCCSR_CIR007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR007"
 DXCCSR_CIR008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR008"
 DXCCSR_CIR009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR009"
 DXCCSR_CIR010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR010"
 DXCCSR_CIR011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR011"
 DXCCSR_CIR012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR012"
 DXCCSR_CIR013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR013"
 DXCCSR_CIR014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR014"
 DXCCSR_CIR015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR015"
 DXCCSR_CIR016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR016"
 DXCCSR_CIR017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR017"
 DXCCSR_CIR018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR018"
 DXCCSR_CIR019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR019"
 DXCCSR_CIR020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR020"
 DXCCSR_CIR021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR021"
 DXCCSR_CIR022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR022"
 DXCCSR_CIR023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR023"
 DXCCSR_CIR024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR024"
 DXCCSR_CIR025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR025"
 DXCCSR_CIR026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR026"
 DXCCSR_CIR027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR027"
 DXCCSR_CIR028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR028"
 DXCCSR_CIR029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR029"
 DXCCSR_CIR030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR030"
 DXCCSR_CIR031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR031"
 DXCCSR_CIR032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR032"
 DXCCSR_CIR033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR033"
 DXCCSR_CIR034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR034"
 DXCCSR_CIR035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR035"
 DXCCSR_CIR036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR036"
 DXCCSR_CIR037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR037"
 DXCCSR_CIR038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR038"
 DXCCSR_CIR039
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR039"
 DXCCSR_Default_DX1           "Default CCSR for principal/first-listed ICD-10-CM diagnosis"
 DXCCSR_DEN001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN001"
 DXCCSR_DEN002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN002"
 DXCCSR_DEN003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN003"
 DXCCSR_DIG001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG001"
 DXCCSR_DIG002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG002"
 DXCCSR_DIG003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG003"
 DXCCSR_DIG004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG004"
 DXCCSR_DIG005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG005"
 DXCCSR_DIG006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG006"
 DXCCSR_DIG007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG007"
 DXCCSR_DIG008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG008"
 DXCCSR_DIG009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG009"
 DXCCSR_DIG010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG010"
 DXCCSR_DIG011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG011"
 DXCCSR_DIG012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG012"
 DXCCSR_DIG013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG013"
 DXCCSR_DIG014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG014"
 DXCCSR_DIG015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG015"
 DXCCSR_DIG016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG016"
 DXCCSR_DIG017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG017"
 DXCCSR_DIG018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG018"
 DXCCSR_DIG019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG019"
 DXCCSR_DIG020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG020"
 DXCCSR_DIG021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG021"
 DXCCSR_DIG022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG022"
 DXCCSR_DIG023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG023"
 DXCCSR_DIG024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG024"
 DXCCSR_DIG025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG025"
 DXCCSR_EAR001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR001"
 DXCCSR_EAR002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR002"
 DXCCSR_EAR003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR003"
 DXCCSR_EAR004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR004"
 DXCCSR_EAR005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR005"
 DXCCSR_EAR006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR006"
 DXCCSR_END001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END001"
 DXCCSR_END002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END002"
 DXCCSR_END003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END003"
 DXCCSR_END004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END004"
 DXCCSR_END005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END005"
 DXCCSR_END006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END006"
 DXCCSR_END007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END007"
 DXCCSR_END008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END008"
 DXCCSR_END009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END009"
 DXCCSR_END010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END010"
 DXCCSR_END011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END011"
 DXCCSR_END012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END012"
 DXCCSR_END013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END013"
 DXCCSR_END014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END014"
 DXCCSR_END015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END015"
 DXCCSR_END016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END016"
 DXCCSR_END017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END017"
 DXCCSR_EXT001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT001"
 DXCCSR_EXT002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT002"
 DXCCSR_EXT003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT003"
 DXCCSR_EXT004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT004"
 DXCCSR_EXT005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT005"
 DXCCSR_EXT006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT006"
 DXCCSR_EXT007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT007"
 DXCCSR_EXT008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT008"
 DXCCSR_EXT009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT009"
 DXCCSR_EXT010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT010"
 DXCCSR_EXT011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT011"
 DXCCSR_EXT012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT012"
 DXCCSR_EXT013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT013"
 DXCCSR_EXT014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT014"
 DXCCSR_EXT015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT015"
 DXCCSR_EXT016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT016"
 DXCCSR_EXT017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT017"
 DXCCSR_EXT018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT018"
 DXCCSR_EXT019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT019"
 DXCCSR_EXT020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT020"
 DXCCSR_EXT021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT021"
 DXCCSR_EXT022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT022"
 DXCCSR_EXT023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT023"
 DXCCSR_EXT024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT024"
 DXCCSR_EXT025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT025"
 DXCCSR_EXT026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT026"
 DXCCSR_EXT027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT027"
 DXCCSR_EXT028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT028"
 DXCCSR_EXT029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT029"
 DXCCSR_EXT030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT030"
 DXCCSR_EYE001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE001"
 DXCCSR_EYE002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE002"
 DXCCSR_EYE003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE003"
 DXCCSR_EYE004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE004"
 DXCCSR_EYE005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE005"
 DXCCSR_EYE006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE006"
 DXCCSR_EYE007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE007"
 DXCCSR_EYE008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE008"
 DXCCSR_EYE009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE009"
 DXCCSR_EYE010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE010"
 DXCCSR_EYE011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE011"
 DXCCSR_EYE012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE012"
 DXCCSR_FAC001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC001"
 DXCCSR_FAC002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC002"
 DXCCSR_FAC003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC003"
 DXCCSR_FAC004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC004"
 DXCCSR_FAC005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC005"
 DXCCSR_FAC006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC006"
 DXCCSR_FAC007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC007"
 DXCCSR_FAC008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC008"
 DXCCSR_FAC009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC009"
 DXCCSR_FAC010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC010"
 DXCCSR_FAC011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC011"
 DXCCSR_FAC012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC012"
 DXCCSR_FAC013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC013"
 DXCCSR_FAC014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC014"
 DXCCSR_FAC015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC015"
 DXCCSR_FAC016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC016"
 DXCCSR_FAC017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC017"
 DXCCSR_FAC018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC018"
 DXCCSR_FAC019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC019"
 DXCCSR_FAC020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC020"
 DXCCSR_FAC021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC021"
 DXCCSR_FAC022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC022"
 DXCCSR_FAC023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC023"
 DXCCSR_FAC024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC024"
 DXCCSR_FAC025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC025"
 DXCCSR_GEN001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN001"
 DXCCSR_GEN002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN002"
 DXCCSR_GEN003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN003"
 DXCCSR_GEN004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN004"
 DXCCSR_GEN005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN005"
 DXCCSR_GEN006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN006"
 DXCCSR_GEN007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN007"
 DXCCSR_GEN008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN008"
 DXCCSR_GEN009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN009"
 DXCCSR_GEN010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN010"
 DXCCSR_GEN011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN011"
 DXCCSR_GEN012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN012"
 DXCCSR_GEN013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN013"
 DXCCSR_GEN014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN014"
 DXCCSR_GEN015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN015"
 DXCCSR_GEN016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN016"
 DXCCSR_GEN017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN017"
 DXCCSR_GEN018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN018"
 DXCCSR_GEN019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN019"
 DXCCSR_GEN020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN020"
 DXCCSR_GEN021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN021"
 DXCCSR_GEN022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN022"
 DXCCSR_GEN023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN023"
 DXCCSR_GEN024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN024"
 DXCCSR_GEN025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN025"
 DXCCSR_GEN026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN026"
 DXCCSR_INF001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF001"
 DXCCSR_INF002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF002"
 DXCCSR_INF003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF003"
 DXCCSR_INF004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF004"
 DXCCSR_INF005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF005"
 DXCCSR_INF006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF006"
 DXCCSR_INF007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF007"
 DXCCSR_INF008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF008"
 DXCCSR_INF009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF009"
 DXCCSR_INF010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF010"
 DXCCSR_INF011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF011"
 DXCCSR_INF012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF012"
 DXCCSR_INJ001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ001"
 DXCCSR_INJ002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ002"
 DXCCSR_INJ003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ003"
 DXCCSR_INJ004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ004"
 DXCCSR_INJ005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ005"
 DXCCSR_INJ006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ006"
 DXCCSR_INJ007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ007"
 DXCCSR_INJ008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ008"
 DXCCSR_INJ009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ009"
 DXCCSR_INJ010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ010"
 DXCCSR_INJ011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ011"
 DXCCSR_INJ012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ012"
 DXCCSR_INJ013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ013"
 DXCCSR_INJ014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ014"
 DXCCSR_INJ015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ015"
 DXCCSR_INJ016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ016"
 DXCCSR_INJ017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ017"
 DXCCSR_INJ018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ018"
 DXCCSR_INJ019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ019"
 DXCCSR_INJ020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ020"
 DXCCSR_INJ021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ021"
 DXCCSR_INJ022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ022"
 DXCCSR_INJ023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ023"
 DXCCSR_INJ024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ024"
 DXCCSR_INJ025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ025"
 DXCCSR_INJ026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ026"
 DXCCSR_INJ027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ027"
 DXCCSR_INJ028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ028"
 DXCCSR_INJ029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ029"
 DXCCSR_INJ030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ030"
 DXCCSR_INJ031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ031"
 DXCCSR_INJ032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ032"
 DXCCSR_INJ033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ033"
 DXCCSR_INJ034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ034"
 DXCCSR_INJ035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ035"
 DXCCSR_INJ036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ036"
 DXCCSR_INJ037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ037"
 DXCCSR_INJ038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ038"
 DXCCSR_INJ039
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ039"
 DXCCSR_INJ040
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ040"
 DXCCSR_INJ041
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ041"
 DXCCSR_INJ042
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ042"
 DXCCSR_INJ043
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ043"
 DXCCSR_INJ044
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ044"
 DXCCSR_INJ045
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ045"
 DXCCSR_INJ046
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ046"
 DXCCSR_INJ047
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ047"
 DXCCSR_INJ048
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ048"
 DXCCSR_INJ049
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ049"
 DXCCSR_INJ050
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ050"
 DXCCSR_INJ051
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ051"
 DXCCSR_INJ052
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ052"
 DXCCSR_INJ053
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ053"
 DXCCSR_INJ054
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ054"
 DXCCSR_INJ055
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ055"
 DXCCSR_INJ056
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ056"
 DXCCSR_INJ057
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ057"
 DXCCSR_INJ058
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ058"
 DXCCSR_INJ059
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ059"
 DXCCSR_INJ060
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ060"
 DXCCSR_INJ061
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ061"
 DXCCSR_INJ062
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ062"
 DXCCSR_INJ063
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ063"
 DXCCSR_INJ064
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ064"
 DXCCSR_INJ065
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ065"
 DXCCSR_INJ066
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ066"
 DXCCSR_INJ067
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ067"
 DXCCSR_INJ068
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ068"
 DXCCSR_INJ069
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ069"
 DXCCSR_INJ070
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ070"
 DXCCSR_INJ071
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ071"
 DXCCSR_INJ072
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ072"
 DXCCSR_INJ073
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ073"
 DXCCSR_INJ074
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ074"
 DXCCSR_INJ075
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ075"
 DXCCSR_INJ076
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ076"
 DXCCSR_MAL001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL001"
 DXCCSR_MAL002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL002"
 DXCCSR_MAL003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL003"
 DXCCSR_MAL004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL004"
 DXCCSR_MAL005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL005"
 DXCCSR_MAL006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL006"
 DXCCSR_MAL007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL007"
 DXCCSR_MAL008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL008"
 DXCCSR_MAL009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL009"
 DXCCSR_MAL010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL010"
 DXCCSR_MBD001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD001"
 DXCCSR_MBD002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD002"
 DXCCSR_MBD003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD003"
 DXCCSR_MBD004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD004"
 DXCCSR_MBD005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD005"
 DXCCSR_MBD006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD006"
 DXCCSR_MBD007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD007"
 DXCCSR_MBD008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD008"
 DXCCSR_MBD009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD009"
 DXCCSR_MBD010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD010"
 DXCCSR_MBD011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD011"
 DXCCSR_MBD012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD012"
 DXCCSR_MBD013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD013"
 DXCCSR_MBD014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD014"
 DXCCSR_MBD017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD017"
 DXCCSR_MBD018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD018"
 DXCCSR_MBD019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD019"
 DXCCSR_MBD020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD020"
 DXCCSR_MBD021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD021"
 DXCCSR_MBD022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD022"
 DXCCSR_MBD023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD023"
 DXCCSR_MBD024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD024"
 DXCCSR_MBD025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD025"
 DXCCSR_MBD026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD026"
 DXCCSR_MBD027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD027"
 DXCCSR_MBD028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD028"
 DXCCSR_MBD029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD029"
 DXCCSR_MBD030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD030"
 DXCCSR_MBD031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD031"
 DXCCSR_MBD032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD032"
 DXCCSR_MBD033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD033"
 DXCCSR_MBD034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD034"
 DXCCSR_MUS001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS001"
 DXCCSR_MUS002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS002"
 DXCCSR_MUS003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS003"
 DXCCSR_MUS004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS004"
 DXCCSR_MUS005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS005"
 DXCCSR_MUS006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS006"
 DXCCSR_MUS007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS007"
 DXCCSR_MUS008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS008"
 DXCCSR_MUS009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS009"
 DXCCSR_MUS010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS010"
 DXCCSR_MUS011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS011"
 DXCCSR_MUS012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS012"
 DXCCSR_MUS013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS013"
 DXCCSR_MUS014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS014"
 DXCCSR_MUS015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS015"
 DXCCSR_MUS016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS016"
 DXCCSR_MUS017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS017"
 DXCCSR_MUS018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS018"
 DXCCSR_MUS019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS019"
 DXCCSR_MUS020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS020"
 DXCCSR_MUS021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS021"
 DXCCSR_MUS022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS022"
 DXCCSR_MUS023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS023"
 DXCCSR_MUS024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS024"
 DXCCSR_MUS025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS025"
 DXCCSR_MUS026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS026"
 DXCCSR_MUS027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS027"
 DXCCSR_MUS028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS028"
 DXCCSR_MUS029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS029"
 DXCCSR_MUS030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS030"
 DXCCSR_MUS031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS031"
 DXCCSR_MUS032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS032"
 DXCCSR_MUS033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS033"
 DXCCSR_MUS034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS034"
 DXCCSR_MUS035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS035"
 DXCCSR_MUS036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS036"
 DXCCSR_MUS037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS037"
 DXCCSR_MUS038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS038"
 DXCCSR_NEO001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO001"
 DXCCSR_NEO002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO002"
 DXCCSR_NEO003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO003"
 DXCCSR_NEO004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO004"
 DXCCSR_NEO005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO005"
 DXCCSR_NEO006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO006"
 DXCCSR_NEO007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO007"
 DXCCSR_NEO008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO008"
 DXCCSR_NEO009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO009"
 DXCCSR_NEO010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO010"
 DXCCSR_NEO011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO011"
 DXCCSR_NEO012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO012"
 DXCCSR_NEO013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO013"
 DXCCSR_NEO014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO014"
 DXCCSR_NEO015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO015"
 DXCCSR_NEO016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO016"
 DXCCSR_NEO017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO017"
 DXCCSR_NEO018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO018"
 DXCCSR_NEO019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO019"
 DXCCSR_NEO020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO020"
 DXCCSR_NEO021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO021"
 DXCCSR_NEO022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO022"
 DXCCSR_NEO023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO023"
 DXCCSR_NEO024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO024"
 DXCCSR_NEO025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO025"
 DXCCSR_NEO026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO026"
 DXCCSR_NEO027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO027"
 DXCCSR_NEO028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO028"
 DXCCSR_NEO029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO029"
 DXCCSR_NEO030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO030"
 DXCCSR_NEO031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO031"
 DXCCSR_NEO032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO032"
 DXCCSR_NEO033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO033"
 DXCCSR_NEO034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO034"
 DXCCSR_NEO035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO035"
 DXCCSR_NEO036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO036"
 DXCCSR_NEO037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO037"
 DXCCSR_NEO038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO038"
 DXCCSR_NEO039
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO039"
 DXCCSR_NEO040
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO040"
 DXCCSR_NEO041
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO041"
 DXCCSR_NEO042
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO042"
 DXCCSR_NEO043
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO043"
 DXCCSR_NEO044
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO044"
 DXCCSR_NEO045
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO045"
 DXCCSR_NEO046
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO046"
 DXCCSR_NEO047
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO047"
 DXCCSR_NEO048
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO048"
 DXCCSR_NEO049
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO049"
 DXCCSR_NEO050
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO050"
 DXCCSR_NEO051
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO051"
 DXCCSR_NEO052
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO052"
 DXCCSR_NEO053
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO053"
 DXCCSR_NEO054
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO054"
 DXCCSR_NEO055
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO055"
 DXCCSR_NEO056
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO056"
 DXCCSR_NEO057
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO057"
 DXCCSR_NEO058
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO058"
 DXCCSR_NEO059
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO059"
 DXCCSR_NEO060
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO060"
 DXCCSR_NEO061
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO061"
 DXCCSR_NEO062
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO062"
 DXCCSR_NEO063
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO063"
 DXCCSR_NEO064
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO064"
 DXCCSR_NEO065
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO065"
 DXCCSR_NEO066
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO066"
 DXCCSR_NEO067
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO067"
 DXCCSR_NEO068
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO068"
 DXCCSR_NEO069
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO069"
 DXCCSR_NEO070
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO070"
 DXCCSR_NEO071
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO071"
 DXCCSR_NEO072
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO072"
 DXCCSR_NEO073
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO073"
 DXCCSR_NEO074
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO074"
 DXCCSR_NVS001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS001"
 DXCCSR_NVS002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS002"
 DXCCSR_NVS003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS003"
 DXCCSR_NVS004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS004"
 DXCCSR_NVS005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS005"
 DXCCSR_NVS006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS006"
 DXCCSR_NVS007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS007"
 DXCCSR_NVS008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS008"
 DXCCSR_NVS009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS009"
 DXCCSR_NVS010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS010"
 DXCCSR_NVS011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS011"
 DXCCSR_NVS012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS012"
 DXCCSR_NVS013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS013"
 DXCCSR_NVS014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS014"
 DXCCSR_NVS015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS015"
 DXCCSR_NVS016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS016"
 DXCCSR_NVS017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS017"
 DXCCSR_NVS018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS018"
 DXCCSR_NVS019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS019"
 DXCCSR_NVS020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS020"
 DXCCSR_NVS021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS021"
 DXCCSR_NVS022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS022"
 DXCCSR_PNL001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL001"
 DXCCSR_PNL002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL002"
 DXCCSR_PNL003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL003"
 DXCCSR_PNL004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL004"
 DXCCSR_PNL005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL005"
 DXCCSR_PNL006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL006"
 DXCCSR_PNL007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL007"
 DXCCSR_PNL008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL008"
 DXCCSR_PNL009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL009"
 DXCCSR_PNL010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL010"
 DXCCSR_PNL011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL011"
 DXCCSR_PNL012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL012"
 DXCCSR_PNL013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL013"
 DXCCSR_PNL014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL014"
 DXCCSR_PNL015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL015"
 DXCCSR_PRG001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG001"
 DXCCSR_PRG002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG002"
 DXCCSR_PRG003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG003"
 DXCCSR_PRG004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG004"
 DXCCSR_PRG005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG005"
 DXCCSR_PRG006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG006"
 DXCCSR_PRG007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG007"
 DXCCSR_PRG008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG008"
 DXCCSR_PRG009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG009"
 DXCCSR_PRG010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG010"
 DXCCSR_PRG011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG011"
 DXCCSR_PRG012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG012"
 DXCCSR_PRG013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG013"
 DXCCSR_PRG014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG014"
 DXCCSR_PRG015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG015"
 DXCCSR_PRG016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG016"
 DXCCSR_PRG017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG017"
 DXCCSR_PRG018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG018"
 DXCCSR_PRG019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG019"
 DXCCSR_PRG020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG020"
 DXCCSR_PRG021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG021"
 DXCCSR_PRG022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG022"
 DXCCSR_PRG023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG023"
 DXCCSR_PRG024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG024"
 DXCCSR_PRG025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG025"
 DXCCSR_PRG026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG026"
 DXCCSR_PRG027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG027"
 DXCCSR_PRG028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG028"
 DXCCSR_PRG029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG029"
 DXCCSR_PRG030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG030"
 DXCCSR_RSP001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP001"
 DXCCSR_RSP002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP002"
 DXCCSR_RSP003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP003"
 DXCCSR_RSP004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP004"
 DXCCSR_RSP005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP005"
 DXCCSR_RSP006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP006"
 DXCCSR_RSP007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP007"
 DXCCSR_RSP008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP008"
 DXCCSR_RSP009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP009"
 DXCCSR_RSP010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP010"
 DXCCSR_RSP011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP011"
 DXCCSR_RSP012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP012"
 DXCCSR_RSP013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP013"
 DXCCSR_RSP014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP014"
 DXCCSR_RSP015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP015"
 DXCCSR_RSP016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP016"
 DXCCSR_RSP017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP017"
 DXCCSR_SKN001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN001"
 DXCCSR_SKN002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN002"
 DXCCSR_SKN003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN003"
 DXCCSR_SKN004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN004"
 DXCCSR_SKN005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN005"
 DXCCSR_SKN006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN006"
 DXCCSR_SKN007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN007"
 DXCCSR_SYM001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM001"
 DXCCSR_SYM002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM002"
 DXCCSR_SYM003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM003"
 DXCCSR_SYM004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM004"
 DXCCSR_SYM005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM005"
 DXCCSR_SYM006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM006"
 DXCCSR_SYM007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM007"
 DXCCSR_SYM008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM008"
 DXCCSR_SYM009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM009"
 DXCCSR_SYM010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM010"
 DXCCSR_SYM011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM011"
 DXCCSR_SYM012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM012"
 DXCCSR_SYM013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM013"
 DXCCSR_SYM014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM014"
 DXCCSR_SYM015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM015"
 DXCCSR_SYM016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM016"
 DXCCSR_SYM017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM017"
 DXCCSR_VERSION               "Version of CCSR for ICD-10-CM diagnoses"
 I10_INJURY

"Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)
"
 I10_INJURY_CUT               "Mechanism of injury: cut or pierce"
 I10_INJURY_DROWN             "Mechanism of injury: drowning or submersion"
 I10_INJURY_FALL              "Mechanism of injury: fall"
 I10_INJURY_FIRE              "Mechanism of injury: fire, flame, hot object, or hot substance"
 I10_INJURY_FIREARM           "Mechanism of injury: firearm"
 I10_INJURY_MACHINERY         "Mechanism of injury: machinery"
 I10_INJURY_MVT

"Mechanism of injury: motor vehicle traffic, including the occupant of a car, motorcyclist, pedal cyclist, pedestrian, o
ther, or unspecified"
 I10_INJURY_NATURE
"Mechanism of injury: natural or environmental, included venomous and nonvenomous bites and stings"
 I10_INJURY_OVEREXERTION      "Mechanism of injury: overexertion"
 I10_INJURY_POISON            "Mechanism of injury: poisoning, including drugs and nondrugs"
 I10_INJURY_STRUCK            "Mechanism of injury: struck by or against"
 I10_INJURY_SUFFOCATION       "Mechanism of injury: suffocation"
 I10_INTENT_ASSAULT           "Intent of injury: assault"
 I10_INTENT_SELF_HARM         "Intent of injury: intentional self-harm"
 I10_INTENT_UNINTENTIONAL     "Intent of injury: unintentional"
 I10_MULTINJURY               "Multiple ICD-10-CM injuries reported on record"
 KEY                          "HCUP record identifier" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE CMR_AIDS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_ALCOHOL
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_ANEMDEF
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_AUTOIMMUNE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_BLDLOSS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_LEUK
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_LYMPH
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_METS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_NSITU
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_SOLID
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CBVD
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_COAG
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DEMENTIA
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DEPRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DIAB_CX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DIAB_UNCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DRUG_ABUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_HF
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_HTN_CX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_HTN_UNCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_LIVER_MLD
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_LIVER_SEV
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_LUNG_CHRONIC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_NEURO_MOVT
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_NEURO_OTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_NEURO_SEIZ
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_OBESE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PARALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PERIVASC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PSYCHOSES
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PULMCIRC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_RENLFL_MOD
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_RENLFL_SEV
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_THYROID_HYPO
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_THYROID_OTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_ULCER_PEPTIC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_VALVE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_WGHTLOSS
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCSR_BLD001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR039
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DEN001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DEN002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DEN003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ039
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ040
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ041
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ042
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ043
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ044
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ045
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ046
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ047
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ048
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ049
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ050
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ051
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ052
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ053
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ054
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ055
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ056
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ057
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ058
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ059
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ060
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ061
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ062
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ063
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ064
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ065
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ066
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ067
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ068
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ069
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ070
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ071
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ072
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ073
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ074
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ075
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ076
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO039
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO040
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO041
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO042
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO043
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO044
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO045
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO046
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO047
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO048
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO049
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO050
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO051
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO052
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO053
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO054
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO055
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO056
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO057
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO058
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO059
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO060
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO061
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO062
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO063
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO064
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO065
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO066
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO067
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO068
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO069
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO070
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO071
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO072
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO073
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO074
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM017
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_OVEREXERTION
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'UT_SEDD_2022_DX_PR_GRPS.sav' /COMPRESSED.
