/*******************************************************************
*   UT_SEDD_2007_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'UT_SEDD_2007_CHGS.ASC' FIXED / 
 CHG1                       1-  12
 CHG2                      13-  24
 CHG3                      25-  36
 KEY                       37-  50.


***  Specify write formats  ***.
FORMATS
 CHG1                    (F6.2) /
 CHG2                    (F6.2) /
 CHG3                    (F6.2) /
 KEY                     (F8.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHG1      "Detailed charges 1 (as received from source)"
 CHG2      "Detailed charges 2 (as received from source)"
 CHG3      "Detailed charges 3 (as received from source)"
 KEY       "HCUP record identifier" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).



SAVE OUTFILE = 'UT_SEDD_2007_CHGS.SAV' /COMPRESSED.
