/*******************************************************************
*   UT_SEDD_2002_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'UT_SEDD_2002_CHGS.ASC' FIXED / 
 KEY                   1-  14
 CHG1                 15-  26
 CHG2                 27-  38
 CHG3                 39-  50.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 CHG1                (F6.2) /
 CHG2                (F6.2) /
 CHG3                (F6.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CHG1      "Detailed charges 1 (as received from source)"
 CHG2      "Detailed charges 2 (as received from source)"
 CHG3      "Detailed charges 3 (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).



SAVE OUTFILE = 'UT_SEDD_2002_CHGS.SAV' /COMPRESSED.
