/*******************************************************************
* Creation Date: 12/01/2016   
*   MD_SEDD_2010_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MD_SEDD_2010_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 CHRON1                          1-   2
 CHRON2                          3-   4
 CHRON3                          5-   6
 CHRON4                          7-   8
 CHRON5                          9-  10
 CHRON6                         11-  12
 CHRON7                         13-  14
 CHRON8                         15-  16
 CHRON9                         17-  18
 CHRON10                        19-  20
 CHRON11                        21-  22
 CHRON12                        23-  24
 CHRON13                        25-  26
 CHRON14                        27-  28
 CHRON15                        29-  30
 CHRON16                        31-  32
 CHRONB1                        33-  34
 CHRONB2                        35-  36
 CHRONB3                        37-  38
 CHRONB4                        39-  40
 CHRONB5                        41-  42
 CHRONB6                        43-  44
 CHRONB7                        45-  46
 CHRONB8                        47-  48
 CHRONB9                        49-  50
 CHRONB10                       51-  52
 CHRONB11                       53-  54
 CHRONB12                       55-  56
 CHRONB13                       57-  58
 CHRONB14                       59-  60
 CHRONB15                       61-  62
 CHRONB16                       63-  64
 DXMCCS1                        65-  75 (A)
 DXMCCS2                        76-  86 (A)
 DXMCCS3                        87-  97 (A)
 DXMCCS4                        98- 108 (A)
 DXMCCS5                       109- 119 (A)
 DXMCCS6                       120- 130 (A)
 DXMCCS7                       131- 141 (A)
 DXMCCS8                       142- 152 (A)
 DXMCCS9                       153- 163 (A)
 DXMCCS10                      164- 174 (A)
 DXMCCS11                      175- 185 (A)
 DXMCCS12                      186- 196 (A)
 DXMCCS13                      197- 207 (A)
 DXMCCS14                      208- 218 (A)
 DXMCCS15                      219- 229 (A)
 DXMCCS16                      230- 240 (A)
 E_MCCS1                       241- 251 (A)
 E_MCCS2                       252- 262 (A)
 E_MCCS3                       263- 273 (A)
 E_MCCS4                       274- 284 (A)
 E_MCCS5                       285- 295 (A)
 E_MCCS6                       296- 306 (A)
 E_MCCS7                       307- 317 (A)
 E_MCCS8                       318- 328 (A)
 KEY                           329- 343
 U_BLOOD                       344- 345
 U_CATH                        346- 347
 U_CCU                         348- 349
 U_CHESTXRAY                   350- 351
 U_CTSCAN                      352- 353
 U_DIALYSIS                    354- 355
 U_ECHO                        356- 357
 U_ED                          358- 359
 U_EEG                         360- 361
 U_EKG                         362- 363
 U_EPO                         364- 365
 U_ICU                         366- 367
 U_LITHOTRIPSY                 368- 369
 U_MHSA                        370- 371
 U_MRT                         372- 373
 U_NEWBN2L                     374- 375
 U_NEWBN3L                     376- 377
 U_NEWBN4L                     378- 379
 U_NUCMED                      380- 381
 U_OBSERVATION                 382- 383
 U_OCCTHERAPY                  384- 385
 U_ORGANACQ                    386- 387
 U_OTHIMPLANTS                 388- 389
 U_PACEMAKER                   390- 391
 U_PHYTHERAPY                  392- 393
 U_RADTHERAPY                  394- 395
 U_RESPTHERAPY                 396- 397
 U_SPEECHTHERAPY               398- 399
 U_STRESS                      400- 401
 U_ULTRASOUND                  402- 403.


***  Specify write formats  ***.
FORMATS
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRONB1                      (F3.0) /
 CHRONB2                      (F3.0) /
 CHRONB3                      (F3.0) /
 CHRONB4                      (F3.0) /
 CHRONB5                      (F3.0) /
 CHRONB6                      (F3.0) /
 CHRONB7                      (F3.0) /
 CHRONB8                      (F3.0) /
 CHRONB9                      (F3.0) /
 CHRONB10                     (F3.0) /
 CHRONB11                     (F3.0) /
 CHRONB12                     (F3.0) /
 CHRONB13                     (F3.0) /
 CHRONB14                     (F3.0) /
 CHRONB15                     (F3.0) /
 CHRONB16                     (F3.0) /
 KEY                          (F8.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRONB1                      "Chronic condition body system 1"
 CHRONB2                      "Chronic condition body system 2"
 CHRONB3                      "Chronic condition body system 3"
 CHRONB4                      "Chronic condition body system 4"
 CHRONB5                      "Chronic condition body system 5"
 CHRONB6                      "Chronic condition body system 6"
 CHRONB7                      "Chronic condition body system 7"
 CHRONB8                      "Chronic condition body system 8"
 CHRONB9                      "Chronic condition body system 9"
 CHRONB10                     "Chronic condition body system 10"
 CHRONB11                     "Chronic condition body system 11"
 CHRONB12                     "Chronic condition body system 12"
 CHRONB13                     "Chronic condition body system 13"
 CHRONB14                     "Chronic condition body system 14"
 CHRONB15                     "Chronic condition body system 15"
 CHRONB16                     "Chronic condition body system 16"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 KEY                          "HCUP record identifier"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MD_SEDD_2010_DX_PR_GRPS.SAV' /COMPRESSED.
