/*******************************************************************
*   MA_SEDD_2004_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MA_SEDD_2004_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEMONTH                  18-  20
 AHOUR                     21-  24
 AMONTH                    25-  26
 ASOURCE                   27-  28
 ASOURCE_                  29     (A)
 ATYPE                     30-  31
 AWEEKEND                  32-  33
 CPT1                      34-  38 (A)
 CPT2                      39-  43 (A)
 CPT3                      44-  48 (A)
 CPT4                      49-  53 (A)
 CPT5                      54-  58 (A)
 CPT6                      59-  63 (A)
 CPT7                      64-  68 (A)
 CPT8                      69-  73 (A)
 CPT9                      74-  78 (A)
 CPT10                     79-  83 (A)
 CPT11                     84-  88 (A)
 CPT12                     89-  93 (A)
 CPT13                     94-  98 (A)
 CPT14                     99- 103 (A)
 CPT15                    104- 108 (A)
 CPT16                    109- 113 (A)
 CPT17                    114- 118 (A)
 CPT18                    119- 123 (A)
 CPT19                    124- 128 (A)
 CPT20                    129- 133 (A)
 CPT21                    134- 138 (A)
 CPT22                    139- 143 (A)
 CPT23                    144- 148 (A)
 CPT24                    149- 153 (A)
 CPT25                    154- 158 (A)
 CPT26                    159- 163 (A)
 CPT27                    164- 168 (A)
 CPT28                    169- 173 (A)
 CPT29                    174- 178 (A)
 CPT30                    179- 183 (A)
 CPT31                    184- 188 (A)
 CPT32                    189- 193 (A)
 CPT33                    194- 198 (A)
 CPT34                    199- 203 (A)
 CPT35                    204- 208 (A)
 CPT36                    209- 213 (A)
 CPT37                    214- 218 (A)
 CPT38                    219- 223 (A)
 CPT39                    224- 228 (A)
 CPT40                    229- 233 (A)
 CPT41                    234- 238 (A)
 CPT42                    239- 243 (A)
 CPT43                    244- 248 (A)
 CPT44                    249- 253 (A)
 CPT45                    254- 258 (A)
 CPT46                    259- 263 (A)
 CPT47                    264- 268 (A)
 CPT48                    269- 273 (A)
 CPT49                    274- 278 (A)
 CPT50                    279- 283 (A)
 CPT51                    284- 288 (A)
 CPT52                    289- 293 (A)
 CPT53                    294- 298 (A)
 CPT54                    299- 303 (A)
 CPT55                    304- 308 (A)
 CPT56                    309- 313 (A)
 CPT57                    314- 318 (A)
 CPT58                    319- 323 (A)
 CPT59                    324- 328 (A)
 CPT60                    329- 333 (A)
 CPT61                    334- 338 (A)
 CPT62                    339- 343 (A)
 CPT63                    344- 348 (A)
 CPT64                    349- 353 (A)
 CPT65                    354- 358 (A)
 CPT66                    359- 363 (A)
 CPT67                    364- 368 (A)
 CPT68                    369- 373 (A)
 CPT69                    374- 378 (A)
 CPT70                    379- 383 (A)
 CPT71                    384- 388 (A)
 CPT72                    389- 393 (A)
 CPT73                    394- 398 (A)
 CPT74                    399- 403 (A)
 CPT75                    404- 408 (A)
 CPT76                    409- 413 (A)
 CPT77                    414- 418 (A)
 CPT78                    419- 423 (A)
 CPT79                    424- 428 (A)
 CPT80                    429- 433 (A)
 CPT81                    434- 438 (A)
 CPT82                    439- 443 (A)
 CPT83                    444- 448 (A)
 CPT84                    449- 453 (A)
 CPT85                    454- 458 (A)
 CPT86                    459- 463 (A)
 CPT87                    464- 468 (A)
 CPT88                    469- 473 (A)
 CPT89                    474- 478 (A)
 CPT90                    479- 483 (A)
 CPT91                    484- 488 (A)
 CPT92                    489- 493 (A)
 CPT93                    494- 498 (A)
 CPT94                    499- 503 (A)
 CPT95                    504- 508 (A)
 CPT96                    509- 513 (A)
 CPT97                    514- 518 (A)
 CPT98                    519- 523 (A)
 CPT99                    524- 528 (A)
 CPT100                   529- 533 (A)
 CPT101                   534- 538 (A)
 CPT102                   539- 543 (A)
 CPT103                   544- 548 (A)
 CPT104                   549- 553 (A)
 CPT105                   554- 558 (A)
 CPT106                   559- 563 (A)
 CPT107                   564- 568 (A)
 CPT108                   569- 573 (A)
 CPT109                   574- 578 (A)
 CPT110                   579- 583 (A)
 CPT111                   584- 588 (A)
 CPT112                   589- 593 (A)
 CPT113                   594- 598 (A)
 CPT114                   599- 603 (A)
 CPT115                   604- 608 (A)
 CPT116                   609- 613 (A)
 CPT117                   614- 618 (A)
 CPT118                   619- 623 (A)
 CPT119                   624- 628 (A)
 CPT120                   629- 633 (A)
 DaysBetw                 634- 637
 DHOUR                    638- 641
 DIED                     642- 643
 DISP_X                   644     (A)
 DISPUNIF                 645- 646
 DQTR                     647- 648
 DSHOSPID                 649- 661 (A)
 DX1                      662- 666 (A)
 DX2                      667- 671 (A)
 DX3                      672- 676 (A)
 DX4                      677- 681 (A)
 DX5                      682- 686 (A)
 DX6                      687- 691 (A)
 DXCCS1                   692- 695
 DXCCS2                   696- 699
 DXCCS3                   700- 703
 DXCCS4                   704- 707
 DXCCS5                   708- 711
 DXCCS6                   712- 715
 ECODE1                   716- 720 (A)
 ECODE2                   721- 725 (A)
 ECODE3                   726- 730 (A)
 ECODE4                   731- 735 (A)
 ECODE5                   736- 740 (A)
 E_CCS1                   741- 744
 E_CCS2                   745- 748
 E_CCS3                   749- 752
 E_CCS4                   753- 756
 E_CCS5                   757- 760
 FEMALE                   761- 762
 HCUP_AS                  763- 764
 HCUP_ED                  765- 766
 HCUP_OS                  767- 768
 Homeless                 769- 770
 HOSPST                   771- 772 (A)
 LOS                      773- 777
 LOS_X                    778- 783
 NCPT                     784- 786
 NDX                      787- 788
 NECODE                   789- 790
 NEOMAT                   791- 792
 NPR                      793- 794
 PAY1                     795- 796
 PAY2                     797- 798
 PAY1_X                   799- 803 (A)
 PAY2_X                   804- 808 (A)
 PL_CBSA                  809- 811
 PL_MSA19                 812- 814
 PL_RUCA4                 815- 816
 PL_UR_CA                 817- 818
 PL_UR_CA                 819- 820
 PR1                      821- 824 (A)
 PR2                      825- 828 (A)
 PR3                      829- 832 (A)
 PR4                      833- 836 (A)
 PRCCS1                   837- 839
 PRCCS2                   840- 842
 PRCCS3                   843- 845
 PRCCS4                   846- 848
 PSTATE                   849- 850 (A)
 PSTCO2                   851- 855
 RACE                     856- 857
 RACE_X                   858     (A)
 STATE_AS                 859- 860
 STATE_ED                 861- 862
 STATE_OS                 863- 864
 TOTCHG                   865- 874
 TOTCHG_X                 875- 889
 Transpor                 890- 891
 YEAR                     892- 895
 ZIP3                     896- 898 (A)
 AYEAR                    899- 902
 DMONTH                   903- 904.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DaysBetw                (F3.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 Homeless                (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 Transpor                (F3.0) /
 YEAR                    (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEMONTH  "Age in months (when age < 11 years)"
 AHOUR     "Admission Hour"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPT31     "CPT/HCPCS procedure code 31"
 CPT32     "CPT/HCPCS procedure code 32"
 CPT33     "CPT/HCPCS procedure code 33"
 CPT34     "CPT/HCPCS procedure code 34"
 CPT35     "CPT/HCPCS procedure code 35"
 CPT36     "CPT/HCPCS procedure code 36"
 CPT37     "CPT/HCPCS procedure code 37"
 CPT38     "CPT/HCPCS procedure code 38"
 CPT39     "CPT/HCPCS procedure code 39"
 CPT40     "CPT/HCPCS procedure code 40"
 CPT41     "CPT/HCPCS procedure code 41"
 CPT42     "CPT/HCPCS procedure code 42"
 CPT43     "CPT/HCPCS procedure code 43"
 CPT44     "CPT/HCPCS procedure code 44"
 CPT45     "CPT/HCPCS procedure code 45"
 CPT46     "CPT/HCPCS procedure code 46"
 CPT47     "CPT/HCPCS procedure code 47"
 CPT48     "CPT/HCPCS procedure code 48"
 CPT49     "CPT/HCPCS procedure code 49"
 CPT50     "CPT/HCPCS procedure code 50"
 CPT51     "CPT/HCPCS procedure code 51"
 CPT52     "CPT/HCPCS procedure code 52"
 CPT53     "CPT/HCPCS procedure code 53"
 CPT54     "CPT/HCPCS procedure code 54"
 CPT55     "CPT/HCPCS procedure code 55"
 CPT56     "CPT/HCPCS procedure code 56"
 CPT57     "CPT/HCPCS procedure code 57"
 CPT58     "CPT/HCPCS procedure code 58"
 CPT59     "CPT/HCPCS procedure code 59"
 CPT60     "CPT/HCPCS procedure code 60"
 CPT61     "CPT/HCPCS procedure code 61"
 CPT62     "CPT/HCPCS procedure code 62"
 CPT63     "CPT/HCPCS procedure code 63"
 CPT64     "CPT/HCPCS procedure code 64"
 CPT65     "CPT/HCPCS procedure code 65"
 CPT66     "CPT/HCPCS procedure code 66"
 CPT67     "CPT/HCPCS procedure code 67"
 CPT68     "CPT/HCPCS procedure code 68"
 CPT69     "CPT/HCPCS procedure code 69"
 CPT70     "CPT/HCPCS procedure code 70"
 CPT71     "CPT/HCPCS procedure code 71"
 CPT72     "CPT/HCPCS procedure code 72"
 CPT73     "CPT/HCPCS procedure code 73"
 CPT74     "CPT/HCPCS procedure code 74"
 CPT75     "CPT/HCPCS procedure code 75"
 CPT76     "CPT/HCPCS procedure code 76"
 CPT77     "CPT/HCPCS procedure code 77"
 CPT78     "CPT/HCPCS procedure code 78"
 CPT79     "CPT/HCPCS procedure code 79"
 CPT80     "CPT/HCPCS procedure code 80"
 CPT81     "CPT/HCPCS procedure code 81"
 CPT82     "CPT/HCPCS procedure code 82"
 CPT83     "CPT/HCPCS procedure code 83"
 CPT84     "CPT/HCPCS procedure code 84"
 CPT85     "CPT/HCPCS procedure code 85"
 CPT86     "CPT/HCPCS procedure code 86"
 CPT87     "CPT/HCPCS procedure code 87"
 CPT88     "CPT/HCPCS procedure code 88"
 CPT89     "CPT/HCPCS procedure code 89"
 CPT90     "CPT/HCPCS procedure code 90"
 CPT91     "CPT/HCPCS procedure code 91"
 CPT92     "CPT/HCPCS procedure code 92"
 CPT93     "CPT/HCPCS procedure code 93"
 CPT94     "CPT/HCPCS procedure code 94"
 CPT95     "CPT/HCPCS procedure code 95"
 CPT96     "CPT/HCPCS procedure code 96"
 CPT97     "CPT/HCPCS procedure code 97"
 CPT98     "CPT/HCPCS procedure code 98"
 CPT99     "CPT/HCPCS procedure code 99"
 CPT100    "CPT/HCPCS procedure code 100"
 CPT101    "CPT/HCPCS procedure code 101"
 CPT102    "CPT/HCPCS procedure code 102"
 CPT103    "CPT/HCPCS procedure code 103"
 CPT104    "CPT/HCPCS procedure code 104"
 CPT105    "CPT/HCPCS procedure code 105"
 CPT106    "CPT/HCPCS procedure code 106"
 CPT107    "CPT/HCPCS procedure code 107"
 CPT108    "CPT/HCPCS procedure code 108"
 CPT109    "CPT/HCPCS procedure code 109"
 CPT110    "CPT/HCPCS procedure code 110"
 CPT111    "CPT/HCPCS procedure code 111"
 CPT112    "CPT/HCPCS procedure code 112"
 CPT113    "CPT/HCPCS procedure code 113"
 CPT114    "CPT/HCPCS procedure code 114"
 CPT115    "CPT/HCPCS procedure code 115"
 CPT116    "CPT/HCPCS procedure code 116"
 CPT117    "CPT/HCPCS procedure code 117"
 CPT118    "CPT/HCPCS procedure code 118"
 CPT119    "CPT/HCPCS procedure code 119"
 CPT120    "CPT/HCPCS procedure code 120"
 DaysBetw  "Number of days between visits"
 DHOUR     "Discharge Hour"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 Homeless  "Indicator that patient is homeless"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 Transpor  "Method of transportation to hospital"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 AYEAR     "Admission year"
 DMONTH    "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DaysBetw
 (-999,-888,-666,-555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE Transpor
 (-9,-8,-6,-5=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MA_SEDD_2004_CORE.SAV' /COMPRESSED.
