/*******************************************************************
*   MA_SEDD_2003_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MA_SEDD_2003_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEMONTH                  18-  20
 AHOUR                     21-  24
 AMONTH                    25-  26
 ASOURCE                   27-  28
 ASOURCE_                  29     (A)
 ATYPE                     30-  31
 AWEEKEND                  32-  33
 CPT1                      34-  38 (A)
 CPT2                      39-  43 (A)
 CPT3                      44-  48 (A)
 CPT4                      49-  53 (A)
 CPT5                      54-  58 (A)
 CPT6                      59-  63 (A)
 CPT7                      64-  68 (A)
 CPT8                      69-  73 (A)
 CPT9                      74-  78 (A)
 CPT10                     79-  83 (A)
 CPT11                     84-  88 (A)
 CPT12                     89-  93 (A)
 CPT13                     94-  98 (A)
 CPT14                     99- 103 (A)
 CPT15                    104- 108 (A)
 CPT16                    109- 113 (A)
 CPT17                    114- 118 (A)
 CPT18                    119- 123 (A)
 CPT19                    124- 128 (A)
 CPT20                    129- 133 (A)
 CPT21                    134- 138 (A)
 CPT22                    139- 143 (A)
 CPT23                    144- 148 (A)
 CPT24                    149- 153 (A)
 CPT25                    154- 158 (A)
 CPT26                    159- 163 (A)
 CPT27                    164- 168 (A)
 CPT28                    169- 173 (A)
 CPT29                    174- 178 (A)
 CPT30                    179- 183 (A)
 CPT31                    184- 188 (A)
 CPT32                    189- 193 (A)
 CPT33                    194- 198 (A)
 CPT34                    199- 203 (A)
 CPT35                    204- 208 (A)
 CPT36                    209- 213 (A)
 CPT37                    214- 218 (A)
 CPT38                    219- 223 (A)
 CPT39                    224- 228 (A)
 CPT40                    229- 233 (A)
 CPT41                    234- 238 (A)
 CPT42                    239- 243 (A)
 CPT43                    244- 248 (A)
 CPT44                    249- 253 (A)
 CPT45                    254- 258 (A)
 CPT46                    259- 263 (A)
 CPT47                    264- 268 (A)
 CPT48                    269- 273 (A)
 CPT49                    274- 278 (A)
 CPT50                    279- 283 (A)
 CPT51                    284- 288 (A)
 CPT52                    289- 293 (A)
 CPT53                    294- 298 (A)
 CPT54                    299- 303 (A)
 CPT55                    304- 308 (A)
 CPT56                    309- 313 (A)
 CPT57                    314- 318 (A)
 CPT58                    319- 323 (A)
 CPT59                    324- 328 (A)
 CPT60                    329- 333 (A)
 CPT61                    334- 338 (A)
 CPT62                    339- 343 (A)
 CPT63                    344- 348 (A)
 CPT64                    349- 353 (A)
 CPT65                    354- 358 (A)
 CPT66                    359- 363 (A)
 CPT67                    364- 368 (A)
 CPT68                    369- 373 (A)
 CPT69                    374- 378 (A)
 CPT70                    379- 383 (A)
 CPT71                    384- 388 (A)
 CPT72                    389- 393 (A)
 CPT73                    394- 398 (A)
 CPT74                    399- 403 (A)
 CPT75                    404- 408 (A)
 CPT76                    409- 413 (A)
 CPT77                    414- 418 (A)
 CPT78                    419- 423 (A)
 CPT79                    424- 428 (A)
 DaysBetw                 429- 432
 DHOUR                    433- 436
 DIED                     437- 438
 DISP_X                   439     (A)
 DISPUNIF                 440- 441
 DQTR                     442- 443
 DSHOSPID                 444- 456 (A)
 DX1                      457- 461 (A)
 DX2                      462- 466 (A)
 DX3                      467- 471 (A)
 DX4                      472- 476 (A)
 DX5                      477- 481 (A)
 DX6                      482- 486 (A)
 DXCCS1                   487- 490
 DXCCS2                   491- 494
 DXCCS3                   495- 498
 DXCCS4                   499- 502
 DXCCS5                   503- 506
 DXCCS6                   507- 510
 ECODE1                   511- 515 (A)
 ECODE2                   516- 520 (A)
 ECODE3                   521- 525 (A)
 ECODE4                   526- 530 (A)
 ECODE5                   531- 535 (A)
 E_CCS1                   536- 539
 E_CCS2                   540- 543
 E_CCS3                   544- 547
 E_CCS4                   548- 551
 E_CCS5                   552- 555
 FEMALE                   556- 557
 HCUP_AS                  558- 559
 HCUP_ED                  560- 561
 HCUP_OS                  562- 563
 Homeless                 564- 565
 HOSPST                   566- 567 (A)
 LOS                      568- 572
 LOS_X                    573- 578
 NCPT                     579- 581
 NDX                      582- 583
 NECODE                   584- 585
 NEOMAT                   586- 587
 NPR                      588- 589
 PAY1                     590- 591
 PAY2                     592- 593
 PAY1_X                   594- 598 (A)
 PAY2_X                   599- 603 (A)
 PL_CBSA                  604- 606
 PL_MSA19                 607- 609
 PL_RUCA4                 610- 611
 PL_UR_CA                 612- 613
 PL_UR_CA                 614- 615
 PR1                      616- 619 (A)
 PR2                      620- 623 (A)
 PR3                      624- 627 (A)
 PR4                      628- 631 (A)
 PRCCS1                   632- 634
 PRCCS2                   635- 637
 PRCCS3                   638- 640
 PRCCS4                   641- 643
 PSTATE                   644- 645 (A)
 PSTCO2                   646- 650
 RACE                     651- 652
 RACE_X                   653     (A)
 STATE_AS                 654- 655
 STATE_ED                 656- 657
 STATE_OS                 658- 659
 TOTCHG                   660- 669
 TOTCHG_X                 670- 684
 Transpor                 685- 686
 YEAR                     687- 690
 ZIP3                     691- 693 (A)
 AYEAR                    694- 697
 DMONTH                   698- 699.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DaysBetw                (F3.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 Homeless                (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 Transpor                (F3.0) /
 YEAR                    (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEMONTH  "Age in months (when age < 11 years)"
 AHOUR     "Admission Hour"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPT31     "CPT/HCPCS procedure code 31"
 CPT32     "CPT/HCPCS procedure code 32"
 CPT33     "CPT/HCPCS procedure code 33"
 CPT34     "CPT/HCPCS procedure code 34"
 CPT35     "CPT/HCPCS procedure code 35"
 CPT36     "CPT/HCPCS procedure code 36"
 CPT37     "CPT/HCPCS procedure code 37"
 CPT38     "CPT/HCPCS procedure code 38"
 CPT39     "CPT/HCPCS procedure code 39"
 CPT40     "CPT/HCPCS procedure code 40"
 CPT41     "CPT/HCPCS procedure code 41"
 CPT42     "CPT/HCPCS procedure code 42"
 CPT43     "CPT/HCPCS procedure code 43"
 CPT44     "CPT/HCPCS procedure code 44"
 CPT45     "CPT/HCPCS procedure code 45"
 CPT46     "CPT/HCPCS procedure code 46"
 CPT47     "CPT/HCPCS procedure code 47"
 CPT48     "CPT/HCPCS procedure code 48"
 CPT49     "CPT/HCPCS procedure code 49"
 CPT50     "CPT/HCPCS procedure code 50"
 CPT51     "CPT/HCPCS procedure code 51"
 CPT52     "CPT/HCPCS procedure code 52"
 CPT53     "CPT/HCPCS procedure code 53"
 CPT54     "CPT/HCPCS procedure code 54"
 CPT55     "CPT/HCPCS procedure code 55"
 CPT56     "CPT/HCPCS procedure code 56"
 CPT57     "CPT/HCPCS procedure code 57"
 CPT58     "CPT/HCPCS procedure code 58"
 CPT59     "CPT/HCPCS procedure code 59"
 CPT60     "CPT/HCPCS procedure code 60"
 CPT61     "CPT/HCPCS procedure code 61"
 CPT62     "CPT/HCPCS procedure code 62"
 CPT63     "CPT/HCPCS procedure code 63"
 CPT64     "CPT/HCPCS procedure code 64"
 CPT65     "CPT/HCPCS procedure code 65"
 CPT66     "CPT/HCPCS procedure code 66"
 CPT67     "CPT/HCPCS procedure code 67"
 CPT68     "CPT/HCPCS procedure code 68"
 CPT69     "CPT/HCPCS procedure code 69"
 CPT70     "CPT/HCPCS procedure code 70"
 CPT71     "CPT/HCPCS procedure code 71"
 CPT72     "CPT/HCPCS procedure code 72"
 CPT73     "CPT/HCPCS procedure code 73"
 CPT74     "CPT/HCPCS procedure code 74"
 CPT75     "CPT/HCPCS procedure code 75"
 CPT76     "CPT/HCPCS procedure code 76"
 CPT77     "CPT/HCPCS procedure code 77"
 CPT78     "CPT/HCPCS procedure code 78"
 CPT79     "CPT/HCPCS procedure code 79"
 DaysBetw  "Number of days between visits"
 DHOUR     "Discharge Hour"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 Homeless  "Indicator that patient is homeless"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 Transpor  "Method of transportation to hospital"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 AYEAR     "Admission year"
 DMONTH    "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DaysBetw
 (-999,-888,-666,-555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE Transpor
 (-9,-8,-6,-5=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MA_SEDD_2003_CORE.SAV' /COMPRESSED.
