/*******************************************************************
* Creation Date: 03/19/2019   
*   KS_SEDD_2017_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'KS_SEDD_2017_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BILLTYPE                       20-  23 (A)
 CPT1                           24-  28 (A)
 CPT2                           29-  33 (A)
 CPT3                           34-  38 (A)
 CPT4                           39-  43 (A)
 CPT5                           44-  48 (A)
 CPT6                           49-  53 (A)
 CPT7                           54-  58 (A)
 CPT8                           59-  63 (A)
 CPT9                           64-  68 (A)
 CPT10                          69-  73 (A)
 CPT11                          74-  78 (A)
 CPT12                          79-  83 (A)
 CPT13                          84-  88 (A)
 CPT14                          89-  93 (A)
 CPT15                          94-  98 (A)
 CPT16                          99- 103 (A)
 CPT17                         104- 108 (A)
 CPT18                         109- 113 (A)
 CPT19                         114- 118 (A)
 CPT20                         119- 123 (A)
 CPT21                         124- 128 (A)
 CPT22                         129- 133 (A)
 CPT23                         134- 138 (A)
 CPT24                         139- 143 (A)
 CPT25                         144- 148 (A)
 CPT26                         149- 153 (A)
 CPT27                         154- 158 (A)
 CPT28                         159- 163 (A)
 CPT29                         164- 168 (A)
 CPT30                         169- 173 (A)
 CPT31                         174- 178 (A)
 CPT32                         179- 183 (A)
 CPT33                         184- 188 (A)
 CPT34                         189- 193 (A)
 CPT35                         194- 198 (A)
 CPT36                         199- 203 (A)
 CPT37                         204- 208 (A)
 CPT38                         209- 213 (A)
 CPT39                         214- 218 (A)
 CPT40                         219- 223 (A)
 CPT41                         224- 228 (A)
 CPT42                         229- 233 (A)
 CPT43                         234- 238 (A)
 CPT44                         239- 243 (A)
 CPT45                         244- 248 (A)
 CPT46                         249- 253 (A)
 CPT47                         254- 258 (A)
 CPT48                         259- 263 (A)
 CPT49                         264- 268 (A)
 CPT50                         269- 273 (A)
 CPT51                         274- 278 (A)
 CPT52                         279- 283 (A)
 CPT53                         284- 288 (A)
 CPT54                         289- 293 (A)
 CPT55                         294- 298 (A)
 CPT56                         299- 303 (A)
 CPT57                         304- 308 (A)
 CPT58                         309- 313 (A)
 CPT59                         314- 318 (A)
 CPT60                         319- 323 (A)
 CPT61                         324- 328 (A)
 CPT62                         329- 333 (A)
 CPT63                         334- 338 (A)
 CPT64                         339- 343 (A)
 CPT65                         344- 348 (A)
 CPT66                         349- 353 (A)
 CPT67                         354- 358 (A)
 CPT68                         359- 363 (A)
 CPT69                         364- 368 (A)
 CPT70                         369- 373 (A)
 CPT71                         374- 378 (A)
 CPT72                         379- 383 (A)
 CPT73                         384- 388 (A)
 CPT74                         389- 393 (A)
 CPT75                         394- 398 (A)
 CPTCCS1                       399- 401
 CPTCCS2                       402- 404
 CPTCCS3                       405- 407
 CPTCCS4                       408- 410
 CPTCCS5                       411- 413
 CPTCCS6                       414- 416
 CPTCCS7                       417- 419
 CPTCCS8                       420- 422
 CPTCCS9                       423- 425
 CPTCCS10                      426- 428
 CPTCCS11                      429- 431
 CPTCCS12                      432- 434
 CPTCCS13                      435- 437
 CPTCCS14                      438- 440
 CPTCCS15                      441- 443
 CPTCCS16                      444- 446
 CPTCCS17                      447- 449
 CPTCCS18                      450- 452
 CPTCCS19                      453- 455
 CPTCCS20                      456- 458
 CPTCCS21                      459- 461
 CPTCCS22                      462- 464
 CPTCCS23                      465- 467
 CPTCCS24                      468- 470
 CPTCCS25                      471- 473
 CPTCCS26                      474- 476
 CPTCCS27                      477- 479
 CPTCCS28                      480- 482
 CPTCCS29                      483- 485
 CPTCCS30                      486- 488
 CPTCCS31                      489- 491
 CPTCCS32                      492- 494
 CPTCCS33                      495- 497
 CPTCCS34                      498- 500
 CPTCCS35                      501- 503
 CPTCCS36                      504- 506
 CPTCCS37                      507- 509
 CPTCCS38                      510- 512
 CPTCCS39                      513- 515
 CPTCCS40                      516- 518
 CPTCCS41                      519- 521
 CPTCCS42                      522- 524
 CPTCCS43                      525- 527
 CPTCCS44                      528- 530
 CPTCCS45                      531- 533
 CPTCCS46                      534- 536
 CPTCCS47                      537- 539
 CPTCCS48                      540- 542
 CPTCCS49                      543- 545
 CPTCCS50                      546- 548
 CPTCCS51                      549- 551
 CPTCCS52                      552- 554
 CPTCCS53                      555- 557
 CPTCCS54                      558- 560
 CPTCCS55                      561- 563
 CPTCCS56                      564- 566
 CPTCCS57                      567- 569
 CPTCCS58                      570- 572
 CPTCCS59                      573- 575
 CPTCCS60                      576- 578
 CPTCCS61                      579- 581
 CPTCCS62                      582- 584
 CPTCCS63                      585- 587
 CPTCCS64                      588- 590
 CPTCCS65                      591- 593
 CPTCCS66                      594- 596
 CPTCCS67                      597- 599
 CPTCCS68                      600- 602
 CPTCCS69                      603- 605
 CPTCCS70                      606- 608
 CPTCCS71                      609- 611
 CPTCCS72                      612- 614
 CPTCCS73                      615- 617
 CPTCCS74                      618- 620
 CPTCCS75                      621- 623
 CPTM1_1                       624- 625 (A)
 CPTM1_2                       626- 627 (A)
 CPTM1_3                       628- 629 (A)
 CPTM1_4                       630- 631 (A)
 CPTM1_5                       632- 633 (A)
 CPTM1_6                       634- 635 (A)
 CPTM1_7                       636- 637 (A)
 CPTM1_8                       638- 639 (A)
 CPTM1_9                       640- 641 (A)
 CPTM1_10                      642- 643 (A)
 CPTM1_11                      644- 645 (A)
 CPTM1_12                      646- 647 (A)
 CPTM1_13                      648- 649 (A)
 CPTM1_14                      650- 651 (A)
 CPTM1_15                      652- 653 (A)
 CPTM1_16                      654- 655 (A)
 CPTM1_17                      656- 657 (A)
 CPTM1_18                      658- 659 (A)
 CPTM1_19                      660- 661 (A)
 CPTM1_20                      662- 663 (A)
 CPTM1_21                      664- 665 (A)
 CPTM1_22                      666- 667 (A)
 CPTM1_23                      668- 669 (A)
 CPTM1_24                      670- 671 (A)
 CPTM1_25                      672- 673 (A)
 CPTM1_26                      674- 675 (A)
 CPTM1_27                      676- 677 (A)
 CPTM1_28                      678- 679 (A)
 CPTM1_29                      680- 681 (A)
 CPTM1_30                      682- 683 (A)
 CPTM1_31                      684- 685 (A)
 CPTM1_32                      686- 687 (A)
 CPTM1_33                      688- 689 (A)
 CPTM1_34                      690- 691 (A)
 CPTM1_35                      692- 693 (A)
 CPTM1_36                      694- 695 (A)
 CPTM1_37                      696- 697 (A)
 CPTM1_38                      698- 699 (A)
 CPTM1_39                      700- 701 (A)
 CPTM1_40                      702- 703 (A)
 CPTM1_41                      704- 705 (A)
 CPTM1_42                      706- 707 (A)
 CPTM1_43                      708- 709 (A)
 CPTM1_44                      710- 711 (A)
 CPTM1_45                      712- 713 (A)
 CPTM1_46                      714- 715 (A)
 CPTM1_47                      716- 717 (A)
 CPTM1_48                      718- 719 (A)
 CPTM1_49                      720- 721 (A)
 CPTM1_50                      722- 723 (A)
 CPTM2_1                       724- 725 (A)
 CPTM2_2                       726- 727 (A)
 CPTM2_3                       728- 729 (A)
 CPTM2_4                       730- 731 (A)
 CPTM2_5                       732- 733 (A)
 CPTM2_6                       734- 735 (A)
 CPTM2_7                       736- 737 (A)
 CPTM2_8                       738- 739 (A)
 CPTM2_9                       740- 741 (A)
 CPTM2_10                      742- 743 (A)
 CPTM2_11                      744- 745 (A)
 CPTM2_12                      746- 747 (A)
 CPTM2_13                      748- 749 (A)
 CPTM2_14                      750- 751 (A)
 CPTM2_15                      752- 753 (A)
 CPTM2_16                      754- 755 (A)
 CPTM2_17                      756- 757 (A)
 CPTM2_18                      758- 759 (A)
 CPTM2_19                      760- 761 (A)
 CPTM2_20                      762- 763 (A)
 CPTM2_21                      764- 765 (A)
 CPTM2_22                      766- 767 (A)
 CPTM2_23                      768- 769 (A)
 CPTM2_24                      770- 771 (A)
 CPTM2_25                      772- 773 (A)
 CPTM2_26                      774- 775 (A)
 CPTM2_27                      776- 777 (A)
 CPTM2_28                      778- 779 (A)
 CPTM2_29                      780- 781 (A)
 CPTM2_30                      782- 783 (A)
 CPTM2_31                      784- 785 (A)
 CPTM2_32                      786- 787 (A)
 CPTM2_33                      788- 789 (A)
 CPTM2_34                      790- 791 (A)
 CPTM2_35                      792- 793 (A)
 CPTM2_36                      794- 795 (A)
 CPTM2_37                      796- 797 (A)
 CPTM2_38                      798- 799 (A)
 CPTM2_39                      800- 801 (A)
 CPTM2_40                      802- 803 (A)
 CPTM2_41                      804- 805 (A)
 CPTM2_42                      806- 807 (A)
 CPTM2_43                      808- 809 (A)
 CPTM2_44                      810- 811 (A)
 CPTM2_45                      812- 813 (A)
 CPTM2_46                      814- 815 (A)
 CPTM2_47                      816- 817 (A)
 CPTM2_48                      818- 819 (A)
 CPTM2_49                      820- 821 (A)
 CPTM2_50                      822- 823 (A)
 DHOUR                         824- 827
 DIED                          828- 829
 DISP_X                        830- 831 (A)
 DISPUB04                      832- 833
 DISPUNIFORM                   834- 835
 DMONTH                        836- 837
 DQTR                          838- 839
 DURATION                      840- 845
 DXVER                         846- 848
 FEMALE                        849- 850
 HCUP_ED                       851- 852
 HCUP_OS                       853- 854
 HISPANIC                      855- 856
 HISPANIC_X                    857     (A)
 HOSPST                        858- 859 (A)
 I10_DX1                       860- 866 (A)
 I10_DX2                       867- 873 (A)
 I10_DX3                       874- 880 (A)
 I10_DX4                       881- 887 (A)
 I10_DX5                       888- 894 (A)
 I10_DX6                       895- 901 (A)
 I10_DX7                       902- 908 (A)
 I10_DX8                       909- 915 (A)
 I10_DX9                       916- 922 (A)
 I10_DX10                      923- 929 (A)
 I10_DX11                      930- 936 (A)
 I10_DX12                      937- 943 (A)
 I10_DX13                      944- 950 (A)
 I10_DX14                      951- 957 (A)
 I10_DX15                      958- 964 (A)
 I10_DX16                      965- 971 (A)
 I10_DX17                      972- 978 (A)
 I10_DX18                      979- 985 (A)
 I10_DX19                      986- 992 (A)
 I10_DX20                      993- 999 (A)
 I10_DX21                     1000-1006 (A)
 I10_DX22                     1007-1013 (A)
 I10_DX23                     1014-1020 (A)
 I10_DX24                     1021-1027 (A)
 I10_DX25                     1028-1034 (A)
 I10_DX26                     1035-1041 (A)
 I10_DX27                     1042-1048 (A)
 I10_DX28                     1049-1055 (A)
 I10_DX29                     1056-1062 (A)
 I10_DX30                     1063-1069 (A)
 I10_NDX                      1070-1072
 I10_NPR                      1073-1075
 I10_PR1                      1076-1082 (A)
 I10_PR2                      1083-1089 (A)
 I10_PR3                      1090-1096 (A)
 I10_PR4                      1097-1103 (A)
 I10_PR5                      1104-1110 (A)
 I10_PR6                      1111-1117 (A)
 I10_PR7                      1118-1124 (A)
 I10_PR8                      1125-1131 (A)
 I10_PR9                      1132-1138 (A)
 I10_PR10                     1139-1145 (A)
 I10_PR11                     1146-1152 (A)
 I10_PR12                     1153-1159 (A)
 I10_PR13                     1160-1166 (A)
 I10_PR14                     1167-1173 (A)
 I10_PR15                     1174-1180 (A)
 I10_PR16                     1181-1187 (A)
 I10_PR17                     1188-1194 (A)
 I10_PR18                     1195-1201 (A)
 I10_PR19                     1202-1208 (A)
 I10_PR20                     1209-1215 (A)
 I10_PR21                     1216-1222 (A)
 I10_PR22                     1223-1229 (A)
 I10_PR23                     1230-1236 (A)
 I10_PR24                     1237-1243 (A)
 I10_PR25                     1244-1250 (A)
 I10_PROCTYPE                 1251-1253
 KEY                          1254-1268
 LOS                          1269-1273
 LOS_X                        1274-1279
 MEDINCSTQ                    1280-1281
 NCPT                         1282-1285
 OPservice                    1286     (A)
 OS_TIME                      1287-1297
 PAY1                         1298-1299
 PAY1_X                       1300-1302 (A)
 PAY2                         1303-1304
 PAY2_X                       1305-1307 (A)
 PAY3                         1308-1309
 PAY3_X                       1310-1312 (A)
 PL_CBSA                      1313-1315
 PL_NCHS                      1316-1317
 PL_RUCC                      1318-1319
 PL_UIC                       1320-1321
 PL_UR_CAT4                   1322-1323
 PointOfOrigin_X              1324     (A)
 PointOfOriginUB04            1325     (A)
 PRVER                        1326-1328
 PSTATE                       1329-1330 (A)
 PSTCO                        1331-1335
 PSTCO2                       1336-1340
 RACE                         1341-1342
 RACE_X                       1343     (A)
 STATE_AS                     1344-1345
 STATE_ED                     1346-1347
 STATE_OS                     1348-1349
 TOTCHG                       1350-1359
 TOTCHG_X                     1360-1374
 YEAR                         1375-1378
 ZIP3                         1379-1381 (A)
 ZIPINC_QRTL                  1382-1384
 HOSPID                       1385-1389
 AYEAR                        1390-1393
 BMONTH                       1394-1395
 BYEAR                        1396-1399.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DURATION                     (F4.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM1_7                      "First CPT-4/HCPCS modifier 7"
 CPTM1_8                      "First CPT-4/HCPCS modifier 8"
 CPTM1_9                      "First CPT-4/HCPCS modifier 9"
 CPTM1_10                     "First CPT-4/HCPCS modifier 10"
 CPTM1_11                     "First CPT-4/HCPCS modifier 11"
 CPTM1_12                     "First CPT-4/HCPCS modifier 12"
 CPTM1_13                     "First CPT-4/HCPCS modifier 13"
 CPTM1_14                     "First CPT-4/HCPCS modifier 14"
 CPTM1_15                     "First CPT-4/HCPCS modifier 15"
 CPTM1_16                     "First CPT-4/HCPCS modifier 16"
 CPTM1_17                     "First CPT-4/HCPCS modifier 17"
 CPTM1_18                     "First CPT-4/HCPCS modifier 18"
 CPTM1_19                     "First CPT-4/HCPCS modifier 19"
 CPTM1_20                     "First CPT-4/HCPCS modifier 20"
 CPTM1_21                     "First CPT-4/HCPCS modifier 21"
 CPTM1_22                     "First CPT-4/HCPCS modifier 22"
 CPTM1_23                     "First CPT-4/HCPCS modifier 23"
 CPTM1_24                     "First CPT-4/HCPCS modifier 24"
 CPTM1_25                     "First CPT-4/HCPCS modifier 25"
 CPTM1_26                     "First CPT-4/HCPCS modifier 26"
 CPTM1_27                     "First CPT-4/HCPCS modifier 27"
 CPTM1_28                     "First CPT-4/HCPCS modifier 28"
 CPTM1_29                     "First CPT-4/HCPCS modifier 29"
 CPTM1_30                     "First CPT-4/HCPCS modifier 30"
 CPTM1_31                     "First CPT-4/HCPCS modifier 31"
 CPTM1_32                     "First CPT-4/HCPCS modifier 32"
 CPTM1_33                     "First CPT-4/HCPCS modifier 33"
 CPTM1_34                     "First CPT-4/HCPCS modifier 34"
 CPTM1_35                     "First CPT-4/HCPCS modifier 35"
 CPTM1_36                     "First CPT-4/HCPCS modifier 36"
 CPTM1_37                     "First CPT-4/HCPCS modifier 37"
 CPTM1_38                     "First CPT-4/HCPCS modifier 38"
 CPTM1_39                     "First CPT-4/HCPCS modifier 39"
 CPTM1_40                     "First CPT-4/HCPCS modifier 40"
 CPTM1_41                     "First CPT-4/HCPCS modifier 41"
 CPTM1_42                     "First CPT-4/HCPCS modifier 42"
 CPTM1_43                     "First CPT-4/HCPCS modifier 43"
 CPTM1_44                     "First CPT-4/HCPCS modifier 44"
 CPTM1_45                     "First CPT-4/HCPCS modifier 45"
 CPTM1_46                     "First CPT-4/HCPCS modifier 46"
 CPTM1_47                     "First CPT-4/HCPCS modifier 47"
 CPTM1_48                     "First CPT-4/HCPCS modifier 48"
 CPTM1_49                     "First CPT-4/HCPCS modifier 49"
 CPTM1_50                     "First CPT-4/HCPCS modifier 50"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                      "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                      "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                      "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                     "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                     "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                     "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                     "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                     "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                     "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                     "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                     "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                     "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                     "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                     "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                     "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                     "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                     "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                     "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                     "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                     "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                     "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                     "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                     "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                     "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                     "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                     "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                     "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                     "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                     "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                     "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                     "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                     "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                     "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                     "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                     "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                     "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                     "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                     "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                     "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                     "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                     "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                     "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                     "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                     "Second CPT-4/HCPCS modifier 50"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DURATION                     "Elapsed time for hospital care in hours and minutes"
 DXVER                        "Diagnosis Version"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OPservice                    "Indicator of outpatient service (as received from source)"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'KS_SEDD_2017_CORE.SAV' /COMPRESSED.
