/*******************************************************************
*   IA_SEDD_2008_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'IA_SEDD_2008_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 AWEEKEND                  12-  13
 CPT1                      14-  18 (A)
 CPT2                      19-  23 (A)
 CPT3                      24-  28 (A)
 CPT4                      29-  33 (A)
 CPT5                      34-  38 (A)
 CPT6                      39-  43 (A)
 CPT7                      44-  48 (A)
 CPT8                      49-  53 (A)
 CPT9                      54-  58 (A)
 CPT10                     59-  63 (A)
 CPT11                     64-  68 (A)
 CPT12                     69-  73 (A)
 CPT13                     74-  78 (A)
 CPT14                     79-  83 (A)
 CPT15                     84-  88 (A)
 CPT16                     89-  93 (A)
 CPT17                     94-  98 (A)
 CPT18                     99- 103 (A)
 CPT19                    104- 108 (A)
 CPT20                    109- 113 (A)
 CPT21                    114- 118 (A)
 CPT22                    119- 123 (A)
 CPT23                    124- 128 (A)
 CPT24                    129- 133 (A)
 CPT25                    134- 138 (A)
 CPT26                    139- 143 (A)
 CPT27                    144- 148 (A)
 CPT28                    149- 153 (A)
 CPT29                    154- 158 (A)
 CPT30                    159- 163 (A)
 CPTCCS1                  164- 166
 CPTCCS2                  167- 169
 CPTCCS3                  170- 172
 CPTCCS4                  173- 175
 CPTCCS5                  176- 178
 CPTCCS6                  179- 181
 CPTCCS7                  182- 184
 CPTCCS8                  185- 187
 CPTCCS9                  188- 190
 CPTCCS10                 191- 193
 CPTCCS11                 194- 196
 CPTCCS12                 197- 199
 CPTCCS13                 200- 202
 CPTCCS14                 203- 205
 CPTCCS15                 206- 208
 CPTCCS16                 209- 211
 CPTCCS17                 212- 214
 CPTCCS18                 215- 217
 CPTCCS19                 218- 220
 CPTCCS20                 221- 223
 CPTCCS21                 224- 226
 CPTCCS22                 227- 229
 CPTCCS23                 230- 232
 CPTCCS24                 233- 235
 CPTCCS25                 236- 238
 CPTCCS26                 239- 241
 CPTCCS27                 242- 244
 CPTCCS28                 245- 247
 CPTCCS29                 248- 250
 CPTCCS30                 251- 253
 CPTDAY1                  254- 256
 CPTDAY2                  257- 259
 CPTDAY3                  260- 262
 CPTDAY4                  263- 265
 CPTDAY5                  266- 268
 CPTDAY6                  269- 271
 CPTDAY7                  272- 274
 CPTDAY8                  275- 277
 CPTDAY9                  278- 280
 CPTDAY10                 281- 283
 CPTDAY11                 284- 286
 CPTDAY12                 287- 289
 CPTDAY13                 290- 292
 CPTDAY14                 293- 295
 CPTDAY15                 296- 298
 CPTDAY16                 299- 301
 CPTDAY17                 302- 304
 CPTDAY18                 305- 307
 CPTDAY19                 308- 310
 CPTDAY20                 311- 313
 CPTDAY21                 314- 316
 CPTDAY22                 317- 319
 CPTDAY23                 320- 322
 CPTDAY24                 323- 325
 CPTDAY25                 326- 328
 CPTDAY26                 329- 331
 CPTDAY27                 332- 334
 CPTDAY28                 335- 337
 CPTDAY29                 338- 340
 CPTDAY30                 341- 343
 CPTM1_1                  344- 345 (A)
 CPTM1_2                  346- 347 (A)
 CPTM1_3                  348- 349 (A)
 CPTM1_4                  350- 351 (A)
 CPTM1_5                  352- 353 (A)
 CPTM1_6                  354- 355 (A)
 CPTM1_7                  356- 357 (A)
 CPTM1_8                  358- 359 (A)
 CPTM1_9                  360- 361 (A)
 CPTM1_10                 362- 363 (A)
 CPTM1_11                 364- 365 (A)
 CPTM1_12                 366- 367 (A)
 CPTM1_13                 368- 369 (A)
 CPTM1_14                 370- 371 (A)
 CPTM1_15                 372- 373 (A)
 CPTM1_16                 374- 375 (A)
 CPTM1_17                 376- 377 (A)
 CPTM1_18                 378- 379 (A)
 CPTM1_19                 380- 381 (A)
 CPTM1_20                 382- 383 (A)
 CPTM1_21                 384- 385 (A)
 CPTM1_22                 386- 387 (A)
 CPTM1_23                 388- 389 (A)
 CPTM1_24                 390- 391 (A)
 CPTM1_25                 392- 393 (A)
 CPTM1_26                 394- 395 (A)
 CPTM1_27                 396- 397 (A)
 CPTM1_28                 398- 399 (A)
 CPTM1_29                 400- 401 (A)
 CPTM1_30                 402- 403 (A)
 CPTM2_1                  404- 405 (A)
 CPTM2_2                  406- 407 (A)
 CPTM2_3                  408- 409 (A)
 CPTM2_4                  410- 411 (A)
 CPTM2_5                  412- 413 (A)
 CPTM2_6                  414- 415 (A)
 CPTM2_7                  416- 417 (A)
 CPTM2_8                  418- 419 (A)
 CPTM2_9                  420- 421 (A)
 CPTM2_10                 422- 423 (A)
 CPTM2_11                 424- 425 (A)
 CPTM2_12                 426- 427 (A)
 CPTM2_13                 428- 429 (A)
 CPTM2_14                 430- 431 (A)
 CPTM2_15                 432- 433 (A)
 CPTM2_16                 434- 435 (A)
 CPTM2_17                 436- 437 (A)
 CPTM2_18                 438- 439 (A)
 CPTM2_19                 440- 441 (A)
 CPTM2_20                 442- 443 (A)
 CPTM2_21                 444- 445 (A)
 CPTM2_22                 446- 447 (A)
 CPTM2_23                 448- 449 (A)
 CPTM2_24                 450- 451 (A)
 CPTM2_25                 452- 453 (A)
 CPTM2_26                 454- 455 (A)
 CPTM2_27                 456- 457 (A)
 CPTM2_28                 458- 459 (A)
 CPTM2_29                 460- 461 (A)
 CPTM2_30                 462- 463 (A)
 DIED                     464- 465
 DISPUB04                 466- 467
 DISPUNIF                 468- 469
 DISP_X                   470- 471 (A)
 DQTR                     472- 473
 DSHOSPID                 474- 486 (A)
 DX1                      487- 491 (A)
 DX2                      492- 496 (A)
 DX3                      497- 501 (A)
 DX4                      502- 506 (A)
 DX5                      507- 511 (A)
 DX6                      512- 516 (A)
 DX7                      517- 521 (A)
 DX8                      522- 526 (A)
 DX9                      527- 531 (A)
 DX10                     532- 536 (A)
 DX11                     537- 541 (A)
 DX12                     542- 546 (A)
 DX13                     547- 551 (A)
 DX14                     552- 556 (A)
 DX15                     557- 561 (A)
 DX16                     562- 566 (A)
 DX17                     567- 571 (A)
 DX18                     572- 576 (A)
 DX19                     577- 581 (A)
 DX20                     582- 586 (A)
 DX21                     587- 591 (A)
 DX22                     592- 596 (A)
 DX23                     597- 601 (A)
 DX24                     602- 606 (A)
 DX25                     607- 611 (A)
 DX26                     612- 616 (A)
 DX27                     617- 621 (A)
 DX28                     622- 626 (A)
 DX29                     627- 631 (A)
 DX30                     632- 636 (A)
 DXCCS1                   637- 640
 DXCCS2                   641- 644
 DXCCS3                   645- 648
 DXCCS4                   649- 652
 DXCCS5                   653- 656
 DXCCS6                   657- 660
 DXCCS7                   661- 664
 DXCCS8                   665- 668
 DXCCS9                   669- 672
 DXCCS10                  673- 676
 DXCCS11                  677- 680
 DXCCS12                  681- 684
 DXCCS13                  685- 688
 DXCCS14                  689- 692
 DXCCS15                  693- 696
 DXCCS16                  697- 700
 DXCCS17                  701- 704
 DXCCS18                  705- 708
 DXCCS19                  709- 712
 DXCCS20                  713- 716
 DXCCS21                  717- 720
 DXCCS22                  721- 724
 DXCCS23                  725- 728
 DXCCS24                  729- 732
 DXCCS25                  733- 736
 DXCCS26                  737- 740
 DXCCS27                  741- 744
 DXCCS28                  745- 748
 DXCCS29                  749- 752
 DXCCS30                  753- 756
 DX_Visit                 757- 761 (A)
 ECODE1                   762- 766 (A)
 ECODE2                   767- 771 (A)
 ECODE3                   772- 776 (A)
 ECODE4                   777- 781 (A)
 ECODE5                   782- 786 (A)
 ECODE6                   787- 791 (A)
 ECODE7                   792- 796 (A)
 ECODE8                   797- 801 (A)
 E_CCS1                   802- 805
 E_CCS2                   806- 809
 E_CCS3                   810- 813
 E_CCS4                   814- 817
 E_CCS5                   818- 821
 E_CCS6                   822- 825
 E_CCS7                   826- 829
 E_CCS8                   830- 833
 FEMALE                   834- 835
 HCUP_AS                  836- 837
 HCUP_ED                  838- 839
 HCUP_OS                  840- 841
 HOSPBRTH                 842- 844
 HOSPST                   845- 846 (A)
 KEY                      847- 860
 LOS                      861- 865
 LOS_X                    866- 871
 MDNUM1_R                 872- 880
 MDNUM2_R                 881- 889
 MEDINCST                 890- 891
 MRN_R                    892- 900
 NCPT                     901- 903
 NDX                      904- 905
 NECODE                   906- 907
 NEOMAT                   908- 909
 PAY1                     910- 911
 PAY1_X                   912- 915 (A)
 PL_CBSA                  916- 918
 PL_MSA19                 919- 921
 PL_NCHS2                 922- 923
 PL_RUCA1                 924- 925
 PL_RUCA2                 926- 929
 PL_RUCA4                 930- 931
 PL_RUCC2                 932- 933
 PL_UIC20                 934- 935
 PL_UR_CA                 936- 937
 PROCTYPE                 938- 940
 PSTATE                   941- 942 (A)
 PSTCO                    943- 947
 PSTCO2                   948- 952
 RACE                     953- 954
 RACE_X                   955- 958 (A)
 STATE_AS                 959- 960
 STATE_ED                 961- 962
 STATE_OS                 963- 964
 TOTCHG                   965- 974
 TOTCHG_X                 975- 989
 YEAR                     990- 993
 ZIPINC_Q                 994- 996
 ZIP                      997-1001 (A)
 AYEAR                   1002-1005
 DMONTH                  1006-1007
 BMONTH                  1008-1009
 BYEAR                   1010-1013.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 CPTDAY1                 (F4.0) /
 CPTDAY2                 (F4.0) /
 CPTDAY3                 (F4.0) /
 CPTDAY4                 (F4.0) /
 CPTDAY5                 (F4.0) /
 CPTDAY6                 (F4.0) /
 CPTDAY7                 (F4.0) /
 CPTDAY8                 (F4.0) /
 CPTDAY9                 (F4.0) /
 CPTDAY10                (F4.0) /
 CPTDAY11                (F4.0) /
 CPTDAY12                (F4.0) /
 CPTDAY13                (F4.0) /
 CPTDAY14                (F4.0) /
 CPTDAY15                (F4.0) /
 CPTDAY16                (F4.0) /
 CPTDAY17                (F4.0) /
 CPTDAY18                (F4.0) /
 CPTDAY19                (F4.0) /
 CPTDAY20                (F4.0) /
 CPTDAY21                (F4.0) /
 CPTDAY22                (F4.0) /
 CPTDAY23                (F4.0) /
 CPTDAY24                (F4.0) /
 CPTDAY25                (F4.0) /
 CPTDAY26                (F4.0) /
 CPTDAY27                (F4.0) /
 CPTDAY28                (F4.0) /
 CPTDAY29                (F4.0) /
 CPTDAY30                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPTCCS1   "CCS: CPT 1"
 CPTCCS2   "CCS: CPT 2"
 CPTCCS3   "CCS: CPT 3"
 CPTCCS4   "CCS: CPT 4"
 CPTCCS5   "CCS: CPT 5"
 CPTCCS6   "CCS: CPT 6"
 CPTCCS7   "CCS: CPT 7"
 CPTCCS8   "CCS: CPT 8"
 CPTCCS9   "CCS: CPT 9"
 CPTCCS10  "CCS: CPT 10"
 CPTCCS11  "CCS: CPT 11"
 CPTCCS12  "CCS: CPT 12"
 CPTCCS13  "CCS: CPT 13"
 CPTCCS14  "CCS: CPT 14"
 CPTCCS15  "CCS: CPT 15"
 CPTCCS16  "CCS: CPT 16"
 CPTCCS17  "CCS: CPT 17"
 CPTCCS18  "CCS: CPT 18"
 CPTCCS19  "CCS: CPT 19"
 CPTCCS20  "CCS: CPT 20"
 CPTCCS21  "CCS: CPT 21"
 CPTCCS22  "CCS: CPT 22"
 CPTCCS23  "CCS: CPT 23"
 CPTCCS24  "CCS: CPT 24"
 CPTCCS25  "CCS: CPT 25"
 CPTCCS26  "CCS: CPT 26"
 CPTCCS27  "CCS: CPT 27"
 CPTCCS28  "CCS: CPT 28"
 CPTCCS29  "CCS: CPT 29"
 CPTCCS30  "CCS: CPT 30"
 CPTDAY1   "Number of days from admission to CPT1"
 CPTDAY2   "Number of days from admission to CPT2"
 CPTDAY3   "Number of days from admission to CPT3"
 CPTDAY4   "Number of days from admission to CPT4"
 CPTDAY5   "Number of days from admission to CPT5"
 CPTDAY6   "Number of days from admission to CPT6"
 CPTDAY7   "Number of days from admission to CPT7"
 CPTDAY8   "Number of days from admission to CPT8"
 CPTDAY9   "Number of days from admission to CPT9"
 CPTDAY10  "Number of days from admission to CPT10"
 CPTDAY11  "Number of days from admission to CPT11"
 CPTDAY12  "Number of days from admission to CPT12"
 CPTDAY13  "Number of days from admission to CPT13"
 CPTDAY14  "Number of days from admission to CPT14"
 CPTDAY15  "Number of days from admission to CPT15"
 CPTDAY16  "Number of days from admission to CPT16"
 CPTDAY17  "Number of days from admission to CPT17"
 CPTDAY18  "Number of days from admission to CPT18"
 CPTDAY19  "Number of days from admission to CPT19"
 CPTDAY20  "Number of days from admission to CPT20"
 CPTDAY21  "Number of days from admission to CPT21"
 CPTDAY22  "Number of days from admission to CPT22"
 CPTDAY23  "Number of days from admission to CPT23"
 CPTDAY24  "Number of days from admission to CPT24"
 CPTDAY25  "Number of days from admission to CPT25"
 CPTDAY26  "Number of days from admission to CPT26"
 CPTDAY27  "Number of days from admission to CPT27"
 CPTDAY28  "Number of days from admission to CPT28"
 CPTDAY29  "Number of days from admission to CPT29"
 CPTDAY30  "Number of days from admission to CPT30"
 CPTM1_1   "First CPT-4/HCPCS modifier 1"
 CPTM1_2   "First CPT-4/HCPCS modifier 2"
 CPTM1_3   "First CPT-4/HCPCS modifier 3"
 CPTM1_4   "First CPT-4/HCPCS modifier 4"
 CPTM1_5   "First CPT-4/HCPCS modifier 5"
 CPTM1_6   "First CPT-4/HCPCS modifier 6"
 CPTM1_7   "First CPT-4/HCPCS modifier 7"
 CPTM1_8   "First CPT-4/HCPCS modifier 8"
 CPTM1_9   "First CPT-4/HCPCS modifier 9"
 CPTM1_10  "First CPT-4/HCPCS modifier 10"
 CPTM1_11  "First CPT-4/HCPCS modifier 11"
 CPTM1_12  "First CPT-4/HCPCS modifier 12"
 CPTM1_13  "First CPT-4/HCPCS modifier 13"
 CPTM1_14  "First CPT-4/HCPCS modifier 14"
 CPTM1_15  "First CPT-4/HCPCS modifier 15"
 CPTM1_16  "First CPT-4/HCPCS modifier 16"
 CPTM1_17  "First CPT-4/HCPCS modifier 17"
 CPTM1_18  "First CPT-4/HCPCS modifier 18"
 CPTM1_19  "First CPT-4/HCPCS modifier 19"
 CPTM1_20  "First CPT-4/HCPCS modifier 20"
 CPTM1_21  "First CPT-4/HCPCS modifier 21"
 CPTM1_22  "First CPT-4/HCPCS modifier 22"
 CPTM1_23  "First CPT-4/HCPCS modifier 23"
 CPTM1_24  "First CPT-4/HCPCS modifier 24"
 CPTM1_25  "First CPT-4/HCPCS modifier 25"
 CPTM1_26  "First CPT-4/HCPCS modifier 26"
 CPTM1_27  "First CPT-4/HCPCS modifier 27"
 CPTM1_28  "First CPT-4/HCPCS modifier 28"
 CPTM1_29  "First CPT-4/HCPCS modifier 29"
 CPTM1_30  "First CPT-4/HCPCS modifier 30"
 CPTM2_1   "Second CPT-4/HCPCS modifier 1"
 CPTM2_2   "Second CPT-4/HCPCS modifier 2"
 CPTM2_3   "Second CPT-4/HCPCS modifier 3"
 CPTM2_4   "Second CPT-4/HCPCS modifier 4"
 CPTM2_5   "Second CPT-4/HCPCS modifier 5"
 CPTM2_6   "Second CPT-4/HCPCS modifier 6"
 CPTM2_7   "Second CPT-4/HCPCS modifier 7"
 CPTM2_8   "Second CPT-4/HCPCS modifier 8"
 CPTM2_9   "Second CPT-4/HCPCS modifier 9"
 CPTM2_10  "Second CPT-4/HCPCS modifier 10"
 CPTM2_11  "Second CPT-4/HCPCS modifier 11"
 CPTM2_12  "Second CPT-4/HCPCS modifier 12"
 CPTM2_13  "Second CPT-4/HCPCS modifier 13"
 CPTM2_14  "Second CPT-4/HCPCS modifier 14"
 CPTM2_15  "Second CPT-4/HCPCS modifier 15"
 CPTM2_16  "Second CPT-4/HCPCS modifier 16"
 CPTM2_17  "Second CPT-4/HCPCS modifier 17"
 CPTM2_18  "Second CPT-4/HCPCS modifier 18"
 CPTM2_19  "Second CPT-4/HCPCS modifier 19"
 CPTM2_20  "Second CPT-4/HCPCS modifier 20"
 CPTM2_21  "Second CPT-4/HCPCS modifier 21"
 CPTM2_22  "Second CPT-4/HCPCS modifier 22"
 CPTM2_23  "Second CPT-4/HCPCS modifier 23"
 CPTM2_24  "Second CPT-4/HCPCS modifier 24"
 CPTM2_25  "Second CPT-4/HCPCS modifier 25"
 CPTM2_26  "Second CPT-4/HCPCS modifier 26"
 CPTM2_27  "Second CPT-4/HCPCS modifier 27"
 CPTM2_28  "Second CPT-4/HCPCS modifier 28"
 CPTM2_29  "Second CPT-4/HCPCS modifier 29"
 CPTM2_30  "Second CPT-4/HCPCS modifier 30"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 DX_Visit  "Reason for visit diagnosis 1"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IA_SEDD_2008_CORE.SAV' /COMPRESSED.
