/*******************************************************************
* Creation Date: 05/13/2016   
*   GA_SASD_2014_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'GA_SASD_2014_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 BODYSYSTEM1                     1-   2
 BODYSYSTEM2                     3-   4
 BODYSYSTEM3                     5-   6
 BODYSYSTEM4                     7-   8
 BODYSYSTEM5                     9-  10
 BODYSYSTEM6                    11-  12
 BODYSYSTEM7                    13-  14
 BODYSYSTEM8                    15-  16
 BODYSYSTEM9                    17-  18
 BODYSYSTEM10                   19-  20
 BODYSYSTEM11                   21-  22
 BODYSYSTEM12                   23-  24
 BODYSYSTEM13                   25-  26
 BODYSYSTEM14                   27-  28
 BODYSYSTEM15                   29-  30
 BODYSYSTEM16                   31-  32
 BODYSYSTEM17                   33-  34
 BODYSYSTEM18                   35-  36
 BODYSYSTEM19                   37-  38
 BODYSYSTEM20                   39-  40
 BODYSYSTEM21                   41-  42
 BODYSYSTEM22                   43-  44
 BODYSYSTEM23                   45-  46
 BODYSYSTEM24                   47-  48
 BODYSYSTEM25                   49-  50
 BODYSYSTEM26                   51-  52
 BODYSYSTEM27                   53-  54
 BODYSYSTEM28                   55-  56
 BODYSYSTEM29                   57-  58
 BODYSYSTEM30                   59-  60
 BODYSYSTEM31                   61-  62
 BODYSYSTEM32                   63-  64
 BODYSYSTEM33                   65-  66
 BODYSYSTEM34                   67-  68
 BODYSYSTEM35                   69-  70
 BODYSYSTEM36                   71-  72
 BODYSYSTEM37                   73-  74
 BODYSYSTEM38                   75-  76
 BODYSYSTEM39                   77-  78
 BODYSYSTEM40                   79-  80
 BODYSYSTEM41                   81-  82
 BODYSYSTEM42                   83-  84
 BODYSYSTEM43                   85-  86
 BODYSYSTEM44                   87-  88
 CHRON1                         89-  90
 CHRON2                         91-  92
 CHRON3                         93-  94
 CHRON4                         95-  96
 CHRON5                         97-  98
 CHRON6                         99- 100
 CHRON7                        101- 102
 CHRON8                        103- 104
 CHRON9                        105- 106
 CHRON10                       107- 108
 CHRON11                       109- 110
 CHRON12                       111- 112
 CHRON13                       113- 114
 CHRON14                       115- 116
 CHRON15                       117- 118
 CHRON16                       119- 120
 CHRON17                       121- 122
 CHRON18                       123- 124
 CHRON19                       125- 126
 CHRON20                       127- 128
 CHRON21                       129- 130
 CHRON22                       131- 132
 CHRON23                       133- 134
 CHRON24                       135- 136
 CHRON25                       137- 138
 CHRON26                       139- 140
 CHRON27                       141- 142
 CHRON28                       143- 144
 CHRON29                       145- 146
 CHRON30                       147- 148
 CHRON31                       149- 150
 CHRON32                       151- 152
 CHRON33                       153- 154
 CHRON34                       155- 156
 CHRON35                       157- 158
 CHRON36                       159- 160
 CHRON37                       161- 162
 CHRON38                       163- 164
 CHRON39                       165- 166
 CHRON40                       167- 168
 CHRON41                       169- 170
 CHRON42                       171- 172
 CHRON43                       173- 174
 CHRON44                       175- 176
 DXMCCS1                       177- 187 (A)
 DXMCCS2                       188- 198 (A)
 DXMCCS3                       199- 209 (A)
 DXMCCS4                       210- 220 (A)
 DXMCCS5                       221- 231 (A)
 DXMCCS6                       232- 242 (A)
 DXMCCS7                       243- 253 (A)
 DXMCCS8                       254- 264 (A)
 DXMCCS9                       265- 275 (A)
 DXMCCS10                      276- 286 (A)
 DXMCCS11                      287- 297 (A)
 DXMCCS12                      298- 308 (A)
 DXMCCS13                      309- 319 (A)
 DXMCCS14                      320- 330 (A)
 DXMCCS15                      331- 341 (A)
 DXMCCS16                      342- 352 (A)
 DXMCCS17                      353- 363 (A)
 DXMCCS18                      364- 374 (A)
 DXMCCS19                      375- 385 (A)
 DXMCCS20                      386- 396 (A)
 DXMCCS21                      397- 407 (A)
 DXMCCS22                      408- 418 (A)
 DXMCCS23                      419- 429 (A)
 DXMCCS24                      430- 440 (A)
 DXMCCS25                      441- 451 (A)
 DXMCCS26                      452- 462 (A)
 DXMCCS27                      463- 473 (A)
 DXMCCS28                      474- 484 (A)
 DXMCCS29                      485- 495 (A)
 DXMCCS30                      496- 506 (A)
 DXMCCS31                      507- 517 (A)
 DXMCCS32                      518- 528 (A)
 DXMCCS33                      529- 539 (A)
 DXMCCS34                      540- 550 (A)
 DXMCCS35                      551- 561 (A)
 DXMCCS36                      562- 572 (A)
 DXMCCS37                      573- 583 (A)
 DXMCCS38                      584- 594 (A)
 DXMCCS39                      595- 605 (A)
 DXMCCS40                      606- 616 (A)
 DXMCCS41                      617- 627 (A)
 DXMCCS42                      628- 638 (A)
 DXMCCS43                      639- 649 (A)
 DXMCCS44                      650- 660 (A)
 E_MCCS1                       661- 671 (A)
 E_MCCS2                       672- 682 (A)
 E_MCCS3                       683- 693 (A)
 E_MCCS4                       694- 704 (A)
 E_MCCS5                       705- 715 (A)
 E_MCCS6                       716- 726 (A)
 E_MCCS7                       727- 737 (A)
 INJURY                        738- 739
 INJURY_CUT                    740- 741
 INJURY_DROWN                  742- 743
 INJURY_FALL                   744- 745
 INJURY_FIRE                   746- 747
 INJURY_FIREARM                748- 749
 INJURY_MACHINERY              750- 751
 INJURY_MVT                    752- 753
 INJURY_NATURE                 754- 755
 INJURY_POISON                 756- 757
 INJURY_STRUCK                 758- 759
 INJURY_SUFFOCATION            760- 761
 INTENT_ASSAULT                762- 763
 INTENT_SELF_HARM              764- 765
 INTENT_UNINTENTIONAL          766- 767
 KEY                           768- 782
 MULTINJURY                    783- 784
 PCLASS1                       785- 786
 PCLASS2                       787- 788
 PCLASS3                       789- 790
 PCLASS4                       791- 792
 PCLASS5                       793- 794
 PCLASS6                       795- 796
 PCLASS7                       797- 798
 PCLASS8                       799- 800
 PCLASS9                       801- 802
 PCLASS10                      803- 804
 PCLASS11                      805- 806
 PCLASS12                      807- 808
 PCLASS13                      809- 810
 PCLASS14                      811- 812
 PCLASS15                      813- 814
 PCLASS16                      815- 816
 PCLASS17                      817- 818
 PCLASS18                      819- 820
 PCLASS19                      821- 822
 PCLASS20                      823- 824
 PCLASS21                      825- 826
 PCLASS22                      827- 828
 PCLASS23                      829- 830
 PCLASS24                      831- 832
 PCLASS25                      833- 834
 PCLASS26                      835- 836
 PCLASS27                      837- 838
 PCLASS28                      839- 840
 PCLASS29                      841- 842
 PCLASS30                      843- 844
 PCLASS31                      845- 846
 PCLASS32                      847- 848
 PCLASS33                      849- 850
 PCLASS34                      851- 852
 PCLASS35                      853- 854
 PCLASS36                      855- 856
 PCLASS37                      857- 858
 PCLASS38                      859- 860
 PCLASS39                      861- 862
 PCLASS40                      863- 864
 PCLASS41                      865- 866
 PRMCCS1                       867- 874 (A)
 PRMCCS2                       875- 882 (A)
 PRMCCS3                       883- 890 (A)
 PRMCCS4                       891- 898 (A)
 PRMCCS5                       899- 906 (A)
 PRMCCS6                       907- 914 (A)
 PRMCCS7                       915- 922 (A)
 PRMCCS8                       923- 930 (A)
 PRMCCS9                       931- 938 (A)
 PRMCCS10                      939- 946 (A)
 PRMCCS11                      947- 954 (A)
 PRMCCS12                      955- 962 (A)
 PRMCCS13                      963- 970 (A)
 PRMCCS14                      971- 978 (A)
 PRMCCS15                      979- 986 (A)
 PRMCCS16                      987- 994 (A)
 PRMCCS17                      995-1002 (A)
 PRMCCS18                     1003-1010 (A)
 PRMCCS19                     1011-1018 (A)
 PRMCCS20                     1019-1026 (A)
 PRMCCS21                     1027-1034 (A)
 PRMCCS22                     1035-1042 (A)
 PRMCCS23                     1043-1050 (A)
 PRMCCS24                     1051-1058 (A)
 PRMCCS25                     1059-1066 (A)
 PRMCCS26                     1067-1074 (A)
 PRMCCS27                     1075-1082 (A)
 PRMCCS28                     1083-1090 (A)
 PRMCCS29                     1091-1098 (A)
 PRMCCS30                     1099-1106 (A)
 PRMCCS31                     1107-1114 (A)
 PRMCCS32                     1115-1122 (A)
 PRMCCS33                     1123-1130 (A)
 PRMCCS34                     1131-1138 (A)
 PRMCCS35                     1139-1146 (A)
 PRMCCS36                     1147-1154 (A)
 PRMCCS37                     1155-1162 (A)
 PRMCCS38                     1163-1170 (A)
 PRMCCS39                     1171-1178 (A)
 PRMCCS40                     1179-1186 (A)
 PRMCCS41                     1187-1194 (A)
 U_BLOOD                      1195-1196
 U_CATH                       1197-1198
 U_CCU                        1199-1200
 U_CHESTXRAY                  1201-1202
 U_CTSCAN                     1203-1204
 U_DIALYSIS                   1205-1206
 U_ECHO                       1207-1208
 U_ED                         1209-1210
 U_EEG                        1211-1212
 U_EKG                        1213-1214
 U_EPO                        1215-1216
 U_ICU                        1217-1218
 U_LITHOTRIPSY                1219-1220
 U_MHSA                       1221-1222
 U_MRT                        1223-1224
 U_NEWBN2L                    1225-1226
 U_NEWBN3L                    1227-1228
 U_NEWBN4L                    1229-1230
 U_NUCMED                     1231-1232
 U_OBSERVATION                1233-1234
 U_OCCTHERAPY                 1235-1236
 U_ORGANACQ                   1237-1238
 U_OTHIMPLANTS                1239-1240
 U_PACEMAKER                  1241-1242
 U_PHYTHERAPY                 1243-1244
 U_RADTHERAPY                 1245-1246
 U_RESPTHERAPY                1247-1248
 U_SPEECHTHERAPY              1249-1250
 U_STRESS                     1251-1252
 U_ULTRASOUND                 1253-1254.


***  Specify write formats  ***.
FORMATS
 BODYSYSTEM1                  (F3.0) /
 BODYSYSTEM2                  (F3.0) /
 BODYSYSTEM3                  (F3.0) /
 BODYSYSTEM4                  (F3.0) /
 BODYSYSTEM5                  (F3.0) /
 BODYSYSTEM6                  (F3.0) /
 BODYSYSTEM7                  (F3.0) /
 BODYSYSTEM8                  (F3.0) /
 BODYSYSTEM9                  (F3.0) /
 BODYSYSTEM10                 (F3.0) /
 BODYSYSTEM11                 (F3.0) /
 BODYSYSTEM12                 (F3.0) /
 BODYSYSTEM13                 (F3.0) /
 BODYSYSTEM14                 (F3.0) /
 BODYSYSTEM15                 (F3.0) /
 BODYSYSTEM16                 (F3.0) /
 BODYSYSTEM17                 (F3.0) /
 BODYSYSTEM18                 (F3.0) /
 BODYSYSTEM19                 (F3.0) /
 BODYSYSTEM20                 (F3.0) /
 BODYSYSTEM21                 (F3.0) /
 BODYSYSTEM22                 (F3.0) /
 BODYSYSTEM23                 (F3.0) /
 BODYSYSTEM24                 (F3.0) /
 BODYSYSTEM25                 (F3.0) /
 BODYSYSTEM26                 (F3.0) /
 BODYSYSTEM27                 (F3.0) /
 BODYSYSTEM28                 (F3.0) /
 BODYSYSTEM29                 (F3.0) /
 BODYSYSTEM30                 (F3.0) /
 BODYSYSTEM31                 (F3.0) /
 BODYSYSTEM32                 (F3.0) /
 BODYSYSTEM33                 (F3.0) /
 BODYSYSTEM34                 (F3.0) /
 BODYSYSTEM35                 (F3.0) /
 BODYSYSTEM36                 (F3.0) /
 BODYSYSTEM37                 (F3.0) /
 BODYSYSTEM38                 (F3.0) /
 BODYSYSTEM39                 (F3.0) /
 BODYSYSTEM40                 (F3.0) /
 BODYSYSTEM41                 (F3.0) /
 BODYSYSTEM42                 (F3.0) /
 BODYSYSTEM43                 (F3.0) /
 BODYSYSTEM44                 (F3.0) /
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRON17                      (F3.0) /
 CHRON18                      (F3.0) /
 CHRON19                      (F3.0) /
 CHRON20                      (F3.0) /
 CHRON21                      (F3.0) /
 CHRON22                      (F3.0) /
 CHRON23                      (F3.0) /
 CHRON24                      (F3.0) /
 CHRON25                      (F3.0) /
 CHRON26                      (F3.0) /
 CHRON27                      (F3.0) /
 CHRON28                      (F3.0) /
 CHRON29                      (F3.0) /
 CHRON30                      (F3.0) /
 CHRON31                      (F3.0) /
 CHRON32                      (F3.0) /
 CHRON33                      (F3.0) /
 CHRON34                      (F3.0) /
 CHRON35                      (F3.0) /
 CHRON36                      (F3.0) /
 CHRON37                      (F3.0) /
 CHRON38                      (F3.0) /
 CHRON39                      (F3.0) /
 CHRON40                      (F3.0) /
 CHRON41                      (F3.0) /
 CHRON42                      (F3.0) /
 CHRON43                      (F3.0) /
 CHRON44                      (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
 PCLASS14                     (F3.0) /
 PCLASS15                     (F3.0) /
 PCLASS16                     (F3.0) /
 PCLASS17                     (F3.0) /
 PCLASS18                     (F3.0) /
 PCLASS19                     (F3.0) /
 PCLASS20                     (F3.0) /
 PCLASS21                     (F3.0) /
 PCLASS22                     (F3.0) /
 PCLASS23                     (F3.0) /
 PCLASS24                     (F3.0) /
 PCLASS25                     (F3.0) /
 PCLASS26                     (F3.0) /
 PCLASS27                     (F3.0) /
 PCLASS28                     (F3.0) /
 PCLASS29                     (F3.0) /
 PCLASS30                     (F3.0) /
 PCLASS31                     (F3.0) /
 PCLASS32                     (F3.0) /
 PCLASS33                     (F3.0) /
 PCLASS34                     (F3.0) /
 PCLASS35                     (F3.0) /
 PCLASS36                     (F3.0) /
 PCLASS37                     (F3.0) /
 PCLASS38                     (F3.0) /
 PCLASS39                     (F3.0) /
 PCLASS40                     (F3.0) /
 PCLASS41                     (F3.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 BODYSYSTEM1                  "Body system 1"
 BODYSYSTEM2                  "Body system 2"
 BODYSYSTEM3                  "Body system 3"
 BODYSYSTEM4                  "Body system 4"
 BODYSYSTEM5                  "Body system 5"
 BODYSYSTEM6                  "Body system 6"
 BODYSYSTEM7                  "Body system 7"
 BODYSYSTEM8                  "Body system 8"
 BODYSYSTEM9                  "Body system 9"
 BODYSYSTEM10                 "Body system 10"
 BODYSYSTEM11                 "Body system 11"
 BODYSYSTEM12                 "Body system 12"
 BODYSYSTEM13                 "Body system 13"
 BODYSYSTEM14                 "Body system 14"
 BODYSYSTEM15                 "Body system 15"
 BODYSYSTEM16                 "Body system 16"
 BODYSYSTEM17                 "Body system 17"
 BODYSYSTEM18                 "Body system 18"
 BODYSYSTEM19                 "Body system 19"
 BODYSYSTEM20                 "Body system 20"
 BODYSYSTEM21                 "Body system 21"
 BODYSYSTEM22                 "Body system 22"
 BODYSYSTEM23                 "Body system 23"
 BODYSYSTEM24                 "Body system 24"
 BODYSYSTEM25                 "Body system 25"
 BODYSYSTEM26                 "Body system 26"
 BODYSYSTEM27                 "Body system 27"
 BODYSYSTEM28                 "Body system 28"
 BODYSYSTEM29                 "Body system 29"
 BODYSYSTEM30                 "Body system 30"
 BODYSYSTEM31                 "Body system 31"
 BODYSYSTEM32                 "Body system 32"
 BODYSYSTEM33                 "Body system 33"
 BODYSYSTEM34                 "Body system 34"
 BODYSYSTEM35                 "Body system 35"
 BODYSYSTEM36                 "Body system 36"
 BODYSYSTEM37                 "Body system 37"
 BODYSYSTEM38                 "Body system 38"
 BODYSYSTEM39                 "Body system 39"
 BODYSYSTEM40                 "Body system 40"
 BODYSYSTEM41                 "Body system 41"
 BODYSYSTEM42                 "Body system 42"
 BODYSYSTEM43                 "Body system 43"
 BODYSYSTEM44                 "Body system 44"
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRON17                      "Chronic condition indicator 17"
 CHRON18                      "Chronic condition indicator 18"
 CHRON19                      "Chronic condition indicator 19"
 CHRON20                      "Chronic condition indicator 20"
 CHRON21                      "Chronic condition indicator 21"
 CHRON22                      "Chronic condition indicator 22"
 CHRON23                      "Chronic condition indicator 23"
 CHRON24                      "Chronic condition indicator 24"
 CHRON25                      "Chronic condition indicator 25"
 CHRON26                      "Chronic condition indicator 26"
 CHRON27                      "Chronic condition indicator 27"
 CHRON28                      "Chronic condition indicator 28"
 CHRON29                      "Chronic condition indicator 29"
 CHRON30                      "Chronic condition indicator 30"
 CHRON31                      "Chronic condition indicator 31"
 CHRON32                      "Chronic condition indicator 32"
 CHRON33                      "Chronic condition indicator 33"
 CHRON34                      "Chronic condition indicator 34"
 CHRON35                      "Chronic condition indicator 35"
 CHRON36                      "Chronic condition indicator 36"
 CHRON37                      "Chronic condition indicator 37"
 CHRON38                      "Chronic condition indicator 38"
 CHRON39                      "Chronic condition indicator 39"
 CHRON40                      "Chronic condition indicator 40"
 CHRON41                      "Chronic condition indicator 41"
 CHRON42                      "Chronic condition indicator 42"
 CHRON43                      "Chronic condition indicator 43"
 CHRON44                      "Chronic condition indicator 44"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                     "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                     "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                     "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                     "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                     "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                     "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                     "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                     "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                     "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                     "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                     "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                     "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                     "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                     "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                     "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                     "Multi-Level CCS:  Diagnosis 32"
 DXMCCS33                     "Multi-Level CCS:  Diagnosis 33"
 DXMCCS34                     "Multi-Level CCS:  Diagnosis 34"
 DXMCCS35                     "Multi-Level CCS:  Diagnosis 35"
 DXMCCS36                     "Multi-Level CCS:  Diagnosis 36"
 DXMCCS37                     "Multi-Level CCS:  Diagnosis 37"
 DXMCCS38                     "Multi-Level CCS:  Diagnosis 38"
 DXMCCS39                     "Multi-Level CCS:  Diagnosis 39"
 DXMCCS40                     "Multi-Level CCS:  Diagnosis 40"
 DXMCCS41                     "Multi-Level CCS:  Diagnosis 41"
 DXMCCS42                     "Multi-Level CCS:  Diagnosis 42"
 DXMCCS43                     "Multi-Level CCS:  Diagnosis 43"
 DXMCCS44                     "Multi-Level CCS:  Diagnosis 44"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE
"Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PCLASS14                     "Procedure class 14"
 PCLASS15                     "Procedure class 15"
 PCLASS16                     "Procedure class 16"
 PCLASS17                     "Procedure class 17"
 PCLASS18                     "Procedure class 18"
 PCLASS19                     "Procedure class 19"
 PCLASS20                     "Procedure class 20"
 PCLASS21                     "Procedure class 21"
 PCLASS22                     "Procedure class 22"
 PCLASS23                     "Procedure class 23"
 PCLASS24                     "Procedure class 24"
 PCLASS25                     "Procedure class 25"
 PCLASS26                     "Procedure class 26"
 PCLASS27                     "Procedure class 27"
 PCLASS28                     "Procedure class 28"
 PCLASS29                     "Procedure class 29"
 PCLASS30                     "Procedure class 30"
 PCLASS31                     "Procedure class 31"
 PCLASS32                     "Procedure class 32"
 PCLASS33                     "Procedure class 33"
 PCLASS34                     "Procedure class 34"
 PCLASS35                     "Procedure class 35"
 PCLASS36                     "Procedure class 36"
 PCLASS37                     "Procedure class 37"
 PCLASS38                     "Procedure class 38"
 PCLASS39                     "Procedure class 39"
 PCLASS40                     "Procedure class 40"
 PCLASS41                     "Procedure class 41"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13"
 PRMCCS14                     "Multi-Level CCS:  Procedure 14"
 PRMCCS15                     "Multi-Level CCS:  Procedure 15"
 PRMCCS16                     "Multi-Level CCS:  Procedure 16"
 PRMCCS17                     "Multi-Level CCS:  Procedure 17"
 PRMCCS18                     "Multi-Level CCS:  Procedure 18"
 PRMCCS19                     "Multi-Level CCS:  Procedure 19"
 PRMCCS20                     "Multi-Level CCS:  Procedure 20"
 PRMCCS21                     "Multi-Level CCS:  Procedure 21"
 PRMCCS22                     "Multi-Level CCS:  Procedure 22"
 PRMCCS23                     "Multi-Level CCS:  Procedure 23"
 PRMCCS24                     "Multi-Level CCS:  Procedure 24"
 PRMCCS25                     "Multi-Level CCS:  Procedure 25"
 PRMCCS26                     "Multi-Level CCS:  Procedure 26"
 PRMCCS27                     "Multi-Level CCS:  Procedure 27"
 PRMCCS28                     "Multi-Level CCS:  Procedure 28"
 PRMCCS29                     "Multi-Level CCS:  Procedure 29"
 PRMCCS30                     "Multi-Level CCS:  Procedure 30"
 PRMCCS31                     "Multi-Level CCS:  Procedure 31"
 PRMCCS32                     "Multi-Level CCS:  Procedure 32"
 PRMCCS33                     "Multi-Level CCS:  Procedure 33"
 PRMCCS34                     "Multi-Level CCS:  Procedure 34"
 PRMCCS35                     "Multi-Level CCS:  Procedure 35"
 PRMCCS36                     "Multi-Level CCS:  Procedure 36"
 PRMCCS37                     "Multi-Level CCS:  Procedure 37"
 PRMCCS38                     "Multi-Level CCS:  Procedure 38"
 PRMCCS39                     "Multi-Level CCS:  Procedure 39"
 PRMCCS40                     "Multi-Level CCS:  Procedure 40"
 PRMCCS41                     "Multi-Level CCS:  Procedure 41"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Magnetic Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM16
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM17
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM18
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM19
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM20
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM21
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM22
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM23
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM24
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM25
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM26
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM27
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM28
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM29
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM30
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM31
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM32
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM33
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM34
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM35
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM36
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM37
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM38
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM39
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM40
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM41
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM42
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM43
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM44
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON36
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON37
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON38
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON39
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON40
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON41
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON42
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON43
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON44
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS26
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS27
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS28
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS29
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS30
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS31
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS32
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS33
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS34
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS35
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS36
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS37
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS38
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS39
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS40
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS41
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'GA_SASD_2014_DX_PR_GRPS.SAV' /COMPRESSED.
