/*******************************************************************
*   WI_SASD_2010_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'WI_SASD_2010_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 BILLTYPE                  16-  19 (A)
 CPT1                      20-  24 (A)
 CPT2                      25-  29 (A)
 CPT3                      30-  34 (A)
 CPT4                      35-  39 (A)
 CPT5                      40-  44 (A)
 CPT6                      45-  49 (A)
 CPT7                      50-  54 (A)
 CPT8                      55-  59 (A)
 CPT9                      60-  64 (A)
 CPT10                     65-  69 (A)
 CPT11                     70-  74 (A)
 CPT12                     75-  79 (A)
 CPT13                     80-  84 (A)
 CPT14                     85-  89 (A)
 CPT15                     90-  94 (A)
 CPT16                     95-  99 (A)
 CPT17                    100- 104 (A)
 CPT18                    105- 109 (A)
 CPT19                    110- 114 (A)
 CPT20                    115- 119 (A)
 CPT21                    120- 124 (A)
 CPT22                    125- 129 (A)
 CPT23                    130- 134 (A)
 CPT24                    135- 139 (A)
 CPT25                    140- 144 (A)
 CPT26                    145- 149 (A)
 CPT27                    150- 154 (A)
 CPT28                    155- 159 (A)
 CPT29                    160- 164 (A)
 CPT30                    165- 169 (A)
 CPTCCS1                  170- 172
 CPTCCS2                  173- 175
 CPTCCS3                  176- 178
 CPTCCS4                  179- 181
 CPTCCS5                  182- 184
 CPTCCS6                  185- 187
 CPTCCS7                  188- 190
 CPTCCS8                  191- 193
 CPTCCS9                  194- 196
 CPTCCS10                 197- 199
 CPTCCS11                 200- 202
 CPTCCS12                 203- 205
 CPTCCS13                 206- 208
 CPTCCS14                 209- 211
 CPTCCS15                 212- 214
 CPTCCS16                 215- 217
 CPTCCS17                 218- 220
 CPTCCS18                 221- 223
 CPTCCS19                 224- 226
 CPTCCS20                 227- 229
 CPTCCS21                 230- 232
 CPTCCS22                 233- 235
 CPTCCS23                 236- 238
 CPTCCS24                 239- 241
 CPTCCS25                 242- 244
 CPTCCS26                 245- 247
 CPTCCS27                 248- 250
 CPTCCS28                 251- 253
 CPTCCS29                 254- 256
 CPTCCS30                 257- 259
 CPTM1_1                  260- 261 (A)
 CPTM1_2                  262- 263 (A)
 CPTM1_3                  264- 265 (A)
 CPTM1_4                  266- 267 (A)
 CPTM1_5                  268- 269 (A)
 CPTM1_6                  270- 271 (A)
 CPTM1_7                  272- 273 (A)
 CPTM1_8                  274- 275 (A)
 CPTM1_9                  276- 277 (A)
 CPTM1_10                 278- 279 (A)
 CPTM1_11                 280- 281 (A)
 CPTM1_12                 282- 283 (A)
 CPTM1_13                 284- 285 (A)
 CPTM1_14                 286- 287 (A)
 CPTM1_15                 288- 289 (A)
 CPTM1_16                 290- 291 (A)
 CPTM1_17                 292- 293 (A)
 CPTM1_18                 294- 295 (A)
 CPTM1_19                 296- 297 (A)
 CPTM1_20                 298- 299 (A)
 CPTM1_21                 300- 301 (A)
 CPTM1_22                 302- 303 (A)
 CPTM1_23                 304- 305 (A)
 CPTM1_24                 306- 307 (A)
 CPTM1_25                 308- 309 (A)
 CPTM1_26                 310- 311 (A)
 CPTM1_27                 312- 313 (A)
 CPTM1_28                 314- 315 (A)
 CPTM1_29                 316- 317 (A)
 CPTM1_30                 318- 319 (A)
 CPTM2_1                  320- 321 (A)
 CPTM2_2                  322- 323 (A)
 CPTM2_3                  324- 325 (A)
 CPTM2_4                  326- 327 (A)
 CPTM2_5                  328- 329 (A)
 CPTM2_6                  330- 331 (A)
 CPTM2_7                  332- 333 (A)
 CPTM2_8                  334- 335 (A)
 CPTM2_9                  336- 337 (A)
 CPTM2_10                 338- 339 (A)
 CPTM2_11                 340- 341 (A)
 CPTM2_12                 342- 343 (A)
 CPTM2_13                 344- 345 (A)
 CPTM2_14                 346- 347 (A)
 CPTM2_15                 348- 349 (A)
 CPTM2_16                 350- 351 (A)
 CPTM2_17                 352- 353 (A)
 CPTM2_18                 354- 355 (A)
 CPTM2_19                 356- 357 (A)
 CPTM2_20                 358- 359 (A)
 CPTM2_21                 360- 361 (A)
 CPTM2_22                 362- 363 (A)
 CPTM2_23                 364- 365 (A)
 CPTM2_24                 366- 367 (A)
 CPTM2_25                 368- 369 (A)
 CPTM2_26                 370- 371 (A)
 CPTM2_27                 372- 373 (A)
 CPTM2_28                 374- 375 (A)
 CPTM2_29                 376- 377 (A)
 CPTM2_30                 378- 379 (A)
 DIED                     380- 381
 DISPUB04                 382- 383
 DISPUNIFORM              384- 385
 DISP_X                   386- 387 (A)
 DQTR                     388- 389
 DSHOSPID                 390- 406 (A)
 DX1                      407- 411 (A)
 DX2                      412- 416 (A)
 DX3                      417- 421 (A)
 DX4                      422- 426 (A)
 DX5                      427- 431 (A)
 DX6                      432- 436 (A)
 DX7                      437- 441 (A)
 DX8                      442- 446 (A)
 DX9                      447- 451 (A)
 DX10                     452- 456 (A)
 DX11                     457- 461 (A)
 DX12                     462- 466 (A)
 DX13                     467- 471 (A)
 DX14                     472- 476 (A)
 DX15                     477- 481 (A)
 DX16                     482- 486 (A)
 DX17                     487- 491 (A)
 DX18                     492- 496 (A)
 DX19                     497- 501 (A)
 DX20                     502- 506 (A)
 DX21                     507- 511 (A)
 DX22                     512- 516 (A)
 DX23                     517- 521 (A)
 DX24                     522- 526 (A)
 DX25                     527- 531 (A)
 DX26                     532- 536 (A)
 DX27                     537- 541 (A)
 DX28                     542- 546 (A)
 DX29                     547- 551 (A)
 DX30                     552- 556 (A)
 DXCCS1                   557- 560
 DXCCS2                   561- 564
 DXCCS3                   565- 568
 DXCCS4                   569- 572
 DXCCS5                   573- 576
 DXCCS6                   577- 580
 DXCCS7                   581- 584
 DXCCS8                   585- 588
 DXCCS9                   589- 592
 DXCCS10                  593- 596
 DXCCS11                  597- 600
 DXCCS12                  601- 604
 DXCCS13                  605- 608
 DXCCS14                  609- 612
 DXCCS15                  613- 616
 DXCCS16                  617- 620
 DXCCS17                  621- 624
 DXCCS18                  625- 628
 DXCCS19                  629- 632
 DXCCS20                  633- 636
 DXCCS21                  637- 640
 DXCCS22                  641- 644
 DXCCS23                  645- 648
 DXCCS24                  649- 652
 DXCCS25                  653- 656
 DXCCS26                  657- 660
 DXCCS27                  661- 664
 DXCCS28                  665- 668
 DXCCS29                  669- 672
 DXCCS30                  673- 676
 DX_Visit_Reason1         677- 681 (A)
 DX_Visit_Reason2         682- 686 (A)
 DX_Visit_Reason3         687- 691 (A)
 ECODE1                   692- 696 (A)
 ECODE2                   697- 701 (A)
 ECODE3                   702- 706 (A)
 ECODE4                   707- 711 (A)
 ECODE5                   712- 716 (A)
 ECODE6                   717- 721 (A)
 ECODE7                   722- 726 (A)
 ECODE8                   727- 731 (A)
 ECODE9                   732- 736 (A)
 E_CCS1                   737- 740
 E_CCS2                   741- 744
 E_CCS3                   745- 748
 E_CCS4                   749- 752
 E_CCS5                   753- 756
 E_CCS6                   757- 760
 E_CCS7                   761- 764
 E_CCS8                   765- 768
 E_CCS9                   769- 772
 FEMALE                   773- 774
 HCUP_AS                  775- 776
 HCUP_ED                  777- 778
 HCUP_OS                  779- 780
 HISPANIC_X               781     (A)
 HOSPBRTH                 782- 784
 HOSPST                   785- 786 (A)
 Homeless                 787- 788
 KEY                      789- 802
 LOS                      803- 807
 LOS_X                    808- 813
 MDSPEC1                  814- 816 (A)
 MDSPEC2                  817- 819 (A)
 MEDINCSTQ                820- 821
 MRN_R                    822- 830
 NCHRONIC                 831- 833
 NCPT                     834- 836
 NDX                      837- 838
 NECODE                   839- 840
 NEOMAT                   841- 842
 NPR                      843- 844
 ORPROC                   845- 846
 PAY1                     847- 848
 PAY1_X                   849- 853 (A)
 PAY2                     854- 855
 PAY2_X                   856- 860 (A)
 PL_CBSA                  861- 863
 PL_MSA1993               864- 866
 PL_NCHS2006              867- 868
 PL_RUCA10_2005           869- 870
 PL_RUCA2005              871- 874
 PL_RUCA4_2005            875- 876
 PL_RUCC2003              877- 878
 PL_UIC2003               879- 880
 PL_UR_CAT4               881- 882
 PR1                      883- 886 (A)
 PR2                      887- 890 (A)
 PR3                      891- 894 (A)
 PR4                      895- 898 (A)
 PR5                      899- 902 (A)
 PR6                      903- 906 (A)
 PR7                      907- 910 (A)
 PR8                      911- 914 (A)
 PR9                      915- 918 (A)
 PR10                     919- 922 (A)
 PR11                     923- 926 (A)
 PR12                     927- 930 (A)
 PR13                     931- 934 (A)
 PR14                     935- 938 (A)
 PR15                     939- 942 (A)
 PR16                     943- 946 (A)
 PR17                     947- 950 (A)
 PR18                     951- 954 (A)
 PR19                     955- 958 (A)
 PR20                     959- 962 (A)
 PR21                     963- 966 (A)
 PR22                     967- 970 (A)
 PR23                     971- 974 (A)
 PR24                     975- 978 (A)
 PR25                     979- 982 (A)
 PR26                     983- 986 (A)
 PR27                     987- 990 (A)
 PR28                     991- 994 (A)
 PR29                     995- 998 (A)
 PR30                     999-1002 (A)
 PRCCS1                  1003-1005
 PRCCS2                  1006-1008
 PRCCS3                  1009-1011
 PRCCS4                  1012-1014
 PRCCS5                  1015-1017
 PRCCS6                  1018-1020
 PRCCS7                  1021-1023
 PRCCS8                  1024-1026
 PRCCS9                  1027-1029
 PRCCS10                 1030-1032
 PRCCS11                 1033-1035
 PRCCS12                 1036-1038
 PRCCS13                 1039-1041
 PRCCS14                 1042-1044
 PRCCS15                 1045-1047
 PRCCS16                 1048-1050
 PRCCS17                 1051-1053
 PRCCS18                 1054-1056
 PRCCS19                 1057-1059
 PRCCS20                 1060-1062
 PRCCS21                 1063-1065
 PRCCS22                 1066-1068
 PRCCS23                 1069-1071
 PRCCS24                 1072-1074
 PRCCS25                 1075-1077
 PRCCS26                 1078-1080
 PRCCS27                 1081-1083
 PRCCS28                 1084-1086
 PRCCS29                 1087-1089
 PRCCS30                 1090-1092
 PRDAY1                  1093-1097
 PROCTYPE                1098-1100
 PSTATE                  1101-1102 (A)
 PSTCO2                  1103-1107
 PointOfOriginUB04       1108     (A)
 PointOfOrigin_X         1109     (A)
 RACE                    1110-1111
 RACE_X                  1112     (A)
 STATE_AS                1113-1114
 STATE_ED                1115-1116
 STATE_OS                1117-1118
 TOTCHG                  1119-1128
 TOTCHG_X                1129-1143
 YEAR                    1144-1147
 ZIP3                    1148-1150 (A)
 ZIPINC_QRTL             1151-1153
 ZIP                     1154-1158 (A)
 AYEAR                   1159-1162
 DMONTH                  1163-1164
 BMONTH                  1165-1166
 BYEAR                   1167-1170
 PRMONTH1                1171-1172
 PRYEAR1                 1173-1176.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BILLTYPE                "UB-92 bill type"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM1_7                 "First CPT-4/HCPCS modifier 7"
 CPTM1_8                 "First CPT-4/HCPCS modifier 8"
 CPTM1_9                 "First CPT-4/HCPCS modifier 9"
 CPTM1_10                "First CPT-4/HCPCS modifier 10"
 CPTM1_11                "First CPT-4/HCPCS modifier 11"
 CPTM1_12                "First CPT-4/HCPCS modifier 12"
 CPTM1_13                "First CPT-4/HCPCS modifier 13"
 CPTM1_14                "First CPT-4/HCPCS modifier 14"
 CPTM1_15                "First CPT-4/HCPCS modifier 15"
 CPTM1_16                "First CPT-4/HCPCS modifier 16"
 CPTM1_17                "First CPT-4/HCPCS modifier 17"
 CPTM1_18                "First CPT-4/HCPCS modifier 18"
 CPTM1_19                "First CPT-4/HCPCS modifier 19"
 CPTM1_20                "First CPT-4/HCPCS modifier 20"
 CPTM1_21                "First CPT-4/HCPCS modifier 21"
 CPTM1_22                "First CPT-4/HCPCS modifier 22"
 CPTM1_23                "First CPT-4/HCPCS modifier 23"
 CPTM1_24                "First CPT-4/HCPCS modifier 24"
 CPTM1_25                "First CPT-4/HCPCS modifier 25"
 CPTM1_26                "First CPT-4/HCPCS modifier 26"
 CPTM1_27                "First CPT-4/HCPCS modifier 27"
 CPTM1_28                "First CPT-4/HCPCS modifier 28"
 CPTM1_29                "First CPT-4/HCPCS modifier 29"
 CPTM1_30                "First CPT-4/HCPCS modifier 30"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                 "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                 "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                 "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                "Second CPT-4/HCPCS modifier 30"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 DX_Visit_Reason1        "Reason for visit diagnosis 1"
 DX_Visit_Reason2        "Reason for visit diagnosis 2"
 DX_Visit_Reason3        "Reason for visit diagnosis 3"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 ECODE9                  "E code 9"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_CCS9                  "CCS: E Code 9"
 FEMALE                  "Indicator of sex"
 HCUP_AS                 "HCUP Ambulatory Surgery service indicator"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 Homeless                "Indicator that patient is homeless"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MDSPEC1                 "Physician 1 specialty (as received from source)"
 MDSPEC2                 "Physician 2 specialty (as received from source)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PR21                    "Procedure 21"
 PR22                    "Procedure 22"
 PR23                    "Procedure 23"
 PR24                    "Procedure 24"
 PR25                    "Procedure 25"
 PR26                    "Procedure 26"
 PR27                    "Procedure 27"
 PR28                    "Procedure 28"
 PR29                    "Procedure 29"
 PR30                    "Procedure 30"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRCCS21                 "CCS: procedure 21"
 PRCCS22                 "CCS: procedure 22"
 PRCCS23                 "CCS: procedure 23"
 PRCCS24                 "CCS: procedure 24"
 PRCCS25                 "CCS: procedure 25"
 PRCCS26                 "CCS: procedure 26"
 PRCCS27                 "CCS: procedure 27"
 PRCCS28                 "CCS: procedure 28"
 PRCCS29                 "CCS: procedure 29"
 PRCCS30                 "CCS: procedure 30"
 PRDAY1                  "Number of days from admission to PR1"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRYEAR1                 "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'WI_SASD_2010_CORE.SAV' /COMPRESSED.
