/*******************************************************************
* Creation Date: 01/11/2016   
*   VT_SASD_2014_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'VT_SASD_2014_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BILLTYPE                       20-  23 (A)
 CPT1                           24-  28 (A)
 CPT2                           29-  33 (A)
 CPT3                           34-  38 (A)
 CPT4                           39-  43 (A)
 CPT5                           44-  48 (A)
 CPT6                           49-  53 (A)
 CPT7                           54-  58 (A)
 CPT8                           59-  63 (A)
 CPT9                           64-  68 (A)
 CPT10                          69-  73 (A)
 CPT11                          74-  78 (A)
 CPT12                          79-  83 (A)
 CPT13                          84-  88 (A)
 CPT14                          89-  93 (A)
 CPT15                          94-  98 (A)
 CPT16                          99- 103 (A)
 CPT17                         104- 108 (A)
 CPT18                         109- 113 (A)
 CPT19                         114- 118 (A)
 CPT20                         119- 123 (A)
 CPT21                         124- 128 (A)
 CPT22                         129- 133 (A)
 CPT23                         134- 138 (A)
 CPT24                         139- 143 (A)
 CPT25                         144- 148 (A)
 CPT26                         149- 153 (A)
 CPT27                         154- 158 (A)
 CPT28                         159- 163 (A)
 CPT29                         164- 168 (A)
 CPT30                         169- 173 (A)
 CPT31                         174- 178 (A)
 CPT32                         179- 183 (A)
 CPT33                         184- 188 (A)
 CPT34                         189- 193 (A)
 CPT35                         194- 198 (A)
 CPT36                         199- 203 (A)
 CPT37                         204- 208 (A)
 CPT38                         209- 213 (A)
 CPT39                         214- 218 (A)
 CPT40                         219- 223 (A)
 CPT41                         224- 228 (A)
 CPT42                         229- 233 (A)
 CPT43                         234- 238 (A)
 CPT44                         239- 243 (A)
 CPT45                         244- 248 (A)
 CPT46                         249- 253 (A)
 CPT47                         254- 258 (A)
 CPT48                         259- 263 (A)
 CPT49                         264- 268 (A)
 CPT50                         269- 273 (A)
 CPTCCS1                       274- 276
 CPTCCS2                       277- 279
 CPTCCS3                       280- 282
 CPTCCS4                       283- 285
 CPTCCS5                       286- 288
 CPTCCS6                       289- 291
 CPTCCS7                       292- 294
 CPTCCS8                       295- 297
 CPTCCS9                       298- 300
 CPTCCS10                      301- 303
 CPTCCS11                      304- 306
 CPTCCS12                      307- 309
 CPTCCS13                      310- 312
 CPTCCS14                      313- 315
 CPTCCS15                      316- 318
 CPTCCS16                      319- 321
 CPTCCS17                      322- 324
 CPTCCS18                      325- 327
 CPTCCS19                      328- 330
 CPTCCS20                      331- 333
 CPTCCS21                      334- 336
 CPTCCS22                      337- 339
 CPTCCS23                      340- 342
 CPTCCS24                      343- 345
 CPTCCS25                      346- 348
 CPTCCS26                      349- 351
 CPTCCS27                      352- 354
 CPTCCS28                      355- 357
 CPTCCS29                      358- 360
 CPTCCS30                      361- 363
 CPTCCS31                      364- 366
 CPTCCS32                      367- 369
 CPTCCS33                      370- 372
 CPTCCS34                      373- 375
 CPTCCS35                      376- 378
 CPTCCS36                      379- 381
 CPTCCS37                      382- 384
 CPTCCS38                      385- 387
 CPTCCS39                      388- 390
 CPTCCS40                      391- 393
 CPTCCS41                      394- 396
 CPTCCS42                      397- 399
 CPTCCS43                      400- 402
 CPTCCS44                      403- 405
 CPTCCS45                      406- 408
 CPTCCS46                      409- 411
 CPTCCS47                      412- 414
 CPTCCS48                      415- 417
 CPTCCS49                      418- 420
 CPTCCS50                      421- 423
 CPTDAY1                       424- 426
 CPTDAY2                       427- 429
 CPTDAY3                       430- 432
 CPTDAY4                       433- 435
 CPTDAY5                       436- 438
 CPTDAY6                       439- 441
 CPTDAY7                       442- 444
 CPTDAY8                       445- 447
 CPTDAY9                       448- 450
 CPTDAY10                      451- 453
 CPTDAY11                      454- 456
 CPTDAY12                      457- 459
 CPTDAY13                      460- 462
 CPTDAY14                      463- 465
 CPTDAY15                      466- 468
 CPTDAY16                      469- 471
 CPTDAY17                      472- 474
 CPTDAY18                      475- 477
 CPTDAY19                      478- 480
 CPTDAY20                      481- 483
 CPTDAY21                      484- 486
 CPTDAY22                      487- 489
 CPTDAY23                      490- 492
 CPTDAY24                      493- 495
 CPTDAY25                      496- 498
 CPTDAY26                      499- 501
 CPTDAY27                      502- 504
 CPTDAY28                      505- 507
 CPTDAY29                      508- 510
 CPTDAY30                      511- 513
 CPTDAY31                      514- 516
 CPTDAY32                      517- 519
 CPTDAY33                      520- 522
 CPTDAY34                      523- 525
 CPTDAY35                      526- 528
 CPTDAY36                      529- 531
 CPTDAY37                      532- 534
 CPTDAY38                      535- 537
 CPTDAY39                      538- 540
 CPTDAY40                      541- 543
 CPTDAY41                      544- 546
 CPTDAY42                      547- 549
 CPTDAY43                      550- 552
 CPTDAY44                      553- 555
 CPTDAY45                      556- 558
 CPTDAY46                      559- 561
 CPTDAY47                      562- 564
 CPTDAY48                      565- 567
 CPTDAY49                      568- 570
 CPTDAY50                      571- 573
 CPTM1_1                       574- 575 (A)
 CPTM1_2                       576- 577 (A)
 CPTM1_3                       578- 579 (A)
 CPTM1_4                       580- 581 (A)
 CPTM1_5                       582- 583 (A)
 CPTM1_6                       584- 585 (A)
 CPTM1_7                       586- 587 (A)
 CPTM1_8                       588- 589 (A)
 CPTM1_9                       590- 591 (A)
 CPTM1_10                      592- 593 (A)
 CPTM1_11                      594- 595 (A)
 CPTM1_12                      596- 597 (A)
 CPTM1_13                      598- 599 (A)
 CPTM1_14                      600- 601 (A)
 CPTM1_15                      602- 603 (A)
 CPTM1_16                      604- 605 (A)
 CPTM1_17                      606- 607 (A)
 CPTM1_18                      608- 609 (A)
 CPTM1_19                      610- 611 (A)
 CPTM1_20                      612- 613 (A)
 CPTM1_21                      614- 615 (A)
 CPTM1_22                      616- 617 (A)
 CPTM1_23                      618- 619 (A)
 CPTM1_24                      620- 621 (A)
 CPTM1_25                      622- 623 (A)
 CPTM1_26                      624- 625 (A)
 CPTM1_27                      626- 627 (A)
 CPTM1_28                      628- 629 (A)
 CPTM1_29                      630- 631 (A)
 CPTM1_30                      632- 633 (A)
 CPTM1_31                      634- 635 (A)
 CPTM1_32                      636- 637 (A)
 CPTM1_33                      638- 639 (A)
 CPTM1_34                      640- 641 (A)
 CPTM1_35                      642- 643 (A)
 CPTM1_36                      644- 645 (A)
 CPTM1_37                      646- 647 (A)
 CPTM1_38                      648- 649 (A)
 CPTM1_39                      650- 651 (A)
 CPTM1_40                      652- 653 (A)
 CPTM1_41                      654- 655 (A)
 CPTM1_42                      656- 657 (A)
 CPTM1_43                      658- 659 (A)
 CPTM1_44                      660- 661 (A)
 CPTM1_45                      662- 663 (A)
 CPTM1_46                      664- 665 (A)
 CPTM1_47                      666- 667 (A)
 CPTM1_48                      668- 669 (A)
 CPTM1_49                      670- 671 (A)
 CPTM1_50                      672- 673 (A)
 CPTM2_1                       674- 675 (A)
 CPTM2_2                       676- 677 (A)
 CPTM2_3                       678- 679 (A)
 CPTM2_4                       680- 681 (A)
 CPTM2_5                       682- 683 (A)
 CPTM2_6                       684- 685 (A)
 CPTM2_7                       686- 687 (A)
 CPTM2_8                       688- 689 (A)
 CPTM2_9                       690- 691 (A)
 CPTM2_10                      692- 693 (A)
 CPTM2_11                      694- 695 (A)
 CPTM2_12                      696- 697 (A)
 CPTM2_13                      698- 699 (A)
 CPTM2_14                      700- 701 (A)
 CPTM2_15                      702- 703 (A)
 CPTM2_16                      704- 705 (A)
 CPTM2_17                      706- 707 (A)
 CPTM2_18                      708- 709 (A)
 CPTM2_19                      710- 711 (A)
 CPTM2_20                      712- 713 (A)
 CPTM2_21                      714- 715 (A)
 CPTM2_22                      716- 717 (A)
 CPTM2_23                      718- 719 (A)
 CPTM2_24                      720- 721 (A)
 CPTM2_25                      722- 723 (A)
 CPTM2_26                      724- 725 (A)
 CPTM2_27                      726- 727 (A)
 CPTM2_28                      728- 729 (A)
 CPTM2_29                      730- 731 (A)
 CPTM2_30                      732- 733 (A)
 CPTM2_31                      734- 735 (A)
 CPTM2_32                      736- 737 (A)
 CPTM2_33                      738- 739 (A)
 CPTM2_34                      740- 741 (A)
 CPTM2_35                      742- 743 (A)
 CPTM2_36                      744- 745 (A)
 CPTM2_37                      746- 747 (A)
 CPTM2_38                      748- 749 (A)
 CPTM2_39                      750- 751 (A)
 CPTM2_40                      752- 753 (A)
 CPTM2_41                      754- 755 (A)
 CPTM2_42                      756- 757 (A)
 CPTM2_43                      758- 759 (A)
 CPTM2_44                      760- 761 (A)
 CPTM2_45                      762- 763 (A)
 CPTM2_46                      764- 765 (A)
 CPTM2_47                      766- 767 (A)
 CPTM2_48                      768- 769 (A)
 CPTM2_49                      770- 771 (A)
 CPTM2_50                      772- 773 (A)
 DIED                          774- 775
 DISPUB04                      776- 777
 DISPUNIFORM                   778- 779
 DISP_X                        780- 781 (A)
 DMONTH                        782- 783
 DQTR                          784- 785
 DSHOSPID                      786- 802 (A)
 DX1                           803- 809 (A)
 DX2                           810- 816 (A)
 DX3                           817- 823 (A)
 DX4                           824- 830 (A)
 DX5                           831- 837 (A)
 DX6                           838- 844 (A)
 DX7                           845- 851 (A)
 DX8                           852- 858 (A)
 DX9                           859- 865 (A)
 DX10                          866- 872 (A)
 DX11                          873- 879 (A)
 DX12                          880- 886 (A)
 DX13                          887- 893 (A)
 DX14                          894- 900 (A)
 DX15                          901- 907 (A)
 DX16                          908- 914 (A)
 DX17                          915- 921 (A)
 DX18                          922- 928 (A)
 DX19                          929- 935 (A)
 DX20                          936- 942 (A)
 DXCCS1                        943- 946
 DXCCS2                        947- 950
 DXCCS3                        951- 954
 DXCCS4                        955- 958
 DXCCS5                        959- 962
 DXCCS6                        963- 966
 DXCCS7                        967- 970
 DXCCS8                        971- 974
 DXCCS9                        975- 978
 DXCCS10                       979- 982
 DXCCS11                       983- 986
 DXCCS12                       987- 990
 DXCCS13                       991- 994
 DXCCS14                       995- 998
 DXCCS15                       999-1002
 DXCCS16                      1003-1006
 DXCCS17                      1007-1010
 DXCCS18                      1011-1014
 DXCCS19                      1015-1018
 DXCCS20                      1019-1022
 DXVER                        1023-1025
 DX_Visit_Reason1             1026-1032 (A)
 DX_Visit_Reason2             1033-1039 (A)
 DaysToEvent                  1040-1045
 ECODE1                       1046-1052 (A)
 ECODE2                       1053-1059 (A)
 ECODE3                       1060-1066 (A)
 ECODE4                       1067-1073 (A)
 ECODE5                       1074-1080 (A)
 ECODE6                       1081-1087 (A)
 ECODE7                       1088-1094 (A)
 ECODE8                       1095-1101 (A)
 E_CCS1                       1102-1105
 E_CCS2                       1106-1109
 E_CCS3                       1110-1113
 E_CCS4                       1114-1117
 E_CCS5                       1118-1121
 E_CCS6                       1122-1125
 E_CCS7                       1126-1129
 E_CCS8                       1130-1133
 FEMALE                       1134-1135
 HCUP_ED                      1136-1137
 HCUP_OS                      1138-1139
 HISPANIC_X                   1140     (A)
 HOSPBRTH                     1141-1143
 HOSPST                       1144-1145 (A)
 HOSP_NPI                     1146-1155 (A)
 KEY                          1156-1170
 LOS                          1171-1175
 LOS_X                        1176-1181
 MEDINCSTQ                    1182-1183
 MRN_R                        1184-1192
 NCHRONIC                     1193-1195
 NCPT                         1196-1199
 NDX                          1200-1202
 NECODE                       1203-1204
 NEOMAT                       1205-1206
 NPR                          1207-1209
 ORPROC                       1210-1211
 PAY1                         1212-1213
 PAY1_X                       1214-1215 (A)
 PAY2                         1216-1217
 PAY2_X                       1218-1219 (A)
 PAY3                         1220-1221
 PAY3_X                       1222-1223 (A)
 PAYER1_X                     1224-1229 (A)
 PAYER2_X                     1230-1235 (A)
 PL_CBSA                      1236-1238
 PL_NCHS                      1239-1240
 PL_RUCC                      1241-1242
 PL_UIC                       1243-1244
 PL_UR_CAT4                   1245-1246
 PR1                          1247-1253 (A)
 PR2                          1254-1260 (A)
 PR3                          1261-1267 (A)
 PR4                          1268-1274 (A)
 PR5                          1275-1281 (A)
 PR6                          1282-1288 (A)
 PR7                          1289-1295 (A)
 PR8                          1296-1302 (A)
 PR9                          1303-1309 (A)
 PR10                         1310-1316 (A)
 PR11                         1317-1323 (A)
 PR12                         1324-1330 (A)
 PR13                         1331-1337 (A)
 PR14                         1338-1344 (A)
 PR15                         1345-1351 (A)
 PR16                         1352-1358 (A)
 PR17                         1359-1365 (A)
 PR18                         1366-1372 (A)
 PR19                         1373-1379 (A)
 PR20                         1380-1386 (A)
 PRCCS1                       1387-1389
 PRCCS2                       1390-1392
 PRCCS3                       1393-1395
 PRCCS4                       1396-1398
 PRCCS5                       1399-1401
 PRCCS6                       1402-1404
 PRCCS7                       1405-1407
 PRCCS8                       1408-1410
 PRCCS9                       1411-1413
 PRCCS10                      1414-1416
 PRCCS11                      1417-1419
 PRCCS12                      1420-1422
 PRCCS13                      1423-1425
 PRCCS14                      1426-1428
 PRCCS15                      1429-1431
 PRCCS16                      1432-1434
 PRCCS17                      1435-1437
 PRCCS18                      1438-1440
 PRCCS19                      1441-1443
 PRCCS20                      1444-1446
 PRDAY1                       1447-1451
 PRDAY2                       1452-1456
 PRDAY3                       1457-1461
 PRDAY4                       1462-1466
 PRDAY5                       1467-1471
 PRDAY6                       1472-1476
 PRDAY7                       1477-1481
 PRDAY8                       1482-1486
 PRDAY9                       1487-1491
 PRDAY10                      1492-1496
 PRDAY11                      1497-1501
 PRDAY12                      1502-1506
 PRDAY13                      1507-1511
 PRDAY14                      1512-1516
 PRDAY15                      1517-1521
 PRDAY16                      1522-1526
 PRDAY17                      1527-1531
 PRDAY18                      1532-1536
 PRDAY19                      1537-1541
 PRDAY20                      1542-1546
 PROCTYPE                     1547-1549
 PRVER                        1550-1552
 PSTATE                       1553-1554 (A)
 PSTCO                        1555-1559
 PSTCO2                       1560-1564
 PointOfOriginUB04            1565     (A)
 PointOfOrigin_X              1566     (A)
 RACE                         1567-1568
 RACE_X                       1569     (A)
 READMIT                      1570-1571
 STATE_AS                     1572-1573
 STATE_ED                     1574-1575
 STATE_OS                     1576-1577
 TOTCHG                       1578-1587
 TOTCHG_X                     1588-1602
 VisitLink                    1603-1611
 YEAR                         1612-1615
 ZIP                          1616-1620 (A)
 ZIP3                         1621-1623 (A)
 ZIPINC_QRTL                  1624-1626
 TOWN                         1627-1630 (A)
 AYEAR                        1631-1634
 BMONTH                       1635-1636
 BYEAR                        1637-1640
 PRMONTH1                     1641-1642
 PRMONTH2                     1643-1644
 PRMONTH3                     1645-1646
 PRMONTH4                     1647-1648
 PRMONTH5                     1649-1650
 PRMONTH6                     1651-1652
 PRMONTH7                     1653-1654
 PRMONTH8                     1655-1656
 PRMONTH9                     1657-1658
 PRMONTH10                    1659-1660
 PRMONTH11                    1661-1662
 PRMONTH12                    1663-1664
 PRMONTH13                    1665-1666
 PRMONTH14                    1667-1668
 PRMONTH15                    1669-1670
 PRMONTH16                    1671-1672
 PRMONTH17                    1673-1674
 PRMONTH18                    1675-1676
 PRMONTH19                    1677-1678
 PRMONTH20                    1679-1680
 PRYEAR1                      1681-1684
 PRYEAR2                      1685-1688
 PRYEAR3                      1689-1692
 PRYEAR4                      1693-1696
 PRYEAR5                      1697-1700
 PRYEAR6                      1701-1704
 PRYEAR7                      1705-1708
 PRYEAR8                      1709-1712
 PRYEAR9                      1713-1716
 PRYEAR10                     1717-1720
 PRYEAR11                     1721-1724
 PRYEAR12                     1725-1728
 PRYEAR13                     1729-1732
 PRYEAR14                     1733-1736
 PRYEAR15                     1737-1740
 PRYEAR16                     1741-1744
 PRYEAR17                     1745-1748
 PRYEAR18                     1749-1752
 PRYEAR19                     1753-1756
 PRYEAR20                     1757-1760.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 CPTDAY22                     (F4.0) /
 CPTDAY23                     (F4.0) /
 CPTDAY24                     (F4.0) /
 CPTDAY25                     (F4.0) /
 CPTDAY26                     (F4.0) /
 CPTDAY27                     (F4.0) /
 CPTDAY28                     (F4.0) /
 CPTDAY29                     (F4.0) /
 CPTDAY30                     (F4.0) /
 CPTDAY31                     (F4.0) /
 CPTDAY32                     (F4.0) /
 CPTDAY33                     (F4.0) /
 CPTDAY34                     (F4.0) /
 CPTDAY35                     (F4.0) /
 CPTDAY36                     (F4.0) /
 CPTDAY37                     (F4.0) /
 CPTDAY38                     (F4.0) /
 CPTDAY39                     (F4.0) /
 CPTDAY40                     (F4.0) /
 CPTDAY41                     (F4.0) /
 CPTDAY42                     (F4.0) /
 CPTDAY43                     (F4.0) /
 CPTDAY44                     (F4.0) /
 CPTDAY45                     (F4.0) /
 CPTDAY46                     (F4.0) /
 CPTDAY47                     (F4.0) /
 CPTDAY48                     (F4.0) /
 CPTDAY49                     (F4.0) /
 CPTDAY50                     (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 DXCCS19                      (F4.0) /
 DXCCS20                      (F4.0) /
 DXVER                        (F3.0) /
 DaysToEvent                  (F8.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCHRONIC                     (F3.0) /
 NCPT                         (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRCCS14                      (F3.0) /
 PRCCS15                      (F3.0) /
 PRCCS16                      (F3.0) /
 PRCCS17                      (F3.0) /
 PRCCS18                      (F3.0) /
 PRCCS19                      (F3.0) /
 PRCCS20                      (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PROCTYPE                     (F3.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 READMIT                      (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 CPTDAY22                     "Number of days from admission to CPT22"
 CPTDAY23                     "Number of days from admission to CPT23"
 CPTDAY24                     "Number of days from admission to CPT24"
 CPTDAY25                     "Number of days from admission to CPT25"
 CPTDAY26                     "Number of days from admission to CPT26"
 CPTDAY27                     "Number of days from admission to CPT27"
 CPTDAY28                     "Number of days from admission to CPT28"
 CPTDAY29                     "Number of days from admission to CPT29"
 CPTDAY30                     "Number of days from admission to CPT30"
 CPTDAY31                     "Number of days from admission to CPT31"
 CPTDAY32                     "Number of days from admission to CPT32"
 CPTDAY33                     "Number of days from admission to CPT33"
 CPTDAY34                     "Number of days from admission to CPT34"
 CPTDAY35                     "Number of days from admission to CPT35"
 CPTDAY36                     "Number of days from admission to CPT36"
 CPTDAY37                     "Number of days from admission to CPT37"
 CPTDAY38                     "Number of days from admission to CPT38"
 CPTDAY39                     "Number of days from admission to CPT39"
 CPTDAY40                     "Number of days from admission to CPT40"
 CPTDAY41                     "Number of days from admission to CPT41"
 CPTDAY42                     "Number of days from admission to CPT42"
 CPTDAY43                     "Number of days from admission to CPT43"
 CPTDAY44                     "Number of days from admission to CPT44"
 CPTDAY45                     "Number of days from admission to CPT45"
 CPTDAY46                     "Number of days from admission to CPT46"
 CPTDAY47                     "Number of days from admission to CPT47"
 CPTDAY48                     "Number of days from admission to CPT48"
 CPTDAY49                     "Number of days from admission to CPT49"
 CPTDAY50                     "Number of days from admission to CPT50"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM1_7                      "First CPT-4/HCPCS modifier 7"
 CPTM1_8                      "First CPT-4/HCPCS modifier 8"
 CPTM1_9                      "First CPT-4/HCPCS modifier 9"
 CPTM1_10                     "First CPT-4/HCPCS modifier 10"
 CPTM1_11                     "First CPT-4/HCPCS modifier 11"
 CPTM1_12                     "First CPT-4/HCPCS modifier 12"
 CPTM1_13                     "First CPT-4/HCPCS modifier 13"
 CPTM1_14                     "First CPT-4/HCPCS modifier 14"
 CPTM1_15                     "First CPT-4/HCPCS modifier 15"
 CPTM1_16                     "First CPT-4/HCPCS modifier 16"
 CPTM1_17                     "First CPT-4/HCPCS modifier 17"
 CPTM1_18                     "First CPT-4/HCPCS modifier 18"
 CPTM1_19                     "First CPT-4/HCPCS modifier 19"
 CPTM1_20                     "First CPT-4/HCPCS modifier 20"
 CPTM1_21                     "First CPT-4/HCPCS modifier 21"
 CPTM1_22                     "First CPT-4/HCPCS modifier 22"
 CPTM1_23                     "First CPT-4/HCPCS modifier 23"
 CPTM1_24                     "First CPT-4/HCPCS modifier 24"
 CPTM1_25                     "First CPT-4/HCPCS modifier 25"
 CPTM1_26                     "First CPT-4/HCPCS modifier 26"
 CPTM1_27                     "First CPT-4/HCPCS modifier 27"
 CPTM1_28                     "First CPT-4/HCPCS modifier 28"
 CPTM1_29                     "First CPT-4/HCPCS modifier 29"
 CPTM1_30                     "First CPT-4/HCPCS modifier 30"
 CPTM1_31                     "First CPT-4/HCPCS modifier 31"
 CPTM1_32                     "First CPT-4/HCPCS modifier 32"
 CPTM1_33                     "First CPT-4/HCPCS modifier 33"
 CPTM1_34                     "First CPT-4/HCPCS modifier 34"
 CPTM1_35                     "First CPT-4/HCPCS modifier 35"
 CPTM1_36                     "First CPT-4/HCPCS modifier 36"
 CPTM1_37                     "First CPT-4/HCPCS modifier 37"
 CPTM1_38                     "First CPT-4/HCPCS modifier 38"
 CPTM1_39                     "First CPT-4/HCPCS modifier 39"
 CPTM1_40                     "First CPT-4/HCPCS modifier 40"
 CPTM1_41                     "First CPT-4/HCPCS modifier 41"
 CPTM1_42                     "First CPT-4/HCPCS modifier 42"
 CPTM1_43                     "First CPT-4/HCPCS modifier 43"
 CPTM1_44                     "First CPT-4/HCPCS modifier 44"
 CPTM1_45                     "First CPT-4/HCPCS modifier 45"
 CPTM1_46                     "First CPT-4/HCPCS modifier 46"
 CPTM1_47                     "First CPT-4/HCPCS modifier 47"
 CPTM1_48                     "First CPT-4/HCPCS modifier 48"
 CPTM1_49                     "First CPT-4/HCPCS modifier 49"
 CPTM1_50                     "First CPT-4/HCPCS modifier 50"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                      "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                      "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                      "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                     "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                     "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                     "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                     "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                     "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                     "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                     "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                     "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                     "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                     "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                     "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                     "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                     "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                     "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                     "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                     "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                     "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                     "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                     "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                     "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                     "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                     "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                     "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                     "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                     "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                     "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                     "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                     "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                     "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                     "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                     "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                     "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                     "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                     "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                     "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                     "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                     "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                     "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                     "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                     "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                     "Second CPT-4/HCPCS modifier 50"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DSHOSPID                     "Data source hospital identifier"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DX19                         "Diagnosis 19"
 DX20                         "Diagnosis 20"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXCCS19                      "CCS: diagnosis 19"
 DXCCS20                      "CCS: diagnosis 20"
 DXVER                        "Diagnosis Version"
 DX_Visit_Reason1             "Reason for visit diagnosis 1"
 DX_Visit_Reason2             "Reason for visit diagnosis 2"
 DaysToEvent                  "Days from 'start date' to admission"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 HOSP_NPI                     "Hospital NPI"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCHRONIC                     "Number of chronic conditions"
 NCPT                         "Number of CPT/HCPCS procedures on this record"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 ORPROC                       "Major operating room procedure indicator"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PAYER1_X
"Primary expected payer plan identifier (as received from source)"
 PAYER2_X
"Secondary expected payer plan identifier (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PR14                         "Procedure 14"
 PR15                         "Procedure 15"
 PR16                         "Procedure 16"
 PR17                         "Procedure 17"
 PR18                         "Procedure 18"
 PR19                         "Procedure 19"
 PR20                         "Procedure 20"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRCCS14                      "CCS: procedure 14"
 PRCCS15                      "CCS: procedure 15"
 PRCCS16                      "CCS: procedure 16"
 PRCCS17                      "CCS: procedure 17"
 PRCCS18                      "CCS: procedure 18"
 PRCCS19                      "CCS: procedure 19"
 PRCCS20                      "CCS: procedure 20"
 PRDAY1                       "Number of days from admission to PR1"
 PRDAY2                       "Number of days from admission to PR2"
 PRDAY3                       "Number of days from admission to PR3"
 PRDAY4                       "Number of days from admission to PR4"
 PRDAY5                       "Number of days from admission to PR5"
 PRDAY6                       "Number of days from admission to PR6"
 PRDAY7                       "Number of days from admission to PR7"
 PRDAY8                       "Number of days from admission to PR8"
 PRDAY9                       "Number of days from admission to PR9"
 PRDAY10                      "Number of days from admission to PR10"
 PRDAY11                      "Number of days from admission to PR11"
 PRDAY12                      "Number of days from admission to PR12"
 PRDAY13                      "Number of days from admission to PR13"
 PRDAY14                      "Number of days from admission to PR14"
 PRDAY15                      "Number of days from admission to PR15"
 PRDAY16                      "Number of days from admission to PR16"
 PRDAY17                      "Number of days from admission to PR17"
 PRDAY18                      "Number of days from admission to PR18"
 PRDAY19                      "Number of days from admission to PR19"
 PRDAY20                      "Number of days from admission to PR20"
 PROCTYPE                     "Procedure type indicator"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 READMIT                      "Readmission"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 TOWN                         "Patient town of residence (as received from source)"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY50
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE READMIT
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'VT_SASD_2014_CORE.SAV' /COMPRESSED.
