/*******************************************************************
* Creation Date: 05/31/2019   
*   UT_SASD_2017_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'UT_SASD_2017_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 AWEEKEND                       12-  13
 BILLTYPE                       14-  17 (A)
 CPT1                           18-  22 (A)
 CPT2                           23-  27 (A)
 CPT3                           28-  32 (A)
 CPT4                           33-  37 (A)
 CPT5                           38-  42 (A)
 CPT6                           43-  47 (A)
 CPTCCS1                        48-  50
 CPTCCS2                        51-  53
 CPTCCS3                        54-  56
 CPTCCS4                        57-  59
 CPTCCS5                        60-  62
 CPTCCS6                        63-  65
 CPTDAY1                        66-  68
 CPTDAY2                        69-  71
 CPTDAY3                        72-  74
 CPTDAY4                        75-  77
 CPTDAY5                        78-  80
 CPTDAY6                        81-  83
 CPTM1_1                        84-  85 (A)
 CPTM1_2                        86-  87 (A)
 CPTM1_3                        88-  89 (A)
 CPTM1_4                        90-  91 (A)
 CPTM1_5                        92-  93 (A)
 CPTM1_6                        94-  95 (A)
 CPTM2_1                        96-  97 (A)
 CPTM2_2                        98-  99 (A)
 CPTM2_3                       100- 101 (A)
 CPTM2_4                       102- 103 (A)
 CPTM2_5                       104- 105 (A)
 CPTM2_6                       106- 107 (A)
 DaysToEvent                   108- 113
 DIED                          114- 115
 DISP_X                        116- 117 (A)
 DISPUB04                      118- 119
 DISPUNIFORM                   120- 121
 DMONTH                        122- 123
 DQTR                          124- 125
 DSHOSPID                      126- 142 (A)
 DXVER                         143- 145
 FEMALE                        146- 147
 HCUP_ED                       148- 149
 HCUP_OS                       150- 151
 HCUP_SURGERY_BROAD_CPT        152- 156
 HCUP_SURGERY_NARROW_CPT       157- 161
 HOSPST                        162- 163 (A)
 I10_DX_Visit_Reason1          164- 170 (A)
 I10_DX_Visit_Reason2          171- 177 (A)
 I10_DX_Visit_Reason3          178- 184 (A)
 I10_DX1                       185- 191 (A)
 I10_DX2                       192- 198 (A)
 I10_DX3                       199- 205 (A)
 I10_DX4                       206- 212 (A)
 I10_DX5                       213- 219 (A)
 I10_DX6                       220- 226 (A)
 I10_DX7                       227- 233 (A)
 I10_DX8                       234- 240 (A)
 I10_DX9                       241- 247 (A)
 I10_NDX                       248- 250
 I10_PROCTYPE                  251- 253
 KEY                           254- 268
 LOS                           269- 273
 LOS_X                         274- 279
 MDNUM1_R                      280- 288
 MEDINCSTQ                     289- 290
 NCPT                          291- 294
 PAY1                          295- 296
 PAY1_X                        297- 326 (A)
 PL_CBSA                       327- 329
 PL_NCHS                       330- 331
 PL_RUCC                       332- 333
 PL_UIC                        334- 335
 PL_UR_CAT4                    336- 337
 PointOfOrigin_X               338     (A)
 PointOfOriginUB04             339     (A)
 PSTATE                        340- 341 (A)
 PSTCO2                        342- 346
 STATE_AS                      347- 348
 STATE_ED                      349- 350
 STATE_OS                      351- 352
 TOTCHG                        353- 362
 TOTCHG_X                      363- 377
 VisitLink                     378- 386
 YEAR                          387- 390
 ZIP                           391- 395 (A)
 ZIP3                          396- 398 (A)
 ZIPINC_QRTL                   399- 401
 AYEAR                         402- 405
 BMONTH                        406- 407
 BYEAR                         408- 411.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HCUP_SURGERY_BROAD_CPT       (F3.0) /
 HCUP_SURGERY_NARROW_CPT      (F3.0) /
 I10_NDX                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDNUM1_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 PAY1                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PSTCO2                       (F4.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DSHOSPID                     "Data source hospital identifier"
 DXVER                        "Diagnosis Version"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD_CPT       "Number of reported CPT procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_NARROW_CPT      "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
 HOSPST                       "Hospital state postal code"
 I10_DX_Visit_Reason1         "ICD-10-CM Reason for visit diagnosis 1"
 I10_DX_Visit_Reason2         "ICD-10-CM Reason for visit diagnosis 2"
 I10_DX_Visit_Reason3         "ICD-10-CM Reason for visit diagnosis 3"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PSTATE                       "Patient State postal code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'UT_SASD_2017_CORE.SAV' /COMPRESSED.
