/*******************************************************************
* Creation Date: 05/01/2018   
*   UT_SASD_2015q1q3_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'UT_SASD_2015q1q3_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 AWEEKEND                       12-  13
 BILLTYPE                       14-  17 (A)
 CPT1                           18-  22 (A)
 CPT2                           23-  27 (A)
 CPT3                           28-  32 (A)
 CPT4                           33-  37 (A)
 CPT5                           38-  42 (A)
 CPT6                           43-  47 (A)
 CPTCCS1                        48-  50
 CPTCCS2                        51-  53
 CPTCCS3                        54-  56
 CPTCCS4                        57-  59
 CPTCCS5                        60-  62
 CPTCCS6                        63-  65
 CPTDAY1                        66-  68
 CPTM1_1                        69-  70 (A)
 CPTM1_2                        71-  72 (A)
 CPTM1_3                        73-  74 (A)
 CPTM1_4                        75-  76 (A)
 CPTM1_5                        77-  78 (A)
 CPTM1_6                        79-  80 (A)
 CPTM2_1                        81-  82 (A)
 CPTM2_2                        83-  84 (A)
 CPTM2_3                        85-  86 (A)
 CPTM2_4                        87-  88 (A)
 CPTM2_5                        89-  90 (A)
 CPTM2_6                        91-  92 (A)
 DaysToEvent                    93-  98
 DIED                           99- 100
 DISP_X                        101- 102 (A)
 DISPUB04                      103- 104
 DISPUNIFORM                   105- 106
 DMONTH                        107- 108
 DQTR                          109- 110
 DSHOSPID                      111- 127 (A)
 DX_Visit_Reason1              128- 134 (A)
 DX_Visit_Reason2              135- 141 (A)
 DX_Visit_Reason3              142- 148 (A)
 DX1                           149- 155 (A)
 DX2                           156- 162 (A)
 DX3                           163- 169 (A)
 DX4                           170- 176 (A)
 DX5                           177- 183 (A)
 DX6                           184- 190 (A)
 DX7                           191- 197 (A)
 DX8                           198- 204 (A)
 DX9                           205- 211 (A)
 DXCCS1                        212- 215
 DXCCS2                        216- 219
 DXCCS3                        220- 223
 DXCCS4                        224- 227
 DXCCS5                        228- 231
 DXCCS6                        232- 235
 DXCCS7                        236- 239
 DXCCS8                        240- 243
 DXCCS9                        244- 247
 DXVER                         248- 250
 E_CCS1                        251- 254
 E_CCS2                        255- 258
 E_CCS3                        259- 262
 E_CCS4                        263- 266
 E_CCS5                        267- 270
 E_CCS6                        271- 274
 ECODE1                        275- 281 (A)
 ECODE2                        282- 288 (A)
 ECODE3                        289- 295 (A)
 ECODE4                        296- 302 (A)
 ECODE5                        303- 309 (A)
 ECODE6                        310- 316 (A)
 FEMALE                        317- 318
 HCUP_ED                       319- 320
 HCUP_OS                       321- 322
 HCUP_SURGERY_BROAD_CPT        323- 327
 HCUP_SURGERY_BROAD_I9         328- 332
 HCUP_SURGERY_NARROW_CPT       333- 337
 HCUP_SURGERY_NARROW_I9        338- 342
 HOSPBRTH                      343- 345
 HOSPST                        346- 347 (A)
 KEY                           348- 362
 LOS                           363- 367
 LOS_X                         368- 373
 MDNUM1_R                      374- 382
 MEDINCSTQ                     383- 384
 NCHRONIC                      385- 387
 NCPT                          388- 391
 NDX                           392- 394
 NECODE                        395- 396
 NEOMAT                        397- 398
 NPR                           399- 401
 ORPROC                        402- 403
 PAY1                          404- 405
 PAY1_X                        406- 435 (A)
 PL_CBSA                       436- 438
 PL_NCHS                       439- 440
 PL_RUCC                       441- 442
 PL_UIC                        443- 444
 PL_UR_CAT4                    445- 446
 PointOfOrigin_X               447     (A)
 PointOfOriginUB04             448     (A)
 PR1                           449- 455 (A)
 PR2                           456- 462 (A)
 PR3                           463- 469 (A)
 PR4                           470- 476 (A)
 PR5                           477- 483 (A)
 PR6                           484- 490 (A)
 PRCCS1                        491- 493
 PRCCS2                        494- 496
 PRCCS3                        497- 499
 PRCCS4                        500- 502
 PRCCS5                        503- 505
 PRCCS6                        506- 508
 PRDAY1                        509- 513
 PROCTYPE                      514- 516
 PRVER                         517- 519
 PSTATE                        520- 521 (A)
 PSTCO2                        522- 526
 STATE_AS                      527- 528
 STATE_ED                      529- 530
 STATE_OS                      531- 532
 TOTCHG                        533- 542
 TOTCHG_X                      543- 557
 VisitLink                     558- 566
 YEAR                          567- 570
 ZIP                           571- 575 (A)
 ZIP3                          576- 578 (A)
 ZIPINC_QRTL                   579- 581
 AYEAR                         582- 585
 BMONTH                        586- 587
 BYEAR                         588- 591
 PRMONTH1                      592- 593
 PRYEAR1                       594- 597.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTDAY1                      (F4.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXVER                        (F3.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HCUP_SURGERY_BROAD_CPT       (F3.0) /
 HCUP_SURGERY_BROAD_I9        (F3.0) /
 HCUP_SURGERY_NARROW_CPT      (F3.0) /
 HCUP_SURGERY_NARROW_I9       (F3.0) /
 HOSPBRTH                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDNUM1_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 NCHRONIC                     (F3.0) /
 NCPT                         (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 PAY1                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRDAY1                       (F4.0) /
 PROCTYPE                     (F3.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRYEAR1                      (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DSHOSPID                     "Data source hospital identifier"
 DX_Visit_Reason1             "Reason for visit diagnosis 1"
 DX_Visit_Reason2             "Reason for visit diagnosis 2"
 DX_Visit_Reason3             "Reason for visit diagnosis 3"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXVER                        "Diagnosis Version"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD_CPT       "Number of reported CPT procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_BROAD_I9
"Number of reported ICD-9-CM procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_NARROW_CPT      "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
 HCUP_SURGERY_NARROW_I9
"Number of reported ICD-9-CM procedures that qualify as a surgery using a narrow definition"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCHRONIC                     "Number of chronic conditions"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 ORPROC                       "Major operating room procedure indicator"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRDAY1                       "Number of days from admission to PR1"
 PROCTYPE                     "Procedure type indicator"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRYEAR1                      "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_BROAD_I9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_I9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'UT_SASD_2015q1q3_CORE.SAV' /COMPRESSED.
