/*******************************************************************
*   UT_SASD_2000_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'UT_SASD_2000_CORE.ASC' FIXED / 
 KEY                   1-  14
 AGE                  15-  17
 AGEDAY               18-  20
 AGEMONTH             21-  23
 AMONTH               24-  25
 ASOURCE              26-  27
 ASOURCE_             28     (A)
 AWEEKEND             29-  30
 CPT1                 31-  35 (A)
 CPT2                 36-  40 (A)
 CPT3                 41-  45 (A)
 CPT4                 46-  50 (A)
 CPT5                 51-  55 (A)
 CPT6                 56-  60 (A)
 DIED                 61-  62
 DISP_X               63-  64 (A)
 DISPUB92             65-  66
 DISPUNIF             67-  68
 DQTR                 69-  70
 DSHOSPID             71-  83 (A)
 DX1                  84-  88 (A)
 DX2                  89-  93 (A)
 DX3                  94-  98 (A)
 DX4                  99- 103 (A)
 DX5                 104- 108 (A)
 DX6                 109- 113 (A)
 DX7                 114- 118 (A)
 DX8                 119- 123 (A)
 DX9                 124- 128 (A)
 DXCCS1              129- 132
 DXCCS2              133- 136
 DXCCS3              137- 140
 DXCCS4              141- 144
 DXCCS5              145- 148
 DXCCS6              149- 152
 DXCCS7              153- 156
 DXCCS8              157- 160
 DXCCS9              161- 164
 FEMALE              165- 166
 HOSPST              167- 168 (A)
 LOS                 169- 173
 LOS_X               174- 179
 NCPT                180- 181
 NDX                 182- 183
 NEOMAT              184- 185
 NPR                 186- 187
 PAY1                188- 189
 PAY2                190- 191
 PAY1_X              192- 193 (A)
 PAY2_X              194- 195 (A)
 PAY3_X              196- 197 (A)
 PR1                 198- 201 (A)
 PR2                 202- 205 (A)
 PR3                 206- 209 (A)
 PR4                 210- 213 (A)
 PR5                 214- 217 (A)
 PR6                 218- 221 (A)
 PRCCS1              222- 224
 PRCCS2              225- 227
 PRCCS3              228- 230
 PRCCS4              231- 233
 PRCCS5              234- 236
 PRCCS6              237- 239
 PRDAY1              240- 242
 TOTCHG              243- 252
 TOTCHG_X            253- 267
 YEAR                268- 271
 ZIP_S               272- 276 (A)
 AYEAR               277- 280
 DMONTH              281- 282
 BMONTH              283- 284
 BYEAR               285- 288
 PRMNTH1             289- 290
 PRYEAR1             291- 294.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 NCPT                (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRDAY1              (F4.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 BMONTH              (F3.0) /
 BYEAR               (F3.0) /
 PRMNTH1             (F3.0) /
 PRYEAR1             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 FEMALE    "Indicator of sex"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PAY3_X    "Tertiary expected payer (as received from source)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRDAY1    "Number of days from admission to PR1"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP_S     "Patient zip code (synthetic)"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE NCPT
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'UT_SASD_2000_CORE.SAV' /COMPRESSED.
