/*******************************************************************
* Creation Date: 01/02/2024   
*   SC_SASD_2021_CORE.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'SC_SASD_2021_CORE.asc' FIXED SKIP=2 / 
 AMONTH                          1-   2
 ATYPE                           3-   4
 AWEEKEND                        5-   6
 CPT1                            7-  11 (A)
 CPT2                           12-  16 (A)
 CPT3                           17-  21 (A)
 CPT4                           22-  26 (A)
 CPT5                           27-  31 (A)
 CPT6                           32-  36 (A)
 CPT7                           37-  41 (A)
 CPT8                           42-  46 (A)
 CPT9                           47-  51 (A)
 CPT10                          52-  56 (A)
 CPT11                          57-  61 (A)
 CPT12                          62-  66 (A)
 CPT13                          67-  71 (A)
 CPT14                          72-  76 (A)
 CPT15                          77-  81 (A)
 CPT16                          82-  86 (A)
 CPT17                          87-  91 (A)
 CPT18                          92-  96 (A)
 CPT19                          97- 101 (A)
 CPT20                         102- 106 (A)
 CPT21                         107- 111 (A)
 CPT22                         112- 116 (A)
 CPT23                         117- 121 (A)
 CPT24                         122- 126 (A)
 CPT25                         127- 131 (A)
 CPT26                         132- 136 (A)
 CPT27                         137- 141 (A)
 CPT28                         142- 146 (A)
 CPT29                         147- 151 (A)
 CPT30                         152- 156 (A)
 CPT31                         157- 161 (A)
 CPT32                         162- 166 (A)
 CPT33                         167- 171 (A)
 CPT34                         172- 176 (A)
 CPT35                         177- 181 (A)
 CPT36                         182- 186 (A)
 CPT37                         187- 191 (A)
 CPT38                         192- 196 (A)
 CPT39                         197- 201 (A)
 CPT40                         202- 206 (A)
 CPT41                         207- 211 (A)
 CPT42                         212- 216 (A)
 CPT43                         217- 221 (A)
 CPT44                         222- 226 (A)
 CPT45                         227- 231 (A)
 CPT46                         232- 236 (A)
 CPT47                         237- 241 (A)
 CPT48                         242- 246 (A)
 CPT49                         247- 251 (A)
 CPT50                         252- 256 (A)
 CPT51                         257- 261 (A)
 CPT52                         262- 266 (A)
 CPT53                         267- 271 (A)
 CPT54                         272- 276 (A)
 CPT55                         277- 281 (A)
 CPT56                         282- 286 (A)
 CPT57                         287- 291 (A)
 CPT58                         292- 296 (A)
 CPT59                         297- 301 (A)
 CPT60                         302- 306 (A)
 CPT61                         307- 311 (A)
 CPT62                         312- 316 (A)
 CPT63                         317- 321 (A)
 CPT64                         322- 326 (A)
 CPT65                         327- 331 (A)
 CPT66                         332- 336 (A)
 CPT67                         337- 341 (A)
 CPT68                         342- 346 (A)
 CPT69                         347- 351 (A)
 CPT70                         352- 356 (A)
 CPT71                         357- 361 (A)
 CPT72                         362- 366 (A)
 CPT73                         367- 371 (A)
 CPT74                         372- 376 (A)
 CPT75                         377- 381 (A)
 CPT76                         382- 386 (A)
 CPT77                         387- 391 (A)
 CPT78                         392- 396 (A)
 CPT79                         397- 401 (A)
 CPT80                         402- 406 (A)
 CPT81                         407- 411 (A)
 CPT82                         412- 416 (A)
 CPT83                         417- 421 (A)
 CPT84                         422- 426 (A)
 CPT85                         427- 431 (A)
 CPT86                         432- 436 (A)
 CPT87                         437- 441 (A)
 CPT88                         442- 446 (A)
 CPT89                         447- 451 (A)
 CPT90                         452- 456 (A)
 CPT91                         457- 461 (A)
 CPT92                         462- 466 (A)
 CPT93                         467- 471 (A)
 CPT94                         472- 476 (A)
 CPT95                         477- 481 (A)
 CPT96                         482- 486 (A)
 CPT97                         487- 491 (A)
 CPT98                         492- 496 (A)
 CPT99                         497- 501 (A)
 CPT100                        502- 506 (A)
 CPT101                        507- 511 (A)
 CPT102                        512- 516 (A)
 CPT103                        517- 521 (A)
 CPT104                        522- 526 (A)
 CPT105                        527- 531 (A)
 CPT106                        532- 536 (A)
 CPT107                        537- 541 (A)
 CPT108                        542- 546 (A)
 CPT109                        547- 551 (A)
 CPT110                        552- 556 (A)
 CPT111                        557- 561 (A)
 CPT112                        562- 566 (A)
 CPT113                        567- 571 (A)
 CPT114                        572- 576 (A)
 CPT115                        577- 581 (A)
 CPT116                        582- 586 (A)
 CPT117                        587- 591 (A)
 CPT118                        592- 596 (A)
 CPT119                        597- 601 (A)
 CPT120                        602- 606 (A)
 CPT121                        607- 611 (A)
 CPT122                        612- 616 (A)
 CPT123                        617- 621 (A)
 CPT124                        622- 626 (A)
 CPT125                        627- 631 (A)
 CPT126                        632- 636 (A)
 CPT127                        637- 641 (A)
 CPT128                        642- 646 (A)
 CPT129                        647- 651 (A)
 CPT130                        652- 656 (A)
 CPTCCS1                       657- 659
 CPTCCS2                       660- 662
 CPTCCS3                       663- 665
 CPTCCS4                       666- 668
 CPTCCS5                       669- 671
 CPTCCS6                       672- 674
 CPTCCS7                       675- 677
 CPTCCS8                       678- 680
 CPTCCS9                       681- 683
 CPTCCS10                      684- 686
 CPTCCS11                      687- 689
 CPTCCS12                      690- 692
 CPTCCS13                      693- 695
 CPTCCS14                      696- 698
 CPTCCS15                      699- 701
 CPTCCS16                      702- 704
 CPTCCS17                      705- 707
 CPTCCS18                      708- 710
 CPTCCS19                      711- 713
 CPTCCS20                      714- 716
 CPTCCS21                      717- 719
 CPTCCS22                      720- 722
 CPTCCS23                      723- 725
 CPTCCS24                      726- 728
 CPTCCS25                      729- 731
 CPTCCS26                      732- 734
 CPTCCS27                      735- 737
 CPTCCS28                      738- 740
 CPTCCS29                      741- 743
 CPTCCS30                      744- 746
 CPTCCS31                      747- 749
 CPTCCS32                      750- 752
 CPTCCS33                      753- 755
 CPTCCS34                      756- 758
 CPTCCS35                      759- 761
 CPTCCS36                      762- 764
 CPTCCS37                      765- 767
 CPTCCS38                      768- 770
 CPTCCS39                      771- 773
 CPTCCS40                      774- 776
 CPTCCS41                      777- 779
 CPTCCS42                      780- 782
 CPTCCS43                      783- 785
 CPTCCS44                      786- 788
 CPTCCS45                      789- 791
 CPTCCS46                      792- 794
 CPTCCS47                      795- 797
 CPTCCS48                      798- 800
 CPTCCS49                      801- 803
 CPTCCS50                      804- 806
 CPTCCS51                      807- 809
 CPTCCS52                      810- 812
 CPTCCS53                      813- 815
 CPTCCS54                      816- 818
 CPTCCS55                      819- 821
 CPTCCS56                      822- 824
 CPTCCS57                      825- 827
 CPTCCS58                      828- 830
 CPTCCS59                      831- 833
 CPTCCS60                      834- 836
 CPTCCS61                      837- 839
 CPTCCS62                      840- 842
 CPTCCS63                      843- 845
 CPTCCS64                      846- 848
 CPTCCS65                      849- 851
 CPTCCS66                      852- 854
 CPTCCS67                      855- 857
 CPTCCS68                      858- 860
 CPTCCS69                      861- 863
 CPTCCS70                      864- 866
 CPTCCS71                      867- 869
 CPTCCS72                      870- 872
 CPTCCS73                      873- 875
 CPTCCS74                      876- 878
 CPTCCS75                      879- 881
 CPTCCS76                      882- 884
 CPTCCS77                      885- 887
 CPTCCS78                      888- 890
 CPTCCS79                      891- 893
 CPTCCS80                      894- 896
 CPTCCS81                      897- 899
 CPTCCS82                      900- 902
 CPTCCS83                      903- 905
 CPTCCS84                      906- 908
 CPTCCS85                      909- 911
 CPTCCS86                      912- 914
 CPTCCS87                      915- 917
 CPTCCS88                      918- 920
 CPTCCS89                      921- 923
 CPTCCS90                      924- 926
 CPTCCS91                      927- 929
 CPTCCS92                      930- 932
 CPTCCS93                      933- 935
 CPTCCS94                      936- 938
 CPTCCS95                      939- 941
 CPTCCS96                      942- 944
 CPTCCS97                      945- 947
 CPTCCS98                      948- 950
 CPTCCS99                      951- 953
 CPTCCS100                     954- 956
 CPTCCS101                     957- 959
 CPTCCS102                     960- 962
 CPTCCS103                     963- 965
 CPTCCS104                     966- 968
 CPTCCS105                     969- 971
 CPTCCS106                     972- 974
 CPTCCS107                     975- 977
 CPTCCS108                     978- 980
 CPTCCS109                     981- 983
 CPTCCS110                     984- 986
 CPTCCS111                     987- 989
 CPTCCS112                     990- 992
 CPTCCS113                     993- 995
 CPTCCS114                     996- 998
 CPTCCS115                     999-1001
 CPTCCS116                    1002-1004
 CPTCCS117                    1005-1007
 CPTCCS118                    1008-1010
 CPTCCS119                    1011-1013
 CPTCCS120                    1014-1016
 CPTCCS121                    1017-1019
 CPTCCS122                    1020-1022
 CPTCCS123                    1023-1025
 CPTCCS124                    1026-1028
 CPTCCS125                    1029-1031
 CPTCCS126                    1032-1034
 CPTCCS127                    1035-1037
 CPTCCS128                    1038-1040
 CPTCCS129                    1041-1043
 CPTCCS130                    1044-1046
 DIED                         1047-1048
 DISP_X                       1049-1050 (A)
 DISPUB04                     1051-1052
 DISPUNIFORM                  1053-1054
 DMONTH                       1055-1056
 DQTR                         1057-1058
 FEMALE                       1059-1060
 HCUP_ED                      1061-1062
 HCUP_OS                      1063-1064
 HCUP_SURGERY_BROAD_CPT       1065-1069
 HCUP_SURGERY_NARROW_CPT      1070-1074
 HOSPST                       1075-1076 (A)
 I10_DX_Visit_Reason1         1077-1083 (A)
 I10_DX_Visit_Reason2         1084-1090 (A)
 I10_DX_Visit_Reason3         1091-1097 (A)
 I10_DX1                      1098-1104 (A)
 I10_DX2                      1105-1111 (A)
 I10_DX3                      1112-1118 (A)
 I10_DX4                      1119-1125 (A)
 I10_DX5                      1126-1132 (A)
 I10_DX6                      1133-1139 (A)
 I10_DX7                      1140-1146 (A)
 I10_DX8                      1147-1153 (A)
 I10_DX9                      1154-1160 (A)
 I10_DX10                     1161-1167 (A)
 I10_DX11                     1168-1174 (A)
 I10_DX12                     1175-1181 (A)
 I10_DX13                     1182-1188 (A)
 I10_DX14                     1189-1195 (A)
 I10_DX15                     1196-1202 (A)
 I10_DX16                     1203-1209 (A)
 I10_DX17                     1210-1216 (A)
 I10_NDX                      1217-1219
 I10_PROCTYPE                 1220-1222
 KEY                          1223-1237
 MDSPEC1                      1238-1240 (A)
 MDSPEC2                      1241-1243 (A)
 MEDINCSTQ                    1244-1245
 NCPT                         1246-1249
 PAY1                         1250-1251
 PAY1_X                       1252-1253 (A)
 PL_NCHS                      1254-1255
 PointOfOrigin_X              1256     (A)
 PointOfOriginUB04            1257     (A)
 PSTATE                       1258-1259 (A)
 PSTATE_GEO                   1260-1261 (A)
 PSTCO                        1262-1266
 RACE                         1267-1268
 RACE_X                       1269     (A)
 SASD_SEDD                    1270-1271
 STATE_AS                     1272-1273
 STATE_ED                     1274-1275
 STATE_OS                     1276-1277
 TOTCHG                       1278-1287
 TOTCHG_X                     1288-1302
 YEAR                         1303-1306
 ZIPINC_QRTL                  1307-1309
 AGEGROUP                     1310-1312
 AYEAR                        1313-1316.


/***  Specify write formats  ***/
FORMATS
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTCCS77                     (F4.0) /
 CPTCCS78                     (F4.0) /
 CPTCCS79                     (F4.0) /
 CPTCCS80                     (F4.0) /
 CPTCCS81                     (F4.0) /
 CPTCCS82                     (F4.0) /
 CPTCCS83                     (F4.0) /
 CPTCCS84                     (F4.0) /
 CPTCCS85                     (F4.0) /
 CPTCCS86                     (F4.0) /
 CPTCCS87                     (F4.0) /
 CPTCCS88                     (F4.0) /
 CPTCCS89                     (F4.0) /
 CPTCCS90                     (F4.0) /
 CPTCCS91                     (F4.0) /
 CPTCCS92                     (F4.0) /
 CPTCCS93                     (F4.0) /
 CPTCCS94                     (F4.0) /
 CPTCCS95                     (F4.0) /
 CPTCCS96                     (F4.0) /
 CPTCCS97                     (F4.0) /
 CPTCCS98                     (F4.0) /
 CPTCCS99                     (F4.0) /
 CPTCCS100                    (F4.0) /
 CPTCCS101                    (F4.0) /
 CPTCCS102                    (F4.0) /
 CPTCCS103                    (F4.0) /
 CPTCCS104                    (F4.0) /
 CPTCCS105                    (F4.0) /
 CPTCCS106                    (F4.0) /
 CPTCCS107                    (F4.0) /
 CPTCCS108                    (F4.0) /
 CPTCCS109                    (F4.0) /
 CPTCCS110                    (F4.0) /
 CPTCCS111                    (F4.0) /
 CPTCCS112                    (F4.0) /
 CPTCCS113                    (F4.0) /
 CPTCCS114                    (F4.0) /
 CPTCCS115                    (F4.0) /
 CPTCCS116                    (F4.0) /
 CPTCCS117                    (F4.0) /
 CPTCCS118                    (F4.0) /
 CPTCCS119                    (F4.0) /
 CPTCCS120                    (F4.0) /
 CPTCCS121                    (F4.0) /
 CPTCCS122                    (F4.0) /
 CPTCCS123                    (F4.0) /
 CPTCCS124                    (F4.0) /
 CPTCCS125                    (F4.0) /
 CPTCCS126                    (F4.0) /
 CPTCCS127                    (F4.0) /
 CPTCCS128                    (F4.0) /
 CPTCCS129                    (F4.0) /
 CPTCCS130                    (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HCUP_SURGERY_BROAD_CPT       (F3.0) /
 HCUP_SURGERY_NARROW_CPT      (F3.0) /
 I10_NDX                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 PAY1                         (F3.0) /
 PL_NCHS                      (F3.0) /
 PSTCO                        (F4.0) /
 RACE                         (F3.0) /
 SASD_SEDD                    (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AGEGROUP                     (F3.0) /
 AYEAR                        (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPT77                        "CPT/HCPCS procedure code 77"
 CPT78                        "CPT/HCPCS procedure code 78"
 CPT79                        "CPT/HCPCS procedure code 79"
 CPT80                        "CPT/HCPCS procedure code 80"
 CPT81                        "CPT/HCPCS procedure code 81"
 CPT82                        "CPT/HCPCS procedure code 82"
 CPT83                        "CPT/HCPCS procedure code 83"
 CPT84                        "CPT/HCPCS procedure code 84"
 CPT85                        "CPT/HCPCS procedure code 85"
 CPT86                        "CPT/HCPCS procedure code 86"
 CPT87                        "CPT/HCPCS procedure code 87"
 CPT88                        "CPT/HCPCS procedure code 88"
 CPT89                        "CPT/HCPCS procedure code 89"
 CPT90                        "CPT/HCPCS procedure code 90"
 CPT91                        "CPT/HCPCS procedure code 91"
 CPT92                        "CPT/HCPCS procedure code 92"
 CPT93                        "CPT/HCPCS procedure code 93"
 CPT94                        "CPT/HCPCS procedure code 94"
 CPT95                        "CPT/HCPCS procedure code 95"
 CPT96                        "CPT/HCPCS procedure code 96"
 CPT97                        "CPT/HCPCS procedure code 97"
 CPT98                        "CPT/HCPCS procedure code 98"
 CPT99                        "CPT/HCPCS procedure code 99"
 CPT100                       "CPT/HCPCS procedure code 100"
 CPT101                       "CPT/HCPCS procedure code 101"
 CPT102                       "CPT/HCPCS procedure code 102"
 CPT103                       "CPT/HCPCS procedure code 103"
 CPT104                       "CPT/HCPCS procedure code 104"
 CPT105                       "CPT/HCPCS procedure code 105"
 CPT106                       "CPT/HCPCS procedure code 106"
 CPT107                       "CPT/HCPCS procedure code 107"
 CPT108                       "CPT/HCPCS procedure code 108"
 CPT109                       "CPT/HCPCS procedure code 109"
 CPT110                       "CPT/HCPCS procedure code 110"
 CPT111                       "CPT/HCPCS procedure code 111"
 CPT112                       "CPT/HCPCS procedure code 112"
 CPT113                       "CPT/HCPCS procedure code 113"
 CPT114                       "CPT/HCPCS procedure code 114"
 CPT115                       "CPT/HCPCS procedure code 115"
 CPT116                       "CPT/HCPCS procedure code 116"
 CPT117                       "CPT/HCPCS procedure code 117"
 CPT118                       "CPT/HCPCS procedure code 118"
 CPT119                       "CPT/HCPCS procedure code 119"
 CPT120                       "CPT/HCPCS procedure code 120"
 CPT121                       "CPT/HCPCS procedure code 121"
 CPT122                       "CPT/HCPCS procedure code 122"
 CPT123                       "CPT/HCPCS procedure code 123"
 CPT124                       "CPT/HCPCS procedure code 124"
 CPT125                       "CPT/HCPCS procedure code 125"
 CPT126                       "CPT/HCPCS procedure code 126"
 CPT127                       "CPT/HCPCS procedure code 127"
 CPT128                       "CPT/HCPCS procedure code 128"
 CPT129                       "CPT/HCPCS procedure code 129"
 CPT130                       "CPT/HCPCS procedure code 130"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTCCS77                     "CCS: CPT 77"
 CPTCCS78                     "CCS: CPT 78"
 CPTCCS79                     "CCS: CPT 79"
 CPTCCS80                     "CCS: CPT 80"
 CPTCCS81                     "CCS: CPT 81"
 CPTCCS82                     "CCS: CPT 82"
 CPTCCS83                     "CCS: CPT 83"
 CPTCCS84                     "CCS: CPT 84"
 CPTCCS85                     "CCS: CPT 85"
 CPTCCS86                     "CCS: CPT 86"
 CPTCCS87                     "CCS: CPT 87"
 CPTCCS88                     "CCS: CPT 88"
 CPTCCS89                     "CCS: CPT 89"
 CPTCCS90                     "CCS: CPT 90"
 CPTCCS91                     "CCS: CPT 91"
 CPTCCS92                     "CCS: CPT 92"
 CPTCCS93                     "CCS: CPT 93"
 CPTCCS94                     "CCS: CPT 94"
 CPTCCS95                     "CCS: CPT 95"
 CPTCCS96                     "CCS: CPT 96"
 CPTCCS97                     "CCS: CPT 97"
 CPTCCS98                     "CCS: CPT 98"
 CPTCCS99                     "CCS: CPT 99"
 CPTCCS100                    "CCS: CPT 100"
 CPTCCS101                    "CCS: CPT 101"
 CPTCCS102                    "CCS: CPT 102"
 CPTCCS103                    "CCS: CPT 103"
 CPTCCS104                    "CCS: CPT 104"
 CPTCCS105                    "CCS: CPT 105"
 CPTCCS106                    "CCS: CPT 106"
 CPTCCS107                    "CCS: CPT 107"
 CPTCCS108                    "CCS: CPT 108"
 CPTCCS109                    "CCS: CPT 109"
 CPTCCS110                    "CCS: CPT 110"
 CPTCCS111                    "CCS: CPT 111"
 CPTCCS112                    "CCS: CPT 112"
 CPTCCS113                    "CCS: CPT 113"
 CPTCCS114                    "CCS: CPT 114"
 CPTCCS115                    "CCS: CPT 115"
 CPTCCS116                    "CCS: CPT 116"
 CPTCCS117                    "CCS: CPT 117"
 CPTCCS118                    "CCS: CPT 118"
 CPTCCS119                    "CCS: CPT 119"
 CPTCCS120                    "CCS: CPT 120"
 CPTCCS121                    "CCS: CPT 121"
 CPTCCS122                    "CCS: CPT 122"
 CPTCCS123                    "CCS: CPT 123"
 CPTCCS124                    "CCS: CPT 124"
 CPTCCS125                    "CCS: CPT 125"
 CPTCCS126                    "CCS: CPT 126"
 CPTCCS127                    "CCS: CPT 127"
 CPTCCS128                    "CCS: CPT 128"
 CPTCCS129                    "CCS: CPT 129"
 CPTCCS130                    "CCS: CPT 130"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD_CPT       "Number of reported CPT procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_NARROW_CPT      "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
 HOSPST                       "Hospital state postal code"
 I10_DX_Visit_Reason1         "ICD-10-CM Reason for visit diagnosis 1"
 I10_DX_Visit_Reason2         "ICD-10-CM Reason for visit diagnosis 2"
 I10_DX_Visit_Reason3         "ICD-10-CM Reason for visit diagnosis 3"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 MDSPEC1                      "Physician 1 specialty (as received from source)"
 MDSPEC2                      "Physician 2 specialty (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 SASD_SEDD                    "SASD and SEDD indicator"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 YEAR                         "Calendar year"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AGEGROUP                     "Age Group"
 AYEAR                        "Admission year" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS101
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS102
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS103
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS104
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS105
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS106
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS107
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS108
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS109
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS110
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS111
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS112
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS113
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS114
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS115
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS116
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS117
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS118
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS119
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS120
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS121
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS122
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS123
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS124
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS125
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS126
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS127
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS128
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS129
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS130
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE SASD_SEDD
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'SC_SASD_2021_CORE.sav' /COMPRESSED.
