/*******************************************************************
*   SC_SASD_2007_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'SC_SASD_2007_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRONB1                   21-  22
 CHRONB2                   23-  24
 CHRONB3                   25-  26
 CHRONB4                   27-  28
 CHRONB5                   29-  30
 CHRONB6                   31-  32
 CHRONB7                   33-  34
 CHRONB8                   35-  36
 CHRONB9                   37-  38
 CHRONB10                  39-  40
 DXMCCS1                   41-  51 (A)
 DXMCCS2                   52-  62 (A)
 DXMCCS3                   63-  73 (A)
 DXMCCS4                   74-  84 (A)
 DXMCCS5                   85-  95 (A)
 DXMCCS6                   96- 106 (A)
 DXMCCS7                  107- 117 (A)
 DXMCCS8                  118- 128 (A)
 DXMCCS9                  129- 139 (A)
 DXMCCS10                 140- 150 (A)
 E_MCCS1                  151- 161 (A)
 E_MCCS2                  162- 172 (A)
 E_MCCS3                  173- 183 (A)
 E_MCCS4                  184- 194 (A)
 E_MCCS5                  195- 205 (A)
 E_MCCS6                  206- 216 (A)
 E_MCCS7                  217- 227 (A)
 KEY                      228- 241
 PCLASS1                  242- 243
 PCLASS2                  244- 245
 PCLASS3                  246- 247
 PCLASS4                  248- 249
 PCLASS5                  250- 251
 PCLASS6                  252- 253
 PCLASS7                  254- 255
 PCLASS8                  256- 257
 PCLASS9                  258- 259
 PCLASS10                 260- 261
 PRMCCS1                  262- 269 (A)
 PRMCCS2                  270- 277 (A)
 PRMCCS3                  278- 285 (A)
 PRMCCS4                  286- 293 (A)
 PRMCCS5                  294- 301 (A)
 PRMCCS6                  302- 309 (A)
 PRMCCS7                  310- 317 (A)
 PRMCCS8                  318- 325 (A)
 PRMCCS9                  326- 333 (A)
 PRMCCS10                 334- 341 (A)
 U_BLOOD                  342- 343
 U_CATH                   344- 345
 U_CCU                    346- 347
 U_CHESTX                 348- 349
 U_CTSCAN                 350- 351
 U_DIALYS                 352- 353
 U_ECHO                   354- 355
 U_ED                     356- 357
 U_EEG                    358- 359
 U_EKG                    360- 361
 U_EPO                    362- 363
 U_ICU                    364- 365
 U_LITHOT                 366- 367
 U_MHSA                   368- 369
 U_MRT                    370- 371
 U_NEWBN2                 372- 373
 U_NEWBN3                 374- 375
 U_NEWBN4                 376- 377
 U_NUCMED                 378- 379
 U_OBSERV                 380- 381
 U_OCCTHE                 382- 383
 U_ORGANA                 384- 385
 U_OTHIMP                 386- 387
 U_PACEMA                 388- 389
 U_PHYTHE                 390- 391
 U_RADTHE                 392- 393
 U_RESPTH                 394- 395
 U_SPEECH                 396- 397
 U_STRESS                 398- 399
 U_ULTRAS                 400- 401.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 KEY                     (F8.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
 PCLASS7                 (F3.0) /
 PCLASS8                 (F3.0) /
 PCLASS9                 (F3.0) /
 PCLASS10                (F3.0) /
 U_BLOOD                 (F3.0) /
 U_CATH                  (F3.0) /
 U_CCU                   (F3.0) /
 U_CHESTX                (F3.0) /
 U_CTSCAN                (F3.0) /
 U_DIALYS                (F3.0) /
 U_ECHO                  (F3.0) /
 U_ED                    (F3.0) /
 U_EEG                   (F3.0) /
 U_EKG                   (F3.0) /
 U_EPO                   (F3.0) /
 U_ICU                   (F3.0) /
 U_LITHOT                (F3.0) /
 U_MHSA                  (F3.0) /
 U_MRT                   (F3.0) /
 U_NEWBN2                (F3.0) /
 U_NEWBN3                (F3.0) /
 U_NEWBN4                (F3.0) /
 U_NUCMED                (F3.0) /
 U_OBSERV                (F3.0) /
 U_OCCTHE                (F3.0) /
 U_ORGANA                (F3.0) /
 U_OTHIMP                (F3.0) /
 U_PACEMA                (F3.0) /
 U_PHYTHE                (F3.0) /
 U_RADTHE                (F3.0) /
 U_RESPTH                (F3.0) /
 U_SPEECH                (F3.0) /
 U_STRESS                (F3.0) /
 U_ULTRAS                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1    "Chronic condition indicator 1"
 CHRON2    "Chronic condition indicator 2"
 CHRON3    "Chronic condition indicator 3"
 CHRON4    "Chronic condition indicator 4"
 CHRON5    "Chronic condition indicator 5"
 CHRON6    "Chronic condition indicator 6"
 CHRON7    "Chronic condition indicator 7"
 CHRON8    "Chronic condition indicator 8"
 CHRON9    "Chronic condition indicator 9"
 CHRON10   "Chronic condition indicator 10"
 CHRONB1   "Chronic condition body system 1"
 CHRONB2   "Chronic condition body system 2"
 CHRONB3   "Chronic condition body system 3"
 CHRONB4   "Chronic condition body system 4"
 CHRONB5   "Chronic condition body system 5"
 CHRONB6   "Chronic condition body system 6"
 CHRONB7   "Chronic condition body system 7"
 CHRONB8   "Chronic condition body system 8"
 CHRONB9   "Chronic condition body system 9"
 CHRONB10  "Chronic condition body system 10"
 DXMCCS1   "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2   "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3   "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4   "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5   "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6   "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7   "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8   "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9   "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10  "Multi-Level CCS:  Diagnosis 10"
 E_MCCS1   "Multi-Level CCS:  E Code 1"
 E_MCCS2   "Multi-Level CCS:  E Code 2"
 E_MCCS3   "Multi-Level CCS:  E Code 3"
 E_MCCS4   "Multi-Level CCS:  E Code 4"
 E_MCCS5   "Multi-Level CCS:  E Code 5"
 E_MCCS6   "Multi-Level CCS:  E Code 6"
 E_MCCS7   "Multi-Level CCS:  E Code 7"
 KEY       "HCUP record identifier"
 PCLASS1   "Procedure class 1"
 PCLASS2   "Procedure class 2"
 PCLASS3   "Procedure class 3"
 PCLASS4   "Procedure class 4"
 PCLASS5   "Procedure class 5"
 PCLASS6   "Procedure class 6"
 PCLASS7   "Procedure class 7"
 PCLASS8   "Procedure class 8"
 PCLASS9   "Procedure class 9"
 PCLASS10  "Procedure class 10"
 PRMCCS1   "Multi-Level CCS:  Procedure 1"
 PRMCCS2   "Multi-Level CCS:  Procedure 2"
 PRMCCS3   "Multi-Level CCS:  Procedure 3"
 PRMCCS4   "Multi-Level CCS:  Procedure 4"
 PRMCCS5   "Multi-Level CCS:  Procedure 5"
 PRMCCS6   "Multi-Level CCS:  Procedure 6"
 PRMCCS7   "Multi-Level CCS:  Procedure 7"
 PRMCCS8   "Multi-Level CCS:  Procedure 8"
 PRMCCS9   "Multi-Level CCS:  Procedure 9"
 PRMCCS10  "Multi-Level CCS:  Procedure 10"
 U_BLOOD   "Utilization Flag: Blood"
 U_CATH    "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU     "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTX  "Utilization Flag: Chest X-Ray"
 U_CTSCAN  "Utilization Flag: Computed Tomography Scan"
 U_DIALYS  "Utilization Flag: Renal Dialysis"
 U_ECHO    "Utilization Flag: Echocardiology"
 U_ED      "Utilization Flag: Emergency Room"
 U_EEG     "Utilization Flag: Electroencephalogram"
 U_EKG     "Utilization Flag: Electrocardiogram"
 U_EPO     "Utilization Flag: EPO"
 U_ICU     "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOT  "Utilization Flag: Lithotripsy"
 U_MHSA    "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT     "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2  "Utilization Flag: Nursery Level II"
 U_NEWBN3  "Utilization Flag: Nursery Level III"
 U_NEWBN4  "Utilization Flag: Nursery Level IV"
 U_NUCMED  "Utilization Flag: Nuclear Medicine"
 U_OBSERV  "Utilization Flag: Observation Room"
 U_OCCTHE  "Utilization Flag: Occupational Therapy"
 U_ORGANA  "Utilization Flag: Organ Acquisition"
 U_OTHIMP  "Utilization Flag: Other Implants"
 U_PACEMA  "Utilization Flag: Pacemaker"
 U_PHYTHE  "Utilization Flag: Physical Therapy"
 U_RADTHE  "Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTH  "Utilization Flag: Respiratory Services"
 U_SPEECH  "Utilization Flag: Speech - Language Pathology"
 U_STRESS  "Utilization Flag: Cardiac Stress Test"
 U_ULTRAS  "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTX
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERV
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMP
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRAS
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'SC_SASD_2007_DX_PR_GRPS.SAV' /COMPRESSED.
