/*******************************************************************
*   OR_SASD_2011_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'OR_SASD_2011_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRONB1                   21-  22
 CHRONB2                   23-  24
 CHRONB3                   25-  26
 CHRONB4                   27-  28
 CHRONB5                   29-  30
 CHRONB6                   31-  32
 CHRONB7                   33-  34
 CHRONB8                   35-  36
 CHRONB9                   37-  38
 CHRONB10                  39-  40
 DXMCCS1                   41-  51 (A)
 DXMCCS2                   52-  62 (A)
 DXMCCS3                   63-  73 (A)
 DXMCCS4                   74-  84 (A)
 DXMCCS5                   85-  95 (A)
 DXMCCS6                   96- 106 (A)
 DXMCCS7                  107- 117 (A)
 DXMCCS8                  118- 128 (A)
 DXMCCS9                  129- 139 (A)
 DXMCCS10                 140- 150 (A)
 E_MCCS1                  151- 161 (A)
 E_MCCS2                  162- 172 (A)
 E_MCCS3                  173- 183 (A)
 E_MCCS4                  184- 194 (A)
 E_MCCS5                  195- 205 (A)
 INJURY                   206- 207
 INJURY_CUT               208- 209
 INJURY_DROWN             210- 211
 INJURY_FALL              212- 213
 INJURY_FIRE              214- 215
 INJURY_FIREARM           216- 217
 INJURY_MACHINERY         218- 219
 INJURY_MVT               220- 221
 INJURY_NATURE            222- 223
 INJURY_POISON            224- 225
 INJURY_STRUCK            226- 227
 INJURY_SUFFOCATION       228- 229
 INTENT_ASSAULT           230- 231
 INTENT_SELF_HARM         232- 233
 INTENT_UNINTENTIONAL     234- 235
 KEY                      236- 253
 MULTINJURY               254- 255.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 INJURY                  (F3.0) /
 INJURY_CUT              (F3.0) /
 INJURY_DROWN            (F3.0) /
 INJURY_FALL             (F3.0) /
 INJURY_FIRE             (F3.0) /
 INJURY_FIREARM          (F3.0) /
 INJURY_MACHINERY        (F3.0) /
 INJURY_MVT              (F3.0) /
 INJURY_NATURE           (F3.0) /
 INJURY_POISON           (F3.0) /
 INJURY_STRUCK           (F3.0) /
 INJURY_SUFFOCATION      (F3.0) /
 INTENT_ASSAULT          (F3.0) /
 INTENT_SELF_HARM        (F3.0) /
 INTENT_UNINTENTIONAL    (F3.0) /
 KEY                     (F8.0) /
 MULTINJURY              (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                  "Chronic condition indicator 1"
 CHRON2                  "Chronic condition indicator 2"
 CHRON3                  "Chronic condition indicator 3"
 CHRON4                  "Chronic condition indicator 4"
 CHRON5                  "Chronic condition indicator 5"
 CHRON6                  "Chronic condition indicator 6"
 CHRON7                  "Chronic condition indicator 7"
 CHRON8                  "Chronic condition indicator 8"
 CHRON9                  "Chronic condition indicator 9"
 CHRON10                 "Chronic condition indicator 10"
 CHRONB1                 "Chronic condition body system 1"
 CHRONB2                 "Chronic condition body system 2"
 CHRONB3                 "Chronic condition body system 3"
 CHRONB4                 "Chronic condition body system 4"
 CHRONB5                 "Chronic condition body system 5"
 CHRONB6                 "Chronic condition body system 6"
 CHRONB7                 "Chronic condition body system 7"
 CHRONB8                 "Chronic condition body system 8"
 CHRONB9                 "Chronic condition body system 9"
 CHRONB10                "Chronic condition body system 10"
 DXMCCS1                 "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                 "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                 "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                 "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                 "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                 "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                 "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                 "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                 "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                "Multi-Level CCS:  Diagnosis 10"
 E_MCCS1                 "Multi-Level CCS:  E Code 1"
 E_MCCS2                 "Multi-Level CCS:  E Code 2"
 E_MCCS3                 "Multi-Level CCS:  E Code 3"
 E_MCCS4                 "Multi-Level CCS:  E Code 4"
 E_MCCS5                 "Multi-Level CCS:  E Code 5"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT              "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN            "Injury by drowning or submersion (by E codes)"
 INJURY_FALL             "Injury by falling (by E codes)"
 INJURY_FIRE             "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM          "Injury by firearm (by E codes)"
 INJURY_MACHINERY        "Injury by machinery (by E codes)"
 INJURY_MVT              "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE           "Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON           "Injury by poison (by E codes)"
 INJURY_STRUCK           "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION      "Injury by suffocation (by E codes)"
 INTENT_ASSAULT          "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL    "Unintentional injury indicated on the record (by E codes)"
 KEY                     "HCUP record identifier"
 MULTINJURY              "More than one injury diagnosis reported on record" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'OR_SASD_2011_DX_PR_GRPS.SAV' /COMPRESSED.
