/*******************************************************************
*   OR_SASD_2010_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'OR_SASD_2010_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRONB1                   21-  22
 CHRONB2                   23-  24
 CHRONB3                   25-  26
 CHRONB4                   27-  28
 CHRONB5                   29-  30
 CHRONB6                   31-  32
 CHRONB7                   33-  34
 CHRONB8                   35-  36
 CHRONB9                   37-  38
 CHRONB10                  39-  40
 DXMCCS1                   41-  51 (A)
 DXMCCS2                   52-  62 (A)
 DXMCCS3                   63-  73 (A)
 DXMCCS4                   74-  84 (A)
 DXMCCS5                   85-  95 (A)
 DXMCCS6                   96- 106 (A)
 DXMCCS7                  107- 117 (A)
 DXMCCS8                  118- 128 (A)
 DXMCCS9                  129- 139 (A)
 DXMCCS10                 140- 150 (A)
 E_MCCS1                  151- 161 (A)
 E_MCCS2                  162- 172 (A)
 E_MCCS3                  173- 183 (A)
 E_MCCS4                  184- 194 (A)
 E_MCCS5                  195- 205 (A)
 E_MCCS6                  206- 216 (A)
 KEY                      217- 231.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 KEY                     (F8.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                  "Chronic condition indicator 1"
 CHRON2                  "Chronic condition indicator 2"
 CHRON3                  "Chronic condition indicator 3"
 CHRON4                  "Chronic condition indicator 4"
 CHRON5                  "Chronic condition indicator 5"
 CHRON6                  "Chronic condition indicator 6"
 CHRON7                  "Chronic condition indicator 7"
 CHRON8                  "Chronic condition indicator 8"
 CHRON9                  "Chronic condition indicator 9"
 CHRON10                 "Chronic condition indicator 10"
 CHRONB1                 "Chronic condition body system 1"
 CHRONB2                 "Chronic condition body system 2"
 CHRONB3                 "Chronic condition body system 3"
 CHRONB4                 "Chronic condition body system 4"
 CHRONB5                 "Chronic condition body system 5"
 CHRONB6                 "Chronic condition body system 6"
 CHRONB7                 "Chronic condition body system 7"
 CHRONB8                 "Chronic condition body system 8"
 CHRONB9                 "Chronic condition body system 9"
 CHRONB10                "Chronic condition body system 10"
 DXMCCS1                 "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                 "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                 "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                 "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                 "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                 "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                 "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                 "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                 "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                "Multi-Level CCS:  Diagnosis 10"
 E_MCCS1                 "Multi-Level CCS:  E Code 1"
 E_MCCS2                 "Multi-Level CCS:  E Code 2"
 E_MCCS3                 "Multi-Level CCS:  E Code 3"
 E_MCCS4                 "Multi-Level CCS:  E Code 4"
 E_MCCS5                 "Multi-Level CCS:  E Code 5"
 E_MCCS6                 "Multi-Level CCS:  E Code 6"
 KEY                     "HCUP record identifier" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'OR_SASD_2010_DX_PR_GRPS.SAV' /COMPRESSED.
