/*******************************************************************
*   NY_SASD_2001_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NY_SASD_2001_CORE.ASC' FIXED / 
 KEY                   1-  14
 AGE                  15-  17
 AGEDAY               18-  20
 AGEMONTH             21-  23
 AMONTH               24-  25
 ANESTH               26-  28
 AWEEKEND             29-  30
 DIED                 31-  32
 DISP_X               33-  34 (A)
 DISPUB92             35-  36
 DISPUNIF             37-  38
 DQTR                 39-  40
 DSHOSPID             41-  53 (A)
 DX1                  54-  58 (A)
 DX2                  59-  63 (A)
 DX3                  64-  68 (A)
 DX4                  69-  73 (A)
 DX5                  74-  78 (A)
 DX6                  79-  83 (A)
 DXCCS1               84-  87
 DXCCS2               88-  91
 DXCCS3               92-  95
 DXCCS4               96-  99
 DXCCS5              100- 103
 DXCCS6              104- 107
 FEMALE              108- 109
 HOSPST              110- 111 (A)
 LOS                 112- 116
 LOS_X               117- 122
 MDNUM2_S            123- 138 (A)
 NDX                 139- 140
 NEOMAT              141- 142
 NPR                 143- 144
 ORTIME              145- 148
 PAY1                149- 150
 PAY1_X              151- 152 (A)
 PR1                 153- 156 (A)
 PR2                 157- 160 (A)
 PR3                 161- 164 (A)
 PR4                 165- 168 (A)
 PR5                 169- 172 (A)
 PR6                 173- 176 (A)
 PRCCS1              177- 179
 PRCCS2              180- 182
 PRCCS3              183- 185
 PRCCS4              186- 188
 PRCCS5              189- 191
 PRCCS6              192- 194
 PSTCO               195- 199
 YEAR                200- 203
 ZIP                 204- 208 (A)
 AYEAR               209- 212
 DMONTH              213- 214
 BMONTH              215- 216
 BYEAR               217- 220.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AMONTH              (F3.0) /
 ANESTH              (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 ORTIME              (F4.0) /
 PAY1                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PSTCO               (F4.0) /
 YEAR                (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 BMONTH              (F3.0) /
 BYEAR               (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ANESTH    "Method of anesthesia"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 FEMALE    "Indicator of sex"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDNUM2_S  "Physician 2 number (synthetic)"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 ORTIME    "Operating room time"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PSTCO     "Patient state/county FIPS code"
 YEAR      "Calendar year"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ANESTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORTIME
 (-999,-888,-666,-555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NY_SASD_2001_CORE.SAV' /COMPRESSED.
