/*******************************************************************
*   NE_SASD_2011_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NE_SASD_2011_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRONB1                   19-  20
 CHRONB2                   21-  22
 CHRONB3                   23-  24
 CHRONB4                   25-  26
 CHRONB5                   27-  28
 CHRONB6                   29-  30
 CHRONB7                   31-  32
 CHRONB8                   33-  34
 CHRONB9                   35-  36
 DXMCCS1                   37-  47 (A)
 DXMCCS2                   48-  58 (A)
 DXMCCS3                   59-  69 (A)
 DXMCCS4                   70-  80 (A)
 DXMCCS5                   81-  91 (A)
 DXMCCS6                   92- 102 (A)
 DXMCCS7                  103- 113 (A)
 DXMCCS8                  114- 124 (A)
 DXMCCS9                  125- 135 (A)
 E_MCCS1                  136- 146 (A)
 E_MCCS2                  147- 157 (A)
 E_MCCS3                  158- 168 (A)
 E_MCCS4                  169- 179 (A)
 E_MCCS5                  180- 190 (A)
 E_MCCS6                  191- 201 (A)
 INJURY                   202- 203
 INJURY_CUT               204- 205
 INJURY_DROWN             206- 207
 INJURY_FALL              208- 209
 INJURY_FIRE              210- 211
 INJURY_FIREARM           212- 213
 INJURY_MACHINERY         214- 215
 INJURY_MVT               216- 217
 INJURY_NATURE            218- 219
 INJURY_POISON            220- 221
 INJURY_STRUCK            222- 223
 INJURY_SUFFOCATION       224- 225
 INTENT_ASSAULT           226- 227
 INTENT_SELF_HARM         228- 229
 INTENT_UNINTENTIONAL     230- 231
 KEY                      232- 249
 MULTINJURY               250- 251
 U_BLOOD                  252- 253
 U_CATH                   254- 255
 U_CCU                    256- 257
 U_CHESTXRAY              258- 259
 U_CTSCAN                 260- 261
 U_DIALYSIS               262- 263
 U_ECHO                   264- 265
 U_ED                     266- 267
 U_EEG                    268- 269
 U_EKG                    270- 271
 U_EPO                    272- 273
 U_ICU                    274- 275
 U_LITHOTRIPSY            276- 277
 U_MHSA                   278- 279
 U_MRT                    280- 281
 U_NEWBN2L                282- 283
 U_NEWBN3L                284- 285
 U_NEWBN4L                286- 287
 U_NUCMED                 288- 289
 U_OBSERVATION            290- 291
 U_OCCTHERAPY             292- 293
 U_ORGANACQ               294- 295
 U_OTHIMPLANTS            296- 297
 U_PACEMAKER              298- 299
 U_PHYTHERAPY             300- 301
 U_RADTHERAPY             302- 303
 U_RESPTHERAPY            304- 305
 U_SPEECHTHERAPY          306- 307
 U_STRESS                 308- 309
 U_ULTRASOUND             310- 311.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 INJURY                  (F3.0) /
 INJURY_CUT              (F3.0) /
 INJURY_DROWN            (F3.0) /
 INJURY_FALL             (F3.0) /
 INJURY_FIRE             (F3.0) /
 INJURY_FIREARM          (F3.0) /
 INJURY_MACHINERY        (F3.0) /
 INJURY_MVT              (F3.0) /
 INJURY_NATURE           (F3.0) /
 INJURY_POISON           (F3.0) /
 INJURY_STRUCK           (F3.0) /
 INJURY_SUFFOCATION      (F3.0) /
 INTENT_ASSAULT          (F3.0) /
 INTENT_SELF_HARM        (F3.0) /
 INTENT_UNINTENTIONAL    (F3.0) /
 KEY                     (F8.0) /
 MULTINJURY              (F3.0) /
 U_BLOOD                 (F3.0) /
 U_CATH                  (F3.0) /
 U_CCU                   (F3.0) /
 U_CHESTXRAY             (F3.0) /
 U_CTSCAN                (F3.0) /
 U_DIALYSIS              (F3.0) /
 U_ECHO                  (F3.0) /
 U_ED                    (F3.0) /
 U_EEG                   (F3.0) /
 U_EKG                   (F3.0) /
 U_EPO                   (F3.0) /
 U_ICU                   (F3.0) /
 U_LITHOTRIPSY           (F3.0) /
 U_MHSA                  (F3.0) /
 U_MRT                   (F3.0) /
 U_NEWBN2L               (F3.0) /
 U_NEWBN3L               (F3.0) /
 U_NEWBN4L               (F3.0) /
 U_NUCMED                (F3.0) /
 U_OBSERVATION           (F3.0) /
 U_OCCTHERAPY            (F3.0) /
 U_ORGANACQ              (F3.0) /
 U_OTHIMPLANTS           (F3.0) /
 U_PACEMAKER             (F3.0) /
 U_PHYTHERAPY            (F3.0) /
 U_RADTHERAPY            (F3.0) /
 U_RESPTHERAPY           (F3.0) /
 U_SPEECHTHERAPY         (F3.0) /
 U_STRESS                (F3.0) /
 U_ULTRASOUND            (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                  "Chronic condition indicator 1"
 CHRON2                  "Chronic condition indicator 2"
 CHRON3                  "Chronic condition indicator 3"
 CHRON4                  "Chronic condition indicator 4"
 CHRON5                  "Chronic condition indicator 5"
 CHRON6                  "Chronic condition indicator 6"
 CHRON7                  "Chronic condition indicator 7"
 CHRON8                  "Chronic condition indicator 8"
 CHRON9                  "Chronic condition indicator 9"
 CHRONB1                 "Chronic condition body system 1"
 CHRONB2                 "Chronic condition body system 2"
 CHRONB3                 "Chronic condition body system 3"
 CHRONB4                 "Chronic condition body system 4"
 CHRONB5                 "Chronic condition body system 5"
 CHRONB6                 "Chronic condition body system 6"
 CHRONB7                 "Chronic condition body system 7"
 CHRONB8                 "Chronic condition body system 8"
 CHRONB9                 "Chronic condition body system 9"
 DXMCCS1                 "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                 "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                 "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                 "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                 "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                 "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                 "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                 "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                 "Multi-Level CCS:  Diagnosis 9"
 E_MCCS1                 "Multi-Level CCS:  E Code 1"
 E_MCCS2                 "Multi-Level CCS:  E Code 2"
 E_MCCS3                 "Multi-Level CCS:  E Code 3"
 E_MCCS4                 "Multi-Level CCS:  E Code 4"
 E_MCCS5                 "Multi-Level CCS:  E Code 5"
 E_MCCS6                 "Multi-Level CCS:  E Code 6"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT              "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN            "Injury by drowning or submersion (by E codes)"
 INJURY_FALL             "Injury by falling (by E codes)"
 INJURY_FIRE             "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM          "Injury by firearm (by E codes)"
 INJURY_MACHINERY        "Injury by machinery (by E codes)"
 INJURY_MVT              "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE           "Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON           "Injury by poison (by E codes)"
 INJURY_STRUCK           "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION      "Injury by suffocation (by E codes)"
 INTENT_ASSAULT          "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL    "Unintentional injury indicated on the record (by E codes)"
 KEY                     "HCUP record identifier"
 MULTINJURY              "More than one injury diagnosis reported on record"
 U_BLOOD                 "Utilization Flag: Blood"
 U_CATH                  "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                   "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY             "Utilization Flag: Chest X-Ray"
 U_CTSCAN                "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS              "Utilization Flag: Renal Dialysis"
 U_ECHO                  "Utilization Flag: Echocardiology"
 U_ED                    "Utilization Flag: Emergency Room"
 U_EEG                   "Utilization Flag: Electroencephalogram"
 U_EKG                   "Utilization Flag: Electrocardiogram"
 U_EPO                   "Utilization Flag: EPO"
 U_ICU                   "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY           "Utilization Flag: Lithotripsy"
 U_MHSA                  "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                   "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2L               "Utilization Flag: Nursery Level II"
 U_NEWBN3L               "Utilization Flag: Nursery Level III"
 U_NEWBN4L               "Utilization Flag: Nursery Level IV"
 U_NUCMED                "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION           "Utilization Flag: Observation Room"
 U_OCCTHERAPY            "Utilization Flag: Occupational Therapy"
 U_ORGANACQ              "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS           "Utilization Flag: Other Implants"
 U_PACEMAKER             "Utilization Flag: Pacemaker"
 U_PHYTHERAPY            "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY           "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY         "Utilization Flag: Speech - Language Pathology"
 U_STRESS                "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND            "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NE_SASD_2011_DX_PR_GRPS.SAV' /COMPRESSED.
