/*******************************************************************
*   NC_SASD_2009_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NC_SASD_2009_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 AWEEKEND                  12-  13
 CPT1                      14-  18 (A)
 CPT2                      19-  23 (A)
 CPT3                      24-  28 (A)
 CPT4                      29-  33 (A)
 CPT5                      34-  38 (A)
 CPT6                      39-  43 (A)
 CPT7                      44-  48 (A)
 CPT8                      49-  53 (A)
 CPT9                      54-  58 (A)
 CPT10                     59-  63 (A)
 CPT11                     64-  68 (A)
 CPT12                     69-  73 (A)
 CPT13                     74-  78 (A)
 CPT14                     79-  83 (A)
 CPT15                     84-  88 (A)
 CPT16                     89-  93 (A)
 CPT17                     94-  98 (A)
 CPT18                     99- 103 (A)
 CPT19                    104- 108 (A)
 CPT20                    109- 113 (A)
 CPTCCS1                  114- 116
 CPTCCS2                  117- 119
 CPTCCS3                  120- 122
 CPTCCS4                  123- 125
 CPTCCS5                  126- 128
 CPTCCS6                  129- 131
 CPTCCS7                  132- 134
 CPTCCS8                  135- 137
 CPTCCS9                  138- 140
 CPTCCS10                 141- 143
 CPTCCS11                 144- 146
 CPTCCS12                 147- 149
 CPTCCS13                 150- 152
 CPTCCS14                 153- 155
 CPTCCS15                 156- 158
 CPTCCS16                 159- 161
 CPTCCS17                 162- 164
 CPTCCS18                 165- 167
 CPTCCS19                 168- 170
 CPTCCS20                 171- 173
 CPTDAY1                  174- 176
 CPTDAY2                  177- 179
 CPTDAY3                  180- 182
 CPTDAY4                  183- 185
 CPTDAY5                  186- 188
 CPTDAY6                  189- 191
 CPTDAY7                  192- 194
 CPTDAY8                  195- 197
 CPTDAY9                  198- 200
 CPTDAY10                 201- 203
 CPTDAY11                 204- 206
 CPTDAY12                 207- 209
 CPTDAY13                 210- 212
 CPTDAY14                 213- 215
 CPTDAY15                 216- 218
 CPTDAY16                 219- 221
 CPTDAY17                 222- 224
 CPTDAY18                 225- 227
 CPTDAY19                 228- 230
 CPTDAY20                 231- 233
 DQTR                     234- 235
 DSHOSPID                 236- 252 (A)
 DX1                      253- 257 (A)
 DX2                      258- 262 (A)
 DX3                      263- 267 (A)
 DX4                      268- 272 (A)
 DX5                      273- 277 (A)
 DX6                      278- 282 (A)
 DX7                      283- 287 (A)
 DX8                      288- 292 (A)
 DX9                      293- 297 (A)
 DX10                     298- 302 (A)
 DX11                     303- 307 (A)
 DX12                     308- 312 (A)
 DX13                     313- 317 (A)
 DX14                     318- 322 (A)
 DX15                     323- 327 (A)
 DX16                     328- 332 (A)
 DX17                     333- 337 (A)
 DX18                     338- 342 (A)
 DX19                     343- 347 (A)
 DX20                     348- 352 (A)
 DX21                     353- 357 (A)
 DX22                     358- 362 (A)
 DX23                     363- 367 (A)
 DX24                     368- 372 (A)
 DX25                     373- 377 (A)
 DX26                     378- 382 (A)
 DX27                     383- 387 (A)
 DX28                     388- 392 (A)
 DX29                     393- 397 (A)
 DX30                     398- 402 (A)
 DX31                     403- 407 (A)
 DX32                     408- 412 (A)
 DX33                     413- 417 (A)
 DXCCS1                   418- 421
 DXCCS2                   422- 425
 DXCCS3                   426- 429
 DXCCS4                   430- 433
 DXCCS5                   434- 437
 DXCCS6                   438- 441
 DXCCS7                   442- 445
 DXCCS8                   446- 449
 DXCCS9                   450- 453
 DXCCS10                  454- 457
 DXCCS11                  458- 461
 DXCCS12                  462- 465
 DXCCS13                  466- 469
 DXCCS14                  470- 473
 DXCCS15                  474- 477
 DXCCS16                  478- 481
 DXCCS17                  482- 485
 DXCCS18                  486- 489
 DXCCS19                  490- 493
 DXCCS20                  494- 497
 DXCCS21                  498- 501
 DXCCS22                  502- 505
 DXCCS23                  506- 509
 DXCCS24                  510- 513
 DXCCS25                  514- 517
 DXCCS26                  518- 521
 DXCCS27                  522- 525
 DXCCS28                  526- 529
 DXCCS29                  530- 533
 DXCCS30                  534- 537
 DXCCS31                  538- 541
 DXCCS32                  542- 545
 DXCCS33                  546- 549
 DaysToEvent              550- 555
 ECODE1                   556- 560 (A)
 ECODE2                   561- 565 (A)
 ECODE3                   566- 570 (A)
 ECODE4                   571- 575 (A)
 ECODE5                   576- 580 (A)
 ECODE6                   581- 585 (A)
 E_CCS1                   586- 589
 E_CCS2                   590- 593
 E_CCS3                   594- 597
 E_CCS4                   598- 601
 E_CCS5                   602- 605
 E_CCS6                   606- 609
 FEMALE                   610- 611
 HCUP_AS                  612- 613
 HCUP_ED                  614- 615
 HCUP_OS                  616- 617
 HOSPBRTH                 618- 620
 HOSPST                   621- 622 (A)
 KEY                      623- 636
 LOS                      637- 641
 LOS_X                    642- 647
 MEDINCSTQ                648- 649
 NCHRONIC                 650- 652
 NCPT                     653- 655
 NDX                      656- 657
 NECODE                   658- 659
 NEOMAT                   660- 661
 NPR                      662- 663
 ORPROC                   664- 665
 PAY1                     666- 667
 PAY1_X                   668     (A)
 PL_CBSA                  669- 671
 PL_MSA1993               672- 674
 PL_NCHS2006              675- 676
 PL_RUCA10_2005           677- 678
 PL_RUCA2005              679- 682
 PL_RUCA4_2005            683- 684
 PL_RUCC2003              685- 686
 PL_UIC2003               687- 688
 PL_UR_CAT4               689- 690
 PNUM_R                   691- 699
 PR1                      700- 703 (A)
 PR2                      704- 707 (A)
 PR3                      708- 711 (A)
 PR4                      712- 715 (A)
 PR5                      716- 719 (A)
 PR6                      720- 723 (A)
 PR7                      724- 727 (A)
 PR8                      728- 731 (A)
 PR9                      732- 735 (A)
 PR10                     736- 739 (A)
 PR11                     740- 743 (A)
 PR12                     744- 747 (A)
 PR13                     748- 751 (A)
 PR14                     752- 755 (A)
 PR15                     756- 759 (A)
 PR16                     760- 763 (A)
 PR17                     764- 767 (A)
 PR18                     768- 771 (A)
 PR19                     772- 775 (A)
 PR20                     776- 779 (A)
 PRCCS1                   780- 782
 PRCCS2                   783- 785
 PRCCS3                   786- 788
 PRCCS4                   789- 791
 PRCCS5                   792- 794
 PRCCS6                   795- 797
 PRCCS7                   798- 800
 PRCCS8                   801- 803
 PRCCS9                   804- 806
 PRCCS10                  807- 809
 PRCCS11                  810- 812
 PRCCS12                  813- 815
 PRCCS13                  816- 818
 PRCCS14                  819- 821
 PRCCS15                  822- 824
 PRCCS16                  825- 827
 PRCCS17                  828- 830
 PRCCS18                  831- 833
 PRCCS19                  834- 836
 PRCCS20                  837- 839
 PRDAY1                   840- 844
 PRDAY2                   845- 849
 PRDAY3                   850- 854
 PRDAY4                   855- 859
 PRDAY5                   860- 864
 PRDAY6                   865- 869
 PRDAY7                   870- 874
 PRDAY8                   875- 879
 PRDAY9                   880- 884
 PRDAY10                  885- 889
 PRDAY11                  890- 894
 PRDAY12                  895- 899
 PRDAY13                  900- 904
 PRDAY14                  905- 909
 PRDAY15                  910- 914
 PRDAY16                  915- 919
 PRDAY17                  920- 924
 PRDAY18                  925- 929
 PRDAY19                  930- 934
 PRDAY20                  935- 939
 PROCTYPE                 940- 942
 PSTATE                   943- 944 (A)
 PSTCO                    945- 949
 PSTCO2                   950- 954
 STATE_AS                 955- 956
 STATE_ED                 957- 958
 STATE_OS                 959- 960
 TOTCHG                   961- 970
 TOTCHG_X                 971- 985
 VisitLink                986- 994
 YEAR                     995- 998
 ZIPINC_QRTL              999-1001
 ZIP                     1002-1006 (A)
 AYEAR                   1007-1010
 DMONTH                  1011-1012
 BMONTH                  1013-1014
 BYEAR                   1015-1018
 PRMONTH1                1019-1020
 PRMONTH2                1021-1022
 PRMONTH3                1023-1024
 PRMONTH4                1025-1026
 PRMONTH5                1027-1028
 PRMONTH6                1029-1030
 PRMONTH7                1031-1032
 PRMONTH8                1033-1034
 PRMONTH9                1035-1036
 PRMONTH10               1037-1038
 PRMONTH11               1039-1040
 PRMONTH12               1041-1042
 PRMONTH13               1043-1044
 PRMONTH14               1045-1046
 PRMONTH15               1047-1048
 PRMONTH16               1049-1050
 PRMONTH17               1051-1052
 PRMONTH18               1053-1054
 PRMONTH19               1055-1056
 PRMONTH20               1057-1058
 PRYEAR1                 1059-1062
 PRYEAR2                 1063-1066
 PRYEAR3                 1067-1070
 PRYEAR4                 1071-1074
 PRYEAR5                 1075-1078
 PRYEAR6                 1079-1082
 PRYEAR7                 1083-1086
 PRYEAR8                 1087-1090
 PRYEAR9                 1091-1094
 PRYEAR10                1095-1098
 PRYEAR11                1099-1102
 PRYEAR12                1103-1106
 PRYEAR13                1107-1110
 PRYEAR14                1111-1114
 PRYEAR15                1115-1118
 PRYEAR16                1119-1122
 PRYEAR17                1123-1126
 PRYEAR18                1127-1130
 PRYEAR19                1131-1134
 PRYEAR20                1135-1138.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTDAY1                 (F4.0) /
 CPTDAY2                 (F4.0) /
 CPTDAY3                 (F4.0) /
 CPTDAY4                 (F4.0) /
 CPTDAY5                 (F4.0) /
 CPTDAY6                 (F4.0) /
 CPTDAY7                 (F4.0) /
 CPTDAY8                 (F4.0) /
 CPTDAY9                 (F4.0) /
 CPTDAY10                (F4.0) /
 CPTDAY11                (F4.0) /
 CPTDAY12                (F4.0) /
 CPTDAY13                (F4.0) /
 CPTDAY14                (F4.0) /
 CPTDAY15                (F4.0) /
 CPTDAY16                (F4.0) /
 CPTDAY17                (F4.0) /
 CPTDAY18                (F4.0) /
 CPTDAY19                (F4.0) /
 CPTDAY20                (F4.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 AWEEKEND                "Admission day is a weekend"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTDAY1                 "Number of days from admission to CPT1"
 CPTDAY2                 "Number of days from admission to CPT2"
 CPTDAY3                 "Number of days from admission to CPT3"
 CPTDAY4                 "Number of days from admission to CPT4"
 CPTDAY5                 "Number of days from admission to CPT5"
 CPTDAY6                 "Number of days from admission to CPT6"
 CPTDAY7                 "Number of days from admission to CPT7"
 CPTDAY8                 "Number of days from admission to CPT8"
 CPTDAY9                 "Number of days from admission to CPT9"
 CPTDAY10                "Number of days from admission to CPT10"
 CPTDAY11                "Number of days from admission to CPT11"
 CPTDAY12                "Number of days from admission to CPT12"
 CPTDAY13                "Number of days from admission to CPT13"
 CPTDAY14                "Number of days from admission to CPT14"
 CPTDAY15                "Number of days from admission to CPT15"
 CPTDAY16                "Number of days from admission to CPT16"
 CPTDAY17                "Number of days from admission to CPT17"
 CPTDAY18                "Number of days from admission to CPT18"
 CPTDAY19                "Number of days from admission to CPT19"
 CPTDAY20                "Number of days from admission to CPT20"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DX31                    "Diagnosis 31"
 DX32                    "Diagnosis 32"
 DX33                    "Diagnosis 33"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 DXCCS31                 "CCS: diagnosis 31"
 DXCCS32                 "CCS: diagnosis 32"
 DXCCS33                 "CCS: diagnosis 33"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 FEMALE                  "Indicator of sex"
 HCUP_AS                 "HCUP Ambulatory Surgery service indicator"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PNUM_R                  "Person number (re-identified)"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NC_SASD_2009_CORE.SAV' /COMPRESSED.
