/*******************************************************************
* Creation Date: 06/16/2016   
*   MI_SASD_2014_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MI_SASD_2014_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 CPT1                           16-  20 (A)
 CPT2                           21-  25 (A)
 CPT3                           26-  30 (A)
 CPT4                           31-  35 (A)
 CPT5                           36-  40 (A)
 CPT6                           41-  45 (A)
 CPT7                           46-  50 (A)
 CPT8                           51-  55 (A)
 CPT9                           56-  60 (A)
 CPT10                          61-  65 (A)
 CPT11                          66-  70 (A)
 CPT12                          71-  75 (A)
 CPT13                          76-  80 (A)
 CPT14                          81-  85 (A)
 CPT15                          86-  90 (A)
 CPT16                          91-  95 (A)
 CPT17                          96- 100 (A)
 CPT18                         101- 105 (A)
 CPT19                         106- 110 (A)
 CPT20                         111- 115 (A)
 CPT21                         116- 120 (A)
 CPT22                         121- 125 (A)
 CPT23                         126- 130 (A)
 CPT24                         131- 135 (A)
 CPT25                         136- 140 (A)
 CPT26                         141- 145 (A)
 CPT27                         146- 150 (A)
 CPTCCS1                       151- 153
 CPTCCS2                       154- 156
 CPTCCS3                       157- 159
 CPTCCS4                       160- 162
 CPTCCS5                       163- 165
 CPTCCS6                       166- 168
 CPTCCS7                       169- 171
 CPTCCS8                       172- 174
 CPTCCS9                       175- 177
 CPTCCS10                      178- 180
 CPTCCS11                      181- 183
 CPTCCS12                      184- 186
 CPTCCS13                      187- 189
 CPTCCS14                      190- 192
 CPTCCS15                      193- 195
 CPTCCS16                      196- 198
 CPTCCS17                      199- 201
 CPTCCS18                      202- 204
 CPTCCS19                      205- 207
 CPTCCS20                      208- 210
 CPTCCS21                      211- 213
 CPTCCS22                      214- 216
 CPTCCS23                      217- 219
 CPTCCS24                      220- 222
 CPTCCS25                      223- 225
 CPTCCS26                      226- 228
 CPTCCS27                      229- 231
 CPTDAY1                       232- 234
 CPTDAY2                       235- 237
 CPTDAY3                       238- 240
 CPTDAY4                       241- 243
 CPTDAY5                       244- 246
 CPTDAY6                       247- 249
 CPTDAY7                       250- 252
 CPTDAY8                       253- 255
 CPTDAY9                       256- 258
 CPTDAY10                      259- 261
 CPTDAY11                      262- 264
 CPTDAY12                      265- 267
 CPTDAY13                      268- 270
 CPTDAY14                      271- 273
 CPTDAY15                      274- 276
 CPTDAY16                      277- 279
 CPTDAY17                      280- 282
 CPTDAY18                      283- 285
 CPTDAY19                      286- 288
 CPTDAY20                      289- 291
 CPTDAY21                      292- 294
 CPTDAY22                      295- 297
 CPTDAY23                      298- 300
 CPTDAY24                      301- 303
 CPTDAY25                      304- 306
 CPTDAY26                      307- 309
 CPTDAY27                      310- 312
 DIED                          313- 314
 DISPUB04                      315- 316
 DISPUNIFORM                   317- 318
 DISP_X                        319- 320 (A)
 DMONTH                        321- 322
 DQTR                          323- 324
 DX1                           325- 331 (A)
 DX2                           332- 338 (A)
 DX3                           339- 345 (A)
 DX4                           346- 352 (A)
 DX5                           353- 359 (A)
 DX6                           360- 366 (A)
 DX7                           367- 373 (A)
 DX8                           374- 380 (A)
 DX9                           381- 387 (A)
 DX10                          388- 394 (A)
 DX11                          395- 401 (A)
 DX12                          402- 408 (A)
 DX13                          409- 415 (A)
 DX14                          416- 422 (A)
 DX15                          423- 429 (A)
 DX16                          430- 436 (A)
 DX17                          437- 443 (A)
 DX18                          444- 450 (A)
 DX19                          451- 457 (A)
 DX20                          458- 464 (A)
 DX21                          465- 471 (A)
 DX22                          472- 478 (A)
 DX23                          479- 485 (A)
 DX24                          486- 492 (A)
 DX25                          493- 499 (A)
 DX26                          500- 506 (A)
 DX27                          507- 513 (A)
 DX28                          514- 520 (A)
 DX29                          521- 527 (A)
 DX30                          528- 534 (A)
 DXCCS1                        535- 538
 DXCCS2                        539- 542
 DXCCS3                        543- 546
 DXCCS4                        547- 550
 DXCCS5                        551- 554
 DXCCS6                        555- 558
 DXCCS7                        559- 562
 DXCCS8                        563- 566
 DXCCS9                        567- 570
 DXCCS10                       571- 574
 DXCCS11                       575- 578
 DXCCS12                       579- 582
 DXCCS13                       583- 586
 DXCCS14                       587- 590
 DXCCS15                       591- 594
 DXCCS16                       595- 598
 DXCCS17                       599- 602
 DXCCS18                       603- 606
 DXCCS19                       607- 610
 DXCCS20                       611- 614
 DXCCS21                       615- 618
 DXCCS22                       619- 622
 DXCCS23                       623- 626
 DXCCS24                       627- 630
 DXCCS25                       631- 634
 DXCCS26                       635- 638
 DXCCS27                       639- 642
 DXCCS28                       643- 646
 DXCCS29                       647- 650
 DXCCS30                       651- 654
 DXVER                         655- 657
 DX_Visit_Reason1              658- 664 (A)
 ECODE1                        665- 671 (A)
 ECODE2                        672- 678 (A)
 ECODE3                        679- 685 (A)
 ECODE4                        686- 692 (A)
 ECODE5                        693- 699 (A)
 ECODE6                        700- 706 (A)
 ECODE7                        707- 713 (A)
 ECODE8                        714- 720 (A)
 E_CCS1                        721- 724
 E_CCS2                        725- 728
 E_CCS3                        729- 732
 E_CCS4                        733- 736
 E_CCS5                        737- 740
 E_CCS6                        741- 744
 E_CCS7                        745- 748
 E_CCS8                        749- 752
 FEMALE                        753- 754
 HCUP_ED                       755- 756
 HCUP_OS                       757- 758
 HISPANIC_X                    759     (A)
 HOSPBRTH                      760- 762
 HOSPST                        763- 764 (A)
 KEY                           765- 779
 LOS                           780- 784
 LOS_X                         785- 790
 MDNUM1_R                      791- 799
 MDNUM2_R                      800- 808
 MEDINCSTQ                     809- 810
 MRN_R                         811- 819
 NCHRONIC                      820- 822
 NCPT                          823- 826
 NDX                           827- 829
 NECODE                        830- 831
 NEOMAT                        832- 833
 NPR                           834- 836
 ORPROC                        837- 838
 PAY1                          839- 840
 PAY1_X                        841- 842 (A)
 PAY2                          843- 844
 PAY2_X                        845- 846 (A)
 PL_CBSA                       847- 849
 PL_NCHS                       850- 851
 PL_RUCC                       852- 853
 PL_UIC                        854- 855
 PL_UR_CAT4                    856- 857
 PR1                           858- 864 (A)
 PR2                           865- 871 (A)
 PR3                           872- 878 (A)
 PR4                           879- 885 (A)
 PR5                           886- 892 (A)
 PR6                           893- 899 (A)
 PR7                           900- 906 (A)
 PR8                           907- 913 (A)
 PR9                           914- 920 (A)
 PR10                          921- 927 (A)
 PR11                          928- 934 (A)
 PR12                          935- 941 (A)
 PR13                          942- 948 (A)
 PR14                          949- 955 (A)
 PR15                          956- 962 (A)
 PR16                          963- 969 (A)
 PR17                          970- 976 (A)
 PR18                          977- 983 (A)
 PR19                          984- 990 (A)
 PR20                          991- 997 (A)
 PR21                          998-1004 (A)
 PR22                         1005-1011 (A)
 PR23                         1012-1018 (A)
 PR24                         1019-1025 (A)
 PR25                         1026-1032 (A)
 PR26                         1033-1039 (A)
 PR27                         1040-1046 (A)
 PR28                         1047-1053 (A)
 PR29                         1054-1060 (A)
 PR30                         1061-1067 (A)
 PRCCS1                       1068-1070
 PRCCS2                       1071-1073
 PRCCS3                       1074-1076
 PRCCS4                       1077-1079
 PRCCS5                       1080-1082
 PRCCS6                       1083-1085
 PRCCS7                       1086-1088
 PRCCS8                       1089-1091
 PRCCS9                       1092-1094
 PRCCS10                      1095-1097
 PRCCS11                      1098-1100
 PRCCS12                      1101-1103
 PRCCS13                      1104-1106
 PRCCS14                      1107-1109
 PRCCS15                      1110-1112
 PRCCS16                      1113-1115
 PRCCS17                      1116-1118
 PRCCS18                      1119-1121
 PRCCS19                      1122-1124
 PRCCS20                      1125-1127
 PRCCS21                      1128-1130
 PRCCS22                      1131-1133
 PRCCS23                      1134-1136
 PRCCS24                      1137-1139
 PRCCS25                      1140-1142
 PRCCS26                      1143-1145
 PRCCS27                      1146-1148
 PRCCS28                      1149-1151
 PRCCS29                      1152-1154
 PRCCS30                      1155-1157
 PRDAY1                       1158-1162
 PROCTYPE                     1163-1165
 PRVER                        1166-1168
 PSTATE                       1169-1170 (A)
 PSTCO2                       1171-1175
 PointOfOriginUB04            1176     (A)
 PointOfOrigin_X              1177     (A)
 RACE                         1178-1179
 RACE_X                       1180     (A)
 STATE_AS                     1181-1182
 STATE_ED                     1183-1184
 STATE_OS                     1185-1186
 TOTCHG                       1187-1196
 TOTCHG_X                     1197-1211
 YEAR                         1212-1215
 ZIP                          1216-1220 (A)
 ZIP3                         1221-1223 (A)
 ZIPINC_QRTL                  1224-1226
 HOSPID                       1227-1231
 AYEAR                        1232-1235
 BMONTH                       1236-1237
 BYEAR                        1238-1241
 PRMONTH1                     1242-1243
 PRYEAR1                      1244-1247.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 CPTDAY22                     (F4.0) /
 CPTDAY23                     (F4.0) /
 CPTDAY24                     (F4.0) /
 CPTDAY25                     (F4.0) /
 CPTDAY26                     (F4.0) /
 CPTDAY27                     (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 DXCCS19                      (F4.0) /
 DXCCS20                      (F4.0) /
 DXCCS21                      (F4.0) /
 DXCCS22                      (F4.0) /
 DXCCS23                      (F4.0) /
 DXCCS24                      (F4.0) /
 DXCCS25                      (F4.0) /
 DXCCS26                      (F4.0) /
 DXCCS27                      (F4.0) /
 DXCCS28                      (F4.0) /
 DXCCS29                      (F4.0) /
 DXCCS30                      (F4.0) /
 DXVER                        (F3.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCHRONIC                     (F3.0) /
 NCPT                         (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRCCS14                      (F3.0) /
 PRCCS15                      (F3.0) /
 PRCCS16                      (F3.0) /
 PRCCS17                      (F3.0) /
 PRCCS18                      (F3.0) /
 PRCCS19                      (F3.0) /
 PRCCS20                      (F3.0) /
 PRCCS21                      (F3.0) /
 PRCCS22                      (F3.0) /
 PRCCS23                      (F3.0) /
 PRCCS24                      (F3.0) /
 PRCCS25                      (F3.0) /
 PRCCS26                      (F3.0) /
 PRCCS27                      (F3.0) /
 PRCCS28                      (F3.0) /
 PRCCS29                      (F3.0) /
 PRCCS30                      (F3.0) /
 PRDAY1                       (F4.0) /
 PROCTYPE                     (F3.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRYEAR1                      (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 CPTDAY22                     "Number of days from admission to CPT22"
 CPTDAY23                     "Number of days from admission to CPT23"
 CPTDAY24                     "Number of days from admission to CPT24"
 CPTDAY25                     "Number of days from admission to CPT25"
 CPTDAY26                     "Number of days from admission to CPT26"
 CPTDAY27                     "Number of days from admission to CPT27"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DX19                         "Diagnosis 19"
 DX20                         "Diagnosis 20"
 DX21                         "Diagnosis 21"
 DX22                         "Diagnosis 22"
 DX23                         "Diagnosis 23"
 DX24                         "Diagnosis 24"
 DX25                         "Diagnosis 25"
 DX26                         "Diagnosis 26"
 DX27                         "Diagnosis 27"
 DX28                         "Diagnosis 28"
 DX29                         "Diagnosis 29"
 DX30                         "Diagnosis 30"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXCCS19                      "CCS: diagnosis 19"
 DXCCS20                      "CCS: diagnosis 20"
 DXCCS21                      "CCS: diagnosis 21"
 DXCCS22                      "CCS: diagnosis 22"
 DXCCS23                      "CCS: diagnosis 23"
 DXCCS24                      "CCS: diagnosis 24"
 DXCCS25                      "CCS: diagnosis 25"
 DXCCS26                      "CCS: diagnosis 26"
 DXCCS27                      "CCS: diagnosis 27"
 DXCCS28                      "CCS: diagnosis 28"
 DXCCS29                      "CCS: diagnosis 29"
 DXCCS30                      "CCS: diagnosis 30"
 DXVER                        "Diagnosis Version"
 DX_Visit_Reason1             "Reason for visit diagnosis 1"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCHRONIC                     "Number of chronic conditions"
 NCPT                         "Number of CPT/HCPCS procedures on this record"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 ORPROC                       "Major operating room procedure indicator"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PR14                         "Procedure 14"
 PR15                         "Procedure 15"
 PR16                         "Procedure 16"
 PR17                         "Procedure 17"
 PR18                         "Procedure 18"
 PR19                         "Procedure 19"
 PR20                         "Procedure 20"
 PR21                         "Procedure 21"
 PR22                         "Procedure 22"
 PR23                         "Procedure 23"
 PR24                         "Procedure 24"
 PR25                         "Procedure 25"
 PR26                         "Procedure 26"
 PR27                         "Procedure 27"
 PR28                         "Procedure 28"
 PR29                         "Procedure 29"
 PR30                         "Procedure 30"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRCCS14                      "CCS: procedure 14"
 PRCCS15                      "CCS: procedure 15"
 PRCCS16                      "CCS: procedure 16"
 PRCCS17                      "CCS: procedure 17"
 PRCCS18                      "CCS: procedure 18"
 PRCCS19                      "CCS: procedure 19"
 PRCCS20                      "CCS: procedure 20"
 PRCCS21                      "CCS: procedure 21"
 PRCCS22                      "CCS: procedure 22"
 PRCCS23                      "CCS: procedure 23"
 PRCCS24                      "CCS: procedure 24"
 PRCCS25                      "CCS: procedure 25"
 PRCCS26                      "CCS: procedure 26"
 PRCCS27                      "CCS: procedure 27"
 PRCCS28                      "CCS: procedure 28"
 PRCCS29                      "CCS: procedure 29"
 PRCCS30                      "CCS: procedure 30"
 PRDAY1                       "Number of days from admission to PR1"
 PROCTYPE                     "Procedure type indicator"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRYEAR1                      "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MI_SASD_2014_CORE.SAV' /COMPRESSED.
