/*******************************************************************
*   MI_SASD_2005_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MI_SASD_2005_CORE.ASC' FIXED / 
 HOSPID                     1-   5
 HOSPST                     6-   7 (A)
 KEY                        8-  21
 AGE                       22-  24
 AGEDAY                    25-  27
 AGEMONTH                  28-  30
 AMONTH                    31-  32
 ASOURCE                   33-  34
 ASOURCE_                  35     (A)
 ASOURCEU                  36     (A)
 ATYPE                     37-  38
 AWEEKEND                  39-  40
 CPT1                      41-  45 (A)
 CPT2                      46-  50 (A)
 CPT3                      51-  55 (A)
 CPT4                      56-  60 (A)
 CPT5                      61-  65 (A)
 CPT6                      66-  70 (A)
 CPT7                      71-  75 (A)
 DIED                      76-  77
 DISP_X                    78-  79 (A)
 DISPUB92                  80-  81
 DISPUNIF                  82-  83
 DQTR                      84-  85
 DX1                       86-  90 (A)
 DX2                       91-  95 (A)
 DX3                       96- 100 (A)
 DX4                      101- 105 (A)
 DX5                      106- 110 (A)
 DX6                      111- 115 (A)
 DX7                      116- 120 (A)
 DX8                      121- 125 (A)
 DX9                      126- 130 (A)
 DX10                     131- 135 (A)
 DX11                     136- 140 (A)
 DX12                     141- 145 (A)
 DX13                     146- 150 (A)
 DX14                     151- 155 (A)
 DX15                     156- 160 (A)
 DX16                     161- 165 (A)
 DX17                     166- 170 (A)
 DX18                     171- 175 (A)
 DX19                     176- 180 (A)
 DX20                     181- 185 (A)
 DX21                     186- 190 (A)
 DX22                     191- 195 (A)
 DX23                     196- 200 (A)
 DX24                     201- 205 (A)
 DX25                     206- 210 (A)
 DX26                     211- 215 (A)
 DX27                     216- 220 (A)
 DX28                     221- 225 (A)
 DX29                     226- 230 (A)
 DX30                     231- 235 (A)
 DX_Visit                 236- 240 (A)
 DXCCS1                   241- 244
 DXCCS2                   245- 248
 DXCCS3                   249- 252
 DXCCS4                   253- 256
 DXCCS5                   257- 260
 DXCCS6                   261- 264
 DXCCS7                   265- 268
 DXCCS8                   269- 272
 DXCCS9                   273- 276
 DXCCS10                  277- 280
 DXCCS11                  281- 284
 DXCCS12                  285- 288
 DXCCS13                  289- 292
 DXCCS14                  293- 296
 DXCCS15                  297- 300
 DXCCS16                  301- 304
 DXCCS17                  305- 308
 DXCCS18                  309- 312
 DXCCS19                  313- 316
 DXCCS20                  317- 320
 DXCCS21                  321- 324
 DXCCS22                  325- 328
 DXCCS23                  329- 332
 DXCCS24                  333- 336
 DXCCS25                  337- 340
 DXCCS26                  341- 344
 DXCCS27                  345- 348
 DXCCS28                  349- 352
 DXCCS29                  353- 356
 DXCCS30                  357- 360
 ECODE1                   361- 365 (A)
 ECODE2                   366- 370 (A)
 ECODE3                   371- 375 (A)
 ECODE4                   376- 380 (A)
 ECODE5                   381- 385 (A)
 ECODE6                   386- 390 (A)
 E_CCS1                   391- 394
 E_CCS2                   395- 398
 E_CCS3                   399- 402
 E_CCS4                   403- 406
 E_CCS5                   407- 410
 E_CCS6                   411- 414
 FEMALE                   415- 416
 HCUP_AS                  417- 418
 HCUP_ED                  419- 420
 HCUP_OS                  421- 422
 HISPANIC                 423     (A)
 LOS                      424- 428
 LOS_X                    429- 434
 MEDINCST                 435- 436
 MDNUM1_R                 437- 445
 MDNUM2_R                 446- 454
 MOMNUM_R                 455- 463
 MRN_R                    464- 472
 NCPT                     473- 475
 NDX                      476- 477
 NECODE                   478- 479
 NEOMAT                   480- 481
 NPR                      482- 483
 PAY1                     484- 485
 PAY2                     486- 487
 PAY1_X                   488- 489 (A)
 PAY2_X                   490- 491 (A)
 PL_CBSA                  492- 494
 PL_MSA19                 495- 497
 PL_NHCS2                 498- 499
 PL_RUCA1                 500- 501
 PL_RUCA2                 502- 505
 PL_RUCA4                 506- 507
 PL_RUCC2                 508- 509
 PL_UIC20                 510- 511
 PL_UR_CA                 512- 513
 PL_UR_CA                 514- 515
 PR1                      516- 519 (A)
 PR2                      520- 523 (A)
 PR3                      524- 527 (A)
 PR4                      528- 531 (A)
 PR5                      532- 535 (A)
 PR6                      536- 539 (A)
 PR7                      540- 543 (A)
 PR8                      544- 547 (A)
 PR9                      548- 551 (A)
 PR10                     552- 555 (A)
 PR11                     556- 559 (A)
 PR12                     560- 563 (A)
 PR13                     564- 567 (A)
 PR14                     568- 571 (A)
 PR15                     572- 575 (A)
 PR16                     576- 579 (A)
 PR17                     580- 583 (A)
 PR18                     584- 587 (A)
 PR19                     588- 591 (A)
 PR20                     592- 595 (A)
 PR21                     596- 599 (A)
 PR22                     600- 603 (A)
 PR23                     604- 607 (A)
 PR24                     608- 611 (A)
 PR25                     612- 615 (A)
 PR26                     616- 619 (A)
 PR27                     620- 623 (A)
 PR28                     624- 627 (A)
 PR29                     628- 631 (A)
 PR30                     632- 635 (A)
 PRCCS1                   636- 638
 PRCCS2                   639- 641
 PRCCS3                   642- 644
 PRCCS4                   645- 647
 PRCCS5                   648- 650
 PRCCS6                   651- 653
 PRCCS7                   654- 656
 PRCCS8                   657- 659
 PRCCS9                   660- 662
 PRCCS10                  663- 665
 PRCCS11                  666- 668
 PRCCS12                  669- 671
 PRCCS13                  672- 674
 PRCCS14                  675- 677
 PRCCS15                  678- 680
 PRCCS16                  681- 683
 PRCCS17                  684- 686
 PRCCS18                  687- 689
 PRCCS19                  690- 692
 PRCCS20                  693- 695
 PRCCS21                  696- 698
 PRCCS22                  699- 701
 PRCCS23                  702- 704
 PRCCS24                  705- 707
 PRCCS25                  708- 710
 PRCCS26                  711- 713
 PRCCS27                  714- 716
 PRCCS28                  717- 719
 PRCCS29                  720- 722
 PRCCS30                  723- 725
 PRDAY1                   726- 730
 PSTATE                   731- 732 (A)
 PSTCO2                   733- 737
 RACE                     738- 739
 RACE_X                   740     (A)
 STATE_AS                 741- 742
 STATE_ED                 743- 744
 STATE_OS                 745- 746
 TOTCHG                   747- 756
 TOTCHG_X                 757- 771
 YEAR                     772- 775
 ZIP                      776- 780 (A)
 AYEAR                    781- 784
 DMONTH                   785- 786
 BMONTH                   787- 788
 BYEAR                    789- 792
 PRMNTH1                  793- 794
 PRYEAR1                  795- 798.


***  Specify write formats  ***.
FORMATS
 HOSPID                  (F4.0) /
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCST                (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MOMNUM_R                (F5.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NHCS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRDAY1                  (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 HOSPID    "HCUP hospital identification number"
 HOSPST    "Hospital state postal code"
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DX_Visit  "Reason for visit diagnosis"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MOMNUM_R  "Mother's number (re-identified)"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NHCS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PR26      "Procedure 26"
 PR27      "Procedure 27"
 PR28      "Procedure 28"
 PR29      "Procedure 29"
 PR30      "Procedure 30"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRCCS26   "CCS: procedure 26"
 PRCCS27   "CCS: procedure 27"
 PRCCS28   "CCS: procedure 28"
 PRCCS29   "CCS: procedure 29"
 PRCCS30   "CCS: procedure 30"
 PRDAY1    "Number of days from admission to PR1"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MOMNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NHCS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MI_SASD_2005_CORE.SAV' /COMPRESSED.
