/*******************************************************************
*   MD_SASD_2004_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SASD_2004_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEDAY                    18-  20
 AGEMONTH                  21-  23
 ASOURCE                   24-  25
 ASOURCE_                  26-  27 (A)
 ATYPE                     28-  29
 AWEEKEND                  30-  31
 CPT1                      32-  36 (A)
 CPT2                      37-  41 (A)
 CPT3                      42-  46 (A)
 CPT4                      47-  51 (A)
 CPT5                      52-  56 (A)
 CPT6                      57-  61 (A)
 CPT7                      62-  66 (A)
 CPT8                      67-  71 (A)
 CPT9                      72-  76 (A)
 CPT10                     77-  81 (A)
 CPT11                     82-  86 (A)
 CPT12                     87-  91 (A)
 CPT13                     92-  96 (A)
 CPT14                     97- 101 (A)
 CPT15                    102- 106 (A)
 CPT16                    107- 111 (A)
 CPT17                    112- 116 (A)
 CPT18                    117- 121 (A)
 CPT19                    122- 126 (A)
 CPT20                    127- 131 (A)
 CPT21                    132- 136 (A)
 CPT22                    137- 141 (A)
 CPT23                    142- 146 (A)
 CPT24                    147- 151 (A)
 CPT25                    152- 156 (A)
 CPT26                    157- 161 (A)
 CPT27                    162- 166 (A)
 CPT28                    167- 171 (A)
 CPT29                    172- 176 (A)
 CPT30                    177- 181 (A)
 CPT31                    182- 186 (A)
 CPT32                    187- 191 (A)
 CPT33                    192- 196 (A)
 CPT34                    197- 201 (A)
 CPT35                    202- 206 (A)
 CPT36                    207- 211 (A)
 CPT37                    212- 216 (A)
 CPT38                    217- 221 (A)
 CPT39                    222- 226 (A)
 CPT40                    227- 231 (A)
 CPT41                    232- 236 (A)
 CPT42                    237- 241 (A)
 CPT43                    242- 246 (A)
 CPT44                    247- 251 (A)
 CPT45                    252- 256 (A)
 CPT46                    257- 261 (A)
 CPT47                    262- 266 (A)
 CPT48                    267- 271 (A)
 CPT49                    272- 276 (A)
 CPT50                    277- 281 (A)
 CPT51                    282- 286 (A)
 CPT52                    287- 291 (A)
 CPT53                    292- 296 (A)
 CPT54                    297- 301 (A)
 CPT55                    302- 306 (A)
 CPT56                    307- 311 (A)
 CPT57                    312- 316 (A)
 CPT58                    317- 321 (A)
 CPT59                    322- 326 (A)
 CPT60                    327- 331 (A)
 CPT61                    332- 336 (A)
 CPT62                    337- 341 (A)
 CPT63                    342- 346 (A)
 CPT64                    347- 351 (A)
 CPT65                    352- 356 (A)
 CPT66                    357- 361 (A)
 CPT67                    362- 366 (A)
 CPT68                    367- 371 (A)
 CPT69                    372- 376 (A)
 CPT70                    377- 381 (A)
 CPT71                    382- 386 (A)
 CPT72                    387- 391 (A)
 CPT73                    392- 396 (A)
 CPT74                    397- 401 (A)
 CPT75                    402- 406 (A)
 CPT76                    407- 411 (A)
 CPT77                    412- 416 (A)
 CPT78                    417- 421 (A)
 CPT79                    422- 426 (A)
 CPT80                    427- 431 (A)
 CPT81                    432- 436 (A)
 CPT82                    437- 441 (A)
 CPT83                    442- 446 (A)
 CPT84                    447- 451 (A)
 CPT85                    452- 456 (A)
 CPT86                    457- 461 (A)
 CPT87                    462- 466 (A)
 CPT88                    467- 471 (A)
 CPT89                    472- 476 (A)
 CPT90                    477- 481 (A)
 CPT91                    482- 486 (A)
 CPT92                    487- 491 (A)
 CPT93                    492- 496 (A)
 CPT94                    497- 501 (A)
 CPT95                    502- 506 (A)
 CPT96                    507- 511 (A)
 CPT97                    512- 516 (A)
 CPT98                    517- 521 (A)
 CPT99                    522- 526 (A)
 CPT100                   527- 531 (A)
 DIED                     532- 533
 DISP_X                   534- 535 (A)
 DISPUB92                 536- 537
 DISPUNIF                 538- 539
 DQTR                     540- 541
 DSHOSPID                 542- 554 (A)
 DX1                      555- 559 (A)
 DX2                      560- 564 (A)
 DX3                      565- 569 (A)
 DX4                      570- 574 (A)
 DX5                      575- 579 (A)
 DX6                      580- 584 (A)
 DX7                      585- 589 (A)
 DX8                      590- 594 (A)
 DX9                      595- 599 (A)
 DX10                     600- 604 (A)
 DX11                     605- 609 (A)
 DX12                     610- 614 (A)
 DX13                     615- 619 (A)
 DX14                     620- 624 (A)
 DX15                     625- 629 (A)
 DX16                     630- 634 (A)
 DX_Visit                 635- 639 (A)
 DXCCS1                   640- 643
 DXCCS2                   644- 647
 DXCCS3                   648- 651
 DXCCS4                   652- 655
 DXCCS5                   656- 659
 DXCCS6                   660- 663
 DXCCS7                   664- 667
 DXCCS8                   668- 671
 DXCCS9                   672- 675
 DXCCS10                  676- 679
 DXCCS11                  680- 683
 DXCCS12                  684- 687
 DXCCS13                  688- 691
 DXCCS14                  692- 695
 DXCCS15                  696- 699
 DXCCS16                  700- 703
 ECODE1                   704- 708 (A)
 ECODE2                   709- 713 (A)
 ECODE3                   714- 718 (A)
 ECODE4                   719- 723 (A)
 ECODE5                   724- 728 (A)
 ECODE6                   729- 733 (A)
 E_CCS1                   734- 737
 E_CCS2                   738- 741
 E_CCS3                   742- 745
 E_CCS4                   746- 749
 E_CCS5                   750- 753
 E_CCS6                   754- 757
 FEMALE                   758- 759
 HCUP_AS                  760- 761
 HCUP_ED                  762- 763
 HCUP_OS                  764- 765
 HISPANIC                 766     (A)
 HOSPST                   767- 768 (A)
 LOS                      769- 773
 LOS_X                    774- 779
 MARITALS                 780     (A)
 MDNUM1_R                 781- 789
 MRN_R                    790- 798
 NCPT                     799- 801
 NDX                      802- 803
 NECODE                   804- 805
 NEOMAT                   806- 807
 PAY1                     808- 809
 PAY2                     810- 811
 PAY1_X                   812- 813 (A)
 PAY2_X                   814- 815 (A)
 PAYER1_X                 816- 817 (A)
 PAYER2_X                 818- 819 (A)
 PL_CBSA                  820- 822
 PL_MSA19                 823- 825
 PL_RUCA4                 826- 827
 PL_RUCC2                 828- 829
 PL_UIC20                 830- 831
 PL_UR_CA                 832- 833
 PL_UR_CA                 834- 835
 PSTATE                   836- 837 (A)
 PSTCO                    838- 842
 PSTCO2                   843- 847
 RACE                     848- 849
 RACE_X                   850     (A)
 STATE_AS                 851- 852
 STATE_ED                 853- 854
 STATE_OS                 855- 856
 TOTCHG                   857- 866
 TOTCHG_X                 867- 881
 YEAR                     882- 885
 ZIP3                     886- 888 (A)
 APG1                     889- 892
 APG2                     893- 896
 APG3                     897- 900
 APG4                     901- 904
 APG5                     905- 908
 APG6                     909- 912
 APG7                     913- 916
 APG8                     917- 920
 APG9                     921- 924
 APG10                    925- 928
 APG11                    929- 932
 APG12                    933- 936
 APG13                    937- 940
 APG14                    941- 944
 APG15                    945- 948
 APG16                    949- 952
 APG17                    953- 956
 APG18                    957- 960
 APG19                    961- 964
 APG20                    965- 968
 APG21                    969- 972
 APG22                    973- 976
 APG23                    977- 980
 APG24                    981- 984
 APG25                    985- 988
 APG26                    989- 992
 APG27                    993- 996
 APG28                    997-1000
 APG29                   1001-1004
 APG30                   1005-1008
 APG31                   1009-1012
 APG32                   1013-1016
 APG33                   1017-1020
 APG34                   1021-1024
 APG35                   1025-1028
 APG36                   1029-1032
 APG37                   1033-1036
 APG38                   1037-1040
 APG39                   1041-1044
 APG40                   1045-1048
 APG41                   1049-1052
 APG42                   1053-1056
 APG43                   1057-1060
 APG44                   1061-1064
 APG45                   1065-1068
 APG46                   1069-1072
 APG47                   1073-1076
 APG48                   1077-1080
 APG49                   1081-1084
 APG50                   1085-1088
 APG51                   1089-1092
 APG52                   1093-1096
 APG53                   1097-1100
 APG54                   1101-1104
 APG55                   1105-1108
 APG56                   1109-1112
 APG57                   1113-1116
 APG58                   1117-1120
 APG59                   1121-1124
 APG60                   1125-1128
 APG61                   1129-1132
 APG62                   1133-1136
 APG63                   1137-1140
 APG64                   1141-1144
 APG65                   1145-1148
 APG66                   1149-1152
 APG67                   1153-1156
 APG68                   1157-1160
 APG69                   1161-1164
 APG70                   1165-1168
 APG71                   1169-1172
 APG72                   1173-1176
 APG73                   1177-1180
 APG74                   1181-1184
 APG75                   1185-1188
 APG76                   1189-1192
 APG77                   1193-1196
 APG78                   1197-1200
 APG79                   1201-1204
 APG80                   1205-1208
 APG81                   1209-1212
 APG82                   1213-1216
 APG83                   1217-1220
 APG84                   1221-1224
 APG85                   1225-1228
 APG86                   1229-1232
 APG87                   1233-1236
 APG88                   1237-1240
 APG89                   1241-1244
 APG90                   1245-1248
 APG91                   1249-1252
 APG92                   1253-1256
 APG93                   1257-1260
 APG94                   1261-1264
 APG95                   1265-1268
 APG96                   1269-1272
 APG97                   1273-1276
 APG98                   1277-1280
 APG99                   1281-1284
 APG100                  1285-1288.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDNUM1_R                (F5.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 APG1                    (F3.0) /
 APG2                    (F3.0) /
 APG3                    (F3.0) /
 APG4                    (F3.0) /
 APG5                    (F3.0) /
 APG6                    (F3.0) /
 APG7                    (F3.0) /
 APG8                    (F3.0) /
 APG9                    (F3.0) /
 APG10                   (F3.0) /
 APG11                   (F3.0) /
 APG12                   (F3.0) /
 APG13                   (F3.0) /
 APG14                   (F3.0) /
 APG15                   (F3.0) /
 APG16                   (F3.0) /
 APG17                   (F3.0) /
 APG18                   (F3.0) /
 APG19                   (F3.0) /
 APG20                   (F3.0) /
 APG21                   (F3.0) /
 APG22                   (F3.0) /
 APG23                   (F3.0) /
 APG24                   (F3.0) /
 APG25                   (F3.0) /
 APG26                   (F3.0) /
 APG27                   (F3.0) /
 APG28                   (F3.0) /
 APG29                   (F3.0) /
 APG30                   (F3.0) /
 APG31                   (F3.0) /
 APG32                   (F3.0) /
 APG33                   (F3.0) /
 APG34                   (F3.0) /
 APG35                   (F3.0) /
 APG36                   (F3.0) /
 APG37                   (F3.0) /
 APG38                   (F3.0) /
 APG39                   (F3.0) /
 APG40                   (F3.0) /
 APG41                   (F3.0) /
 APG42                   (F3.0) /
 APG43                   (F3.0) /
 APG44                   (F3.0) /
 APG45                   (F3.0) /
 APG46                   (F3.0) /
 APG47                   (F3.0) /
 APG48                   (F3.0) /
 APG49                   (F3.0) /
 APG50                   (F3.0) /
 APG51                   (F3.0) /
 APG52                   (F3.0) /
 APG53                   (F3.0) /
 APG54                   (F3.0) /
 APG55                   (F3.0) /
 APG56                   (F3.0) /
 APG57                   (F3.0) /
 APG58                   (F3.0) /
 APG59                   (F3.0) /
 APG60                   (F3.0) /
 APG61                   (F3.0) /
 APG62                   (F3.0) /
 APG63                   (F3.0) /
 APG64                   (F3.0) /
 APG65                   (F3.0) /
 APG66                   (F3.0) /
 APG67                   (F3.0) /
 APG68                   (F3.0) /
 APG69                   (F3.0) /
 APG70                   (F3.0) /
 APG71                   (F3.0) /
 APG72                   (F3.0) /
 APG73                   (F3.0) /
 APG74                   (F3.0) /
 APG75                   (F3.0) /
 APG76                   (F3.0) /
 APG77                   (F3.0) /
 APG78                   (F3.0) /
 APG79                   (F3.0) /
 APG80                   (F3.0) /
 APG81                   (F3.0) /
 APG82                   (F3.0) /
 APG83                   (F3.0) /
 APG84                   (F3.0) /
 APG85                   (F3.0) /
 APG86                   (F3.0) /
 APG87                   (F3.0) /
 APG88                   (F3.0) /
 APG89                   (F3.0) /
 APG90                   (F3.0) /
 APG91                   (F3.0) /
 APG92                   (F3.0) /
 APG93                   (F3.0) /
 APG94                   (F3.0) /
 APG95                   (F3.0) /
 APG96                   (F3.0) /
 APG97                   (F3.0) /
 APG98                   (F3.0) /
 APG99                   (F3.0) /
 APG100                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPT31     "CPT/HCPCS procedure code 31"
 CPT32     "CPT/HCPCS procedure code 32"
 CPT33     "CPT/HCPCS procedure code 33"
 CPT34     "CPT/HCPCS procedure code 34"
 CPT35     "CPT/HCPCS procedure code 35"
 CPT36     "CPT/HCPCS procedure code 36"
 CPT37     "CPT/HCPCS procedure code 37"
 CPT38     "CPT/HCPCS procedure code 38"
 CPT39     "CPT/HCPCS procedure code 39"
 CPT40     "CPT/HCPCS procedure code 40"
 CPT41     "CPT/HCPCS procedure code 41"
 CPT42     "CPT/HCPCS procedure code 42"
 CPT43     "CPT/HCPCS procedure code 43"
 CPT44     "CPT/HCPCS procedure code 44"
 CPT45     "CPT/HCPCS procedure code 45"
 CPT46     "CPT/HCPCS procedure code 46"
 CPT47     "CPT/HCPCS procedure code 47"
 CPT48     "CPT/HCPCS procedure code 48"
 CPT49     "CPT/HCPCS procedure code 49"
 CPT50     "CPT/HCPCS procedure code 50"
 CPT51     "CPT/HCPCS procedure code 51"
 CPT52     "CPT/HCPCS procedure code 52"
 CPT53     "CPT/HCPCS procedure code 53"
 CPT54     "CPT/HCPCS procedure code 54"
 CPT55     "CPT/HCPCS procedure code 55"
 CPT56     "CPT/HCPCS procedure code 56"
 CPT57     "CPT/HCPCS procedure code 57"
 CPT58     "CPT/HCPCS procedure code 58"
 CPT59     "CPT/HCPCS procedure code 59"
 CPT60     "CPT/HCPCS procedure code 60"
 CPT61     "CPT/HCPCS procedure code 61"
 CPT62     "CPT/HCPCS procedure code 62"
 CPT63     "CPT/HCPCS procedure code 63"
 CPT64     "CPT/HCPCS procedure code 64"
 CPT65     "CPT/HCPCS procedure code 65"
 CPT66     "CPT/HCPCS procedure code 66"
 CPT67     "CPT/HCPCS procedure code 67"
 CPT68     "CPT/HCPCS procedure code 68"
 CPT69     "CPT/HCPCS procedure code 69"
 CPT70     "CPT/HCPCS procedure code 70"
 CPT71     "CPT/HCPCS procedure code 71"
 CPT72     "CPT/HCPCS procedure code 72"
 CPT73     "CPT/HCPCS procedure code 73"
 CPT74     "CPT/HCPCS procedure code 74"
 CPT75     "CPT/HCPCS procedure code 75"
 CPT76     "CPT/HCPCS procedure code 76"
 CPT77     "CPT/HCPCS procedure code 77"
 CPT78     "CPT/HCPCS procedure code 78"
 CPT79     "CPT/HCPCS procedure code 79"
 CPT80     "CPT/HCPCS procedure code 80"
 CPT81     "CPT/HCPCS procedure code 81"
 CPT82     "CPT/HCPCS procedure code 82"
 CPT83     "CPT/HCPCS procedure code 83"
 CPT84     "CPT/HCPCS procedure code 84"
 CPT85     "CPT/HCPCS procedure code 85"
 CPT86     "CPT/HCPCS procedure code 86"
 CPT87     "CPT/HCPCS procedure code 87"
 CPT88     "CPT/HCPCS procedure code 88"
 CPT89     "CPT/HCPCS procedure code 89"
 CPT90     "CPT/HCPCS procedure code 90"
 CPT91     "CPT/HCPCS procedure code 91"
 CPT92     "CPT/HCPCS procedure code 92"
 CPT93     "CPT/HCPCS procedure code 93"
 CPT94     "CPT/HCPCS procedure code 94"
 CPT95     "CPT/HCPCS procedure code 95"
 CPT96     "CPT/HCPCS procedure code 96"
 CPT97     "CPT/HCPCS procedure code 97"
 CPT98     "CPT/HCPCS procedure code 98"
 CPT99     "CPT/HCPCS procedure code 99"
 CPT100    "CPT/HCPCS procedure code 100"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX_Visit  "Reason for visit diagnosis"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MARITALS  "Patient's marital status"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PAYER1_X  "Primary expected payer plan identifier (as received from source)"
 PAYER2_X  "Secondary expected payer plan identifier (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 APG1      "Ambulatory Patient Group 1 (as received from source)"
 APG2      "Ambulatory Patient Group 2 (as received from source)"
 APG3      "Ambulatory Patient Group 3 (as received from source)"
 APG4      "Ambulatory Patient Group 4 (as received from source)"
 APG5      "Ambulatory Patient Group 5 (as received from source)"
 APG6      "Ambulatory Patient Group 6 (as received from source)"
 APG7      "Ambulatory Patient Group 7 (as received from source)"
 APG8      "Ambulatory Patient Group 8 (as received from source)"
 APG9      "Ambulatory Patient Group 9 (as received from source)"
 APG10     "Ambulatory Patient Group 10 (as received from source)"
 APG11     "Ambulatory Patient Group 11 (as received from source)"
 APG12     "Ambulatory Patient Group 12 (as received from source)"
 APG13     "Ambulatory Patient Group 13 (as received from source)"
 APG14     "Ambulatory Patient Group 14 (as received from source)"
 APG15     "Ambulatory Patient Group 15 (as received from source)"
 APG16     "Ambulatory Patient Group 16 (as received from source)"
 APG17     "Ambulatory Patient Group 17 (as received from source)"
 APG18     "Ambulatory Patient Group 18 (as received from source)"
 APG19     "Ambulatory Patient Group 19 (as received from source)"
 APG20     "Ambulatory Patient Group 20 (as received from source)"
 APG21     "Ambulatory Patient Group 21 (as received from source)"
 APG22     "Ambulatory Patient Group 22 (as received from source)"
 APG23     "Ambulatory Patient Group 23 (as received from source)"
 APG24     "Ambulatory Patient Group 24 (as received from source)"
 APG25     "Ambulatory Patient Group 25 (as received from source)"
 APG26     "Ambulatory Patient Group 26 (as received from source)"
 APG27     "Ambulatory Patient Group 27 (as received from source)"
 APG28     "Ambulatory Patient Group 28 (as received from source)"
 APG29     "Ambulatory Patient Group 29 (as received from source)"
 APG30     "Ambulatory Patient Group 30 (as received from source)"
 APG31     "Ambulatory Patient Group 31 (as received from source)"
 APG32     "Ambulatory Patient Group 32 (as received from source)"
 APG33     "Ambulatory Patient Group 33 (as received from source)"
 APG34     "Ambulatory Patient Group 34 (as received from source)"
 APG35     "Ambulatory Patient Group 35 (as received from source)"
 APG36     "Ambulatory Patient Group 36 (as received from source)"
 APG37     "Ambulatory Patient Group 37 (as received from source)"
 APG38     "Ambulatory Patient Group 38 (as received from source)"
 APG39     "Ambulatory Patient Group 39 (as received from source)"
 APG40     "Ambulatory Patient Group 40 (as received from source)"
 APG41     "Ambulatory Patient Group 41 (as received from source)"
 APG42     "Ambulatory Patient Group 42 (as received from source)"
 APG43     "Ambulatory Patient Group 43 (as received from source)"
 APG44     "Ambulatory Patient Group 44 (as received from source)"
 APG45     "Ambulatory Patient Group 45 (as received from source)"
 APG46     "Ambulatory Patient Group 46 (as received from source)"
 APG47     "Ambulatory Patient Group 47 (as received from source)"
 APG48     "Ambulatory Patient Group 48 (as received from source)"
 APG49     "Ambulatory Patient Group 49 (as received from source)"
 APG50     "Ambulatory Patient Group 50 (as received from source)"
 APG51     "Ambulatory Patient Group 51 (as received from source)"
 APG52     "Ambulatory Patient Group 52 (as received from source)"
 APG53     "Ambulatory Patient Group 53 (as received from source)"
 APG54     "Ambulatory Patient Group 54 (as received from source)"
 APG55     "Ambulatory Patient Group 55 (as received from source)"
 APG56     "Ambulatory Patient Group 56 (as received from source)"
 APG57     "Ambulatory Patient Group 57 (as received from source)"
 APG58     "Ambulatory Patient Group 58 (as received from source)"
 APG59     "Ambulatory Patient Group 59 (as received from source)"
 APG60     "Ambulatory Patient Group 60 (as received from source)"
 APG61     "Ambulatory Patient Group 61 (as received from source)"
 APG62     "Ambulatory Patient Group 62 (as received from source)"
 APG63     "Ambulatory Patient Group 63 (as received from source)"
 APG64     "Ambulatory Patient Group 64 (as received from source)"
 APG65     "Ambulatory Patient Group 65 (as received from source)"
 APG66     "Ambulatory Patient Group 66 (as received from source)"
 APG67     "Ambulatory Patient Group 67 (as received from source)"
 APG68     "Ambulatory Patient Group 68 (as received from source)"
 APG69     "Ambulatory Patient Group 69 (as received from source)"
 APG70     "Ambulatory Patient Group 70 (as received from source)"
 APG71     "Ambulatory Patient Group 71 (as received from source)"
 APG72     "Ambulatory Patient Group 72 (as received from source)"
 APG73     "Ambulatory Patient Group 73 (as received from source)"
 APG74     "Ambulatory Patient Group 74 (as received from source)"
 APG75     "Ambulatory Patient Group 75 (as received from source)"
 APG76     "Ambulatory Patient Group 76 (as received from source)"
 APG77     "Ambulatory Patient Group 77 (as received from source)"
 APG78     "Ambulatory Patient Group 78 (as received from source)"
 APG79     "Ambulatory Patient Group 79 (as received from source)"
 APG80     "Ambulatory Patient Group 80 (as received from source)"
 APG81     "Ambulatory Patient Group 81 (as received from source)"
 APG82     "Ambulatory Patient Group 82 (as received from source)"
 APG83     "Ambulatory Patient Group 83 (as received from source)"
 APG84     "Ambulatory Patient Group 84 (as received from source)"
 APG85     "Ambulatory Patient Group 85 (as received from source)"
 APG86     "Ambulatory Patient Group 86 (as received from source)"
 APG87     "Ambulatory Patient Group 87 (as received from source)"
 APG88     "Ambulatory Patient Group 88 (as received from source)"
 APG89     "Ambulatory Patient Group 89 (as received from source)"
 APG90     "Ambulatory Patient Group 90 (as received from source)"
 APG91     "Ambulatory Patient Group 91 (as received from source)"
 APG92     "Ambulatory Patient Group 92 (as received from source)"
 APG93     "Ambulatory Patient Group 93 (as received from source)"
 APG94     "Ambulatory Patient Group 94 (as received from source)"
 APG95     "Ambulatory Patient Group 95 (as received from source)"
 APG96     "Ambulatory Patient Group 96 (as received from source)"
 APG97     "Ambulatory Patient Group 97 (as received from source)"
 APG98     "Ambulatory Patient Group 98 (as received from source)"
 APG99     "Ambulatory Patient Group 99 (as received from source)"
 APG100    "Ambulatory Patient Group 100 (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE APG1
 (-999,-888,-666,-555=SYSMIS).
RECODE APG2
 (-999,-888,-666,-555=SYSMIS).
RECODE APG3
 (-999,-888,-666,-555=SYSMIS).
RECODE APG4
 (-999,-888,-666,-555=SYSMIS).
RECODE APG5
 (-999,-888,-666,-555=SYSMIS).
RECODE APG6
 (-999,-888,-666,-555=SYSMIS).
RECODE APG7
 (-999,-888,-666,-555=SYSMIS).
RECODE APG8
 (-999,-888,-666,-555=SYSMIS).
RECODE APG9
 (-999,-888,-666,-555=SYSMIS).
RECODE APG10
 (-999,-888,-666,-555=SYSMIS).
RECODE APG11
 (-999,-888,-666,-555=SYSMIS).
RECODE APG12
 (-999,-888,-666,-555=SYSMIS).
RECODE APG13
 (-999,-888,-666,-555=SYSMIS).
RECODE APG14
 (-999,-888,-666,-555=SYSMIS).
RECODE APG15
 (-999,-888,-666,-555=SYSMIS).
RECODE APG16
 (-999,-888,-666,-555=SYSMIS).
RECODE APG17
 (-999,-888,-666,-555=SYSMIS).
RECODE APG18
 (-999,-888,-666,-555=SYSMIS).
RECODE APG19
 (-999,-888,-666,-555=SYSMIS).
RECODE APG20
 (-999,-888,-666,-555=SYSMIS).
RECODE APG21
 (-999,-888,-666,-555=SYSMIS).
RECODE APG22
 (-999,-888,-666,-555=SYSMIS).
RECODE APG23
 (-999,-888,-666,-555=SYSMIS).
RECODE APG24
 (-999,-888,-666,-555=SYSMIS).
RECODE APG25
 (-999,-888,-666,-555=SYSMIS).
RECODE APG26
 (-999,-888,-666,-555=SYSMIS).
RECODE APG27
 (-999,-888,-666,-555=SYSMIS).
RECODE APG28
 (-999,-888,-666,-555=SYSMIS).
RECODE APG29
 (-999,-888,-666,-555=SYSMIS).
RECODE APG30
 (-999,-888,-666,-555=SYSMIS).
RECODE APG31
 (-999,-888,-666,-555=SYSMIS).
RECODE APG32
 (-999,-888,-666,-555=SYSMIS).
RECODE APG33
 (-999,-888,-666,-555=SYSMIS).
RECODE APG34
 (-999,-888,-666,-555=SYSMIS).
RECODE APG35
 (-999,-888,-666,-555=SYSMIS).
RECODE APG36
 (-999,-888,-666,-555=SYSMIS).
RECODE APG37
 (-999,-888,-666,-555=SYSMIS).
RECODE APG38
 (-999,-888,-666,-555=SYSMIS).
RECODE APG39
 (-999,-888,-666,-555=SYSMIS).
RECODE APG40
 (-999,-888,-666,-555=SYSMIS).
RECODE APG41
 (-999,-888,-666,-555=SYSMIS).
RECODE APG42
 (-999,-888,-666,-555=SYSMIS).
RECODE APG43
 (-999,-888,-666,-555=SYSMIS).
RECODE APG44
 (-999,-888,-666,-555=SYSMIS).
RECODE APG45
 (-999,-888,-666,-555=SYSMIS).
RECODE APG46
 (-999,-888,-666,-555=SYSMIS).
RECODE APG47
 (-999,-888,-666,-555=SYSMIS).
RECODE APG48
 (-999,-888,-666,-555=SYSMIS).
RECODE APG49
 (-999,-888,-666,-555=SYSMIS).
RECODE APG50
 (-999,-888,-666,-555=SYSMIS).
RECODE APG51
 (-999,-888,-666,-555=SYSMIS).
RECODE APG52
 (-999,-888,-666,-555=SYSMIS).
RECODE APG53
 (-999,-888,-666,-555=SYSMIS).
RECODE APG54
 (-999,-888,-666,-555=SYSMIS).
RECODE APG55
 (-999,-888,-666,-555=SYSMIS).
RECODE APG56
 (-999,-888,-666,-555=SYSMIS).
RECODE APG57
 (-999,-888,-666,-555=SYSMIS).
RECODE APG58
 (-999,-888,-666,-555=SYSMIS).
RECODE APG59
 (-999,-888,-666,-555=SYSMIS).
RECODE APG60
 (-999,-888,-666,-555=SYSMIS).
RECODE APG61
 (-999,-888,-666,-555=SYSMIS).
RECODE APG62
 (-999,-888,-666,-555=SYSMIS).
RECODE APG63
 (-999,-888,-666,-555=SYSMIS).
RECODE APG64
 (-999,-888,-666,-555=SYSMIS).
RECODE APG65
 (-999,-888,-666,-555=SYSMIS).
RECODE APG66
 (-999,-888,-666,-555=SYSMIS).
RECODE APG67
 (-999,-888,-666,-555=SYSMIS).
RECODE APG68
 (-999,-888,-666,-555=SYSMIS).
RECODE APG69
 (-999,-888,-666,-555=SYSMIS).
RECODE APG70
 (-999,-888,-666,-555=SYSMIS).
RECODE APG71
 (-999,-888,-666,-555=SYSMIS).
RECODE APG72
 (-999,-888,-666,-555=SYSMIS).
RECODE APG73
 (-999,-888,-666,-555=SYSMIS).
RECODE APG74
 (-999,-888,-666,-555=SYSMIS).
RECODE APG75
 (-999,-888,-666,-555=SYSMIS).
RECODE APG76
 (-999,-888,-666,-555=SYSMIS).
RECODE APG77
 (-999,-888,-666,-555=SYSMIS).
RECODE APG78
 (-999,-888,-666,-555=SYSMIS).
RECODE APG79
 (-999,-888,-666,-555=SYSMIS).
RECODE APG80
 (-999,-888,-666,-555=SYSMIS).
RECODE APG81
 (-999,-888,-666,-555=SYSMIS).
RECODE APG82
 (-999,-888,-666,-555=SYSMIS).
RECODE APG83
 (-999,-888,-666,-555=SYSMIS).
RECODE APG84
 (-999,-888,-666,-555=SYSMIS).
RECODE APG85
 (-999,-888,-666,-555=SYSMIS).
RECODE APG86
 (-999,-888,-666,-555=SYSMIS).
RECODE APG87
 (-999,-888,-666,-555=SYSMIS).
RECODE APG88
 (-999,-888,-666,-555=SYSMIS).
RECODE APG89
 (-999,-888,-666,-555=SYSMIS).
RECODE APG90
 (-999,-888,-666,-555=SYSMIS).
RECODE APG91
 (-999,-888,-666,-555=SYSMIS).
RECODE APG92
 (-999,-888,-666,-555=SYSMIS).
RECODE APG93
 (-999,-888,-666,-555=SYSMIS).
RECODE APG94
 (-999,-888,-666,-555=SYSMIS).
RECODE APG95
 (-999,-888,-666,-555=SYSMIS).
RECODE APG96
 (-999,-888,-666,-555=SYSMIS).
RECODE APG97
 (-999,-888,-666,-555=SYSMIS).
RECODE APG98
 (-999,-888,-666,-555=SYSMIS).
RECODE APG99
 (-999,-888,-666,-555=SYSMIS).
RECODE APG100
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MD_SASD_2004_CORE.SAV' /COMPRESSED.
