/*******************************************************************
*   FL_SASD_2002_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'FL_SASD_2002_CORE.ASC' FIXED / 
 KEY                   1-  14
 AGE                  15-  17
 AWEEKEND             18-  19
 CPT1                 20-  24 (A)
 CPT2                 25-  29 (A)
 CPT3                 30-  34 (A)
 CPT4                 35-  39 (A)
 CPT5                 40-  44 (A)
 CPT6                 45-  49 (A)
 CPT7                 50-  54 (A)
 CPT8                 55-  59 (A)
 CPT9                 60-  64 (A)
 CPT10                65-  69 (A)
 CPT11                70-  74 (A)
 CPT12                75-  79 (A)
 CPT13                80-  84 (A)
 CPT14                85-  89 (A)
 CPT15                90-  94 (A)
 DIED                 95-  96
 DISP_X               97-  98 (A)
 DISPUB92             99- 100
 DISPUNIF            101- 102
 DQTR                103- 104
 DSHOSPID            105- 117 (A)
 DX1                 118- 122 (A)
 DX2                 123- 127 (A)
 DX3                 128- 132 (A)
 DX4                 133- 137 (A)
 DX5                 138- 142 (A)
 DXCCS1              143- 146
 DXCCS2              147- 150
 DXCCS3              151- 154
 DXCCS4              155- 158
 DXCCS5              159- 162
 FEMALE              163- 164
 HOSPST              165- 166 (A)
 MDNUM1_S            167- 182 (A)
 MDNUM2_S            183- 198 (A)
 NCPT                199- 200
 NDX                 201- 202
 NEOMAT              203- 204
 NPR                 205- 206
 PAY1                207- 208
 PAY1_X              209     (A)
 PL_CBSA             210- 211
 PL_MSA19            212- 213
 PL_RUCA             214- 217
 PL_RUCA1            218- 219
 PL_RUCA4            220- 221
 PL_RUCC             222- 223
 PL_UIC              224- 225
 PR1                 226- 229 (A)
 PRCCS1              230- 232
 PROFEE              233- 234
 PSTCO2              235- 239
 RACE                240- 241
 RACE_X              242     (A)
 TOTCHG              243- 252
 TOTCHG_X            253- 267
 YEAR                268- 271
 ZIP                 272- 276 (A).


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 FEMALE              (F3.0) /
 NCPT                (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PL_CBSA             (F3.0) /
 PL_MSA19            (F3.0) /
 PL_RUCA             (F4.1) /
 PL_RUCA1            (F3.0) /
 PL_RUCA4            (F3.0) /
 PL_RUCC             (F3.0) /
 PL_UIC              (F3.0) /
 PRCCS1              (F3.0) /
 PROFEE              (F3.0) /
 PSTCO2              (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 FEMALE    "Indicator of sex"
 HOSPST    "Hospital state postal code"
 MDNUM1_S  "Physician 1 number (synthetic)"
 MDNUM2_S  "Physician 2 number (synthetic)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA   "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC   "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC    "Patient location: Urban Influence Codes"
 PR1       "Principal procedure"
 PRCCS1    "CCS: principal procedure"
 PROFEE    "Professional fees included in total charges"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP       "Patient ZIP Code" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_MSA19
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PROFEE
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).



SAVE OUTFILE = 'FL_SASD_2002_CORE.SAV' /COMPRESSED.
