/*******************************************************************
*   FL_SASD_2001_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'FL_SASD_2001_CORE.ASC' FIXED / 
 KEY                   1-  14
 AGE                  15-  17
 CPT1                 18-  22 (A)
 CPT2                 23-  27 (A)
 CPT3                 28-  32 (A)
 CPT4                 33-  37 (A)
 CPT5                 38-  42 (A)
 CPT6                 43-  47 (A)
 CPT7                 48-  52 (A)
 CPT8                 53-  57 (A)
 CPT9                 58-  62 (A)
 CPT10                63-  67 (A)
 CPT11                68-  72 (A)
 CPT12                73-  77 (A)
 CPT13                78-  82 (A)
 CPT14                83-  87 (A)
 CPT15                88-  92 (A)
 DIED                 93-  94
 DISP_X               95-  96 (A)
 DISPUB92             97-  98
 DISPUNIF             99- 100
 DQTR                101- 102
 DSHOSPID            103- 115 (A)
 DX1                 116- 120 (A)
 DX2                 121- 125 (A)
 DX3                 126- 130 (A)
 DX4                 131- 135 (A)
 DX5                 136- 140 (A)
 DXCCS1              141- 144
 DXCCS2              145- 148
 DXCCS3              149- 152
 DXCCS4              153- 156
 DXCCS5              157- 160
 FEMALE              161- 162
 HOSPST              163- 164 (A)
 MDNUM1_S            165- 180 (A)
 MDNUM2_S            181- 196 (A)
 NCPT                197- 198
 NDX                 199- 200
 NEOMAT              201- 202
 NPR                 203- 204
 PAY1                205- 206
 PAY1_X              207     (A)
 PR1                 208- 211 (A)
 PRCCS1              212- 214
 PROFEE              215- 216
 RACE                217- 218
 RACE_X              219     (A)
 TOTCHG              220- 229
 TOTCHG_X            230- 244
 YEAR                245- 248
 ZIP                 249- 253 (A).


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 FEMALE              (F3.0) /
 NCPT                (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PRCCS1              (F3.0) /
 PROFEE              (F3.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 FEMALE    "Indicator of sex"
 HOSPST    "Hospital state postal code"
 MDNUM1_S  "Physician 1 number (synthetic)"
 MDNUM2_S  "Physician 2 number (synthetic)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PR1       "Principal procedure"
 PRCCS1    "CCS: principal procedure"
 PROFEE    "Professional fees included in total charges"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP       "Patient ZIP Code" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PROFEE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).



SAVE OUTFILE = 'FL_SASD_2001_CORE.SAV' /COMPRESSED.
