/*****************************************************************************
* Stataload_NIS_2015_Core.Do
* This program will load the NIS_2015_Core ASCII File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    AGE                          1-   3   ///
      byte   AGE_NEONATE                  4-   5   ///
      byte   AMONTH                       6-   7   ///
      byte   AWEEKEND                     8-   9   ///
      byte   DIED                        10-  11   ///
      double DISCWT                      12-  22   ///
      byte   DISPUNIFORM                 23-  24   ///
      byte   DQTR                        25-  26   ///
      byte   ELECTIVE                    27-  28   ///
      byte   FEMALE                      29-  30   ///
      int    HCUP_ED                     31-  33   ///
      byte   HOSP_DIVISION               34-  35   ///
      long   HOSP_NIS                    36-  40   ///
      double KEY_NIS                     41-  50   ///
      long   LOS                         51-  55   ///
      int    NIS_STRATUM                 56-  59   ///
      byte   PAY1                        60-  61   ///
      int    PL_NCHS                     62-  64   ///
      byte   RACE                        65-  66   ///
      double TOTCHG                      67-  76   ///
      byte   TRAN_IN                     77-  78   ///
      byte   TRAN_OUT                    79-  80   ///
      int    YEAR                        81-  84   ///
      byte   ZIPINC_QRTL                 85-  86   ///
      using  "NIS_2015_Core.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
label var AMONTH                   "Admission month"
label var AWEEKEND                 "Admission day is a weekend"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "NIS discharge weight"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var ELECTIVE                 "Elective versus non-elective admission"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HOSP_DIVISION            "Census Division of hospital"
label var HOSP_NIS                 "NIS hospital number"
label var KEY_NIS                  "NIS record number"
label var LOS                      "Length of stay (cleaned)"
label var NIS_STRATUM              "NIS hospital stratum"
label var PAY1                     "Primary expected payer (uniform)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var RACE                     "Race (uniform)"
label var TOTCHG                   "Total charges (cleaned)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGE_NEONATE               (-9 -8 -6 -5=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-99 -88 -66=.)
recode HOSP_DIVISION             (-9 -8 -6 -5=.)
recode HOSP_NIS                  (-9999 -8888 -6666=.)
recode KEY_NIS                   (-999999999 -888888888 -666666666=.)
recode LOS                       (-9999 -8888 -6666=.)
recode NIS_STRATUM               (-999 -888 -666=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_NCHS                   (-99 -88 -66=.)
recode RACE                      (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-9 -8 -6 -5=.)

save "NIS_2015_Core.dta", replace
