/*****************************************************************************
* Stataload_NIS_2015Q4_DX_PR_GRPS.Do
* This program will load the NIS_2015Q4_DX_PR_GRPS ASCII File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    DRG                          1-   3   ///
      int    DRG_NoPOA                    4-   6   ///
      byte   DRGVER                       7-   8   ///
      byte   DXVER                        9-  10   ///
      long   HOSP_NIS                    11-  15   ///
      str    I10_DX1                     16-  22   ///
      str    I10_DX2                     23-  29   ///
      str    I10_DX3                     30-  36   ///
      str    I10_DX4                     37-  43   ///
      str    I10_DX5                     44-  50   ///
      str    I10_DX6                     51-  57   ///
      str    I10_DX7                     58-  64   ///
      str    I10_DX8                     65-  71   ///
      str    I10_DX9                     72-  78   ///
      str    I10_DX10                    79-  85   ///
      str    I10_DX11                    86-  92   ///
      str    I10_DX12                    93-  99   ///
      str    I10_DX13                   100- 106   ///
      str    I10_DX14                   107- 113   ///
      str    I10_DX15                   114- 120   ///
      str    I10_DX16                   121- 127   ///
      str    I10_DX17                   128- 134   ///
      str    I10_DX18                   135- 141   ///
      str    I10_DX19                   142- 148   ///
      str    I10_DX20                   149- 155   ///
      str    I10_DX21                   156- 162   ///
      str    I10_DX22                   163- 169   ///
      str    I10_DX23                   170- 176   ///
      str    I10_DX24                   177- 183   ///
      str    I10_DX25                   184- 190   ///
      str    I10_DX26                   191- 197   ///
      str    I10_DX27                   198- 204   ///
      str    I10_DX28                   205- 211   ///
      str    I10_DX29                   212- 218   ///
      str    I10_DX30                   219- 225   ///
      str    I10_ECAUSE1                226- 232   ///
      str    I10_ECAUSE2                233- 239   ///
      str    I10_ECAUSE3                240- 246   ///
      str    I10_ECAUSE4                247- 253   ///
      byte   I10_NDX                    254- 255   ///
      int    I10_NECAUSE                256- 258   ///
      byte   I10_NPR                    259- 260   ///
      str    I10_PR1                    261- 267   ///
      str    I10_PR2                    268- 274   ///
      str    I10_PR3                    275- 281   ///
      str    I10_PR4                    282- 288   ///
      str    I10_PR5                    289- 295   ///
      str    I10_PR6                    296- 302   ///
      str    I10_PR7                    303- 309   ///
      str    I10_PR8                    310- 316   ///
      str    I10_PR9                    317- 323   ///
      str    I10_PR10                   324- 330   ///
      str    I10_PR11                   331- 337   ///
      str    I10_PR12                   338- 344   ///
      str    I10_PR13                   345- 351   ///
      str    I10_PR14                   352- 358   ///
      str    I10_PR15                   359- 365   ///
      double KEY_NIS                    366- 375   ///
      byte   MDC                        376- 377   ///
      byte   MDC_NoPOA                  378- 379   ///
      int    PRDAY1                     380- 382   ///
      int    PRDAY2                     383- 385   ///
      int    PRDAY3                     386- 388   ///
      int    PRDAY4                     389- 391   ///
      int    PRDAY5                     392- 394   ///
      int    PRDAY6                     395- 397   ///
      int    PRDAY7                     398- 400   ///
      int    PRDAY8                     401- 403   ///
      int    PRDAY9                     404- 406   ///
      int    PRDAY10                    407- 409   ///
      int    PRDAY11                    410- 412   ///
      int    PRDAY12                    413- 415   ///
      int    PRDAY13                    416- 418   ///
      int    PRDAY14                    419- 421   ///
      int    PRDAY15                    422- 424   ///
      byte   PRVER                      425- 426   ///
      using  "NIS_2015Q4_DX_PR_GRPS.ASC"

***  Assign labels to the data elements ***
label var DRG                      "DRG in effect on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DXVER                    "Diagnosis Version"
label var HOSP_NIS                 "NIS hospital number"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_DX18                 "ICD-10-CM Diagnosis 18"
label var I10_DX19                 "ICD-10-CM Diagnosis 19"
label var I10_DX20                 "ICD-10-CM Diagnosis 20"
label var I10_DX21                 "ICD-10-CM Diagnosis 21"
label var I10_DX22                 "ICD-10-CM Diagnosis 22"
label var I10_DX23                 "ICD-10-CM Diagnosis 23"
label var I10_DX24                 "ICD-10-CM Diagnosis 24"
label var I10_DX25                 "ICD-10-CM Diagnosis 25"
label var I10_DX26                 "ICD-10-CM Diagnosis 26"
label var I10_DX27                 "ICD-10-CM Diagnosis 27"
label var I10_DX28                 "ICD-10-CM Diagnosis 28"
label var I10_DX29                 "ICD-10-CM Diagnosis 29"
label var I10_DX30                 "ICD-10-CM Diagnosis 30"
label var I10_ECAUSE1              "ICD-10-CM External cause 1"
label var I10_ECAUSE2              "ICD-10-CM External cause 2"
label var I10_ECAUSE3              "ICD-10-CM External cause 3"
label var I10_ECAUSE4              "ICD-10-CM External cause 4"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_NECAUSE              "ICD-10-CM Number of external cause codes on this record"
label var I10_NPR                  "ICD-10-PCS Number of procedures on this record"
label var I10_PR1                  "ICD-10-PCS Procedure 1"
label var I10_PR2                  "ICD-10-PCS Procedure 2"
label var I10_PR3                  "ICD-10-PCS Procedure 3"
label var I10_PR4                  "ICD-10-PCS Procedure 4"
label var I10_PR5                  "ICD-10-PCS Procedure 5"
label var I10_PR6                  "ICD-10-PCS Procedure 6"
label var I10_PR7                  "ICD-10-PCS Procedure 7"
label var I10_PR8                  "ICD-10-PCS Procedure 8"
label var I10_PR9                  "ICD-10-PCS Procedure 9"
label var I10_PR10                 "ICD-10-PCS Procedure 10"
label var I10_PR11                 "ICD-10-PCS Procedure 11"
label var I10_PR12                 "ICD-10-PCS Procedure 12"
label var I10_PR13                 "ICD-10-PCS Procedure 13"
label var I10_PR14                 "ICD-10-PCS Procedure 14"
label var I10_PR15                 "ICD-10-PCS Procedure 15"
label var KEY_NIS                  "NIS record number"
label var MDC                      "MDC in effect on discharge date"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var PRDAY1                   "Number of days from admission to I10_PR1"
label var PRDAY2                   "Number of days from admission to I10_PR2"
label var PRDAY3                   "Number of days from admission to I10_PR3"
label var PRDAY4                   "Number of days from admission to I10_PR4"
label var PRDAY5                   "Number of days from admission to I10_PR5"
label var PRDAY6                   "Number of days from admission to I10_PR6"
label var PRDAY7                   "Number of days from admission to I10_PR7"
label var PRDAY8                   "Number of days from admission to I10_PR8"
label var PRDAY9                   "Number of days from admission to I10_PR9"
label var PRDAY10                  "Number of days from admission to I10_PR10"
label var PRDAY11                  "Number of days from admission to I10_PR11"
label var PRDAY12                  "Number of days from admission to I10_PR12"
label var PRDAY13                  "Number of days from admission to I10_PR13"
label var PRDAY14                  "Number of days from admission to I10_PR14"
label var PRDAY15                  "Number of days from admission to I10_PR15"
label var PRVER                    "Procedure Version"

*** Convert special values to missing values ***
recode DRG                       (-99 -88 -66=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DXVER                     (-9 -8 -6 -5=.)
recode HOSP_NIS                  (-9999 -8888 -6666=.)
recode I10_NDX                   (-9 -8 -6 -5=.)
recode I10_NECAUSE               (-99 -88 -66=.)
recode I10_NPR                   (-9 -8 -6 -5=.)
recode KEY_NIS                   (-999999999 -888888888 -666666666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode PRVER                     (-9 -8 -6 -5=.)

save "NIS_2015Q4_DX_PR_GRPS.dta", replace
