/*****************************************************************************
* Stataload_NIS_2015Q1Q3_DX_PR_GRPS.Do
* This program will load the NIS_2015Q1Q3_DX_PR_GRPS ASCII File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    BODYSYSTEM1                  1-   3   ///
      int    BODYSYSTEM2                  4-   6   ///
      int    BODYSYSTEM3                  7-   9   ///
      int    BODYSYSTEM4                 10-  12   ///
      int    BODYSYSTEM5                 13-  15   ///
      int    BODYSYSTEM6                 16-  18   ///
      int    BODYSYSTEM7                 19-  21   ///
      int    BODYSYSTEM8                 22-  24   ///
      int    BODYSYSTEM9                 25-  27   ///
      int    BODYSYSTEM10                28-  30   ///
      int    BODYSYSTEM11                31-  33   ///
      int    BODYSYSTEM12                34-  36   ///
      int    BODYSYSTEM13                37-  39   ///
      int    BODYSYSTEM14                40-  42   ///
      int    BODYSYSTEM15                43-  45   ///
      int    BODYSYSTEM16                46-  48   ///
      int    BODYSYSTEM17                49-  51   ///
      int    BODYSYSTEM18                52-  54   ///
      int    BODYSYSTEM19                55-  57   ///
      int    BODYSYSTEM20                58-  60   ///
      int    BODYSYSTEM21                61-  63   ///
      int    BODYSYSTEM22                64-  66   ///
      int    BODYSYSTEM23                67-  69   ///
      int    BODYSYSTEM24                70-  72   ///
      int    BODYSYSTEM25                73-  75   ///
      int    BODYSYSTEM26                76-  78   ///
      int    BODYSYSTEM27                79-  81   ///
      int    BODYSYSTEM28                82-  84   ///
      int    BODYSYSTEM29                85-  87   ///
      int    BODYSYSTEM30                88-  90   ///
      int    CHRON1                      91-  93   ///
      int    CHRON2                      94-  96   ///
      int    CHRON3                      97-  99   ///
      int    CHRON4                     100- 102   ///
      int    CHRON5                     103- 105   ///
      int    CHRON6                     106- 108   ///
      int    CHRON7                     109- 111   ///
      int    CHRON8                     112- 114   ///
      int    CHRON9                     115- 117   ///
      int    CHRON10                    118- 120   ///
      int    CHRON11                    121- 123   ///
      int    CHRON12                    124- 126   ///
      int    CHRON13                    127- 129   ///
      int    CHRON14                    130- 132   ///
      int    CHRON15                    133- 135   ///
      int    CHRON16                    136- 138   ///
      int    CHRON17                    139- 141   ///
      int    CHRON18                    142- 144   ///
      int    CHRON19                    145- 147   ///
      int    CHRON20                    148- 150   ///
      int    CHRON21                    151- 153   ///
      int    CHRON22                    154- 156   ///
      int    CHRON23                    157- 159   ///
      int    CHRON24                    160- 162   ///
      int    CHRON25                    163- 165   ///
      int    CHRON26                    166- 168   ///
      int    CHRON27                    169- 171   ///
      int    CHRON28                    172- 174   ///
      int    CHRON29                    175- 177   ///
      int    CHRON30                    178- 180   ///
      int    DRG                        181- 183   ///
      int    DRG_NoPOA                  184- 186   ///
      byte   DRGVER                     187- 188   ///
      str    DX1                        189- 195   ///
      str    DX2                        196- 202   ///
      str    DX3                        203- 209   ///
      str    DX4                        210- 216   ///
      str    DX5                        217- 223   ///
      str    DX6                        224- 230   ///
      str    DX7                        231- 237   ///
      str    DX8                        238- 244   ///
      str    DX9                        245- 251   ///
      str    DX10                       252- 258   ///
      str    DX11                       259- 265   ///
      str    DX12                       266- 272   ///
      str    DX13                       273- 279   ///
      str    DX14                       280- 286   ///
      str    DX15                       287- 293   ///
      str    DX16                       294- 300   ///
      str    DX17                       301- 307   ///
      str    DX18                       308- 314   ///
      str    DX19                       315- 321   ///
      str    DX20                       322- 328   ///
      str    DX21                       329- 335   ///
      str    DX22                       336- 342   ///
      str    DX23                       343- 349   ///
      str    DX24                       350- 356   ///
      str    DX25                       357- 363   ///
      str    DX26                       364- 370   ///
      str    DX27                       371- 377   ///
      str    DX28                       378- 384   ///
      str    DX29                       385- 391   ///
      str    DX30                       392- 398   ///
      int    DXCCS1                     399- 402   ///
      int    DXCCS2                     403- 406   ///
      int    DXCCS3                     407- 410   ///
      int    DXCCS4                     411- 414   ///
      int    DXCCS5                     415- 418   ///
      int    DXCCS6                     419- 422   ///
      int    DXCCS7                     423- 426   ///
      int    DXCCS8                     427- 430   ///
      int    DXCCS9                     431- 434   ///
      int    DXCCS10                    435- 438   ///
      int    DXCCS11                    439- 442   ///
      int    DXCCS12                    443- 446   ///
      int    DXCCS13                    447- 450   ///
      int    DXCCS14                    451- 454   ///
      int    DXCCS15                    455- 458   ///
      int    DXCCS16                    459- 462   ///
      int    DXCCS17                    463- 466   ///
      int    DXCCS18                    467- 470   ///
      int    DXCCS19                    471- 474   ///
      int    DXCCS20                    475- 478   ///
      int    DXCCS21                    479- 482   ///
      int    DXCCS22                    483- 486   ///
      int    DXCCS23                    487- 490   ///
      int    DXCCS24                    491- 494   ///
      int    DXCCS25                    495- 498   ///
      int    DXCCS26                    499- 502   ///
      int    DXCCS27                    503- 506   ///
      int    DXCCS28                    507- 510   ///
      int    DXCCS29                    511- 514   ///
      int    DXCCS30                    515- 518   ///
      str    DXMCCS1                    519- 529   ///
      byte   DXVER                      530- 531   ///
      int    E_CCS1                     532- 535   ///
      int    E_CCS2                     536- 539   ///
      int    E_CCS3                     540- 543   ///
      int    E_CCS4                     544- 547   ///
      str    E_MCCS1                    548- 558   ///
      str    ECODE1                     559- 565   ///
      str    ECODE2                     566- 572   ///
      str    ECODE3                     573- 579   ///
      str    ECODE4                     580- 586   ///
      long   HOSP_NIS                   587- 591   ///
      byte   HOSPBRTH                   592- 593   ///
      double KEY_NIS                    594- 603   ///
      byte   MDC                        604- 605   ///
      byte   MDC_NoPOA                  606- 607   ///
      byte   NCHRONIC                   608- 609   ///
      byte   NDX                        610- 611   ///
      int    NECODE                     612- 614   ///
      byte   NEOMAT                     615- 616   ///
      byte   NPR                        617- 618   ///
      byte   ORPROC                     619- 620   ///
      int    PCLASS1                    621- 623   ///
      int    PCLASS2                    624- 626   ///
      int    PCLASS3                    627- 629   ///
      int    PCLASS4                    630- 632   ///
      int    PCLASS5                    633- 635   ///
      int    PCLASS6                    636- 638   ///
      int    PCLASS7                    639- 641   ///
      int    PCLASS8                    642- 644   ///
      int    PCLASS9                    645- 647   ///
      int    PCLASS10                   648- 650   ///
      int    PCLASS11                   651- 653   ///
      int    PCLASS12                   654- 656   ///
      int    PCLASS13                   657- 659   ///
      int    PCLASS14                   660- 662   ///
      int    PCLASS15                   663- 665   ///
      str    PR1                        666- 672   ///
      str    PR2                        673- 679   ///
      str    PR3                        680- 686   ///
      str    PR4                        687- 693   ///
      str    PR5                        694- 700   ///
      str    PR6                        701- 707   ///
      str    PR7                        708- 714   ///
      str    PR8                        715- 721   ///
      str    PR9                        722- 728   ///
      str    PR10                       729- 735   ///
      str    PR11                       736- 742   ///
      str    PR12                       743- 749   ///
      str    PR13                       750- 756   ///
      str    PR14                       757- 763   ///
      str    PR15                       764- 770   ///
      int    PRCCS1                     771- 773   ///
      int    PRCCS2                     774- 776   ///
      int    PRCCS3                     777- 779   ///
      int    PRCCS4                     780- 782   ///
      int    PRCCS5                     783- 785   ///
      int    PRCCS6                     786- 788   ///
      int    PRCCS7                     789- 791   ///
      int    PRCCS8                     792- 794   ///
      int    PRCCS9                     795- 797   ///
      int    PRCCS10                    798- 800   ///
      int    PRCCS11                    801- 803   ///
      int    PRCCS12                    804- 806   ///
      int    PRCCS13                    807- 809   ///
      int    PRCCS14                    810- 812   ///
      int    PRCCS15                    813- 815   ///
      int    PRDAY1                     816- 818   ///
      int    PRDAY2                     819- 821   ///
      int    PRDAY3                     822- 824   ///
      int    PRDAY4                     825- 827   ///
      int    PRDAY5                     828- 830   ///
      int    PRDAY6                     831- 833   ///
      int    PRDAY7                     834- 836   ///
      int    PRDAY8                     837- 839   ///
      int    PRDAY9                     840- 842   ///
      int    PRDAY10                    843- 845   ///
      int    PRDAY11                    846- 848   ///
      int    PRDAY12                    849- 851   ///
      int    PRDAY13                    852- 854   ///
      int    PRDAY14                    855- 857   ///
      int    PRDAY15                    858- 860   ///
      str    PRMCCS1                    861- 868   ///
      byte   PRVER                      869- 870   ///
      int    SERVICELINE                871- 873   ///
      using  "NIS_2015Q1Q3_DX_PR_GRPS.ASC"

***  Assign labels to the data elements ***
label var BODYSYSTEM1              "Body system 1"
label var BODYSYSTEM2              "Body system 2"
label var BODYSYSTEM3              "Body system 3"
label var BODYSYSTEM4              "Body system 4"
label var BODYSYSTEM5              "Body system 5"
label var BODYSYSTEM6              "Body system 6"
label var BODYSYSTEM7              "Body system 7"
label var BODYSYSTEM8              "Body system 8"
label var BODYSYSTEM9              "Body system 9"
label var BODYSYSTEM10             "Body system 10"
label var BODYSYSTEM11             "Body system 11"
label var BODYSYSTEM12             "Body system 12"
label var BODYSYSTEM13             "Body system 13"
label var BODYSYSTEM14             "Body system 14"
label var BODYSYSTEM15             "Body system 15"
label var BODYSYSTEM16             "Body system 16"
label var BODYSYSTEM17             "Body system 17"
label var BODYSYSTEM18             "Body system 18"
label var BODYSYSTEM19             "Body system 19"
label var BODYSYSTEM20             "Body system 20"
label var BODYSYSTEM21             "Body system 21"
label var BODYSYSTEM22             "Body system 22"
label var BODYSYSTEM23             "Body system 23"
label var BODYSYSTEM24             "Body system 24"
label var BODYSYSTEM25             "Body system 25"
label var BODYSYSTEM26             "Body system 26"
label var BODYSYSTEM27             "Body system 27"
label var BODYSYSTEM28             "Body system 28"
label var BODYSYSTEM29             "Body system 29"
label var BODYSYSTEM30             "Body system 30"
label var CHRON1                   "Chronic condition indicator 1"
label var CHRON2                   "Chronic condition indicator 2"
label var CHRON3                   "Chronic condition indicator 3"
label var CHRON4                   "Chronic condition indicator 4"
label var CHRON5                   "Chronic condition indicator 5"
label var CHRON6                   "Chronic condition indicator 6"
label var CHRON7                   "Chronic condition indicator 7"
label var CHRON8                   "Chronic condition indicator 8"
label var CHRON9                   "Chronic condition indicator 9"
label var CHRON10                  "Chronic condition indicator 10"
label var CHRON11                  "Chronic condition indicator 11"
label var CHRON12                  "Chronic condition indicator 12"
label var CHRON13                  "Chronic condition indicator 13"
label var CHRON14                  "Chronic condition indicator 14"
label var CHRON15                  "Chronic condition indicator 15"
label var CHRON16                  "Chronic condition indicator 16"
label var CHRON17                  "Chronic condition indicator 17"
label var CHRON18                  "Chronic condition indicator 18"
label var CHRON19                  "Chronic condition indicator 19"
label var CHRON20                  "Chronic condition indicator 20"
label var CHRON21                  "Chronic condition indicator 21"
label var CHRON22                  "Chronic condition indicator 22"
label var CHRON23                  "Chronic condition indicator 23"
label var CHRON24                  "Chronic condition indicator 24"
label var CHRON25                  "Chronic condition indicator 25"
label var CHRON26                  "Chronic condition indicator 26"
label var CHRON27                  "Chronic condition indicator 27"
label var CHRON28                  "Chronic condition indicator 28"
label var CHRON29                  "Chronic condition indicator 29"
label var CHRON30                  "Chronic condition indicator 30"
label var DRG                      "DRG in effect on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DX16                     "Diagnosis 16"
label var DX17                     "Diagnosis 17"
label var DX18                     "Diagnosis 18"
label var DX19                     "Diagnosis 19"
label var DX20                     "Diagnosis 20"
label var DX21                     "Diagnosis 21"
label var DX22                     "Diagnosis 22"
label var DX23                     "Diagnosis 23"
label var DX24                     "Diagnosis 24"
label var DX25                     "Diagnosis 25"
label var DX26                     "Diagnosis 26"
label var DX27                     "Diagnosis 27"
label var DX28                     "Diagnosis 28"
label var DX29                     "Diagnosis 29"
label var DX30                     "Diagnosis 30"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var DXCCS16                  "CCS: diagnosis 16"
label var DXCCS17                  "CCS: diagnosis 17"
label var DXCCS18                  "CCS: diagnosis 18"
label var DXCCS19                  "CCS: diagnosis 19"
label var DXCCS20                  "CCS: diagnosis 20"
label var DXCCS21                  "CCS: diagnosis 21"
label var DXCCS22                  "CCS: diagnosis 22"
label var DXCCS23                  "CCS: diagnosis 23"
label var DXCCS24                  "CCS: diagnosis 24"
label var DXCCS25                  "CCS: diagnosis 25"
label var DXCCS26                  "CCS: diagnosis 26"
label var DXCCS27                  "CCS: diagnosis 27"
label var DXCCS28                  "CCS: diagnosis 28"
label var DXCCS29                  "CCS: diagnosis 29"
label var DXCCS30                  "CCS: diagnosis 30"
label var DXMCCS1                  "Multi-Level CCS:  Diagnosis 1"
label var DXVER                    "Diagnosis Version"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var E_MCCS1                  "Multi-Level CCS:  E Code 1"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var HOSP_NIS                 "NIS hospital number"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var KEY_NIS                  "NIS record number"
label var MDC                      "MDC in effect on discharge date"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var NCHRONIC                 "Number of chronic conditions"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PCLASS1                  "Procedure class 1"
label var PCLASS2                  "Procedure class 2"
label var PCLASS3                  "Procedure class 3"
label var PCLASS4                  "Procedure class 4"
label var PCLASS5                  "Procedure class 5"
label var PCLASS6                  "Procedure class 6"
label var PCLASS7                  "Procedure class 7"
label var PCLASS8                  "Procedure class 8"
label var PCLASS9                  "Procedure class 9"
label var PCLASS10                 "Procedure class 10"
label var PCLASS11                 "Procedure class 11"
label var PCLASS12                 "Procedure class 12"
label var PCLASS13                 "Procedure class 13"
label var PCLASS14                 "Procedure class 14"
label var PCLASS15                 "Procedure class 15"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var PRMCCS1                  "Multi-Level CCS:  Procedure 1"
label var PRVER                    "Procedure Version"
label var SERVICELINE              "Hospital Service Line"

*** Convert special values to missing values ***
recode BODYSYSTEM1               (-99 -88 -66=.)
recode BODYSYSTEM2               (-99 -88 -66=.)
recode BODYSYSTEM3               (-99 -88 -66=.)
recode BODYSYSTEM4               (-99 -88 -66=.)
recode BODYSYSTEM5               (-99 -88 -66=.)
recode BODYSYSTEM6               (-99 -88 -66=.)
recode BODYSYSTEM7               (-99 -88 -66=.)
recode BODYSYSTEM8               (-99 -88 -66=.)
recode BODYSYSTEM9               (-99 -88 -66=.)
recode BODYSYSTEM10              (-99 -88 -66=.)
recode BODYSYSTEM11              (-99 -88 -66=.)
recode BODYSYSTEM12              (-99 -88 -66=.)
recode BODYSYSTEM13              (-99 -88 -66=.)
recode BODYSYSTEM14              (-99 -88 -66=.)
recode BODYSYSTEM15              (-99 -88 -66=.)
recode BODYSYSTEM16              (-99 -88 -66=.)
recode BODYSYSTEM17              (-99 -88 -66=.)
recode BODYSYSTEM18              (-99 -88 -66=.)
recode BODYSYSTEM19              (-99 -88 -66=.)
recode BODYSYSTEM20              (-99 -88 -66=.)
recode BODYSYSTEM21              (-99 -88 -66=.)
recode BODYSYSTEM22              (-99 -88 -66=.)
recode BODYSYSTEM23              (-99 -88 -66=.)
recode BODYSYSTEM24              (-99 -88 -66=.)
recode BODYSYSTEM25              (-99 -88 -66=.)
recode BODYSYSTEM26              (-99 -88 -66=.)
recode BODYSYSTEM27              (-99 -88 -66=.)
recode BODYSYSTEM28              (-99 -88 -66=.)
recode BODYSYSTEM29              (-99 -88 -66=.)
recode BODYSYSTEM30              (-99 -88 -66=.)
recode CHRON1                    (-99 -88 -66=.)
recode CHRON2                    (-99 -88 -66=.)
recode CHRON3                    (-99 -88 -66=.)
recode CHRON4                    (-99 -88 -66=.)
recode CHRON5                    (-99 -88 -66=.)
recode CHRON6                    (-99 -88 -66=.)
recode CHRON7                    (-99 -88 -66=.)
recode CHRON8                    (-99 -88 -66=.)
recode CHRON9                    (-99 -88 -66=.)
recode CHRON10                   (-99 -88 -66=.)
recode CHRON11                   (-99 -88 -66=.)
recode CHRON12                   (-99 -88 -66=.)
recode CHRON13                   (-99 -88 -66=.)
recode CHRON14                   (-99 -88 -66=.)
recode CHRON15                   (-99 -88 -66=.)
recode CHRON16                   (-99 -88 -66=.)
recode CHRON17                   (-99 -88 -66=.)
recode CHRON18                   (-99 -88 -66=.)
recode CHRON19                   (-99 -88 -66=.)
recode CHRON20                   (-99 -88 -66=.)
recode CHRON21                   (-99 -88 -66=.)
recode CHRON22                   (-99 -88 -66=.)
recode CHRON23                   (-99 -88 -66=.)
recode CHRON24                   (-99 -88 -66=.)
recode CHRON25                   (-99 -88 -66=.)
recode CHRON26                   (-99 -88 -66=.)
recode CHRON27                   (-99 -88 -66=.)
recode CHRON28                   (-99 -88 -66=.)
recode CHRON29                   (-99 -88 -66=.)
recode CHRON30                   (-99 -88 -66=.)
recode DRG                       (-99 -88 -66=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DXCCS1                    (-999 -888 -666=.)
recode DXCCS2                    (-999 -888 -666=.)
recode DXCCS3                    (-999 -888 -666=.)
recode DXCCS4                    (-999 -888 -666=.)
recode DXCCS5                    (-999 -888 -666=.)
recode DXCCS6                    (-999 -888 -666=.)
recode DXCCS7                    (-999 -888 -666=.)
recode DXCCS8                    (-999 -888 -666=.)
recode DXCCS9                    (-999 -888 -666=.)
recode DXCCS10                   (-999 -888 -666=.)
recode DXCCS11                   (-999 -888 -666=.)
recode DXCCS12                   (-999 -888 -666=.)
recode DXCCS13                   (-999 -888 -666=.)
recode DXCCS14                   (-999 -888 -666=.)
recode DXCCS15                   (-999 -888 -666=.)
recode DXCCS16                   (-999 -888 -666=.)
recode DXCCS17                   (-999 -888 -666=.)
recode DXCCS18                   (-999 -888 -666=.)
recode DXCCS19                   (-999 -888 -666=.)
recode DXCCS20                   (-999 -888 -666=.)
recode DXCCS21                   (-999 -888 -666=.)
recode DXCCS22                   (-999 -888 -666=.)
recode DXCCS23                   (-999 -888 -666=.)
recode DXCCS24                   (-999 -888 -666=.)
recode DXCCS25                   (-999 -888 -666=.)
recode DXCCS26                   (-999 -888 -666=.)
recode DXCCS27                   (-999 -888 -666=.)
recode DXCCS28                   (-999 -888 -666=.)
recode DXCCS29                   (-999 -888 -666=.)
recode DXCCS30                   (-999 -888 -666=.)
recode DXVER                     (-9 -8 -6 -5=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode HOSP_NIS                  (-9999 -8888 -6666=.)
recode HOSPBRTH                  (-9 -8 -6 -5=.)
recode KEY_NIS                   (-999999999 -888888888 -666666666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode NCHRONIC                  (-9 -8 -6 -5=.)
recode NDX                       (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NPR                       (-9 -8 -6 -5=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PCLASS1                   (-99 -88 -66=.)
recode PCLASS2                   (-99 -88 -66=.)
recode PCLASS3                   (-99 -88 -66=.)
recode PCLASS4                   (-99 -88 -66=.)
recode PCLASS5                   (-99 -88 -66=.)
recode PCLASS6                   (-99 -88 -66=.)
recode PCLASS7                   (-99 -88 -66=.)
recode PCLASS8                   (-99 -88 -66=.)
recode PCLASS9                   (-99 -88 -66=.)
recode PCLASS10                  (-99 -88 -66=.)
recode PCLASS11                  (-99 -88 -66=.)
recode PCLASS12                  (-99 -88 -66=.)
recode PCLASS13                  (-99 -88 -66=.)
recode PCLASS14                  (-99 -88 -66=.)
recode PCLASS15                  (-99 -88 -66=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode PRVER                     (-9 -8 -6 -5=.)
recode SERVICELINE               (-99 -88 -66=.)

save "NIS_2015Q1Q3_DX_PR_GRPS.dta", replace
