/*****************************************************************************
* Stataload_NIS_2005_Dx_Pr_Grps.Do
* This program will load the 2005 NIS ASCII Dx_Pr_Grps File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix long   HOSPID                      1-  5   ///
      double KEY                         6- 19   ///
      int    CCSMGN1                    20- 22   ///
      int    CCSMGN2                    23- 25   ///
      int    CCSMGN3                    26- 28   ///
      int    CCSMGN4                    29- 31   ///
      int    CCSMGN5                    32- 34   ///
      int    CCSMGN6                    35- 37   ///
      int    CCSMGN7                    38- 40   ///
      int    CCSMGN8                    41- 43   ///
      int    CCSMGN9                    44- 46   ///
      int    CCSMGN10                   47- 49   ///
      int    CCSMGN11                   50- 52   ///
      int    CCSMGN12                   53- 55   ///
      int    CCSMGN13                   56- 58   ///
      int    CCSMGN14                   59- 61   ///
      int    CCSMGN15                   62- 64   ///
      int    CCSMSP1                    65- 68   ///
      int    CCSMSP2                    69- 72   ///
      int    CCSMSP3                    73- 76   ///
      int    CCSMSP4                    77- 80   ///
      int    CCSMSP5                    81- 84   ///
      int    CCSMSP6                    85- 88   ///
      int    CCSMSP7                    89- 92   ///
      int    CCSMSP8                    93- 96   ///
      int    CCSMSP9                    97-100   ///
      int    CCSMSP10                  101-104   ///
      int    CCSMSP11                  105-108   ///
      int    CCSMSP12                  109-112   ///
      int    CCSMSP13                  113-116   ///
      int    CCSMSP14                  117-120   ///
      int    CCSMSP15                  121-124   ///
      int    CHRON1                    125-127   ///
      int    CHRON2                    128-130   ///
      int    CHRON3                    131-133   ///
      int    CHRON4                    134-136   ///
      int    CHRON5                    137-139   ///
      int    CHRON6                    140-142   ///
      int    CHRON7                    143-145   ///
      int    CHRON8                    146-148   ///
      int    CHRON9                    149-151   ///
      int    CHRON10                   152-154   ///
      int    CHRON11                   155-157   ///
      int    CHRON12                   158-160   ///
      int    CHRON13                   161-163   ///
      int    CHRON14                   164-166   ///
      int    CHRON15                   167-169   ///
      int    CHRONB1                   170-172   ///
      int    CHRONB2                   173-175   ///
      int    CHRONB3                   176-178   ///
      int    CHRONB4                   179-181   ///
      int    CHRONB5                   182-184   ///
      int    CHRONB6                   185-187   ///
      int    CHRONB7                   188-190   ///
      int    CHRONB8                   191-193   ///
      int    CHRONB9                   194-196   ///
      int    CHRONB10                  197-199   ///
      int    CHRONB11                  200-202   ///
      int    CHRONB12                  203-205   ///
      int    CHRONB13                  206-208   ///
      int    CHRONB14                  209-211   ///
      int    CHRONB15                  212-214   ///
      int    ECCSMGN1                  215-217   ///
      int    ECCSMGN2                  218-220   ///
      int    ECCSMGN3                  221-223   ///
      int    ECCSMGN4                  224-226   ///
      int    PCLASS1                   227-229   ///
      int    PCLASS2                   230-232   ///
      int    PCLASS3                   233-235   ///
      int    PCLASS4                   236-238   ///
      int    PCLASS5                   239-241   ///
      int    PCLASS6                   242-244   ///
      int    PCLASS7                   245-247   ///
      int    PCLASS8                   248-250   ///
      int    PCLASS9                   251-253   ///
      int    PCLASS10                  254-256   ///
      int    PCLASS11                  257-259   ///
      int    PCLASS12                  260-262   ///
      int    PCLASS13                  263-265   ///
      int    PCLASS14                  266-268   ///
      int    PCLASS15                  269-271   ///
      using  "NIS_2005_Dx_Pr_Grps.ASC"

***  Assign labels to the data elements ***
label var HOSPID                   "HCUP hospital identification number"
label var KEY                      "HCUP record identifier"
label var CCSMGN1                  "CCS-MHSA general category: principal diagnosis"
label var CCSMGN2                  "CCS-MHSA general category: diagnosis 2"
label var CCSMGN3                  "CCS-MHSA general category: diagnosis 3"
label var CCSMGN4                  "CCS-MHSA general category: diagnosis 4"
label var CCSMGN5                  "CCS-MHSA general category: diagnosis 5"
label var CCSMGN6                  "CCS-MHSA general category: diagnosis 6"
label var CCSMGN7                  "CCS-MHSA general category: diagnosis 7"
label var CCSMGN8                  "CCS-MHSA general category: diagnosis 8"
label var CCSMGN9                  "CCS-MHSA general category: diagnosis 9"
label var CCSMGN10                 "CCS-MHSA general category: diagnosis 10"
label var CCSMGN11                 "CCS-MHSA general category: diagnosis 11"
label var CCSMGN12                 "CCS-MHSA general category: diagnosis 12"
label var CCSMGN13                 "CCS-MHSA general category: diagnosis 13"
label var CCSMGN14                 "CCS-MHSA general category: diagnosis 14"
label var CCSMGN15                 "CCS-MHSA general category: diagnosis 15"
label var CCSMSP1                  "CCS-MHSA specific category: principal diagnosis"
label var CCSMSP2                  "CCS-MHSA specific category: diagnosis 2"
label var CCSMSP3                  "CCS-MHSA specific category: diagnosis 3"
label var CCSMSP4                  "CCS-MHSA specific category: diagnosis 4"
label var CCSMSP5                  "CCS-MHSA specific category: diagnosis 5"
label var CCSMSP6                  "CCS-MHSA specific category: diagnosis 6"
label var CCSMSP7                  "CCS-MHSA specific category: diagnosis 7"
label var CCSMSP8                  "CCS-MHSA specific category: diagnosis 8"
label var CCSMSP9                  "CCS-MHSA specific category: diagnosis 9"
label var CCSMSP10                 "CCS-MHSA specific category: diagnosis 10"
label var CCSMSP11                 "CCS-MHSA specific category: diagnosis 11"
label var CCSMSP12                 "CCS-MHSA specific category: diagnosis 12"
label var CCSMSP13                 "CCS-MHSA specific category: diagnosis 13"
label var CCSMSP14                 "CCS-MHSA specific category: diagnosis 14"
label var CCSMSP15                 "CCS-MHSA specific category: diagnosis 15"
label var CHRON1                   "Chronic condition indicator 1"
label var CHRON2                   "Chronic condition indicator 2"
label var CHRON3                   "Chronic condition indicator 3"
label var CHRON4                   "Chronic condition indicator 4"
label var CHRON5                   "Chronic condition indicator 5"
label var CHRON6                   "Chronic condition indicator 6"
label var CHRON7                   "Chronic condition indicator 7"
label var CHRON8                   "Chronic condition indicator 8"
label var CHRON9                   "Chronic condition indicator 9"
label var CHRON10                  "Chronic condition indicator 10"
label var CHRON11                  "Chronic condition indicator 11"
label var CHRON12                  "Chronic condition indicator 12"
label var CHRON13                  "Chronic condition indicator 13"
label var CHRON14                  "Chronic condition indicator 14"
label var CHRON15                  "Chronic condition indicator 15"
label var CHRONB1                  "Chronic condition body system 1"
label var CHRONB2                  "Chronic condition body system 2"
label var CHRONB3                  "Chronic condition body system 3"
label var CHRONB4                  "Chronic condition body system 4"
label var CHRONB5                  "Chronic condition body system 5"
label var CHRONB6                  "Chronic condition body system 6"
label var CHRONB7                  "Chronic condition body system 7"
label var CHRONB8                  "Chronic condition body system 8"
label var CHRONB9                  "Chronic condition body system 9"
label var CHRONB10                 "Chronic condition body system 10"
label var CHRONB11                 "Chronic condition body system 11"
label var CHRONB12                 "Chronic condition body system 12"
label var CHRONB13                 "Chronic condition body system 13"
label var CHRONB14                 "Chronic condition body system 14"
label var CHRONB15                 "Chronic condition body system 15"
label var ECCSMGN1                 "CCS-MHSA general category: E Code 1"
label var ECCSMGN2                 "CCS-MHSA general category: E Code 2"
label var ECCSMGN3                 "CCS-MHSA general category: E Code 3"
label var ECCSMGN4                 "CCS-MHSA general category: E Code 4"
label var PCLASS1                  "Principal procedure class"
label var PCLASS2                  "Procedure class 2"
label var PCLASS3                  "Procedure class 3"
label var PCLASS4                  "Procedure class 4"
label var PCLASS5                  "Procedure class 5"
label var PCLASS6                  "Procedure class 6"
label var PCLASS7                  "Procedure class 7"
label var PCLASS8                  "Procedure class 8"
label var PCLASS9                  "Procedure class 9"
label var PCLASS10                 "Procedure class 10"
label var PCLASS11                 "Procedure class 11"
label var PCLASS12                 "Procedure class 12"
label var PCLASS13                 "Procedure class 13"
label var PCLASS14                 "Procedure class 14"
label var PCLASS15                 "Procedure class 15"

*** Convert special values to missing values ***
recode CCSMGN1                   (-99 -88 -66=.)
recode CCSMGN2                   (-99 -88 -66=.)
recode CCSMGN3                   (-99 -88 -66=.)
recode CCSMGN4                   (-99 -88 -66=.)
recode CCSMGN5                   (-99 -88 -66=.)
recode CCSMGN6                   (-99 -88 -66=.)
recode CCSMGN7                   (-99 -88 -66=.)
recode CCSMGN8                   (-99 -88 -66=.)
recode CCSMGN9                   (-99 -88 -66=.)
recode CCSMGN10                  (-99 -88 -66=.)
recode CCSMGN11                  (-99 -88 -66=.)
recode CCSMGN12                  (-99 -88 -66=.)
recode CCSMGN13                  (-99 -88 -66=.)
recode CCSMGN14                  (-99 -88 -66=.)
recode CCSMGN15                  (-99 -88 -66=.)
recode CCSMSP1                   (-999 -888 -666=.)
recode CCSMSP2                   (-999 -888 -666=.)
recode CCSMSP3                   (-999 -888 -666=.)
recode CCSMSP4                   (-999 -888 -666=.)
recode CCSMSP5                   (-999 -888 -666=.)
recode CCSMSP6                   (-999 -888 -666=.)
recode CCSMSP7                   (-999 -888 -666=.)
recode CCSMSP8                   (-999 -888 -666=.)
recode CCSMSP9                   (-999 -888 -666=.)
recode CCSMSP10                  (-999 -888 -666=.)
recode CCSMSP11                  (-999 -888 -666=.)
recode CCSMSP12                  (-999 -888 -666=.)
recode CCSMSP13                  (-999 -888 -666=.)
recode CCSMSP14                  (-999 -888 -666=.)
recode CCSMSP15                  (-999 -888 -666=.)
recode CHRON1                    (-99 -88 -66=.)
recode CHRON2                    (-99 -88 -66=.)
recode CHRON3                    (-99 -88 -66=.)
recode CHRON4                    (-99 -88 -66=.)
recode CHRON5                    (-99 -88 -66=.)
recode CHRON6                    (-99 -88 -66=.)
recode CHRON7                    (-99 -88 -66=.)
recode CHRON8                    (-99 -88 -66=.)
recode CHRON9                    (-99 -88 -66=.)
recode CHRON10                   (-99 -88 -66=.)
recode CHRON11                   (-99 -88 -66=.)
recode CHRON12                   (-99 -88 -66=.)
recode CHRON13                   (-99 -88 -66=.)
recode CHRON14                   (-99 -88 -66=.)
recode CHRON15                   (-99 -88 -66=.)
recode CHRONB1                   (-99 -88 -66=.)
recode CHRONB2                   (-99 -88 -66=.)
recode CHRONB3                   (-99 -88 -66=.)
recode CHRONB4                   (-99 -88 -66=.)
recode CHRONB5                   (-99 -88 -66=.)
recode CHRONB6                   (-99 -88 -66=.)
recode CHRONB7                   (-99 -88 -66=.)
recode CHRONB8                   (-99 -88 -66=.)
recode CHRONB9                   (-99 -88 -66=.)
recode CHRONB10                  (-99 -88 -66=.)
recode CHRONB11                  (-99 -88 -66=.)
recode CHRONB12                  (-99 -88 -66=.)
recode CHRONB13                  (-99 -88 -66=.)
recode CHRONB14                  (-99 -88 -66=.)
recode CHRONB15                  (-99 -88 -66=.)
recode ECCSMGN1                  (-99 -88 -66=.)
recode ECCSMGN2                  (-99 -88 -66=.)
recode ECCSMGN3                  (-99 -88 -66=.)
recode ECCSMGN4                  (-99 -88 -66=.)
recode PCLASS1                   (-99 -88 -66=.)
recode PCLASS2                   (-99 -88 -66=.)
recode PCLASS3                   (-99 -88 -66=.)
recode PCLASS4                   (-99 -88 -66=.)
recode PCLASS5                   (-99 -88 -66=.)
recode PCLASS6                   (-99 -88 -66=.)
recode PCLASS7                   (-99 -88 -66=.)
recode PCLASS8                   (-99 -88 -66=.)
recode PCLASS9                   (-99 -88 -66=.)
recode PCLASS10                  (-99 -88 -66=.)
recode PCLASS11                  (-99 -88 -66=.)
recode PCLASS12                  (-99 -88 -66=.)
recode PCLASS13                  (-99 -88 -66=.)
recode PCLASS14                  (-99 -88 -66=.)
recode PCLASS15                  (-99 -88 -66=.)

save "NIS_2005_Dx_Pr_Grps.dta", replace
