/*******************************************************************
*   SPSSload_NIS_2003_10PCT_SEVERITY_A.SPS:                               
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII NIS            
*      INPATIENT STAY 10PCT_SEVERITY_A FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NIS_2003_10PCT_SEVERITY_A.ASC' FIXED / 
 KEY                  1- 14
 HOSPID              15- 19
 APRDRG              20- 23
 APRDRG_R            24- 25
 APRDRG_S            26- 27
 APSDRG              28- 32
 APSDRG_C            33- 42
 APSDRG_L            43- 52
 APSDRG_M            53- 62
 CM_AIDS             63- 64
 CM_ALCOH            65- 66
 CM_ANEMD            67- 68
 CM_ARTH             69- 70
 CM_BLDLO            71- 72
 CM_CHF              73- 74
 CM_CHRNL            75- 76
 CM_COAG             77- 78
 CM_DEPRE            79- 80
 CM_DM               81- 82
 CM_DMCX             83- 84
 CM_DRUG             85- 86
 CM_HTN_C            87- 88
 CM_HYPOT            89- 90
 CM_LIVER            91- 92
 CM_LYMPH            93- 94
 CM_LYTES            95- 96
 CM_METS             97- 98
 CM_NEURO            99-100
 CM_OBESE           101-102
 CM_PARA            103-104
 CM_PERIV           105-106
 CM_PSYCH           107-108
 CM_PULMC           109-110
 CM_RENLF           111-112
 CM_TUMOR           113-114
 CM_ULCER           115-116
 CM_VALVE           117-118
 CM_WGHTL           119-120
 DS_DX_Ca           121-125 (A)
 DS_LOS_L           126-127
 DS_LOS_S           128-139
 DS_Mrt_L           140-141
 DS_Mrt_S           142-153
 DS_RD_Le           154-155
 DS_RD_Sc           156-167
 DS_Stage           168-172.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 HOSPID              (F4.0) /
 APRDRG              (F3.0) /
 APRDRG_R            (F3.0) /
 APRDRG_S            (F3.0) /
 APSDRG              (F4.0) /
 APSDRG_C            (F6.5) /
 APSDRG_L            (F6.5) /
 APSDRG_M            (F6.5) /
 CM_AIDS             (F3.0) /
 CM_ALCOH            (F3.0) /
 CM_ANEMD            (F3.0) /
 CM_ARTH             (F3.0) /
 CM_BLDLO            (F3.0) /
 CM_CHF              (F3.0) /
 CM_CHRNL            (F3.0) /
 CM_COAG             (F3.0) /
 CM_DEPRE            (F3.0) /
 CM_DM               (F3.0) /
 CM_DMCX             (F3.0) /
 CM_DRUG             (F3.0) /
 CM_HTN_C            (F3.0) /
 CM_HYPOT            (F3.0) /
 CM_LIVER            (F3.0) /
 CM_LYMPH            (F3.0) /
 CM_LYTES            (F3.0) /
 CM_METS             (F3.0) /
 CM_NEURO            (F3.0) /
 CM_OBESE            (F3.0) /
 CM_PARA             (F3.0) /
 CM_PERIV            (F3.0) /
 CM_PSYCH            (F3.0) /
 CM_PULMC            (F3.0) /
 CM_RENLF            (F3.0) /
 CM_TUMOR            (F3.0) /
 CM_ULCER            (F3.0) /
 CM_VALVE            (F3.0) /
 CM_WGHTL            (F3.0) /
 DS_LOS_L            (F3.0) /
 DS_LOS_S            (F8.5) /
 DS_Mrt_L            (F3.0) /
 DS_Mrt_S            (F8.5) /
 DS_RD_Le            (F3.0) /
 DS_RD_Sc            (F8.5) /
 DS_Stage            (F5.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 HOSPID    "HCUP hospital identification number"
 APRDRG    "All Patient Refined DRG"
 APRDRG_R  "All Patient Refined DRG: Risk of Mortality Subclass"
 APRDRG_S  "All Patient Refined DRG: Severity of Illness Subclass"
 APSDRG    "All-Payer Severity-adjusted DRG"
 APSDRG_C  "All-Payer Severity-adjusted DRG: Charge Weight"
 APSDRG_L  "All-Payer Severity-adjusted DRG: Length of Stay Weight"
 APSDRG_M  "All-Payer Severity-adjusted DRG: Mortality Weight"
 CM_AIDS   "AHRQ comorbidity measure: Acquired immune deficiency syndrome"
 CM_ALCOH  "AHRQ comorbidity measure: Alcohol abuse"
 CM_ANEMD  "AHRQ comorbidity measure: Deficiency anemias"
 CM_ARTH   "AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases"
 CM_BLDLO  "AHRQ comorbidity measure: Chronic blood loss anemia"
 CM_CHF    "AHRQ comorbidity measure: Congestive heart failure"
 CM_CHRNL  "AHRQ comorbidity measure: Chronic pulmonary disease"
 CM_COAG   "AHRQ comorbidity measure: Coagulopathy"
 CM_DEPRE  "AHRQ comorbidity measure: Depression"
 CM_DM     "AHRQ comorbidity measure: Diabetes, uncomplicated"
 CM_DMCX   "AHRQ comorbidity measure: Diabetes with chronic complications"
 CM_DRUG   "AHRQ comorbidity measure: Drug abuse"
 CM_HTN_C  "AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)"
 CM_HYPOT  "AHRQ comorbidity measure: Hypothyroidism"
 CM_LIVER  "AHRQ comorbidity measure: Liver disease"
 CM_LYMPH  "AHRQ comorbidity measure: Lymphoma"
 CM_LYTES  "AHRQ comorbidity measure: Fluid and electrolyte disorders"
 CM_METS   "AHRQ comorbidity measure: Metastatic cancer"
 CM_NEURO  "AHRQ comorbidity measure: Other neurological disorders"
 CM_OBESE  "AHRQ comorbidity measure: Obesity"
 CM_PARA   "AHRQ comorbidity measure: Paralysis"
 CM_PERIV  "AHRQ comorbidity measure: Peripheral vascular disorders"
 CM_PSYCH  "AHRQ comorbidity measure: Psychoses"
 CM_PULMC  "AHRQ comorbidity measure: Pulmonary circulation disorders"
 CM_RENLF  "AHRQ comorbidity measure: Renal failure"
 CM_TUMOR  "AHRQ comorbidity measure: Solid tumor without metastasis"
 CM_ULCER  "AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding"
 CM_VALVE  "AHRQ comorbidity measure: Valvular disease"
 CM_WGHTL  "AHRQ comorbidity measure: Weight loss"
 DS_DX_Ca  "Disease Staging: Principal Disease Category"
 DS_LOS_L  "Disease Staging: Length of Stay Level"
 DS_LOS_S  "Disease Staging: Length of Stay Scale"
 DS_Mrt_L  "Disease Staging: Mortality Level"
 DS_Mrt_S  "Disease Staging: Mortality Scale"
 DS_RD_Le  "Disease Staging: Resource Demand Level"
 DS_RD_Sc  "Disease Staging: Resource Demand Scale"
 DS_Stage  "Disease Staging: Principal Stage" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE APRDRG
 (-999,-888,-666,-555=SYSMIS).
RECODE APRDRG_R
 (-9,-8,-6,-5=SYSMIS).
RECODE APRDRG_S
 (-9,-8,-6,-5=SYSMIS).
RECODE APSDRG
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE APSDRG_C
 (-999.99999,-888.88888,-666.66666,-555.55555=SYSMIS).
RECODE APSDRG_L
 (-999.99999,-888.88888,-666.66666,-555.55555=SYSMIS).
RECODE APSDRG_M
 (-999.99999,-888.88888,-666.66666,-555.55555=SYSMIS).
RECODE CM_AIDS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ALCOH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ANEMD
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ARTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_BLDLO
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_CHF
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_CHRNL
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_COAG
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DEPRE
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DM
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DMCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DRUG
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_HTN_C
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_HYPOT
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LIVER
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LYMPH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LYTES
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_METS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_NEURO
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_OBESE
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PARA
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PERIV
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PSYCH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PULMC
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_RENLF
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_TUMOR
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ULCER
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_VALVE
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_WGHTL
 (-9,-8,-6,-5=SYSMIS).
RECODE DS_LOS_L
 (-9,-8,-6,-5=SYSMIS).
RECODE DS_LOS_S
 (-99999.99999,-88888.88888,-66666.66666,-55555.55555=SYSMIS).
RECODE DS_Mrt_L
 (-9,-8,-6,-5=SYSMIS).
RECODE DS_Mrt_S
 (-99999.99999,-88888.88888,-66666.66666,-55555.55555=SYSMIS).
RECODE DS_RD_Le
 (-9,-8,-6,-5=SYSMIS).
RECODE DS_RD_Sc
 (-99999.99999,-88888.88888,-66666.66666,-55555.55555=SYSMIS).
RECODE DS_Stage
 (-9.99,-8.88,-6.66,-5.55=SYSMIS).



SAVE OUTFILE = 'NIS_2003_10PCT_SEVERITY_A.SAV' /COMPRESSED.
