/*******************************************************************
*   SPSSload_NIS_2002_10PCT_SAMPLE_B.SPS:                               
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII NIS            
*      INPATIENT STAY 10PCT_SAMPLE_B FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NIS_2002_10PCT_SAMPLE_B.ASC' FIXED / 
 KEY                  1- 14
 AGE                 15- 17
 AGEDAY              18- 20
 AMONTH              21- 22
 ASOURCE             23- 24
 ASOURCE_            25- 32 (A)
 ATYPE               33- 34
 AWEEKEND            35- 36
 DIED                37- 38
 DISCWT10            39- 48
 DISPUB92            49- 50
 DISPUNIF            51- 52
 DQTR                53- 54
 DRG                 55- 57
 DRG18               58- 60
 DRGVER              61- 62
 DSHOSPID            63- 75 (A)
 DX1                 76- 80 (A)
 DX2                 81- 85 (A)
 DX3                 86- 90 (A)
 DX4                 91- 95 (A)
 DX5                 96-100 (A)
 DX6                101-105 (A)
 DX7                106-110 (A)
 DX8                111-115 (A)
 DX9                116-120 (A)
 DX10               121-125 (A)
 DX11               126-130 (A)
 DX12               131-135 (A)
 DX13               136-140 (A)
 DX14               141-145 (A)
 DX15               146-150 (A)
 DXCCS1             151-154
 DXCCS2             155-158
 DXCCS3             159-162
 DXCCS4             163-166
 DXCCS5             167-170
 DXCCS6             171-174
 DXCCS7             175-178
 DXCCS8             179-182
 DXCCS9             183-186
 DXCCS10            187-190
 DXCCS11            191-194
 DXCCS12            195-198
 DXCCS13            199-202
 DXCCS14            203-206
 DXCCS15            207-210
 ELECTIVE           211-212
 FEMALE             213-214
 HOSPID             215-219
 HOSPST             220-221 (A)
 HOSPSTCO           222-226
 LOS                227-231
 LOS_X              232-237
 MDC                238-239
 MDC18              240-241
 MDNUM1_S           242-257 (A)
 MDNUM2_S           258-273 (A)
 NDX                274-275
 NEOMAT             276-277
 NIS_STRA           278-281
 NPR                282-283
 PAY1               284-285
 PAY1_X             286-295 (A)
 PAY2               296-297
 PAY2_X             298-307 (A)
 PR1                308-311 (A)
 PR2                312-315 (A)
 PR3                316-319 (A)
 PR4                320-323 (A)
 PR5                324-327 (A)
 PR6                328-331 (A)
 PR7                332-335 (A)
 PR8                336-339 (A)
 PR9                340-343 (A)
 PR10               344-347 (A)
 PR11               348-351 (A)
 PR12               352-355 (A)
 PR13               356-359 (A)
 PR14               360-363 (A)
 PR15               364-367 (A)
 PRCCS1             368-370
 PRCCS2             371-373
 PRCCS3             374-376
 PRCCS4             377-379
 PRCCS5             380-382
 PRCCS6             383-385
 PRCCS7             386-388
 PRCCS8             389-391
 PRCCS9             392-394
 PRCCS10            395-397
 PRCCS11            398-400
 PRCCS12            401-403
 PRCCS13            404-406
 PRCCS14            407-409
 PRCCS15            410-412
 PRDAY1             413-415
 PRDAY2             416-418
 PRDAY3             419-421
 PRDAY4             422-424
 PRDAY5             425-427
 PRDAY6             428-430
 PRDAY7             431-433
 PRDAY8             434-436
 PRDAY9             437-439
 PRDAY10            440-442
 PRDAY11            443-445
 PRDAY12            446-448
 PRDAY13            449-451
 PRDAY14            452-454
 PRDAY15            455-457
 RACE               458-459
 TOTCHG             460-469
 TOTCHG_X           470-484
 YEAR               485-488
 ZIPINC             489-490.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISCWT10            (F8.4) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DRG                 (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 DXCCS13             (F4.0) /
 DXCCS14             (F4.0) /
 DXCCS15             (F4.0) /
 ELECTIVE            (F3.0) /
 FEMALE              (F3.0) /
 HOSPID              (F4.0) /
 HOSPSTCO            (F4.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC18               (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NIS_STRA            (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRCCS11             (F3.0) /
 PRCCS12             (F3.0) /
 PRCCS13             (F3.0) /
 PRCCS14             (F3.0) /
 PRCCS15             (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PRDAY11             (F4.0) /
 PRDAY12             (F4.0) /
 PRDAY13             (F4.0) /
 PRDAY14             (F4.0) /
 PRDAY15             (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 ZIPINC              (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISCWT10  "10% subsample weight to discharges in AHA universe"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRGVER    "DRG grouper version used on discharge date"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 ELECTIVE  "Elective versus non-elective admission"
 FEMALE    "Indicator of sex"
 HOSPID    "HCUP hospital identification number"
 HOSPST    "Hospital state postal code"
 HOSPSTCO  "Hospital modified FIPS state/county code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 MDNUM1_S  "Physician 1 number (synthetic)"
 MDNUM2_S  "Physician 2 number (synthetic)"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NIS_STRA  "Stratum used to sample hospital"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2      "Secondary expected payer (uniform)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 RACE      "Race (uniform)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC    "Median household income category for patient's ZIP Code" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISCWT10
 (-9999.9999,-8888.8888,-6666.6666,-5555.5555=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE ELECTIVE
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NIS_STRA
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NIS_2002_10PCT_SAMPLE_B.SAV' /COMPRESSED.
