/*****************************************************************************
* SPSSload_NIS_1996_Supplemental.SPS
* This program will load the 1996 NIS ASCII Supplemental File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_1996_Supplemental.ASC' FIXED / 
    TRENDWT                    1- 11
    SEQ                       12- 24
    AWEEKEND                  25- 26
    DISPUNIFORM               27- 28
    FEMALE                    29- 30
    PRCCS1                    31- 33
    PRCCS2                    34- 36
    PRCCS3                    37- 39
    PRCCS4                    40- 42
    PRCCS5                    43- 45
    PRCCS6                    46- 48
    PRCCS7                    49- 51
    PRCCS8                    52- 54
    PRCCS9                    55- 57
    PRCCS10                   58- 60
    PRCCS11                   61- 63
    PRCCS12                   64- 66
    PRCCS13                   67- 69
    PRCCS14                   70- 72
    PRCCS15                   73- 75
    NIS_STRATUM               76- 79
    TOTAL_DISC                80- 85
    HOSP_BEDSIZE              86- 87
    HOSP_CONTROL              88- 89
    HOSP_LOCATION             90- 91
    HOSP_LOCTEACH             92- 93
    HOSP_REGION               94- 95
    HOSP_TEACH                96- 97
    NDX                       98- 99
    DXCCS1                   100-102
    DXCCS2                   103-105
    DXCCS3                   106-108
    DXCCS4                   109-111
    DXCCS5                   112-114
    DXCCS6                   115-117
    DXCCS7                   118-120
    DXCCS8                   121-123
    DXCCS9                   124-126
    DXCCS10                  127-129
    DXCCS11                  130-132
    DXCCS12                  133-135
    DXCCS13                  136-138
    DXCCS14                  139-141
    DXCCS15                  142-144
    E_CCS1                   145-148
    E_CCS2                   149-152
    E_CCS3                   153-156
    E_CCS4                   157-160
    ELECTIVE                 161-162
    NECODE                   163-165
    DX1                      166-170 (A)
    DX2                      171-175 (A)
    DX3                      176-180 (A)
    DX4                      181-185 (A)
    DX5                      186-190 (A)
    DX6                      191-195 (A)
    DX7                      196-200 (A)
    DX8                      201-205 (A)
    DX9                      206-210 (A)
    DX10                     211-215 (A)
    DX11                     216-220 (A)
    DX12                     221-225 (A)
    DX13                     226-230 (A)
    DX14                     231-235 (A)
    DX15                     236-240 (A)
    PR1                      241-244 (A)
    PR2                      245-248 (A)
    PR3                      249-252 (A)
    PR4                      253-256 (A)
    PR5                      257-260 (A)
    PR6                      261-264 (A)
    PR7                      265-268 (A)
    PR8                      269-272 (A)
    PR9                      273-276 (A)
    PR10                     277-280 (A)
    PR11                     281-284 (A)
    PR12                     285-288 (A)
    PR13                     289-292 (A)
    PR14                     293-296 (A)
    PR15                     297-300 (A)
    ECODE1                   301-305 (A)
    ECODE2                   306-310 (A)
    ECODE3                   311-315 (A)
    ECODE4                   316-320 (A)
    MDNUM1_S                 321-336 (A)
    MDNUM2_S                 337-352 (A).

***  Specify write formats  ***.
FORMATS
    TRENDWT                  (F11.7) /
    SEQ                      (F13.0) /
    AWEEKEND                 (F2.0) /
    DISPUNIFORM              (F2.0) /
    FEMALE                   (F2.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    NIS_STRATUM              (F4.0) /
    TOTAL_DISC               (F6.0) /
    HOSP_BEDSIZE             (F2.0) /
    HOSP_CONTROL             (F2.0) /
    HOSP_LOCATION            (F2.0) /
    HOSP_LOCTEACH            (F2.0) /
    HOSP_REGION              (F2.0) /
    HOSP_TEACH               (F2.0) /
    NDX                      (F2.0) /
    DXCCS1                   (F3.0) /
    DXCCS2                   (F3.0) /
    DXCCS3                   (F3.0) /
    DXCCS4                   (F3.0) /
    DXCCS5                   (F3.0) /
    DXCCS6                   (F3.0) /
    DXCCS7                   (F3.0) /
    DXCCS8                   (F3.0) /
    DXCCS9                   (F3.0) /
    DXCCS10                  (F3.0) /
    DXCCS11                  (F3.0) /
    DXCCS12                  (F3.0) /
    DXCCS13                  (F3.0) /
    DXCCS14                  (F3.0) /
    DXCCS15                  (F3.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    ELECTIVE                 (F2.0) /
    NECODE                   (F3.0) /
.

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    TRENDWT                  "Trend weight to discharges in the universe"
    SEQ                      "I:HCUP-3 record sequence number"
    AWEEKEND                 "Admission day is a weekend"
    DISPUNIFORM              "Disposition of patient (uniform)"
    FEMALE                   "Indicator of sex"
    PRCCS1                   "CCS: principal procedure"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    NIS_STRATUM              "H:Stratum used to post-stratify hospital"
    TOTAL_DISC               "H:Total hospital discharges"
    HOSP_BEDSIZE             "Bed size of hospital"
    HOSP_CONTROL             "Control/ownership of hospital"
    HOSP_LOCATION            "Location (urban/rural) of hospital"
    HOSP_LOCTEACH            "Location/teaching status of hospital"
    HOSP_REGION              "Region of hospital"
    HOSP_TEACH               "Teaching status of hospital"
    NDX                      "I:Number of diagnoses on this discharge"
    DXCCS1                   "CCS: principal diagnosis"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    NECODE                   "Number of E codes on this record"
    DX1                      "I:Principal diagnosis"
    DX2                      "I:Diagnosis 2"
    DX3                      "I:Diagnosis 3"
    DX4                      "I:Diagnosis 4"
    DX5                      "I:Diagnosis 5"
    DX6                      "I:Diagnosis 6"
    DX7                      "I:Diagnosis 7"
    DX8                      "I:Diagnosis 8"
    DX9                      "I:Diagnosis 9"
    DX10                     "I:Diagnosis 10"
    DX11                     "I:Diagnosis 11"
    DX12                     "I:Diagnosis 12"
    DX13                     "I:Diagnosis 13"
    DX14                     "I:Diagnosis 14"
    DX15                     "I:Diagnosis 15"
    PR1                      "I:Principal procedure"
    PR2                      "I:Procedure 2"
    PR3                      "I:Procedure 3"
    PR4                      "I:Procedure 4"
    PR5                      "I:Procedure 5"
    PR6                      "I:Procedure 6"
    PR7                      "I:Procedure 7"
    PR8                      "I:Procedure 8"
    PR9                      "I:Procedure 9"
    PR10                     "I:Procedure 10"
    PR11                     "I:Procedure 11"
    PR12                     "I:Procedure 12"
    PR13                     "I:Procedure 13"
    PR14                     "I:Procedure 14"
    PR15                     "I:Procedure 15"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    MDNUM1_S                 "Physician 1 number (synthetic)"
    MDNUM2_S                 "Physician 2 number (synthetic)" .

*** Convert special values to system missing values ***.
RECODE TRENDWT                  (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE SEQ                      (-999999999999 -888888888888 -666666666666=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE TOTAL_DISC               (-99999 -88888 -66666=SYSMIS).
RECODE HOSP_BEDSIZE             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_CONTROL             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCATION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCTEACH            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_TEACH               (-9 -8 -6 -5=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE DXCCS1                   (-99 -88 -66=SYSMIS).
RECODE DXCCS2                   (-99 -88 -66=SYSMIS).
RECODE DXCCS3                   (-99 -88 -66=SYSMIS).
RECODE DXCCS4                   (-99 -88 -66=SYSMIS).
RECODE DXCCS5                   (-99 -88 -66=SYSMIS).
RECODE DXCCS6                   (-99 -88 -66=SYSMIS).
RECODE DXCCS7                   (-99 -88 -66=SYSMIS).
RECODE DXCCS8                   (-99 -88 -66=SYSMIS).
RECODE DXCCS9                   (-99 -88 -66=SYSMIS).
RECODE DXCCS10                  (-99 -88 -66=SYSMIS).
RECODE DXCCS11                  (-99 -88 -66=SYSMIS).
RECODE DXCCS12                  (-99 -88 -66=SYSMIS).
RECODE DXCCS13                  (-99 -88 -66=SYSMIS).
RECODE DXCCS14                  (-99 -88 -66=SYSMIS).
RECODE DXCCS15                  (-99 -88 -66=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NIS_1996_Supplemental.SAV' / COMPRESSED.
