/*****************************************************************************
* SPSSload_NIS_2023_Hospital.SPS
* This program will load the NIS_2023_Hospital ASCII File into SPSS.
* Created on 12/10/2025.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2023_Hospital.ASC' FIXED / 
    HOSP_NIS                    1-   5
    NIS_STRATUM                 6-   9
    DISCWT                     10-  20
    HOSP_BEDSIZE               21-  22
    HOSP_LOCTEACH              23-  24
    H_CONTRL                   25-  26
    N_DISC_U                   27-  34
    N_HOSP_U                   35-  38
    S_DISC_U                   39-  46
    S_HOSP_U                   47-  50
    TOTAL_DISC                 51-  56
    YEAR                       57-  60.

***  Specify write formats  ***.
FORMATS
    HOSP_NIS                 (F5.0) /
    NIS_STRATUM              (F4.0) /
    DISCWT                   (F11.7) /
    HOSP_BEDSIZE             (F2.0) /
    HOSP_LOCTEACH            (F2.0) /
    H_CONTRL                 (F2.0) /
    N_DISC_U                 (F8.0) /
    N_HOSP_U                 (F4.0) /
    S_DISC_U                 (F8.0) /
    S_HOSP_U                 (F4.0) /
    TOTAL_DISC               (F6.0) /
    YEAR                     (F4.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_NIS                 "NIS hospital number"
    NIS_STRATUM              "NIS hospital stratum"
    DISCWT                   "NIS discharge weight"
    HOSP_BEDSIZE             "Relative bed size category of hospital (original)"
    HOSP_LOCTEACH            "Location/teaching status of hospital (original)"
    H_CONTRL                 "Control/ownership of hospital (original)"
    N_DISC_U                 "Number of universe discharges in the stratum"
    N_HOSP_U                 "Number of universe hospitals in the stratum"
    S_DISC_U                 "Number of sample discharges in the stratum"
    S_HOSP_U                 "Number of sample hospitals in the stratum"
    TOTAL_DISC               "Total number of discharges from this hospital in the NIS"
    YEAR                     "Calendar year" .

*** Convert special values to system missing values ***.
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSP_BEDSIZE             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCTEACH            (-9 -8 -6 -5=SYSMIS).
RECODE H_CONTRL                 (-9 -8 -6 -5=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE TOTAL_DISC               (-99999 -88888 -66666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NIS_2023_Hospital.SAV' / COMPRESSED.
