/*****************************************************************************
* SPSSload_NIS_2023_Core.SPS
* This program will load the NIS_2023_Core ASCII File into SPSS.
* Created on 12/10/2025.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2023_Core.ASC' FIXED / 
    HOSP_NIS                    1-   5
    KEY_NIS                     6-  15
    NIS_STRATUM                16-  19
    AGE                        20-  22
    AGE_NEONATE                23-  24
    AMONTH                     25-  26
    AWEEKEND                   27-  28
    DIED                       29-  30
    DISCWT                     31-  41
    DISPUNIFORM                42-  43
    DQTR                       44-  45
    DRG                        46-  48
    DRGVER                     49-  50
    DRG_NoPOA                  51-  53
    ELECTIVE                   54-  55
    FEMALE                     56-  57
    HCUP_ED                    58-  60
    I10_BIRTH                  61-  63
    I10_DELIVERY               64-  66
    I10_DX1                    67-  73 (A)
    I10_DX2                    74-  80 (A)
    I10_DX3                    81-  87 (A)
    I10_DX4                    88-  94 (A)
    I10_DX5                    95- 101 (A)
    I10_DX6                   102- 108 (A)
    I10_DX7                   109- 115 (A)
    I10_DX8                   116- 122 (A)
    I10_DX9                   123- 129 (A)
    I10_DX10                  130- 136 (A)
    I10_DX11                  137- 143 (A)
    I10_DX12                  144- 150 (A)
    I10_DX13                  151- 157 (A)
    I10_DX14                  158- 164 (A)
    I10_DX15                  165- 171 (A)
    I10_DX16                  172- 178 (A)
    I10_DX17                  179- 185 (A)
    I10_DX18                  186- 192 (A)
    I10_DX19                  193- 199 (A)
    I10_DX20                  200- 206 (A)
    I10_DX21                  207- 213 (A)
    I10_DX22                  214- 220 (A)
    I10_DX23                  221- 227 (A)
    I10_DX24                  228- 234 (A)
    I10_DX25                  235- 241 (A)
    I10_DX26                  242- 248 (A)
    I10_DX27                  249- 255 (A)
    I10_DX28                  256- 262 (A)
    I10_DX29                  263- 269 (A)
    I10_DX30                  270- 276 (A)
    I10_DX31                  277- 283 (A)
    I10_DX32                  284- 290 (A)
    I10_DX33                  291- 297 (A)
    I10_DX34                  298- 304 (A)
    I10_DX35                  305- 311 (A)
    I10_DX36                  312- 318 (A)
    I10_DX37                  319- 325 (A)
    I10_DX38                  326- 332 (A)
    I10_DX39                  333- 339 (A)
    I10_DX40                  340- 346 (A)
    I10_INJURY                347- 348
    I10_MULTINJURY            349- 350
    I10_NDX                   351- 352
    I10_NPR                   353- 354
    I10_PR1                   355- 361 (A)
    I10_PR2                   362- 368 (A)
    I10_PR3                   369- 375 (A)
    I10_PR4                   376- 382 (A)
    I10_PR5                   383- 389 (A)
    I10_PR6                   390- 396 (A)
    I10_PR7                   397- 403 (A)
    I10_PR8                   404- 410 (A)
    I10_PR9                   411- 417 (A)
    I10_PR10                  418- 424 (A)
    I10_PR11                  425- 431 (A)
    I10_PR12                  432- 438 (A)
    I10_PR13                  439- 445 (A)
    I10_PR14                  446- 452 (A)
    I10_PR15                  453- 459 (A)
    I10_PR16                  460- 466 (A)
    I10_PR17                  467- 473 (A)
    I10_PR18                  474- 480 (A)
    I10_PR19                  481- 487 (A)
    I10_PR20                  488- 494 (A)
    I10_PR21                  495- 501 (A)
    I10_PR22                  502- 508 (A)
    I10_PR23                  509- 515 (A)
    I10_PR24                  516- 522 (A)
    I10_PR25                  523- 529 (A)
    I10_SERVICELINE           530- 532
    LOS                       533- 537
    MDC                       538- 539
    MDC_NoPOA                 540- 541
    PAY1                      542- 543
    PCLASS_ORPROC             544- 545
    PRDAY1                    546- 548
    PRDAY2                    549- 551
    PRDAY3                    552- 554
    PRDAY4                    555- 557
    PRDAY5                    558- 560
    PRDAY6                    561- 563
    PRDAY7                    564- 566
    PRDAY8                    567- 569
    PRDAY9                    570- 572
    PRDAY10                   573- 575
    PRDAY11                   576- 578
    PRDAY12                   579- 581
    PRDAY13                   582- 584
    PRDAY14                   585- 587
    PRDAY15                   588- 590
    PRDAY16                   591- 593
    PRDAY17                   594- 596
    PRDAY18                   597- 599
    PRDAY19                   600- 602
    PRDAY20                   603- 605
    PRDAY21                   606- 608
    PRDAY22                   609- 611
    PRDAY23                   612- 614
    PRDAY24                   615- 617
    PRDAY25                   618- 620
    TRAN_IN                   621- 622
    TRAN_OUT                  623- 624
    YEAR                      625- 628
    ZIPINC_QRTL               629- 630
    TOTCHG_2023               631- 640
    PL_NCHS2                  641- 643.

***  Specify write formats  ***.
FORMATS
    HOSP_NIS                 (F5.0) /
    KEY_NIS                  (F10.0) /
    NIS_STRATUM              (F4.0) /
    AGE                      (F3.0) /
    AGE_NEONATE              (F2.0) /
    AMONTH                   (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DRG                      (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    ELECTIVE                 (F2.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    I10_BIRTH                (F3.0) /
    I10_DELIVERY             (F3.0) /
    I10_INJURY               (F2.0) /
    I10_MULTINJURY           (F2.0) /
    I10_NDX                  (F2.0) /
    I10_NPR                  (F2.0) /
    I10_SERVICELINE          (F3.0) /
    LOS                      (F5.0) /
    MDC                      (F2.0) /
    MDC_NoPOA                (F2.0) /
    PAY1                     (F2.0) /
    PCLASS_ORPROC            (F2.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    PRDAY16                  (F3.0) /
    PRDAY17                  (F3.0) /
    PRDAY18                  (F3.0) /
    PRDAY19                  (F3.0) /
    PRDAY20                  (F3.0) /
    PRDAY21                  (F3.0) /
    PRDAY22                  (F3.0) /
    PRDAY23                  (F3.0) /
    PRDAY24                  (F3.0) /
    PRDAY25                  (F3.0) /
    TRAN_IN                  (F2.0) /
    TRAN_OUT                 (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) /
    TOTCHG_2023              (F10.0) /
    PL_NCHS2                 (F3.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_NIS                 "NIS hospital number"
    KEY_NIS                  "NIS record number"
    NIS_STRATUM              "NIS hospital stratum"
    AGE                      "Age in years at admission"
    AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "NIS discharge weight"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    ELECTIVE                 "Elective versus non-elective admission"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    I10_BIRTH                "ICD-10-CM Birth Indicator"
    I10_DELIVERY             "ICD-10-CM Delivery Indicator"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_DX31                 "ICD-10-CM Diagnosis 31"
    I10_DX32                 "ICD-10-CM Diagnosis 32"
    I10_DX33                 "ICD-10-CM Diagnosis 33"
    I10_DX34                 "ICD-10-CM Diagnosis 34"
    I10_DX35                 "ICD-10-CM Diagnosis 35"
    I10_DX36                 "ICD-10-CM Diagnosis 36"
    I10_DX37                 "ICD-10-CM Diagnosis 37"
    I10_DX38                 "ICD-10-CM Diagnosis 38"
    I10_DX39                 "ICD-10-CM Diagnosis 39"
    I10_DX40                 "ICD-10-CM Diagnosis 40"
    I10_INJURY
    "Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)"
    I10_MULTINJURY           "Multiple ICD-10-CM injuries reported on record"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NPR                  "ICD-10-PCS Number of procedures on this record"
    I10_PR1                  "ICD-10-PCS Procedure 1"
    I10_PR2                  "ICD-10-PCS Procedure 2"
    I10_PR3                  "ICD-10-PCS Procedure 3"
    I10_PR4                  "ICD-10-PCS Procedure 4"
    I10_PR5                  "ICD-10-PCS Procedure 5"
    I10_PR6                  "ICD-10-PCS Procedure 6"
    I10_PR7                  "ICD-10-PCS Procedure 7"
    I10_PR8                  "ICD-10-PCS Procedure 8"
    I10_PR9                  "ICD-10-PCS Procedure 9"
    I10_PR10                 "ICD-10-PCS Procedure 10"
    I10_PR11                 "ICD-10-PCS Procedure 11"
    I10_PR12                 "ICD-10-PCS Procedure 12"
    I10_PR13                 "ICD-10-PCS Procedure 13"
    I10_PR14                 "ICD-10-PCS Procedure 14"
    I10_PR15                 "ICD-10-PCS Procedure 15"
    I10_PR16                 "ICD-10-PCS Procedure 16"
    I10_PR17                 "ICD-10-PCS Procedure 17"
    I10_PR18                 "ICD-10-PCS Procedure 18"
    I10_PR19                 "ICD-10-PCS Procedure 19"
    I10_PR20                 "ICD-10-PCS Procedure 20"
    I10_PR21                 "ICD-10-PCS Procedure 21"
    I10_PR22                 "ICD-10-PCS Procedure 22"
    I10_PR23                 "ICD-10-PCS Procedure 23"
    I10_PR24                 "ICD-10-PCS Procedure 24"
    I10_PR25                 "ICD-10-PCS Procedure 25"
    I10_SERVICELINE          "ICD-10-CM/PCS Hospital Service Line"
    LOS                      "Length of stay (cleaned)"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    PAY1                     "Primary expected payer (uniform)"
    PCLASS_ORPROC            "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
    PRDAY1                   "Number of days from admission to I10_PR1"
    PRDAY2                   "Number of days from admission to I10_PR2"
    PRDAY3                   "Number of days from admission to I10_PR3"
    PRDAY4                   "Number of days from admission to I10_PR4"
    PRDAY5                   "Number of days from admission to I10_PR5"
    PRDAY6                   "Number of days from admission to I10_PR6"
    PRDAY7                   "Number of days from admission to I10_PR7"
    PRDAY8                   "Number of days from admission to I10_PR8"
    PRDAY9                   "Number of days from admission to I10_PR9"
    PRDAY10                  "Number of days from admission to I10_PR10"
    PRDAY11                  "Number of days from admission to I10_PR11"
    PRDAY12                  "Number of days from admission to I10_PR12"
    PRDAY13                  "Number of days from admission to I10_PR13"
    PRDAY14                  "Number of days from admission to I10_PR14"
    PRDAY15                  "Number of days from admission to I10_PR15"
    PRDAY16                  "Number of days from admission to I10_PR16"
    PRDAY17                  "Number of days from admission to I10_PR17"
    PRDAY18                  "Number of days from admission to I10_PR18"
    PRDAY19                  "Number of days from admission to I10_PR19"
    PRDAY20                  "Number of days from admission to I10_PR20"
    PRDAY21                  "Number of days from admission to I10_PR21"
    PRDAY22                  "Number of days from admission to I10_PR22"
    PRDAY23                  "Number of days from admission to I10_PR23"
    PRDAY24                  "Number of days from admission to I10_PR24"
    PRDAY25                  "Number of days from admission to I10_PR25"
    TRAN_IN                  "Transfer in indicator"
    TRAN_OUT                 "Transfer out indicator"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
    TOTCHG_2023              "Total charges adjusted for national estimates"
    PL_NCHS2                 "Patient Location: NCHS Urban-Rural Code (collapsed)" .

*** Convert special values to system missing values ***.
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGE_NEONATE              (-9 -8 -6 -5=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE I10_BIRTH                (-99 -88 -66=SYSMIS).
RECODE I10_DELIVERY             (-99 -88 -66=SYSMIS).
RECODE I10_INJURY               (-9 -8 -6 -5=SYSMIS).
RECODE I10_MULTINJURY           (-9 -8 -6 -5=SYSMIS).
RECODE I10_NDX                  (-9 -8 -6 -5=SYSMIS).
RECODE I10_NPR                  (-9 -8 -6 -5=SYSMIS).
RECODE I10_SERVICELINE          (-99 -88 -66=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PCLASS_ORPROC            (-9 -8 -6 -5=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY16                  (-99 -88 -66=SYSMIS).
RECODE PRDAY17                  (-99 -88 -66=SYSMIS).
RECODE PRDAY18                  (-99 -88 -66=SYSMIS).
RECODE PRDAY19                  (-99 -88 -66=SYSMIS).
RECODE PRDAY20                  (-99 -88 -66=SYSMIS).
RECODE PRDAY21                  (-99 -88 -66=SYSMIS).
RECODE PRDAY22                  (-99 -88 -66=SYSMIS).
RECODE PRDAY23                  (-99 -88 -66=SYSMIS).
RECODE PRDAY24                  (-99 -88 -66=SYSMIS).
RECODE PRDAY25                  (-99 -88 -66=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE TRAN_OUT                 (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG_2023              (-999999999 -888888888 -666666666=SYSMIS).
RECODE PL_NCHS2                 (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NIS_2023_Core.SAV' / COMPRESSED.
