/*****************************************************************************
* SPSSload_NIS_2018_Core.SPS
* This program will load the NIS_2018_Core ASCII File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2018_Core.ASC' FIXED / 
    AGE                        1-  3
    AGE_NEONATE                4-  5
    AMONTH                     6-  7
    AWEEKEND                   8-  9
    DIED                      10- 11
    DISCWT                    12- 22
    DISPUNIFORM               23- 24
    DQTR                      25- 26
    DRG                       27- 29
    DRGVER                    30- 31
    DRG_NoPOA                 32- 34
    ELECTIVE                  35- 36
    FEMALE                    37- 38
    HCUP_ED                   39- 41
    HOSP_DIVISION             42- 43
    HOSP_NIS                  44- 48
    I10_DX1                   49- 55 (A)
    I10_DX2                   56- 62 (A)
    I10_DX3                   63- 69 (A)
    I10_DX4                   70- 76 (A)
    I10_DX5                   77- 83 (A)
    I10_DX6                   84- 90 (A)
    I10_DX7                   91- 97 (A)
    I10_DX8                   98-104 (A)
    I10_DX9                  105-111 (A)
    I10_DX10                 112-118 (A)
    I10_DX11                 119-125 (A)
    I10_DX12                 126-132 (A)
    I10_DX13                 133-139 (A)
    I10_DX14                 140-146 (A)
    I10_DX15                 147-153 (A)
    I10_DX16                 154-160 (A)
    I10_DX17                 161-167 (A)
    I10_DX18                 168-174 (A)
    I10_DX19                 175-181 (A)
    I10_DX20                 182-188 (A)
    I10_DX21                 189-195 (A)
    I10_DX22                 196-202 (A)
    I10_DX23                 203-209 (A)
    I10_DX24                 210-216 (A)
    I10_DX25                 217-223 (A)
    I10_DX26                 224-230 (A)
    I10_DX27                 231-237 (A)
    I10_DX28                 238-244 (A)
    I10_DX29                 245-251 (A)
    I10_DX30                 252-258 (A)
    I10_DX31                 259-265 (A)
    I10_DX32                 266-272 (A)
    I10_DX33                 273-279 (A)
    I10_DX34                 280-286 (A)
    I10_DX35                 287-293 (A)
    I10_DX36                 294-300 (A)
    I10_DX37                 301-307 (A)
    I10_DX38                 308-314 (A)
    I10_DX39                 315-321 (A)
    I10_DX40                 322-328 (A)
    I10_NDX                  329-330
    I10_NPR                  331-332
    I10_PR1                  333-339 (A)
    I10_PR2                  340-346 (A)
    I10_PR3                  347-353 (A)
    I10_PR4                  354-360 (A)
    I10_PR5                  361-367 (A)
    I10_PR6                  368-374 (A)
    I10_PR7                  375-381 (A)
    I10_PR8                  382-388 (A)
    I10_PR9                  389-395 (A)
    I10_PR10                 396-402 (A)
    I10_PR11                 403-409 (A)
    I10_PR12                 410-416 (A)
    I10_PR13                 417-423 (A)
    I10_PR14                 424-430 (A)
    I10_PR15                 431-437 (A)
    I10_PR16                 438-444 (A)
    I10_PR17                 445-451 (A)
    I10_PR18                 452-458 (A)
    I10_PR19                 459-465 (A)
    I10_PR20                 466-472 (A)
    I10_PR21                 473-479 (A)
    I10_PR22                 480-486 (A)
    I10_PR23                 487-493 (A)
    I10_PR24                 494-500 (A)
    I10_PR25                 501-507 (A)
    KEY_NIS                  508-517
    LOS                      518-522
    MDC                      523-524
    MDC_NoPOA                525-526
    NIS_STRATUM              527-530
    PAY1                     531-532
    PL_NCHS                  533-535
    PRDAY1                   536-538
    PRDAY2                   539-541
    PRDAY3                   542-544
    PRDAY4                   545-547
    PRDAY5                   548-550
    PRDAY6                   551-553
    PRDAY7                   554-556
    PRDAY8                   557-559
    PRDAY9                   560-562
    PRDAY10                  563-565
    PRDAY11                  566-568
    PRDAY12                  569-571
    PRDAY13                  572-574
    PRDAY14                  575-577
    PRDAY15                  578-580
    PRDAY16                  581-583
    PRDAY17                  584-586
    PRDAY18                  587-589
    PRDAY19                  590-592
    PRDAY20                  593-595
    PRDAY21                  596-598
    PRDAY22                  599-601
    PRDAY23                  602-604
    PRDAY24                  605-607
    PRDAY25                  608-610
    RACE                     611-612
    TOTCHG                   613-622
    TRAN_IN                  623-624
    TRAN_OUT                 625-626
    YEAR                     627-630
    ZIPINC_QRTL              631-632.

***  Specify write formats  ***.
FORMATS
    AGE                      (F3.0) /
    AGE_NEONATE              (F2.0) /
    AMONTH                   (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DRG                      (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    ELECTIVE                 (F2.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSP_DIVISION            (F2.0) /
    HOSP_NIS                 (F5.0) /
    I10_NDX                  (F2.0) /
    I10_NPR                  (F2.0) /
    KEY_NIS                  (F10.0) /
    LOS                      (F5.0) /
    MDC                      (F2.0) /
    MDC_NoPOA                (F2.0) /
    NIS_STRATUM              (F4.0) /
    PAY1                     (F2.0) /
    PL_NCHS                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    PRDAY16                  (F3.0) /
    PRDAY17                  (F3.0) /
    PRDAY18                  (F3.0) /
    PRDAY19                  (F3.0) /
    PRDAY20                  (F3.0) /
    PRDAY21                  (F3.0) /
    PRDAY22                  (F3.0) /
    PRDAY23                  (F3.0) /
    PRDAY24                  (F3.0) /
    PRDAY25                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TRAN_IN                  (F2.0) /
    TRAN_OUT                 (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "NIS discharge weight"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    ELECTIVE                 "Elective versus non-elective admission"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSP_DIVISION            "Census Division of hospital"
    HOSP_NIS                 "NIS hospital number"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_DX31                 "ICD-10-CM Diagnosis 31"
    I10_DX32                 "ICD-10-CM Diagnosis 32"
    I10_DX33                 "ICD-10-CM Diagnosis 33"
    I10_DX34                 "ICD-10-CM Diagnosis 34"
    I10_DX35                 "ICD-10-CM Diagnosis 35"
    I10_DX36                 "ICD-10-CM Diagnosis 36"
    I10_DX37                 "ICD-10-CM Diagnosis 37"
    I10_DX38                 "ICD-10-CM Diagnosis 38"
    I10_DX39                 "ICD-10-CM Diagnosis 39"
    I10_DX40                 "ICD-10-CM Diagnosis 40"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NPR                  "ICD-10-PCS Number of procedures on this record"
    I10_PR1                  "ICD-10-PCS Procedure 1"
    I10_PR2                  "ICD-10-PCS Procedure 2"
    I10_PR3                  "ICD-10-PCS Procedure 3"
    I10_PR4                  "ICD-10-PCS Procedure 4"
    I10_PR5                  "ICD-10-PCS Procedure 5"
    I10_PR6                  "ICD-10-PCS Procedure 6"
    I10_PR7                  "ICD-10-PCS Procedure 7"
    I10_PR8                  "ICD-10-PCS Procedure 8"
    I10_PR9                  "ICD-10-PCS Procedure 9"
    I10_PR10                 "ICD-10-PCS Procedure 10"
    I10_PR11                 "ICD-10-PCS Procedure 11"
    I10_PR12                 "ICD-10-PCS Procedure 12"
    I10_PR13                 "ICD-10-PCS Procedure 13"
    I10_PR14                 "ICD-10-PCS Procedure 14"
    I10_PR15                 "ICD-10-PCS Procedure 15"
    I10_PR16                 "ICD-10-PCS Procedure 16"
    I10_PR17                 "ICD-10-PCS Procedure 17"
    I10_PR18                 "ICD-10-PCS Procedure 18"
    I10_PR19                 "ICD-10-PCS Procedure 19"
    I10_PR20                 "ICD-10-PCS Procedure 20"
    I10_PR21                 "ICD-10-PCS Procedure 21"
    I10_PR22                 "ICD-10-PCS Procedure 22"
    I10_PR23                 "ICD-10-PCS Procedure 23"
    I10_PR24                 "ICD-10-PCS Procedure 24"
    I10_PR25                 "ICD-10-PCS Procedure 25"
    KEY_NIS                  "NIS record number"
    LOS                      "Length of stay (cleaned)"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    NIS_STRATUM              "NIS hospital stratum"
    PAY1                     "Primary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    PRDAY1                   "Number of days from admission to I10_PR1"
    PRDAY2                   "Number of days from admission to I10_PR2"
    PRDAY3                   "Number of days from admission to I10_PR3"
    PRDAY4                   "Number of days from admission to I10_PR4"
    PRDAY5                   "Number of days from admission to I10_PR5"
    PRDAY6                   "Number of days from admission to I10_PR6"
    PRDAY7                   "Number of days from admission to I10_PR7"
    PRDAY8                   "Number of days from admission to I10_PR8"
    PRDAY9                   "Number of days from admission to I10_PR9"
    PRDAY10                  "Number of days from admission to I10_PR10"
    PRDAY11                  "Number of days from admission to I10_PR11"
    PRDAY12                  "Number of days from admission to I10_PR12"
    PRDAY13                  "Number of days from admission to I10_PR13"
    PRDAY14                  "Number of days from admission to I10_PR14"
    PRDAY15                  "Number of days from admission to I10_PR15"
    PRDAY16                  "Number of days from admission to I10_PR16"
    PRDAY17                  "Number of days from admission to I10_PR17"
    PRDAY18                  "Number of days from admission to I10_PR18"
    PRDAY19                  "Number of days from admission to I10_PR19"
    PRDAY20                  "Number of days from admission to I10_PR20"
    PRDAY21                  "Number of days from admission to I10_PR21"
    PRDAY22                  "Number of days from admission to I10_PR22"
    PRDAY23                  "Number of days from admission to I10_PR23"
    PRDAY24                  "Number of days from admission to I10_PR24"
    PRDAY25                  "Number of days from admission to I10_PR25"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TRAN_IN                  "Transfer in indicator"
    TRAN_OUT                 "Transfer out indicator"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGE_NEONATE              (-9 -8 -6 -5=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSP_DIVISION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE I10_NDX                  (-9 -8 -6 -5=SYSMIS).
RECODE I10_NPR                  (-9 -8 -6 -5=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY16                  (-99 -88 -66=SYSMIS).
RECODE PRDAY17                  (-99 -88 -66=SYSMIS).
RECODE PRDAY18                  (-99 -88 -66=SYSMIS).
RECODE PRDAY19                  (-99 -88 -66=SYSMIS).
RECODE PRDAY20                  (-99 -88 -66=SYSMIS).
RECODE PRDAY21                  (-99 -88 -66=SYSMIS).
RECODE PRDAY22                  (-99 -88 -66=SYSMIS).
RECODE PRDAY23                  (-99 -88 -66=SYSMIS).
RECODE PRDAY24                  (-99 -88 -66=SYSMIS).
RECODE PRDAY25                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE TRAN_OUT                 (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2018_Core.SAV' / COMPRESSED.
