/*****************************************************************************
* SPSSload_NIS_2015_Core.SPS
* This program will load the NIS_2015_Core ASCII File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2015_Core.ASC' FIXED / 
    AGE                        1-  3
    AGE_NEONATE                4-  5
    AMONTH                     6-  7
    AWEEKEND                   8-  9
    DIED                      10- 11
    DISCWT                    12- 22
    DISPUNIFORM               23- 24
    DQTR                      25- 26
    ELECTIVE                  27- 28
    FEMALE                    29- 30
    HCUP_ED                   31- 33
    HOSP_DIVISION             34- 35
    HOSP_NIS                  36- 40
    KEY_NIS                   41- 50
    LOS                       51- 55
    NIS_STRATUM               56- 59
    PAY1                      60- 61
    PL_NCHS                   62- 64
    RACE                      65- 66
    TOTCHG                    67- 76
    TRAN_IN                   77- 78
    TRAN_OUT                  79- 80
    YEAR                      81- 84
    ZIPINC_QRTL               85- 86.

***  Specify write formats  ***.
FORMATS
    AGE                      (F3.0) /
    AGE_NEONATE              (F2.0) /
    AMONTH                   (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    ELECTIVE                 (F2.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSP_DIVISION            (F2.0) /
    HOSP_NIS                 (F5.0) /
    KEY_NIS                  (F10.0) /
    LOS                      (F5.0) /
    NIS_STRATUM              (F4.0) /
    PAY1                     (F2.0) /
    PL_NCHS                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TRAN_IN                  (F2.0) /
    TRAN_OUT                 (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "NIS discharge weight"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    ELECTIVE                 "Elective versus non-elective admission"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSP_DIVISION            "Census Division of hospital"
    HOSP_NIS                 "NIS hospital number"
    KEY_NIS                  "NIS record number"
    LOS                      "Length of stay (cleaned)"
    NIS_STRATUM              "NIS hospital stratum"
    PAY1                     "Primary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TRAN_IN                  "Transfer in indicator"
    TRAN_OUT                 "Transfer out indicator"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGE_NEONATE              (-9 -8 -6 -5=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSP_DIVISION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE TRAN_OUT                 (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2015_Core.SAV' / COMPRESSED.
