/*****************************************************************************
* SPSSload_NIS_2013_Severity.SPS
* This program will load the 2013 NIS ASCII Severity File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2013_Severity.ASC' FIXED / 
    HOSP_NIS                   1-  5
    KEY_NIS                    6- 15
    APRDRG                    16- 19
    APRDRG_Risk_Mortality     20- 21
    APRDRG_Severity           22- 23
    CM_AIDS                   24- 25
    CM_ALCOHOL                26- 27
    CM_ANEMDEF                28- 29
    CM_ARTH                   30- 31
    CM_BLDLOSS                32- 33
    CM_CHF                    34- 35
    CM_CHRNLUNG               36- 37
    CM_COAG                   38- 39
    CM_DEPRESS                40- 41
    CM_DM                     42- 43
    CM_DMCX                   44- 45
    CM_DRUG                   46- 47
    CM_HTN_C                  48- 49
    CM_HYPOTHY                50- 51
    CM_LIVER                  52- 53
    CM_LYMPH                  54- 55
    CM_LYTES                  56- 57
    CM_METS                   58- 59
    CM_NEURO                  60- 61
    CM_OBESE                  62- 63
    CM_PARA                   64- 65
    CM_PERIVASC               66- 67
    CM_PSYCH                  68- 69
    CM_PULMCIRC               70- 71
    CM_RENLFAIL               72- 73
    CM_TUMOR                  74- 75
    CM_ULCER                  76- 77
    CM_VALVE                  78- 79
    CM_WGHTLOSS               80- 81.

***  Specify write formats  ***.
FORMATS
    HOSP_NIS                 (F5.0) /
    KEY_NIS                  (F10.0) /
    APRDRG                   (F4.0) /
    APRDRG_Risk_Mortality    (F2.0) /
    APRDRG_Severity          (F2.0) /
    CM_AIDS                  (F2.0) /
    CM_ALCOHOL               (F2.0) /
    CM_ANEMDEF               (F2.0) /
    CM_ARTH                  (F2.0) /
    CM_BLDLOSS               (F2.0) /
    CM_CHF                   (F2.0) /
    CM_CHRNLUNG              (F2.0) /
    CM_COAG                  (F2.0) /
    CM_DEPRESS               (F2.0) /
    CM_DM                    (F2.0) /
    CM_DMCX                  (F2.0) /
    CM_DRUG                  (F2.0) /
    CM_HTN_C                 (F2.0) /
    CM_HYPOTHY               (F2.0) /
    CM_LIVER                 (F2.0) /
    CM_LYMPH                 (F2.0) /
    CM_LYTES                 (F2.0) /
    CM_METS                  (F2.0) /
    CM_NEURO                 (F2.0) /
    CM_OBESE                 (F2.0) /
    CM_PARA                  (F2.0) /
    CM_PERIVASC              (F2.0) /
    CM_PSYCH                 (F2.0) /
    CM_PULMCIRC              (F2.0) /
    CM_RENLFAIL              (F2.0) /
    CM_TUMOR                 (F2.0) /
    CM_ULCER                 (F2.0) /
    CM_VALVE                 (F2.0) /
    CM_WGHTLOSS              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_NIS                 "NIS hospital number"
    KEY_NIS                  "NIS record number"
    APRDRG                   "All Patient Refined DRG"
    APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
    APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass"
    CM_AIDS                  "AHRQ comorbidity measure: Acquired immune deficiency syndrome"
    CM_ALCOHOL               "AHRQ comorbidity measure: Alcohol abuse"
    CM_ANEMDEF               "AHRQ comorbidity measure: Deficiency anemias"
    CM_ARTH                  "AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases"
    CM_BLDLOSS               "AHRQ comorbidity measure: Chronic blood loss anemia"
    CM_CHF                   "AHRQ comorbidity measure: Congestive heart failure"
    CM_CHRNLUNG              "AHRQ comorbidity measure: Chronic pulmonary disease"
    CM_COAG                  "AHRQ comorbidity measure: Coagulopathy"
    CM_DEPRESS               "AHRQ comorbidity measure: Depression"
    CM_DM                    "AHRQ comorbidity measure: Diabetes, uncomplicated"
    CM_DMCX                  "AHRQ comorbidity measure: Diabetes with chronic complications"
    CM_DRUG                  "AHRQ comorbidity measure: Drug abuse"
    CM_HTN_C                 "AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)"
    CM_HYPOTHY               "AHRQ comorbidity measure: Hypothyroidism"
    CM_LIVER                 "AHRQ comorbidity measure: Liver disease"
    CM_LYMPH                 "AHRQ comorbidity measure: Lymphoma"
    CM_LYTES                 "AHRQ comorbidity measure: Fluid and electrolyte disorders"
    CM_METS                  "AHRQ comorbidity measure: Metastatic cancer"
    CM_NEURO                 "AHRQ comorbidity measure: Other neurological disorders"
    CM_OBESE                 "AHRQ comorbidity measure: Obesity"
    CM_PARA                  "AHRQ comorbidity measure: Paralysis"
    CM_PERIVASC              "AHRQ comorbidity measure: Peripheral vascular disorders"
    CM_PSYCH                 "AHRQ comorbidity measure: Psychoses"
    CM_PULMCIRC              "AHRQ comorbidity measure: Pulmonary circulation disorders"
    CM_RENLFAIL              "AHRQ comorbidity measure: Renal failure"
    CM_TUMOR                 "AHRQ comorbidity measure: Solid tumor without metastasis"
    CM_ULCER                 "AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding"
    CM_VALVE                 "AHRQ comorbidity measure: Valvular disease"
    CM_WGHTLOSS              "AHRQ comorbidity measure: Weight loss" .

*** Convert special values to system missing values ***.
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE APRDRG                   (-999 -888 -666=SYSMIS).
RECODE APRDRG_Risk_Mortality    (-9 -8 -6 -5=SYSMIS).
RECODE APRDRG_Severity          (-9 -8 -6 -5=SYSMIS).
RECODE CM_AIDS                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_ALCOHOL               (-9 -8 -6 -5=SYSMIS).
RECODE CM_ANEMDEF               (-9 -8 -6 -5=SYSMIS).
RECODE CM_ARTH                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_BLDLOSS               (-9 -8 -6 -5=SYSMIS).
RECODE CM_CHF                   (-9 -8 -6 -5=SYSMIS).
RECODE CM_CHRNLUNG              (-9 -8 -6 -5=SYSMIS).
RECODE CM_COAG                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_DEPRESS               (-9 -8 -6 -5=SYSMIS).
RECODE CM_DM                    (-9 -8 -6 -5=SYSMIS).
RECODE CM_DMCX                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_DRUG                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_HTN_C                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_HYPOTHY               (-9 -8 -6 -5=SYSMIS).
RECODE CM_LIVER                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_LYMPH                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_LYTES                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_METS                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_NEURO                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_OBESE                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_PARA                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_PERIVASC              (-9 -8 -6 -5=SYSMIS).
RECODE CM_PSYCH                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_PULMCIRC              (-9 -8 -6 -5=SYSMIS).
RECODE CM_RENLFAIL              (-9 -8 -6 -5=SYSMIS).
RECODE CM_TUMOR                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_ULCER                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_VALVE                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_WGHTLOSS              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2013_Severity.SAV' / COMPRESSED.
