/*****************************************************************************
* SPSSload_NIS_2010_Hospital.SPS
* This program will load the 2010 NIS ASCII Hospital File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2010_Hospital.ASC' FIXED / 
    HOSPST                     1-  2 (A)
    AHAID                      3-  9 (A)
    DISCWT                    10- 20
    HFIPSSTCO                 21- 25
    H_CONTRL                  26- 27
    HOSPADDR                  28- 87 (A)
    HOSPCITY                  88-107 (A)
    HOSPID                   108-112
    HOSPNAME                 113-202 (A)
    HOSPSTCO                 203-207
    HOSPWT                   208-218
    HOSPZIP                  219-223 (A)
    HOSP_BEDSIZE             224-225
    HOSP_CONTROL             226-227
    HOSP_LOCATION            228-229
    HOSP_LOCTEACH            230-231
    HOSP_REGION              232-233
    HOSP_TEACH               234-235
    IDNUMBER                 236-241 (A)
    NIS_STRATUM              242-245
    N_DISC_U                 246-253
    N_HOSP_U                 254-257
    S_DISC_U                 258-263
    S_HOSP_U                 264-267
    TOTAL_DISC               268-273
    YEAR                     274-277
    HOSP_RNPCT               278-280
    HOSP_RNFTEAPD            281-284
    HOSP_LPNFTEAPD           285-288
    HOSP_NAFTEAPD            289-292
    HOSP_OPSURGPCT           293-295
    HOSP_MHSMEMBER           296-297
    HOSP_MHSCLUSTER          298-299.

***  Specify write formats  ***.
FORMATS
    DISCWT                   (F11.7) /
    HFIPSSTCO                (F5.0) /
    H_CONTRL                 (F2.0) /
    HOSPID                   (F5.0) /
    HOSPSTCO                 (F5.0) /
    HOSPWT                   (F11.7) /
    HOSP_BEDSIZE             (F2.0) /
    HOSP_CONTROL             (F2.0) /
    HOSP_LOCATION            (F2.0) /
    HOSP_LOCTEACH            (F2.0) /
    HOSP_REGION              (F2.0) /
    HOSP_TEACH               (F2.0) /
    NIS_STRATUM              (F4.0) /
    N_DISC_U                 (F8.0) /
    N_HOSP_U                 (F4.0) /
    S_DISC_U                 (F6.0) /
    S_HOSP_U                 (F4.0) /
    TOTAL_DISC               (F6.0) /
    YEAR                     (F4.0) /
    HOSP_RNPCT               (F3.0) /
    HOSP_RNFTEAPD            (F4.1) /
    HOSP_LPNFTEAPD           (F4.1) /
    HOSP_NAFTEAPD            (F4.1) /
    HOSP_OPSURGPCT           (F3.0) /
    HOSP_MHSMEMBER           (F2.0) /
    HOSP_MHSCLUSTER          (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSPST                   "Hospital state postal code"
    AHAID                    "AHA hospital identifier with the leading 6"
    DISCWT                   "Weight to discharges in AHA universe"
    HFIPSSTCO                "Hospital FIPS state/county code"
    H_CONTRL                 "Control/ownership of hospital"
    HOSPADDR                 "Hospital address from AHA Survey (Z011)"
    HOSPCITY                 "Hospital city from AHA Survey (Z012)"
    HOSPID                   "HCUP hospital identification number"
    HOSPNAME                 "Hospital name from AHA Survey (Z000)"
    HOSPSTCO                 "Hospital modified FIPS state/county code"
    HOSPWT                   "Weight to hospitals in AHA universe"
    HOSPZIP                  "Hospital ZIP Code from AHA Survey (Z014)"
    HOSP_BEDSIZE             "Bed size of hospital (STRATA)"
    HOSP_CONTROL             "Control/ownership of hospital (STRATA)"
    HOSP_LOCATION            "Location (urban/rural) of hospital"
    HOSP_LOCTEACH            "Location/teaching status of hospital (STRATA)"
    HOSP_REGION              "Region of hospital (STRATA)"
    HOSP_TEACH               "Teaching status of hospital"
    IDNUMBER                 "AHA hospital identifier without the leading 6"
    NIS_STRATUM              "Stratum used to sample hospital"
    N_DISC_U                 "Number of AHA universe discharges in NIS_STRATUM"
    N_HOSP_U                 "Number of AHA universe hospitals in NIS_STRATUM"
    S_DISC_U                 "Number of sample discharges in NIS_STRATUM"
    S_HOSP_U                 "Number of sample hospitals in NIS_STRATUM"
    TOTAL_DISC               "Total number of discharges from this hospital in the NIS"
    YEAR                     "Calendar Year"
    HOSP_RNPCT               "Percentage of RN among licensed nurses-H"
    HOSP_RNFTEAPD            "RN FTEs per 1000 adjusted patient days-H"
    HOSP_LPNFTEAPD           "LPN FTEs per 1000 adjusted patient days-H"
    HOSP_NAFTEAPD            "Nurse aides per 1000 adjusted patient days-H"
    HOSP_OPSURGPCT           "Percentage of all surgeries performed in outpatient setting-H"
    HOSP_MHSMEMBER           "Hospital is part of multiple hospital system-H"
    HOSP_MHSCLUSTER          "AHA multiple hospital system cluster code-H" .

*** Convert special values to system missing values ***.
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HFIPSSTCO                (-9999 -8888 -6666=SYSMIS).
RECODE H_CONTRL                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSPSTCO                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSPWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSP_BEDSIZE             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_CONTROL             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCATION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCTEACH            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_TEACH               (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_DISC_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE TOTAL_DISC               (-99999 -88888 -66666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE HOSP_RNPCT               (-99 -88 -66=SYSMIS).
RECODE HOSP_RNFTEAPD            (-9.9 -8.8 -6.6=SYSMIS).
RECODE HOSP_LPNFTEAPD           (-9.9 -8.8 -6.6=SYSMIS).
RECODE HOSP_NAFTEAPD            (-9.9 -8.8 -6.6=SYSMIS).
RECODE HOSP_OPSURGPCT           (-99 -88 -66=SYSMIS).
RECODE HOSP_MHSMEMBER           (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_MHSCLUSTER          (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2010_Hospital.SAV' / COMPRESSED.
